/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/blind_test_run_result.ts.cpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] implementation of @ref ::diagnostics::unittest::testing::blind_test_run_result
 *
 * @test none
 */


#include <diagnostics/util/blind_test_run_result.ts.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

::std::string blind_test_run_result(::std::string const & in)
{
    ::std::string result;
	
    char const * const search_string("Test_Run_Result ");
    int const search_string_len(::std::strlen(search_string));

    ::std::string::size_type last_pos(0);
    ::std::string::size_type pos(in.find(search_string));
    for(;pos!= ::std::string::npos; pos=in.find(search_string,last_pos)){
	pos+=search_string_len;
	result.append("XX");
	result.append(in,last_pos,pos-last_pos);  // copying everything up to "Test_Run_Result "
	last_pos=in.find("]:",pos)+2;             // jumping post "[host pid/tid]:"
	pos=in.find(" in ",last_pos)+4;            // spawning the copy area to the " in "
	result.append("XX");
	result.append(in,last_pos,pos-last_pos);
	last_pos=in.find("secs",pos)+4;           // jumping post the "xxx secs"
    }
    result.append("XX");
    result.append(in,last_pos,in.size()-last_pos);
	
    return result;
}


TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
// vim:ts=4:sw=4
