# Copyright (C) 2014 Red Hat, Inc.
#
# This copyrighted material is made available to anyone wishing to use,
# modify, copy, or redistribute it subject to the terms and conditions of
# the GNU General Public License v.2, or (at your option) any later version.
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY expressed or implied, including the implied warranties of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.  You should have received a copy of the
# GNU General Public License along with this program; if not, write to the
# Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.  Any Red Hat trademarks that are incorporated in the
# source code or documentation are not subject to the GNU General Public
# License and may only be used or replicated with the express permission of
# Red Hat, Inc.
#


from __future__ import absolute_import
from __future__ import print_function
from __future__ import unicode_literals

import needs_restarting
import tests.support

DEL_FILE = '3dcf000000-3dcf032000 r-xp 00000000 08:02 140759                ' \
           '         /usr/lib64/libXfont.so.1.4.1;5408628d (deleted)'
MM_FILE = '7fc4e1168000-7fc4e1169000 rw-s 1096dd000 00:05 7749' \
          '                      /dev/dri/card0'
SO_FILE = '30efe06000-30efe07000 r--p 00006000 08:02 139936' \
          '                         /usr/lib64/libSM.so.6.0.1'


class NeedsRestartingTest(tests.support.TestCase):
    def test_smap2opened_file(self):
        func = needs_restarting.smap2opened_file
        self.assertIsNone(func(1, 'Shared_Dirty:          0 kB'))
        self.assertIsNone(func(1, MM_FILE))

        ofile = func(5, SO_FILE)
        self.assertFalse(ofile.deleted)
        self.assertEqual(ofile.name, '/usr/lib64/libSM.so.6.0.1')
        self.assertEqual(ofile.pid, 5)

        ofile = func(5, DEL_FILE)
        self.assertTrue(ofile.deleted)
        self.assertEqual(ofile.name, '/usr/lib64/libXfont.so.1.4.1;5408628d')


class OpenedFileTest(tests.support.TestCase):
    def test_presumed_name(self):
        ofile = needs_restarting.OpenedFile(
            100, '/usr/lib64/libgtk-3.so.0.1000.9;54085c6e', True)
        self.assertEqual(ofile.presumed_name, '/usr/lib64/libgtk-3.so.0.1000.9')
