/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.emboss.jemboss.editor.Consensus;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.gui.form.LabelTextBox;
import org.emboss.jemboss.gui.form.TextFieldFloat;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class ConsensusOptions
extends JFrame {
    private TextFieldFloat pluralFloat;
    private TextFieldInt idInt;
    private TextFieldFloat caseFloat;
    private GraphicSequenceCollection gsc;
    private Matrix mat;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);

    public ConsensusOptions(JScrollPane jspSequence) {
        super("Consensus Options");
        Box bdown = Box.createVerticalBox();
        bdown.add(Box.createVerticalStrut(4));
        Box bacross = Box.createHorizontalBox();
        this.pluralFloat = new TextFieldFloat();
        Dimension d = new Dimension(65, 30);
        this.pluralFloat.setPreferredSize(d);
        this.pluralFloat.setMaximumSize(d);
        bacross.add(this.pluralFloat);
        LabelTextBox pluralLabel = new LabelTextBox("Minimum positive match score value for there to be a consensus", "Set a cut-off for the number of\npositive matches below which\nthere is no consensus.");
        bacross.add(pluralLabel);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        this.idInt = new TextFieldInt();
        this.idInt.setText("0");
        this.idInt.setPreferredSize(d);
        this.idInt.setMaximumSize(d);
        bacross.add(this.idInt);
        LabelTextBox caselLabel = new LabelTextBox("Minimum number of identities for there to be a consensus", "The required number of identities\nat a site for it to give a consensus\nat that position. Therefore, if this\nis set to the number of sequences in\nthe alignment only columns of identities\ncontribute to the consensus.");
        bacross.add(caselLabel);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        this.caseFloat = new TextFieldFloat();
        this.caseFloat.setPreferredSize(d);
        this.caseFloat.setMaximumSize(d);
        bacross.add(this.caseFloat);
        LabelTextBox idLabel = new LabelTextBox("Threshold positive match score for setting the consensus to upper-case", "Sets the threshold for the positive\nmatches above which the consensus is\nin upper-case and below which the\nconsensus is in lower-case.");
        bacross.add(idLabel);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        JButton calculate = new JButton("Calculate Consensus");
        calculate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConsensusOptions.this.setCursor(ConsensusOptions.this.cbusy);
                ConsensusOptions.this.gsc.deleteSequence("Consensus");
                Consensus conseq = new Consensus(ConsensusOptions.this.mat, ConsensusOptions.this.gsc.getSequenceCollection(), ConsensusOptions.this.getPlurality(), ConsensusOptions.this.getCase(), ConsensusOptions.this.getIdentity());
                int fontSize = ConsensusOptions.this.gsc.getFontSize();
                ConsensusOptions.this.gsc.addSequence(conseq.getConsensusSequence(), true, 5, fontSize);
                Dimension dpane = ConsensusOptions.this.gsc.getPanelSize();
                ConsensusOptions.this.gsc.setPreferredSize(dpane);
                ConsensusOptions.this.gsc.setNamePanelWidth(ConsensusOptions.this.gsc.getNameWidth());
                ConsensusOptions.this.setCursor(ConsensusOptions.this.cdone);
            }
        });
        bacross.add(calculate);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(new JSeparator());
        JMenuItem fileMenuExit = new JMenuItem("Close");
        fileMenuExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConsensusOptions.this.setVisible(false);
            }
        });
        fileMenu.add(fileMenuExit);
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        this.getContentPane().add(bdown);
        this.pack();
    }

    public float getPlurality() {
        return Float.parseFloat(this.pluralFloat.getText());
    }

    public float getCase() {
        return Float.parseFloat(this.caseFloat.getText());
    }

    public int getIdentity() {
        return Integer.parseInt(this.idInt.getText());
    }

    protected void setCase(float caseValue) {
        caseValue = Math.round(caseValue * 100.0f);
        this.caseFloat.setText(Float.toString(caseValue / 100.0f));
    }

    protected void setGraphicSequenceCollection(GraphicSequenceCollection gsc) {
        this.gsc = gsc;
    }

    protected void setMatrix(Matrix mat) {
        this.mat = mat;
    }

    protected void setPlurality(float plurality) {
        plurality = Math.round(plurality * 100.0f);
        this.pluralFloat.setText(Float.toString(plurality / 100.0f));
    }
}

