/**
 * Furnace Tracker - multi-system chiptune tracker
 * Copyright (C) 2021-2025 tildearrow and contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

// guiConst: constants used in the GUI like arrays, strings and other stuff
#include "gui.h"
#include "guiConst.h"
#include "../engine/song.h"
#include "IconsFontAwesome4.h"
#include "furIcons.h"

const int opOrder[4]={
  0, 2, 1, 3
};

const char* noteNames[180]={
  "c_5", "c+5", "d_5", "d+5", "e_5", "f_5", "f+5", "g_5", "g+5", "a_5", "a+5", "b_5",
  "c_4", "c+4", "d_4", "d+4", "e_4", "f_4", "f+4", "g_4", "g+4", "a_4", "a+4", "b_4",
  "c_3", "c+3", "d_3", "d+3", "e_3", "f_3", "f+3", "g_3", "g+3", "a_3", "a+3", "b_3",
  "c_2", "c+2", "d_2", "d+2", "e_2", "f_2", "f+2", "g_2", "g+2", "a_2", "a+2", "b_2",
  "c_1", "c+1", "d_1", "d+1", "e_1", "f_1", "f+1", "g_1", "g+1", "a_1", "a+1", "b_1",
  "C-0", "C#0", "D-0", "D#0", "E-0", "F-0", "F#0", "G-0", "G#0", "A-0", "A#0", "B-0",
  "C-1", "C#1", "D-1", "D#1", "E-1", "F-1", "F#1", "G-1", "G#1", "A-1", "A#1", "B-1",
  "C-2", "C#2", "D-2", "D#2", "E-2", "F-2", "F#2", "G-2", "G#2", "A-2", "A#2", "B-2",
  "C-3", "C#3", "D-3", "D#3", "E-3", "F-3", "F#3", "G-3", "G#3", "A-3", "A#3", "B-3",
  "C-4", "C#4", "D-4", "D#4", "E-4", "F-4", "F#4", "G-4", "G#4", "A-4", "A#4", "B-4",
  "C-5", "C#5", "D-5", "D#5", "E-5", "F-5", "F#5", "G-5", "G#5", "A-5", "A#5", "B-5",
  "C-6", "C#6", "D-6", "D#6", "E-6", "F-6", "F#6", "G-6", "G#6", "A-6", "A#6", "B-6",
  "C-7", "C#7", "D-7", "D#7", "E-7", "F-7", "F#7", "G-7", "G#7", "A-7", "A#7", "B-7",
  "C-8", "C#8", "D-8", "D#8", "E-8", "F-8", "F#8", "G-8", "G#8", "A-8", "A#8", "B-8",
  "C-9", "C#9", "D-9", "D#9", "E-9", "F-9", "F#9", "G-9", "G#9", "A-9", "A#9", "B-9"
};

const char* noteNamesG[180]={
  "c_5", "c+5", "d_5", "d+5", "e_5", "f_5", "f+5", "g_5", "g+5", "a_5", "a+5", "h_5",
  "c_4", "c+4", "d_4", "d+4", "e_4", "f_4", "f+4", "g_4", "g+4", "a_4", "a+4", "h_4",
  "c_3", "c+3", "d_3", "d+3", "e_3", "f_3", "f+3", "g_3", "g+3", "a_3", "a+3", "h_3",
  "c_2", "c+2", "d_2", "d+2", "e_2", "f_2", "f+2", "g_2", "g+2", "a_2", "a+2", "h_2",
  "c_1", "c+1", "d_1", "d+1", "e_1", "f_1", "f+1", "g_1", "g+1", "a_1", "a+1", "h_1",
  "C-0", "C#0", "D-0", "D#0", "E-0", "F-0", "F#0", "G-0", "G#0", "A-0", "A#0", "H-0",
  "C-1", "C#1", "D-1", "D#1", "E-1", "F-1", "F#1", "G-1", "G#1", "A-1", "A#1", "H-1",
  "C-2", "C#2", "D-2", "D#2", "E-2", "F-2", "F#2", "G-2", "G#2", "A-2", "A#2", "H-2",
  "C-3", "C#3", "D-3", "D#3", "E-3", "F-3", "F#3", "G-3", "G#3", "A-3", "A#3", "H-3",
  "C-4", "C#4", "D-4", "D#4", "E-4", "F-4", "F#4", "G-4", "G#4", "A-4", "A#4", "H-4",
  "C-5", "C#5", "D-5", "D#5", "E-5", "F-5", "F#5", "G-5", "G#5", "A-5", "A#5", "H-5",
  "C-6", "C#6", "D-6", "D#6", "E-6", "F-6", "F#6", "G-6", "G#6", "A-6", "A#6", "H-6",
  "C-7", "C#7", "D-7", "D#7", "E-7", "F-7", "F#7", "G-7", "G#7", "A-7", "A#7", "H-7",
  "C-8", "C#8", "D-8", "D#8", "E-8", "F-8", "F#8", "G-8", "G#8", "A-8", "A#8", "H-8",
  "C-9", "C#9", "D-9", "D#9", "E-9", "F-9", "F#9", "G-9", "G#9", "A-9", "A#9", "H-9"
};

const char* noteNamesF[180]={
  "c_5", "dd5", "d_5", "ed5", "e_5", "f_5", "gd5", "g_5", "ad5", "a_5", "bd5", "b_5",
  "c_4", "dd4", "d_4", "ed4", "e_4", "f_4", "gd4", "g_4", "ad4", "a_4", "bd4", "b_4",
  "c_3", "dd3", "d_3", "ed3", "e_3", "f_3", "gd3", "g_3", "ad3", "a_3", "bd3", "b_3",
  "c_2", "dd2", "d_2", "ed2", "e_2", "f_2", "gd2", "g_2", "ad2", "a_2", "bd2", "b_2",
  "c_1", "dd1", "d_1", "ed1", "e_1", "f_1", "gd1", "g_1", "ad1", "a_1", "bd1", "b_1",
  "C-0", "Db0", "D-0", "Eb0", "E-0", "F-0", "Gb0", "G-0", "Ab0", "A-0", "Bb0", "B-0",
  "C-1", "Db1", "D-1", "Eb1", "E-1", "F-1", "Gb1", "G-1", "Ab1", "A-1", "Bb1", "B-1",
  "C-2", "Db2", "D-2", "Eb2", "E-2", "F-2", "Gb2", "G-2", "Ab2", "A-2", "Bb2", "B-2",
  "C-3", "Db3", "D-3", "Eb3", "E-3", "F-3", "Gb3", "G-3", "Ab3", "A-3", "Bb3", "B-3",
  "C-4", "Db4", "D-4", "Eb4", "E-4", "F-4", "Gb4", "G-4", "Ab4", "A-4", "Bb4", "B-4",
  "C-5", "Db5", "D-5", "Eb5", "E-5", "F-5", "Gb5", "G-5", "Ab5", "A-5", "Bb5", "B-5",
  "C-6", "Db6", "D-6", "Eb6", "E-6", "F-6", "Gb6", "G-6", "Ab6", "A-6", "Bb6", "B-6",
  "C-7", "Db7", "D-7", "Eb7", "E-7", "F-7", "Gb7", "G-7", "Ab7", "A-7", "Bb7", "B-7",
  "C-8", "Db8", "D-8", "Eb8", "E-8", "F-8", "Gb8", "G-8", "Ab8", "A-8", "Bb8", "B-8",
  "C-9", "Db9", "D-9", "Eb9", "E-9", "F-9", "Gb9", "G-9", "Ab9", "A-9", "Bb9", "B-9"
};

const char* noteNamesGF[180]={
  "c_5", "dd5", "d_5", "ed5", "e_5", "f_5", "gd5", "g_5", "ad5", "a_5", "b_5", "h_5",
  "c_4", "dd4", "d_4", "ed4", "e_4", "f_4", "gd4", "g_4", "ad4", "a_4", "b_4", "h_4",
  "c_3", "dd3", "d_3", "ed3", "e_3", "f_3", "gd3", "g_3", "ad3", "a_3", "b_3", "h_3",
  "c_2", "dd2", "d_2", "ed2", "e_2", "f_2", "gd2", "g_2", "ad2", "a_2", "b_2", "h_2",
  "c_1", "dd1", "d_1", "ed1", "e_1", "f_1", "gd1", "g_1", "ad1", "a_1", "b_1", "h_1",
  "C-0", "Db0", "D-0", "Eb0", "E-0", "F-0", "Gb0", "G-0", "Ab0", "A-0", "B-0", "H-0",
  "C-1", "Db1", "D-1", "Eb1", "E-1", "F-1", "Gb1", "G-1", "Ab1", "A-1", "B-1", "H-1",
  "C-2", "Db2", "D-2", "Eb2", "E-2", "F-2", "Gb2", "G-2", "Ab2", "A-2", "B-2", "H-2",
  "C-3", "Db3", "D-3", "Eb3", "E-3", "F-3", "Gb3", "G-3", "Ab3", "A-3", "B-3", "H-3",
  "C-4", "Db4", "D-4", "Eb4", "E-4", "F-4", "Gb4", "G-4", "Ab4", "A-4", "B-4", "H-4",
  "C-5", "Db5", "D-5", "Eb5", "E-5", "F-5", "Gb5", "G-5", "Ab5", "A-5", "B-5", "H-5",
  "C-6", "Db6", "D-6", "Eb6", "E-6", "F-6", "Gb6", "G-6", "Ab6", "A-6", "B-6", "H-6",
  "C-7", "Db7", "D-7", "Eb7", "E-7", "F-7", "Gb7", "G-7", "Ab7", "A-7", "B-7", "H-7",
  "C-8", "Db8", "D-8", "Eb8", "E-8", "F-8", "Gb8", "G-8", "Ab8", "A-8", "B-8", "H-8",
  "C-9", "Db9", "D-9", "Eb9", "E-9", "F-9", "Gb9", "G-9", "Ab9", "A-9", "B-9", "H-9"
};

const char* pitchLabel[11]={
  "1/6", "1/5", "1/4", "1/3", "1/2", "1x", "2x", "3x", "4x", "5x", "6x"
};

const int altValues[24]={
  0, 10, 1, 11, 2, 3, 12, 4, 13, 5, 14, 6, 7, 15, 8, -1, 9, -1, -1, -1, -1, -1, -1, -1
};

const int vgmVersions[7]={
  0x150,
  0x151,
  0x160,
  0x161,
  0x170,
  0x171,
  0x172
};

// name, icon, letter icon
const char* insTypes[DIV_INS_MAX+1][3]={
  {"SN76489/Sega PSG",ICON_FA_BAR_CHART,ICON_FUR_INS_STD},
  {"FM (OPN)",ICON_FA_AREA_CHART,ICON_FUR_INS_FM},
  {"Game Boy",ICON_FA_GAMEPAD,ICON_FUR_INS_GB},
  {"C64",ICON_FA_KEYBOARD_O,ICON_FUR_INS_C64},
  {_N("Generic Sample"),ICON_FA_VOLUME_UP,ICON_FUR_INS_AMIGA},
  {"PC Engine",ICON_FA_ID_BADGE,ICON_FUR_INS_PCE},
  {"AY-3-8910/SSG",ICON_FA_BAR_CHART,ICON_FUR_INS_AY},
  {"AY8930",ICON_FA_BAR_CHART,ICON_FUR_INS_AY8930},
  {"TIA",ICON_FA_BAR_CHART,ICON_FUR_INS_TIA},
  {"SAA1099",ICON_FA_BAR_CHART,ICON_FUR_INS_SAA1099},
  {"VIC",ICON_FA_BAR_CHART,ICON_FUR_INS_VIC},
  {"PET",ICON_FA_SQUARE,ICON_FUR_INS_PET},
  {"VRC6",ICON_FA_BAR_CHART,ICON_FUR_INS_VRC6},
  {"FM (OPLL)",ICON_FA_AREA_CHART,ICON_FUR_INS_OPLL},
  {"FM (OPL)",ICON_FA_AREA_CHART,ICON_FUR_INS_OPL},
  {"FDS",ICON_FA_FLOPPY_O,ICON_FUR_INS_FDS},
  {"Virtual Boy",ICON_FA_BINOCULARS,ICON_FUR_INS_VBOY},
  {"Namco 163",ICON_FA_CALCULATOR,ICON_FUR_INS_N163},
  {"Konami SCC/Bubble System WSG",ICON_FA_CALCULATOR,ICON_FUR_INS_SCC},
  {"FM (OPZ)",ICON_FA_AREA_CHART,ICON_FUR_INS_OPZ},
  {"POKEY",ICON_FA_BAR_CHART,ICON_FUR_INS_POKEY},
  {"Beeper",ICON_FA_SQUARE,ICON_FUR_INS_BEEPER},
  {"WonderSwan",ICON_FA_GAMEPAD,ICON_FUR_INS_SWAN},
  {"Atari Lynx",ICON_FA_BAR_CHART,ICON_FUR_INS_MIKEY},
  {"VERA",ICON_FA_KEYBOARD_O,ICON_FUR_INS_VERA},
  {"X1-010",ICON_FA_BAR_CHART,ICON_FUR_INS_X1_010},
  {_("VRC6 (saw)"),ICON_FA_BAR_CHART,ICON_FUR_INS_VRC6_SAW},
  {"ES5506",ICON_FA_VOLUME_UP,ICON_FUR_INS_ES5506},
  {"MultiPCM/OPL4 PCM",ICON_FA_VOLUME_UP,ICON_FUR_INS_MULTIPCM},
  {"SNES",ICON_FA_VOLUME_UP,ICON_FUR_INS_SNES},
  {"Sound Unit",ICON_FA_MICROCHIP,ICON_FUR_INS_SU},
  {"Namco WSG",ICON_FA_PIE_CHART,ICON_FUR_INS_NAMCO},
  {_N("OPL (drums)"),ICON_FA_COFFEE,ICON_FUR_INS_OPL_DRUMS},
  {"FM (OPM)",ICON_FA_AREA_CHART,ICON_FUR_INS_OPM},
  {"NES",ICON_FA_GAMEPAD,ICON_FUR_INS_NES},
  {"MSM6258",ICON_FA_VOLUME_UP,ICON_FUR_INS_MSM6258},
  {"MSM6295",ICON_FA_VOLUME_UP,ICON_FUR_INS_MSM6295},
  {"ADPCM-A",ICON_FA_VOLUME_UP,ICON_FUR_INS_ADPCMA},
  {"ADPCM-B",ICON_FA_VOLUME_UP,ICON_FUR_INS_ADPCMB},
  {"SegaPCM",ICON_FA_VOLUME_UP,ICON_FUR_INS_SEGAPCM},
  {"QSound",ICON_FA_VOLUME_UP,ICON_FUR_INS_QSOUND},
  {"YMZ280B",ICON_FA_VOLUME_UP,ICON_FUR_INS_YMZ280B},
  {"RF5C68",ICON_FA_VOLUME_UP,ICON_FUR_INS_RF5C68},
  {"MSM5232",ICON_FA_BAR_CHART,ICON_FUR_INS_MSM5232},
  {"T6W28",ICON_FA_BAR_CHART,ICON_FUR_INS_T6W28},
  {"K007232",ICON_FA_BAR_CHART,ICON_FUR_INS_K007232},
  {"GA20",ICON_FA_BAR_CHART,ICON_FUR_INS_GA20},
  {"Pokémon Mini/QuadTone",ICON_FA_BAR_CHART,ICON_FUR_INS_POKEMINI},
  {"SM8521",ICON_FA_GAMEPAD,ICON_FUR_INS_SM8521},
  {"PV-1000",ICON_FA_GAMEPAD,ICON_FUR_INS_PV1000},
  {"K053260",ICON_FA_BAR_CHART,ICON_FUR_INS_K053260},
  {"SCSP",ICON_FA_QUESTION,ICON_FUR_INS_SCSP},
  {"TED",ICON_FA_BAR_CHART,ICON_FUR_INS_TED},
  {"C140",ICON_FA_VOLUME_UP,ICON_FUR_INS_C140},
  {"C219",ICON_FA_VOLUME_UP,ICON_FUR_INS_C219},
  {"FM (ESFM)",ICON_FA_AREA_CHART,ICON_FUR_INS_ESFM},
  {_N("PowerNoise (noise)"),ICON_FUR_NOISE,ICON_FUR_INS_POWERNOISE},
  {_N("PowerNoise (slope)"),ICON_FUR_SAW,ICON_FUR_INS_POWERNOISE_SAW},
  {"Dave",ICON_FA_BAR_CHART,ICON_FUR_INS_DAVE},
  {"Nintendo DS",ICON_FA_BAR_CHART,ICON_FUR_INS_NDS},
  {"GBA DMA",ICON_FA_GAMEPAD,ICON_FUR_INS_GBA_DMA},
  {"GBA MinMod",ICON_FA_VOLUME_UP,ICON_FUR_INS_GBA_MINMOD},
  {"Bifurcator",ICON_FA_LINE_CHART,ICON_FUR_INS_BIFURCATOR},
  {"SID2",ICON_FA_KEYBOARD_O,ICON_FUR_INS_SID2},
  {"Watara Supervision",ICON_FA_GAMEPAD,ICON_FUR_INS_SUPERVISION},
  {"NEC μPD1771C",ICON_FA_BAR_CHART,ICON_FUR_INS_UPD1771C},
  {"SID3",ICON_FA_KEYBOARD_O,ICON_FUR_INS_SID3},
  {NULL,ICON_FA_QUESTION,ICON_FA_QUESTION}
};

const char* sampleLoopModes[DIV_SAMPLE_LOOP_MAX]={
  _N("Forward"),
  _N("Backward"),
  _N("Ping pong")
};

const char* sampleDepths[DIV_SAMPLE_DEPTH_MAX]={
  "1-bit PCM",
  "1-bit DPCM",
  NULL,
  "YMZ/YMU ADPCM",
  "QSound ADPCM",
  "ADPCM-A",
  "ADPCM-B",
  "K05 ADPCM",
  "8-bit PCM",
  "BRR",
  "VOX",
  "8-bit µ-law PCM",
  "C219 PCM",
  "IMA ADPCM",
  "12-bit PCM",
  NULL,
  "16-bit PCM"
};

const char* resampleStrats[]={
  _N("none"),
  _N("linear"),
  _N("cubic spline"),
  _N("blep synthesis"),
  _N("sinc"),
  _N("best possible")
};

const char* fxColorsNames[]={
  _N("Invalid"),
  _N("Pitch"),
  _N("Volume"),
  _N("Panning"),
  _N("Song"),
  _N("Time"),
  _N("Speed"),
  _N("System (Primary)"),
  _N("System (Secondary)"),
  _N("Miscellaneous")
};

const char* chanNames[CHANNEL_TYPE_MAX+1]={
  _N("FM"),
  _N("Pulse"),
  _N("Noise"),
  _N("Wavetable"),
  _N("Sample"),
  // the "freaks":
  _N("Square"),
  _N("Triangle"), // NES
  _N("Saw"), // VRC6
  _N("Ext. Operator"), 
  _N("Drums"),
  _N("Slope"), // PowerNoise
  _N("Wave"), // not wavetable (VERA, 5E01)
  _N("PSG"),

  _N("Channel"), // if neither
  _N("Channels") // in case this makes l10n easier
};

unsigned char chanNamesHierarchy[CHANNEL_TYPE_MAX+1]={
  CHANNEL_TYPE_FM,
  CHANNEL_TYPE_OPERATOR,
  CHANNEL_TYPE_SQUARE,
  CHANNEL_TYPE_PULSE,
  CHANNEL_TYPE_PSG,
  CHANNEL_TYPE_WAVETABLE,
  CHANNEL_TYPE_TRIANGLE,
  CHANNEL_TYPE_SAW,
  CHANNEL_TYPE_NOISE,
  CHANNEL_TYPE_SLOPE,
  CHANNEL_TYPE_WAVE,
  CHANNEL_TYPE_DRUMS,
  CHANNEL_TYPE_SAMPLE,
  CHANNEL_TYPE_OTHER,
  CHANNEL_TYPE_MAX
};

const FurnaceGUIColors fxColors[256]={
  GUI_COLOR_PATTERN_EFFECT_MISC, // 00
  GUI_COLOR_PATTERN_EFFECT_PITCH, // 01
  GUI_COLOR_PATTERN_EFFECT_PITCH, // 02
  GUI_COLOR_PATTERN_EFFECT_PITCH, // 03
  GUI_COLOR_PATTERN_EFFECT_PITCH, // 04
  GUI_COLOR_PATTERN_EFFECT_VOLUME, // 05
  GUI_COLOR_PATTERN_EFFECT_VOLUME, // 06
  GUI_COLOR_PATTERN_EFFECT_VOLUME, // 07
  GUI_COLOR_PATTERN_EFFECT_PANNING, // 08
  GUI_COLOR_PATTERN_EFFECT_SPEED, // 09
  GUI_COLOR_PATTERN_EFFECT_VOLUME, // 0A
  GUI_COLOR_PATTERN_EFFECT_SONG, // 0B
  GUI_COLOR_PATTERN_EFFECT_TIME, // 0C
  GUI_COLOR_PATTERN_EFFECT_SONG, // 0D
  GUI_COLOR_PATTERN_EFFECT_INVALID, // 0E
  GUI_COLOR_PATTERN_EFFECT_SPEED, // 0F

  // 10-1F
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,

  // 20-2F
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,

  // 30-3F
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,

  // 40-4F
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,

  // 50-5F
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,

  // 60-6F
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,

  // 70-7F
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,

  // 80-8F
  GUI_COLOR_PATTERN_EFFECT_PANNING,
  GUI_COLOR_PATTERN_EFFECT_PANNING,
  GUI_COLOR_PATTERN_EFFECT_PANNING,
  GUI_COLOR_PATTERN_EFFECT_PANNING,
  GUI_COLOR_PATTERN_EFFECT_PANNING,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_PANNING,
  GUI_COLOR_PATTERN_EFFECT_PANNING,
  GUI_COLOR_PATTERN_EFFECT_PANNING,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,

  // 90-9F
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,
  GUI_COLOR_PATTERN_EFFECT_MISC,

  // A0-AF
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,

  // B0-BF
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,

  // C0-CF
  GUI_COLOR_PATTERN_EFFECT_SPEED,
  GUI_COLOR_PATTERN_EFFECT_SPEED,
  GUI_COLOR_PATTERN_EFFECT_SPEED,
  GUI_COLOR_PATTERN_EFFECT_SPEED,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,

  // D0-DF
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_VOLUME,
  GUI_COLOR_PATTERN_EFFECT_VOLUME,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_VOLUME, // DC
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_INVALID,
  GUI_COLOR_PATTERN_EFFECT_MISC, // DF

  // E0-FF extended effects
  GUI_COLOR_PATTERN_EFFECT_MISC, // E0
  GUI_COLOR_PATTERN_EFFECT_PITCH, // E1
  GUI_COLOR_PATTERN_EFFECT_PITCH, // E2
  GUI_COLOR_PATTERN_EFFECT_MISC, // E3
  GUI_COLOR_PATTERN_EFFECT_MISC, // E4
  GUI_COLOR_PATTERN_EFFECT_PITCH, // E5
  GUI_COLOR_PATTERN_EFFECT_MISC, // E6
  GUI_COLOR_PATTERN_EFFECT_TIME, // E7
  GUI_COLOR_PATTERN_EFFECT_MISC, // E8
  GUI_COLOR_PATTERN_EFFECT_MISC, // E9
  GUI_COLOR_PATTERN_EFFECT_MISC, // EA
  GUI_COLOR_PATTERN_EFFECT_MISC, // EB
  GUI_COLOR_PATTERN_EFFECT_TIME, // EC
  GUI_COLOR_PATTERN_EFFECT_TIME, // ED
  GUI_COLOR_PATTERN_EFFECT_SONG, // EE
  GUI_COLOR_PATTERN_EFFECT_SONG, // EF
  GUI_COLOR_PATTERN_EFFECT_SPEED, // F0
  GUI_COLOR_PATTERN_EFFECT_PITCH, // F1
  GUI_COLOR_PATTERN_EFFECT_PITCH, // F2
  GUI_COLOR_PATTERN_EFFECT_VOLUME, // F3
  GUI_COLOR_PATTERN_EFFECT_VOLUME, // F4
  GUI_COLOR_PATTERN_EFFECT_MISC, // F5
  GUI_COLOR_PATTERN_EFFECT_MISC, // F6
  GUI_COLOR_PATTERN_EFFECT_MISC, // F7
  GUI_COLOR_PATTERN_EFFECT_VOLUME, // F8
  GUI_COLOR_PATTERN_EFFECT_VOLUME, // F9
  GUI_COLOR_PATTERN_EFFECT_VOLUME, // FA
  GUI_COLOR_PATTERN_EFFECT_INVALID, // FB
  GUI_COLOR_PATTERN_EFFECT_TIME, // FC
  GUI_COLOR_PATTERN_EFFECT_SPEED, // FD
  GUI_COLOR_PATTERN_EFFECT_SPEED, // FE
  GUI_COLOR_PATTERN_EFFECT_SONG // FF
};

#define D FurnaceGUIActionDef
#define NOT_AN_ACTION -1

// format: ("ACTION_ENUM", "Action name", defaultBind)
const FurnaceGUIActionDef guiActions[GUI_ACTION_MAX]={
  D("GLOBAL_MIN", _N("---Global"), NOT_AN_ACTION),
  D("NEW", _N("New"), FURKMOD_CMD|SDLK_n),
  D("OPEN", _N("Open file"), FURKMOD_CMD|SDLK_o),
  D("OPEN_BACKUP", _N("Restore backup"), 0),
  D("SAVE", _N("Save file"), FURKMOD_CMD|SDLK_s),
  D("SAVE_AS", _N("Save as"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_s),
  D("EXPORT", _N("Export"), 0),
  D("UNDO", _N("Undo"), FURKMOD_CMD|SDLK_z),
#ifdef __APPLE__
  D("REDO", _N("Redo"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_z, FURKMOD_CMD|SDLK_y),
#else
  D("REDO", _N("Redo"), FURKMOD_CMD|SDLK_y),
#endif
  D("QUIT", _N("Exit"), 0),
  D("PLAY_TOGGLE", _N("Play/Stop (toggle)"), SDLK_RETURN),
  D("PLAY", _N("Play"), 0),
  D("STOP", _N("Stop"), 0),
  D("PLAY_START", _N("Play (from beginning)"), SDLK_F5),
  D("PLAY_REPEAT", _N("Play (repeat pattern)"), 0),
  D("PLAY_CURSOR", _N("Play from cursor"), FURKMOD_SHIFT|SDLK_RETURN),
  D("STEP_ONE", _N("Step row"), FURKMOD_CMD|SDLK_RETURN),
  D("OCTAVE_UP", _N("Octave up"), SDLK_KP_MULTIPLY),
  D("OCTAVE_DOWN", _N("Octave down"), SDLK_KP_DIVIDE),
  D("INS_UP", _N("Previous instrument"), FURKMOD_SHIFT|SDLK_KP_DIVIDE),
  D("INS_DOWN", _N("Next instrument"), FURKMOD_SHIFT|SDLK_KP_MULTIPLY),
  D("STEP_UP", _N("Increase edit step"), FURKMOD_CMD|SDLK_KP_MULTIPLY),
  D("STEP_DOWN", _N("Decrease edit step"), FURKMOD_CMD|SDLK_KP_DIVIDE),
  D("TOGGLE_EDIT", _N("Toggle edit mode"), SDLK_SPACE),
  D("METRONOME", _N("Metronome"), FURKMOD_CMD|SDLK_m),
  D("REPEAT_PATTERN", _N("Toggle repeat pattern"), 0),
  D("FOLLOW_ORDERS", _N("Follow orders"), 0),
  D("FOLLOW_PATTERN", _N("Follow pattern"), 0),
  D("FULLSCREEN", _N("Toggle full-screen"), SDLK_F11),
  D("TX81Z_REQUEST", _N("Request voice from TX81Z"), 0),
  D("PANIC", _N("Panic"), SDLK_F12),
  D("CLEAR", _N("Clear song data"), 0),

  D("COMMAND_PALETTE", _N("Command Palette"), FURKMOD_CMD|SDLK_p),
  D("CMDPAL_MIN", "", NOT_AN_ACTION),
  D("CMDPAL_RECENT", _N("Recent files (Palette)"), 0),
  D("CMDPAL_INSTRUMENTS", _N("Instruments (Palette)"), 0),
  D("CMDPAL_SAMPLES", _N("Samples (Palette)"), 0),
  D("CMDPAL_INSTRUMENT_CHANGE", _N("Change instrument (Palette)"), 0),
  D("CMDPAL_ADD_CHIP", _N("Add chip (Palette)"), 0),
  D("CMDPAL_MAX", "", NOT_AN_ACTION),

  D("WINDOW_EDIT_CONTROLS", _N("Edit Controls"), 0),
  D("WINDOW_ORDERS", _N("Orders"), 0),
  D("WINDOW_INS_LIST", _N("Instrument List"), 0),
  D("WINDOW_INS_EDIT", _N("Instrument Editor"), 0),
  D("WINDOW_SONG_INFO", _N("Song Information"), 0),
  D("WINDOW_SPEED", _N("Speed"), 0),
  D("WINDOW_PATTERN", _N("Pattern"), 0),
  D("WINDOW_WAVE_LIST", _N("Wavetable List"), 0),
  D("WINDOW_WAVE_EDIT", _N("Wavetable Editor"), 0),
  D("WINDOW_SAMPLE_LIST", _N("Sample List"), 0),
  D("WINDOW_SAMPLE_EDIT", _N("Sample Editor"), 0),
  D("WINDOW_ABOUT", _N("About"), 0),
#ifdef __APPLE__
  D("WINDOW_SETTINGS", _N("Settings"), FURKMOD_CMD|SDLK_COMMA),
#else
  D("WINDOW_SETTINGS", _N("Settings"), 0),
#endif
  D("WINDOW_MIXER", _N("Mixer"), 0),
  D("WINDOW_DEBUG", _N("Debug Menu"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_d),
  D("WINDOW_OSCILLOSCOPE", _N("Oscilloscope (master)"), 0),
  D("WINDOW_VOL_METER", _N("Volume Meter"), 0),
  D("WINDOW_STATS", _N("Statistics"), 0),
  D("WINDOW_COMPAT_FLAGS", _N("Compatibility Flags"), 0),
  D("WINDOW_PIANO", _N("Piano"), 0),
  D("WINDOW_NOTES", _N("Song Comments"), 0),
  D("WINDOW_CHANNELS", _N("Channels"), 0),
  D("WINDOW_PAT_MANAGER", _N("Pattern Manager"), 0),
  D("WINDOW_SYS_MANAGER", _N("Chip Manager"), 0),
  D("WINDOW_REGISTER_VIEW", _N("Register View"), 0),
  D("WINDOW_LOG", _N("Log Viewer"), 0),
  D("WINDOW_EFFECT_LIST", _N("Effect List"), 0),
  D("WINDOW_CHAN_OSC", _N("Oscilloscope (per-channel)"), 0),
  D("WINDOW_SUBSONGS", _N("Subsongs"), 0),
  D("WINDOW_FIND", _N("Find/Replace"), FURKMOD_CMD|SDLK_f),
  D("WINDOW_CLOCK", _N("Clock"), 0),
  D("WINDOW_GROOVES", _N("Grooves"), 0),
  D("WINDOW_XY_OSC", _N("Oscilloscope (X-Y)"), 0),
  D("WINDOW_MEMORY", _N("Memory Composition"), 0),
  D("WINDOW_CS_PLAYER", _N("Command Stream Player"), 0),
  D("WINDOW_USER_PRESETS", _N("User Presets"), 0),

  D("COLLAPSE_WINDOW", _N("Collapse/expand current window"), 0),
  D("CLOSE_WINDOW", _N("Close current window"), FURKMOD_SHIFT|SDLK_ESCAPE),
  D("GLOBAL_MAX", "", NOT_AN_ACTION),

  D("PAT_MIN", _N("---Pattern"), NOT_AN_ACTION),
  D("PAT_NOTE_UP", _N("Transpose (+1)"), FURKMOD_CMD|SDLK_F2),
  D("PAT_NOTE_DOWN", _N("Transpose (-1)"), FURKMOD_CMD|SDLK_F1),
  D("PAT_OCTAVE_UP", _N("Transpose (+1 octave)"), FURKMOD_CMD|SDLK_F4),
  D("PAT_OCTAVE_DOWN", _N("Transpose (-1 octave)"), FURKMOD_CMD|SDLK_F3),
  D("PAT_VALUE_UP", _N("Increase values (+1)"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_F2),
  D("PAT_VALUE_DOWN", _N("Increase values (-1)"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_F1),
  D("PAT_VALUE_UP_COARSE", _N("Increase values (+16)"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_F4),
  D("PAT_VALUE_DOWN_COARSE", _N("Increase values (-16)"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_F3),
  D("PAT_SELECT_ALL", _N("Select all"), FURKMOD_CMD|SDLK_a),
  D("PAT_CUT", _N("Cut"), FURKMOD_CMD|SDLK_x),
  D("PAT_COPY", _N("Copy"), FURKMOD_CMD|SDLK_c),
  D("PAT_PASTE", _N("Paste"), FURKMOD_CMD|SDLK_v),
  D("PAT_PASTE_MIX", _N("Paste Mix (foreground)"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_v),
  D("PAT_PASTE_MIX_BG", _N("Paste Mix (background)"), 0),
  D("PAT_PASTE_FLOOD", _N("Paste Flood"), 0),
  D("PAT_PASTE_OVERFLOW", _N("Paste Overflow"), 0),
  D("PAT_CURSOR_UP", _N("Move cursor up"), SDLK_UP),
  D("PAT_CURSOR_DOWN", _N("Move cursor down"), SDLK_DOWN),
  D("PAT_CURSOR_LEFT", _N("Move cursor left"), SDLK_LEFT),
  D("PAT_CURSOR_RIGHT", _N("Move cursor right"), SDLK_RIGHT),
  D("PAT_CURSOR_UP_ONE", _N("Move cursor up by one (override Edit Step)"), FURKMOD_SHIFT|SDLK_HOME),
  D("PAT_CURSOR_DOWN_ONE", _N("Move cursor down by one (override Edit Step)"), FURKMOD_SHIFT|SDLK_END),
  D("PAT_CURSOR_LEFT_CHANNEL", _N("Move cursor to previous channel"), 0),
  D("PAT_CURSOR_RIGHT_CHANNEL", _N("Move cursor to next channel"), 0),
  D("PAT_CURSOR_NEXT_CHANNEL", _N("Move cursor to next channel (overflow)"), 0),
  D("PAT_CURSOR_PREVIOUS_CHANNEL", _N("Move cursor to previous channel (overflow)"), 0),
  D("PAT_CURSOR_BEGIN", _N("Move cursor to beginning of pattern"), SDLK_HOME),
  D("PAT_CURSOR_END", _N("Move cursor to end of pattern"), SDLK_END),
  D("PAT_CURSOR_UP_COARSE", _N("Move cursor up (coarse)"), SDLK_PAGEUP),
  D("PAT_CURSOR_DOWN_COARSE", _N("Move cursor down (coarse)"), SDLK_PAGEDOWN),
  D("PAT_SELECTION_UP", _N("Expand selection upwards"), FURKMOD_SHIFT|SDLK_UP),
  D("PAT_SELECTION_DOWN", _N("Expand selection downwards"), FURKMOD_SHIFT|SDLK_DOWN),
  D("PAT_SELECTION_LEFT", _N("Expand selection to the left"), FURKMOD_SHIFT|SDLK_LEFT),
  D("PAT_SELECTION_RIGHT", _N("Expand selection to the right"), FURKMOD_SHIFT|SDLK_RIGHT),
  D("PAT_SELECTION_UP_ONE", _N("Expand selection upwards by one (override Edit Step)"), 0),
  D("PAT_SELECTION_DOWN_ONE", _N("Expand selection downwards by one (override Edit Step)"), 0),
  D("PAT_SELECTION_BEGIN", _N("Expand selection to beginning of pattern"), 0),
  D("PAT_SELECTION_END", _N("Expand selection to end of pattern"), 0),
  D("PAT_SELECTION_UP_COARSE", _N("Expand selection upwards (coarse)"), FURKMOD_SHIFT|SDLK_PAGEUP),
  D("PAT_SELECTION_DOWN_COARSE", _N("Expand selection downwards (coarse)"), FURKMOD_SHIFT|SDLK_PAGEDOWN),
  D("PAT_MOVE_UP", _N("Move selection up"), FURKMOD_ALT|SDLK_UP),
  D("PAT_MOVE_DOWN", _N("Move selection down"), FURKMOD_ALT|SDLK_DOWN),
  D("PAT_MOVE_LEFT_CHANNEL", _N("Move selection to previous channel"), FURKMOD_ALT|SDLK_LEFT),
  D("PAT_MOVE_RIGHT_CHANNEL", _N("Move selection to next channel"), FURKMOD_ALT|SDLK_RIGHT),
  D("PAT_DELETE", _N("Delete"), SDLK_DELETE),
  D("PAT_PULL_DELETE", _N("Pull delete"), SDLK_BACKSPACE),
  D("PAT_INSERT", _N("Insert"), SDLK_INSERT),
  D("PAT_MUTE_CURSOR", _N("Mute channel at cursor"), FURKMOD_ALT|SDLK_F9),
  D("PAT_SOLO_CURSOR", _N("Solo channel at cursor"), FURKMOD_ALT|SDLK_F10),
  D("PAT_UNMUTE_ALL", _N("Unmute all channels"), FURKMOD_ALT|FURKMOD_SHIFT|SDLK_F9),
  D("PAT_NEXT_ORDER", _N("Go to next order"), 0),
  D("PAT_PREV_ORDER", _N("Go to previous order"), 0),
  D("PAT_COLLAPSE", _N("Collapse channel at cursor"), 0),
  D("PAT_INCREASE_COLUMNS", _N("Increase effect columns"), 0),
  D("PAT_DECREASE_COLUMNS", _N("Decrease effect columns"), 0),
  D("PAT_INTERPOLATE", _N("Interpolate"), 0),
  D("PAT_FADE", _N("Fade"), 0),
  D("PAT_INVERT_VALUES", _N("Invert values"), 0),
  D("PAT_FLIP_SELECTION", _N("Flip selection"), 0),
  D("PAT_COLLAPSE_ROWS", _N("Collapse rows"), 0),
  D("PAT_EXPAND_ROWS", _N("Expand rows"), 0),
  D("PAT_COLLAPSE_PAT", _N("Collapse pattern"), 0),
  D("PAT_EXPAND_PAT", _N("Expand pattern"), 0),
  D("PAT_COLLAPSE_SONG", _N("Collapse song"), 0),
  D("PAT_EXPAND_SONG", _N("Expand song"), 0),
  D("PAT_LATCH", _N("Set note input latch"), 0),
  D("PAT_SCROLL_MODE", _N("Change mobile scroll mode"), 0),
  D("PAT_CLEAR_LATCH", _N("Clear note input latch"), 0),
  D("PAT_ABSORB_INSTRUMENT", _N("Absorb instrument/octave from status at cursor"), 0),
  D("PAT_CURSOR_UNDO", _N("Return cursor to previous jump point"), 0),
  D("PAT_CURSOR_REDO", _N("Reverse recent cursor undo"), 0),
  D("PAT_MAX", "", NOT_AN_ACTION),

  D("INS_LIST_MIN", _N("---Instrument list"), NOT_AN_ACTION),
  D("INS_LIST_ADD", _N("Add instrument"), SDLK_INSERT),
  D("INS_LIST_DUPLICATE", _N("Duplicate instrument"), FURKMOD_CMD|SDLK_d),
  D("INS_LIST_OPEN", _N("Open instrument"), 0),
  D("INS_LIST_OPEN_REPLACE", _N("Open instrument (replace current)"), 0),
  D("INS_LIST_SAVE", _N("Save instrument"), 0),
  D("INS_LIST_SAVE_DMP", _N("Save instrument (.dmp)"), 0),
  D("INS_LIST_MOVE_UP", _N("Move instrument up in list"), FURKMOD_SHIFT|SDLK_UP),
  D("INS_LIST_MOVE_DOWN", _N("Move instrument down in list"), FURKMOD_SHIFT|SDLK_DOWN),
  D("INS_LIST_DELETE", _N("Delete instrument"), 0),
  D("INS_LIST_EDIT", _N("Edit instrument"), FURKMOD_SHIFT|SDLK_RETURN),
  D("INS_LIST_UP", _N("Instrument cursor up"), SDLK_UP),
  D("INS_LIST_DOWN", _N("Instrument cursor down"), SDLK_DOWN),
  D("INS_LIST_DIR_VIEW", _N("Instruments: toggle folders/standard view"), FURKMOD_CMD|SDLK_v),
  D("INS_LIST_SAVE_ALL", _N("Save all instruments"), 0),
  D("INS_LIST_MAX", "", NOT_AN_ACTION),

  D("WAVE_LIST_MIN", _N("---Wavetable list"), NOT_AN_ACTION),
  D("WAVE_LIST_ADD", _N("Add wavetable"), SDLK_INSERT),
  D("WAVE_LIST_DUPLICATE", _N("Duplicate wavetable"), FURKMOD_CMD|SDLK_d),
  D("WAVE_LIST_OPEN", _N("Open wavetable"), 0),
  D("WAVE_LIST_OPEN_REPLACE", _N("Open wavetable (replace current)"), 0),
  D("WAVE_LIST_SAVE", _N("Save wavetable"), 0),
  D("WAVE_LIST_SAVE_DMW", _N("Save wavetable (.dmw)"), 0),
  D("WAVE_LIST_SAVE_RAW", _N("Save wavetable (raw)"), 0),
  D("WAVE_LIST_CREATE_SAMPLE", _N("Create sample from wavetable"),0),
  D("WAVE_LIST_MOVE_UP", _N("Move wavetable up in list"), FURKMOD_SHIFT|SDLK_UP),
  D("WAVE_LIST_MOVE_DOWN", _N("Move wavetable down in list"), FURKMOD_SHIFT|SDLK_DOWN),
  D("WAVE_LIST_DELETE", _N("Delete wavetable"), 0),
  D("WAVE_LIST_EDIT", _N("Edit wavetable"), FURKMOD_SHIFT|SDLK_RETURN),
  D("WAVE_LIST_UP", _N("Wavetable cursor up"), SDLK_UP),
  D("WAVE_LIST_DOWN", _N("Wavetable cursor down"), SDLK_DOWN),
  D("WAVE_LIST_DIR_VIEW", _N("Wavetables: toggle folders/standard view"), FURKMOD_CMD|SDLK_v),
  D("WAVE_LIST_SAVE_ALL", _N("Save all wavetables"), 0),
  D("WAVE_LIST_MAX", "", NOT_AN_ACTION),

  D("SAMPLE_LIST_MIN", _N("---Sample list"), NOT_AN_ACTION),
  D("SAMPLE_LIST_ADD", _N("Add sample"), SDLK_INSERT),
  D("SAMPLE_LIST_DUPLICATE", _N("Duplicate sample"), FURKMOD_CMD|SDLK_d),
  D("SAMPLE_LIST_OPEN", _N("Open sample"), 0),
  D("SAMPLE_LIST_OPEN_REPLACE", _N("Open sample (replace current)"), 0),
  D("SAMPLE_LIST_OPEN_RAW", _N("Import raw sample data"), 0),
  D("SAMPLE_LIST_OPEN_REPLACE_RAW", _N("Import raw sample data (replace current)"), 0),
  D("SAMPLE_LIST_SAVE", _N("Save sample"), 0),
  D("SAMPLE_LIST_SAVE_RAW", _N("Save sample (raw)"), 0),
  D("SAMPLE_LIST_MOVE_UP", _N("Move sample up in list"), FURKMOD_SHIFT|SDLK_UP),
  D("SAMPLE_LIST_MOVE_DOWN", _N("Move sample down in list"), FURKMOD_SHIFT|SDLK_DOWN),
  D("SAMPLE_LIST_DELETE", _N("Delete sample"), 0),
  D("SAMPLE_LIST_EDIT", _N("Edit sample"), FURKMOD_SHIFT|SDLK_RETURN),
  D("SAMPLE_LIST_UP", _N("Sample cursor up"), SDLK_UP),
  D("SAMPLE_LIST_DOWN", _N("Sample cursor down"), SDLK_DOWN),
  D("SAMPLE_LIST_PREVIEW", _N("Sample preview"), 0),
  D("SAMPLE_LIST_STOP_PREVIEW", _N("Stop sample preview"), 0),
  D("SAMPLE_LIST_DIR_VIEW", _N("Samples: Toggle folders/standard view"), FURKMOD_CMD|SDLK_v),
  D("SAMPLE_LIST_MAKE_MAP", _N("Samples: Make me a drum kit"), 0),
  D("SAMPLE_LIST_SAVE_ALL", _N("Save all samples"), 0),
  D("SAMPLE_LIST_MAX", "", NOT_AN_ACTION),

  D("SAMPLE_MIN", _N("---Sample editor"), NOT_AN_ACTION),
  D("SAMPLE_SELECT", _N("Sample editor mode: Select"), FURKMOD_SHIFT|SDLK_i),
  D("SAMPLE_DRAW", _N("Sample editor mode: Draw"), FURKMOD_SHIFT|SDLK_d),
  D("SAMPLE_CUT", _N("Sample editor: Cut"), FURKMOD_CMD|SDLK_x),
  D("SAMPLE_COPY", _N("Sample editor: Copy"), FURKMOD_CMD|SDLK_c),
  D("SAMPLE_PASTE", _N("Sample editor: Paste"), FURKMOD_CMD|SDLK_v),
  D("SAMPLE_PASTE_REPLACE", _N("Sample editor: Paste replace"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_v),
  D("SAMPLE_PASTE_MIX", _N("Sample editor: Paste mix"), FURKMOD_CMD|FURKMOD_ALT|SDLK_v),
  D("SAMPLE_SELECT_ALL", _N("Sample editor: Select all"), FURKMOD_CMD|SDLK_a),
  D("SAMPLE_RESIZE", _N("Sample editor: Resize"), FURKMOD_CMD|SDLK_r),
  D("SAMPLE_RESAMPLE", _N("Sample editor: Resample"), FURKMOD_CMD|SDLK_e),
  D("SAMPLE_AMPLIFY", _N("Sample editor: Amplify"), FURKMOD_CMD|SDLK_b),
  D("SAMPLE_NORMALIZE", _N("Sample editor: Normalize"), FURKMOD_CMD|SDLK_n),
  D("SAMPLE_FADE_IN", _N("Sample editor: Fade in"), FURKMOD_CMD|SDLK_i),
  D("SAMPLE_FADE_OUT", _N("Sample editor: Fade out"), FURKMOD_CMD|SDLK_o),
  D("SAMPLE_SILENCE", _N("Sample editor: Apply silence"), FURKMOD_SHIFT|SDLK_DELETE),
  D("SAMPLE_INSERT", _N("Sample editor: Insert silence"), SDLK_INSERT),
  D("SAMPLE_DELETE", _N("Sample editor: Delete"), SDLK_DELETE),
  D("SAMPLE_TRIM", _N("Sample editor: Trim"), FURKMOD_CMD|SDLK_DELETE),
  D("SAMPLE_REVERSE", _N("Sample editor: Reverse"), FURKMOD_CMD|SDLK_t),
  D("SAMPLE_INVERT", _N("Sample editor: Invert"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_t),
  D("SAMPLE_SIGN", _N("Sample editor: Signed/unsigned exchange"), FURKMOD_CMD|SDLK_u),
  D("SAMPLE_FILTER", _N("Sample editor: Apply filter"), FURKMOD_CMD|SDLK_f),
  D("SAMPLE_CROSSFADE_LOOP", _N("Sample editor: Crossfade loop points"), NOT_AN_ACTION),
  D("SAMPLE_PREVIEW", _N("Sample editor: Preview sample"), 0),
  D("SAMPLE_STOP_PREVIEW", _N("Sample editor: Stop sample preview"), 0),
  D("SAMPLE_ZOOM_IN", _N("Sample editor: Zoom in"), FURKMOD_CMD|SDLK_EQUALS),
  D("SAMPLE_ZOOM_OUT", _N("Sample editor: Zoom out"), FURKMOD_CMD|SDLK_MINUS),
  D("SAMPLE_ZOOM_AUTO", _N("Sample editor: Toggle auto-zoom"), FURKMOD_CMD|SDLK_0),
  D("SAMPLE_MAKE_INS", _N("Sample editor: Create instrument from sample"), 0),
  D("SAMPLE_SET_LOOP", _N("Sample editor: Set loop to selection"), FURKMOD_CMD|SDLK_l),
  D("SAMPLE_CREATE_WAVE", _N("Sample editor: Create wavetable from selection"), FURKMOD_CMD|SDLK_w),
  D("SAMPLE_MAX", "", NOT_AN_ACTION),

  D("ORDERS_MIN", _N("---Orders"), NOT_AN_ACTION),
  D("ORDERS_UP", _N("Previous order"), SDLK_UP),
  D("ORDERS_DOWN", _N("Next order"), SDLK_DOWN),
  D("ORDERS_LEFT", _N("Order cursor left"), SDLK_LEFT),
  D("ORDERS_RIGHT", _N("Order cursor right"), SDLK_RIGHT),
  D("ORDERS_INCREASE", _N("Increase order value"), 0),
  D("ORDERS_DECREASE", _N("Decrease order value"), 0),
  D("ORDERS_EDIT_MODE", _N("Switch order edit mode"), 0),
  D("ORDERS_LINK", _N("Order: toggle alter entire row"), FURKMOD_CMD|SDLK_l),
  D("ORDERS_ADD", _N("Add order"), SDLK_INSERT),
  D("ORDERS_DUPLICATE", _N("Duplicate order"), FURKMOD_CMD|SDLK_d),
  D("ORDERS_DEEP_CLONE", _N("Deep clone order"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_d),
  D("ORDERS_DUPLICATE_END", _N("Copy current order to end of song"), FURKMOD_CMD|SDLK_e),
  D("ORDERS_DEEP_CLONE_END", _N("Deep clone current order to end of song"), FURKMOD_CMD|FURKMOD_SHIFT|SDLK_e),
  D("ORDERS_REMOVE", _N("Remove order"), SDLK_DELETE),
  D("ORDERS_MOVE_UP", _N("Move order up"), FURKMOD_SHIFT|SDLK_UP),
  D("ORDERS_MOVE_DOWN", _N("Move order down"), FURKMOD_SHIFT|SDLK_DOWN),
  D("ORDERS_REPLAY", _N("Replay order"), 0),
  D("ORDERS_MAX", "", NOT_AN_ACTION),
};
#undef D

#define D(x,y,z) FurnaceGUIColorDef(#x,y,ImGui::ColorConvertFloat4ToU32(z))

const FurnaceGUIColorDef guiColors[GUI_COLOR_MAX]={
  D(GUI_COLOR_BACKGROUND,"Background",ImVec4(0.1f,0.1f,0.1f,1.0f)),
  D(GUI_COLOR_FRAME_BACKGROUND,"",ImVec4(0.0f,0.0f,0.0f,0.85f)),
  D(GUI_COLOR_FRAME_BACKGROUND_CHILD,"",ImVec4(0.0f,0.0f,0.0f,0.0f)),
  D(GUI_COLOR_FRAME_BACKGROUND_POPUP,"",ImVec4(0.08f,0.08f,0.08f,0.94f)),
  D(GUI_COLOR_MODAL_BACKDROP,"",ImVec4(0.0f,0.0f,0.0f,0.55f)),
  D(GUI_COLOR_HEADER,"",ImVec4(0.2f,0.2f,0.2f,1.0f)),
  D(GUI_COLOR_TEXT,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_TEXT_DISABLED,"",ImVec4(0.5f,0.5f,0.5f,1.0f)),
  D(GUI_COLOR_ACCENT_PRIMARY,"",ImVec4(0.06f,0.53f,0.98f,1.0f)),
  D(GUI_COLOR_ACCENT_SECONDARY,"",ImVec4(0.26f,0.59f,0.98f,1.0f)),
  D(GUI_COLOR_TITLE_INACTIVE,"",ImVec4(0.04f,0.04f,0.04f,1.0f)),
  D(GUI_COLOR_TITLE_COLLAPSED,"",ImVec4(0.0f,0.0f,0.0f,0.51f)),
  D(GUI_COLOR_MENU_BAR,"",ImVec4(0.14f,0.14f,0.14f,1.0f)),
  D(GUI_COLOR_BORDER,"",ImVec4(0.43f,0.43f,0.5f,0.5f)),
  D(GUI_COLOR_BORDER_SHADOW,"",ImVec4(0.0f,0.0f,0.0f,0.0f)),
  D(GUI_COLOR_SCROLL_BACKGROUND,"",ImVec4(0.02f,0.02f,0.02f,0.33f)),
  D(GUI_COLOR_SCROLL,"",ImVec4(0.31f,0.31f,0.31f,1.0f)),
  D(GUI_COLOR_SCROLL_HOVER,"",ImVec4(0.41f,0.41f,0.41f,1.0f)),
  D(GUI_COLOR_SCROLL_ACTIVE,"",ImVec4(0.51f,0.51f,0.51f,1.0f)),
  D(GUI_COLOR_SEPARATOR,"",ImVec4(0.43f,0.43f,0.5f,0.5f)),
  D(GUI_COLOR_SEPARATOR_HOVER,"",ImVec4(0.1f,0.4f,0.75f,0.78f)),
  D(GUI_COLOR_SEPARATOR_ACTIVE,"",ImVec4(0.1f,0.4f,0.75f,1.0f)),
  D(GUI_COLOR_DOCKING_PREVIEW,"",ImVec4(0.26f,0.59f,0.98f,0.7f)),
  D(GUI_COLOR_DOCKING_EMPTY,"",ImVec4(0.2f,0.2f,0.2f,1.0f)),
  D(GUI_COLOR_TABLE_HEADER,"",ImVec4(0.19f,0.19f,0.2f,1.0f)),
  D(GUI_COLOR_TABLE_BORDER_HARD,"",ImVec4(0.31f,0.31f,0.35f,1.0f)),
  D(GUI_COLOR_TABLE_BORDER_SOFT,"",ImVec4(0.23f,0.23f,0.25f,1.0f)),
  D(GUI_COLOR_DRAG_DROP_TARGET,"",ImVec4(1.0f,1.0f,0.0f,0.9f)),
  D(GUI_COLOR_NAV_HIGHLIGHT,"",ImVec4(0.26f,0.59f,0.98f,1.0f)),
  D(GUI_COLOR_NAV_WIN_HIGHLIGHT,"",ImVec4(1.0f,1.0f,1.0f,0.7f)),
  D(GUI_COLOR_NAV_WIN_BACKDROP,"",ImVec4(0.8f,0.8f,0.8f,0.2f)),
  D(GUI_COLOR_PLOT_LINES,"",ImVec4(0.61f,0.61f,0.61f,1.0f)),
  D(GUI_COLOR_PLOT_LINES_HOVER,"",ImVec4(1.00f,0.43f,0.35f,1.00f)),
  D(GUI_COLOR_PLOT_HISTOGRAM,"",ImVec4(0.0f,0.9f,1.0f,1.0f)),
  D(GUI_COLOR_PLOT_HISTOGRAM_HOVER,"",ImVec4(0.0f,0.9f,1.0f,1.0f)),

  D(GUI_COLOR_BUTTON,"",ImVec4(0.085f,0.216f,0.343f,1.0f)),
  D(GUI_COLOR_BUTTON_HOVER,"",ImVec4(0.075f,0.287f,0.49f,1.0f)),
  D(GUI_COLOR_BUTTON_ACTIVE,"",ImVec4(0.06f,0.53f,0.98f,1.0f)),
  D(GUI_COLOR_TAB,"",ImVec4(0.085f,0.216f,0.343f,1.0f)),
  D(GUI_COLOR_TAB_HOVER,"",ImVec4(0.165f,0.313f,0.49f,1.0f)),
  D(GUI_COLOR_TAB_ACTIVE,"",ImVec4(0.25f,0.47f,0.735f,1.0f)),
  D(GUI_COLOR_TAB_UNFOCUSED,"",ImVec4(0.085f,0.216f,0.343f,1.0f)),
  D(GUI_COLOR_TAB_UNFOCUSED_ACTIVE,"",ImVec4(0.075f,0.287f,0.49f,1.0f)),
  D(GUI_COLOR_IMGUI_HEADER,"",ImVec4(0.083f,0.156f,0.245f,1.0f)),
  D(GUI_COLOR_IMGUI_HEADER_HOVER,"",ImVec4(0.165f,0.313f,0.49f,1.0f)),
  D(GUI_COLOR_IMGUI_HEADER_ACTIVE,"",ImVec4(0.26f,0.59f,0.98f,1.0f)),
  D(GUI_COLOR_RESIZE_GRIP,"",ImVec4(0.083f,0.156f,0.245f,1.0f)),
  D(GUI_COLOR_RESIZE_GRIP_HOVER,"",ImVec4(0.165f,0.313f,0.49f,1.0f)),
  D(GUI_COLOR_RESIZE_GRIP_ACTIVE,"",ImVec4(0.26f,0.59f,0.98f,1.0f)),
  D(GUI_COLOR_WIDGET_BACKGROUND,"",ImVec4(0.083f,0.156f,0.245f,1.0f)),
  D(GUI_COLOR_WIDGET_BACKGROUND_HOVER,"",ImVec4(0.165f,0.313f,0.49f,1.0f)),
  D(GUI_COLOR_WIDGET_BACKGROUND_ACTIVE,"",ImVec4(0.26f,0.59f,0.98f,1.0f)),
  D(GUI_COLOR_SLIDER_GRAB,"",ImVec4(0.06f,0.53f,0.98f,1.0f)),
  D(GUI_COLOR_SLIDER_GRAB_ACTIVE,"",ImVec4(0.06f,0.53f,0.98f,1.0f)),
  D(GUI_COLOR_TITLE_BACKGROUND_ACTIVE,"",ImVec4(0.085f,0.216f,0.343f,1.0f)),
  D(GUI_COLOR_CHECK_MARK,"",ImVec4(0.06f,0.53f,0.98f,1.0f)),
  D(GUI_COLOR_TEXT_SELECTION,"",ImVec4(0.165f,0.313f,0.49f,1.0f)),
  D(GUI_COLOR_TABLE_ROW_EVEN,"",ImVec4(0.0f,0.0f,0.0f,0.0f)),
  D(GUI_COLOR_TABLE_ROW_ODD,"",ImVec4(1.0f,1.0f,1.0f,0.06f)),

  D(GUI_COLOR_TOGGLE_OFF,"",ImVec4(0.2f,0.2f,0.2f,1.0f)),
  D(GUI_COLOR_TOGGLE_ON,"",ImVec4(0.2f,0.6f,0.2f,1.0f)),
  D(GUI_COLOR_EDITING,"",ImVec4(0.2f,0.1f,0.1f,1.0f)),
  D(GUI_COLOR_EDITING_CLONE,"",ImVec4(0.2f,0.1f,0.3f,1.0f)),
  D(GUI_COLOR_SONG_LOOP,"",ImVec4(0.3f,0.5f,0.8f,0.4f)),
  D(GUI_COLOR_DESTRUCTIVE,"",ImVec4(1.0f,0.2f,0.2f,1.0f)),
  D(GUI_COLOR_WARNING,"",ImVec4(0.98f,0.98f,0.06f,1.0f)),
  D(GUI_COLOR_ERROR,"",ImVec4(0.98f,0.06f,0.11f,1.0f)),

  D(GUI_COLOR_FILE_DIR,"",ImVec4(0.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_FILE_SONG_NATIVE,"",ImVec4(0.5f,1.0f,0.5f,1.0f)),
  D(GUI_COLOR_FILE_SONG_IMPORT,"",ImVec4(0.5f,1.0f,0.8f,1.0f)),
  D(GUI_COLOR_FILE_INSTR,"",ImVec4(1.0f,0.5f,0.5f,1.0f)),
  D(GUI_COLOR_FILE_AUDIO,"",ImVec4(1.0f,1.0f,0.5f,1.0f)),
  D(GUI_COLOR_FILE_WAVE,"",ImVec4(1.0f,0.75f,0.5f,1.0f)),
  D(GUI_COLOR_FILE_VGM,"",ImVec4(1.0f,1.0f,0.5f,1.0f)),
  D(GUI_COLOR_FILE_ZSM,"",ImVec4(1.0f,1.0f,0.5f,1.0f)),
  D(GUI_COLOR_FILE_FONT,"",ImVec4(0.3f,1.0f,0.6f,1.0f)),
  D(GUI_COLOR_FILE_OTHER,"",ImVec4(0.7f,0.7f,0.7f,1.0f)),

  D(GUI_COLOR_OSC_BG1,"",ImVec4(0.1f,0.18f,0.3f,1.0f)),
  D(GUI_COLOR_OSC_BG2,"",ImVec4(0.1f,0.18f,0.3f,1.0f)),
  D(GUI_COLOR_OSC_BG3,"",ImVec4(0.05f,0.15f,0.25f,1.0f)),
  D(GUI_COLOR_OSC_BG4,"",ImVec4(0.05f,0.15f,0.25f,1.0f)),
  D(GUI_COLOR_OSC_BORDER,"",ImVec4(0.4f,0.6f,0.95f,1.0f)),
  D(GUI_COLOR_OSC_WAVE,"",ImVec4(0.95f,0.95f,1.0f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_PEAK,"",ImVec4(0.95f,0.95f,1.0f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH0,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH1,"",ImVec4(1.0f,0.2f,0.2f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH2,"",ImVec4(0.1f,0.5f,1.0f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH3,"",ImVec4(0.5f,0.5f,0.5f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH4,"",ImVec4(0.7f,0.2f,0.7f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH5,"",ImVec4(0.2f,1.0f,0.2f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH6,"",ImVec4(1.0f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH7,"",ImVec4(1.0f,0.5f,0.1f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH8,"",ImVec4(0.9f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH9,"",ImVec4(0.8f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH10,"",ImVec4(0.7f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH11,"",ImVec4(0.6f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH12,"",ImVec4(0.5f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH13,"",ImVec4(0.4f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH14,"",ImVec4(0.3f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_OSC_WAVE_CH15,"",ImVec4(0.2f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_OSC_REF,"",ImVec4(0.3,0.65f,1.0f,0.15f)),
  D(GUI_COLOR_OSC_GUIDE,"",ImVec4(0.3,0.65f,1.0f,0.13f)),

  D(GUI_COLOR_VOLMETER_LOW,"",ImVec4(0.2f,0.6f,0.2f,1.0f)),
  D(GUI_COLOR_VOLMETER_HIGH,"",ImVec4(1.0f,0.9f,0.2f,1.0f)),
  D(GUI_COLOR_VOLMETER_PEAK,"",ImVec4(1.0f,0.1f,0.1f,1.0f)),

  D(GUI_COLOR_ORDER_ROW_INDEX,"",ImVec4(0.5f,0.8f,1.0f,1.0f)),
  D(GUI_COLOR_ORDER_ACTIVE,"",ImVec4(0.4f,0.7f,1.0f,0.25f)),
  D(GUI_COLOR_ORDER_SELECTED,"",ImVec4(0.6f,0.8f,1.0f,0.75f)),
  D(GUI_COLOR_ORDER_SIMILAR,"",ImVec4(0.5f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_ORDER_INACTIVE,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),

  D(GUI_COLOR_FM_ALG_BG,"",ImVec4(0.12f,0.12f,0.12f,1.0f)),
  D(GUI_COLOR_FM_ALG_LINE,"",ImVec4(1.0f,1.0f,1.0f,0.33f)),
  D(GUI_COLOR_FM_MOD,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_FM_PRIMARY_MOD,"",ImVec4(0.06f,0.53f,0.98f,1.0f)),
  D(GUI_COLOR_FM_SECONDARY_MOD,"",ImVec4(0.06f,0.53f,0.98f,1.0f)),
  D(GUI_COLOR_FM_BORDER_MOD,"",ImVec4(0.43f,0.43f,0.5f,0.5f)),
  D(GUI_COLOR_FM_BORDER_SHADOW_MOD,"",ImVec4(0.0f,0.0f,0.0f,0.0f)),
  D(GUI_COLOR_FM_CAR,"",ImVec4(0.5f,0.8f,1.0f,1.0f)),
  D(GUI_COLOR_FM_PRIMARY_CAR,"",ImVec4(0.06f,0.8f,0.98f,1.0f)),
  D(GUI_COLOR_FM_SECONDARY_CAR,"",ImVec4(0.06f,0.8f,0.98f,1.0f)),
  D(GUI_COLOR_FM_BORDER_CAR,"",ImVec4(0.43f,0.5f,0.5f,0.5f)),
  D(GUI_COLOR_FM_BORDER_SHADOW_CAR,"",ImVec4(0.0f,0.0f,0.0f,0.0f)),

  D(GUI_COLOR_FM_ENVELOPE,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_FM_ENVELOPE_SUS_GUIDE,"",ImVec4(0.3f,0.5f,0.8f,0.4f)),
  D(GUI_COLOR_FM_ENVELOPE_RELEASE,"",ImVec4(0.3f,0.5f,0.8f,0.4f)),
  D(GUI_COLOR_FM_SSG,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_FM_WAVE,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),

  D(GUI_COLOR_MACRO_HIGHLIGHT,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_MACRO_VOLUME,"",ImVec4(0.2f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_MACRO_PITCH,"",ImVec4(1.0f,0.8f,0.0f,1.0f)),
  D(GUI_COLOR_MACRO_OTHER,"",ImVec4(0.0f,0.9f,1.0f,1.0f)),
  D(GUI_COLOR_MACRO_WAVE,"",ImVec4(1.0f,0.4f,0.0f,1.0f)),
  D(GUI_COLOR_MACRO_NOISE,"",ImVec4(0.8f,0.8f,0.8f,1.0f)),
  D(GUI_COLOR_MACRO_FILTER,"",ImVec4(0.4f,0.2f,1.0f,1.0f)),
  D(GUI_COLOR_MACRO_ENVELOPE,"",ImVec4(0.0f,1.0f,0.5f,1.0f)),
  D(GUI_COLOR_MACRO_GLOBAL,"",ImVec4(1.0f,0.1f,0.1f,1.0f)),

  D(GUI_COLOR_INSTR_STD,"",ImVec4(0.6f,1.0f,0.5f,1.0f)),
  D(GUI_COLOR_INSTR_FM,"",ImVec4(0.6f,0.9f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_GB,"",ImVec4(1.0f,1.0f,0.5f,1.0f)),
  D(GUI_COLOR_INSTR_C64,"",ImVec4(0.85f,0.8f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_AMIGA,"",ImVec4(1.0f,0.5f,0.5f,1.0f)),
  D(GUI_COLOR_INSTR_PCE,"",ImVec4(1.0f,0.8f,0.5f,1.0f)),
  D(GUI_COLOR_INSTR_AY,"",ImVec4(1.0f,0.5f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_AY8930,"",ImVec4(0.7f,0.5f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_TIA,"",ImVec4(1.0f,0.6f,0.4f,1.0f)),
  D(GUI_COLOR_INSTR_SAA1099,"",ImVec4(0.3f,0.3f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_VIC,"",ImVec4(0.2f,1.0f,0.6f,1.0f)),
  D(GUI_COLOR_INSTR_PET,"",ImVec4(1.0f,1.0f,0.8f,1.0f)),
  D(GUI_COLOR_INSTR_VRC6,"",ImVec4(1.0f,0.9f,0.5f,1.0f)),
  D(GUI_COLOR_INSTR_OPLL,"",ImVec4(0.6f,0.7f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_OPL,"",ImVec4(0.3f,1.0f,0.9f,1.0f)),
  D(GUI_COLOR_INSTR_FDS,"",ImVec4(0.8f,0.5f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_VBOY,"",ImVec4(1.0f,0.1f,0.1f,1.0f)),
  D(GUI_COLOR_INSTR_N163,"",ImVec4(1.0f,0.4f,0.1f,1.0f)),
  D(GUI_COLOR_INSTR_SCC,"",ImVec4(0.7f,1.0f,0.3f,1.0f)),
  D(GUI_COLOR_INSTR_OPZ,"",ImVec4(0.2f,0.8f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_POKEY,"",ImVec4(0.5f,1.0f,0.3f,1.0f)),
  D(GUI_COLOR_INSTR_BEEPER,"",ImVec4(0.0f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_INSTR_SWAN,"",ImVec4(0.3f,0.5f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_MIKEY,"",ImVec4(0.5f,1.0f,0.3f,1.0f)),
  D(GUI_COLOR_INSTR_VERA,"",ImVec4(0.4f,0.6f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_X1_010,"",ImVec4(0.3f,0.5f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_VRC6_SAW,"",ImVec4(0.8f,0.3f,0.0f,1.0f)),
  D(GUI_COLOR_INSTR_ES5506,"",ImVec4(0.5f,0.5f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_MULTIPCM,"",ImVec4(1.0f,0.8f,0.1f,1.0f)),
  D(GUI_COLOR_INSTR_SNES,"",ImVec4(0.8f,0.7f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_SU,"",ImVec4(0.95f,0.98f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_NAMCO,"",ImVec4(1.0f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_INSTR_OPL_DRUMS,"",ImVec4(0.3f,1.0f,0.9f,1.0f)),
  D(GUI_COLOR_INSTR_OPM,"",ImVec4(0.2f,0.6f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_NES,"",ImVec4(0.4f,1.0f,0.3f,1.0f)),
  D(GUI_COLOR_INSTR_MSM6258,"",ImVec4(1.0f,0.5f,0.7f,1.0f)),
  D(GUI_COLOR_INSTR_MSM6295,"",ImVec4(1.0f,0.6f,0.9f,1.0f)),
  D(GUI_COLOR_INSTR_ADPCMA,"",ImVec4(1.0f,1.0f,0.5f,1.0f)),
  D(GUI_COLOR_INSTR_ADPCMB,"",ImVec4(1.0f,0.75f,0.5f,1.0f)),
  D(GUI_COLOR_INSTR_SEGAPCM,"",ImVec4(1.0f,0.9f,0.6f,1.0f)),
  D(GUI_COLOR_INSTR_QSOUND,"",ImVec4(1.0f,0.8f,0.3f,1.0f)),
  D(GUI_COLOR_INSTR_YMZ280B,"",ImVec4(0.4f,0.5f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_RF5C68,"",ImVec4(1.0f,0.3f,0.3f,1.0f)),
  D(GUI_COLOR_INSTR_MSM5232,"",ImVec4(0.5f,0.9f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_T6W28,"",ImVec4(1.0f,0.8f,0.1f,1.0f)),
  D(GUI_COLOR_INSTR_K007232,"",ImVec4(1.0f,0.8f,0.1f,1.0f)),
  D(GUI_COLOR_INSTR_GA20,"",ImVec4(0.1f,1.0f,0.4f,1.0f)),
  D(GUI_COLOR_INSTR_POKEMINI,"",ImVec4(1.0f,1.0f,0.3f,1.0f)),
  D(GUI_COLOR_INSTR_SM8521,"",ImVec4(0.5f,0.55f,0.6f,1.0f)),
  D(GUI_COLOR_INSTR_PV1000,"",ImVec4(0.4f,0.6f,0.7f,1.0f)),
  D(GUI_COLOR_INSTR_K053260,"",ImVec4(1.0f,0.8f,0.1f,1.0f)),
  D(GUI_COLOR_INSTR_SCSP,"",ImVec4(0.5f,0.5f,0.5f,1.0f)),
  D(GUI_COLOR_INSTR_TED,"",ImVec4(0.7f,0.6f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_C140,"",ImVec4(1.0f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_INSTR_C219,"",ImVec4(1.0f,0.8f,0.0f,1.0f)),
  D(GUI_COLOR_INSTR_ESFM,"",ImVec4(0.1f,0.9f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_POWERNOISE,"",ImVec4(1.0f,1.0f,0.8f,1.0f)),
  D(GUI_COLOR_INSTR_POWERNOISE_SLOPE,"",ImVec4(1.0f,0.6f,0.3f,1.0f)),
  D(GUI_COLOR_INSTR_DAVE,"",ImVec4(0.7f,0.7f,0.8f,1.0f)),
  D(GUI_COLOR_INSTR_NDS,"",ImVec4(0.7f,0.7f,0.8f,1.0f)),
  D(GUI_COLOR_INSTR_GBA_DMA,"",ImVec4(0.6f,0.4f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_GBA_MINMOD,"",ImVec4(0.5f,0.45f,0.7f,1.0f)),
  D(GUI_COLOR_INSTR_BIFURCATOR,"",ImVec4(0.8925f,0.8925f,0.8925f,1.0f)),
  D(GUI_COLOR_INSTR_SID2,"",ImVec4(0.6f,0.75f,1.0f,1.0f)),
  D(GUI_COLOR_INSTR_SUPERVISION,"",ImVec4(0.52f,1.0f,0.6f,1.0f)),
  D(GUI_COLOR_INSTR_UPD1771C,"",ImVec4(0.94f,0.52f,0.6f,1.0f)),
  D(GUI_COLOR_INSTR_SID3,"",ImVec4(0.6f,0.75f,0.6f,1.0f)),
  D(GUI_COLOR_INSTR_UNKNOWN,"",ImVec4(0.3f,0.3f,0.3f,1.0f)),

  D(GUI_COLOR_CHANNEL_BG,"",ImVec4(0.4f,0.6f,0.8f,1.0f)),
  D(GUI_COLOR_CHANNEL_FG,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_CHANNEL_FM,"",ImVec4(0.2f,0.8f,1.0f,1.0f)),
  D(GUI_COLOR_CHANNEL_PULSE,"",ImVec4(0.4f,1.0f,0.2f,1.0f)),
  D(GUI_COLOR_CHANNEL_NOISE,"",ImVec4(0.8f,0.8f,0.8f,1.0f)),
  D(GUI_COLOR_CHANNEL_WAVE,"",ImVec4(1.0f,0.5f,0.2f,1.0f)),
  D(GUI_COLOR_CHANNEL_PCM,"",ImVec4(1.0f,0.9f,0.2f,1.0f)),
  D(GUI_COLOR_CHANNEL_OP,"",ImVec4(0.2f,0.4f,1.0f,1.0f)),
  D(GUI_COLOR_CHANNEL_MUTED,"",ImVec4(0.5f,0.5f,0.5f,1.0f)),

  D(GUI_COLOR_PATTERN_PLAY_HEAD,"",ImVec4(1.0f,1.0f,1.0f,0.25f)),
  D(GUI_COLOR_PATTERN_CURSOR,"",ImVec4(0.1f,0.3f,0.5f,1.0f)),
  D(GUI_COLOR_PATTERN_CURSOR_HOVER,"",ImVec4(0.2f,0.4f,0.6f,1.0f)),
  D(GUI_COLOR_PATTERN_CURSOR_ACTIVE,"",ImVec4(0.2f,0.5f,0.7f,1.0f)),
  D(GUI_COLOR_PATTERN_SELECTION,"",ImVec4(0.15f,0.15f,0.2f,1.0f)),
  D(GUI_COLOR_PATTERN_SELECTION_HOVER,"",ImVec4(0.2f,0.2f,0.3f,1.0f)),
  D(GUI_COLOR_PATTERN_SELECTION_ACTIVE,"",ImVec4(0.4f,0.4f,0.5f,1.0f)),
  D(GUI_COLOR_PATTERN_HI_1,"",ImVec4(0.6f,0.6f,0.6f,0.2f)),
  D(GUI_COLOR_PATTERN_HI_2,"",ImVec4(0.5f,0.8f,1.0f,0.2f)),
  D(GUI_COLOR_PATTERN_ROW_INDEX,"",ImVec4(0.5f,0.8f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_ROW_INDEX_HI1,"",ImVec4(0.5f,0.8f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_ROW_INDEX_HI2,"",ImVec4(0.5f,0.8f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_ACTIVE,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_INACTIVE,"",ImVec4(0.5f,0.5f,0.5f,1.0f)),
  D(GUI_COLOR_PATTERN_ACTIVE_HI1,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_INACTIVE_HI1,"",ImVec4(0.5f,0.5f,0.5f,1.0f)),
  D(GUI_COLOR_PATTERN_ACTIVE_HI2,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_INACTIVE_HI2,"",ImVec4(0.5f,0.5f,0.5f,1.0f)),
  D(GUI_COLOR_PATTERN_INS,"",ImVec4(0.4f,0.7f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_INS_WARN,"",ImVec4(1.0f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_PATTERN_INS_ERROR,"",ImVec4(1.0f,0.1f,0.1f,1.0f)),
  D(GUI_COLOR_PATTERN_VOLUME_MAX,"",ImVec4(0.0f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_VOLUME_HALF,"",ImVec4(0.0f,0.75f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_VOLUME_MIN,"",ImVec4(0.0f,0.5f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_EFFECT_INVALID,"",ImVec4(1.0f,0.0f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_EFFECT_PITCH,"",ImVec4(1.0f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_EFFECT_VOLUME,"",ImVec4(0.0f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_EFFECT_PANNING,"",ImVec4(0.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_EFFECT_SONG,"",ImVec4(1.0f,0.0f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_EFFECT_TIME,"",ImVec4(0.5f,0.0f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_EFFECT_SPEED,"",ImVec4(1.0f,0.0f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_EFFECT_SYS_PRIMARY,"",ImVec4(0.5f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_EFFECT_SYS_SECONDARY,"",ImVec4(0.0f,1.0f,0.5f,1.0f)),
  D(GUI_COLOR_PATTERN_EFFECT_MISC,"",ImVec4(0.3f,0.3f,1.0f,1.0f)),

  D(GUI_COLOR_PATTERN_STATUS_OFF,"",ImVec4(0.2f,0.2f,0.2f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_REL,"",ImVec4(0.7f,0.1f,0.1f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_REL_ON,"",ImVec4(1.0f,0.8f,0.1f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_ON,"",ImVec4(0.3f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_VOLUME,"",ImVec4(0.0f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_PITCH,"",ImVec4(1.0f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_PANNING,"",ImVec4(0.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_SYS1,"",ImVec4(0.5f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_SYS2,"",ImVec4(0.0f,1.0f,0.5f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_MIXING,"",ImVec4(1.0f,0.3f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_DSP,"",ImVec4(0.3f,0.6f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_NOTE,"",ImVec4(0.3f,0.3f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_MISC1,"",ImVec4(1.0f,0.5f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_MISC2,"",ImVec4(0.7f,0.5f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_MISC3,"",ImVec4(1.0f,0.1f,0.1f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_ATTACK,"",ImVec4(1.0f,0.1f,0.1f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_DECAY,"",ImVec4(0.1f,0.4f,0.5f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_SUSTAIN,"",ImVec4(0.1f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_RELEASE,"",ImVec4(1.0f,0.1f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_DEC_LINEAR,"",ImVec4(0.0f,0.6f,0.7f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_DEC_EXP,"",ImVec4(1.0f,0.3f,0.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_INC,"",ImVec4(0.1f,0.1f,1.0f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_BENT,"",ImVec4(1.0f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_PATTERN_STATUS_DIRECT,"",ImVec4(1.0f,0.5f,0.2f,1.0f)),

  D(GUI_COLOR_PATTERN_PAIR,"",ImVec4(0.6f,0.8f,1.0f,1.0f)),

  D(GUI_COLOR_SAMPLE_BG,"",ImVec4(0.04f,0.13f,0.2f,1.0f)),
  D(GUI_COLOR_SAMPLE_FG,"",ImVec4(0.7f,0.7f,0.7f,1.0f)),
  D(GUI_COLOR_SAMPLE_LOOP,"",ImVec4(0.1f,0.22f,0.35f,1.0f)),
  D(GUI_COLOR_SAMPLE_CENTER,"",ImVec4(0.2f,0.2f,0.2f,1.0f)),
  D(GUI_COLOR_SAMPLE_GRID,"",ImVec4(0.1f,0.1f,0.15f,1.0f)),
  D(GUI_COLOR_SAMPLE_SEL,"",ImVec4(0.26f,0.59f,0.98f,0.25f)),
  D(GUI_COLOR_SAMPLE_SEL_POINT,"",ImVec4(0.06f,0.53f,0.98f,0.5f)),
  D(GUI_COLOR_SAMPLE_NEEDLE,"",ImVec4(1.0f,0.8f,0.0f,1.0f)),
  D(GUI_COLOR_SAMPLE_NEEDLE_PLAYING,"",ImVec4(0.2f,1.0f,0.0f,1.0f)),
  D(GUI_COLOR_SAMPLE_LOOP_POINT,"",ImVec4(1.0f,0.0f,0.0f,1.0f)),
  D(GUI_COLOR_SAMPLE_TIME_BG,"",ImVec4(0.1f,0.11f,0.12f,1.0f)),
  D(GUI_COLOR_SAMPLE_TIME_FG,"",ImVec4(0.4f,0.4f,0.4f,1.0f)),
  D(GUI_COLOR_SAMPLE_CHIP_DISABLED,"",ImVec4(0.6f,0.6f,0.6f,1.0f)),
  D(GUI_COLOR_SAMPLE_CHIP_ENABLED,"",ImVec4(0.3f,1.0f,0.3f,1.0f)),
  D(GUI_COLOR_SAMPLE_CHIP_WARNING,"",ImVec4(1.0f,0.75f,0.3f,1.0f)),

  D(GUI_COLOR_PAT_MANAGER_NULL,"",ImVec4(0.15f,0.15f,0.15f,1.0f)),
  D(GUI_COLOR_PAT_MANAGER_USED,"",ImVec4(0.15f,1.0f,0.15f,1.0f)),
  D(GUI_COLOR_PAT_MANAGER_OVERUSED,"",ImVec4(1.0f,1.0f,0.15f,1.0f)),
  D(GUI_COLOR_PAT_MANAGER_EXTREMELY_OVERUSED,"",ImVec4(1.0f,0.5f,0.15f,1.0f)),
  D(GUI_COLOR_PAT_MANAGER_COMBO_BREAKER,"",ImVec4(1.0f,0.15f,1.0f,1.0f)),
  D(GUI_COLOR_PAT_MANAGER_UNUSED,"",ImVec4(1.0f,0.15f,0.15f,1.0f)),

  D(GUI_COLOR_PIANO_BACKGROUND,"",ImVec4(0.0f,0.0f,0.0f,1.0f)),
  D(GUI_COLOR_PIANO_KEY_BOTTOM,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_PIANO_KEY_TOP,"",ImVec4(0.0f,0.0f,0.0f,1.0f)),
  D(GUI_COLOR_PIANO_KEY_BOTTOM_HIT,"",ImVec4(0.5f,0.7f,0.9f,1.0f)),
  D(GUI_COLOR_PIANO_KEY_TOP_HIT,"",ImVec4(0.3f,0.5f,0.7f,1.0f)),
  D(GUI_COLOR_PIANO_KEY_BOTTOM_ACTIVE,"",ImVec4(0.5f,0.5f,0.5f,1.0f)),
  D(GUI_COLOR_PIANO_KEY_TOP_ACTIVE,"",ImVec4(0.4f,0.4f,0.4f,1.0f)),

  D(GUI_COLOR_CLOCK_TEXT,"",ImVec4(1.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_CLOCK_BEAT_LOW,"",ImVec4(0.1f,0.13f,0.25f,1.0f)),
  D(GUI_COLOR_CLOCK_BEAT_HIGH,"",ImVec4(0.5f,0.8f,1.0f,1.0f)),

  D(GUI_COLOR_PATCHBAY_PORTSET,"",ImVec4(0.25f,0.25f,0.25f,1.0f)),
  D(GUI_COLOR_PATCHBAY_PORT,"",ImVec4(0.3f,0.4f,0.6f,1.0f)),
  D(GUI_COLOR_PATCHBAY_PORT_HIDDEN,"",ImVec4(0.4f,0.4f,0.4f,1.0f)),
  D(GUI_COLOR_PATCHBAY_CONNECTION,"",ImVec4(0.3f,0.55f,0.8f,1.0f)),
  D(GUI_COLOR_PATCHBAY_CONNECTION_BG,"",ImVec4(0.1f,0.25f,0.3f,1.0f)),
  D(GUI_COLOR_PATCHBAY_CONNECTION_HI,"",ImVec4(0.2f,1.0f,1.0f,1.0f)),

  D(GUI_COLOR_MEMORY_BG,"",ImVec4(0.12f,0.12f,0.12f,1.0f)),
  D(GUI_COLOR_MEMORY_DATA,"",ImVec4(1.0f,1.0f,1.0f,0.8f)),
  D(GUI_COLOR_MEMORY_FREE,"",ImVec4(0.25f,0.25f,0.25f,1.0f)),
  D(GUI_COLOR_MEMORY_PADDING,"",ImVec4(0.25f,0.25f,0.25f,1.0f)),
  D(GUI_COLOR_MEMORY_RESERVED,"",ImVec4(0.5f,0.5f,0.6f,1.0f)),
  D(GUI_COLOR_MEMORY_SAMPLE,"",ImVec4(1.0f,1.0f,0.2f,1.0f)),
  D(GUI_COLOR_MEMORY_SAMPLE_ALT1,"",ImVec4(0.5f,1.0f,0.2f,1.0f)),
  D(GUI_COLOR_MEMORY_SAMPLE_ALT2,"",ImVec4(0.2f,1.0f,0.2f,1.0f)),
  D(GUI_COLOR_MEMORY_SAMPLE_ALT3,"",ImVec4(0.2f,1.0f,0.5f,1.0f)),
  D(GUI_COLOR_MEMORY_WAVE_RAM,"",ImVec4(1.0f,0.5f,0.1f,1.0f)),
  D(GUI_COLOR_MEMORY_WAVE_STATIC,"",ImVec4(1.0f,0.3f,0.1f,1.0f)),
  D(GUI_COLOR_MEMORY_ECHO,"",ImVec4(0.2f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_MEMORY_N163_LOAD,"",ImVec4(1.0f,0.5f,0.1f,1.0f)),
  D(GUI_COLOR_MEMORY_N163_PLAY,"",ImVec4(1.0f,1.0f,0.2f,1.0f)),
  D(GUI_COLOR_MEMORY_BANK0,"",ImVec4(1.0f,0.1f,0.1f,1.0f)),
  D(GUI_COLOR_MEMORY_BANK1,"",ImVec4(1.0f,0.5f,0.1f,1.0f)),
  D(GUI_COLOR_MEMORY_BANK2,"",ImVec4(1.0f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_MEMORY_BANK3,"",ImVec4(0.1f,1.0f,0.1f,1.0f)),
  D(GUI_COLOR_MEMORY_BANK4,"",ImVec4(0.1f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_MEMORY_BANK5,"",ImVec4(0.1f,0.1f,1.0f,1.0f)),
  D(GUI_COLOR_MEMORY_BANK6,"",ImVec4(0.5f,0.1f,1.0f,1.0f)),
  D(GUI_COLOR_MEMORY_BANK7,"",ImVec4(1.0f,0.1f,1.0f,1.0f)),

  D(GUI_COLOR_LOGLEVEL_ERROR,"",ImVec4(1.0f,0.2f,0.2f,1.0f)),
  D(GUI_COLOR_LOGLEVEL_WARNING,"",ImVec4(1.0f,1.0f,0.2f,1.0f)),
  D(GUI_COLOR_LOGLEVEL_INFO,"",ImVec4(0.4f,1.0f,0.4f,1.0f)),
  D(GUI_COLOR_LOGLEVEL_DEBUG,"",ImVec4(0.3f,0.5f,1.0f,1.0f)),
  D(GUI_COLOR_LOGLEVEL_TRACE,"",ImVec4(0.8f,0.8f,0.8f,1.0f)),

  D(GUI_COLOR_EE_VALUE,"",ImVec4(0.0f,1.0f,1.0f,1.0f)),
  D(GUI_COLOR_PLAYBACK_STAT,"",ImVec4(0.6f,0.6f,0.6f,1.0f)),
};
#undef D

// define chips here

// all chips
const int availableSystems[]={
  DIV_SYSTEM_YM2612,
  DIV_SYSTEM_YM2612_EXT,
  DIV_SYSTEM_YM2612_CSM,
  DIV_SYSTEM_YM2612_DUALPCM,
  DIV_SYSTEM_YM2612_DUALPCM_EXT,
  DIV_SYSTEM_SMS,
  DIV_SYSTEM_GB,
  DIV_SYSTEM_PCE,
  DIV_SYSTEM_NES,
  DIV_SYSTEM_C64_8580,
  DIV_SYSTEM_C64_6581,
  DIV_SYSTEM_C64_PCM,
  DIV_SYSTEM_YM2151,
  DIV_SYSTEM_SEGAPCM,
  DIV_SYSTEM_SEGAPCM_COMPAT,
  DIV_SYSTEM_YM2610,
  DIV_SYSTEM_YM2610_EXT,
  DIV_SYSTEM_YM2610_FULL,
  DIV_SYSTEM_YM2610_FULL_EXT,
  DIV_SYSTEM_YM2610_CSM,
  DIV_SYSTEM_YM2610B,
  DIV_SYSTEM_YM2610B_EXT,
  DIV_SYSTEM_YM2610B_CSM,
  DIV_SYSTEM_T6W28,
  DIV_SYSTEM_AY8910,
  DIV_SYSTEM_AMIGA,
  DIV_SYSTEM_PCSPKR,
  DIV_SYSTEM_POKEMINI,
  DIV_SYSTEM_SFX_BEEPER,
  DIV_SYSTEM_SFX_BEEPER_QUADTONE,
  DIV_SYSTEM_YMU759,
  DIV_SYSTEM_DUMMY,
  DIV_SYSTEM_SOUND_UNIT,
  DIV_SYSTEM_YM2203,
  DIV_SYSTEM_YM2203_EXT,
  DIV_SYSTEM_YM2203_CSM,
  DIV_SYSTEM_YM2608,
  DIV_SYSTEM_YM2608_EXT,
  DIV_SYSTEM_YM2608_CSM,
  DIV_SYSTEM_OPLL,
  DIV_SYSTEM_OPLL_DRUMS,
  DIV_SYSTEM_VRC7,
  DIV_SYSTEM_OPL,
  DIV_SYSTEM_OPL_DRUMS,
  DIV_SYSTEM_Y8950,
  DIV_SYSTEM_Y8950_DRUMS,
  DIV_SYSTEM_OPL2,
  DIV_SYSTEM_OPL2_DRUMS,
  DIV_SYSTEM_OPL3,
  DIV_SYSTEM_OPL3_DRUMS,
  DIV_SYSTEM_OPZ,
  DIV_SYSTEM_TIA,
  DIV_SYSTEM_SAA1099,
  DIV_SYSTEM_AY8930,
  DIV_SYSTEM_POKEY,
  DIV_SYSTEM_LYNX,
  DIV_SYSTEM_QSOUND,
  DIV_SYSTEM_X1_010,
  DIV_SYSTEM_SWAN,
  DIV_SYSTEM_VBOY,
  DIV_SYSTEM_VERA,
  DIV_SYSTEM_BUBSYS_WSG,
  DIV_SYSTEM_N163,
  DIV_SYSTEM_PET,
  DIV_SYSTEM_VIC20,
  DIV_SYSTEM_VRC6,
  DIV_SYSTEM_FDS,
  DIV_SYSTEM_MMC5,
  DIV_SYSTEM_ES5506,
  DIV_SYSTEM_SCC,
  DIV_SYSTEM_SCC_PLUS,
  DIV_SYSTEM_YMZ280B,
  DIV_SYSTEM_NAMCO,
  DIV_SYSTEM_NAMCO_15XX,
  DIV_SYSTEM_NAMCO_CUS30,
  DIV_SYSTEM_MSM6258,
  DIV_SYSTEM_MSM6295,
  DIV_SYSTEM_RF5C68,
  DIV_SYSTEM_SNES,
  DIV_SYSTEM_MSM5232,
  DIV_SYSTEM_K007232,
  DIV_SYSTEM_GA20,
  DIV_SYSTEM_SM8521,
  DIV_SYSTEM_PV1000,
  DIV_SYSTEM_K053260,
  DIV_SYSTEM_TED,
  DIV_SYSTEM_C140,
  DIV_SYSTEM_C219,
  DIV_SYSTEM_GBA_DMA,
  DIV_SYSTEM_GBA_MINMOD,
  DIV_SYSTEM_PCM_DAC,
  DIV_SYSTEM_ESFM,
  DIV_SYSTEM_PONG,
  DIV_SYSTEM_POWERNOISE,
  DIV_SYSTEM_DAVE,
  DIV_SYSTEM_NDS,
  DIV_SYSTEM_5E01,
  DIV_SYSTEM_BIFURCATOR,
  DIV_SYSTEM_SID2,
  DIV_SYSTEM_OPL4,
  DIV_SYSTEM_OPL4_DRUMS,
  DIV_SYSTEM_SUPERVISION,
  DIV_SYSTEM_UPD1771C,
  DIV_SYSTEM_SID3,
  0 // don't remove this last one!
};

// FM
const int chipsFM[]={
  DIV_SYSTEM_YM2612,
  DIV_SYSTEM_YM2612_EXT,
  DIV_SYSTEM_YM2612_CSM,
  DIV_SYSTEM_YM2612_DUALPCM,
  DIV_SYSTEM_YM2612_DUALPCM_EXT,
  DIV_SYSTEM_YM2151,
  DIV_SYSTEM_YM2610,
  DIV_SYSTEM_YM2610_EXT,
  DIV_SYSTEM_YM2610_FULL,
  DIV_SYSTEM_YM2610_FULL_EXT,
  DIV_SYSTEM_YM2610_CSM,
  DIV_SYSTEM_YM2610B,
  DIV_SYSTEM_YM2610B_EXT,
  DIV_SYSTEM_YM2610B_CSM,
  DIV_SYSTEM_YMU759,
  DIV_SYSTEM_YM2203,
  DIV_SYSTEM_YM2203_EXT,
  DIV_SYSTEM_YM2203_CSM,
  DIV_SYSTEM_YM2608,
  DIV_SYSTEM_YM2608_EXT,
  DIV_SYSTEM_YM2608_CSM,
  DIV_SYSTEM_OPLL,
  DIV_SYSTEM_OPLL_DRUMS,
  DIV_SYSTEM_VRC7,
  DIV_SYSTEM_OPL,
  DIV_SYSTEM_OPL_DRUMS,
  DIV_SYSTEM_Y8950,
  DIV_SYSTEM_Y8950_DRUMS,
  DIV_SYSTEM_OPL2,
  DIV_SYSTEM_OPL2_DRUMS,
  DIV_SYSTEM_OPL3,
  DIV_SYSTEM_OPL3_DRUMS,
  DIV_SYSTEM_OPZ,
  DIV_SYSTEM_ESFM,
  DIV_SYSTEM_OPL4,
  DIV_SYSTEM_OPL4_DRUMS,
  0 // don't remove this last one!
};

// square
const int chipsSquare[]={
  DIV_SYSTEM_SMS,
  DIV_SYSTEM_AY8910,
  DIV_SYSTEM_PCSPKR,
  DIV_SYSTEM_POKEMINI,
  DIV_SYSTEM_SAA1099,
  DIV_SYSTEM_VIC20,
  DIV_SYSTEM_MSM5232,
  DIV_SYSTEM_T6W28,
  DIV_SYSTEM_PV1000,
  DIV_SYSTEM_TED,
  0 // don't remove this last one!
};

// wavetable
const int chipsWave[]={
  DIV_SYSTEM_PCE,
  DIV_SYSTEM_X1_010,
  DIV_SYSTEM_SWAN,
  DIV_SYSTEM_VBOY,
  DIV_SYSTEM_BUBSYS_WSG,
  DIV_SYSTEM_N163,
  DIV_SYSTEM_FDS,
  DIV_SYSTEM_SCC,
  DIV_SYSTEM_SCC_PLUS,
  DIV_SYSTEM_NAMCO,
  DIV_SYSTEM_NAMCO_15XX,
  DIV_SYSTEM_NAMCO_CUS30,
  0 // don't remove this last one!
};

// specialized
const int chipsSpecial[]={
  DIV_SYSTEM_GB,
  DIV_SYSTEM_NES,
  DIV_SYSTEM_C64_8580,
  DIV_SYSTEM_C64_6581,
  DIV_SYSTEM_C64_PCM,
  DIV_SYSTEM_SFX_BEEPER,
  DIV_SYSTEM_SFX_BEEPER_QUADTONE,
  DIV_SYSTEM_DUMMY,
  DIV_SYSTEM_SOUND_UNIT,
  DIV_SYSTEM_TIA,
  DIV_SYSTEM_AY8930,
  DIV_SYSTEM_POKEY,
  DIV_SYSTEM_LYNX,
  DIV_SYSTEM_VERA,
  DIV_SYSTEM_PET,
  DIV_SYSTEM_VRC6,
  DIV_SYSTEM_MMC5,
  DIV_SYSTEM_SM8521,
  DIV_SYSTEM_POWERNOISE,
  DIV_SYSTEM_DAVE,
  DIV_SYSTEM_NDS,
  DIV_SYSTEM_5E01,
  DIV_SYSTEM_BIFURCATOR,
  DIV_SYSTEM_SID2,
  DIV_SYSTEM_SUPERVISION,
  DIV_SYSTEM_UPD1771C,
  DIV_SYSTEM_SID3,
  0 // don't remove this last one!
};

// sample
const int chipsSample[]={
  DIV_SYSTEM_SEGAPCM,
  DIV_SYSTEM_SEGAPCM_COMPAT,
  DIV_SYSTEM_AMIGA,
  DIV_SYSTEM_QSOUND,
  DIV_SYSTEM_X1_010,
  DIV_SYSTEM_YMZ280B,
  DIV_SYSTEM_MSM6258,
  DIV_SYSTEM_MSM6295,
  DIV_SYSTEM_RF5C68,
  DIV_SYSTEM_SNES,
  DIV_SYSTEM_K007232,
  DIV_SYSTEM_GA20,
  DIV_SYSTEM_PCM_DAC,
  DIV_SYSTEM_ES5506,
  DIV_SYSTEM_K053260,
  DIV_SYSTEM_C140,
  DIV_SYSTEM_C219,
  DIV_SYSTEM_NDS,
  DIV_SYSTEM_GBA_DMA,
  DIV_SYSTEM_GBA_MINMOD,
  DIV_SYSTEM_OPL4,
  DIV_SYSTEM_OPL4_DRUMS,
  0 // don't remove this last one!
};

const int* chipCategories[]={
  availableSystems,
  chipsFM,
  chipsSquare,
  chipsWave,
  chipsSpecial,
  chipsSample,
  NULL
};

const char* chipCategoryNames[]={
  _N("All chips"),
  _N("FM"),
  _N("Square"),
  _N("Wavetable"),
  _N("Special"),
  _N("Sample"),
  NULL
};
