# 사전 데이터 관리

## 국립국어원 사전

- 국립국어원의 한국어기초사전, 표준국어대사전은 다운로드한 XML을 편집 가능한
  형태로 저장해 관리됩니다.

- 가져오기 스크립트를 통해 국립국어원 데이터를 가져와 기록합니다. 이 가져온
  부분은 수동으로 수정하지 않습니다. 만약 원본에서 필요한 정보가 더 있다면
  가져오기 코드를 수정하고, 원본 데이터에 오류가 있다면 가져오는 과정이나
  아니면 재처리하는 과정에서 보완하거나 추가적인 정보를 서술하는 방법으로
  피해갑니다.

- 국립국어원 사전에서 모든 내용을 가져올 필요는 없습니다. 맞춤법 검사에서
  명백히 의미가 없는 정보는 (단어가 아닌 구, 속담 정보 항목. 한국어기초사전의
  다국어 정보) 가져오지 않습니다. 하지만 당장 hunspell 사전에 사용하지
  않더라도 사람이 편집할 때 원본 XML을 참고하지 않아도 되도록 충분한 정보를
  가져옵니다. (단어 설명, 단어 관계, 예문 등) 이러한 정보는 단어의 문법 관계를
  자동으로 유추하는데도 도움이 됩니다.

- 한국어기초사전에서는 모든 단어를 가져옵니다.

- 표준국어대사전에서는 미리 지정한 단어만 가져옵니다.

- 표준국어대사전 예문 중 출처가 언급된 경우는 (<source> 태그) 신문이나 문학
  작품 등 기존의 문헌에서 인용한 경우로, 공정 사용의 차원에서 사용되었을 뿐
  자유로운 활용이 불가능합니다. 이 부분은 제외합니다.

## 수동 편집

- 수동으로 추가하는 단어는 최소화하고 가능한한 국립국어원 사전 항목을
  사용합니다. 국립국어원 사전의 편집 방향 때문에 누락된 단어 (고유 명사 등),
  명백히 누락된 단어, 구현의 기술적인 어려움 등 때문에 새로운 단어를 추가할 수
  있지만 표준어 규정에 어긋난 단어를 추가하지는 않습니다.

- FIXME: verify

## 파일의 구조

- 폴더의 파일 개수가 너무 많아지지 않도록 저장합니다.
  entries/<첫음절받침제외>.yaml entries/<첫음절받침제외>-legacy.yaml

- "import" 아래에는 스크립트를 통해 외부에서 가져온 데이터가 들어 있습니다.

- "result" 아래에는 최종적으로 사용할 데이터가 들어 있습니다. 만약 이 정보가
  올바르지 않으면 "manual" 항목을 만들어서 자동으로 유추한 정보를 덮어쓸 수
  있습니다. 이 경우 처리 스크립트는 기존 "result" 내용을 "import_derived"에
  옮기고, "manual"이 반영된 최종 내용을 "result" 항목에 씁니다.

```
import:
  한국어기초사전:
    ID: 123456
    표제어: 단어
    품사: 명사
    ...
import_derived:
  맞춤법 검사:
    표제어: 딛다
    품사: 동사
    속성:
    - ㅅ불규칙 미확정
manual:
  맞춤법 검사:
    속성:
    - ㅅ불규칙
result:
  맞춤법 검사:
    표제어: 딛다
    품사: 동사
    속성:
    - ㅅ불규칙
```

## 관리 스크립트 사용

### 요약 파일 빌드

```make build```

### 한국어기초사전 가져오기

 * 한국어기초사전 사이트에서 "자세히 찾기"로 전체 단어를 검색한 후 "사전
   내려받기"를 눌러 XML 포맷으로 다운로드합니다. 진행이 완료되면 ZIP 파일을
   다운로드할 수 있습니다.

 * 다운로드한 파일이 123456.zip 파일이라고 할 때 다음을 실행해 가져옵니다.

 ```python3 scripts/import-krdict.py ../../123456.zip'

 * 단어가 한국어기초사전에서 제외된 경우는 처리하지 못합니다. 그런 경우
   '가져온 시각'이 과거 시각인지를 비교해서 알 수 있습니다.

### 표준국어대사전 가져오기

 * 표준국어대사전 사이트에서 "자세히 찾기"로 전체 단어를 검색한 후 "사전
   내려받기"를 눌러 XML 포맷으로 다운로드합니다. 진행이 완료되면 ZIP 파일을
   다운로드할 수 있습니다.

 * 다운로드한 파일이 123456.zip 파일이라고 할 때 다음을 실행해 가져옵니다.

 ```python3 scripts/import-stdict.py ../../123456.zip scripts/import-stdict-words.csv```

## 데이터 처리

```make process```

가져온 여러가지 데이터에서 필요한 단어 정보만 추출하거나 유추해 YAML 파일에
끼워 넣습니다.
