#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:vincent.vole@example.com"
SENDER="mailto:paul.boddie@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"

mkdir -p "$PREFS/$SENDER"
echo 'Europe/Oslo' > "$PREFS/$SENDER/TZID"

# Test free/busy responses.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/fb-request-person-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/fb-request-person.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& ! grep -q '^FREEBUSY' out1.tmp \
&& echo "Success" \
|| echo "Failed"

# Publish an event, testing registration in the outgoing handler.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out1f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out1f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test registration in the incoming handler for the recipient.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   ! grep -q 'METHOD:REPLY' out2.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out2f.tmp

   ! grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out2f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out2o.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out2o.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test acceptance and registration in the outgoing handler.

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER" "event8@example.com" 2>> $ERROR \
| tee out3.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out3f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out3f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test recurrence cancellation in the outgoing handler.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-person-recurring-instance.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out3s.tmp

   [ `grep "event8@example.com" "out3s.tmp" | wc -l` = '2' ] \
&& ! grep -q "^20141114T090000Z${TAB}20141114T100000Z" "out3s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test cancellation in the incoming handler.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-person-recurring-instance.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out4.tmp

   ! grep -q 'METHOD:REPLY' out4.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out4f.tmp

   [ `grep "event8@example.com" "out4f.tmp" | wc -l` = '2' ] \
&& ! grep -q "^20141114T090000Z${TAB}20141114T100000Z" "out4f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out4o.tmp

   [ `grep "event8@example.com" "out4o.tmp" | wc -l` = '2' ] \
&& ! grep -q "^20141114T090000Z${TAB}20141114T100000Z" "out4o.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test rescheduling in the outgoing handler.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring-reschedule-instance.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out4s.tmp

   grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out4s.tmp" \
&& ! grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out4s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test rescheduling in the incoming handler.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring-reschedule-instance.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out5.tmp

   ! grep -q 'METHOD:REPLY' out5.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out5f.tmp

   ! grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out5f.tmp" \
&& grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out5f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out5o.tmp

   grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out5o.tmp" \
&& ! grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out5o.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test rescheduling acceptance in the outgoing handler.

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER" "event8@example.com" "20141010T080000Z" 2>> $ERROR \
| tee out6.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out6f.tmp

   grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out6f.tmp" \
&& ! grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out6f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test complete cancellation in the outgoing handler.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-person-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out6s.tmp

   ! grep -q "event8@example.com" "out6s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test complete cancellation in the incoming handler.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-person-recurring.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out7.tmp

   ! grep -q 'METHOD:REPLY' out7.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out7f.tmp

   ! grep -q "event8@example.com" "out7f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out7o.tmp

   ! grep -q "event8@example.com" "out7o.tmp" \
&& echo "Success" \
|| echo "Failed"

# Switch time zones.

echo 'Europe/Mariehamn' > "$PREFS/$USER/TZID"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out7s.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out7s.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out8.tmp

   ! grep -q 'METHOD:REPLY' out8.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out8f.tmp

   ! grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out8f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out8o.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out8o.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER" "event8@example.com" 2>> $ERROR \
| tee out9.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out9f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out9f.tmp" \
&& echo "Success" \
|| echo "Failed"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-person-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out9s.tmp

   ! grep -q "event8@example.com" "out9s.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-person-recurring.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out10.tmp

   ! grep -q 'METHOD:REPLY' out10.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out10f.tmp

   ! grep -q "event8@example.com" "out10f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out10o.tmp

   ! grep -q "event8@example.com" "out10o.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test floating dates. Here, the outgoing interpretation is different because
# the sender is in a different time zone.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring-day-floating.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out10s.tmp

   grep -q "^20141211T230000Z${TAB}20141212T230000Z" "out10s.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring-day-floating.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out11.tmp

   ! grep -q 'METHOD:REPLY' out11.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out11f.tmp

   ! grep -q "^20141211T220000Z${TAB}20141212T220000Z" "out11f.tmp" \
&& echo "Success" \
|| echo "Failed"

# (The organiser is not attending.)

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out11o.tmp

   ! grep -q "^20141211T220000Z${TAB}20141212T220000Z" "out11o.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER" "event12@example.com" 2>> $ERROR \
| tee out12.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out12f.tmp

   grep -q "^20141211T220000Z${TAB}20141212T220000Z" "out12f.tmp" \
&& echo "Success" \
|| echo "Failed"
