.nr PS 9
.nr VS 11
.de V1
.ft CW
.nf
..
.de V2
.fi
.ft R
..
.de LS
.br
.in +2
..
.de LE
.br
.sp .5v
.in -2
..
.ND February 1993
.TL
Guide to the Slit Spectra Reduction Task DOECSLIT
.AU
Francisco Valdes
.AI
IRAF Group - Central Computer Services
.K2
.DY

.AB
\fBDoecslit\fR subtracts background sky or scattered light, extracts,
wavelength calibrates, and flux calibrates multiorder echelle slit spectra
which have been processed to remove the detector characteristics; i.e. CCD
images have been bias, dark count, and flat field corrected.  The spectra
should be oriented such that pixels of constant wavelength are aligned with
the image columns or lines.  Small departures from this alignment are not
critical resulting in only a small loss of resolution.  Single order
observations should be reduced with \fBdoslit\fR.
.AE
.NH
Introduction
.LP
\fBDoecslit\fR subtracts background sky or scattered light, extracts,
wavelength calibrates, and flux calibrates multiorder echelle slit spectra
which have been processed to remove the detector characteristics; i.e. CCD
images have been bias, dark count, and flat field corrected.  The spectra
should be oriented such that pixels of constant wavelength are aligned with
the image columns or lines.  Small departures from this alignment are not
critical resulting in only a small loss of resolution.  Single order
observations should be reduced with \fBdoslit\fR.
.LP
The task is a command language script which collects and combines the
functions and parameters of many general purpose tasks to provide a single,
complete data reduction path and a degree of guidance, automation, and
record keeping.  In the following description and in the parameter section
the various general tasks used are identified.  Further
information about those tasks and their parameters may be found in their
documentation.  \fBDoecslit\fR also simplifies and consolidates parameters
from those tasks and keeps track of previous processing to avoid
duplications.
.LP
The general organization of the task is to do the interactive setup steps,
such as the aperture definitions and reference dispersion function
determination, first using representative calibration data and then perform
the majority of the reductions automatically, possibly as a background
process, with reference to the setup data.  In addition, the task
determines which setup and processing operations have been completed in
previous executions of the task and, contingent on the \f(CWredo\fR and
\f(CWupdate\fR options, skip or repeat some or all the steps.
.LP
The description is divided into a quick usage outline followed by details
of the parameters and algorithms.  The usage outline is provided as a
checklist and a refresher for those familiar with this task and the
component tasks.  It presents only the default or recommended usage
since there are many variations possible.
.NH
Usage Outline
.LP
.IP [1] 6
The images are first processed with \fBccdproc\fR for overscan,
zero level, dark count, and flat field corrections.
.IP [2]
Set the \fBdoecslit\fR parameters with \fBeparam\fR.  Specify the object
images to be processed, an aperture reference image (usually a bright
star spectrum) to use in finding the orders and defining the
aperture parameters, one or more arc images, and one or more standard
star images.  If there are many object, arc, or standard star images
you might prepare "@ files".  Set the detector and data
specific parameters.  Select the processing options desired.
Finally you might wish to review the \fBsparams\fR algorithm parameters
though the defaults are probably adequate.
.IP [3]
Run the task.  This may be repeated multiple times with different
observations and the task will generally only do the setup steps
once and only process new images.  Queries presented during the
execution for various interactive operations may be answered with
"yes", "no", "YES", or "NO".  The lower case responses apply just
to that query while the upper case responses apply to all further
such queries during the current execution and no further queries of that
type will be made.
.IP [4]
The specified number of orders (ranked by peak strength) in the aperture
reference image are located and default fixed width apertures are
assigned.  If the resize option is set the apertures are resized by finding
the level which is 5% (the default) of the peak above local background.
You then have the option of entering the aperture editing loop to check the
aperture positions, sizes, and background fitting parameters.  This is
highly recommended.  Note that it is important that the aperture numbers be
sequential with the orders and if any orders are skipped the aperture
numbers should also skip.  It is also important to verify the background
regions with the 'b' key.  Usually you want any changes made to the
background definitions to apply to all apertures so use the 'a' key to
select all apertures before modifying the background parameters.  To exit
the background mode and then to exit the review mode use 'q'.
.IP [5]
The order positions at a series of points along the dispersion are measured
and a function is fit to these positions.  This may be done interactively
to examine the traced positions and adjust the fitting parameters.  To exit
the interactive fitting type 'q'.  Not all orders need be examined and the
"NO" response will quit the interactive fitting using the last defined
fitting parameters on the remaining traces.
.IP [6]
Apertures are now defined for all standard and object images.  This is only
done if there are no previous aperture definitions for the image.  The
aperture references previously defined are used as the initial set of
apertures for each image.  The apertures are then recentered by an average
shift over all orders and resized if that option is selected.
The apertures may also be retraced and interactively examined
for each image if the tracing option is selected and quicklook mode is not.
.IP [7]
If scattered light subtraction is selected the scattered light parameters
are set using the aperture reference image and the task \fBapscatter\fR.
The purpose of this is to interactively define the aperture buffer distance
for the scattered light and the cross and parallel dispersion fitting
parameters.  The fitting parameters are taken from and recorded in the
parameter sets \fBapscat1\fR and \fBapscat2\fR.  All other scattered light
subtractions are done noninteractively with these parameters.  Note that
the scattered light correction modifies the input images.  Scattered light
subtraction is not done in quicklook mode.
.IP [8]
If dispersion correction is selected the first arc in the arc list is
extracted.  The dispersion function is defined using the task
\fBecidentify\fR.  Identify a few arc lines in a few orders with 'm' and 'o'
and use the 'l' line list identification command to automatically add
additional lines and fit the dispersion function.  Check the quality of the
dispersion function fit with 'f'.  When satisfied exit with 'q'.
.IP [9]
If the flux calibration option is selected the standard star spectra are
processed (if not done previously).  The images are background subtracted,
extracted, and wavelength calibrated.  The appropriate arc
calibration spectra are extracted and the dispersion function refit
using the arc reference spectrum as a starting point.  The standard star
fluxes through the calibration bandpasses are compiled.  You are queried
for the name of the standard star calibration data file.  Because echelle
spectra are often at much higher dispersion than the calibration data
interpolated bandpasses may be defined with the bandpass parameters in
\fBsparams\fR and checked or modified interactively.
.IP
After all the standard stars are processed a sensitivity function is
determined using the interactive task \fBsensfunc\fR.  Finally, the
standard star spectra are extinction corrected and flux calibrated
using the derived sensitivity function.
.IP [10]
The object spectra are now automatically background subtracted
(an alternative to scattered light subtraction),
extracted, wavelength calibrated, and flux calibrated.
.IP [11]
The option to examine the final spectra with \fBsplot\fR may be given.
To exit type 'q'.  In quicklook mode the spectra are plotted
noninteractively with \fBspecplot\fR.
.IP [12]
The final spectra will have the same name as the original 2D images
with a ".ec" extension added.
.NH
Spectra and Data Files
.LP
The basic input consists of echelle slit object, standard star, and arc
calibration spectra stored as IRAF images.
The type of image format is defined by the
environment parameter \fIimtype\fR.  Only images with that extension will
be processed and created.
The raw CCD images must be
processed to remove overscan, bias, dark count, and flat field effects.
This is generally done using the \fBccdred\fR package.  Flat fields which
are not contaminated by low counts between the apertures may be prepared
with the task \fBapflatten\fR (recommended) or \fBapnormalize\fR.  Lines of
constant wavelength across the orders should be closely aligned with one of
the image axes.  Sometimes the orders are aligned rather than the spectral
features.  This will result in a small amount of resolution loss but is
often acceptable.  In some cases one may correct for misalignment with the
\fBrotate\fR task.  More complex geometric problems and observations of
extended objects should be handled by the \fBlongslit\fR package and single
order observations should be processed by \fBdoslit\fR.
.LP
The aperture reference spectrum is generally a bright star.  The arc
spectra are comparison arc lamp observations (they must all be of the same
type).  The assignment of arc calibration exposures to object exposures is
generally done by selecting the nearest in time and interpolating.
However, the optional \fIarc assignment table\fR may be used to explicitly
assign arc images to specific objects.  The format of this file is
described in task \fBrefspectra\fR.
.LP
The final reduced spectra are recorded in two or three dimensional IRAF
images.  The images have the same name as the original images with an added
".ec" extension.  Each line in the reduced image is a one dimensional
spectrum with associated aperture, order, and wavelength
information.  When the \f(CWextras\fR parameter is set the lines in the
third dimension contain additional information (see
\fBapsum\fR for further details).  These spectral formats are accepted by the
one dimensional spectroscopy tasks such as the plotting tasks \fBsplot\fR
and \fBspecplot\fR.  The special task \fBscopy\fR may be used to extract
specific apertures or to change format to individual one dimensional
images.  The task \fBscombine\fR is used to combine or merge orders into
a single spectrum.
.NH
Package Parameters
.LP
The \fBechelle\fR package parameters, shown in Figure 1, set parameters
which change infrequently and define the standard I/O functions.
.KS

.ce
Figure 1: Package Parameter Set for the ECHELLE Package

.V1
cl> epar echelle
                           I R A F
            Image Reduction and Analysis Facility
PACKAGE = imred
   TASK = echelle

(extinct= onedstds$kpnoextinct.dat) Extinction file
(caldir = onedstds$spechayescal/) Standard star calibration directory
(observa=  observatory) Observatory of data
(interp =        poly5) Interpolation type
(dispaxi=            2) Image axis for 2D images
(nsum   =            1) Number of lines/columns to sum for 2D images

(databas=     database) Database
(verbose=          no) Verbose output?
(logfile=      logfile) Text log file
(plotfil=             ) Plot file

(records=                     ) Record number extensions
(version= ECHELLE V3: July 1991)

.KE
.V2
The extinction file
is used for making extinction corrections and the standard star
calibration directory is used for determining flux calibrations from
standard star observations.  The calibration directories contain data files
with standard star fluxes and band passes.  The available extinction
files and flux calibration directories may be listed using the command:
.V1

	cl> page onedstds$README

.V2
The extinction correction requires computation of an air mass using the
task \fBsetairmass\fR.  The air mass computation needs information
about the observation and, in particular, the latitude of the observatory.
This is determined using the OBSERVAT image header keyword.  If this
keyword is not present the observatory parameter is used.  See the
task \fBobservatory\fR for more on defining the observatory parameters.
.LP
The spectrum interpolation type is used whenever a spectrum needs to be
resampled for linearization or performing operations between spectra
with different sampling.  The "sinc" interpolation may be of interest
as an alternative but see the cautions given in \fBonedspec.package\fR.
.LP
The verbose parameter selects whether to print everything which goes
into the log file on the terminal.  It is useful for monitoring
everything that the task does.  The log and plot files are useful for
keeping a record of the processing.  A log file is highly recommended.
A plot file provides a record of the apertures, traces, and extracted
spectra but can become quite large.
.NH
Processing Parameters
.LP
The \fBdoecslit\fR parameters are shown in Figure 2.
.KS

.ce
Figure 2: Parameter Set for DOECSLIT

.V1
                           I R A F
            Image Reduction and Analysis Facility
PACKAGE = echelle
   TASK = doecslit

objects =               List of object spectra
(apref  =             ) Aperture reference spectrum
(arcs   =             ) List of arc spectra
(arctabl=             ) Arc assignment table (optional)
(standar=             ) List of standard star spectra
.KE
.V1

(readnoi=           0.) Read out noise sigma (photons)
(gain   =           1.) Photon gain (photons/data number)
(datamax=        INDEF) Max data value / cosmic ray threshold
(norders=           10) Number of orders
(width  =           5.) Width of profiles (pixels)

(dispcor=          yes) Dispersion correct spectra?
(extcor =           no) Extinction correct spectra?
(fluxcal=           no) Flux calibrate spectra?
(resize =           no) Resize object apertures?
(clean  =           no) Detect and replace bad pixels?
(trace  =          yes) Trace object spectra?
(backgro=         none) Background to subtract
(splot  =           no) Plot the final spectra?
(redo   =           no) Redo operations if previously done?
(update =           no) Update spectra if cal data changes?
(quicklo=           no) Approximate quicklook reductions?
(batch  =           no) Extract objects in batch?
(listonl=           no) List steps but don't process?

(sparams=             ) Algorithm parameters

.V2
The input images are specified by image lists.  The lists may be
a list of explicit comma separate image names, @ files, or image
templates using pattern matching against file names in the directory.
To allow wildcard image lists to be used safely and conveniently the
image lists are checked to remove extracted images (the .ec images)
and to automatically identify object and arc spectra.  Object and arc
images are identified by the keyword IMAGETYP with values of "object",
"OBJECT", "comp", or "COMPARISON" (the current practice at NOAO).
If arc images are found in the object list they are transferred to the
arc list while if object images are found in the arc list they are ignored.
All other image types, such as biases, darks, or flat fields, are
ignored.  This behavior allows simply specifying all images with a wildcard
in the object list with automatic selections of arc spectra or a
wildcard in the arc list to automatically find the arc spectra.
If the data lack the identifying information it is up to the user
to explicitly set the proper lists.
.LP
As mentioned earlier, all the arc images must be of the same type;
that is taken with the same arc lamp.  The aperture reference parameter
is a single image name which is usually a bright star.
.LP
The next set of parameters describe the noise characteristics and the
general layout of the orders.  The read out noise and gain are used when
"cleaning" cosmic rays and when using variance or optimal weighting.  These
parameters must be fairly accurate.  Note that these are the effective
parameters and must be adjusted if previous processing has modified the
pixel values; such as with an unnormalized flat field.
.LP
The general direction in which the orders run is specified by the
dispersion axis parameter.  Recall that ideally it is the direction
of constant wavelength which should be aligned with an image axis and
the dispersion direction will not be aligned because of the cross-dispersion.
The \f(CWnorders\fR parameter is used to automatically find the orders.  The
specified number of the brightest peaks are found.  Generally after finding the
orders the aperture definitions are reviewed and adjusted interactively.
The profile width should be approximately the full width at the profile
base.  The default aperture limits and background regions are all
derived from this width parameter.
.LP
The next set of parameters select the processing steps and options.  The
various calibration steps may be done simultaneously, that is at the same
time as the basic extractions, or in separate executions of the task.
Typically, all the desired operations are done at the same time.
Dispersion correction requires at least one arc spectrum and flux
calibration requires dispersion correction and at least one standard star
observation.
.LP
The \f(CWresize\fR option resets the edges of the extraction apertures based
on the profile for each object and standard star order.  The default
resizing is to the 5% point relative to the peak measured above the
background.  This allows following changes in the seeing.  However, one
should consider the consequences of this if attempting to flux calibrate
the observations.  Except in quicklook mode, the apertures for each object
and standard star observation may be reviewed graphically and further
adjustments made to the aperture width and background regions.
.LP
The apertures for each observation are adjusted for small shifts relative
to the reference aperture definitions.  If you think this is not sufficient,
say to account for rotation of the detector or for differing atmospheric
dispersion, the \f(CWtrace\fR option allows redefining the aperture trace
functions for each observation.  Note this is only allowed in non-quicklook
mode.
.LP
The \f(CWclean\fR option invokes a profile
fitting and deviant point rejection algorithm as well as a variance weighting
of points in the aperture.  See the next section for more about
requirements to use this option.
.LP
The \f(CWbackground\fR option selects a type of correction for background
or scattered light.  If the type is "scattered" a global scattered light
is fit to the data between the apertures  and subtracted from the images.
\fINote that the input images are modified by this operation\fR.
This option is slow and is not allowed in quicklook
mode.  Alternatively, a local background may be subtracted using
background regions defined for each aperture.  The background may be
within the slit for a sky subtraction or outside of the slit for a
local scattered light subtraction.  The data in the regions
may be averaged, medianed, or the minimum value used.  Another choice
is to fit the data in the background regions by a function and interpolate
to the object aperture.
.LP
Generally once a spectrum has been processed it will not be reprocessed if
specified as an input spectrum.  However, changes to the underlying
calibration data can cause such spectra to be reprocessed if the
\f(CWupdate\fR flag is set.  The changes which will cause an update are a new
reference image, adding the scattered light subtraction option, a new arc
reference image, and new standard stars.  If all input spectra are to be
processed regardless of previous processing the \f(CWredo\fR flag may be
used.  Note that reprocessing clobbers the previously processed output
spectra.
.LP
The final step is to plot the spectra if the \f(CWsplot\fR option is
selected.  In non-quicklook mode there is a query which may be
answered either in lower or upper case.  The plotting uses the interactive
task \fBsplot\fR.  In quicklook mode the plot appears noninteractively
using the task \fBspecplot\fR.  
.LP
The \f(CWquicklook\fR option provides a simpler, less interactive, mode.
The quicklook mode automatically assigns the reference apertures to
the object and standard star observations without interactive review
or tracing, does not do the time consuming scattered light correction,
and the \f(CWsplot\fR option selects a noninteractive plot to be
shown at the end of processing of each object and standard star
spectrum.  While the algorithms used in quicklook mode are nearly the same
as in non-quicklook mode and the final results may be the same it is
recommended that the greater degree of monitoring and review in
non-quicklook mode be used for careful final reductions.
.LP
The batch processing option allows object spectra to be processed as a
background or batch job.  This will occur only if the interactive
\f(CWsplot\fR option is not active; either not set, turned off during
processing with "NO", or in quicklook mode.  In batch processing the
terminal output is suppressed.
.LP
The \f(CWlistonly\fR option prints a summary of the processing steps
which will be performed on the input spectra without actually doing
anything.  This is useful for verifying which spectra will be affected
if the input list contains previously processed spectra.  The listing
does not include any arc spectra which may be extracted to dispersion
calibrate an object spectrum.
.LP
The last parameter (excluding the task mode parameter) points to
another parameter set for the algorithm parameters.  The default
parameter set is called \fBsparams\fR.  The algorithm parameters are
discussed further in the next section.
.NH
Algorithms and Algorithm Parameters
.LP
This section summarizes the various algorithms used by the
\fBdoecslit\fR task and the parameters which control and modify the
algorithms.  The algorithm parameters available to you are
collected in the parameter set \fBsparams\fR.  These parameters are
taken from the various general purpose tasks used by the \fBdoecslit\fR
processing task.  Additional information about these parameters and
algorithms may be found in the help for the actual
task executed.  These tasks are identified below.  The aim of this
parameter set organization is to collect all the algorithm parameters
in one place separate from the processing parameters and include only
those which are relevant for echelle slit data.  The parameter values
can be changed from the defaults by using the parameter editor,
.V1

cl> epar sparams

.V2
or simple typing \f(CWsparams\fR.
The parameter editor can also be entered when editing the \fBdoecslit\fR
parameters by typing \f(CW:e\fR when positioned at the \f(CWsparams\fR
parameter.  Figure 3 shows the parameter set.
.KS

.ce
Figure 3: Algorithm Parameter Set

.V1
cl> epar sparams
                           I R A F
            Image Reduction and Analysis Facility
PACKAGE = echelle
   TASK = sparams

(line   =        INDEF) Default dispersion line
(nsum   =           10) Number of dispersion lines to sum
(extras =           no) Extract sky, sigma, etc.?

                        -- AUTOMATIC APERTURE RESIZING PARAMETERS --
(ylevel =         0.05) Fraction of peak or intensity for resizing
.KE
.V1

                        -- TRACE PARAMETERS --
(t_step =           10) Tracing step
(t_funct=      spline3) Trace fitting function
(t_order=            2) Trace fitting function order
(t_niter=            1) Trace rejection iterations
(t_low  =           3.) Trace lower rejection sigma
(t_high =           3.) Trace upper rejection sigma

                        -- BACKGROUND AND SCATTERED LIGHT PARAMETERS --
(b_funct=     legendre) Background function
(b_order=            1) Background function order
(b_naver=         -100) Background average or median
(b_niter=            0) Background rejection iterations
(b_low  =           3.) Background lower rejection sigma
(b_high =           3.) Background upper rejection sigma
(buffer =           1.) Buffer distance from apertures
(apscat1=             ) Fitting parameters across the dispersion
(apscat2=             ) Fitting parameters along the dispersion

                        -- APERTURE EXTRACTION PARAMETERS --
(weights=         none) Extraction weights (none|variance)
(pfit   =        fit1d) Profile fitting algorithm (fit1d|fit2d)
(lsigma =           3.) Lower rejection threshold
(usigma =           3.) Upper rejection threshold

                                -- ARC DISPERSION FUNCTION PARAMETERS --
(coordli= linelist$thar.dat) Line list
(match  =           1.) Line list matching limit in Angstroms
(fwidth =           4.) Arc line widths in pixels
(cradius=          10.) Centering radius in pixels
(i_funct=     legendre) Echelle coordinate function
(i_xorde=            3) Order of coordinate function along dispersion
(i_yorde=            3) Order of coordinate function across dispersion
(i_niter=            3) Rejection iterations
(i_low  =           3.) Lower rejection sigma
(i_high =           3.) Upper rejection sigma
(refit  =          yes) Refit coordinate function when reidentifying

                        -- AUTOMATIC ARC ASSIGNMENT PARAMETERS --
(select =       interp) Selection method for reference spectra
(sort   =           jd) Sort key
(group  =          ljd) Group key
(time   =           no) Is sort key a time?
(timewra=          17.) Time wrap point for time sorting

                        -- DISPERSION CORRECTION PARAMETERS --
(lineari=          yes) Linearize (interpolate) spectra?
(log    =           no) Logarithmic wavelength scale?
(flux   =          yes) Conserve flux?

                        -- SENSITIVITY CALIBRATION PARAMETERS --
(bandwid=          10.) Bandpass widths
(bandsep=          10.) Bandpass separation
(s_inter=          yes) Graphic interaction to examine/define bandpasses
(s_funct=      spline3) Fitting function
(s_order=            1) Order of sensitivity function
(fnu    =           no) Create spectra having units of FNU?

.V2
.NH 2
Aperture Definitions
.LP
The first operation is to define the extraction apertures, which include the
aperture width, background regions, and position dependence with
wavelength, for the input echelle slit spectra and, if flux calibration is
selected, the standard star spectra.  This is done only for spectra which
do not have previously defined apertures unless the \f(CWredo\fR option is
set to force all definitions to be redone.  Thus, apertures may be
defined separately using the \fBapextract\fR tasks.  This is particularly
useful if one needs to use reference images to define apertures for very
weak spectra which are not well centered or traced by themselves.
.LP
Initially apertures are defined for a specified \fIaperture reference\fR
image.  The selected number of orders are found automatically by selecting
the highest peaks in a cut across the dispersion.  Apertures are assigned
with a width given by the \f(CWwidth\fR parameter and numbered sequentially.
The background regions are also defined in terms of the width parameter
starting at one width distance from the profile center and extending to two
widths on both sides of the profile.  As an example, if the width parameter
is 5 pixels the default aperture limits are +/- 2.5 pixels and the
background sample regions will be "-10:-5,5:10".  If the \f(CWresize\fR
parameter is set the aperture limits are adjusted to a specified point on
the spectrum profile (see \fBapresize\fR).
.LP
A query is then given allowing the aperture definitions to be reviewed and
modified.  Queries made by \fBdoecslit\fR generally may be answered with either
lower case "yes" or "no" or with upper case "YES" or "NO".  The upper
case responses apply to all further queries and so are used to eliminate
further queries of that kind.
.LP
Reviewing the aperture definitions is highly recommended to check the
aperture numbering, aperture limits, and background regions.  The aperture
numbers must be linearly related, with a slope of +/- 1, to the true order
numbers though absolute order numbers need not be known.  The key point is
that if an order is skipped the aperture numbers must also skip.  The
background regions are checked with the 'b' key.  Typically one adjusts all
the background regions at the same time by selecting all apertures with
the 'a' key first.  To exit the background and aperture editing steps type
'q'.
.LP
Next the positions of the orders at various points along the dispersion
are measured and "trace functions" are fit.  The user is asked whether
to fit each trace function interactively.  This is selected to adjust
the fitting parameters such as function type and order.  When
interactively fitting a query is given for each aperture.  After the
first aperture one may skip reviewing the other traces.
.LP
After the aperture reference image is done all the object and standard star
images are checked for aperture definitions and those without definitions
are assigned apertures.  The assignment consists of inheriting the aperture
from the reference aperture image, recentering the apertures based on an
average shift that best centers all the apertures, resizing the apertures
if the resize option is selected, and retracing the spectral orders if the
retracing option is selected.  Retracing is only allowed in non-quicklook
mode (set by the \f(CWquicklook\fR parameter).  Also interactive review of
the aperture definitions is only done in
non-quicklook mode.  In quicklook mode the aperture definitions are all set
noninteractively without retracing.  It is recommended that quicklook only
be used for initial quick extractions and calibration and that for final
reductions one at least review the aperture definitions and possibly
retrace each observation.
.LP
The above steps are all performed using tasks from the \fBapextract\fR
package and parameters from the \fBsparams\fR parameters.  As a quick
summary, the dispersion direction of the spectra are determined from the
package \fBdispaxis\fR parameter if not defined in the image header.  The default
line or column for finding the object position on the slit and the number
of image lines or columns to sum are set by the \f(CWline\fR and \f(CWnsum\fR
parameters.  A line of INDEF (the default) selects the middle of the
image.  The automatic finding algorithm is described for the task
\fBapfind\fR and basically finds the strongest peaks.  The resizing is
described in the task \fBapresize\fR and the parameters used are also
described there.  The tracing is
done as described in \fBaptrace\fR and consists of stepping along the image
using the specified \f(CWt_step\fR parameter.  The function fitting uses the
\fBicfit\fR commands with the other parameters from the tracing section.
.NH 2
Background or Scattered Light Subtraction
.LP
In addition to not subtracting any sky or scattered light there are two
approaches to subtracting background light.  The first is to determine
a smooth global scattered light component.  The second is to subtract
a locally determined background at each point along the dispersion and
for each aperture.  This can be either for a sky subtraction if the
background regions are within the slit or scattered light if the
background regions are outside of the slit.  Note that background
subtraction is only done for object and standard star images and not
for arc spectra.  Also, the global scattered light option is not done
in quicklook mode.
.LP
The global scattered light fitting and subtraction is done with the task
\fBapscatter\fR.  The function fitting parameters are set interactively
using the aperture reference spectrum.  All other subtractions are done
noninteractively with the same set of parameters.  The scattered light is
subtracted from the input images, thus modifying them, and one might wish
to first make backups of the original images.
.LP
The scattered light is measured between the apertures using a specified
buffer distance from the aperture edges.  The scattered light pixels are
fit by a series of one dimensional functions across the dispersion.  The
independent fits are then smoothed along the dispersion by again fitting
low order functions.  These fits then define the smooth scattered light
surface to be subtracted from the image.  The fitting parameters are
defined and recorded in the two parameter sets \f(CWapscat1\fR and
\f(CWapscat2\fR.  The scattered light algorithm is described more fully in
\fBapscatter\fR.  This algorithm is relatively slow.
.LP
Local background subtraction is done during extraction based on background
regions and parameters defined by the default background parameters or
changed during interactive review of the apertures.  The background
subtraction options are to subtract the average, median, or minimum of the
pixels in the background regions, or to fit a function and subtract the
function from under the extracted object pixels.  The background regions
are specified in pixels from the aperture center and follow changes in
center of the spectrum along the dispersion.  The syntax is colon separated
ranges with multiple ranges separated by a comma or space.  The background
fitting uses the \fBicfit\fR routines which include medians, iterative
rejection of deviant points, and a choice of function types and orders.
Note that it is important to use a method which rejects cosmic rays such as
using either medians over all the background regions (\f(CWbackground\fR =
"median") or median samples during fitting (\f(CWb_naverage\fR < -1).  The
background subtraction algorithm and options are described in greater
detail in \fBapsum\fR and \fBapbackground\fR.
.NH 2
Extraction
.LP
The actual extraction of the spectra is done by summing across the
fixed width apertures at each point along the dispersion.
The default is to simply sum the pixels using
partial pixels at the ends.  There is an option to weight the
sum based on a Poisson variance model using the \f(CWreadnoise\fR and
\f(CWgain\fR detector parameters.  Note that if the \f(CWclean\fR
option is selected the variance weighted extraction is used regardless
of the \f(CWweights\fR parameter.  The sigma thresholds for cleaning
are also set in the \fBsparams\fR parameters.
.LP
The cleaning and variance weighting options require knowing the effective
(i.e. accounting for any image combining) read out noise and gain.
These numbers need to be adjusted if the image has been processed
such that the intensity scale has a different origin (such as
a scattered light subtraction) or scaling (such as caused by unnormalized
flat fielding).  These options also require using background subtraction
if the profile does not go to zero.  For optimal extraction and
cleaning to work it is recommended that any flat fielding be done
using flat fields produced by \fBapflatten\fR, no scattered light
correction, and using background subtraction if there is any
appreciable sky or to compensate for scattered light.
For further discussion of cleaning and variance weighted extraction see
\fBapvariance\fR and \fBapprofiles\fR as well as  \fBapsum\fR.
.NH 2
Dispersion Correction
.LP
If dispersion correction is not selected, \f(CWdispcor\fR=no, then the object
spectra are simply extracted.  The extracted spectra may be plotted
by setting the \f(CWsplot\fR option.  This produces a query and uses
the interactive \fBsplot\fR task in non-quicklook mode and uses
\fBspecplot\fR noninteractively in quicklook mode.
.LP
Dispersion corrections are applied to the extracted spectra if the
\f(CWdispcor\fR processing parameter is set.  There
are three basic steps involved; determining the dispersion functions
relating pixel position to wavelength, assigning the appropriate
dispersion function to a particular observation, and either storing
the nonlinear dispersion function in the image headers or resampling the
spectra to evenly spaced pixels in wavelength.
.LP
The first arc spectrum in the arc list is used to define the reference
dispersion solution.  It is extracted using the reference aperture definition.
Note extractions of arc spectra are not background or scattered light
subtracted.  The interactive task \fBecidentify\fR is used to define the
dispersion function.  The idea is to mark some lines in a few orders whose
wavelengths are known (with the line list used to supply additional lines after
the first few identifications define the approximate wavelengths) and to fit a
function giving the wavelength from the aperture number and pixel position.
.LP
The arc dispersion function parameters are for \fBecidentify\fR and it's
related partner \fBecreidentify\fR.  The parameters define a line list for
use in automatically assigning wavelengths to arc lines, a centering width
(which should match the line widths at the base of the lines), the
dispersion function type and orders, parameters to exclude bad lines from
function fits, and defining whether to refit the dispersion function as
opposed to simply determining a zero point shift.  The defaults should
generally be adequate and the dispersion function fitting parameters may be
altered interactively.  One should consult the help for the two tasks for
additional details of these parameters and the interactive operation of
\fBecidentify\fR.
.LP
Once the reference dispersion function is defined other arc spectra are
extracted as required by the object spectra.  The assignment of arcs is
done either explicitly with an arc assignment table (parameter
\f(CWarctable\fR) or based on a header parameter such as a time.
This assignments are made by the task
\fBrefspectra\fR.  When two arcs are assigned to an object spectrum an
interpolation is done between the two dispersion functions.  This makes an
approximate correction for steady drifts in the dispersion.
.LP
The tasks \fBsetjd\fR and \fBsetairmass\fR are automatically run on all
spectra.  This computes and adds the header parameters for the Julian date
(JD), the local Julian day number (LJD), the universal time (UTMIDDLE), and
the air mass at the middle of the exposure.  The default arc assignment is
to use the Julian date grouped by the local Julian day number.  The
grouping allows multiple nights of data to be correctly assigned at the
same time.
.LP
In non-quicklook mode the arc spectra assigned to each object are
extracted using the same apertures as the object.  This accounts for
changes in the recentering, aperture sizes, and tracing functions.
In quicklook mode the arc spectra are extracted using the reference
apertures.  When the same arc is used for several object images this
allows the arc spectrum to only be extracted once.
.LP
Defining the dispersion function for a new arc extraction is done with
the task \fBecreidentify\fR.  This is done noninteractively with log
information recorded about the line reidentifications and the fit.
.LP
The last step of dispersion correction is setting the dispersion
of the object image from the arc images.  There are two choices here.
If the \f(CWlinearize\fR parameter is not set the nonlinear dispersion
function is stored in the image header.  Other IRAF tasks interpret
this information when dispersion coordinates are needed for plotting
or analysis.  This has the advantage of not requiring the spectra
to be interpolated and the disadvantage that the dispersion
information is only understood by IRAF tasks and cannot be readily
exported to other analysis software.
.LP
If the \f(CWlinearize\fR parameter is set then the spectra are resampled to a
linear dispersion relation either in wavelength or the log of the
wavelength.  For echelle spectra each order is linearized independently so
that the wavelength interval per pixel is different in different orders.
This preserves most of the resolution and avoids over or under sampling of
the highest or lowest dispersion orders.  The wavelength limits are
taken from the limits determined from the arc reference spectrum and
the number of pixels is the same as the original images.  The dispersion
per pixel is then derived from these constraints.
.LP
The linearization algorithm  parameters allow selecting the interpolation
function type, whether to conserve flux per pixel by integrating across the
extent of the final pixel, and whether to linearize to equal linear or
logarithmic intervals.  The latter may be appropriate for radial velocity
studies.  The default is to use a fifth order polynomial for interpolation,
to conserve flux, and to not use logarithmic wavelength bins.  These
parameters are described fully in the help for the task \fBdispcor\fR which
performs the correction.
.NH 2
Flux Calibration
.LP
Flux calibration consists of an extinction correction and an instrumental
sensitivity calibration.  The extinction correction only depends on the
extinction function defined by the package parameter \f(CWextinct\fR and
determination of the airmass from the header parameters (the air mass is
computed by \fBsetairmass\fR as mentioned earlier).  The sensitivity
calibration depends on a sensitivity calibration spectrum determined from
standard star observations for which there are tabulated absolute fluxes.
The task that applies both the extinction correction and sensitivity
calibration to each extracted object spectrum is \fBcalibrate\fR.  Consult
the manual page for this task for more information.
.LP
Generation of the sensitivity calibration spectrum is done before
processing any object spectra since it has two interactive steps and
requires all the standard star observations.  The first step is tabulating
the observed fluxes over the same bandpasses as the calibrated absolute
fluxes.  For very high resolution it may be the case that the measured
calibration bandpasses are too large or sparse.  In this case one must
interpolate the calibration data to bandpasses appropriate for the data.
If the bandpass widths and separations are given as INDEF then the same
bandpasses as in the calibration file are used.  Otherwise a uniform grid
of bandpasses is interpolated.  Using interpolated bandpasses is not
rigorous but is sometimes the only choice for echelle spectra.
.LP
The standard star tabulations are done after each standard star is
extracted and dispersion corrected.  You are asked for the name of the
standard star as tabulated in the absolute flux data files in the directory
\f(CWcaldir\fR defined by the package parameters.  If the \f(CWinteract\fR
parameter is yes the bandpasses can be displayed on the data and you can
interactively add or delete bandpasses. The tabulation of the standard star
observations over the standard bandpasses is done by the task
\fBstandard\fR.  The tabulated data is stored in the file \f(CWstd\fR.  Note
that if the \f(CWredo\fR flag is not set any new standard stars specified in
subsequent executions of \fBdoecslit\fR are added to the previous data in
the data file, otherwise the file is first deleted.  Modification of the
tabulated standard star data, such as by adding new stars, will cause any
spectra in the input list which have been previously calibrated to be
reprocessed if the \f(CWupdate\fR flag is set.
.LP
After the standard star calibration bandpass fluxes are tabulated the
information from all the standard stars is combined to produce a
sensitivity function for use by \fBcalibrate\fR.  The sensitivity function
determination is interactive and uses the task \fBsensfunc\fR.  This task
allows fitting a smooth sensitivity function to the ratio of the observed
to calibrated fluxes verses wavelength.  The types of manipulations one
needs to do include deleting bad observations, possibly removing variable
extinction (for poor data), and possibly deriving a revised extinction
function.  This is a complex operation and one should consult the manual
page for \fBsensfunc\fR.  The sensitivity function is saved as one
dimensional spectra (one per order) with the root name \f(CWsens\fR.
Deletion of these images will also cause reprocessing to occur if the
\f(CWupdate\fR flag is set.
.NH
References
.NH 2
IRAF Introductory References
.LP
Work is underway on a new introductory guide to IRAF.  Currently, the
work below is the primary introduction.
.IP
P. Shames and D. Tody, \fIA User's Introduction to the IRAF Command
Language\fR, Central Computer Services, NOAO, 1986.
.NH 2
CCD Reductions
.IP
F. Valdes, \fIThe IRAF CCD Reduction Package -- CCDRED\fR, Central
Computer Services, NOAO, 1987.
.IP
F. Valdes, \fIUser's Guide to the CCDRED Package\fR, Central
Computer Services, NOAO, 1988.  Also on-line as \f(CWhelp ccdred.guide\fR.
.IP
P. Massey, \fIA User's Guide to CCD Reductions with IRAF\fR, Central
Computer Services, NOAO, 1989.
.NH 2
Aperture Extraction Package
.IP
F. Valdes, \fIThe IRAF APEXTRACT Package\fR, Central Computer Services,
NOAO, 1987 (out-of-date).
.NH 2
Task Help References
.LP
Each task in the \fBspecred\fR packages and tasks used by \fBdofibers\fR have
help pages describing the parameters and task in some detail.  To get
on-line help type
.V1

cl> help \fItaskname\fR

.V2
The output of this command can be piped to \fBlprint\fR to make a printed
copy.

.V1
      apall - Extract 1D spectra (all parameters in one task)
  apdefault - Set the default aperture parameters and apidtable
     apedit - Edit apertures interactively
     apfind - Automatically find spectra and define apertures
      apfit - Fit 2D spectra and output the fit, difference, or ratio
  apflatten - Remove overall spectral and profile shapes from flat fields
     apmask - Create and IRAF pixel list mask of the apertures
apnormalize - Normalize 2D apertures by 1D functions
 aprecenter - Recenter apertures
   apresize - Resize apertures
  apscatter - Fit and subtract scattered light
      apsum - Extract 1D spectra
    aptrace - Trace positions of spectra

      bplot - Batch plots of spectra
  calibrate - Apply extinction and flux calibrations to spectra
  continuum - Fit the continuum in spectra
   deredden - Apply interstellar extinction corrections
    dispcor - Dispersion correct spectra
     dopcor - Doppler correct spectra
 ecidentify - Identify features in spectrum for dispersion solution
ecreidentify - Automatically identify features in spectra
 refspectra - Assign wavelength reference spectra to other spectra
     sarith - Spectrum arithmetic
   scombine - Combine spectra
      scopy - Select and copy apertures in different spectral formats
   sensfunc - Create sensitivity function
 setairmass - Compute effective airmass and middle UT for an exposure
      setjd - Compute and set Julian dates in images
      slist - List spectrum header parameters
   specplot - Stack and plot multiple spectra
      splot - Preliminary spectral plot/analysis
   standard - Identify standard stars to be used in sensitivity calc

   doecslit - Process Echelle slit spectra
      demos - Demonstrations and tests

            Additional help topics

   onedspec.package - Package parameters and general description of package
  apextract.package - Package parameters and general description of package
 approfiles - Profile determination algorithms
 apvariance - Extractions, variance weighting, cleaning, and noise model
   center1d - One dimensional centering algorithm
      icfit - Interactive one dimensional curve fitting

.V2
.SH
Appendix A: DOECSLIT Parameters
.LP
.nr PS 8
.nr VS 10
objects
.LS
List of object images to be processed.  Previously processed spectra are
ignored unless the \f(CWredo\fR flag is set or the \f(CWupdate\fR flag is set
and dependent calibration data has changed.  If the images contain the
keyword IMAGETYP then only those with a value of "object" or "OBJECT"
are used and those with a value of "comp" or "COMPARISON" are added
to the list of arcs.  Extracted spectra are ignored.
.LE
apref = ""
.LS
Aperture reference spectrum.  This spectrum is used to define the basic
extraction apertures and is typically a bright star spectrum.
.LE
arcs = "" (at least one if dispersion correcting)
.LS
List of arc calibration spectra.  These spectra are used to define
the dispersion functions.  The first spectrum is used to mark lines
and set the dispersion function interactively and dispersion functions
for all other arc spectra are derived from it.  If the images contain
the keyword IMAGETYP then only those with a value of "comp" or
"COMPARISON" are used.  All others are ignored as are extracted spectra.
.LE
arctable = "" (optional) (refspectra)
.LS
Table defining which arc spectra are to be assigned to which object
spectra (see \fBrefspectra\fR).  If not specified an assignment based
on a header parameter, \f(CWsparams.sort\fR, such as the Julian date
is made.
.LE
standards = "" (at least one if flux calibrating)
.LS
List of standard star spectra.  The standard stars must have entries in
the calibration database (package parameter \f(CWechelle.caldir\fR).
.LE

readnoise = 0., gain = 1. (apsum)
.LS
Read out noise in photons and detector gain in photons per data value.
This parameter defines the minimum noise sigma and the conversion between
photon Poisson statistics and the data number statistics.  Image header
keywords (case insensitive) may be specified to obtain the values from the
image header.
.LE
datamax = INDEF (apsum.saturation)
.LS
The maximum data value which is not a cosmic ray.
When cleaning cosmic rays and/or using variance weighted extraction
very strong cosmic rays (pixel values much larger than the data) can
cause these operations to behave poorly.  If a value other than INDEF
is specified then all data pixels in excess of this value will be
excluded and the algorithms will yield improved results.
This applies only to the object spectra and not the standard star or
arc spectra.  For more
on this see the discussion of the saturation parameter in the
\fBapextract\fR package.
.LE
norders = 10 (apfind)
.LS
Number of orders to be found automatically.
.LE
width = 5. (apedit)
.LS
Approximate full width of the spectrum profiles.  This parameter is used
to define a width and error radius for the profile centering algorithm,
and defaults for the aperture limits and background regions.
.LE

dispcor = yes
.LS
Dispersion correct spectra?  This may involve either defining a nonlinear
dispersion coordinate system in the image header or resampling the
spectra to uniform linear wavelength coordinates as selected by
the parameter \f(CWsparams.linearize\fR.
.LE
extcor = no
.LS
Extinction correct the spectra?
.LE
fluxcal = no
.LS
Flux calibrate the spectra using standard star observations?
.LE
resize = no (apresize)
.LS
Resize the default apertures for each object based on the spectrum profile?
.LE
clean = no (apsum)
.LS
Detect and correct for bad pixels during extraction?  This is the same
as the clean option in the \fBapextract\fR package.  If yes this also
implies variance weighted extraction.  In addition the datamax parameters
can be useful.
.LE
trace = yes (non-quicklook mode only) (aptrace)
.LS
Allow tracing each object spectrum separately?  If not set then the trace
from the aperture reference is used, with recentering to allow for shifts
across the dispersion.  If set then each object and standard star
image is retraced.  Retracing is NOT done in quicklook mode.
.LE
background = "none" (apsum, apscatter)
.LS
Type of background light subtraction.  The choices are "none" for no
background subtraction, "scattered" for a global scattered light
subtraction, "average" to average the background within background regions,
"median" to use the median in background regions, "minimum" to use the
minimum in background regions, or "fit" to fit across the dispersion using
the background within background regions.  The scattered light option fits
and subtracts a smooth global background and modifies the input images.
This is a slow operation and so is NOT performed in quicklook mode.  The
other background options are local to each aperture.  The "fit" option uses
additional fitting parameters from \fBsparams\fR and the "scattered" option
uses parameters from \fBapscat1\fR and \fBapscat2\fR.
.LE
splot = no
.LS
Plot the final spectra?  In quicklook mode a noninteractive, stacked plot
is automatically produced using the task \fBspecplot\fR while in
non-quicklook mode a query is given and the task \fBsplot\fR is used for
interactive plotting.
.LE
redo = no
.LS
Redo operations previously done?  If no then previously processed spectra
in the objects list will not be processed unless required by the
update option.
.LE
update = no
.LS
Update processing of previously processed spectra if the aperture
reference image, the dispersion reference image, or standard star
calibration data are changed?
.LE
quicklook = no
.LS
Extract and calibrate spectra with minimal interaction?  In quicklook mode
only aperture reference definitions, the initial dispersion function
solution, and the standard star setup are done interactively.  Scattered
light subtraction and individual object tracing are not performed.
Normally the \f(CWsplot\fR option is set in this mode to produce an automatic
final spectrum plot for each object.  It is recommended that this mode not be
used for final reductions.
.LE
batch = no
.LS
Process spectra as a background or batch job provided there are no interactive
steps remaining.
.LE
listonly = no
.LS
List processing steps but don't process?
.LE

sparams = "" (pset)
.LS
Name of parameter set containing additional processing parameters.  This
parameter is only for indicating the link to the parameter set
\fBsparams\fR and should not be given a value.  The parameter set may be
examined and modified in the usual ways (typically with "epar sparams"
or ":e sparams" from the parameter editor).  The parameters are
described below.
.LE

.ce
-- GENERAL PARAMETERS --

line = INDEF, nsum = 10
.LS
The dispersion line (line or column perpendicular to the dispersion
axis) and number of adjacent lines (half before and half after unless
at the end of the image) used in finding, recentering, resizing,
editing, and tracing operations.  A line of INDEF selects the middle of the
image along the dispersion axis.
.LE
extras = no (apsum)
.LS
Include raw unweighted and uncleaned spectra, the background spectra, and
the estimated sigma spectra in a three dimensional output image format.
See the discussion in the \fBapextract\fR package for further information.
.LE

.ce
-- AUTOMATIC APERTURE RESIZING PARAMETERS --

ylevel = 0.05 (apresize)
.LS
Fraction of the peak to set aperture limits during automatic resizing.
.LE

.ce
-- TRACE PARAMETERS --

t_step = 10 (aptrace)
.LS
Step along the dispersion axis between determination of the spectrum
positions.  Note the \f(CWnsum\fR parameter is also used to enhance the
signal-to-noise at each step.
.LE
t_function = "spline3", t_order = 2 (aptrace)
.LS
Default trace fitting function and order.  The fitting function types are
"chebyshev" polynomial, "legendre" polynomial, "spline1" linear spline, and
"spline3" cubic spline.  The order refers to the number of
terms in the polynomial functions or the number of spline pieces in the spline
functions.
.LE
t_niterate = 1, t_low = 3., t_high = 3. (aptrace)
.LS
Default number of rejection iterations and rejection sigma thresholds.
.LE

.ce
-- BACKGROUND AND SCATTERED LIGHT PARAMETERS --

b_function = "legendre", b_order = 1 (apsum)
.LS
Default background fitting function and order.  The fitting function types are
"chebyshev" polynomial, "legendre" polynomial, "spline1" linear spline, and
"spline3" cubic spline.  The order refers to the number of
terms in the polynomial functions or the number of spline pieces in the spline
functions.
.LE
b_naverage = -100 (apsum)
.LS
Default number of points to average or median.  Positive numbers
average that number of sequential points to form a fitting point.
Negative numbers median that number, in absolute value, of sequential
points.  A value of 1 does no averaging and each data point is used in the
fit.
.LE
b_niterate = 0 (apsum)
.LS
Default number of rejection iterations.  If greater than zero the fit is
used to detect deviant fitting points and reject them before repeating the
fit.  The number of iterations of this process is given by this parameter.
.LE
b_low_reject = 3., b_high_reject = 3. (apsum)
.LS
Default background lower and upper rejection sigmas.  If greater than zero
points deviating from the fit below and above the fit by more than this
number of times the sigma of the residuals are rejected before refitting.
.LE
buffer = 1. (apscatter)
.LS
Buffer distance from the edge of any aperture for data to be included
in the scattered light determination.  This parameter may be modified
interactively.
.LE
apscat1 = "", apscat2 = "" (apscatter)
.LS
Parameter sets for the fitting functions across and along the dispersion.
These parameters are those used by \fBicfit\fR.  These parameters are
usually set interactively.
.LE

.ce
-- APERTURE EXTRACTION PARAMETERS --

weights = "none" (apsum) (none|variance)
.LS
Type of extraction weighting.  Note that if the \f(CWclean\fR parameter is
set then the weights used are "variance" regardless of the weights
specified by this parameter.  The choices are:

"none"
.LS
The pixels are summed without weights except for partial pixels at the
ends.
.LE
"variance"
.LS
The extraction is weighted by the variance based on the data values
and a poisson/ccd model using the \f(CWgain\fR and \f(CWreadnoise\fR
parameters.
.LE
.LE
pfit = "fit1d" (apsum and approfile) (fit1d|fit2d)
.LS
Type of profile fitting algorithm to use.  The "fit1d" algorithm is
preferred except in cases of extreme tilt.
.LE
lsigma = 3., usigma = 3. (apsum)
.LS
Lower and upper rejection thresholds, given as a number of times the
estimated sigma of a pixel, for cleaning.
.LE

.ce
-- ARC DISPERSION FUNCTION PARAMETERS --

threshold = 10. (identify/reidentify)
.LS
In order for a feature center to be determined the range of pixel intensities
around the feature must exceed this threshold.
.LE
coordlist = "linelist$thar.dat" (ecidentify)
.LS
Arc line list consisting of an ordered list of wavelengths.
Some standard line lists are available in the directory "linelist$".
.LE
match = 1. (ecidentify)
.LS
The maximum difference for a match between the dispersion function computed
value and a wavelength in the coordinate list.
.LE
fwidth = 4. (ecidentify)
.LS
Approximate full base width (in pixels) of arc lines.
.LE
cradius = 10. (reidentify)
.LS
Radius from previous position to reidentify arc line.
.LE
i_function = "legendre", i_xorder = 3, i_yorder = 3 (ecidentify)
.LS
The default function, function order for the pixel position dependence, and
function order for the aperture number dependence to be fit to the arc
wavelengths.  The functions choices are "chebyshev" or "legendre".
.LE
i_niterate = 3, i_low = 3.0, i_high = 3.0 (ecidentify)
.LS
Number of rejection iterations and sigma thresholds for rejecting arc
lines from the dispersion function fits.
.LE
refit = yes (ecreidentify)
.LS
Refit the dispersion function?  If yes and there is more than 1 line
and a dispersion function was defined in the arc reference then a new
dispersion function of the same type as in the reference image is fit
using the new pixel positions.  Otherwise only a zero point shift is
determined for the revised fitted coordinates without changing the
form of the dispersion function.
.LE

.ce
-- AUTOMATIC ARC ASSIGNMENT PARAMETERS --

select = "interp" (refspectra)
.LS
Selection method for assigning wavelength calibration spectra.
Note that an arc assignment table may be used to override the selection
method and explicitly assign arc spectra to object spectra.
The automatic selection methods are:

average
.LS
Average two reference spectra without regard to any sort parameter.
If only one reference spectrum is specified then it is assigned with a
warning.  If more than two reference spectra are specified then only the
first two are used and a warning is given.
This option is used to assign two reference spectra, with equal weights,
independent of any sorting parameter.
.LE
following
.LS
Select the nearest following spectrum in the reference list based on the
sorting parameter.  If there is no following spectrum use the nearest preceding
spectrum.
.LE
interp
.LS
Interpolate between the preceding and following spectra in the reference
list based on the sorting parameter.  If there is no preceding and following
spectrum use the nearest spectrum.  The interpolation is weighted by the
relative distances of the sorting parameter.
.LE
match
.LS
Match each input spectrum with the reference spectrum list in order.
This overrides the reference aperture check.
.LE
nearest
.LS
Select the nearest spectrum in the reference list based on the sorting
parameter.
.LE
preceding
.LS
Select the nearest preceding spectrum in the reference list based on the
sorting parameter.  If there is no preceding spectrum use the nearest following
spectrum.
.LE
.LE
sort = "jd" (setjd and refspectra)
.LS
Image header keyword to be used as the sorting parameter for selection
based on order.  The header parameter must be numeric but otherwise may
be anything.  Common sorting parameters are times or positions.
.LE
group = "ljd" (setjd and refspectra)
.LS
Image header keyword to be used to group spectra.  For those selection
methods which use the group parameter the reference and object
spectra must have identical values for this keyword.  This can
be anything but it must be constant within a group.  Common grouping
parameters are the date of observation "date-obs" (provided it does not
change over a night) or the local Julian day number.
.LE
time = no, timewrap = 17. (refspectra)
.LS
Is the sorting parameter a 24 hour time?  If so then the time origin
for the sorting is specified by the timewrap parameter.  This time
should precede the first observation and follow the last observation
in a 24 hour cycle.
.LE

.ce
-- DISPERSION  CORRECTION PARAMETERS --

linearize = yes (dispcor)
.LS
Interpolate the spectra to a linear dispersion sampling?  If yes the
spectra will be interpolated to a linear or log linear sampling using
the linear dispersion parameters specified by other parameters.  If
no the nonlinear dispersion function(s) from the dispersion function
database are assigned to the input image world coordinate system
and the spectral data is not interpolated.  Note the interpolation
function type is set by the package parameter \f(CWinterp\fR.
.LE
log = no (ecdispcor)
.LS
Use linear logarithmic wavelength coordinates?  Linear logarithmic
wavelength coordinates have wavelength intervals which are constant
in the logarithm of the wavelength.
.LE
flux = yes (ecdispcor)
.LS
Conserve the total flux during interpolation?  If \f(CWno\fR the output
spectrum is interpolated from the input spectrum at each output
wavelength coordinate.  If \f(CWyes\fR the input spectrum is integrated
over the extent of each output pixel.  This is slower than
simple interpolation.
.LE

.ce
-- SENSITIVITY CALIBRATION PARAMETERS --

bandwidth = 10., bandsep = 10. (standard)
.LS
Interpolated bandpass grid.  If INDEF then the same bandpasses as in the
calibration files are used otherwise the calibration data is interpolated
to the specified set of bandpasses.
.LE
s_interact = yes (standard)
.LS
Display the bandpasses on the standard star data and allow interactive
addition and deletion of bandpasses.
.LE
s_function = "spline3", s_order = 1 (sensfunc)
.LS
Function and order used to fit the sensitivity data.  The function types are
"chebyshev" polynomial, "legendre" polynomial, "spline3" cubic spline,
and "spline1" linear spline.
Order of the sensitivity fitting function.  The value corresponds to the
number of polynomial terms or the number of spline pieces.  The default
values may be changed interactively.
.LE
fnu = no (calibrate)
.LS
The default calibration is into units of F-lambda. If \f(CWfnu\fR = yes then
the calibrated spectrum will be in units of F-nu.
.LE

.ce
PACKAGE PARAMETERS

dispaxis = 2
.LS
Default dispersion axis.  The dispersion axis is 1 for dispersion
running along image lines and 2 for dispersion running along image
columns.  If the image header parameter DISPAXIS is defined it has
precedence over this parameter.  The default value defers to the
package parameter of the same name.
.LE
extinction = "onedstds$kpnoextinct.dat" (standard, sensfunc, calibrate)
.LS
Extinction file for a site.  There are two extinction files in the
NOAO standards library, onedstds$, for KPNO and CTIO.  These extinction
files are used for extinction and flux calibration.
.LE
caldir (standard)
.LS
Standard star calibration directory.  A directory containing standard
star data files.  Note that the directory name must end with '/'.
There are a number of standard star calibrations directories in the NOAO
standards library, onedstds$.
.LE
observatory = "observatory" (observatory)
.LS
The default observatory to use for latitude dependent computations.
If the OBSERVAT keyword in the image header it takes precedence over
this parameter.
.LE
interp = "poly5" (nearest|linear|poly3|poly5|spline3|sinc) (dispcor)
.LS
Spectrum interpolation type used when spectra are resampled.  The choices are:

.V1
        nearest - nearest neighbor
         linear - linear
          poly3 - 3rd order polynomial
          poly5 - 5th order polynomial
        spline3 - cubic spline
           sinc - sinc function
.V2
.LE
database = "database"
.LS
Database name used by various tasks.  This is a directory which is created
if necessary.
.LE
verbose = no
.LS
Verbose output?  If set then almost all the information written to the
logfile is also written to the terminal except when the task is a
background or batch process.
.LE
logfile = "logfile"
.LS
If specified detailed text log information is written to this file.
.LE
plotfile = ""
.LS
If specified metacode plots are recorded in this file for later review.
Since plot information can become large this should be used only if
really desired.
.LE

.ce
ENVIRONMENT PARAMETERS
.LP
The environment parameter \fIimtype\fR is used to determine the extension
of the images to be processed and created.  This allows use with any
supported image extension.  For STF images the extension has to be exact;
for example "d1h".
