/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef SHADERS_H
#define SHADERS_H

#include <glm/glm.hpp>

namespace libgltf
{

class ShaderProgram
{
public:
    // Setting integers
    void setUniform(unsigned int uProgId, const char* name, const int iValue);

    // Setting floats
    void setUniform(unsigned int uProgId, const char* name,
                    const float fValue);

    // Setting vectors
    void setUniform(unsigned int uProgId, const char* name,
                    const glm::vec2& vVector);
    void setUniform(unsigned int uProgId, const char* name,
                    const glm::vec3& vVector);
    void setUniform(unsigned int uProgId, const char* name,
                    const glm::vec4& vVector);

    // Setting 3x3 matrices
    void setUniform(unsigned int uProgId, const char* name,
                    const glm::mat3& mMatrix);

    // Setting 4x4 matrices
    void setUniform(unsigned int uProgId, const char* name,
                    const glm::mat4& mMatrix);

    unsigned int createProgram(const char* pvShader, size_t ivShaderSize,
                               const char* pfShader, size_t ifShaderSize);

    void deleteProgram(unsigned int programId);

    void useProgram(unsigned int programId);

    bool loadShader(unsigned int programId, const char* pShader, size_t iSize,
                    int type);
private:

    bool compileShader(const char* pShader, size_t iSize,
                       unsigned int shaderId);

    bool linkProgram(unsigned int programId, unsigned int shaderId);

    void deleteShader(unsigned int shaderId);
};

} // namespace libgltf

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
