/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.AbstractDragControler;
import com.vldocking.swing.docking.DockableDragSource;
import com.vldocking.swing.docking.DockingDesktop;
import com.vldocking.swing.docking.DragControlerGlassPane;
import com.vldocking.swing.docking.ShapePainterStrategy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;

class LightWeightDragControler
extends AbstractDragControler {
    LightWeightDragControler(DockingDesktop desktop) {
        super(desktop);
    }

    @Override
    protected Component findComponentAt(Container container, int x, int y) {
        return container.findComponentAt(x, y);
    }

    @Override
    protected ShapePainterStrategy createShapePainterStrategy(Window w) {
        return new LWShapePainterStrategy(w);
    }

    private class LWShapePainterStrategy
    implements ShapePainterStrategy {
        private DragControlerGlassPane dragGlassPane;
        private Component oldGlassPane;
        private boolean oldGlassPaneVisible;
        private Window window;
        private boolean isDragStarted;

        public LWShapePainterStrategy(Window window) {
            this.dragGlassPane = new DragControlerGlassPane(LightWeightDragControler.this);
            this.oldGlassPane = null;
            this.oldGlassPaneVisible = false;
            this.window = null;
            this.isDragStarted = false;
            this.window = window;
        }

        @Override
        public void showDragCursor() {
            this.dragGlassPane.showDragCursor();
        }

        @Override
        public void showStopDragCursor() {
            this.dragGlassPane.showStopDragCursor();
        }

        @Override
        public void showSwapDragCursor() {
            this.dragGlassPane.showSwapDragCursor();
        }

        @Override
        public void showFloatCursor() {
            this.dragGlassPane.showFloatCursor();
        }

        @Override
        public void repaint() {
            this.dragGlassPane.repaint();
        }

        @Override
        public void startDrag(DockableDragSource source) {
            if (this.isDragStarted || source == null) {
                return;
            }
            Window aboveWindow = this.window;
            this.isDragStarted = true;
            if (aboveWindow instanceof JFrame) {
                this.oldGlassPane = ((JFrame)aboveWindow).getGlassPane();
                this.oldGlassPaneVisible = this.oldGlassPane.isVisible();
                ((JFrame)aboveWindow).setGlassPane(this.dragGlassPane);
                this.dragGlassPane.setVisible(true);
            } else if (aboveWindow instanceof JDialog) {
                this.oldGlassPane = ((JDialog)aboveWindow).getGlassPane();
                this.oldGlassPaneVisible = this.oldGlassPane.isVisible();
                ((JDialog)aboveWindow).setGlassPane(this.dragGlassPane);
                this.dragGlassPane.setVisible(true);
            }
        }

        @Override
        public void endDrag() {
            Window aboveWindow = this.window;
            if (aboveWindow instanceof JFrame) {
                ((JFrame)aboveWindow).setGlassPane(this.oldGlassPane);
            } else if (aboveWindow instanceof JDialog) {
                ((JDialog)aboveWindow).setGlassPane(this.oldGlassPane);
            }
            this.oldGlassPane.setVisible(this.oldGlassPaneVisible);
            this.isDragStarted = false;
        }
    }
}

