
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CapeBoxAttributes.h
    \\brief Definition of CapeBox Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "CapeBoxAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

CapeBoxAttributes::CapeBoxAttributes():
	box_border_thickness_(ParameterManager::getDouble("cape_box_border_thickness")),
	marker_index_(ParameterManager::getInt("cape_marker_index")),
	marker_height_(ParameterManager::getDouble("cape_marker_height")),
	box_thickness_(ParameterManager::getDouble("cape_box_thickness")),
	box_width_(ParameterManager::getDouble("cape_box_width")),
	text_font_size_(ParameterManager::getDouble("cape_text_font_size"))
	,
	control_colour_(MagTranslator<string, Colour>().magics("cape_control_colour")),
	hres_colour_(MagTranslator<string, Colour>().magics("cape_hres_colour")),
	box_colour_(MagTranslator<string, Colour>().magics("cape_box_colour")),
	box_border_colour_(MagTranslator<string, Colour>().magics("cape_box_border_colour")),
	marker_colour_(MagTranslator<string, Colour>().magics("cape_marker_colour")),
	box_style_(MagTranslator<string, LineStyle>().magics("cape_box_line_style")),
	text_font_colour_(MagTranslator<string, Colour>().magics("cape_text_font_colour"))
	 
{
} 


CapeBoxAttributes::~CapeBoxAttributes()
{
	
}

    
void CapeBoxAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "cape";
	
	setAttribute(prefix, "cape_box_border_thickness", box_border_thickness_, params);
	setAttribute(prefix, "cape_marker_index", marker_index_, params);
	setAttribute(prefix, "cape_marker_height", marker_height_, params);
	setAttribute(prefix, "cape_box_thickness", box_thickness_, params);
	setAttribute(prefix, "cape_box_width", box_width_, params);
	setAttribute(prefix, "cape_text_font_size", text_font_size_, params);
	
	setMember(prefix, "cape_control_colour", control_colour_, params);
	setMember(prefix, "cape_hres_colour", hres_colour_, params);
	setMember(prefix, "cape_box_colour", box_colour_, params);
	setMember(prefix, "cape_box_border_colour", box_border_colour_, params);
	setMember(prefix, "cape_marker_colour", marker_colour_, params);
	setAttribute(prefix, "cape_box_line_style", box_style_, params);
	setMember(prefix, "cape_text_font_colour", text_font_colour_, params);
	
}

void CapeBoxAttributes::copy(const CapeBoxAttributes& other)
{
	box_border_thickness_ = other.box_border_thickness_;
	marker_index_ = other.marker_index_;
	marker_height_ = other.marker_height_;
	box_thickness_ = other.box_thickness_;
	box_width_ = other.box_width_;
	text_font_size_ = other.text_font_size_;
	control_colour_ = unique_ptr<Colour>(other.control_colour_->clone());
	hres_colour_ = unique_ptr<Colour>(other.hres_colour_->clone());
	box_colour_ = unique_ptr<Colour>(other.box_colour_->clone());
	box_border_colour_ = unique_ptr<Colour>(other.box_border_colour_->clone());
	marker_colour_ = unique_ptr<Colour>(other.marker_colour_->clone());
	box_style_ = other.box_style_;
	text_font_colour_ = unique_ptr<Colour>(other.text_font_colour_->clone());
	
} 


bool CapeBoxAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "capebox")  )
		return true;
	
	return false;
}

void CapeBoxAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "capebox")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void CapeBoxAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " box_border_thickness = " <<  box_border_thickness_;
	out << " marker_index = " <<  marker_index_;
	out << " marker_height = " <<  marker_height_;
	out << " box_thickness = " <<  box_thickness_;
	out << " box_width = " <<  box_width_;
	out << " text_font_size = " <<  text_font_size_;
	out << " control_colour = " <<  *control_colour_;
	out << " hres_colour = " <<  *hres_colour_;
	out << " box_colour = " <<  *box_colour_;
	out << " box_border_colour = " <<  *box_border_colour_;
	out << " marker_colour = " <<  *marker_colour_;
	out << " box_style = " <<  box_style_;
	out << " text_font_colour = " <<  *text_font_colour_;
	
	out << "]" << "\n";
}

void CapeBoxAttributes::toxml(ostream& out)  const
{
	out <<  "\"capebox\""; 
	out << ", \"cape_box_border_thickness\":";
	niceprint(out,box_border_thickness_);
	out << ", \"cape_marker_index\":";
	niceprint(out,marker_index_);
	out << ", \"cape_marker_height\":";
	niceprint(out,marker_height_);
	out << ", \"cape_box_thickness\":";
	niceprint(out,box_thickness_);
	out << ", \"cape_box_width\":";
	niceprint(out,box_width_);
	out << ", \"cape_text_font_size\":";
	niceprint(out,text_font_size_);
	out << ", \"cape_control_colour\":";
	niceprint(out, *control_colour_);
	out << ", \"cape_hres_colour\":";
	niceprint(out, *hres_colour_);
	out << ", \"cape_box_colour\":";
	niceprint(out, *box_colour_);
	out << ", \"cape_box_border_colour\":";
	niceprint(out, *box_border_colour_);
	out << ", \"cape_marker_colour\":";
	niceprint(out, *marker_colour_);
	out << ", \"cape_box_line_style\":";
	niceprint(out, box_style_);
	out << ", \"cape_text_font_colour\":";
	niceprint(out, *text_font_colour_);
	
}

static MagicsParameter<double> cape_box_border_thickness("cape_box_border_thickness", 2, "");
static MagicsParameter<int> cape_marker_index("cape_marker_index", 15, "");
static MagicsParameter<double> cape_marker_height("cape_marker_height", 0.5, "");
static MagicsParameter<double> cape_box_thickness("cape_box_thickness", 1, "");
static MagicsParameter<double> cape_box_width("cape_box_width", 1, "");
static MagicsParameter<double> cape_text_font_size("cape_text_font_size", 0.5, "");
static MagicsParameter<string> cape_control_colour("cape_control_colour", "red", ""); 
static MagicsParameter<string> cape_hres_colour("cape_hres_colour", "blue", ""); 
static MagicsParameter<string> cape_box_colour("cape_box_colour", "black", ""); 
static MagicsParameter<string> cape_box_border_colour("cape_box_border_colour", "black", ""); 
static MagicsParameter<string> cape_marker_colour("cape_marker_colour", "black", ""); 
static MagicsParameter<string> cape_box_line_style("cape_box_line_style", "solid", ""); 
static MagicsParameter<string> cape_text_font_colour("cape_text_font_colour", "black", ""); 
