# Copyright 2010-2021, Google Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
# copyright notice, this list of conditions and the following disclaimer
# in the documentation and/or other materials provided with the
# distribution.
#     * Neither the name of Google Inc. nor the names of its
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

{
  'type': 'none',
  'actions': [
    {
      'action_name': 'gen_<(gen_resource_proj_name)_resource_header',
      'variables': {
        'base_path': '<(DEPTH)/',
        'version_file_path': '<(base_path)/mozc_version.txt',
        'script_path': '<(base_path)/build_tools/gen_win32_resource_header.py',
      },
      'inputs': [
        '<(base_path)/<(gen_main_resource_path)',
        '<(base_path)/build_tools/mozc_win32_resource_template.rc',
        '<(script_path)',
        '<(version_file_path)',
      ],
      'outputs': [
        '<(gen_output_resource_path)',
      ],
      'action': [
        '<(python)', '<(script_path)',
        '--version_file', '<(version_file_path)',
        '--main', '<(base_path)/<(gen_main_resource_path)',
        '--template', '<(base_path)/build_tools/mozc_win32_resource_template.rc',
        '--output', '<(gen_output_resource_path)',
      ],
    },
  ],
}
