#! /usr/bin/env python

import openturns as ot

ot.TESTPREAMBLE()

# Instantiate one distribution object
dim = 1
meanPoint = ot.Point(dim, 1.0)
meanPoint[0] = 0.5
sigma = ot.Point(dim, 1.0)
sigma[0] = 2.0
R = ot.CorrelationMatrix(dim)
distribution1 = ot.Normal(meanPoint, sigma, R)

# Instantiate another distribution object
meanPoint[0] = -1.5
sigma[0] = 4.0
distribution2 = ot.Normal(meanPoint, sigma, R)

# Test for sampling
size = 200
nPoints = 20
sample1 = distribution1.getSample(size)
sample2 = distribution2.getSample(size)

# Construct empirical CDF for each sample
data1 = ot.Sample(nPoints, 2)
data2 = ot.Sample(nPoints, 2)
cursor1 = ot.Point(2)
cursor2 = ot.Point(2)
for i in range(nPoints):
    cursor1[0] = 13.0 * i / nPoints - 6.5
    count1 = 0.0
    cursor2[0] = 24.0 * i / nPoints - 13.5
    count2 = 0.0
    for j in range(size):
        if sample1[j, 0] < cursor1[0]:
            count1 += 1.0
        if sample2[j, 0] < cursor2[0]:
            count2 += 1.0
    cursor1[1] = count1 / size
    cursor2[1] = count2 / size
    data1[i] = cursor1
    data2[i] = cursor2

# Create an empty graph
myGraph = ot.Graph("Some curves", "x1", "x2", True, "bottomright")

# Create the first staircase
myStaircase1 = ot.Staircase(data1, "blue", "solid", "s", "")

myStaircase1b = ot.Staircase(myStaircase1)
myStaircase1b.setPattern("S")
myStaircase1b.setColor("green")
myStaircase1b.setLineStyle("dashed")
myStaircase1b.setLegend("eCDF1b, pat=S")

# Then, draw it
myGraph.add(myStaircase1)
myGraph.add(myStaircase1b)

# Check that the correct files have been generated by computing their
# checksum

# Create the second staircase
myStaircase2 = ot.Staircase(data2, "red", "dashed", "S", "eCDF2, pat=S")

# Add it to the graph and draw everything
myGraph.add(myStaircase2)
