**Technical Charter (the &quot;Charter&quot;) for OpenVDB a Series of LF Projects, LLC**

**Adopted 2018/10/10**

This charter (the &quot;Charter&quot;) sets forth the responsibilities and procedures for technical contribution to, and oversight of, the **OpenVDB** project, which has been established as the **OpenVDB** Series of LF Projects, LLC (the &quot;Project&quot;). LF Projects, LLC (&quot;LF Projects&quot;) is a Delaware series limited liability company.  All Contributors to the Project must comply with the terms of this Charter.

1. Mission and Scope of the Project
  * **a.** The mission of the Project is to continue maintenance and development of an open source project with the goals indicated in the &quot;README&quot; file within the Project&#39;s code repository.
  * **b.** The scope of the Project includes using existing OpenVDB repositories to seed the Project, and software development under an OSI-approved open source license supporting the mission, including documentation, testing, integration and the creation of other artifacts that aid the development, deployment, operation or adoption of the open source software project.
2. Technical Steering Committee
  * **a.** The Technical Steering Committee (the &quot;TSC&quot;) will be responsible for all technical oversight of the open source Project.
  * **b.** The TSC voting members shall be as set forth within the &quot;CONTRIBUTING&quot; file within the Project&#39;s code repository.  A voting member of the TSC may nominate a successor in the event that such voting member decides to leave the TSC, and the TSC, including the departing member, shall confirm or reject such nomination by a vote.  In the event that the departing member&#39;s nomination for successor is rejected by vote of the TSC, the departing member shall be entitled to continue nominating successors until one such successor is confirmed by vote of the TSC.  If the departing member fails or is unable to nominate a successor, the TSC may nominate one on the departing member&#39;s behalf.  The TSC may also determine if and how additional voting members of the TSC are chosen, and any such approach will be documented in the CONTRIBUTING file, provided that such approach does not conflict with this Charter.  Any meetings of the TSC are intended to be open to the public, except where there is a reasonable need for privacy, and can be conducted electronically, via teleconference, or in person.
  * **c.** TSC projects generally will involve Contributors and Committers. The TSC may adopt or modify roles so long as the roles are documented in the CONTRIBUTING file. Unless otherwise documented:
    * **i.** Contributors include anyone in the technical community that contributes code, documentation, or other technical artifacts to the Project;
    * **ii.**  Committers are Contributors who have earned the ability to modify (&quot;commit&quot;) source code, documentation or other technical artifacts in the Project&#39;s repository; and
    * **iii.**  A Contributor may become a Committer by a majority approval of the existing Committers or at the discretion of the TSC.  A Committer may be removed by a majority approval of the other existing Committers, or at the discretion of the TSC.
  * **d.** Participation in the Project through becoming a Contributor and Committer is open to anyone so long as they abide by the terms of this Charter.
  * **e.** The TSC may (1) establish work flow procedures for the submission, approval, and closure/archiving of projects, (2) set requirements for the promotion of Contributors to Committer status, as applicable, and (3) amend, adjust, refine and/or eliminate the roles of Contributors, and Committers, and create new roles, and publicly document any TSC roles, as it sees fit.
  * **f.** The TSC may elect a TSC Chair, who will preside over meetings of the TSC and will serve until his or her resignation or replacement by the TSC. ** ** The TSC Chair, or any other TSC member so designated by the TSC, will serve as the primary communication contact between the Project and the Academy Software Foundation Fund of The Linux Foundation.
  * **g.** Responsibilities: The TSC will be responsible for all aspects of oversight relating to the Project, which may include:
    * **i.** coordinating the technical direction of the Project;
    * **ii.** approving project or system proposals (including, but not limited to, incubation, deprecation, and changes to a sub-project&#39;s scope);
    * **iii.** organizing sub-projects and removing projects;
    * **iv.** creating sub-committees or working groups to focus on cross-project technical issues and requirements;
    * **v.** appointing representatives to work with other open source or open standards communities;
    * **vi.** establishing community norms, workflows, issuing releases, and security issue reporting policies;
    * **vii.** approving and implementing policies and processes for contributing (to be published in the CONTRIBUTING file) and coordinating with the Series Manager or its designee to resolve matters or concerns that may arise as set forth in Section 7 of this Charter;
    * **viii.** discussions, seeking consensus, and where necessary, voting on technical matters relating to the code base that affect multiple projects; and
    * **ix.** coordinating any marketing, events, or communications regarding the Project with the LF Projects Manager or its designee.
3. TSC Voting
  * **a.** Although the Project aims to operate as a consensus-based community, if any TSC decision requires a vote to move the Project forward, the voting members of the TSC will vote on a one vote per voting member basis.
  * **b.** At least fifty percent of all voting members of the TSC must be present at a TSC meeting in order to establish a quorum. The TSC may continue to meet if a quorum is not met, but will be prevented from making any decisions at such meeting.
  * **c.** Except as provided in Section 7.c. and 8.a, decisions by vote at a meeting require a majority vote of those in attendance, provided a quorum is met. Decisions made by electronic vote without a meeting require a majority vote of all voting members of the TSC.
  * **d.** In the event a vote cannot be resolved by the TSC, any voting member of the TSC may refer the matter to the Series Manager or its designee for assistance in reaching a resolution.
4. Compliance with Policies
  * **a.** This Charter is subject to the Series Agreement for the Project and the Operating Agreement of LF Projects. Contributors will comply with the policies of LF Projects as may be adopted and amended by LF Projects, including, without limitation the policies listed at https://lfprojects.org/policies/.
  * **b.** The TSC may adopt a code of conduct (&quot;CoC&quot;) for the Project, which is subject to approval by the LF Projects Series Manager.  Contributors to the Project will comply with the CoC or, in the event that a Project-specific CoC has not been approved, the LF Projects Code of Conduct listed at https://lfprojects.org/policies/.
  * **c.** When amending or adopting any policy applicable to the Project, LF Projects will publish such policy, as to be amended or adopted, on its web site at least 30 days prior to such policy taking effect; provided, however, that in the case of any amendment of the Trademark Policy or Terms of Use of LF Projects, any such amendment is effective upon publication on LF Projects&#39; web site.
  * **d.** All participants must allow open participation from any individual or organization meeting the requirements for contributing under this Charter and any policies adopted for all participants by the TSC, regardless of competitive interests. Put another way, the Project community must not seek to exclude any participant based on any criteria, requirement, or reason other than those that are reasonable and applied on a non-discriminatory basis to all participants in the Project community.
  * **e.** The Project will operate in a transparent, open, collaborative, and ethical manner at all times. The output of all Project discussions, proposals, timelines, decisions, and status should be made open and easily visible to all. Any potential violations of this requirement should be reported immediately to the LF Projects Manager.
5. Community Assets
  * **a.** LF Projects will hold title to all trade or service marks used by the Project (&quot;Project Trademarks&quot;), whether based on common law or registered rights.  Project Trademarks will be transferred and assigned to LF Projects to hold on behalf of the Project. Any use of any Project Trademarks by participants in the Project will be in accordance with the license from LF Projects and inure to the benefit of LF Projects.
  * **b.** The Project will, as permitted and in accordance with such license from LF Projects, develop and own all Project GitHub and social media accounts, and domain name registrations created by the Project community.
  * **c.** Under no circumstances will LF Projects be expected or required to undertake any action on behalf of the Project that is inconsistent with the tax-exempt status or purpose, as applicable, of LFP, Inc. or LF Projects, LLC.
6. General Rules and Operations.
  * **a.** The Project will:
    * **i.** engage in the work of the project in a professional manner consistent with maintaining a cohesive community, while also maintaining the goodwill and esteem of LF Projects, LFP, Inc. and other partner organizations in the open source software community; and
    * **ii.** respect the rights of all trademark owners, including any branding and trademark usage guidelines.
7. Intellectual Property Policy
  * **a.** Participants acknowledge that the copyright in all new contributions will be retained by the copyright holder as independent works of authorship and that no contributor or copyright holder will be required to assign copyrights to the Project.
  * **b.** Except as described in Section 7.c., all code contributions to the Project are subject to the following:
    * **i.** All new inbound code contributions to the Project must be made using an OSI-approved open source license specified for the Project within the &quot;LICENSE&quot; file within the Project&#39;s code repository (the &quot;Project License&quot;).
    * **ii.** All new inbound code contributions must:
      1. Be made pursuant to a binding Project Contribution License Agreement (the &quot;CLA&quot;) available on the Project&#39;s web site; and
      2. Be accompanied by a Developer Certificate of Origin ([http://developercertificate.org](http://developercertificate.org)) sign-off in the source code system that is submitted through a TSC-approved contribution process which will bind the authorized contributor and, if not self-employed, their employer to the applicable license;
    * **iii.** All outbound code will be made available under the Project License.
    * **iv.** Documentation will be received and made available by the Project under the Creative Commons Attribution 4.0 International License (available at [http://creativecommons.org/licenses/by/4.0/](http://creativecommons.org/licenses/by/4.0/)).
    * **v.** The Project may seek to integrate and contribute back to other open source projects (&quot;Upstream Projects&quot;). In such cases, the Project will conform to all license requirements of the Upstream Projects, including dependencies, leveraged by the Project.  Upstream Project code contributions not stored within the Project&#39;s main code repository will comply with the contribution process and license terms for the applicable Upstream Project.
  * **c.** If an alternative inbound or outbound license is required for compliance with the license for a leveraged open source project or is otherwise required to achieve the Project&#39;s mission, the Governing Board of the Academy Software Foundation Fund of the Linux Foundation (&quot;Governing Board&quot;), or the Governing Board&#39;s representatives designated for such purpose, may approve the use of an alternative license for specific inbound or outbound contributions on an exception basis.  Any exceptions must be approved by a vote of the Governing Board and must be limited in scope to what is required for such a purpose.  To request an exception, please describe the contribution, the alternative open source license(s), and the justification for using an alternative open source license for the Project.
  * **d.** Contributed files should contain license information, such as SPDX short form identifiers, indicating the open source license or licenses pertaining to the file.
8. Amendments
  * **a.** This charter may be amended by a two-thirds vote of the entire TSC, subject to reasonable approval by LF Projects.
