/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.Keep;
import com.tonicsystems.jarjar.PatternElement;
import com.tonicsystems.jarjar.Rule;
import com.tonicsystems.jarjar.Zap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

class RulesFileParser {
    private RulesFileParser() {
    }

    public static List parse(File file) throws IOException {
        return RulesFileParser.parse(new FileReader(file));
    }

    public static List parse(String value) throws IOException {
        return RulesFileParser.parse(new StringReader(value));
    }

    private static List parse(Reader r) throws IOException {
        String line;
        ArrayList<Rule> patterns = new ArrayList<Rule>();
        BufferedReader br = new BufferedReader(r);
        int c = 1;
        while ((line = br.readLine()) != null) {
            List parts = RulesFileParser.splitOnWhitespace(line);
            if (parts.size() < 2) {
                RulesFileParser.error(c, parts);
            }
            String type = (String)parts.get(0);
            PatternElement element = null;
            if (type.equals("rule")) {
                if (parts.size() < 3) {
                    RulesFileParser.error(c, parts);
                }
                element = new Rule();
                element.setResult((String)parts.get(2));
            } else if (type.equals("zap")) {
                element = new Zap();
            } else if (type.equals("keep")) {
                element = new Keep();
            } else {
                RulesFileParser.error(c, parts);
            }
            element.setPattern((String)parts.get(1));
            patterns.add((Rule)element);
            ++c;
        }
        r.close();
        return patterns;
    }

    private static void error(int line, List parts) {
        throw new IllegalArgumentException("Error on line " + line + ": " + parts);
    }

    private static List splitOnWhitespace(String line) {
        ArrayList list = new ArrayList();
        StringTokenizer e = new StringTokenizer(line);
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }
}

