# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class ApiVersions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Common API Versions for Assessment Project Tracked Resource."""

    V2019_10_01 = "2019-10-01"
    """2019-10-01 API Version."""
    V2020_01_01 = "2020-01-01"
    """2020-01-01 API Version."""
    V2020_05_01_PREVIEW = "2020-05-01-preview"
    """2020-05-01-preview API Version."""
    V2022_02_02_PREVIEW = "2022-02-02-preview"
    """2022-02-02-preview API Version."""
    V2023_03_03 = "2023-03-03"
    """2023-03-03 API Version."""
    V2023_03_15 = "2023-03-15"
    """2023-03-15 API Version."""
    V2023_04_01_PREVIEW = "2023-04-01-preview"
    """2023-04-01-preview API Version."""
    V2023_07_07_PREVIEW = "2023-07-07-preview"
    """2023-07-07-preview API Version."""


class AssessedMachineType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AssessedMachineType."""

    UNKNOWN = "Unknown"
    ASSESSED_MACHINE = "AssessedMachine"
    AVS_ASSESSED_MACHINE = "AvsAssessedMachine"
    SQL_ASSESSED_MACHINE = "SqlAssessedMachine"


class AssessmentSizingCriterion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Assessment Sizing Criteria."""

    PERFORMANCE_BASED = "PerformanceBased"
    """Performance Data based Sizing."""
    AS_ON_PREMISES = "AsOnPremises"
    """As On Premises or Static Data based Sizing."""


class AssessmentStage(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AssessmentStage."""

    IN_PROGRESS = "InProgress"
    UNDER_REVIEW = "UnderReview"
    APPROVED = "Approved"


class AssessmentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Assessment Status."""

    CREATED = "Created"
    """Assessment is Created."""
    UPDATED = "Updated"
    """Assessment is Updated."""
    RUNNING = "Running"
    """Assessment is currently running."""
    COMPLETED = "Completed"
    """Assessment is Completed or Ready."""
    INVALID = "Invalid"
    """Assessment is Failed i.e. it is now invalid."""
    OUT_OF_SYNC = "OutOfSync"
    """Assessment is Out of Sync."""
    OUT_DATED = "OutDated"
    """Assessment is Out Dated."""
    DELETED = "Deleted"
    """Assessment is Deleted."""


class AssessmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AssessmentType."""

    UNKNOWN = "Unknown"
    MACHINE_ASSESSMENT = "MachineAssessment"
    AVS_ASSESSMENT = "AvsAssessment"
    SQL_ASSESSMENT = "SqlAssessment"
    WEB_APP_ASSESSMENT = "WebAppAssessment"


class AsyncCommitModeIntent(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AsyncCommitModeIntent."""

    NONE = "None"
    HIGH_AVAILABILITY = "HighAvailability"
    DISASTER_RECOVERY = "DisasterRecovery"


class AzureAvsNodeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureAvsNodeType."""

    UNKNOWN = "Unknown"
    AV36 = "AV36"


class AzureAvsSuitabilityExplanation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureAvsSuitabilityExplanation."""

    UNKNOWN = "Unknown"
    NOT_APPLICABLE = "NotApplicable"
    UNSUPPORTED_LOCATION_FOR_SELECTED_NODE = "UnsupportedLocationForSelectedNode"


class AzureAvsVmSuitabilityDetail(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureAvsVmSuitabilityDetail."""

    NONE = "None"
    PERCENTAGE_OF_CORES_UTILIZED_MISSING = "PercentageOfCoresUtilizedMissing"
    PERCENTAGE_OF_MEMORY_UTILIZED_MISSING = "PercentageOfMemoryUtilizedMissing"
    PERCENTAGE_OF_CORES_UTILIZED_OUT_OF_RANGE = "PercentageOfCoresUtilizedOutOfRange"
    PERCENTAGE_OF_MEMORY_UTILIZED_OUT_OF_RANGE = "PercentageOfMemoryUtilizedOutOfRange"
    PERCENTAGE_OF_STORAGE_UTILIZED_OUT_OF_RANGE = "PercentageOfStorageUtilizedOutOfRange"


class AzureAvsVmSuitabilityExplanation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureAvsVmSuitabilityExplanation."""

    UNKNOWN = "Unknown"
    NOT_APPLICABLE = "NotApplicable"
    IP_V6_NOT_SUPPORTED = "IpV6NotSupported"
    UNSUPPORTED_OPERATING_SYSTEM = "UnsupportedOperatingSystem"


class AzureCurrency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Currency for Azure."""

    UNKNOWN = "Unknown"
    USD = "USD"
    DKK = "DKK"
    CAD = "CAD"
    IDR = "IDR"
    JPY = "JPY"
    KRW = "KRW"
    NZD = "NZD"
    NOK = "NOK"
    RUB = "RUB"
    SAR = "SAR"
    ZAR = "ZAR"
    SEK = "SEK"
    TRY = "TRY"
    GBP = "GBP"
    MXN = "MXN"
    MYR = "MYR"
    INR = "INR"
    HKD = "HKD"
    BRL = "BRL"
    TWD = "TWD"
    EUR = "EUR"
    CHF = "CHF"
    ARS = "ARS"
    AUD = "AUD"
    CNY = "CNY"
    TRY_ENUM = "TRY"


class AzureDiskSize(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureDiskSize."""

    UNKNOWN = "Unknown"
    STANDARD_S4 = "Standard_S4"
    STANDARD_S6 = "Standard_S6"
    STANDARD_S10 = "Standard_S10"
    STANDARD_S15 = "Standard_S15"
    STANDARD_S20 = "Standard_S20"
    STANDARD_S30 = "Standard_S30"
    STANDARD_S40 = "Standard_S40"
    STANDARD_S50 = "Standard_S50"
    STANDARD_S60 = "Standard_S60"
    STANDARD_S70 = "Standard_S70"
    STANDARD_S80 = "Standard_S80"
    PREMIUM_P4 = "Premium_P4"
    PREMIUM_P6 = "Premium_P6"
    PREMIUM_P10 = "Premium_P10"
    PREMIUM_P15 = "Premium_P15"
    PREMIUM_P20 = "Premium_P20"
    PREMIUM_P30 = "Premium_P30"
    PREMIUM_P40 = "Premium_P40"
    PREMIUM_P50 = "Premium_P50"
    PREMIUM_P60 = "Premium_P60"
    PREMIUM_P70 = "Premium_P70"
    PREMIUM_P80 = "Premium_P80"
    STANDARD_SSDE10 = "StandardSSD_E10"
    STANDARD_SSDE15 = "StandardSSD_E15"
    STANDARD_SSDE20 = "StandardSSD_E20"
    STANDARD_SSDE30 = "StandardSSD_E30"
    STANDARD_SSDE40 = "StandardSSD_E40"
    STANDARD_SSDE50 = "StandardSSD_E50"
    STANDARD_SSDE60 = "StandardSSD_E60"
    STANDARD_SSDE70 = "StandardSSD_E70"
    STANDARD_SSDE80 = "StandardSSD_E80"
    STANDARD_SSDE4 = "StandardSSD_E4"
    STANDARD_SSDE6 = "StandardSSD_E6"
    STANDARD_SSDE1 = "StandardSSD_E1"
    STANDARD_SSDE2 = "StandardSSD_E2"
    STANDARD_SSDE3 = "StandardSSD_E3"
    PREMIUM_P1 = "Premium_P1"
    PREMIUM_P2 = "Premium_P2"
    PREMIUM_P3 = "Premium_P3"
    ULTRA = "Ultra"
    PREMIUM_V2 = "PremiumV2"


class AzureDiskSuitabilityDetail(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureDiskSuitabilityDetail."""

    NONE = "None"
    NUMBER_OF_READ_OPERATIONS_PER_SECOND_MISSING = "NumberOfReadOperationsPerSecondMissing"
    NUMBER_OF_WRITE_OPERATIONS_PER_SECOND_MISSING = "NumberOfWriteOperationsPerSecondMissing"
    MEGABYTES_PER_SECOND_OF_READ_MISSING = "MegabytesPerSecondOfReadMissing"
    MEGABYTES_PER_SECOND_OF_WRITE_MISSING = "MegabytesPerSecondOfWriteMissing"
    DISK_GIGABYTES_CONSUMED_MISSING = "DiskGigabytesConsumedMissing"
    DISK_GIGABYTES_PROVISIONED_MISSING = "DiskGigabytesProvisionedMissing"
    NUMBER_OF_READ_OPERATIONS_PER_SECOND_OUT_OF_RANGE = "NumberOfReadOperationsPerSecondOutOfRange"
    NUMBER_OF_WRITE_OPERATIONS_PER_SECOND_OUT_OF_RANGE = "NumberOfWriteOperationsPerSecondOutOfRange"
    MEGABYTES_PER_SECOND_OF_READ_OUT_OF_RANGE = "MegabytesPerSecondOfReadOutOfRange"
    MEGABYTES_PER_SECOND_OF_WRITE_OUT_OF_RANGE = "MegabytesPerSecondOfWriteOutOfRange"
    DISK_GIGABYTES_CONSUMED_OUT_OF_RANGE = "DiskGigabytesConsumedOutOfRange"
    DISK_GIGABYTES_PROVISIONED_OUT_OF_RANGE = "DiskGigabytesProvisionedOutOfRange"


class AzureDiskSuitabilityExplanation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureDiskSuitabilityExplanation."""

    UNKNOWN = "Unknown"
    NOT_APPLICABLE = "NotApplicable"
    DISK_SIZE_GREATER_THAN_SUPPORTED = "DiskSizeGreaterThanSupported"
    NO_SUITABLE_DISK_SIZE_FOR_IOPS = "NoSuitableDiskSizeForIops"
    NO_SUITABLE_DISK_SIZE_FOR_THROUGHPUT = "NoSuitableDiskSizeForThroughput"
    NO_DISK_SIZE_FOUND_IN_SELECTED_LOCATION = "NoDiskSizeFoundInSelectedLocation"
    NO_DISK_SIZE_FOUND_FOR_SELECTED_REDUNDANCY = "NoDiskSizeFoundForSelectedRedundancy"
    INTERNAL_ERROR_OCCURRED_FOR_DISK_EVALUATION = "InternalErrorOccurredForDiskEvaluation"
    NO_EA_PRICE_FOUND_FOR_DISK_SIZE = "NoEaPriceFoundForDiskSize"


class AzureDiskType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureDiskType."""

    UNKNOWN = "Unknown"
    STANDARD = "Standard"
    STANDARD_SSD = "StandardSSD"
    PREMIUM = "Premium"
    STANDARD_OR_PREMIUM = "StandardOrPremium"
    ULTRA = "Ultra"
    PREMIUM_V2 = "PremiumV2"


class AzureHybridUseBenefit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureHybridUseBenefit."""

    UNKNOWN = "Unknown"
    YES = "Yes"
    NO = "No"


class AzureLocation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Location for Azure."""

    UNKNOWN = "Unknown"
    EAST_ASIA = "EastAsia"
    SOUTHEAST_ASIA = "SoutheastAsia"
    AUSTRALIA_EAST = "AustraliaEast"
    AUSTRALIA_SOUTHEAST = "AustraliaSoutheast"
    BRAZIL_SOUTH = "BrazilSouth"
    CANADA_CENTRAL = "CanadaCentral"
    CANADA_EAST = "CanadaEast"
    WEST_EUROPE = "WestEurope"
    NORTH_EUROPE = "NorthEurope"
    CENTRAL_INDIA = "CentralIndia"
    SOUTH_INDIA = "SouthIndia"
    WEST_INDIA = "WestIndia"
    JAPAN_EAST = "JapanEast"
    JAPAN_WEST = "JapanWest"
    KOREA_CENTRAL = "KoreaCentral"
    KOREA_SOUTH = "KoreaSouth"
    UK_WEST = "UkWest"
    UK_SOUTH = "UkSouth"
    NORTH_CENTRAL_US = "NorthCentralUs"
    EAST_US = "EastUs"
    WEST_US2 = "WestUs2"
    SOUTH_CENTRAL_US = "SouthCentralUs"
    CENTRAL_US = "CentralUs"
    EAST_US2 = "EastUs2"
    WEST_US = "WestUs"
    WEST_CENTRAL_US = "WestCentralUs"
    GERMANY_CENTRAL = "GermanyCentral"
    GERMANY_NORTHEAST = "GermanyNortheast"
    CHINA_NORTH = "ChinaNorth"
    CHINA_EAST = "ChinaEast"
    US_GOV_ARIZONA = "USGovArizona"
    US_GOV_TEXAS = "USGovTexas"
    US_GOV_IOWA = "USGovIowa"
    US_GOV_VIRGINIA = "USGovVirginia"
    US_DO_D_CENTRAL = "USDoDCentral"
    US_DO_D_EAST = "USDoDEast"
    FRANCE_CENTRAL = "FranceCentral"
    AUSTRALIA_CENTRAL = "AustraliaCentral"
    SOUTH_AFRICA_NORTH = "SouthAfricaNorth"
    FRANCE_SOUTH = "FranceSouth"
    AUSTRALIA_CENTRAL2 = "AustraliaCentral2"
    SOUTH_AFRICA_WEST = "SouthAfricaWest"
    GERMANY_NORTH = "GermanyNorth"
    GERMANY_WEST_CENTRAL = "GermanyWestCentral"
    NORWAY_EAST = "NorwayEast"
    NORWAY_WEST = "NorwayWest"
    CHINA_EAST2 = "ChinaEast2"
    CHINA_NORTH2 = "ChinaNorth2"
    SWITZERLAND_NORTH = "SwitzerlandNorth"
    SWITZERLAND_WEST = "SwitzerlandWest"
    UAE_NORTH = "UAENorth"
    UAE_CENTRAL = "UAECentral"
    US_NAT_EAST = "UsNatEast"
    US_NAT_WEST = "UsNatWest"
    US_SEC_EAST = "UsSecEast"
    US_SEC_CENTRAL = "UsSecCentral"
    US_SEC_WEST = "UsSecWest"
    SWEDEN_CENTRAL = "SwedenCentral"
    QATAR_CENTRAL = "QatarCentral"


class AzureManagedDiskSkuDTODiskRedundancy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureManagedDiskSkuDTODiskRedundancy."""

    UNKNOWN = "Unknown"
    LRS = "LRS"
    ZRS = "ZRS"


class AzureManagedDiskSkuDTODiskType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureManagedDiskSkuDTODiskType."""

    UNKNOWN = "Unknown"
    STANDARD = "Standard"
    STANDARD_SSD = "StandardSSD"
    PREMIUM = "Premium"
    STANDARD_OR_PREMIUM = "StandardOrPremium"
    ULTRA = "Ultra"
    PREMIUM_V2 = "PremiumV2"


class AzureNetworkAdapterSuitabilityDetail(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureNetworkAdapterSuitabilityDetail."""

    NONE = "None"
    MEGABYTES_OF_DATA_TRANSMITTED_MISSING = "MegabytesOfDataTransmittedMissing"
    MEGABYTES_OF_DATA_TRANSMITTED_OUT_OF_RANGE = "MegabytesOfDataTransmittedOutOfRange"
    MEGABYTES_OF_DATA_RECIEVED_MISSING = "MegabytesOfDataRecievedMissing"
    MEGABYTES_OF_DATA_RECIEVED_OUT_OF_RANGE = "MegabytesOfDataRecievedOutOfRange"


class AzureNetworkAdapterSuitabilityExplanation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureNetworkAdapterSuitabilityExplanation."""

    UNKNOWN = "Unknown"
    NOT_APPLICABLE = "NotApplicable"
    INTERNAL_ERROR_OCCURRED = "InternalErrorOccurred"


class AzureOfferCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureOfferCode."""

    UNKNOWN = "Unknown"
    MSAZR0003_P = "MSAZR0003P"
    MSAZR0044_P = "MSAZR0044P"
    MSAZR0059_P = "MSAZR0059P"
    MSAZR0060_P = "MSAZR0060P"
    MSAZR0062_P = "MSAZR0062P"
    MSAZR0063_P = "MSAZR0063P"
    MSAZR0064_P = "MSAZR0064P"
    MSAZR0029_P = "MSAZR0029P"
    MSAZR0022_P = "MSAZR0022P"
    MSAZR0023_P = "MSAZR0023P"
    MSAZR0148_P = "MSAZR0148P"
    MSAZR0025_P = "MSAZR0025P"
    MSAZR0036_P = "MSAZR0036P"
    MSAZR0120_P = "MSAZR0120P"
    MSAZR0121_P = "MSAZR0121P"
    MSAZR0122_P = "MSAZR0122P"
    MSAZR0123_P = "MSAZR0123P"
    MSAZR0124_P = "MSAZR0124P"
    MSAZR0125_P = "MSAZR0125P"
    MSAZR0126_P = "MSAZR0126P"
    MSAZR0127_P = "MSAZR0127P"
    MSAZR0128_P = "MSAZR0128P"
    MSAZR0129_P = "MSAZR0129P"
    MSAZR0130_P = "MSAZR0130P"
    MSAZR0111_P = "MSAZR0111P"
    MSAZR0144_P = "MSAZR0144P"
    MSAZR0149_P = "MSAZR0149P"
    MSMCAZR0044_P = "MSMCAZR0044P"
    MSMCAZR0059_P = "MSMCAZR0059P"
    MSMCAZR0060_P = "MSMCAZR0060P"
    MSMCAZR0063_P = "MSMCAZR0063P"
    MSMCAZR0120_P = "MSMCAZR0120P"
    MSMCAZR0121_P = "MSMCAZR0121P"
    MSMCAZR0125_P = "MSMCAZR0125P"
    MSMCAZR0128_P = "MSMCAZR0128P"
    MSAZRDE0003_P = "MSAZRDE0003P"
    MSAZRDE0044_P = "MSAZRDE0044P"
    MSAZRUSGOV0003_P = "MSAZRUSGOV0003P"
    EA = "EA"
    MSAZR0243_P = "MSAZR0243P"
    SAVINGS_PLAN1_YEAR = "SavingsPlan1Year"
    SAVINGS_PLAN3_YEAR = "SavingsPlan3Year"


class AzurePricingTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzurePricingTier."""

    STANDARD = "Standard"
    BASIC = "Basic"


class AzureQuorumWitnessDTOQuorumWitnessType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureQuorumWitnessDTOQuorumWitnessType."""

    UNKNOWN = "Unknown"
    CLOUD = "Cloud"
    DISK = "Disk"


class AzureReservedInstance(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureReservedInstance."""

    NONE = "None"
    RI1_YEAR = "RI1Year"
    RI3_YEAR = "RI3Year"


class AzureSecurityOfferingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureSecurityOfferingType."""

    NO = "NO"
    MDC = "MDC"


class AzureSqlDataBaseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureSqlDataBaseType."""

    UNKNOWN = "Unknown"
    AUTOMATIC = "Automatic"
    SINGLE_DATABASE = "SingleDatabase"
    ELASTIC_POOL = "ElasticPool"


class AzureSqlInstanceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureSqlInstanceType."""

    UNKNOWN = "Unknown"
    AUTOMATIC = "Automatic"
    SINGLE_INSTANCE = "SingleInstance"
    INSTANCE_POOLS = "InstancePools"


class AzureSqlPurchaseModel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureSqlPurchaseModel."""

    UNKNOWN = "Unknown"
    V_CORE = "VCore"
    DTU = "DTU"


class AzureSqlServiceTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureSqlServiceTier."""

    UNKNOWN = "Unknown"
    AUTOMATIC = "Automatic"
    GENERAL_PURPOSE = "GeneralPurpose"
    BUSINESS_CRITICAL = "BusinessCritical"
    HYPER_SCALE = "HyperScale"


class AzureStorageRedundancy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureStorageRedundancy."""

    UNKNOWN = "Unknown"
    LOCALLY_REDUNDANT = "LocallyRedundant"
    ZONE_REDUNDANT = "ZoneRedundant"
    GEO_REDUNDANT = "GeoRedundant"
    READ_ACCESS_GEO_REDUNDANT = "ReadAccessGeoRedundant"


class AzureVmFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureVmFamily."""

    UNKNOWN = "Unknown"
    BASIC_A0_A4 = "Basic_A0_A4"
    STANDARD_A0_A7 = "Standard_A0_A7"
    STANDARD_A8_A11 = "Standard_A8_A11"
    AV2_SERIES = "Av2_series"
    D_SERIES = "D_series"
    DV2_SERIES = "Dv2_series"
    DS_SERIES = "DS_series"
    D_SV2_SERIES = "DSv2_series"
    F_SERIES = "F_series"
    FS_SERIES = "Fs_series"
    G_SERIES = "G_series"
    GS_SERIES = "GS_series"
    H_SERIES = "H_series"
    LS_SERIES = "Ls_series"
    DSV3_SERIES = "Dsv3_series"
    DV3_SERIES = "Dv3_series"
    FSV2_SERIES = "Fsv2_series"
    EV3_SERIES = "Ev3_series"
    ESV3_SERIES = "Esv3_series"
    M_SERIES = "M_series"
    DC_SERIES = "DC_Series"
    LSV2_SERIES = "Lsv2_series"
    EV4_SERIES = "Ev4_series"
    ESV4_SERIES = "Esv4_series"
    EDV4_SERIES = "Edv4_series"
    EDSV4_SERIES = "Edsv4_series"
    DV4_SERIES = "Dv4_series"
    DSV4_SERIES = "Dsv4_series"
    DDV4_SERIES = "Ddv4_series"
    DDSV4_SERIES = "Ddsv4_series"
    EASV4_SERIES = "Easv4_series"
    DASV4_SERIES = "Dasv4_series"
    MV2_SERIES = "Mv2_series"
    EAV4_SERIES = "Eav4_series"
    DAV4_SERIES = "Dav4_series"
    MSV2_SERIES = "Msv2_series"
    MDSV2_SERIES = "Mdsv2_series"
    DV5_SERIES = "Dv5_series"
    DSV5_SERIES = "Dsv5_series"
    DDV5_SERIES = "Ddv5_series"
    DDSV5_SERIES = "Ddsv5_series"
    DASV5_SERIES = "Dasv5_series"
    DADSV5_SERIES = "Dadsv5_series"
    EV5_SERIES = "Ev5_series"
    ESV5_SERIES = "Esv5_series"
    EDV5_SERIES = "Edv5_series"
    EDSV5_SERIES = "Edsv5_series"
    EASV5_SERIES = "Easv5_series"
    EADSV5_SERIES = "Eadsv5_series"
    EBSV5_SERIES = "Ebsv5_series"
    EBDSV5_SERIES = "Ebdsv5_series"


class AzureVmSize(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureVmSize."""

    UNKNOWN = "Unknown"
    BASIC_A0 = "Basic_A0"
    BASIC_A1 = "Basic_A1"
    BASIC_A2 = "Basic_A2"
    BASIC_A3 = "Basic_A3"
    BASIC_A4 = "Basic_A4"
    STANDARD_A0 = "Standard_A0"
    STANDARD_A1 = "Standard_A1"
    STANDARD_A2 = "Standard_A2"
    STANDARD_A3 = "Standard_A3"
    STANDARD_A4 = "Standard_A4"
    STANDARD_A5 = "Standard_A5"
    STANDARD_A6 = "Standard_A6"
    STANDARD_A7 = "Standard_A7"
    STANDARD_A8 = "Standard_A8"
    STANDARD_A9 = "Standard_A9"
    STANDARD_A10 = "Standard_A10"
    STANDARD_A11 = "Standard_A11"
    STANDARD_A1_V2 = "Standard_A1_v2"
    STANDARD_A2_V2 = "Standard_A2_v2"
    STANDARD_A4_V2 = "Standard_A4_v2"
    STANDARD_A8_V2 = "Standard_A8_v2"
    STANDARD_A2_MV2 = "Standard_A2m_v2"
    STANDARD_A4_MV2 = "Standard_A4m_v2"
    STANDARD_A8_MV2 = "Standard_A8m_v2"
    STANDARD_D1 = "Standard_D1"
    STANDARD_D2 = "Standard_D2"
    STANDARD_D3 = "Standard_D3"
    STANDARD_D4 = "Standard_D4"
    STANDARD_D11 = "Standard_D11"
    STANDARD_D12 = "Standard_D12"
    STANDARD_D13 = "Standard_D13"
    STANDARD_D14 = "Standard_D14"
    STANDARD_D1_V2 = "Standard_D1_v2"
    STANDARD_D2_V2 = "Standard_D2_v2"
    STANDARD_D3_V2 = "Standard_D3_v2"
    STANDARD_D4_V2 = "Standard_D4_v2"
    STANDARD_D5_V2 = "Standard_D5_v2"
    STANDARD_D11_V2 = "Standard_D11_v2"
    STANDARD_D12_V2 = "Standard_D12_v2"
    STANDARD_D13_V2 = "Standard_D13_v2"
    STANDARD_D14_V2 = "Standard_D14_v2"
    STANDARD_D15_V2 = "Standard_D15_v2"
    STANDARD_DS1 = "Standard_DS1"
    STANDARD_DS2 = "Standard_DS2"
    STANDARD_DS3 = "Standard_DS3"
    STANDARD_DS4 = "Standard_DS4"
    STANDARD_DS11 = "Standard_DS11"
    STANDARD_DS12 = "Standard_DS12"
    STANDARD_DS13 = "Standard_DS13"
    STANDARD_DS14 = "Standard_DS14"
    STANDARD_DS1_V2 = "Standard_DS1_v2"
    STANDARD_DS2_V2 = "Standard_DS2_v2"
    STANDARD_DS3_V2 = "Standard_DS3_v2"
    STANDARD_DS4_V2 = "Standard_DS4_v2"
    STANDARD_DS5_V2 = "Standard_DS5_v2"
    STANDARD_DS11_V2 = "Standard_DS11_v2"
    STANDARD_DS12_V2 = "Standard_DS12_v2"
    STANDARD_DS13_V2 = "Standard_DS13_v2"
    STANDARD_DS14_V2 = "Standard_DS14_v2"
    STANDARD_DS15_V2 = "Standard_DS15_v2"
    STANDARD_F1 = "Standard_F1"
    STANDARD_F2 = "Standard_F2"
    STANDARD_F4 = "Standard_F4"
    STANDARD_F8 = "Standard_F8"
    STANDARD_F16 = "Standard_F16"
    STANDARD_F1_S = "Standard_F1s"
    STANDARD_F2_S = "Standard_F2s"
    STANDARD_F4_S = "Standard_F4s"
    STANDARD_F8_S = "Standard_F8s"
    STANDARD_F16_S = "Standard_F16s"
    STANDARD_G1 = "Standard_G1"
    STANDARD_G2 = "Standard_G2"
    STANDARD_G3 = "Standard_G3"
    STANDARD_G4 = "Standard_G4"
    STANDARD_G5 = "Standard_G5"
    STANDARD_GS1 = "Standard_GS1"
    STANDARD_GS2 = "Standard_GS2"
    STANDARD_GS3 = "Standard_GS3"
    STANDARD_GS4 = "Standard_GS4"
    STANDARD_GS5 = "Standard_GS5"
    STANDARD_H8 = "Standard_H8"
    STANDARD_H16 = "Standard_H16"
    STANDARD_H8_M = "Standard_H8m"
    STANDARD_H16_M = "Standard_H16m"
    STANDARD_H16_R = "Standard_H16r"
    STANDARD_H16_MR = "Standard_H16mr"
    STANDARD_L4_S = "Standard_L4s"
    STANDARD_L8_S = "Standard_L8s"
    STANDARD_L16_S = "Standard_L16s"
    STANDARD_L32_S = "Standard_L32s"
    STANDARD_D2_SV3 = "Standard_D2s_v3"
    STANDARD_D4_SV3 = "Standard_D4s_v3"
    STANDARD_D8_SV3 = "Standard_D8s_v3"
    STANDARD_D16_SV3 = "Standard_D16s_v3"
    STANDARD_D32_SV3 = "Standard_D32s_v3"
    STANDARD_D64_SV3 = "Standard_D64s_v3"
    STANDARD_D2_V3 = "Standard_D2_v3"
    STANDARD_D4_V3 = "Standard_D4_v3"
    STANDARD_D8_V3 = "Standard_D8_v3"
    STANDARD_D16_V3 = "Standard_D16_v3"
    STANDARD_D32_V3 = "Standard_D32_v3"
    STANDARD_D64_V3 = "Standard_D64_v3"
    STANDARD_F2_SV2 = "Standard_F2s_v2"
    STANDARD_F4_SV2 = "Standard_F4s_v2"
    STANDARD_F8_SV2 = "Standard_F8s_v2"
    STANDARD_F16_SV2 = "Standard_F16s_v2"
    STANDARD_F32_SV2 = "Standard_F32s_v2"
    STANDARD_F64_SV2 = "Standard_F64s_v2"
    STANDARD_F72_SV2 = "Standard_F72s_v2"
    STANDARD_E2_V3 = "Standard_E2_v3"
    STANDARD_E4_V3 = "Standard_E4_v3"
    STANDARD_E8_V3 = "Standard_E8_v3"
    STANDARD_E16_V3 = "Standard_E16_v3"
    STANDARD_E32_V3 = "Standard_E32_v3"
    STANDARD_E64_V3 = "Standard_E64_v3"
    STANDARD_E2_SV3 = "Standard_E2s_v3"
    STANDARD_E4_SV3 = "Standard_E4s_v3"
    STANDARD_E8_SV3 = "Standard_E8s_v3"
    STANDARD_E16_SV3 = "Standard_E16s_v3"
    STANDARD_E32_SV3 = "Standard_E32s_v3"
    STANDARD_E64_SV3 = "Standard_E64s_v3"
    STANDARD_M64_S = "Standard_M64s"
    STANDARD_M64_MS = "Standard_M64ms"
    STANDARD_M128_S = "Standard_M128s"
    STANDARD_M128_MS = "Standard_M128ms"
    STANDARD_DC2_S = "Standard_DC2s"
    STANDARD_DC4_S = "Standard_DC4s"
    STANDARD_E20_V3 = "Standard_E20_v3"
    STANDARD_E20_SV3 = "Standard_E20s_v3"
    STANDARD_E64_IV3 = "Standard_E64i_v3"
    STANDARD_E64_IS_V3 = "Standard_E64is_v3"
    STANDARD_M8_MS = "Standard_M8ms"
    STANDARD_M16_MS = "Standard_M16ms"
    STANDARD_M32_LS = "Standard_M32ls"
    STANDARD_M32_MS = "Standard_M32ms"
    STANDARD_M32_TS = "Standard_M32ts"
    STANDARD_M64 = "Standard_M64"
    STANDARD_M64_LS = "Standard_M64ls"
    STANDARD_M64_M = "Standard_M64m"
    STANDARD_M128 = "Standard_M128"
    STANDARD_M128_M = "Standard_M128m"
    STANDARD_L8_SV2 = "Standard_L8s_v2"
    STANDARD_L16_SV2 = "Standard_L16s_v2"
    STANDARD_L32_SV2 = "Standard_L32s_v2"
    STANDARD_L48_SV2 = "Standard_L48s_v2"
    STANDARD_L64_SV2 = "Standard_L64s_v2"
    STANDARD_L80_SV2 = "Standard_L80s_v2"
    STANDARD_D2_V4 = "Standard_D2_v4"
    STANDARD_D4_V4 = "Standard_D4_v4"
    STANDARD_D8_V4 = "Standard_D8_v4"
    STANDARD_D16_V4 = "Standard_D16_v4"
    STANDARD_D32_V4 = "Standard_D32_v4"
    STANDARD_D48_V4 = "Standard_D48_v4"
    STANDARD_D64_V4 = "Standard_D64_v4"
    STANDARD_D2_SV4 = "Standard_D2s_v4"
    STANDARD_D4_SV4 = "Standard_D4s_v4"
    STANDARD_D8_SV4 = "Standard_D8s_v4"
    STANDARD_D16_SV4 = "Standard_D16s_v4"
    STANDARD_D32_SV4 = "Standard_D32s_v4"
    STANDARD_D48_SV4 = "Standard_D48s_v4"
    STANDARD_D64_SV4 = "Standard_D64s_v4"
    STANDARD_D2_DV4 = "Standard_D2d_v4"
    STANDARD_D4_DV4 = "Standard_D4d_v4"
    STANDARD_D8_DV4 = "Standard_D8d_v4"
    STANDARD_D16_DV4 = "Standard_D16d_v4"
    STANDARD_D32_DV4 = "Standard_D32d_v4"
    STANDARD_D48_DV4 = "Standard_D48d_v4"
    STANDARD_D64_DV4 = "Standard_D64d_v4"
    STANDARD_D2_DS_V4 = "Standard_D2ds_v4"
    STANDARD_D4_DS_V4 = "Standard_D4ds_v4"
    STANDARD_D8_DS_V4 = "Standard_D8ds_v4"
    STANDARD_D16_DS_V4 = "Standard_D16ds_v4"
    STANDARD_D32_DS_V4 = "Standard_D32ds_v4"
    STANDARD_D48_DS_V4 = "Standard_D48ds_v4"
    STANDARD_D64_DS_V4 = "Standard_D64ds_v4"
    STANDARD_E2_V4 = "Standard_E2_v4"
    STANDARD_E4_V4 = "Standard_E4_v4"
    STANDARD_E8_V4 = "Standard_E8_v4"
    STANDARD_E16_V4 = "Standard_E16_v4"
    STANDARD_E20_V4 = "Standard_E20_v4"
    STANDARD_E32_V4 = "Standard_E32_v4"
    STANDARD_E48_V4 = "Standard_E48_v4"
    STANDARD_E64_V4 = "Standard_E64_v4"
    STANDARD_E2_SV4 = "Standard_E2s_v4"
    STANDARD_E4_SV4 = "Standard_E4s_v4"
    STANDARD_E8_SV4 = "Standard_E8s_v4"
    STANDARD_E16_SV4 = "Standard_E16s_v4"
    STANDARD_E20_SV4 = "Standard_E20s_v4"
    STANDARD_E32_SV4 = "Standard_E32s_v4"
    STANDARD_E48_SV4 = "Standard_E48s_v4"
    STANDARD_E64_SV4 = "Standard_E64s_v4"
    STANDARD_E2_DV4 = "Standard_E2d_v4"
    STANDARD_E4_DV4 = "Standard_E4d_v4"
    STANDARD_E8_DV4 = "Standard_E8d_v4"
    STANDARD_E16_DV4 = "Standard_E16d_v4"
    STANDARD_E20_DV4 = "Standard_E20d_v4"
    STANDARD_E32_DV4 = "Standard_E32d_v4"
    STANDARD_E48_DV4 = "Standard_E48d_v4"
    STANDARD_E64_DV4 = "Standard_E64d_v4"
    STANDARD_E2_DS_V4 = "Standard_E2ds_v4"
    STANDARD_E4_DS_V4 = "Standard_E4ds_v4"
    STANDARD_E8_DS_V4 = "Standard_E8ds_v4"
    STANDARD_E16_DS_V4 = "Standard_E16ds_v4"
    STANDARD_E20_DS_V4 = "Standard_E20ds_v4"
    STANDARD_E32_DS_V4 = "Standard_E32ds_v4"
    STANDARD_E48_DS_V4 = "Standard_E48ds_v4"
    STANDARD_E64_DS_V4 = "Standard_E64ds_v4"
    STANDARD_E2_AS_V4 = "Standard_E2as_v4"
    STANDARD_E4_AS_V4 = "Standard_E4as_v4"
    STANDARD_E8_AS_V4 = "Standard_E8as_v4"
    STANDARD_E16_AS_V4 = "Standard_E16as_v4"
    STANDARD_E20_AS_V4 = "Standard_E20as_v4"
    STANDARD_E32_AS_V4 = "Standard_E32as_v4"
    STANDARD_E48_AS_V4 = "Standard_E48as_v4"
    STANDARD_E64_AS_V4 = "Standard_E64as_v4"
    STANDARD_E96_AS_V4 = "Standard_E96as_v4"
    STANDARD_D2_AS_V4 = "Standard_D2as_v4"
    STANDARD_D4_AS_V4 = "Standard_D4as_v4"
    STANDARD_D8_AS_V4 = "Standard_D8as_v4"
    STANDARD_D16_AS_V4 = "Standard_D16as_v4"
    STANDARD_D32_AS_V4 = "Standard_D32as_v4"
    STANDARD_D48_AS_V4 = "Standard_D48as_v4"
    STANDARD_D64_AS_V4 = "Standard_D64as_v4"
    STANDARD_D96_AS_V4 = "Standard_D96as_v4"
    STANDARD_M208_MS_V2 = "Standard_M208ms_v2"
    STANDARD_M208_SV2 = "Standard_M208s_v2"
    STANDARD_M416_MS_V2 = "Standard_M416ms_v2"
    STANDARD_M416_SV2 = "Standard_M416s_v2"
    STANDARD_F48_SV2 = "Standard_F48s_v2"
    STANDARD_E48_V3 = "Standard_E48_v3"
    STANDARD_E48_SV3 = "Standard_E48s_v3"
    STANDARD_E80_IS_V4 = "Standard_E80is_v4"
    STANDARD_E80_IDS_V4 = "Standard_E80ids_v4"
    STANDARD_E2_AV4 = "Standard_E2a_v4"
    STANDARD_E4_AV4 = "Standard_E4a_v4"
    STANDARD_E8_AV4 = "Standard_E8a_v4"
    STANDARD_E16_AV4 = "Standard_E16a_v4"
    STANDARD_E20_AV4 = "Standard_E20a_v4"
    STANDARD_E32_AV4 = "Standard_E32a_v4"
    STANDARD_E48_AV4 = "Standard_E48a_v4"
    STANDARD_E64_AV4 = "Standard_E64a_v4"
    STANDARD_E96_AV4 = "Standard_E96a_v4"
    STANDARD_D2_AV4 = "Standard_D2a_v4"
    STANDARD_D4_AV4 = "Standard_D4a_v4"
    STANDARD_D8_AV4 = "Standard_D8a_v4"
    STANDARD_D16_AV4 = "Standard_D16a_v4"
    STANDARD_D32_AV4 = "Standard_D32a_v4"
    STANDARD_D48_AV4 = "Standard_D48a_v4"
    STANDARD_D64_AV4 = "Standard_D64a_v4"
    STANDARD_D96_AV4 = "Standard_D96a_v4"
    STANDARD_M32_MS_V2 = "Standard_M32ms_v2"
    STANDARD_M64_SV2 = "Standard_M64s_v2"
    STANDARD_M64_MS_V2 = "Standard_M64ms_v2"
    STANDARD_M128_SV2 = "Standard_M128s_v2"
    STANDARD_M128_MS_V2 = "Standard_M128ms_v2"
    STANDARD_M192_IS_V2 = "Standard_M192is_v2"
    STANDARD_M192_IMS_V2 = "Standard_M192ims_v2"
    STANDARD_M32_DMS_V2 = "Standard_M32dms_v2"
    STANDARD_M64_DS_V2 = "Standard_M64ds_v2"
    STANDARD_M64_DMS_V2 = "Standard_M64dms_v2"
    STANDARD_M128_DS_V2 = "Standard_M128ds_v2"
    STANDARD_M128_DMS_V2 = "Standard_M128dms_v2"
    STANDARD_M192_IDS_V2 = "Standard_M192ids_v2"
    STANDARD_M192_IDMS_V2 = "Standard_M192idms_v2"
    STANDARD_D2_V5 = "Standard_D2_v5"
    STANDARD_D4_V5 = "Standard_D4_v5"
    STANDARD_D8_V5 = "Standard_D8_v5"
    STANDARD_D16_V5 = "Standard_D16_v5"
    STANDARD_D32_V5 = "Standard_D32_v5"
    STANDARD_D48_V5 = "Standard_D48_v5"
    STANDARD_D64_V5 = "Standard_D64_v5"
    STANDARD_D96_V5 = "Standard_D96_v5"
    STANDARD_D2_SV5 = "Standard_D2s_v5"
    STANDARD_D4_SV5 = "Standard_D4s_v5"
    STANDARD_D8_SV5 = "Standard_D8s_v5"
    STANDARD_D16_SV5 = "Standard_D16s_v5"
    STANDARD_D32_SV5 = "Standard_D32s_v5"
    STANDARD_D48_SV5 = "Standard_D48s_v5"
    STANDARD_D64_SV5 = "Standard_D64s_v5"
    STANDARD_D96_SV5 = "Standard_D96s_v5"
    STANDARD_D2_DV5 = "Standard_D2d_v5"
    STANDARD_D4_DV5 = "Standard_D4d_v5"
    STANDARD_D8_DV5 = "Standard_D8d_v5"
    STANDARD_D16_DV5 = "Standard_D16d_v5"
    STANDARD_D32_DV5 = "Standard_D32d_v5"
    STANDARD_D48_DV5 = "Standard_D48d_v5"
    STANDARD_D64_DV5 = "Standard_D64d_v5"
    STANDARD_D96_DV5 = "Standard_D96d_v5"
    STANDARD_D2_DS_V5 = "Standard_D2ds_v5"
    STANDARD_D4_DS_V5 = "Standard_D4ds_v5"
    STANDARD_D8_DS_V5 = "Standard_D8ds_v5"
    STANDARD_D16_DS_V5 = "Standard_D16ds_v5"
    STANDARD_D32_DS_V5 = "Standard_D32ds_v5"
    STANDARD_D48_DS_V5 = "Standard_D48ds_v5"
    STANDARD_D64_DS_V5 = "Standard_D64ds_v5"
    STANDARD_D96_DS_V5 = "Standard_D96ds_v5"
    STANDARD_D2_AS_V5 = "Standard_D2as_v5"
    STANDARD_D4_AS_V5 = "Standard_D4as_v5"
    STANDARD_D8_AS_V5 = "Standard_D8as_v5"
    STANDARD_D16_AS_V5 = "Standard_D16as_v5"
    STANDARD_D32_AS_V5 = "Standard_D32as_v5"
    STANDARD_D48_AS_V5 = "Standard_D48as_v5"
    STANDARD_D64_AS_V5 = "Standard_D64as_v5"
    STANDARD_D96_AS_V5 = "Standard_D96as_v5"
    STANDARD_D2_ADS_V5 = "Standard_D2ads_v5"
    STANDARD_D4_ADS_V5 = "Standard_D4ads_v5"
    STANDARD_D8_ADS_V5 = "Standard_D8ads_v5"
    STANDARD_D16_ADS_V5 = "Standard_D16ads_v5"
    STANDARD_D32_ADS_V5 = "Standard_D32ads_v5"
    STANDARD_D48_ADS_V5 = "Standard_D48ads_v5"
    STANDARD_D64_ADS_V5 = "Standard_D64ads_v5"
    STANDARD_D96_ADS_V5 = "Standard_D96ads_v5"
    STANDARD_E2_V5 = "Standard_E2_v5"
    STANDARD_E4_V5 = "Standard_E4_v5"
    STANDARD_E8_V5 = "Standard_E8_v5"
    STANDARD_E16_V5 = "Standard_E16_v5"
    STANDARD_E20_V5 = "Standard_E20_v5"
    STANDARD_E32_V5 = "Standard_E32_v5"
    STANDARD_E48_V5 = "Standard_E48_v5"
    STANDARD_E64_V5 = "Standard_E64_v5"
    STANDARD_E96_V5 = "Standard_E96_v5"
    STANDARD_E104_IV5 = "Standard_E104i_v5"
    STANDARD_E2_SV5 = "Standard_E2s_v5"
    STANDARD_E4_SV5 = "Standard_E4s_v5"
    STANDARD_E8_SV5 = "Standard_E8s_v5"
    STANDARD_E16_SV5 = "Standard_E16s_v5"
    STANDARD_E20_SV5 = "Standard_E20s_v5"
    STANDARD_E32_SV5 = "Standard_E32s_v5"
    STANDARD_E48_SV5 = "Standard_E48s_v5"
    STANDARD_E64_SV5 = "Standard_E64s_v5"
    STANDARD_E96_SV5 = "Standard_E96s_v5"
    STANDARD_E104_IS_V5 = "Standard_E104is_v5"
    STANDARD_E2_DV5 = "Standard_E2d_v5"
    STANDARD_E4_DV5 = "Standard_E4d_v5"
    STANDARD_E8_DV5 = "Standard_E8d_v5"
    STANDARD_E16_DV5 = "Standard_E16d_v5"
    STANDARD_E20_DV5 = "Standard_E20d_v5"
    STANDARD_E32_DV5 = "Standard_E32d_v5"
    STANDARD_E48_DV5 = "Standard_E48d_v5"
    STANDARD_E64_DV5 = "Standard_E64d_v5"
    STANDARD_E96_DV5 = "Standard_E96d_v5"
    STANDARD_E104_ID_V5 = "Standard_E104id_v5"
    STANDARD_E2_DS_V5 = "Standard_E2ds_v5"
    STANDARD_E4_DS_V5 = "Standard_E4ds_v5"
    STANDARD_E8_DS_V5 = "Standard_E8ds_v5"
    STANDARD_E16_DS_V5 = "Standard_E16ds_v5"
    STANDARD_E20_DS_V5 = "Standard_E20ds_v5"
    STANDARD_E32_DS_V5 = "Standard_E32ds_v5"
    STANDARD_E48_DS_V5 = "Standard_E48ds_v5"
    STANDARD_E64_DS_V5 = "Standard_E64ds_v5"
    STANDARD_E96_DS_V5 = "Standard_E96ds_v5"
    STANDARD_E104_IDS_V5 = "Standard_E104ids_v5"
    STANDARD_E2_AS_V5 = "Standard_E2as_v5"
    STANDARD_E4_AS_V5 = "Standard_E4as_v5"
    STANDARD_E8_AS_V5 = "Standard_E8as_v5"
    STANDARD_E16_AS_V5 = "Standard_E16as_v5"
    STANDARD_E20_AS_V5 = "Standard_E20as_v5"
    STANDARD_E32_AS_V5 = "Standard_E32as_v5"
    STANDARD_E48_AS_V5 = "Standard_E48as_v5"
    STANDARD_E64_AS_V5 = "Standard_E64as_v5"
    STANDARD_E96_AS_V5 = "Standard_E96as_v5"
    STANDARD_E2_ADS_V5 = "Standard_E2ads_v5"
    STANDARD_E4_ADS_V5 = "Standard_E4ads_v5"
    STANDARD_E8_ADS_V5 = "Standard_E8ads_v5"
    STANDARD_E16_ADS_V5 = "Standard_E16ads_v5"
    STANDARD_E20_ADS_V5 = "Standard_E20ads_v5"
    STANDARD_E32_ADS_V5 = "Standard_E32ads_v5"
    STANDARD_E48_ADS_V5 = "Standard_E48ads_v5"
    STANDARD_E64_ADS_V5 = "Standard_E64ads_v5"
    STANDARD_E96_ADS_V5 = "Standard_E96ads_v5"
    STANDARD_M82_MS = "Standard_M8_2ms"
    STANDARD_M84_MS = "Standard_M8_4ms"
    STANDARD_M164_MS = "Standard_M16_4ms"
    STANDARD_M168_MS = "Standard_M16_8ms"
    STANDARD_M328_MS = "Standard_M32_8ms"
    STANDARD_M3216_MS = "Standard_M32_16ms"
    STANDARD_M6432_MS = "Standard_M64_32ms"
    STANDARD_M6416_MS = "Standard_M64_16ms"
    STANDARD_M12864_MS = "Standard_M128_64ms"
    STANDARD_M12832_MS = "Standard_M128_32ms"
    STANDARD_E42_SV3 = "Standard_E4_2s_v3"
    STANDARD_E84_SV3 = "Standard_E8_4s_v3"
    STANDARD_E82_SV3 = "Standard_E8_2s_v3"
    STANDARD_E168_SV3 = "Standard_E16_8s_v3"
    STANDARD_E164_SV3 = "Standard_E16_4s_v3"
    STANDARD_E3216_SV3 = "Standard_E32_16s_v3"
    STANDARD_E328_SV3 = "Standard_E32_8s_v3"
    STANDARD_E6432_SV3 = "Standard_E64_32s_v3"
    STANDARD_E6416_SV3 = "Standard_E64_16s_v3"
    STANDARD_E42_SV4 = "Standard_E4_2s_v4"
    STANDARD_E84_SV4 = "Standard_E8_4s_v4"
    STANDARD_E82_SV4 = "Standard_E8_2s_v4"
    STANDARD_E168_SV4 = "Standard_E16_8s_v4"
    STANDARD_E164_SV4 = "Standard_E16_4s_v4"
    STANDARD_E3216_SV4 = "Standard_E32_16s_v4"
    STANDARD_E328_SV4 = "Standard_E32_8s_v4"
    STANDARD_E6432_SV4 = "Standard_E64_32s_v4"
    STANDARD_E6416_SV4 = "Standard_E64_16s_v4"
    STANDARD_E42_DS_V4 = "Standard_E4_2ds_v4"
    STANDARD_E84_DS_V4 = "Standard_E8_4ds_v4"
    STANDARD_E82_DS_V4 = "Standard_E8_2ds_v4"
    STANDARD_E168_DS_V4 = "Standard_E16_8ds_v4"
    STANDARD_E164_DS_V4 = "Standard_E16_4ds_v4"
    STANDARD_E3216_DS_V4 = "Standard_E32_16ds_v4"
    STANDARD_E328_DS_V4 = "Standard_E32_8ds_v4"
    STANDARD_E6432_DS_V4 = "Standard_E64_32ds_v4"
    STANDARD_E6416_DS_V4 = "Standard_E64_16ds_v4"
    STANDARD_E42_AS_V4 = "Standard_E4_2as_v4"
    STANDARD_E84_AS_V4 = "Standard_E8_4as_v4"
    STANDARD_E82_AS_V4 = "Standard_E8_2as_v4"
    STANDARD_E168_AS_V4 = "Standard_E16_8as_v4"
    STANDARD_E164_AS_V4 = "Standard_E16_4as_v4"
    STANDARD_E3216_AS_V4 = "Standard_E32_16as_v4"
    STANDARD_E328_AS_V4 = "Standard_E32_8as_v4"
    STANDARD_E6432_AS_V4 = "Standard_E64_32as_v4"
    STANDARD_E6416_AS_V4 = "Standard_E64_16as_v4"
    STANDARD_E9648_AS_V4 = "Standard_E96_48as_v4"
    STANDARD_E9624_AS_V4 = "Standard_E96_24as_v4"
    STANDARD_E42_ADS_V5 = "Standard_E4_2ads_v5"
    STANDARD_E84_ADS_V5 = "Standard_E8_4ads_v5"
    STANDARD_E82_ADS_V5 = "Standard_E8_2ads_v5"
    STANDARD_E168_ADS_V5 = "Standard_E16_8ads_v5"
    STANDARD_E164_ADS_V5 = "Standard_E16_4ads_v5"
    STANDARD_E3216_ADS_V5 = "Standard_E32_16ads_v5"
    STANDARD_E328_ADS_V5 = "Standard_E32_8ads_v5"
    STANDARD_E6432_ADS_V5 = "Standard_E64_32ads_v5"
    STANDARD_E6416_ADS_V5 = "Standard_E64_16ads_v5"
    STANDARD_E9648_ADS_V5 = "Standard_E96_48ads_v5"
    STANDARD_E9624_ADS_V5 = "Standard_E96_24ads_v5"
    STANDARD_E42_SV5 = "Standard_E4_2s_v5"
    STANDARD_E84_SV5 = "Standard_E8_4s_v5"
    STANDARD_E82_SV5 = "Standard_E8_2s_v5"
    STANDARD_E168_SV5 = "Standard_E16_8s_v5"
    STANDARD_E164_SV5 = "Standard_E16_4s_v5"
    STANDARD_E3216_SV5 = "Standard_E32_16s_v5"
    STANDARD_E328_SV5 = "Standard_E32_8s_v5"
    STANDARD_E6432_SV5 = "Standard_E64_32s_v5"
    STANDARD_E6416_SV5 = "Standard_E64_16s_v5"
    STANDARD_E9648_SV5 = "Standard_E96_48s_v5"
    STANDARD_E9624_SV5 = "Standard_E96_24s_v5"
    STANDARD_E42_DS_V5 = "Standard_E4_2ds_v5"
    STANDARD_E84_DS_V5 = "Standard_E8_4ds_v5"
    STANDARD_E82_DS_V5 = "Standard_E8_2ds_v5"
    STANDARD_E168_DS_V5 = "Standard_E16_8ds_v5"
    STANDARD_E164_DS_V5 = "Standard_E16_4ds_v5"
    STANDARD_E3216_DS_V5 = "Standard_E32_16ds_v5"
    STANDARD_E328_DS_V5 = "Standard_E32_8ds_v5"
    STANDARD_E6432_DS_V5 = "Standard_E64_32ds_v5"
    STANDARD_E6416_DS_V5 = "Standard_E64_16ds_v5"
    STANDARD_E9648_DS_V5 = "Standard_E96_48ds_v5"
    STANDARD_E9624_DS_V5 = "Standard_E96_24ds_v5"
    STANDARD_E42_AS_V5 = "Standard_E4_2as_v5"
    STANDARD_E84_AS_V5 = "Standard_E8_4as_v5"
    STANDARD_E82_AS_V5 = "Standard_E8_2as_v5"
    STANDARD_E168_AS_V5 = "Standard_E16_8as_v5"
    STANDARD_E164_AS_V5 = "Standard_E16_4as_v5"
    STANDARD_E3216_AS_V5 = "Standard_E32_16as_v5"
    STANDARD_E328_AS_V5 = "Standard_E32_8as_v5"
    STANDARD_E6432_AS_V5 = "Standard_E64_32as_v5"
    STANDARD_E6416_AS_V5 = "Standard_E64_16as_v5"
    STANDARD_E9648_AS_V5 = "Standard_E96_48as_v5"
    STANDARD_E9624_AS_V5 = "Standard_E96_24as_v5"
    STANDARD_GS48 = "Standard_GS4_8"
    STANDARD_GS44 = "Standard_GS4_4"
    STANDARD_GS516 = "Standard_GS5_16"
    STANDARD_GS58 = "Standard_GS5_8"
    STANDARD_DS111_V2 = "Standard_DS11_1_v2"
    STANDARD_DS122_V2 = "Standard_DS12_2_v2"
    STANDARD_DS121_V2 = "Standard_DS12_1_v2"
    STANDARD_DS134_V2 = "Standard_DS13_4_v2"
    STANDARD_DS132_V2 = "Standard_DS13_2_v2"
    STANDARD_DS148_V2 = "Standard_DS14_8_v2"
    STANDARD_DS144_V2 = "Standard_DS14_4_v2"
    STANDARD_M416208_SV2 = "Standard_M416_208s_v2"
    STANDARD_M416208_MS_V2 = "Standard_M416_208ms_v2"
    STANDARD_E2_BS_V5 = "Standard_E2bs_v5"
    STANDARD_E4_BS_V5 = "Standard_E4bs_v5"
    STANDARD_E8_BS_V5 = "Standard_E8bs_v5"
    STANDARD_E16_BS_V5 = "Standard_E16bs_v5"
    STANDARD_E32_BS_V5 = "Standard_E32bs_v5"
    STANDARD_E48_BS_V5 = "Standard_E48bs_v5"
    STANDARD_E64_BS_V5 = "Standard_E64bs_v5"
    STANDARD_E2_BDS_V5 = "Standard_E2bds_v5"
    STANDARD_E4_BDS_V5 = "Standard_E4bds_v5"
    STANDARD_E8_BDS_V5 = "Standard_E8bds_v5"
    STANDARD_E16_BDS_V5 = "Standard_E16bds_v5"
    STANDARD_E32_BDS_V5 = "Standard_E32bds_v5"
    STANDARD_E48_BDS_V5 = "Standard_E48bds_v5"
    STANDARD_E64_BDS_V5 = "Standard_E64bds_v5"


class AzureVmSuitabilityDetail(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureVmSuitabilityDetail."""

    NONE = "None"
    RECOMMENDED_SIZE_HAS_LESS_NETWORK_ADAPTERS = "RecommendedSizeHasLessNetworkAdapters"
    CANNOT_REPORT_COMPUTE_COST = "CannotReportComputeCost"
    CANNOT_REPORT_STORAGE_COST = "CannotReportStorageCost"
    CANNOT_REPORT_BANDWIDTH_COSTS = "CannotReportBandwidthCosts"
    PERCENTAGE_OF_CORES_UTILIZED_MISSING = "PercentageOfCoresUtilizedMissing"
    PERCENTAGE_OF_MEMORY_UTILIZED_MISSING = "PercentageOfMemoryUtilizedMissing"
    PERCENTAGE_OF_CORES_UTILIZED_OUT_OF_RANGE = "PercentageOfCoresUtilizedOutOfRange"
    PERCENTAGE_OF_MEMORY_UTILIZED_OUT_OF_RANGE = "PercentageOfMemoryUtilizedOutOfRange"


class AzureVmSuitabilityExplanation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureVmSuitabilityExplanation."""

    UNKNOWN = "Unknown"
    NOT_APPLICABLE = "NotApplicable"
    GUEST_OPERATING_SYSTEM_ARCHITECTURE_NOT_SUPPORTED = "GuestOperatingSystemArchitectureNotSupported"
    GUEST_OPERATING_SYSTEM_NOT_SUPPORTED = "GuestOperatingSystemNotSupported"
    BOOT_TYPE_NOT_SUPPORTED = "BootTypeNotSupported"
    MORE_DISKS_THAN_SUPPORTED = "MoreDisksThanSupported"
    NO_SUITABLE_VM_SIZE_FOUND = "NoSuitableVmSizeFound"
    ONE_OR_MORE_DISKS_NOT_SUITABLE = "OneOrMoreDisksNotSuitable"
    ONE_OR_MORE_ADAPTERS_NOT_SUITABLE = "OneOrMoreAdaptersNotSuitable"
    INTERNAL_ERROR_OCCURRED_DURING_COMPUTE_EVALUATION = "InternalErrorOccurredDuringComputeEvaluation"
    INTERNAL_ERROR_OCCURRED_DURING_STORAGE_EVALUATION = "InternalErrorOccurredDuringStorageEvaluation"
    INTERNAL_ERROR_OCCURRED_DURING_NETWORK_EVALUATION = "InternalErrorOccurredDuringNetworkEvaluation"
    NO_VM_SIZE_SUPPORTS_STORAGE_PERFORMANCE = "NoVmSizeSupportsStoragePerformance"
    NO_VM_SIZE_SUPPORTS_NETWORK_PERFORMANCE = "NoVmSizeSupportsNetworkPerformance"
    NO_VM_SIZE_FOR_SELECTED_PRICING_TIER = "NoVmSizeForSelectedPricingTier"
    NO_VM_SIZE_FOR_SELECTED_AZURE_LOCATION = "NoVmSizeForSelectedAzureLocation"
    CHECK_RED_HAT_LINUX_VERSION = "CheckRedHatLinuxVersion"
    CHECK_OPEN_SUSE_LINUX_VERSION = "CheckOpenSuseLinuxVersion"
    CHECK_WINDOWS_SERVER2008_R2_VERSION = "CheckWindowsServer2008R2Version"
    CHECK_CENT_OS_VERSION = "CheckCentOsVersion"
    CHECK_DEBIAN_LINUX_VERSION = "CheckDebianLinuxVersion"
    CHECK_SUSE_LINUX_VERSION = "CheckSuseLinuxVersion"
    CHECK_ORACLE_LINUX_VERSION = "CheckOracleLinuxVersion"
    CHECK_UBUNTU_LINUX_VERSION = "CheckUbuntuLinuxVersion"
    CHECK_CORE_OS_LINUX_VERSION = "CheckCoreOsLinuxVersion"
    WINDOWS_SERVER_VERSION_CONDITIONALLY_SUPPORTED = "WindowsServerVersionConditionallySupported"
    NO_GUEST_OPERATING_SYSTEM_CONDITIONALLY_SUPPORTED = "NoGuestOperatingSystemConditionallySupported"
    WINDOWS_CLIENT_VERSIONS_CONDITIONALLY_SUPPORTED = "WindowsClientVersionsConditionallySupported"
    BOOT_TYPE_UNKNOWN = "BootTypeUnknown"
    GUEST_OPERATING_SYSTEM_UNKNOWN = "GuestOperatingSystemUnknown"
    WINDOWS_SERVER_VERSIONS_SUPPORTED_WITH_CAVEAT = "WindowsServerVersionsSupportedWithCaveat"
    WINDOWS_OS_NO_LONGER_UNDER_MS_SUPPORT = "WindowsOSNoLongerUnderMSSupport"
    ENDORSED_WITH_CONDITIONS_LINUX_DISTRIBUTIONS = "EndorsedWithConditionsLinuxDistributions"
    UNENDORSED_LINUX_DISTRIBUTIONS = "UnendorsedLinuxDistributions"
    NO_VM_SIZE_FOR_STANDARD_PRICING_TIER = "NoVmSizeForStandardPricingTier"
    NO_VM_SIZE_FOR_BASIC_PRICING_TIER = "NoVmSizeForBasicPricingTier"
    NO_VM_SIZE_IN_SELECTED_FAMILY_FOUND = "NoVmSizeInSelectedFamilyFound"
    NO_EA_PRICE_FOUND_FOR_VM_SIZE = "NoEaPriceFoundForVmSize"
    NO_VM_SIZE_FOUND_FOR_OFFER_CURRENCY_RESERVED_INSTANCE = "NoVmSizeFoundForOfferCurrencyReservedInstance"


class CloudSuitability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cloud Suitability for Azure."""

    UNKNOWN = "Unknown"
    """Unknown. Indicates missing data."""
    NOT_SUITABLE = "NotSuitable"
    """Not Suitable for Azure."""
    SUITABLE = "Suitable"
    """Suitable for Azure."""
    CONDITIONALLY_SUITABLE = "ConditionallySuitable"
    """Conditionally Suitable for Azure."""
    READINESS_UNKNOWN = "ReadinessUnknown"
    """Unknown Readiness for Azure."""


class CompatibilityLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CompatibilityLevel."""

    UNKNOWN = "Unknown"
    COMPAT_LEVEL80 = "CompatLevel80"
    COMPAT_LEVEL90 = "CompatLevel90"
    COMPAT_LEVEL100 = "CompatLevel100"
    COMPAT_LEVEL110 = "CompatLevel110"
    COMPAT_LEVEL120 = "CompatLevel120"
    COMPAT_LEVEL130 = "CompatLevel130"
    COMPAT_LEVEL140 = "CompatLevel140"
    COMPAT_LEVEL150 = "CompatLevel150"


class ComputeTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ComputeTier."""

    UNKNOWN = "Unknown"
    AUTOMATIC = "Automatic"
    PROVISIONED = "Provisioned"
    SERVERLESS = "Serverless"


class CostComponentName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to represent component name."""

    UNKNOWN = "Unknown"
    MONTHLY_AZURE_HYBRID_COST_SAVINGS = "MonthlyAzureHybridCostSavings"
    MONTHLY_SECURITY_COST = "MonthlySecurityCost"
    MONTHLY_PREMIUM_V2_STORAGE_COST = "MonthlyPremiumV2StorageCost"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class EnvironmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """EnvironmentType."""

    PRODUCTION = "Production"
    TEST = "Test"


class FttAndRaidLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """FttAndRaidLevel."""

    UNKNOWN = "Unknown"
    FTT1_RAID1 = "Ftt1Raid1"
    FTT1_RAID5 = "Ftt1Raid5"
    FTT2_RAID1 = "Ftt2Raid1"
    FTT2_RAID6 = "Ftt2Raid6"
    FTT3_RAID1 = "Ftt3Raid1"


class GroupStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """GroupStatus."""

    CREATED = "Created"
    UPDATED = "Updated"
    RUNNING = "Running"
    COMPLETED = "Completed"
    INVALID = "Invalid"


class GroupType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """GroupType."""

    DEFAULT = "Default"
    IMPORT = "Import"
    IMPORT_ENUM = "Import"


class GroupUpdateOperation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """GroupUpdateOperation."""

    ADD = "Add"
    REMOVE = "Remove"


class GuestOperatingSystemArchitecture(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """GuestOperatingSystemArchitecture."""

    UNKNOWN = "Unknown"
    X86 = "X86"
    X64 = "X64"


class HardwareGeneration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """HardwareGeneration."""

    UNKNOWN = "Unknown"
    AUTOMATIC = "Automatic"
    GEN5 = "Gen5"
    FSV2_SERIES = "Fsv2_series"
    M_SERIES = "M_series"
    DC_SERIES = "DC_series"


class MachineBootType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MachineBootType."""

    UNKNOWN = "Unknown"
    EFI = "EFI"
    BIOS = "BIOS"
    NOT_SPECIFIED = "NotSpecified"


class MultiSubnetIntent(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MultiSubnetIntent."""

    NONE = "None"
    HIGH_AVAILABILITY = "HighAvailability"
    DISASTER_RECOVERY = "DisasterRecovery"


class OptimizationLogic(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OptimizationLogic."""

    MINIMIZE_COST = "MinimizeCost"
    MODERNIZE_TO_PAA_S = "ModernizeToPaaS"
    MODERNIZE_TO_AZURE_SQL_MI = "ModernizeToAzureSqlMi"
    MODERNIZE_TO_AZURE_SQL_DB = "ModernizeToAzureSqlDb"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class OsLicense(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OsLicense."""

    UNKNOWN = "Unknown"
    YES = "Yes"
    NO = "No"


class Percentile(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Percentile."""

    PERCENTILE50 = "Percentile50"
    PERCENTILE90 = "Percentile90"
    PERCENTILE95 = "Percentile95"
    PERCENTILE99 = "Percentile99"


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class ProjectStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Project Status."""

    ACTIVE = "Active"
    """Active Status."""
    INACTIVE = "Inactive"
    """Inactive Status."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    PROVISIONING = "Provisioning"
    """Resource is being Provisioned."""
    UPDATING = "Updating"
    """Resource is being Updated."""
    DELETING = "Deleting"
    """Resource is being Deleted."""
    ACCEPTED = "Accepted"
    """Resource is being Accepted."""


class RecommendedSuitability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RecommendedSuitability."""

    UNKNOWN = "Unknown"
    SUITABLE_FOR_SQL_DB = "SuitableForSqlDB"
    SUITABLE_FOR_SQL_MI = "SuitableForSqlMI"
    SUITABLE_FOR_VM = "SuitableForVM"
    POTENTIALLY_SUITABLE_FOR_VM = "PotentiallySuitableForVM"
    READINESS_UNKNOWN = "ReadinessUnknown"
    NOT_SUITABLE = "NotSuitable"
    SUITABLE_FOR_SQL_VM = "SuitableForSqlVM"
    CONDITIONALLY_SUITABLE_FOR_SQL_DB = "ConditionallySuitableForSqlDB"
    CONDITIONALLY_SUITABLE_FOR_SQL_MI = "ConditionallySuitableForSqlMI"
    CONDITIONALLY_SUITABLE_FOR_VM = "ConditionallySuitableForVM"
    CONDITIONALLY_SUITABLE_FOR_SQL_VM = "ConditionallySuitableForSqlVM"


class SkuReplicationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SkuReplicationMode."""

    NOT_APPLICABLE = "NotApplicable"
    ACTIVE_GEO_REPLICATION = "ActiveGeoReplication"
    FAILOVER_GROUP_INSTANCE = "FailoverGroupInstance"


class SqlAssessmentMigrationIssueCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SqlAssessmentMigrationIssueCategory."""

    ISSUE = "Issue"
    WARNING = "Warning"
    INTERNAL = "Internal"


class SqlFCIMetadataState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SqlFCIMetadataState."""

    UNKNOWN = "Unknown"
    INHERITED = "Inherited"
    INITIALIZING = "Initializing"
    ONLINE = "Online"
    OFFLINE = "Offline"
    FAILED = "Failed"
    PENDING = "Pending"
    ONLINE_PENDING = "OnlinePending"
    OFFLINE_PENDING = "OfflinePending"


class SqlFCIState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SqlFCIState."""

    UNKNOWN = "Unknown"
    ACTIVE = "Active"
    PASSIVE = "Passive"
    NOT_APPLICABLE = "NotApplicable"


class SqlMigrationGuidelineCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SqlMigrationGuidelineCategory."""

    UNKNOWN = "Unknown"
    GENERAL = "General"
    FAILOVER_CLUTER_INSTANCE_GUIDE_LINE = "FailoverCluterInstanceGuideLine"
    AVAILABILITY_GROUP_GUIDELINE = "AvailabilityGroupGuideline"


class SqlServerLicense(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SqlServerLicense."""

    UNKNOWN = "Unknown"
    YES = "Yes"
    NO = "No"


class TargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TargetType."""

    UNKNOWN = "Unknown"
    RECOMMENDED = "Recommended"
    AZURE_SQL_DATABASE = "AzureSqlDatabase"
    AZURE_SQL_MANAGED_INSTANCE = "AzureSqlManagedInstance"
    AZURE_SQL_VIRTUAL_MACHINE = "AzureSqlVirtualMachine"
    AZURE_VIRTUAL_MACHINE = "AzureVirtualMachine"


class TimeRange(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TimeRange."""

    DAY = "Day"
    WEEK = "Week"
    MONTH = "Month"
    CUSTOM = "Custom"
