/* Siconos is a program dedicated to modeling, simulation and control
 * of non smooth dynamical systems.
 *
 * Copyright 2020 INRIA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

/*! \file RelationTypes.hpp
  \brief enum of the available types and subtypes for relations,
  plugin names ...
*/

/*! \file RelationTypes.hpp
Include files related to the different types of relations
*/

#ifndef RelationTypes_hpp
#define RelationTypes_hpp

#include "FirstOrderNonLinearR.hpp"
#include "FirstOrderType1R.hpp"
#include "FirstOrderType2R.hpp"
#include "FirstOrderLinearR.hpp"
#include "FirstOrderLinearTIR.hpp"
#include "LagrangianLinearTIR.hpp"
#include "LagrangianScleronomousR.hpp"
#include "LagrangianRheonomousR.hpp"
#include "LagrangianCompliantR.hpp"
#include "LagrangianCompliantLinearTIR.hpp"
#include "Lagrangian2d1DR.hpp"
#include "Lagrangian2d2DR.hpp"
#include "Lagrangian2d3DR.hpp"
#endif
