'\"
'\" Generated from dom.xml
'\"
'\" BEGIN man.macros
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.de DS
.RS
.nf
.sp
..
.de DE
.fi
.RE
.sp
..
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.if t .ft C
..
.de CE
.fi
.if t .ft R
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\" END man.macros
.TH dom n "" Tcl ""
.BS
.SH NAME
dom \- Create an in-memory DOM tree from XML
.SH SYNOPSIS
.nf
package require tdom

\&\fBdom\fP \fImethod\fR ?\fIarg arg ...\fR?
.fi
.BE
.SH "DESCRIPTION "
.PP
This command provides the creation of DOM trees in memory. In
the usual case a string containing a XML information is parsed and converted
into a DOM tree. Other possible parse input may be HTML or JSON.
The \fImethod\fR indicates a specific subcommand.
.PP
The valid methods are:
.TP
\&\fB\fBdom\fP \fBparse\fP ?\fIoptions\fB? ?\fIdata\fB?
\&\fRParses the XML information and builds up the DOM tree in memory
providing a Tcl object command to this DOM document object. Example:

      
.RS
.CS

dom parse $xml doc
$doc documentElement root
.CE
.PP
parses the XML in the variable xml, creates the DOM tree in memory,
make a reference to the document object, visible in Tcl as a document object
command, and assigns this new object name to the variable doc. When doc gets
freed, the DOM tree and the associated Tcl command object (document and all
node objects) are freed automatically.

      
      
.CS

set document [dom parse $xml]
set root     [$document documentElement]
.CE
.PP
parses the XML in the variable xml, creates the DOM tree in memory,
make a reference to the document object, visible in Tcl as a document object
command, and returns this new object name, which is then stored in
\&\fIdocument\fR.  To free the underlying DOM tree and the associative Tcl
object commands (document + nodes + fragment nodes) the document object command
has to be explicitly deleted by:


      
.CS

$document delete

.CE
or
.CS

rename $document ""
.CE
.PP
The valid options are:
.IP "\fB-simple\fR"
If \fI-simple\fR is specified, a simple but
fast parser is used (conforms not fully to XML
recommendation). That should double parsing and DOM
generation speed. The encoding of the data is not
transformed inside the parser. The simple parser does
not respect any encoding information in the XML
declaration. It skips over the internal DTD subset and
ignores any information in it. Therefore, it doesn't
include defaulted attribute values into the tree, even
if the according attribute declaration is in the
internal subset. It also doesn't expand internal or
external entity references other than the predefined
entities and character references
.IP "\fB-html\fR"
If \fI-html\fR is specified, a fast HTML parser
is used, which tries to even parse badly formed HTML
into a DOM tree. If the HTML document given to parse
does not have a single root element (as it was legal
up to HTML 4.01) and the -forest option is not used
then a html node will be inserted as document element,
with the HTML input data top level elements as
children.
.IP "\fB-html5\fR"
This option is only available if tDOM was build
with --enable-html5. Use the \fIfeatureinfo\fR method
if you need to know if this feature is build in. If
\&\fI-html5\fR is specified, the gumbo lib html5 parser
(https://github.com/google/gumbo-parser) is used to
build the DOM tree. This is, as far as it goes, XML
namespace-aware (which means for example that all HTML
elements are in the html5 namespace). Since this
probably isn't wanted by a lot of users and adds only
burden for no good in a lot of use cases \fI-html5\fR
can be combined with \fI-ignorexmlns\fR, in which
case all nodes and attributes in the DOM tree are not
in an XML namespace. All tag and attribute names in
the DOM tree will be lower case, even for foreign
elements not in the xhtml, svg or mathml namespace.
The DOM tree may include nodes, that the parser
inserted because they are implied by the context (as
<head>, <tbody>, etc.). Input longer than
4 GByte byte length is not supported by the underlying
gumbo parser.
.IP "\fB-json\fR"
If \fI-json\fR is specified, the \fIdata\fR is
expected to be a valid JSON string (according to RFC
7159). The command returns an ordinary DOM document
with nesting token inside the JSON data translated
into tree hierarchy. If a JSON array value is itself
an object or array then container element nodes named
(in a default build) arraycontainer or
objectcontainer, respectively, are inserted into the
tree. The JSON serialization of this document (with
the domDoc method \fIasJSON\fR) is the same JSON
information as the \fIdata\fR, preserving JSON
datatypes, allowing non-unique member names of objects
while preserving their order and the full range of
JSON string values. JSON datatype handling is done
with an additional property "sticking" at the doc and
tree nodes. This property isn't contained in an XML
serialization of the document. If you need to store
the JSON data represented by a document, store the
JSON serialization and parse it back from there. Apart
from this JSON type information the returned doc
command or handle is an ordinary DOM doc, which may be
investigated or modified with the full range of the
doc and node methods. Please note that the element
node names and the text node values within the tree
may be outside of what the appropriate XML productions
allow.
.IP "\fB-jsonroot <document element name>\fR"
If given makes the given element name the
document element of the resulting doc. The parsed
content of the JSON string will be the children of
this document element node.
.IP "\fB-jsonmaxnesting  \fIinteger\fP\fR"
This option only has effect if used together
with the \fI-json\fR option. The current
implementation uses a recursive descent JSON parser.
In order to avoid using excess stack space, any JSON
input that has more than a certain levels of nesting
is considered invalid. The default maximum nesting is
2000. The option -jsonmaxnesting allows the user to
adjust that.
.IP "\fB--\fR"
The option \fI--\fR marks the end of options.
To give this option isn't strictly necessary even in
the case of JSON parsing, for which valid data may
start with a "-". If parsing json and if the second to
last or last argument start with a "-" and isn't a
known option name it will be treated as JSON
data.
.IP "\fB-keepEmpties\fR"
If \fI-keepEmpties\fR is
specified then text nodes which contain only whitespaces will be part of the
resulting DOM tree. In default case (\fI-keepEmpties\fR not given) those empty
text nodes are removed at parsing time.
.IP "\fB-keepCDATA\fR"
If \fI-keepCDATA\fR is
specified then CDATA sections aren't added to the tree as text nodes
(and, if necessary, combined with sibling text nodes into one text
node) as without this option but are added as CDATA_SECTION_NODEs to
the tree. Please note that the resulting tree isn't prepared for XPath
selects or to be the source or the stylesheet of an XSLT
transformation. If not combined with \fI-keepEmpties\fR only not
whitespace only CDATA sections will be added to the resulting DOM
tree.
.IP "\fB-channel  \fI<channel-ID>\fP\fR"
If \fI-channel <channel-ID>\fR is specified, the
input to be parsed is read from the specified channel. The encoding setting of
the channel (via fconfigure -encoding) is respected, ie the data read from the
channel are converted to UTF-8 according to the encoding settings before the
data is parsed.
.IP "\fB-baseurl  \fI<baseURI>\fP\fR"
If \fI-baseurl <baseURI>\fR is specified,
the baseURI is used as the base URI of the document.
External entities references in the document are
resolved relative to this base URI. This base URI is
also stored within the DOM tree.
.IP "\fB-feedbackAfter  \fI<#bytes>\fP\fR"
If \fI-feedbackAfter <#bytes>\fR is
specified, the Tcl command given by
\&\fI-feedbackcmd\fR is evaluated at the first element
start within the document (or an external entity)
after the start of the document or external entity or
the last such call after #bytes. For backward
compatibility if no -feedbackcmd is given but there is
a Tcl proc named ::dom::domParseFeedback this proc is
used as -feedbackcmd. If there isn't such a proc and
-feedbackAfter is used it is an error to not also use
-feedbackcmd. If the called script raises error, then
parsing will be aborted, the \fIdom parse\fR call
returns error, with the script error msg as error msg.
If the called script \fIreturn -code break\fR, the
parsing will abort and the \fIdom parse\fR call will
return the empty string.
.IP "\fB-feedbackcmd  \fI<script>\fP\fR"
If \fI-feedbackcmd <script>\fR is specified, the
script \fIscript\fR is evaluated at the first
element start within the document (or an external entity) after the
start of the document or external entity or the last such call after
#bytes value given by the \fI-feedbackAfter\fR option. If
\&\fI-feedbackAfter\fR isn't given, using this option
doesn't has any effect. If the called
script raises error, then parsing will be aborted, the
\&\fIdom parse\fR call returns error, with the script
error msg as error msg. If the called script \fIreturn
-code break\fR, the parsing will abort and the \fIdom
parse\fR call will return the empty string.
.IP "\fB-externalentitycommand  \fI<script>\fP\fR"
If \fI-externalentitycommand <script>\fR is
specified, the specified Tcl script is called to resolve any external entities
of the document. The actual evaluated command consists of this option followed
by three arguments: the base uri, the system identifier of the entity and the
public identifier of the entity. The base uri and the public identifier may be
the empty list. The script has to return a Tcl list consisting of three
elements. The first element of this list signals how the external entity is
returned to the processor. Currently the two allowed types are "string"
and "channel". The second element of the list has to be the (absolute) base URI
of the external entity to be parsed.  The third element of the list are data,
either the already read data out of the external entity as string in the case
of type "string", or the name of a Tcl channel, in the case of type
"channel". Note that if the script returns a Tcl channel, it will not be closed
by the processor.  It must be closed separately if it is no longer
needed.
.IP "\fB-useForeignDTD  \fI<boolean>\fP\fR"
If
<boolean> is true and the document does not have
an external subset, the parser will call the
-externalentitycommand script with empty values for
the systemId and publicID arguments. Please note that
if the document also doesn't have an internal subset,
the -startdoctypedeclcommand and
-enddoctypedeclcommand scripts, if set, are not
called.
.IP "\fB-paramentityparsing  \fI<always|never|notstandalone>\fP\fR"
The \fI-paramentityparsing\fR option controls,
if the parser tries to resolve the external entities
(including the external DTD subset) of the document
while building the DOM tree.
\&\fI-paramentityparsing\fR requires an argument, which
must be either "always", "never", or "notstandalone".
The value "always" means that the parser tries to
resolves (recursively) all external entities of the
XML source. This is the default in case
\&\fI-paramentityparsing\fR is omitted. The value
"never" means that only the given XML source is
parsed and no external entity (including the external
subset) will be resolved and parsed. The value
"notstandalone" means, that all external entities will
be resolved and parsed, with the exception of
documents, which explicitly states standalone="yes" in
their XML declaration.
.IP "\fB-forest\fR"
If this option is given, there is no need for a
single root; any sequence of well-formed, balanced
subtrees will be parsed into a DOM tree. This works
for the expat DOM builder, the simple xml parser
enabled with \fI-simple\fR and the simple HTML parser
enabled -with \fI-html\fR. If used together with
\&\fI-json\fR or \fI-html5\fR this option is ignored.
.IP "\fB-ignorexmlns\fR"
It is recommended, that you only use this option
with the \fI-html5\fR option. If this option is
given, no node within the created DOM tree will be
internally marked as placed into an XML Namespace,
even if there is a default namespace in scope for
un-prefixed elements or even if the element has a
defined namespace prefix. One consequence is that
XPath node expressions on such a DOM tree doesn't work
as may be expected. Prefixed element nodes can't be
selected naively and element nodes without prefix will
be seen by XPath expressions as if they are not in any
namespace (no matter if they are in fact should be in
a default namespace). If you need to inject prefixed
node names into an XPath expression use the '%' syntax
described in the documentation of the of the
.TP
\&\fBdomNode
\&\fR command method
\&\fB>selectNodes\fP.
.IP "\fB-billionLaughsAttackProtectionMaximumAmplification  \fI<float>\fP\fR"
.UR "https://en.wikipedia.org/wiki/Billion_laughs_attack"
<URL: https://en.wikipedia.org/wiki/Billion_laughs_attack>
.UE
This option together with
\&\fI-billionLaughsAttackProtectionActivationThreshold\fR
gives control over the parser limits that protects
against billion laugh attacks
().
This option expects a float >= 1.0 as argument. You
should never need to use this option, because the
default value (100.0) should work for any real data.
If you ever need to increase this value for non-attack
payload, please report.
.IP "\fB-billionLaughsAttackProtectionActivationThreshold  \fI<long>\fP\fR"
.UR "https://en.wikipedia.org/wiki/Billion_laughs_attack"
<URL: https://en.wikipedia.org/wiki/Billion_laughs_attack>
.UE
This option together with
\&\fI-billionLaughsAttackProtectionMaximumAmplification\fR
gives control over the parser limits that protects
against billion laugh attacks
().
This option expects a positiv integer as argument. You
should never need to use this option, because the
default value (8388608) should work for any real data.
If you ever need to increase this value for non-attack
payload, please report.
.PP
.RE
.TP
\&\fB\fBdom\fP \fBcreateDocument\fP \fIdocElemName\fB ?\fIobjVar\fB?
\&\fRCreates a new DOM document object with one element node with
node name \fIdocElemName\fR. The \fIobjVar\fR controls the
memory handling as explained above.
.TP
\&\fB\fBdom\fP \fBcreateDocumentNS\fP \fIuri\fB \fIdocElemName\fB ?\fIobjVar\fB?
\&\fRCreates a new DOM document object with one element node with
node name \fIdocElemName\fR. \fIUri\fR gives the namespace of the
document element to create. The \fIobjVar\fR controls the
memory handling as explained above.
.TP
\&\fB\fBdom\fP \fBcreateDocumentNode\fP ?\fI-jsonType jsonType\fB? ?\fIobjVar\fB?
\&\fRCreates a new 'empty' DOM document object without any
element node. \fIobjVar\fR controls the memory handling as
explained above. If the option -jsonType is given the
created document node will be of the given JSON type.
.TP
\&\fB\fBdom\fP \fBcreateFromTypedList\fP \fItypedList\fB ?\fIobjVar\fB?
\&\fR
.RS
.PP
Creates a new DOM document from the argument \fItypedList\fR.
The \fIobjVar\fR argument controls the memory handling as
explained above.
.PP
The \fItypedList\fR argument must be a Tcl list and must
follow the format of the output of the document command
method \fIasTypedList\fR, see there.
.RE
.TP
\&\fB\fBdom\fP \fBcreateNodeCmd\fP \fI?-returnNodeCmd?\fB \fI?-tagName name?\fB \fI?-jsonType jsonType?\fB \fI?-namespace URI?\fB \fI(element|comment|text|cdata|pi)Node\fB \fIcommandName\fB
\&\fRThis method creates Tcl commands, which in turn create
tDOM nodes. Tcl commands created by this command are only
available inside a script given to the domNode methods
\&\fIappendFromScript\fR or \fIinsertBeforeFromScript\fR. If
a command created with \fIcreateNodeCmd\fR is invoked in
any other context, it will return error. The created command
\&\fIcommandName\fR replaces any existing command or
procedure with that name. If the \fIcommandName\fR includes
any Tcl namespace qualifiers, it is created in the specified
namespace. The \fI-tagName\fR option is only allowed for
the elementNode type. The \fI-jsonType\fR option is only
allowed for elementNode and textNode types.
.RS
.PP
If such command is invoked inside a script given as argument to the
domNode method \fIappendFromScript\fR or
\&\fIinsertBeforeFromScript\fR it creates a new node and appends this
node at the end of the child list of the invoking element node. If the
option \fI-returnNodeCmd\fR was given, the command returns the
created node as Tcl command. If this option was omitted, the command
returns nothing. Each command creates always the same type of node.
Which type of node is created by the command is determined by the
first argument to the \fIcreateNodeCmd\fR. The syntax of the created
command depends on the type of the node it creates.
.PP
If the command type to create is \fIelementNode\fR, the created
command will create an element node, if called. Without the
\&\fI-tagName\fR option the tag name of the created node is
\&\fIcommandName\fR without Tcl namespace qualifiers. If the
\&\fI-tagName\fR option was given then the created elements will have
the value of this option as tag name. If the \fI-jsonType\fR option
was given then the created node elements will have the given JSON
type. If the \fI-namespace\fR option is given the created element
node will be XML namespaced and in the namespace given by the option.
The element name will be literal as given either by the command name
or the \fI-tagname\fR option, if that was given. An appropriate XML
namespace declaration will be automatically added, to bind the prefix
(if the element name has one) or the default namespace (if the element
name hasn't a prefix) to the namespace if such a binding isn't in
scope.
.PP
The syntax of the created command is:



.CS

\&\fBelementNodeCmd\fP \fI?attributeName attributeValue ...? ?script?\fR
\&\fBelementNodeCmd\fP \fI?-attributeName attributeValue ...? ?script?\fR
\&\fBelementNodeCmd\fP \fIname_value_list script\fR

.CE
.PP
The command syntax allows three different ways to specify the attributes of
the resulting element. These could be specified with \fIattributeName
attributeValue\fR argument pairs, in an "option style" way with
\&\fI-attriubteName attributeValue\fR argument pairs (the '-' character is only
syntactical sugar and will be stripped off) or as a Tcl list with elements
interpreted as attribute name and the corresponding attribute value.
The attribute name elements in the list may have a leading '-' character, which
will be stripped off.
.PP
Every \fIelementNodeCmd\fR accepts an optional Tcl script as last
argument. This script is evaluated as recursive \fIappendFromScript\fR script
with the node created by the \fIelementNodeCmd\fR as parent of all nodes
created by the script.
.PP
If the first argument of the method is \fItextNode\fR, the command
will create a text node. If the \fI-jsonType\fR option was given then
the created text node will have that JSON type. The syntax of the
created command is:



.CS

\&\fBtextNodeCmd\fP ?-disableOutputEscaping? \fI?data?\fR

.CE
.PP
If the json type of the created text node is NULL, TRUE or FALSE
then the \fIdata\fR argument is optional, otherwise it this argument
must be given.
.PP
If the optional flag \fI-disableOutputEscaping\fR is given, the
escaping of the ampersand character (&) and the left angle bracket (<)
inside the data is disabled. You should use this flag carefully.
.PP
If the first argument of the method is \fIcommentNode\fR or
\&\fIcdataNode\fR the command will create an comment node or CDATA section
node. The syntax of the created command is:



.CS

\&\fBnodeCmd\fP \fIdata\fR

.CE
.PP
If the first argument of the method is \fIpiNode\fR, the command will
create a processing instruction node. The syntax of the created
command is:



.CS

\&\fBpiNodeCmd\fP \fItarget data\fR

.CE
.PP
Beside the with \fBdom\fP \fBcreateNodeCmd\fP calls
created node commands there are two more commands which automatically
insert nodes into the tree inside an \fBappendFromScript\fP
script.



.CS

\&\fBtdom::fsnewNode\fP \fI?-jsonType <jsonType>?\fR \fI?-namespace <namespace>?\fR \fItagName\fR \fI?attributes?\fR \fI?script?\fR

.CE
.PP
If called inside a fromScript context this command creates a new
node \fItagName\fR in the XML namespace \fInamespace\fR if the
\&\fI-namespace\fR option was given and with the JSON type
\&\fIjsonType\fR if the \fI-jsonType\fR option was given and appends
this node at the end of the child list of the invoking element node.
The \fIattributes\fR and \fIscript\fR arguments will be processed as
if given to an element creating node command. If called outside a
fromScript context this command will raise error.



.CS

\&\fBtdom::fsinsertNode\fP \fInode\fR

.CE
.PP
If called inside o fromScript context this comannd instead of
creating a new node appends the as argument given node at the end of
the child list of the invoking element node. The node is unlinked from
its previous place. If called outside a fromScript context this
command will raise error.
.RE
.TP
\&\fB\fBdom\fP \fBsetStoreLineColumn\fP \fI?boolean\fB?
\&\fRIf switched on, the DOM nodes will contain line and column
position information for the original XML document after parsing. The default
is not to store line and column position information.
.TP
\&\fB\fBdom\fP \fBsetNameCheck\fP \fI?boolean\fB?
\&\fRIf NameCheck is true, every method which expects an XML Name,
a full qualified name or a processing instructing target will check, if the
given string is valid according to its production rule. For commands created
with the \fIcreateNodeCmd\fR method to be used in the context of
\&\fIappendFromScript\fR the status of the flag at creation time
decides. If NameCheck is true at creation time, the command will
check its arguments, otherwise not. The \fIsetNameCheck\fR
set this flag. It returns the current NameCheck flag state. The
default state for NameCheck is true.
.TP
\&\fB\fBdom\fP \fBsetTextCheck\fP \fI?boolean\fB?
\&\fRIf TextCheck is true, every command which expects XML Chars,
a comment, a CDATA section value or a processing instructing value will check,
if the given string is valid according to its production rule. For commands
created with the \fIcreateNodeCmd\fR method to be used in the
context of \fIappendFromScript\fR the status of the flag at
creation time decides. If TextCheck is true at creation time, the
command will check its arguments, otherwise not.The
\&\fIsetTextCheck\fR method sets this flag. It returns the current
TextCheck flag state. The default state for TextCheck is true.
.TP
\&\fB\fBdom\fP \fBsetObjectCommands\fP ?\fI(automatic|token|command)\fB?
\&\fRControls if documents and nodes are created as Tcl commands or
as token to be
used with the domNode and domDoc commands. If the mode is
\&'automatic', then methods used at Tcl commands will create Tcl
commands and methods used at doc or node tokes will create tokens. If
the mode is 'command' then always Tcl commands will be created. If
the mode is 'token', then always token will be created. The method
returns the current mode. This method is an experimental interface.
.TP
\&\fB\fBdom\fP \fBisName\fP \fIname\fB
\&\fRReturns 1 if \fIname\fR is a valid XML Name according to
production 5 of the XML
1.0 recommendation. This means that \fIname\fR is a valid
XML element or attribute name. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBisPIName\fP \fIname\fB
\&\fRReturns 1 if \fIname\fR is a valid XML processing instruction
target according to
production 17 of the XML 1.0 recommendation. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBisNCName\fP \fIname\fB
\&\fRReturns 1 if \fIname\fR is a valid NCName according
to production 4 of the of the Namespaces in XML recommendation. Otherwise it returns
0.
.TP
\&\fB\fBdom\fP \fBisQName\fP \fIname\fB
\&\fRReturns 1 if \fIname\fR is a valid QName according
to production 6 of the of the Namespaces in XML recommendation. Otherwise it returns
0.
.TP
\&\fB\fBdom\fP \fBisCharData\fP \fIstring\fB
\&\fRReturns 1 if every character in \fIstring\fR is
a valid XML Char according to production 2 of the XML 1.0
recommendation. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBisHTML5CustomName\fP \fIstring\fB
\&\fRReturns 1 if \fIstring\fR is a HTML5 valid custom
element name (according to
https://html.spec.whatwg.org/#valid-custom-element-name at
26 June 2024, it's a living standard). Otherwise it returns
0.
.TP
\&\fB\fBdom\fP \fBclearString\fP ?\fI-replace\fB? \fIstring\fB
\&\fRReturns the string given as argument cleared out from
any characters not allowed as XML parsed character data. If
the \fI-replace\fR option is given then instead of removing
such characters are replaced with \euFFFD.
.TP
\&\fB\fBdom\fP \fBisBMPCharData\fP \fIstring\fB
\&\fRReturns 1 if every character in \fIstring\fR is
a valid XML Char with a Unicode code point within the Basic
Multilingual Plane (that means, that every character within the string
is at most 3 bytes long). Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBisComment\fP \fIstring\fB
\&\fRReturns 1 if \fIstring\fR is
a valid comment according to production 15 of the XML 1.0
recommendation. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBisCDATA\fP \fIstring\fB
\&\fRReturns 1 if \fIstring\fR is
valid according to production 20 of the XML 1.0
recommendation. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBisPIValue\fP \fIstring\fB
\&\fRReturns 1 if \fIstring\fR is
valid according to production 16 of the XML 1.0
recommendation. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBfeatureinfo\fP \fIfeature\fB
\&\fRThis method provides information about the used
build options and the expat version. The valid values for
the \fIfeature\fR argument are:
.RS
.IP "\fBexpatversion\fR"
Returns the version of the underlyling expat
version as string, something like
"exapt_2.1.0". This is what the expat API
function XML_ExpatVersion() returns.
.IP "\fBexpatmajorversion\fR"
Returns the major version of the at build
time used expat version as integer.
.IP "\fBexpatminorversion\fR"
Returns the minor version of the at build
time used expat version as integer.
.IP "\fBexpatmicroversion\fR"
Returns the micro version of the at build
time used expat version as integer.
.IP "\fBdtd\fR"
Returns as boolean if build with
\&\fI--enable-dtd\fR.
.IP "\fBns\fR"
Returns as boolean if build with
\&\fI--enable-ns\fR.
.IP "\fBunknown\fR"
Returns as boolean if build with
\&\fI--enable-unknown\fR.
.IP "\fBtdomalloc\fR"
Returns as boolean if build with
\&\fI--enable-tdomalloc\fR.
.IP "\fBlessns\fR"
Returns as boolean if build with
\&\fI--enable-lessns\fR.
.IP "\fBTCL_UTF_MAX\fR"
Returns the TCL_UTF_MAX value of the Tcl
core, tDOM was build with as integer
.IP "\fBhtml5\fR"
Returns as boolean, if build with
\&\fI--enable-html5\fR.
.IP "\fBversionhash\fR"
Returns the fossil repository version hash.
.IP "\fBpullparser\fR"
Returns as boolean if the pullparser command
is build in.
.IP "\fBschema\fR"
Returns as boolean if the tDOM schema features
are build in.
.RE
.SH KEYWORDS
XML, DOM, document, node, parsing
