// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMLAL_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SMLAL_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_smlal_8H[] = {
  0x0a29, 0x1c3a, 0x3d0b, 0x3e14, 0x3f7e, 0x407e, 0x3f80, 0x7137,
  0x10ef, 0x2982, 0x3d88, 0x3e92, 0xc0fd, 0x3ffe, 0x3f01, 0x70b9,
  0x18e7, 0x29d7, 0x3e05, 0xc110, 0xc17c, 0x3f7e, 0x3e82, 0x5d87,
  0x191a, 0x2a2c, 0xc182, 0xc18e, 0xc1fb, 0x3efe, 0x2b29, 0x4ccb,
  0x194d, 0xd581, 0xc1ff, 0xc20c, 0xc27a, 0x2b7e, 0x1a4b, 0x3723,
  0xe680, 0xd5d6, 0xc27c, 0xc28a, 0xd5d3, 0x1a7e, 0x0477, 0x34ad,
  0xe6b3, 0xd62b, 0xc2f9, 0xd5bc, 0xe6b1, 0x047e, 0x01fc, 0x342f,
  0xe6e6, 0xd680, 0xd604, 0xe678, 0xfc85, 0x01fe, 0x017d, 0x33b1,
  0xe719, 0xe373, 0xe69e, 0xfc20, 0xff00, 0x017e, 0x00fe, 0x3333,
  0xeede, 0xeebd, 0xfc1a, 0xfe96, 0xff7f, 0x00fe, 0x007f, 0x32b5,
  0xf5a4, 0xfd59, 0xfe8b, 0xff14, 0xfffe, 0x007e, 0x0000, 0x3237,
  0xfe68, 0xff02, 0xff08, 0xff92, 0x007d, 0xfffe, 0xff81, 0x2f43,
  0xff67, 0xff57, 0xff85, 0x0010, 0x00fc, 0xff7e, 0xfc87, 0x1a19,
  0xff9a, 0xffac, 0x0002, 0x008e, 0x017b, 0xfc7e, 0xe732, 0x095d,
  0xffcd, 0x0001, 0x007f, 0x010c, 0x0475, 0xe6fe, 0xd654, 0xf5ad,
  0x0000, 0x0056, 0x00fc, 0x0400, 0x19ca, 0xd5fe, 0xc27c, 0xf52f,
  0x0033, 0x00ab, 0x03ea, 0x192a, 0x2aa8, 0xc1fe, 0xc1fd, 0xf4b1,
  0x0066, 0x02a9, 0x18e9, 0x29e6, 0x3e80, 0xc17e, 0xc17e, 0x7233,
  0x0198, 0x10f0, 0x2983, 0x3d96, 0x3eff, 0xc0fe, 0x3fff, 0x71b5,
  0x10ef, 0x2982, 0x3d88, 0x3e92, 0xc0fd, 0x3ffe, 0x3f01, 0x70b9,
  0x1c39, 0x3d0a, 0x3e06, 0x3f11, 0x407d, 0x3f7f, 0x3e83, 0x703c,
  0x2981, 0x3d87, 0x3e84, 0xc090, 0x3ffd, 0x3f00, 0x3e05, 0x5d31,
  0x29d6, 0x3e04, 0xc102, 0xc10f, 0x3f7d, 0x3e81, 0x2ad3, 0x4c97,
  0x2a2b, 0xc181, 0xc180, 0xc18e, 0x3efd, 0x2b28, 0x1a17, 0x371b,
  0xd580, 0xc1fe, 0xc1fe, 0xc20d, 0x2b7d, 0x1a4a, 0x046f, 0x34aa,
  0xd5d5, 0xc27b, 0xc27c, 0xd566, 0x1a7d, 0x0476, 0x01f9, 0x342d,
  0xd62a, 0xc2f8, 0xd5ae, 0xe644, 0x047d, 0x01fb, 0x017b, 0x33b0,
  0xd67f, 0xd603, 0xe66a, 0xfc18, 0x01fd, 0x017c, 0x00fd, 0x3333,
  0xe372, 0xe69d, 0xfc12, 0xfe93, 0x017d, 0x00fd, 0x007f, 0x32b6,
  0xeebc, 0xfc19, 0xfe88, 0xff12, 0x00fd, 0x007e, 0x0001, 0x3239,
  0xfd58, 0xfe8a, 0xff06, 0xff91, 0x007d, 0xffff, 0xff83, 0x2f4b,
  0xff01, 0xff07, 0xff84, 0x0010, 0xfffd, 0xff80, 0xfc8f, 0x1a4c,
  0xff56, 0xff84, 0x0002, 0x008f, 0xff7d, 0xfc86, 0xe765, 0x09b2,
  0xffab, 0x0001, 0x0080, 0x010e, 0xfc7d, 0xe731, 0xd6a9, 0xf62a,
  0x0000, 0x007e, 0x00fe, 0x0408, 0xe6fd, 0xd653, 0xc2f9, 0xf5ad,
  0x0055, 0x00fb, 0x03f2, 0x195d, 0xd5fd, 0xc27b, 0xc27b, 0xf530,
  0x00aa, 0x03e9, 0x191c, 0x2a3b, 0xc1fd, 0xc1fc, 0xc1fd, 0x71b3,
  0x02a8, 0x18e8, 0x29d8, 0x3e13, 0xc17d, 0xc17d, 0x3f7f, 0x7136,
  0x18e7, 0x29d7, 0x3e05, 0xc110, 0xc17c, 0x3f7e, 0x3e82, 0x5d87,
  0x2981, 0x3d87, 0x3e84, 0xc090, 0x3ffd, 0x3f00, 0x3e05, 0x5d31,
  0x3d09, 0x3e05, 0x3f03, 0x4010, 0x3f7e, 0x3e82, 0x3d88, 0x5017,
  0x3d86, 0x3e83, 0xc082, 0x3f90, 0x3eff, 0x3e04, 0x2a7d, 0x44ab,
  0x3e03, 0xc101, 0xc101, 0x3f10, 0x3e80, 0x2ad2, 0x19e3, 0x35e3,
  0xc180, 0xc17f, 0xc180, 0x3e90, 0x2b27, 0x1a16, 0x0467, 0x3435,
  0xc1fd, 0xc1fd, 0xc1ff, 0x2b10, 0x1a49, 0x046e, 0x01f6, 0x33df,
  0xc27a, 0xc27b, 0xd558, 0x1a10, 0x0475, 0x01f8, 0x0179, 0x3389,
  0xc2f7, 0xd5ad, 0xe636, 0x0410, 0x01fa, 0x017a, 0x00fc, 0x3333,
  0xd602, 0xe669, 0xfc0a, 0x0190, 0x017b, 0x00fc, 0x007f, 0x32dd,
  0xe69c, 0xfc11, 0xfe85, 0x0110, 0x00fc, 0x007e, 0x0002, 0x3287,
  0xfc18, 0xfe87, 0xff04, 0x0090, 0x007d, 0x0000, 0xff85, 0x3083,
  0xfe89, 0xff05, 0xff83, 0x0010, 0xfffe, 0xff82, 0xfc97, 0x2211,
  0xff06, 0xff83, 0x0002, 0xff90, 0xff7f, 0xfc8e, 0xe798, 0x16a5,
  0xff83, 0x0001, 0x0081, 0xff10, 0xfc85, 0xe764, 0xd6fe, 0x0935,
  0x0000, 0x007f, 0x0100, 0xfc10, 0xe730, 0xd6a8, 0xc376, 0x08df,
  0x007d, 0x00fd, 0x03fa, 0xe690, 0xd652, 0xc2f8, 0xc2f9, 0x0889,
  0x00fa, 0x03f1, 0x194f, 0xd590, 0xc27a, 0xc27a, 0xc27c, 0x5e33,
  0x03e8, 0x191b, 0x2a2d, 0xc190, 0xc1fb, 0xc1fc, 0x3eff, 0x5ddd,
  0x191a, 0x2a2c, 0xc182, 0xc18e, 0xc1fb, 0x3efe, 0x2b29, 0x4ccb,
  0x29d6, 0x3e04, 0xc102, 0xc10f, 0x3f7d, 0x3e81, 0x2ad3, 0x4c97,
  0x3d86, 0x3e83, 0xc082, 0x3f90, 0x3eff, 0x3e04, 0x2a7d, 0x44ab,
  0x3e04, 0x3f02, 0x4002, 0x3f11, 0x3e81, 0x3d87, 0x1d63, 0x3dc3,
  0x3e82, 0xc081, 0x3f82, 0x3e92, 0x3e03, 0x2a7c, 0x11f7, 0x34d3,
  0xc100, 0xc100, 0x3f02, 0x3e13, 0x2ad1, 0x19e2, 0x032f, 0x33cf,
  0xc17e, 0xc17f, 0x3e82, 0x2aba, 0x1a15, 0x0466, 0x0181, 0x339b,
  0xc1fc, 0xc1fe, 0x2b02, 0x19dc, 0x046d, 0x01f5, 0x012b, 0x3367,
  0xc27a, 0xd557, 0x1a02, 0x0408, 0x01f7, 0x0178, 0x00d5, 0x3333,
  0xd5ac, 0xe635, 0x0402, 0x018d, 0x0179, 0x00fb, 0x007f, 0x32ff,
  0xe668, 0xfc09, 0x0182, 0x010e, 0x00fb, 0x007e, 0x0029, 0x32cb,
  0xfc10, 0xfe84, 0x0102, 0x008f, 0x007d, 0x0001, 0xffd3, 0x3193,
  0xfe86, 0xff03, 0x0082, 0x0010, 0xffff, 0xff84, 0xfdcf, 0x28d7,
  0xff04, 0xff82, 0x0002, 0xff91, 0xff81, 0xfc96, 0xef5d, 0x21ef,
  0xff82, 0x0001, 0xff82, 0xff12, 0xfc8d, 0xe797, 0xe3f1, 0x19cf,
  0x0000, 0x0080, 0xff02, 0xfc18, 0xe763, 0xd6fd, 0xd681, 0x199b,
  0x007e, 0x00ff, 0xfc02, 0xe6c3, 0xd6a7, 0xc375, 0xd62b, 0x1967,
  0x00fc, 0x03f9, 0xe682, 0xd5e5, 0xc2f7, 0xc2f8, 0xd5d5, 0x4d33,
  0x03f0, 0x194e, 0xd582, 0xc20d, 0xc279, 0xc27b, 0x2b7f, 0x4cff,
  0x194d, 0xd581, 0xc1ff, 0xc20c, 0xc27a, 0x2b7e, 0x1a4b, 0x3723,
  0x2a2b, 0xc181, 0xc180, 0xc18e, 0x3efd, 0x2b28, 0x1a17, 0x371b,
  0x3e03, 0xc101, 0xc101, 0x3f10, 0x3e80, 0x2ad2, 0x19e3, 0x35e3,
  0x3e82, 0xc081, 0x3f82, 0x3e92, 0x3e03, 0x2a7c, 0x11f7, 0x34d3,
  0x3f01, 0x4001, 0x3f03, 0x3e14, 0x3d86, 0x1d62, 0x0b0f, 0x3373,
  0xc080, 0x3f81, 0x3e84, 0x3d96, 0x2a7b, 0x11f6, 0x021f, 0x334b,
  0xc0ff, 0x3f01, 0x3e05, 0x2a64, 0x19e1, 0x032e, 0x011b, 0x3343,
  0xc17e, 0x3e81, 0x2aac, 0x19a8, 0x0465, 0x0180, 0x00e7, 0x333b,
  0xc1fd, 0x2b01, 0x19ce, 0x0400, 0x01f4, 0x012a, 0x00b3, 0x3333,
  0xd556, 0x1a01, 0x03fa, 0x018a, 0x0177, 0x00d4, 0x007f, 0x332b,
  0xe634, 0x0401, 0x017f, 0x010c, 0x00fa, 0x007e, 0x004b, 0x3323,
  0xfc08, 0x0181, 0x0100, 0x008e, 0x007d, 0x0028, 0x0017, 0x32f3,
  0xfe83, 0x0101, 0x0081, 0x0010, 0x0000, 0xffd2, 0xfedf, 0x319b,
  0xff02, 0x0081, 0x0002, 0xff92, 0xff83, 0xfdce, 0xf623, 0x308b,
  0xff81, 0x0001, 0xff83, 0xff14, 0xfc95, 0xef5c, 0xef3b, 0x2f4b,
  0x0000, 0xff81, 0xff04, 0xfc20, 0xe796, 0xe3f0, 0xe71b, 0x2f43,
  0x007f, 0xff01, 0xfc0a, 0xe6f6, 0xd6fc, 0xd680, 0xe6e7, 0x2f3b,
  0x00fe, 0xfc01, 0xe6b5, 0xd63a, 0xc374, 0xd62a, 0xe6b3, 0x3733,
  0x03f8, 0xe681, 0xd5d7, 0xc28a, 0xc2f7, 0xd5d4, 0x1a7f, 0x372b,
  0xe680, 0xd5d6, 0xc27c, 0xc28a, 0xd5d3, 0x1a7e, 0x0477, 0x34ad,
  0xd580, 0xc1fe, 0xc1fe, 0xc20d, 0x2b7d, 0x1a4a, 0x046f, 0x34aa,
  0xc180, 0xc17f, 0xc180, 0x3e90, 0x2b27, 0x1a16, 0x0467, 0x3435,
  0xc100, 0xc100, 0x3f02, 0x3e13, 0x2ad1, 0x19e2, 0x032f, 0x33cf,
  0xc080, 0x3f81, 0x3e84, 0x3d96, 0x2a7b, 0x11f6, 0x021f, 0x334b,
  0x4000, 0x3f02, 0x3e06, 0x3d19, 0x1d61, 0x0b0e, 0x00bf, 0x333c,
  0x3f80, 0x3e83, 0x3d88, 0x2a0e, 0x11f5, 0x021e, 0x0097, 0x3339,
  0x3f00, 0x3e04, 0x2a56, 0x1974, 0x032d, 0x011a, 0x008f, 0x3336,
  0x3e80, 0x2aab, 0x199a, 0x03f8, 0x017f, 0x00e6, 0x0087, 0x3333,
  0x2b00, 0x19cd, 0x03f2, 0x0187, 0x0129, 0x00b2, 0x007f, 0x3330,
  0x1a00, 0x03f9, 0x017c, 0x010a, 0x00d3, 0x007e, 0x0077, 0x332d,
  0x0400, 0x017e, 0x00fe, 0x008d, 0x007d, 0x004a, 0x006f, 0x331b,
  0x0180, 0x00ff, 0x0080, 0x0010, 0x0027, 0x0016, 0x003f, 0x329a,
  0x0100, 0x0080, 0x0002, 0xff93, 0xffd1, 0xfede, 0xfee7, 0x3234,
  0x0080, 0x0001, 0xff84, 0xff16, 0xfdcd, 0xf622, 0xfdd7, 0x31bc,
  0x0000, 0xff82, 0xff06, 0xfc28, 0xef5b, 0xef3a, 0xfc97, 0x31b9,
  0xff80, 0xff03, 0xfc12, 0xe729, 0xe3ef, 0xe71a, 0xfc8f, 0x31b6,
  0xff00, 0xfc09, 0xe6e8, 0xd68f, 0xd67f, 0xe6e6, 0xfc87, 0x34b3,
  0xfc00, 0xe6b4, 0xd62c, 0xc307, 0xd629, 0xe6b2, 0x047f, 0x34b0,
  0xe6b3, 0xd62b, 0xc2f9, 0xd5bc, 0xe6b1, 0x047e, 0x01fc, 0x342f,
  0xd5d5, 0xc27b, 0xc27c, 0xd566, 0x1a7d, 0x0476, 0x01f9, 0x342d,
  0xc1fd, 0xc1fd, 0xc1ff, 0x2b10, 0x1a49, 0x046e, 0x01f6, 0x33df,
  0xc17e, 0xc17f, 0x3e82, 0x2aba, 0x1a15, 0x0466, 0x0181, 0x339b,
  0xc0ff, 0x3f01, 0x3e05, 0x2a64, 0x19e1, 0x032e, 0x011b, 0x3343,
  0x3f80, 0x3e83, 0x3d88, 0x2a0e, 0x11f5, 0x021e, 0x0097, 0x3339,
  0x3f01, 0x3e05, 0x3d0b, 0x1cf4, 0x0b0d, 0x00be, 0x0088, 0x3337,
  0x3e82, 0x3d87, 0x2a00, 0x1188, 0x021d, 0x0096, 0x0085, 0x3335,
  0x3e03, 0x2a55, 0x1966, 0x02c0, 0x0119, 0x008e, 0x0082, 0x3333,
  0x2aaa, 0x1999, 0x03ea, 0x0112, 0x00e5, 0x0086, 0x007f, 0x3331,
  0x19cc, 0x03f1, 0x0179, 0x00bc, 0x00b1, 0x007e, 0x007c, 0x332f,
  0x03f8, 0x017b, 0x00fc, 0x0066, 0x007d, 0x0076, 0x0079, 0x3323,
  0x017d, 0x00fd, 0x007f, 0x0010, 0x0049, 0x006e, 0x0067, 0x32cd,
  0x00fe, 0x007f, 0x0002, 0xffba, 0x0015, 0x003e, 0xffe6, 0x3289,
  0x007f, 0x0001, 0xff85, 0xff64, 0xfedd, 0xfee6, 0xff80, 0x3239,
  0x0000, 0xff83, 0xff08, 0xfd60, 0xf621, 0xfdd6, 0xff08, 0x3237,
  0xff81, 0xff05, 0xfc1a, 0xeeee, 0xef39, 0xfc96, 0xff05, 0x3235,
  0xff02, 0xfc11, 0xe71b, 0xe382, 0xe719, 0xfc8e, 0xff02, 0x3433,
  0xfc08, 0xe6e7, 0xd681, 0xd612, 0xe6e5, 0xfc86, 0x01ff, 0x3431,
  0xe6e6, 0xd680, 0xd604, 0xe678, 0xfc85, 0x01fe, 0x017d, 0x33b1,
  0xd62a, 0xc2f8, 0xd5ae, 0xe644, 0x047d, 0x01fb, 0x017b, 0x33b0,
  0xc27a, 0xc27b, 0xd558, 0x1a10, 0x0475, 0x01f8, 0x0179, 0x3389,
  0xc1fc, 0xc1fe, 0x2b02, 0x19dc, 0x046d, 0x01f5, 0x012b, 0x3367,
  0xc17e, 0x3e81, 0x2aac, 0x19a8, 0x0465, 0x0180, 0x00e7, 0x333b,
  0x3f00, 0x3e04, 0x2a56, 0x1974, 0x032d, 0x011a, 0x008f, 0x3336,
  0x3e82, 0x3d87, 0x2a00, 0x1188, 0x021d, 0x0096, 0x0085, 0x3335,
  0x3e04, 0x3d0a, 0x1ce6, 0x0aa0, 0x00bd, 0x0087, 0x0083, 0x3334,
  0x3d86, 0x29ff, 0x117a, 0x01b0, 0x0095, 0x0084, 0x0081, 0x3333,
  0x2a54, 0x1965, 0x02b2, 0x00ac, 0x008d, 0x0081, 0x007f, 0x3332,
  0x1998, 0x03e9, 0x0104, 0x0078, 0x0085, 0x007e, 0x007d, 0x3331,
  0x03f0, 0x0178, 0x00ae, 0x0044, 0x007d, 0x007b, 0x007b, 0x332b,
  0x017a, 0x00fb, 0x0058, 0x0010, 0x0075, 0x0078, 0x006f, 0x3300,
  0x00fc, 0x007e, 0x0002, 0xffdc, 0x006d, 0x0066, 0x0019, 0x32de,
  0x007e, 0x0001, 0xffac, 0xffa8, 0x003d, 0xffe5, 0xffd5, 0x32b6,
  0x0000, 0xff84, 0xff56, 0xfe70, 0xfee5, 0xff7f, 0xff85, 0x32b5,
  0xff82, 0xff07, 0xfd52, 0xf5b4, 0xfdd5, 0xff07, 0xff83, 0x32b4,
  0xff04, 0xfc19, 0xeee0, 0xeecc, 0xfc95, 0xff04, 0xff81, 0x33b3,
  0xfc10, 0xe71a, 0xe374, 0xe6ac, 0xfc8d, 0xff01, 0x017f, 0x33b2,
  0xe719, 0xe373, 0xe69e, 0xfc20, 0xff00, 0x017e, 0x00fe, 0x3333,
  0xd67f, 0xd603, 0xe66a, 0xfc18, 0x01fd, 0x017c, 0x00fd, 0x3333,
  0xc2f7, 0xd5ad, 0xe636, 0x0410, 0x01fa, 0x017a, 0x00fc, 0x3333,
  0xc27a, 0xd557, 0x1a02, 0x0408, 0x01f7, 0x0178, 0x00d5, 0x3333,
  0xc1fd, 0x2b01, 0x19ce, 0x0400, 0x01f4, 0x012a, 0x00b3, 0x3333,
  0x3e80, 0x2aab, 0x199a, 0x03f8, 0x017f, 0x00e6, 0x0087, 0x3333,
  0x3e03, 0x2a55, 0x1966, 0x02c0, 0x0119, 0x008e, 0x0082, 0x3333,
  0x3d86, 0x29ff, 0x117a, 0x01b0, 0x0095, 0x0084, 0x0081, 0x3333,
  0x3d09, 0x1ce5, 0x0a92, 0x0050, 0x0086, 0x0082, 0x0080, 0x3333,
  0x29fe, 0x1179, 0x01a2, 0x0028, 0x0083, 0x0080, 0x007f, 0x3333,
  0x1964, 0x02b1, 0x009e, 0x0020, 0x0080, 0x007e, 0x007e, 0x3333,
  0x03e8, 0x0103, 0x006a, 0x0018, 0x007d, 0x007c, 0x007d, 0x3333,
  0x0177, 0x00ad, 0x0036, 0x0010, 0x007a, 0x007a, 0x0077, 0x3333,
  0x00fa, 0x0057, 0x0002, 0x0008, 0x0077, 0x006e, 0x004c, 0x3333,
  0x007d, 0x0001, 0xffce, 0x0000, 0x0065, 0x0018, 0x002a, 0x3333,
  0x0000, 0xffab, 0xff9a, 0xffd0, 0xffe4, 0xffd4, 0x0002, 0x3333,
  0xff83, 0xff55, 0xfe62, 0xfe78, 0xff7e, 0xff84, 0x0001, 0x3333,
  0xff06, 0xfd51, 0xf5a6, 0xfd68, 0xff06, 0xff82, 0x0000, 0x3333,
  0xfc18, 0xeedf, 0xeebe, 0xfc28, 0xff03, 0xff80, 0x00ff, 0x3333,
  0xeede, 0xeebd, 0xfc1a, 0xfe96, 0xff7f, 0x00fe, 0x007f, 0x32b5,
  0xe372, 0xe69d, 0xfc12, 0xfe93, 0x017d, 0x00fd, 0x007f, 0x32b6,
  0xd602, 0xe669, 0xfc0a, 0x0190, 0x017b, 0x00fc, 0x007f, 0x32dd,
  0xd5ac, 0xe635, 0x0402, 0x018d, 0x0179, 0x00fb, 0x007f, 0x32ff,
  0xd556, 0x1a01, 0x03fa, 0x018a, 0x0177, 0x00d4, 0x007f, 0x332b,
  0x2b00, 0x19cd, 0x03f2, 0x0187, 0x0129, 0x00b2, 0x007f, 0x3330,
  0x2aaa, 0x1999, 0x03ea, 0x0112, 0x00e5, 0x0086, 0x007f, 0x3331,
  0x2a54, 0x1965, 0x02b2, 0x00ac, 0x008d, 0x0081, 0x007f, 0x3332,
  0x29fe, 0x1179, 0x01a2, 0x0028, 0x0083, 0x0080, 0x007f, 0x3333,
  0x1ce4, 0x0a91, 0x0042, 0x0019, 0x0081, 0x007f, 0x007f, 0x3334,
  0x1178, 0x01a1, 0x001a, 0x0016, 0x007f, 0x007e, 0x007f, 0x3335,
  0x02b0, 0x009d, 0x0012, 0x0013, 0x007d, 0x007d, 0x007f, 0x333b,
  0x0102, 0x0069, 0x000a, 0x0010, 0x007b, 0x007c, 0x007f, 0x3366,
  0x00ac, 0x0035, 0x0002, 0x000d, 0x0079, 0x0076, 0x007f, 0x3388,
  0x0056, 0x0001, 0xfffa, 0x000a, 0x006d, 0x004b, 0x007f, 0x33b0,
  0x0000, 0xffcd, 0xfff2, 0xfff8, 0x0017, 0x0029, 0x007f, 0x33b1,
  0xffaa, 0xff99, 0xffc2, 0xff77, 0xffd3, 0x0001, 0x007f, 0x33b2,
  0xff54, 0xfe61, 0xfe6a, 0xff11, 0xff83, 0x0000, 0x007f, 0x32b3,
  0xfd50, 0xf5a5, 0xfd5a, 0xfe99, 0xff81, 0xffff, 0x007f, 0x32b4,
  0xf5a4, 0xfd59, 0xfe8b, 0xff14, 0xfffe, 0x007e, 0x0000, 0x3237,
  0xeebc, 0xfc19, 0xfe88, 0xff12, 0x00fd, 0x007e, 0x0001, 0x3239,
  0xe69c, 0xfc11, 0xfe85, 0x0110, 0x00fc, 0x007e, 0x0002, 0x3287,
  0xe668, 0xfc09, 0x0182, 0x010e, 0x00fb, 0x007e, 0x0029, 0x32cb,
  0xe634, 0x0401, 0x017f, 0x010c, 0x00fa, 0x007e, 0x004b, 0x3323,
  0x1a00, 0x03f9, 0x017c, 0x010a, 0x00d3, 0x007e, 0x0077, 0x332d,
  0x19cc, 0x03f1, 0x0179, 0x00bc, 0x00b1, 0x007e, 0x007c, 0x332f,
  0x1998, 0x03e9, 0x0104, 0x0078, 0x0085, 0x007e, 0x007d, 0x3331,
  0x1964, 0x02b1, 0x009e, 0x0020, 0x0080, 0x007e, 0x007e, 0x3333,
  0x1178, 0x01a1, 0x001a, 0x0016, 0x007f, 0x007e, 0x007f, 0x3335,
  0x0a90, 0x0041, 0x000b, 0x0014, 0x007e, 0x007e, 0x0080, 0x3337,
  0x01a0, 0x0019, 0x0008, 0x0012, 0x007d, 0x007e, 0x0081, 0x3343,
  0x009c, 0x0011, 0x0005, 0x0010, 0x007c, 0x007e, 0x0087, 0x3399,
  0x0068, 0x0009, 0x0002, 0x000e, 0x007b, 0x007e, 0x00b2, 0x33dd,
  0x0034, 0x0001, 0xffff, 0x000c, 0x0075, 0x007e, 0x00d4, 0x342d,
  0x0000, 0xfff9, 0xfffc, 0x0000, 0x004a, 0x007e, 0x00fc, 0x342f,
  0xffcc, 0xfff1, 0xffea, 0xffaa, 0x0028, 0x007e, 0x00fd, 0x3431,
  0xff98, 0xffc1, 0xff69, 0xff66, 0x0000, 0x007e, 0x00fe, 0x3233,
  0xfe60, 0xfe69, 0xff03, 0xff16, 0xffff, 0x007e, 0xffff, 0x3235,
  0xfe68, 0xff02, 0xff08, 0xff92, 0x007d, 0xfffe, 0xff81, 0x2f43,
  0xfd58, 0xfe8a, 0xff06, 0xff91, 0x007d, 0xffff, 0xff83, 0x2f4b,
  0xfc18, 0xfe87, 0xff04, 0x0090, 0x007d, 0x0000, 0xff85, 0x3083,
  0xfc10, 0xfe84, 0x0102, 0x008f, 0x007d, 0x0001, 0xffd3, 0x3193,
  0xfc08, 0x0181, 0x0100, 0x008e, 0x007d, 0x0028, 0x0017, 0x32f3,
  0x0400, 0x017e, 0x00fe, 0x008d, 0x007d, 0x004a, 0x006f, 0x331b,
  0x03f8, 0x017b, 0x00fc, 0x0066, 0x007d, 0x0076, 0x0079, 0x3323,
  0x03f0, 0x0178, 0x00ae, 0x0044, 0x007d, 0x007b, 0x007b, 0x332b,
  0x03e8, 0x0103, 0x006a, 0x0018, 0x007d, 0x007c, 0x007d, 0x3333,
  0x02b0, 0x009d, 0x0012, 0x0013, 0x007d, 0x007d, 0x007f, 0x333b,
  0x01a0, 0x0019, 0x0008, 0x0012, 0x007d, 0x007e, 0x0081, 0x3343,
  0x0040, 0x000a, 0x0006, 0x0011, 0x007d, 0x007f, 0x0083, 0x3373,
  0x0018, 0x0007, 0x0004, 0x0010, 0x007d, 0x0080, 0x008f, 0x34cb,
  0x0010, 0x0004, 0x0002, 0x000f, 0x007d, 0x0086, 0x00e5, 0x35db,
  0x0008, 0x0001, 0x0000, 0x000e, 0x007d, 0x00b1, 0x0129, 0x371b,
  0x0000, 0xfffe, 0xfffe, 0x0008, 0x007d, 0x00d3, 0x0179, 0x3723,
  0xfff8, 0xfffb, 0xfff2, 0xffdd, 0x007d, 0x00fb, 0x017b, 0x372b,
  0xfff0, 0xffe9, 0xff9c, 0xffbb, 0x007d, 0x00fc, 0x017d, 0x2f33,
  0xffc0, 0xff68, 0xff58, 0xff93, 0x007d, 0x00fd, 0xff7f, 0x2f3b,
  0xff67, 0xff57, 0xff85, 0x0010, 0x00fc, 0xff7e, 0xfc87, 0x1a19,
  0xff01, 0xff07, 0xff84, 0x0010, 0xfffd, 0xff80, 0xfc8f, 0x1a4c,
  0xfe89, 0xff05, 0xff83, 0x0010, 0xfffe, 0xff82, 0xfc97, 0x2211,
  0xfe86, 0xff03, 0x0082, 0x0010, 0xffff, 0xff84, 0xfdcf, 0x28d7,
  0xfe83, 0x0101, 0x0081, 0x0010, 0x0000, 0xffd2, 0xfedf, 0x319b,
  0x0180, 0x00ff, 0x0080, 0x0010, 0x0027, 0x0016, 0x003f, 0x329a,
  0x017d, 0x00fd, 0x007f, 0x0010, 0x0049, 0x006e, 0x0067, 0x32cd,
  0x017a, 0x00fb, 0x0058, 0x0010, 0x0075, 0x0078, 0x006f, 0x3300,
  0x0177, 0x00ad, 0x0036, 0x0010, 0x007a, 0x007a, 0x0077, 0x3333,
  0x0102, 0x0069, 0x000a, 0x0010, 0x007b, 0x007c, 0x007f, 0x3366,
  0x009c, 0x0011, 0x0005, 0x0010, 0x007c, 0x007e, 0x0087, 0x3399,
  0x0018, 0x0007, 0x0004, 0x0010, 0x007d, 0x0080, 0x008f, 0x34cb,
  0x0009, 0x0005, 0x0003, 0x0010, 0x007e, 0x0082, 0x00bf, 0x3d5c,
  0x0006, 0x0003, 0x0002, 0x0010, 0x007f, 0x008e, 0x0217, 0x4422,
  0x0003, 0x0001, 0x0001, 0x0010, 0x0085, 0x00e4, 0x0327, 0x4c1a,
  0x0000, 0xffff, 0x0000, 0x0010, 0x00b0, 0x0128, 0x0467, 0x4c4d,
  0xfffd, 0xfffd, 0xfffa, 0x0010, 0x00d2, 0x0178, 0x046f, 0x4c80,
  0xfffa, 0xfff1, 0xffcf, 0x0010, 0x00fa, 0x017a, 0x0477, 0x19b3,
  0xffe8, 0xff9b, 0xffad, 0x0010, 0x00fb, 0x017c, 0xfc7f, 0x19e6,
  0xff9a, 0xffac, 0x0002, 0x008e, 0x017b, 0xfc7e, 0xe732, 0x095d,
  0xff56, 0xff84, 0x0002, 0x008f, 0xff7d, 0xfc86, 0xe765, 0x09b2,
  0xff06, 0xff83, 0x0002, 0xff90, 0xff7f, 0xfc8e, 0xe798, 0x16a5,
  0xff04, 0xff82, 0x0002, 0xff91, 0xff81, 0xfc96, 0xef5d, 0x21ef,
  0xff02, 0x0081, 0x0002, 0xff92, 0xff83, 0xfdce, 0xf623, 0x308b,
  0x0100, 0x0080, 0x0002, 0xff93, 0xffd1, 0xfede, 0xfee7, 0x3234,
  0x00fe, 0x007f, 0x0002, 0xffba, 0x0015, 0x003e, 0xffe6, 0x3289,
  0x00fc, 0x007e, 0x0002, 0xffdc, 0x006d, 0x0066, 0x0019, 0x32de,
  0x00fa, 0x0057, 0x0002, 0x0008, 0x0077, 0x006e, 0x004c, 0x3333,
  0x00ac, 0x0035, 0x0002, 0x000d, 0x0079, 0x0076, 0x007f, 0x3388,
  0x0068, 0x0009, 0x0002, 0x000e, 0x007b, 0x007e, 0x00b2, 0x33dd,
  0x0010, 0x0004, 0x0002, 0x000f, 0x007d, 0x0086, 0x00e5, 0x35db,
  0x0006, 0x0003, 0x0002, 0x0010, 0x007f, 0x008e, 0x0217, 0x4422,
  0x0004, 0x0002, 0x0002, 0x0011, 0x0081, 0x00be, 0x0aa8, 0x4f6c,
  0x0002, 0x0001, 0x0002, 0x0012, 0x008d, 0x0216, 0x116e, 0x5cb4,
  0x0000, 0x0000, 0x0002, 0x0018, 0x00e3, 0x0326, 0x1966, 0x5d09,
  0xfffe, 0xffff, 0x0002, 0x0043, 0x0127, 0x0466, 0x1999, 0x5d5e,
  0xfffc, 0xfff9, 0x0002, 0x0065, 0x0177, 0x046e, 0x19cc, 0x08b3,
  0xfff0, 0xffce, 0x0002, 0x008d, 0x0179, 0x0476, 0xe6ff, 0x0908,
  0xffcd, 0x0001, 0x007f, 0x010c, 0x0475, 0xe6fe, 0xd654, 0xf5ad,
  0xffab, 0x0001, 0x0080, 0x010e, 0xfc7d, 0xe731, 0xd6a9, 0xf62a,
  0xff83, 0x0001, 0x0081, 0xff10, 0xfc85, 0xe764, 0xd6fe, 0x0935,
  0xff82, 0x0001, 0xff82, 0xff12, 0xfc8d, 0xe797, 0xe3f1, 0x19cf,
  0xff81, 0x0001, 0xff83, 0xff14, 0xfc95, 0xef5c, 0xef3b, 0x2f4b,
  0x0080, 0x0001, 0xff84, 0xff16, 0xfdcd, 0xf622, 0xfdd7, 0x31bc,
  0x007f, 0x0001, 0xff85, 0xff64, 0xfedd, 0xfee6, 0xff80, 0x3239,
  0x007e, 0x0001, 0xffac, 0xffa8, 0x003d, 0xffe5, 0xffd5, 0x32b6,
  0x007d, 0x0001, 0xffce, 0x0000, 0x0065, 0x0018, 0x002a, 0x3333,
  0x0056, 0x0001, 0xfffa, 0x000a, 0x006d, 0x004b, 0x007f, 0x33b0,
  0x0034, 0x0001, 0xffff, 0x000c, 0x0075, 0x007e, 0x00d4, 0x342d,
  0x0008, 0x0001, 0x0000, 0x000e, 0x007d, 0x00b1, 0x0129, 0x371b,
  0x0003, 0x0001, 0x0001, 0x0010, 0x0085, 0x00e4, 0x0327, 0x4c1a,
  0x0002, 0x0001, 0x0002, 0x0012, 0x008d, 0x0216, 0x116e, 0x5cb4,
  0x0001, 0x0001, 0x0003, 0x0014, 0x00bd, 0x0aa7, 0x1cb8, 0x703c,
  0x0000, 0x0001, 0x0004, 0x0020, 0x0215, 0x116d, 0x2a00, 0x70b9,
  0xffff, 0x0001, 0x000a, 0x0076, 0x0325, 0x1965, 0x2a55, 0x7136,
  0xfffe, 0x0001, 0x0035, 0x00ba, 0x0465, 0x1998, 0x2aaa, 0xf4b3,
  0xfff8, 0x0001, 0x0057, 0x010a, 0x046d, 0x19cb, 0xd5ff, 0xf530,
  0x0000, 0x0056, 0x00fc, 0x0400, 0x19ca, 0xd5fe, 0xc27c, 0xf52f,
  0x0000, 0x007e, 0x00fe, 0x0408, 0xe6fd, 0xd653, 0xc2f9, 0xf5ad,
  0x0000, 0x007f, 0x0100, 0xfc10, 0xe730, 0xd6a8, 0xc376, 0x08df,
  0x0000, 0x0080, 0xff02, 0xfc18, 0xe763, 0xd6fd, 0xd681, 0x199b,
  0x0000, 0xff81, 0xff04, 0xfc20, 0xe796, 0xe3f0, 0xe71b, 0x2f43,
  0x0000, 0xff82, 0xff06, 0xfc28, 0xef5b, 0xef3a, 0xfc97, 0x31b9,
  0x0000, 0xff83, 0xff08, 0xfd60, 0xf621, 0xfdd6, 0xff08, 0x3237,
  0x0000, 0xff84, 0xff56, 0xfe70, 0xfee5, 0xff7f, 0xff85, 0x32b5,
  0x0000, 0xffab, 0xff9a, 0xffd0, 0xffe4, 0xffd4, 0x0002, 0x3333,
  0x0000, 0xffcd, 0xfff2, 0xfff8, 0x0017, 0x0029, 0x007f, 0x33b1,
  0x0000, 0xfff9, 0xfffc, 0x0000, 0x004a, 0x007e, 0x00fc, 0x342f,
  0x0000, 0xfffe, 0xfffe, 0x0008, 0x007d, 0x00d3, 0x0179, 0x3723,
  0x0000, 0xffff, 0x0000, 0x0010, 0x00b0, 0x0128, 0x0467, 0x4c4d,
  0x0000, 0x0000, 0x0002, 0x0018, 0x00e3, 0x0326, 0x1966, 0x5d09,
  0x0000, 0x0001, 0x0004, 0x0020, 0x0215, 0x116d, 0x2a00, 0x70b9,
  0x0000, 0x0002, 0x0006, 0x0050, 0x0aa6, 0x1cb7, 0x3d88, 0x7137,
  0x0000, 0x0003, 0x0012, 0x01a8, 0x116c, 0x29ff, 0x3e05, 0x71b5,
  0x0000, 0x0009, 0x0068, 0x02b8, 0x1964, 0x2a54, 0x3e82, 0xf433,
  0x0000, 0x0034, 0x00ac, 0x03f8, 0x1997, 0x2aa9, 0xc1ff, 0xf4b1,
  0x0033, 0x00ab, 0x03ea, 0x192a, 0x2aa8, 0xc1fe, 0xc1fd, 0xf4b1,
  0x0055, 0x00fb, 0x03f2, 0x195d, 0xd5fd, 0xc27b, 0xc27b, 0xf530,
  0x007d, 0x00fd, 0x03fa, 0xe690, 0xd652, 0xc2f8, 0xc2f9, 0x0889,
  0x007e, 0x00ff, 0xfc02, 0xe6c3, 0xd6a7, 0xc375, 0xd62b, 0x1967,
  0x007f, 0xff01, 0xfc0a, 0xe6f6, 0xd6fc, 0xd680, 0xe6e7, 0x2f3b,
  0xff80, 0xff03, 0xfc12, 0xe729, 0xe3ef, 0xe71a, 0xfc8f, 0x31b6,
  0xff81, 0xff05, 0xfc1a, 0xeeee, 0xef39, 0xfc96, 0xff05, 0x3235,
  0xff82, 0xff07, 0xfd52, 0xf5b4, 0xfdd5, 0xff07, 0xff83, 0x32b4,
  0xff83, 0xff55, 0xfe62, 0xfe78, 0xff7e, 0xff84, 0x0001, 0x3333,
  0xffaa, 0xff99, 0xffc2, 0xff77, 0xffd3, 0x0001, 0x007f, 0x33b2,
  0xffcc, 0xfff1, 0xffea, 0xffaa, 0x0028, 0x007e, 0x00fd, 0x3431,
  0xfff8, 0xfffb, 0xfff2, 0xffdd, 0x007d, 0x00fb, 0x017b, 0x372b,
  0xfffd, 0xfffd, 0xfffa, 0x0010, 0x00d2, 0x0178, 0x046f, 0x4c80,
  0xfffe, 0xffff, 0x0002, 0x0043, 0x0127, 0x0466, 0x1999, 0x5d5e,
  0xffff, 0x0001, 0x000a, 0x0076, 0x0325, 0x1965, 0x2a55, 0x7136,
  0x0000, 0x0003, 0x0012, 0x01a8, 0x116c, 0x29ff, 0x3e05, 0x71b5,
  0x0001, 0x0005, 0x0042, 0x0a39, 0x1cb6, 0x3d87, 0x3e83, 0x7234,
  0x0002, 0x0011, 0x019a, 0x10ff, 0x29fe, 0x3e04, 0x3f01, 0xf3b3,
  0x0008, 0x0067, 0x02aa, 0x18f7, 0x2a53, 0x3e81, 0xc17f, 0xf432,
  0x0066, 0x02a9, 0x18e9, 0x29e6, 0x3e80, 0xc17e, 0xc17e, 0x7233,
  0x00aa, 0x03e9, 0x191c, 0x2a3b, 0xc1fd, 0xc1fc, 0xc1fd, 0x71b3,
  0x00fa, 0x03f1, 0x194f, 0xd590, 0xc27a, 0xc27a, 0xc27c, 0x5e33,
  0x00fc, 0x03f9, 0xe682, 0xd5e5, 0xc2f7, 0xc2f8, 0xd5d5, 0x4d33,
  0x00fe, 0xfc01, 0xe6b5, 0xd63a, 0xc374, 0xd62a, 0xe6b3, 0x3733,
  0xff00, 0xfc09, 0xe6e8, 0xd68f, 0xd67f, 0xe6e6, 0xfc87, 0x34b3,
  0xff02, 0xfc11, 0xe71b, 0xe382, 0xe719, 0xfc8e, 0xff02, 0x3433,
  0xff04, 0xfc19, 0xeee0, 0xeecc, 0xfc95, 0xff04, 0xff81, 0x33b3,
  0xff06, 0xfd51, 0xf5a6, 0xfd68, 0xff06, 0xff82, 0x0000, 0x3333,
  0xff54, 0xfe61, 0xfe6a, 0xff11, 0xff83, 0x0000, 0x007f, 0x32b3,
  0xff98, 0xffc1, 0xff69, 0xff66, 0x0000, 0x007e, 0x00fe, 0x3233,
  0xfff0, 0xffe9, 0xff9c, 0xffbb, 0x007d, 0x00fc, 0x017d, 0x2f33,
  0xfffa, 0xfff1, 0xffcf, 0x0010, 0x00fa, 0x017a, 0x0477, 0x19b3,
  0xfffc, 0xfff9, 0x0002, 0x0065, 0x0177, 0x046e, 0x19cc, 0x08b3,
  0xfffe, 0x0001, 0x0035, 0x00ba, 0x0465, 0x1998, 0x2aaa, 0xf4b3,
  0x0000, 0x0009, 0x0068, 0x02b8, 0x1964, 0x2a54, 0x3e82, 0xf433,
  0x0002, 0x0011, 0x019a, 0x10ff, 0x29fe, 0x3e04, 0x3f01, 0xf3b3,
  0x0004, 0x0041, 0x0a2b, 0x1c49, 0x3d86, 0x3e82, 0x3f80, 0x7333,
  0x0010, 0x0199, 0x10f1, 0x2991, 0x3e03, 0x3f00, 0xc0ff, 0x72b3,
  0x0198, 0x10f0, 0x2983, 0x3d96, 0x3eff, 0xc0fe, 0x3fff, 0x71b5,
  0x02a8, 0x18e8, 0x29d8, 0x3e13, 0xc17d, 0xc17d, 0x3f7f, 0x7136,
  0x03e8, 0x191b, 0x2a2d, 0xc190, 0xc1fb, 0xc1fc, 0x3eff, 0x5ddd,
  0x03f0, 0x194e, 0xd582, 0xc20d, 0xc279, 0xc27b, 0x2b7f, 0x4cff,
  0x03f8, 0xe681, 0xd5d7, 0xc28a, 0xc2f7, 0xd5d4, 0x1a7f, 0x372b,
  0xfc00, 0xe6b4, 0xd62c, 0xc307, 0xd629, 0xe6b2, 0x047f, 0x34b0,
  0xfc08, 0xe6e7, 0xd681, 0xd612, 0xe6e5, 0xfc86, 0x01ff, 0x3431,
  0xfc10, 0xe71a, 0xe374, 0xe6ac, 0xfc8d, 0xff01, 0x017f, 0x33b2,
  0xfc18, 0xeedf, 0xeebe, 0xfc28, 0xff03, 0xff80, 0x00ff, 0x3333,
  0xfd50, 0xf5a5, 0xfd5a, 0xfe99, 0xff81, 0xffff, 0x007f, 0x32b4,
  0xfe60, 0xfe69, 0xff03, 0xff16, 0xffff, 0x007e, 0xffff, 0x3235,
  0xffc0, 0xff68, 0xff58, 0xff93, 0x007d, 0x00fd, 0xff7f, 0x2f3b,
  0xffe8, 0xff9b, 0xffad, 0x0010, 0x00fb, 0x017c, 0xfc7f, 0x19e6,
  0xfff0, 0xffce, 0x0002, 0x008d, 0x0179, 0x0476, 0xe6ff, 0x0908,
  0xfff8, 0x0001, 0x0057, 0x010a, 0x046d, 0x19cb, 0xd5ff, 0xf530,
  0x0000, 0x0034, 0x00ac, 0x03f8, 0x1997, 0x2aa9, 0xc1ff, 0xf4b1,
  0x0008, 0x0067, 0x02aa, 0x18f7, 0x2a53, 0x3e81, 0xc17f, 0xf432,
  0x0010, 0x0199, 0x10f1, 0x2991, 0x3e03, 0x3f00, 0xc0ff, 0x72b3,
  0x0040, 0x0a2a, 0x1c3b, 0x3d19, 0x3e81, 0x3f7f, 0x407f, 0x7234,
};
const unsigned kExpectedCount_NEON_smlal_8H = 361;

#endif  // VIXL_SIM_SMLAL_8H_TRACE_AARCH64_H_
