// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_USUBL2_8H_TRACE_AARCH64_H_
#define VIXL_SIM_USUBL2_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_usubl2_8H[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd9, 0xffde, 0xffd4, 0xfffb, 0xffff, 0xffff, 0x00ff, 0xffff,
  0xffb7, 0xffb2, 0xffcf, 0xfffa, 0xfffe, 0x00fe, 0x00fe, 0xfffe,
  0xff8b, 0xffad, 0xffce, 0xfff9, 0x00fd, 0x00fd, 0x00fd, 0xfff8,
  0xff86, 0xffac, 0xffcd, 0x00f8, 0x00fc, 0x00fc, 0x00f7, 0xffcd,
  0xff85, 0xffab, 0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc, 0xffab,
  0xff84, 0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa, 0xff83,
  0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082, 0xff82,
  0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081, 0xff81,
  0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080, 0x0080, 0xff80,
  0x007b, 0x0077, 0x0077, 0x007b, 0x007f, 0x007f, 0x007f, 0xff7f,
  0x0050, 0x0055, 0x004f, 0x007a, 0x007e, 0x007e, 0x007e, 0xff7e,
  0x002e, 0x002d, 0x004e, 0x0079, 0x007d, 0x007d, 0x007d, 0xff7d,
  0x0006, 0x002c, 0x004d, 0x0078, 0x007c, 0x007c, 0x007c, 0xff56,
  0x0005, 0x002b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0xff34,
  0x0004, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0xff08,
  0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0xff03,
  0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0xff02,
  0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0xff01,
  0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0xff01, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffde, 0xffd4, 0xfffb, 0xffff, 0xffff, 0x00ff, 0xffff, 0xffff,
  0xffb2, 0xffcf, 0xfffa, 0xfffe, 0x00fe, 0x00fe, 0xfffe, 0xfff9,
  0xffad, 0xffce, 0xfff9, 0x00fd, 0x00fd, 0x00fd, 0xfff8, 0xffce,
  0xffac, 0xffcd, 0x00f8, 0x00fc, 0x00fc, 0x00f7, 0xffcd, 0xffac,
  0xffab, 0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc, 0xffab, 0xff84,
  0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa, 0xff83, 0xff83,
  0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082, 0xff82, 0xff82,
  0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081, 0xff81, 0xff81,
  0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080, 0x0080, 0xff80, 0xff80,
  0x0077, 0x0077, 0x007b, 0x007f, 0x007f, 0x007f, 0xff7f, 0xff7f,
  0x0055, 0x004f, 0x007a, 0x007e, 0x007e, 0x007e, 0xff7e, 0xff7e,
  0x002d, 0x004e, 0x0079, 0x007d, 0x007d, 0x007d, 0xff7d, 0xff57,
  0x002c, 0x004d, 0x0078, 0x007c, 0x007c, 0x007c, 0xff56, 0xff35,
  0x002b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0xff34, 0xff09,
  0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0xff08, 0xff04,
  0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0xff03, 0xff03,
  0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0xff02, 0xff02,
  0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0xff02, 0xff02, 0x0002,
  0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0xff01, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd4, 0xfffb, 0xffff, 0xffff, 0x00ff, 0xffff, 0xffff, 0xfffa,
  0xffcf, 0xfffa, 0xfffe, 0x00fe, 0x00fe, 0xfffe, 0xfff9, 0xffcf,
  0xffce, 0xfff9, 0x00fd, 0x00fd, 0x00fd, 0xfff8, 0xffce, 0xffad,
  0xffcd, 0x00f8, 0x00fc, 0x00fc, 0x00f7, 0xffcd, 0xffac, 0xff85,
  0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc, 0xffab, 0xff84, 0xff84,
  0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa, 0xff83, 0xff83, 0xff83,
  0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082, 0xff82, 0xff82, 0xff82,
  0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081, 0xff81, 0xff81, 0xff81,
  0x0099, 0x00a3, 0x0080, 0x0080, 0x0080, 0xff80, 0xff80, 0xff80,
  0x0077, 0x007b, 0x007f, 0x007f, 0x007f, 0xff7f, 0xff7f, 0xff7f,
  0x004f, 0x007a, 0x007e, 0x007e, 0x007e, 0xff7e, 0xff7e, 0xff58,
  0x004e, 0x0079, 0x007d, 0x007d, 0x007d, 0xff7d, 0xff57, 0xff36,
  0x004d, 0x0078, 0x007c, 0x007c, 0x007c, 0xff56, 0xff35, 0xff0a,
  0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0xff34, 0xff09, 0xff05,
  0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0xff08, 0xff04, 0xff04,
  0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0xff03, 0xff03, 0xff03,
  0x0075, 0x0053, 0x0032, 0x0007, 0xff03, 0xff03, 0xff03, 0x0008,
  0x004e, 0x0031, 0x0006, 0x0002, 0xff02, 0xff02, 0x0002, 0x0007,
  0x002c, 0x0005, 0x0001, 0x0001, 0xff01, 0x0001, 0x0001, 0x0006,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xffff, 0x00ff, 0xffff, 0xffff, 0xfffa, 0xffd5,
  0xfffa, 0xfffe, 0x00fe, 0x00fe, 0xfffe, 0xfff9, 0xffcf, 0xffb3,
  0xfff9, 0x00fd, 0x00fd, 0x00fd, 0xfff8, 0xffce, 0xffad, 0xff8b,
  0x00f8, 0x00fc, 0x00fc, 0x00f7, 0xffcd, 0xffac, 0xff85, 0xff8a,
  0x00f7, 0x00fb, 0x00f6, 0x00cc, 0xffab, 0xff84, 0xff84, 0xff89,
  0x00f6, 0x00f5, 0x00cb, 0x00aa, 0xff83, 0xff83, 0xff83, 0xff88,
  0x00f0, 0x00ca, 0x00a9, 0x0082, 0xff82, 0xff82, 0xff82, 0xff87,
  0x00c5, 0x00a8, 0x0081, 0x0081, 0xff81, 0xff81, 0xff81, 0xff86,
  0x00a3, 0x0080, 0x0080, 0x0080, 0xff80, 0xff80, 0xff80, 0xff85,
  0x007b, 0x007f, 0x007f, 0x007f, 0xff7f, 0xff7f, 0xff7f, 0xff5e,
  0x007a, 0x007e, 0x007e, 0x007e, 0xff7e, 0xff7e, 0xff58, 0xff3c,
  0x0079, 0x007d, 0x007d, 0x007d, 0xff7d, 0xff57, 0xff36, 0xff10,
  0x0078, 0x007c, 0x007c, 0x007c, 0xff56, 0xff35, 0xff0a, 0xff0b,
  0x0077, 0x007b, 0x007b, 0x0055, 0xff34, 0xff09, 0xff05, 0xff0a,
  0x0076, 0x007a, 0x0054, 0x0033, 0xff08, 0xff04, 0xff04, 0xff09,
  0x007a, 0x0054, 0x0033, 0xff08, 0xff04, 0xff04, 0xff09, 0x0033,
  0x0053, 0x0032, 0x0007, 0xff03, 0xff03, 0xff03, 0x0008, 0x0032,
  0x0031, 0x0006, 0x0002, 0xff02, 0xff02, 0x0002, 0x0007, 0x0031,
  0x0005, 0x0001, 0x0001, 0xff01, 0x0001, 0x0001, 0x0006, 0x002b,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x00ff, 0xffff, 0xffff, 0xfffa, 0xffd5, 0xffde,
  0xfffe, 0x00fe, 0x00fe, 0xfffe, 0xfff9, 0xffcf, 0xffb3, 0xffb6,
  0x00fd, 0x00fd, 0x00fd, 0xfff8, 0xffce, 0xffad, 0xff8b, 0xffb5,
  0x00fc, 0x00fc, 0x00f7, 0xffcd, 0xffac, 0xff85, 0xff8a, 0xffb4,
  0x00fb, 0x00f6, 0x00cc, 0xffab, 0xff84, 0xff84, 0xff89, 0xffb3,
  0x00f5, 0x00cb, 0x00aa, 0xff83, 0xff83, 0xff83, 0xff88, 0xffb2,
  0x00ca, 0x00a9, 0x0082, 0xff82, 0xff82, 0xff82, 0xff87, 0xffb1,
  0x00a8, 0x0081, 0x0081, 0xff81, 0xff81, 0xff81, 0xff86, 0xffb0,
  0x0080, 0x0080, 0x0080, 0xff80, 0xff80, 0xff80, 0xff85, 0xff89,
  0x007f, 0x007f, 0x007f, 0xff7f, 0xff7f, 0xff7f, 0xff5e, 0xff67,
  0x007e, 0x007e, 0x007e, 0xff7e, 0xff7e, 0xff58, 0xff3c, 0xff3b,
  0x007d, 0x007d, 0x007d, 0xff7d, 0xff57, 0xff36, 0xff10, 0xff36,
  0x007c, 0x007c, 0x007c, 0xff56, 0xff35, 0xff0a, 0xff0b, 0xff35,
  0x007b, 0x007b, 0x0055, 0xff34, 0xff09, 0xff05, 0xff0a, 0xff34,
  0x007b, 0x0055, 0xff34, 0xff09, 0xff05, 0xff0a, 0xff34, 0x0055,
  0x0054, 0x0033, 0xff08, 0xff04, 0xff04, 0xff09, 0x0033, 0x0054,
  0x0032, 0x0007, 0xff03, 0xff03, 0xff03, 0x0008, 0x0032, 0x0053,
  0x0006, 0x0002, 0xff02, 0xff02, 0x0002, 0x0007, 0x0031, 0x004d,
  0x0001, 0x0001, 0xff01, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x00ff, 0xffff, 0xffff, 0xfffa, 0xffd5, 0xffde, 0xffd8,
  0x00fe, 0x00fe, 0xfffe, 0xfff9, 0xffcf, 0xffb3, 0xffb6, 0xffd7,
  0x00fd, 0x00fd, 0xfff8, 0xffce, 0xffad, 0xff8b, 0xffb5, 0xffd6,
  0x00fc, 0x00f7, 0xffcd, 0xffac, 0xff85, 0xff8a, 0xffb4, 0xffd5,
  0x00f6, 0x00cc, 0xffab, 0xff84, 0xff84, 0xff89, 0xffb3, 0xffd4,
  0x00cb, 0x00aa, 0xff83, 0xff83, 0xff83, 0xff88, 0xffb2, 0xffd3,
  0x00a9, 0x0082, 0xff82, 0xff82, 0xff82, 0xff87, 0xffb1, 0xffd2,
  0x0081, 0x0081, 0xff81, 0xff81, 0xff81, 0xff86, 0xffb0, 0xffab,
  0x0080, 0x0080, 0xff80, 0xff80, 0xff80, 0xff85, 0xff89, 0xff89,
  0x007f, 0x007f, 0xff7f, 0xff7f, 0xff7f, 0xff5e, 0xff67, 0xff5d,
  0x007e, 0x007e, 0xff7e, 0xff7e, 0xff58, 0xff3c, 0xff3b, 0xff58,
  0x007d, 0x007d, 0xff7d, 0xff57, 0xff36, 0xff10, 0xff36, 0xff57,
  0x007c, 0x007c, 0xff56, 0xff35, 0xff0a, 0xff0b, 0xff35, 0xff56,
  0x007c, 0xff56, 0xff35, 0xff0a, 0xff0b, 0xff35, 0xff56, 0x007d,
  0x0055, 0xff34, 0xff09, 0xff05, 0xff0a, 0xff34, 0x0055, 0x007c,
  0x0033, 0xff08, 0xff04, 0xff04, 0xff09, 0x0033, 0x0054, 0x007b,
  0x0007, 0xff03, 0xff03, 0xff03, 0x0008, 0x0032, 0x0053, 0x0075,
  0x0002, 0xff02, 0xff02, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a,
  0x0001, 0xff01, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00ff, 0xffff, 0xffff, 0xfffa, 0xffd5, 0xffde, 0xffd8, 0xffff,
  0x00fe, 0xfffe, 0xfff9, 0xffcf, 0xffb3, 0xffb6, 0xffd7, 0xfffe,
  0x00fd, 0xfff8, 0xffce, 0xffad, 0xff8b, 0xffb5, 0xffd6, 0xfffd,
  0x00f7, 0xffcd, 0xffac, 0xff85, 0xff8a, 0xffb4, 0xffd5, 0xfffc,
  0x00cc, 0xffab, 0xff84, 0xff84, 0xff89, 0xffb3, 0xffd4, 0xfffb,
  0x00aa, 0xff83, 0xff83, 0xff83, 0xff88, 0xffb2, 0xffd3, 0xfffa,
  0x0082, 0xff82, 0xff82, 0xff82, 0xff87, 0xffb1, 0xffd2, 0xffd3,
  0x0081, 0xff81, 0xff81, 0xff81, 0xff86, 0xffb0, 0xffab, 0xffb1,
  0x0080, 0xff80, 0xff80, 0xff80, 0xff85, 0xff89, 0xff89, 0xff85,
  0x007f, 0xff7f, 0xff7f, 0xff7f, 0xff5e, 0xff67, 0xff5d, 0xff80,
  0x007e, 0xff7e, 0xff7e, 0xff58, 0xff3c, 0xff3b, 0xff58, 0xff7f,
  0x007d, 0xff7d, 0xff57, 0xff36, 0xff10, 0xff36, 0xff57, 0xff7e,
  0xff7d, 0xff57, 0xff36, 0xff10, 0xff36, 0xff57, 0xff7e, 0x007e,
  0xff56, 0xff35, 0xff0a, 0xff0b, 0xff35, 0xff56, 0x007d, 0x007d,
  0xff34, 0xff09, 0xff05, 0xff0a, 0xff34, 0x0055, 0x007c, 0x007c,
  0xff08, 0xff04, 0xff04, 0xff09, 0x0033, 0x0054, 0x007b, 0x0076,
  0xff03, 0xff03, 0xff03, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b,
  0xff02, 0xff02, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029,
  0xff01, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfffa, 0xffd5, 0xffde, 0xffd8, 0xffff, 0xffff,
  0xfffe, 0xfff9, 0xffcf, 0xffb3, 0xffb6, 0xffd7, 0xfffe, 0xfffe,
  0xfff8, 0xffce, 0xffad, 0xff8b, 0xffb5, 0xffd6, 0xfffd, 0xfffd,
  0xffcd, 0xffac, 0xff85, 0xff8a, 0xffb4, 0xffd5, 0xfffc, 0xfffc,
  0xffab, 0xff84, 0xff84, 0xff89, 0xffb3, 0xffd4, 0xfffb, 0xfffb,
  0xff83, 0xff83, 0xff83, 0xff88, 0xffb2, 0xffd3, 0xfffa, 0xffd4,
  0xff82, 0xff82, 0xff82, 0xff87, 0xffb1, 0xffd2, 0xffd3, 0xffb2,
  0xff81, 0xff81, 0xff81, 0xff86, 0xffb0, 0xffab, 0xffb1, 0xff86,
  0xff80, 0xff80, 0xff80, 0xff85, 0xff89, 0xff89, 0xff85, 0xff81,
  0xff7f, 0xff7f, 0xff7f, 0xff5e, 0xff67, 0xff5d, 0xff80, 0xff80,
  0xff7e, 0xff7e, 0xff58, 0xff3c, 0xff3b, 0xff58, 0xff7f, 0xff7f,
  0xff7e, 0xff58, 0xff3c, 0xff3b, 0xff58, 0xff7f, 0xff7f, 0x007f,
  0xff57, 0xff36, 0xff10, 0xff36, 0xff57, 0xff7e, 0x007e, 0x007e,
  0xff35, 0xff0a, 0xff0b, 0xff35, 0xff56, 0x007d, 0x007d, 0x007d,
  0xff09, 0xff05, 0xff0a, 0xff34, 0x0055, 0x007c, 0x007c, 0x0077,
  0xff04, 0xff04, 0xff09, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c,
  0xff03, 0xff03, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a,
  0xff02, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002,
  0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfffa, 0xffd5, 0xffde, 0xffd8, 0xffff, 0xffff, 0xffff,
  0xfff9, 0xffcf, 0xffb3, 0xffb6, 0xffd7, 0xfffe, 0xfffe, 0xfffe,
  0xffce, 0xffad, 0xff8b, 0xffb5, 0xffd6, 0xfffd, 0xfffd, 0xfffd,
  0xffac, 0xff85, 0xff8a, 0xffb4, 0xffd5, 0xfffc, 0xfffc, 0xfffc,
  0xff84, 0xff84, 0xff89, 0xffb3, 0xffd4, 0xfffb, 0xfffb, 0xffd5,
  0xff83, 0xff83, 0xff88, 0xffb2, 0xffd3, 0xfffa, 0xffd4, 0xffb3,
  0xff82, 0xff82, 0xff87, 0xffb1, 0xffd2, 0xffd3, 0xffb2, 0xff87,
  0xff81, 0xff81, 0xff86, 0xffb0, 0xffab, 0xffb1, 0xff86, 0xff82,
  0xff80, 0xff80, 0xff85, 0xff89, 0xff89, 0xff85, 0xff81, 0xff81,
  0xff7f, 0xff7f, 0xff5e, 0xff67, 0xff5d, 0xff80, 0xff80, 0xff80,
  0xff7f, 0xff5e, 0xff67, 0xff5d, 0xff80, 0xff80, 0xff80, 0x0080,
  0xff58, 0xff3c, 0xff3b, 0xff58, 0xff7f, 0xff7f, 0x007f, 0x007f,
  0xff36, 0xff10, 0xff36, 0xff57, 0xff7e, 0x007e, 0x007e, 0x007e,
  0xff0a, 0xff0b, 0xff35, 0xff56, 0x007d, 0x007d, 0x007d, 0x0078,
  0xff05, 0xff0a, 0xff34, 0x0055, 0x007c, 0x007c, 0x0077, 0x004d,
  0xff04, 0xff09, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x002b,
  0xff03, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x0003,
  0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x0002,
  0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0xffd5, 0xffde, 0xffd8, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffcf, 0xffb3, 0xffb6, 0xffd7, 0xfffe, 0xfffe, 0xfffe, 0xfffe,
  0xffad, 0xff8b, 0xffb5, 0xffd6, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xff85, 0xff8a, 0xffb4, 0xffd5, 0xfffc, 0xfffc, 0xfffc, 0xffd6,
  0xff84, 0xff89, 0xffb3, 0xffd4, 0xfffb, 0xfffb, 0xffd5, 0xffb4,
  0xff83, 0xff88, 0xffb2, 0xffd3, 0xfffa, 0xffd4, 0xffb3, 0xff88,
  0xff82, 0xff87, 0xffb1, 0xffd2, 0xffd3, 0xffb2, 0xff87, 0xff83,
  0xff81, 0xff86, 0xffb0, 0xffab, 0xffb1, 0xff86, 0xff82, 0xff82,
  0xff80, 0xff85, 0xff89, 0xff89, 0xff85, 0xff81, 0xff81, 0xff81,
  0xff85, 0xff89, 0xff89, 0xff85, 0xff81, 0xff81, 0xff81, 0x0081,
  0xff5e, 0xff67, 0xff5d, 0xff80, 0xff80, 0xff80, 0x0080, 0x0080,
  0xff3c, 0xff3b, 0xff58, 0xff7f, 0xff7f, 0x007f, 0x007f, 0x007f,
  0xff10, 0xff36, 0xff57, 0xff7e, 0x007e, 0x007e, 0x007e, 0x0079,
  0xff0b, 0xff35, 0xff56, 0x007d, 0x007d, 0x007d, 0x0078, 0x004e,
  0xff0a, 0xff34, 0x0055, 0x007c, 0x007c, 0x0077, 0x004d, 0x002c,
  0xff09, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x002b, 0x0004,
  0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x0003, 0x0003,
  0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x0002, 0x0002,
  0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd5, 0xffde, 0xffd8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffb3, 0xffb6, 0xffd7, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe,
  0xff8b, 0xffb5, 0xffd6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xffd7,
  0xff8a, 0xffb4, 0xffd5, 0xfffc, 0xfffc, 0xfffc, 0xffd6, 0xffb5,
  0xff89, 0xffb3, 0xffd4, 0xfffb, 0xfffb, 0xffd5, 0xffb4, 0xff89,
  0xff88, 0xffb2, 0xffd3, 0xfffa, 0xffd4, 0xffb3, 0xff88, 0xff84,
  0xff87, 0xffb1, 0xffd2, 0xffd3, 0xffb2, 0xff87, 0xff83, 0xff83,
  0xff86, 0xffb0, 0xffab, 0xffb1, 0xff86, 0xff82, 0xff82, 0xff82,
  0xffb0, 0xffab, 0xffb1, 0xff86, 0xff82, 0xff82, 0xff82, 0x0082,
  0xff89, 0xff89, 0xff85, 0xff81, 0xff81, 0xff81, 0x0081, 0x0081,
  0xff67, 0xff5d, 0xff80, 0xff80, 0xff80, 0x0080, 0x0080, 0x0080,
  0xff3b, 0xff58, 0xff7f, 0xff7f, 0x007f, 0x007f, 0x007f, 0x007a,
  0xff36, 0xff57, 0xff7e, 0x007e, 0x007e, 0x007e, 0x0079, 0x004f,
  0xff35, 0xff56, 0x007d, 0x007d, 0x007d, 0x0078, 0x004e, 0x002d,
  0xff34, 0x0055, 0x007c, 0x007c, 0x0077, 0x004d, 0x002c, 0x0005,
  0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x002b, 0x0004, 0x0004,
  0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x0003, 0x0003, 0x0003,
  0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x0002, 0x0002, 0x0002,
  0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffde, 0xffd8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffb6, 0xffd7, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xffd8,
  0xffb5, 0xffd6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xffd7, 0xffb6,
  0xffb4, 0xffd5, 0xfffc, 0xfffc, 0xfffc, 0xffd6, 0xffb5, 0xff8a,
  0xffb3, 0xffd4, 0xfffb, 0xfffb, 0xffd5, 0xffb4, 0xff89, 0xff85,
  0xffb2, 0xffd3, 0xfffa, 0xffd4, 0xffb3, 0xff88, 0xff84, 0xff84,
  0xffb1, 0xffd2, 0xffd3, 0xffb2, 0xff87, 0xff83, 0xff83, 0xff83,
  0xffd2, 0xffd3, 0xffb2, 0xff87, 0xff83, 0xff83, 0xff83, 0x0083,
  0xffab, 0xffb1, 0xff86, 0xff82, 0xff82, 0xff82, 0x0082, 0x0082,
  0xff89, 0xff85, 0xff81, 0xff81, 0xff81, 0x0081, 0x0081, 0x0081,
  0xff5d, 0xff80, 0xff80, 0xff80, 0x0080, 0x0080, 0x0080, 0x007b,
  0xff58, 0xff7f, 0xff7f, 0x007f, 0x007f, 0x007f, 0x007a, 0x0050,
  0xff57, 0xff7e, 0x007e, 0x007e, 0x007e, 0x0079, 0x004f, 0x002e,
  0xff56, 0x007d, 0x007d, 0x007d, 0x0078, 0x004e, 0x002d, 0x0006,
  0x0055, 0x007c, 0x007c, 0x0077, 0x004d, 0x002c, 0x0005, 0x0005,
  0x0054, 0x007b, 0x0076, 0x004c, 0x002b, 0x0004, 0x0004, 0x0004,
  0x0053, 0x0075, 0x004b, 0x002a, 0x0003, 0x0003, 0x0003, 0x0003,
  0x004d, 0x004a, 0x0029, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
  0x0022, 0x0028, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffd9,
  0xffd7, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xffd8, 0xffb7,
  0xffd6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xffd7, 0xffb6, 0xff8b,
  0xffd5, 0xfffc, 0xfffc, 0xfffc, 0xffd6, 0xffb5, 0xff8a, 0xff86,
  0xffd4, 0xfffb, 0xfffb, 0xffd5, 0xffb4, 0xff89, 0xff85, 0xff85,
  0xffd3, 0xfffa, 0xffd4, 0xffb3, 0xff88, 0xff84, 0xff84, 0xff84,
  0xfffa, 0xffd4, 0xffb3, 0xff88, 0xff84, 0xff84, 0xff84, 0x00aa,
  0xffd3, 0xffb2, 0xff87, 0xff83, 0xff83, 0xff83, 0x0083, 0x00a9,
  0xffb1, 0xff86, 0xff82, 0xff82, 0xff82, 0x0082, 0x0082, 0x00a8,
  0xff85, 0xff81, 0xff81, 0xff81, 0x0081, 0x0081, 0x0081, 0x00a2,
  0xff80, 0xff80, 0xff80, 0x0080, 0x0080, 0x0080, 0x007b, 0x0077,
  0xff7f, 0xff7f, 0x007f, 0x007f, 0x007f, 0x007a, 0x0050, 0x0055,
  0xff7e, 0x007e, 0x007e, 0x007e, 0x0079, 0x004f, 0x002e, 0x002d,
  0x007d, 0x007d, 0x007d, 0x0078, 0x004e, 0x002d, 0x0006, 0x002c,
  0x007c, 0x007c, 0x0077, 0x004d, 0x002c, 0x0005, 0x0005, 0x002b,
  0x007b, 0x0076, 0x004c, 0x002b, 0x0004, 0x0004, 0x0004, 0x002a,
  0x0075, 0x004b, 0x002a, 0x0003, 0x0003, 0x0003, 0x0003, 0x0029,
  0x004a, 0x0029, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0028,
  0x0028, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0027,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffd9, 0xffde,
  0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xffb2,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xffad,
  0xfffc, 0xfffc, 0xfffc, 0xffd6, 0xffb5, 0xff8a, 0xff86, 0xffac,
  0xfffb, 0xfffb, 0xffd5, 0xffb4, 0xff89, 0xff85, 0xff85, 0xffab,
  0xfffb, 0xffd5, 0xffb4, 0xff89, 0xff85, 0xff85, 0xffab, 0x00cc,
  0xffd4, 0xffb3, 0xff88, 0xff84, 0xff84, 0xff84, 0x00aa, 0x00cb,
  0xffb2, 0xff87, 0xff83, 0xff83, 0xff83, 0x0083, 0x00a9, 0x00ca,
  0xff86, 0xff82, 0xff82, 0xff82, 0x0082, 0x0082, 0x00a8, 0x00c4,
  0xff81, 0xff81, 0xff81, 0x0081, 0x0081, 0x0081, 0x00a2, 0x0099,
  0xff80, 0xff80, 0x0080, 0x0080, 0x0080, 0x007b, 0x0077, 0x0077,
  0xff7f, 0x007f, 0x007f, 0x007f, 0x007a, 0x0050, 0x0055, 0x004f,
  0x007e, 0x007e, 0x007e, 0x0079, 0x004f, 0x002e, 0x002d, 0x004e,
  0x007d, 0x007d, 0x0078, 0x004e, 0x002d, 0x0006, 0x002c, 0x004d,
  0x007c, 0x0077, 0x004d, 0x002c, 0x0005, 0x0005, 0x002b, 0x004c,
  0x0076, 0x004c, 0x002b, 0x0004, 0x0004, 0x0004, 0x002a, 0x004b,
  0x004b, 0x002a, 0x0003, 0x0003, 0x0003, 0x0003, 0x0029, 0x004a,
  0x0029, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0028, 0x0049,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffd9, 0xffde, 0xffd4,
  0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xffb2, 0xffcf,
  0xfffd, 0xfffd, 0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xffad, 0xffce,
  0xfffc, 0xfffc, 0xffd6, 0xffb5, 0xff8a, 0xff86, 0xffac, 0xffcd,
  0xfffc, 0xffd6, 0xffb5, 0xff8a, 0xff86, 0xffac, 0xffcd, 0x00f8,
  0xffd5, 0xffb4, 0xff89, 0xff85, 0xff85, 0xffab, 0x00cc, 0x00f7,
  0xffb3, 0xff88, 0xff84, 0xff84, 0xff84, 0x00aa, 0x00cb, 0x00f6,
  0xff87, 0xff83, 0xff83, 0xff83, 0x0083, 0x00a9, 0x00ca, 0x00f0,
  0xff82, 0xff82, 0xff82, 0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5,
  0xff81, 0xff81, 0x0081, 0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3,
  0xff80, 0x0080, 0x0080, 0x0080, 0x007b, 0x0077, 0x0077, 0x007b,
  0x007f, 0x007f, 0x007f, 0x007a, 0x0050, 0x0055, 0x004f, 0x007a,
  0x007e, 0x007e, 0x0079, 0x004f, 0x002e, 0x002d, 0x004e, 0x0079,
  0x007d, 0x0078, 0x004e, 0x002d, 0x0006, 0x002c, 0x004d, 0x0078,
  0x0077, 0x004d, 0x002c, 0x0005, 0x0005, 0x002b, 0x004c, 0x0077,
  0x004c, 0x002b, 0x0004, 0x0004, 0x0004, 0x002a, 0x004b, 0x0076,
  0x002a, 0x0003, 0x0003, 0x0003, 0x0003, 0x0029, 0x004a, 0x0075,
  0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffd9, 0xffde, 0xffd4, 0xfffb,
  0xfffe, 0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xffb2, 0xffcf, 0xfffa,
  0xfffd, 0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xffad, 0xffce, 0xfff9,
  0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xffad, 0xffce, 0xfff9, 0x00fd,
  0xffd6, 0xffb5, 0xff8a, 0xff86, 0xffac, 0xffcd, 0x00f8, 0x00fc,
  0xffb4, 0xff89, 0xff85, 0xff85, 0xffab, 0x00cc, 0x00f7, 0x00fb,
  0xff88, 0xff84, 0xff84, 0xff84, 0x00aa, 0x00cb, 0x00f6, 0x00f5,
  0xff83, 0xff83, 0xff83, 0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca,
  0xff82, 0xff82, 0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8,
  0xff81, 0x0081, 0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080,
  0x0080, 0x0080, 0x0080, 0x007b, 0x0077, 0x0077, 0x007b, 0x007f,
  0x007f, 0x007f, 0x007a, 0x0050, 0x0055, 0x004f, 0x007a, 0x007e,
  0x007e, 0x0079, 0x004f, 0x002e, 0x002d, 0x004e, 0x0079, 0x007d,
  0x0078, 0x004e, 0x002d, 0x0006, 0x002c, 0x004d, 0x0078, 0x007c,
  0x004d, 0x002c, 0x0005, 0x0005, 0x002b, 0x004c, 0x0077, 0x007b,
  0x002b, 0x0004, 0x0004, 0x0004, 0x002a, 0x004b, 0x0076, 0x007a,
  0x0003, 0x0003, 0x0003, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053,
  0x0002, 0x0002, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffd9, 0xffde, 0xffd4, 0xfffb, 0xffff,
  0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xffb2, 0xffcf, 0xfffa, 0xfffe,
  0xfffe, 0xffd8, 0xffb7, 0xffb2, 0xffcf, 0xfffa, 0xfffe, 0x00fe,
  0xffd7, 0xffb6, 0xff8b, 0xffad, 0xffce, 0xfff9, 0x00fd, 0x00fd,
  0xffb5, 0xff8a, 0xff86, 0xffac, 0xffcd, 0x00f8, 0x00fc, 0x00fc,
  0xff89, 0xff85, 0xff85, 0xffab, 0x00cc, 0x00f7, 0x00fb, 0x00f6,
  0xff84, 0xff84, 0xff84, 0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb,
  0xff83, 0xff83, 0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9,
  0xff82, 0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081,
  0x0081, 0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080,
  0x0080, 0x0080, 0x007b, 0x0077, 0x0077, 0x007b, 0x007f, 0x007f,
  0x007f, 0x007a, 0x0050, 0x0055, 0x004f, 0x007a, 0x007e, 0x007e,
  0x0079, 0x004f, 0x002e, 0x002d, 0x004e, 0x0079, 0x007d, 0x007d,
  0x004e, 0x002d, 0x0006, 0x002c, 0x004d, 0x0078, 0x007c, 0x007c,
  0x002c, 0x0005, 0x0005, 0x002b, 0x004c, 0x0077, 0x007b, 0x007b,
  0x0004, 0x0004, 0x0004, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054,
  0x0003, 0x0003, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032,
  0x0002, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006,
  0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffd9, 0xffde, 0xffd4, 0xfffb, 0xffff, 0xffff,
  0xffff, 0xffd9, 0xffde, 0xffd4, 0xfffb, 0xffff, 0xffff, 0x00ff,
  0xffd8, 0xffb7, 0xffb2, 0xffcf, 0xfffa, 0xfffe, 0x00fe, 0x00fe,
  0xffb6, 0xff8b, 0xffad, 0xffce, 0xfff9, 0x00fd, 0x00fd, 0x00fd,
  0xff8a, 0xff86, 0xffac, 0xffcd, 0x00f8, 0x00fc, 0x00fc, 0x00f7,
  0xff85, 0xff85, 0xffab, 0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc,
  0xff84, 0xff84, 0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa,
  0xff83, 0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082,
  0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081,
  0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080, 0x0080,
  0x0080, 0x007b, 0x0077, 0x0077, 0x007b, 0x007f, 0x007f, 0x007f,
  0x007a, 0x0050, 0x0055, 0x004f, 0x007a, 0x007e, 0x007e, 0x007e,
  0x004f, 0x002e, 0x002d, 0x004e, 0x0079, 0x007d, 0x007d, 0x007d,
  0x002d, 0x0006, 0x002c, 0x004d, 0x0078, 0x007c, 0x007c, 0x007c,
  0x0005, 0x0005, 0x002b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055,
  0x0004, 0x0004, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033,
  0x0003, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007,
  0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002,
  0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_usubl2_8H = 361;

#endif  // VIXL_SIM_USUBL2_8H_TRACE_AARCH64_H_
