/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.InstructionUsageMarker;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.ParameterUsageMarker;

public class EvaluationShrinker
extends SimplifiedVisitor
implements AttributeVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_RESULTS = false;
    private static final int UNSUPPORTED = -1;
    private static final int NOP = 0;
    private static final int POP = 87;
    private static final int POP2 = 88;
    private static final int DUP = 89;
    private static final int DUP_X1 = 90;
    private static final int DUP_X2 = 91;
    private static final int DUP2 = 92;
    private static final int DUP2_X1 = 93;
    private static final int DUP2_X2 = 94;
    private static final int SWAP = 95;
    private static final int MOV_X2 = 22363;
    private static final int MOV2_X1 = 22621;
    private static final int MOV2_X2 = 22622;
    private static final int POP_X1 = 22367;
    private static final int POP_X2 = 5724253;
    private static final int POP_X3 = -1;
    private static final int POP2_X1 = 5789531;
    private static final int POP2_X2 = 0x58585E;
    private static final int POP3 = 22360;
    private static final int POP4 = 22616;
    private static final int POP_DUP = 22871;
    private static final int POP_SWAP_POP = 0x575F57;
    private static final int POP2_SWAP_POP = 5726040;
    private static final int SWAP_DUP_X1 = 23135;
    private static final int SWAP_DUP_X1_SWAP = 0x5F5A5F;
    private static final int SWAP_POP_DUP = 5855071;
    private static final int SWAP_POP_DUP_X1 = 5920607;
    private static final int DUP_X2_POP2 = 22619;
    private static final int DUP2_X1_POP3 = 5724253;
    private static final int DUP2_X2_POP3 = 5724254;
    private static final int DUP2_X2_SWAP_POP = 5726046;
    private final InstructionUsageMarker instructionUsageMarker;
    private final boolean runInstructionUsageMarker;
    private final InstructionVisitor extraDeletedInstructionVisitor;
    private final InstructionVisitor extraAddedInstructionVisitor;
    private final MyStaticInvocationFixer staticInvocationFixer = new MyStaticInvocationFixer();
    private final MyBackwardBranchFixer backwardBranchFixer = new MyBackwardBranchFixer();
    private final MyNonReturningSubroutineFixer nonReturningSubroutineFixer = new MyNonReturningSubroutineFixer();
    private final MyStackConsistencyFixer stackConsistencyFixer = new MyStackConsistencyFixer();
    private final MyInstructionDeleter instructionDeleter = new MyInstructionDeleter();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false, true);

    public EvaluationShrinker() {
        this(new PartialEvaluator(), true, null, null);
    }

    public EvaluationShrinker(PartialEvaluator partialEvaluator, boolean bl, InstructionVisitor instructionVisitor, InstructionVisitor instructionVisitor2) {
        this(new InstructionUsageMarker(partialEvaluator, bl), true, instructionVisitor, instructionVisitor2);
    }

    public EvaluationShrinker(InstructionUsageMarker instructionUsageMarker, boolean bl, InstructionVisitor instructionVisitor, InstructionVisitor instructionVisitor2) {
        this.instructionUsageMarker = instructionUsageMarker;
        this.runInstructionUsageMarker = bl;
        this.extraDeletedInstructionVisitor = instructionVisitor;
        this.extraAddedInstructionVisitor = instructionVisitor2;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while shrinking instructions after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            runtimeException.printStackTrace();
            System.err.println("Not optimizing this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.runInstructionUsageMarker) {
            this.instructionUsageMarker.visitCodeAttribute(clazz, method, codeAttribute);
        }
        int n = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(n);
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.necessaryInstructionFilter(true, this.staticInvocationFixer));
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.tracedInstructionFilter(true, this.instructionUsageMarker.necessaryInstructionFilter(false, this.backwardBranchFixer)));
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.necessaryInstructionFilter(true, this.nonReturningSubroutineFixer));
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.tracedInstructionFilter(true, this.stackConsistencyFixer));
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.necessaryInstructionFilter(false, this.instructionDeleter));
        codeAttribute.exceptionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        if (!this.instructionUsageMarker.isTraced(exceptionInfo.u2handlerPC)) {
            exceptionInfo.u2endPC = exceptionInfo.u2startPC;
        }
    }

    private boolean isAnyUnnecessaryInstructionBranchingOver(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.instructionUsageMarker.isTraced(i) || this.instructionUsageMarker.isInstructionNecessary(i) || !this.isAnyLargerThan(this.instructionUsageMarker.branchTargets(i), n2)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyLargerThan(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2;
        if (instructionOffsetValue != null && (n2 = instructionOffsetValue.instructionOffsetCount()) > 0) {
            for (int i = 0; i < n2; ++i) {
                if (instructionOffsetValue.instructionOffset(i) <= n) continue;
                return true;
            }
        }
        return false;
    }

    private void insertPushInstructions(int n, boolean bl, boolean bl2, int n2) {
        SimpleInstruction simpleInstruction = new SimpleInstruction(this.pushOpcode(n2));
        this.insertInstruction(n, bl, bl2, simpleInstruction);
    }

    private byte pushOpcode(int n) {
        switch (n) {
            case 1: {
                return 3;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 14;
            }
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalArgumentException("No push opcode for computational type [" + n + "]");
    }

    private void insertPopInstructions(int n, boolean bl, boolean bl2, int n2) {
        switch (n2) {
            case 1: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(87);
                this.insertInstruction(n, bl, bl2, simpleInstruction);
                break;
            }
            case 2: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                this.insertInstruction(n, bl, bl2, simpleInstruction);
                break;
            }
            default: {
                Instruction[] instructionArray = new Instruction[n2 / 2 + n2 % 2];
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                for (int i = 0; i < n2 / 2; ++i) {
                    instructionArray[i] = simpleInstruction;
                }
                if (n2 % 2 == 1) {
                    simpleInstruction = new SimpleInstruction(87);
                    instructionArray[n2 / 2] = simpleInstruction;
                }
                this.insertInstructions(n, bl, bl2, simpleInstruction, instructionArray);
                break;
            }
        }
    }

    private void insertInstruction(int n, boolean bl, boolean bl2, Instruction instruction) {
        if (bl) {
            this.codeAttributeEditor.replaceInstruction(n, instruction);
            if (this.extraAddedInstructionVisitor != null && !this.instructionUsageMarker.isInstructionNecessary(n)) {
                instruction.accept(null, null, null, n, this.extraAddedInstructionVisitor);
            }
        } else {
            if (bl2) {
                this.codeAttributeEditor.insertBeforeInstruction(n, instruction);
            } else {
                this.codeAttributeEditor.insertAfterInstruction(n, instruction);
            }
            if (this.extraAddedInstructionVisitor != null) {
                instruction.accept(null, null, null, n, this.extraAddedInstructionVisitor);
            }
        }
    }

    private void insertInstructions(int n, boolean bl, boolean bl2, Instruction instruction, Instruction[] instructionArray) {
        block6: {
            block5: {
                if (!bl) break block5;
                this.codeAttributeEditor.replaceInstruction(n, instructionArray);
                if (this.extraAddedInstructionVisitor == null) break block6;
                if (!this.instructionUsageMarker.isInstructionNecessary(n)) {
                    instruction.accept(null, null, null, n, this.extraAddedInstructionVisitor);
                }
                for (int i = 1; i < instructionArray.length; ++i) {
                    instructionArray[i].accept(null, null, null, n, this.extraAddedInstructionVisitor);
                }
                break block6;
            }
            if (bl2) {
                this.codeAttributeEditor.insertBeforeInstruction(n, instructionArray);
            } else {
                this.codeAttributeEditor.insertAfterInstruction(n, instructionArray);
            }
            for (int i = 0; i < instructionArray.length; ++i) {
                if (this.extraAddedInstructionVisitor == null) continue;
                instructionArray[i].accept(null, null, null, n, this.extraAddedInstructionVisitor);
            }
        }
    }

    private void replaceByStaticInvocation(Clazz clazz, int n, ConstantInstruction constantInstruction) {
        ConstantInstruction constantInstruction2 = new ConstantInstruction(-72, constantInstruction.constantIndex);
        this.codeAttributeEditor.replaceInstruction(n, constantInstruction2);
    }

    private void replaceByInfiniteLoop(Clazz clazz, int n) {
        BranchInstruction branchInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(n, branchInstruction);
    }

    private class MyInstructionDeleter
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyInstructionDeleter() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            EvaluationShrinker.this.codeAttributeEditor.deleteInstruction(n);
            if (EvaluationShrinker.this.extraDeletedInstructionVisitor != null) {
                instruction.accept(clazz, method, codeAttribute, n, EvaluationShrinker.this.extraDeletedInstructionVisitor);
            }
        }
    }

    private class MyStackConsistencyFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyStackConsistencyFixer() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(n)) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6 = instruction.stackPopCount(clazz);
                if (n6 > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackBefore(n);
                    int n7 = tracedStack.size();
                    n5 = 0;
                    n4 = 0;
                    for (n3 = n7 - n6; n3 < n7; ++n3) {
                        boolean bl = EvaluationShrinker.this.instructionUsageMarker.isStackEntryUnwantedBefore(n, n3);
                        boolean bl2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n3);
                        if (bl) {
                            if (!bl2) continue;
                            ++n5;
                            continue;
                        }
                        if (bl2) continue;
                        ++n4;
                    }
                    if (n5 > 0) {
                        EvaluationShrinker.this.insertPopInstructions(n, false, true, n6);
                    }
                    if (n4 > 0) {
                        Value value = tracedStack.getTop(0);
                        if (n4 > (value.isCategory2() ? 2 : 1)) {
                            throw new IllegalArgumentException("Unsupported stack size increment [" + n4 + "] at [" + n + "]");
                        }
                        EvaluationShrinker.this.insertPushInstructions(n, false, true, value.computationalType());
                    }
                }
                if ((n2 = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackAfter(n);
                    n5 = tracedStack.size();
                    n4 = 0;
                    for (n3 = n5 - n2; n3 < n5; ++n3) {
                        if (EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3)) continue;
                        ++n4;
                    }
                    if (n4 > 0) {
                        EvaluationShrinker.this.insertPopInstructions(n, false, false, n4);
                    }
                }
            } else if (EvaluationShrinker.this.instructionUsageMarker.isExtraPushPopInstructionNecessary(n)) {
                int n8;
                int n9;
                int n10;
                int n11 = instruction.stackPopCount(clazz);
                if (n11 > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackBefore(n);
                    int n12 = tracedStack.size();
                    n10 = 0;
                    for (n9 = n12 - n11; n9 < n12; ++n9) {
                        if (!EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n9)) continue;
                        ++n10;
                    }
                    if (n10 > 0) {
                        EvaluationShrinker.this.insertPopInstructions(n, true, false, n10);
                    }
                }
                if ((n8 = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackAfter(n);
                    n10 = tracedStack.size();
                    n9 = 0;
                    for (int i = n10 - n8; i < n10; ++i) {
                        if (!EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, i)) continue;
                        ++n9;
                    }
                    if (n9 > 0) {
                        EvaluationShrinker.this.insertPushInstructions(n, true, false, tracedStack.getTop(0).computationalType());
                    }
                }
            }
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(n) && this.isDupOrSwap(simpleInstruction)) {
                int n2;
                byte by = simpleInstruction.opcode;
                int n3 = EvaluationShrinker.this.instructionUsageMarker.getStackBefore(n).size() - 1;
                int n4 = this.fixDupSwap(n, by, n3, n2 = EvaluationShrinker.this.instructionUsageMarker.getStackAfter(n).size() - 1);
                if (n4 == -1) {
                    throw new UnsupportedOperationException("Can't handle " + simpleInstruction.toString() + " instruction at [" + n + "]");
                }
                if ((n4 & 0xFFFFFF00) == 0) {
                    byte by2 = (byte)n4;
                    if (by2 == 0) {
                        EvaluationShrinker.this.codeAttributeEditor.deleteInstruction(n);
                        if (EvaluationShrinker.this.extraDeletedInstructionVisitor != null) {
                            EvaluationShrinker.this.extraDeletedInstructionVisitor.visitSimpleInstruction(null, null, null, n, null);
                        }
                    } else if (by2 == by) {
                        EvaluationShrinker.this.codeAttributeEditor.undeleteInstruction(n);
                    } else {
                        SimpleInstruction simpleInstruction2 = new SimpleInstruction(by2);
                        EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(n, simpleInstruction2);
                    }
                } else {
                    Instruction[] instructionArray;
                    Instruction[] instructionArray2 = new Instruction[4];
                    int n5 = 0;
                    while (n4 != 0) {
                        instructionArray = new SimpleInstruction((byte)n4);
                        instructionArray2[n5++] = instructionArray;
                        n4 >>>= 8;
                    }
                    if (n5 < 4) {
                        instructionArray = new Instruction[n5];
                        System.arraycopy(instructionArray2, 0, instructionArray, 0, n5);
                        instructionArray2 = instructionArray;
                    }
                    EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(n, instructionArray2);
                }
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, n, simpleInstruction);
            }
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(n)) {
                if (branchInstruction.stackPopCount(clazz) > 0 && !EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, EvaluationShrinker.this.instructionUsageMarker.getStackBefore(n).size() - 1)) {
                    BranchInstruction branchInstruction2 = new BranchInstruction(-89, branchInstruction.branchOffset);
                    EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(n, branchInstruction2);
                }
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, n, branchInstruction);
            }
        }

        @Override
        public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(n)) {
                if (switchInstruction.stackPopCount(clazz) > 0 && !EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, EvaluationShrinker.this.instructionUsageMarker.getStackBefore(n).size() - 1)) {
                    BranchInstruction branchInstruction = new BranchInstruction(-89, switchInstruction.defaultOffset);
                    EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(n, branchInstruction);
                }
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, n, switchInstruction);
            }
        }

        private boolean isDupOrSwap(Instruction instruction) {
            return instruction.opcode >= 89 && instruction.opcode <= 95;
        }

        private int fixDupSwap(int n, byte by, int n2, int n3) {
            switch (by) {
                case 89: {
                    return this.fixedDup(n, n2, n3);
                }
                case 90: {
                    return this.fixedDup_x1(n, n2, n3);
                }
                case 91: {
                    return this.fixedDup_x2(n, n2, n3);
                }
                case 92: {
                    return this.fixedDup2(n, n2, n3);
                }
                case 93: {
                    return this.fixedDup2_x1(n, n2, n3);
                }
                case 94: {
                    return this.fixedDup2_x2(n, n2, n3);
                }
                case 95: {
                    return this.fixedSwap(n, n2, n3);
                }
            }
            throw new IllegalArgumentException("Not a dup/swap opcode [" + by + "]");
        }

        private int fixedDup(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2);
            boolean bl2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3);
            boolean bl3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 1);
            return bl2 ? (bl3 ? 89 : 0) : (bl3 ? 0 : (bl ? 87 : 0));
        }

        private int fixedDup_x1(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2);
            boolean bl2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2 - 1);
            boolean bl3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3);
            boolean bl4 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 1);
            boolean bl5 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 2);
            return bl4 ? (bl5 ? (bl3 ? 90 : 95) : (bl3 ? 0 : (bl ? 87 : 0))) : (bl2 ? (bl5 ? (bl3 ? 5855071 : 22367) : (bl3 ? 22367 : (bl ? 88 : 87))) : (bl5 ? (bl3 ? 89 : 0) : (bl3 ? 0 : (bl ? 87 : 0))));
        }

        private int fixedDup_x2(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2);
            boolean bl2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2 - 1);
            boolean bl3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2 - 2);
            boolean bl4 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3);
            boolean bl5 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 1);
            boolean bl6 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 2);
            boolean bl7 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 3);
            return bl5 ? (bl6 ? (bl7 ? (bl4 ? 91 : 22363) : (bl4 ? 0 : (bl ? 87 : 0))) : (bl3 ? (bl7 ? -1 : (bl4 ? 5724253 : (bl ? 0x575F57 : 22367))) : (bl7 ? (bl4 ? 90 : 95) : (bl4 ? 0 : (bl ? 87 : 0))))) : (bl2 ? (bl6 ? (bl7 ? (bl4 ? 5920607 : 22619) : (bl4 ? 22367 : (bl ? 88 : 87))) : (bl3 ? (bl7 ? (bl4 ? -1 : 5789531) : (bl4 ? 5789531 : (bl ? 22360 : 88))) : (bl7 ? (bl4 ? 5855071 : 22367) : (bl4 ? 22367 : (bl ? 88 : 87))))) : (bl6 ? (bl7 ? (bl4 ? 90 : 95) : (bl4 ? 0 : (bl ? 87 : 0))) : (bl3 ? (bl7 ? (bl4 ? 5855071 : 22367) : (bl4 ? 22367 : (bl ? 88 : 87))) : (bl7 ? (bl4 ? 89 : 0) : (bl4 ? 0 : (bl ? 87 : 0))))));
        }

        private int fixedDup2(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2);
            boolean bl2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2 - 1);
            boolean bl3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3);
            boolean bl4 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 1);
            boolean bl5 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 2);
            boolean bl6 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 3);
            return bl6 ? (bl5 ? (bl4 ? (bl3 ? 92 : 23135) : (bl3 ? 89 : 0)) : (bl4 ? (bl3 ? 0x5F5A5F : (bl ? 22871 : 89)) : (bl3 ? 0 : (bl ? 87 : 0)))) : (bl5 ? (bl4 ? (bl3 ? 90 : 95) : (bl2 ? (bl3 ? 5855071 : 22367) : (bl3 ? 87 : 0))) : (bl4 ? (bl3 ? 0 : (bl ? 87 : 0)) : (bl2 ? (bl3 ? 22367 : (bl ? 88 : 87)) : (bl3 ? 0 : (bl ? 87 : 0)))));
        }

        private int fixedDup2_x1(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesPresentBefore(n, n2, n2 - 1);
            boolean bl2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2 - 2);
            boolean bl3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesNecessaryAfter(n, n3, n3 - 1);
            boolean bl4 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 2);
            boolean bl5 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesNecessaryAfter(n, n3 - 3, n3 - 4);
            return bl4 ? (bl5 ? (bl3 ? 93 : 22621) : (bl3 ? 0 : (bl ? 88 : 0))) : (bl2 ? (bl5 ? (bl3 ? -1 : 5724253) : (bl3 ? 5724253 : (bl ? 22360 : 87))) : (bl5 ? (bl3 ? 92 : 0) : (bl3 ? 0 : (bl ? 88 : 0))));
        }

        private int fixedDup2_x2(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesPresentBefore(n, n2, n2 - 1);
            boolean bl2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2 - 2);
            boolean bl3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2 - 3);
            boolean bl4 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesNecessaryAfter(n, n3, n3 - 1);
            boolean bl5 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 2);
            boolean bl6 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 3);
            boolean bl7 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesNecessaryAfter(n, n3 - 4, n3 - 5);
            return bl5 ? (bl6 ? (bl7 ? (bl4 ? 94 : 22622) : (bl4 ? 0 : (bl ? 88 : 0))) : (bl3 ? (bl7 ? (bl4 ? -1 : 5726046) : (bl4 ? -1 : (bl ? 5726040 : 22367))) : (bl7 ? (bl4 ? 93 : 22621) : (bl4 ? 0 : (bl ? 88 : 0))))) : (bl2 ? (bl6 ? (bl7 ? (bl4 ? -1 : 5724254) : (bl4 ? 5724253 : (bl ? 22360 : 87))) : (bl3 ? (bl7 ? (bl4 ? -1 : 0x58585E) : (bl4 ? 0x58585E : (bl ? 22616 : 88))) : (bl7 ? (bl4 ? -1 : 5724253) : (bl4 ? 5724253 : (bl ? 22360 : 87))))) : (bl6 ? (bl7 ? (bl4 ? 93 : 22621) : (bl4 ? 0 : (bl ? 88 : 0))) : (bl3 ? (bl7 ? (bl4 ? -1 : 5724253) : (bl4 ? 5724253 : (bl ? 22360 : 87))) : (bl7 ? (bl4 ? 92 : 0) : (bl4 ? 0 : (bl ? 88 : 0))))));
        }

        private int fixedSwap(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2);
            boolean bl2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(n, n2 - 1);
            boolean bl3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3);
            boolean bl4 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(n, n3 - 1);
            return bl3 ? (bl4 ? 95 : (bl ? 87 : 0)) : (bl2 ? 22367 : 0);
        }
    }

    private class MyNonReturningSubroutineFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyNonReturningSubroutineFixer() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            if (branchInstruction.canonicalOpcode() == -88) {
                int n2 = n + branchInstruction.length(n);
                if (!EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(n2)) {
                    EvaluationShrinker.this.replaceByInfiniteLoop(clazz, n2);
                }
            }
        }
    }

    private class MyBackwardBranchFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyBackwardBranchFixer() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            if (this.isAllSmallerThanOrEqual(EvaluationShrinker.this.instructionUsageMarker.branchTargets(n), n) && !EvaluationShrinker.this.isAnyUnnecessaryInstructionBranchingOver(this.lastNecessaryInstructionOffset(n), n)) {
                EvaluationShrinker.this.replaceByInfiniteLoop(clazz, n);
            }
        }

        private boolean isAllSmallerThanOrEqual(InstructionOffsetValue instructionOffsetValue, int n) {
            int n2;
            if (instructionOffsetValue != null && (n2 = instructionOffsetValue.instructionOffsetCount()) > 0) {
                for (int i = 0; i < n2; ++i) {
                    if (instructionOffsetValue.instructionOffset(i) <= n) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private int lastNecessaryInstructionOffset(int n) {
            for (int i = n - 1; i >= 0; --i) {
                if (!EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(n)) continue;
                return i;
            }
            return 0;
        }
    }

    private class MyStaticInvocationFixer
    extends SimplifiedVisitor
    implements InstructionVisitor,
    ConstantVisitor,
    MemberVisitor {
        private int invocationOffset;
        private ConstantInstruction invocationInstruction;

        private MyStaticInvocationFixer() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -74: 
                case -73: 
                case -71: {
                    this.invocationOffset = n;
                    this.invocationInstruction = constantInstruction;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                }
            }
        }

        @Override
        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            refConstant.referencedMemberAccept(this);
        }

        @Override
        public void visitAnyMember(Clazz clazz, Member member) {
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            if ((programMethod.getAccessFlags() & 8) == 0 && !ParameterUsageMarker.isParameterUsed(programMethod, 0)) {
                EvaluationShrinker.this.replaceByStaticInvocation(programClass, this.invocationOffset, this.invocationInstruction);
            }
        }
    }
}

