; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefixes=ALL,X32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefixes=ALL,X64

; The mask is all-ones, potentially shifted.

;------------------------------------------------------------------------------;
; 8-bit
;------------------------------------------------------------------------------;

; lshr

define i8 @test_i8_7_mask_lshr_1(i8 %a0) {
; X32-LABEL: test_i8_7_mask_lshr_1:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $6, %al
; X32-NEXT:    shrb %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_7_mask_lshr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $6, %al
; X64-NEXT:    shrb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 7
  %t1 = lshr i8 %t0, 1
  ret i8 %t1
}

define i8 @test_i8_28_mask_lshr_1(i8 %a0) {
; X32-LABEL: test_i8_28_mask_lshr_1:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $28, %al
; X32-NEXT:    shrb %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_lshr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $28, %al
; X64-NEXT:    shrb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = lshr i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_28_mask_lshr_2(i8 %a0) {
; X32-LABEL: test_i8_28_mask_lshr_2:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $28, %al
; X32-NEXT:    shrb $2, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_lshr_2:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $28, %al
; X64-NEXT:    shrb $2, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = lshr i8 %t0, 2
  ret i8 %t1
}
define i8 @test_i8_28_mask_lshr_3(i8 %a0) {
; X32-LABEL: test_i8_28_mask_lshr_3:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $24, %al
; X32-NEXT:    shrb $3, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_lshr_3:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $24, %al
; X64-NEXT:    shrb $3, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = lshr i8 %t0, 3
  ret i8 %t1
}
define i8 @test_i8_28_mask_lshr_4(i8 %a0) {
; X32-LABEL: test_i8_28_mask_lshr_4:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $16, %al
; X32-NEXT:    shrb $4, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_lshr_4:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $16, %al
; X64-NEXT:    shrb $4, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = lshr i8 %t0, 4
  ret i8 %t1
}

define i8 @test_i8_224_mask_lshr_1(i8 %a0) {
; X32-LABEL: test_i8_224_mask_lshr_1:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $-32, %al
; X32-NEXT:    shrb %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_224_mask_lshr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $-32, %al
; X64-NEXT:    shrb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 224
  %t1 = lshr i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_224_mask_lshr_4(i8 %a0) {
; X32-LABEL: test_i8_224_mask_lshr_4:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $-32, %al
; X32-NEXT:    shrb $4, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_224_mask_lshr_4:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $-32, %al
; X64-NEXT:    shrb $4, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 224
  %t1 = lshr i8 %t0, 4
  ret i8 %t1
}
define i8 @test_i8_224_mask_lshr_5(i8 %a0) {
; X32-LABEL: test_i8_224_mask_lshr_5:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    shrb $5, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_224_mask_lshr_5:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrb $5, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 224
  %t1 = lshr i8 %t0, 5
  ret i8 %t1
}
define i8 @test_i8_224_mask_lshr_6(i8 %a0) {
; X32-LABEL: test_i8_224_mask_lshr_6:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    shrb $6, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_224_mask_lshr_6:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrb $6, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 224
  %t1 = lshr i8 %t0, 6
  ret i8 %t1
}

; ashr

define i8 @test_i8_7_mask_ashr_1(i8 %a0) {
; X32-LABEL: test_i8_7_mask_ashr_1:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $6, %al
; X32-NEXT:    shrb %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_7_mask_ashr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $6, %al
; X64-NEXT:    shrb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 7
  %t1 = ashr i8 %t0, 1
  ret i8 %t1
}

define i8 @test_i8_28_mask_ashr_1(i8 %a0) {
; X32-LABEL: test_i8_28_mask_ashr_1:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $28, %al
; X32-NEXT:    shrb %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_ashr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $28, %al
; X64-NEXT:    shrb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = ashr i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_28_mask_ashr_2(i8 %a0) {
; X32-LABEL: test_i8_28_mask_ashr_2:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $28, %al
; X32-NEXT:    shrb $2, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_ashr_2:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $28, %al
; X64-NEXT:    shrb $2, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = ashr i8 %t0, 2
  ret i8 %t1
}
define i8 @test_i8_28_mask_ashr_3(i8 %a0) {
; X32-LABEL: test_i8_28_mask_ashr_3:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $24, %al
; X32-NEXT:    shrb $3, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_ashr_3:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $24, %al
; X64-NEXT:    shrb $3, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = ashr i8 %t0, 3
  ret i8 %t1
}
define i8 @test_i8_28_mask_ashr_4(i8 %a0) {
; X32-LABEL: test_i8_28_mask_ashr_4:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $16, %al
; X32-NEXT:    shrb $4, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_ashr_4:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $16, %al
; X64-NEXT:    shrb $4, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = ashr i8 %t0, 4
  ret i8 %t1
}

define i8 @test_i8_224_mask_ashr_1(i8 %a0) {
; X32-LABEL: test_i8_224_mask_ashr_1:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $-32, %al
; X32-NEXT:    sarb %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_224_mask_ashr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $-32, %al
; X64-NEXT:    sarb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 224
  %t1 = ashr i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_224_mask_ashr_4(i8 %a0) {
; X32-LABEL: test_i8_224_mask_ashr_4:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $-32, %al
; X32-NEXT:    sarb $4, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_224_mask_ashr_4:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $-32, %al
; X64-NEXT:    sarb $4, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 224
  %t1 = ashr i8 %t0, 4
  ret i8 %t1
}
define i8 @test_i8_224_mask_ashr_5(i8 %a0) {
; X32-LABEL: test_i8_224_mask_ashr_5:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    sarb $5, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_224_mask_ashr_5:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarb $5, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 224
  %t1 = ashr i8 %t0, 5
  ret i8 %t1
}
define i8 @test_i8_224_mask_ashr_6(i8 %a0) {
; X32-LABEL: test_i8_224_mask_ashr_6:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    sarb $6, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_224_mask_ashr_6:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarb $6, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 224
  %t1 = ashr i8 %t0, 6
  ret i8 %t1
}

; shl

define i8 @test_i8_7_mask_shl_1(i8 %a0) {
; X32-LABEL: test_i8_7_mask_shl_1:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $7, %al
; X32-NEXT:    addb %al, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_7_mask_shl_1:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    andb $7, %dil
; X64-NEXT:    leal (%rdi,%rdi), %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 7
  %t1 = shl i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_7_mask_shl_4(i8 %a0) {
; X32-LABEL: test_i8_7_mask_shl_4:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $7, %al
; X32-NEXT:    shlb $4, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_7_mask_shl_4:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $7, %al
; X64-NEXT:    shlb $4, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 7
  %t1 = shl i8 %t0, 4
  ret i8 %t1
}
define i8 @test_i8_7_mask_shl_5(i8 %a0) {
; X32-LABEL: test_i8_7_mask_shl_5:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    shlb $5, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_7_mask_shl_5:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shlb $5, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 7
  %t1 = shl i8 %t0, 5
  ret i8 %t1
}
define i8 @test_i8_7_mask_shl_6(i8 %a0) {
; X32-LABEL: test_i8_7_mask_shl_6:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    shlb $6, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_7_mask_shl_6:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shlb $6, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 7
  %t1 = shl i8 %t0, 6
  ret i8 %t1
}

define i8 @test_i8_28_mask_shl_1(i8 %a0) {
; X32-LABEL: test_i8_28_mask_shl_1:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $28, %al
; X32-NEXT:    addb %al, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_shl_1:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    andb $28, %dil
; X64-NEXT:    leal (%rdi,%rdi), %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = shl i8 %t0, 1
  ret i8 %t1
}
define i8 @test_i8_28_mask_shl_2(i8 %a0) {
; X32-LABEL: test_i8_28_mask_shl_2:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $28, %al
; X32-NEXT:    shlb $2, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_shl_2:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    andb $28, %dil
; X64-NEXT:    leal (,%rdi,4), %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = shl i8 %t0, 2
  ret i8 %t1
}
define i8 @test_i8_28_mask_shl_3(i8 %a0) {
; X32-LABEL: test_i8_28_mask_shl_3:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $28, %al
; X32-NEXT:    shlb $3, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_shl_3:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    andb $28, %dil
; X64-NEXT:    leal (,%rdi,8), %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = shl i8 %t0, 3
  ret i8 %t1
}
define i8 @test_i8_28_mask_shl_4(i8 %a0) {
; X32-LABEL: test_i8_28_mask_shl_4:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $12, %al
; X32-NEXT:    shlb $4, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_28_mask_shl_4:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $12, %al
; X64-NEXT:    shlb $4, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 28
  %t1 = shl i8 %t0, 4
  ret i8 %t1
}

define i8 @test_i8_224_mask_shl_1(i8 %a0) {
; X32-LABEL: test_i8_224_mask_shl_1:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    andb $96, %al
; X32-NEXT:    addb %al, %al
; X32-NEXT:    retl
;
; X64-LABEL: test_i8_224_mask_shl_1:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    andb $96, %dil
; X64-NEXT:    leal (%rdi,%rdi), %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = and i8 %a0, 224
  %t1 = shl i8 %t0, 1
  ret i8 %t1
}

;------------------------------------------------------------------------------;
; 16-bit
;------------------------------------------------------------------------------;

; lshr

define i16 @test_i16_127_mask_lshr_1(i16 %a0) {
; X32-LABEL: test_i16_127_mask_lshr_1:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $126, %eax
; X32-NEXT:    shrl %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_127_mask_lshr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $126, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 127
  %t1 = lshr i16 %t0, 1
  ret i16 %t1
}

define i16 @test_i16_2032_mask_lshr_3(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_lshr_3:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $2032, %eax # imm = 0x7F0
; X32-NEXT:    shrl $3, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_lshr_3:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $2032, %eax # imm = 0x7F0
; X64-NEXT:    shrl $3, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = lshr i16 %t0, 3
  ret i16 %t1
}
define i16 @test_i16_2032_mask_lshr_4(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_lshr_4:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $4, %eax
; X32-NEXT:    andl $127, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_lshr_4:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrl $4, %eax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = lshr i16 %t0, 4
  ret i16 %t1
}
define i16 @test_i16_2032_mask_lshr_5(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_lshr_5:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $5, %eax
; X32-NEXT:    andl $63, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_lshr_5:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrl $5, %eax
; X64-NEXT:    andl $63, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = lshr i16 %t0, 5
  ret i16 %t1
}
define i16 @test_i16_2032_mask_lshr_6(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_lshr_6:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $6, %eax
; X32-NEXT:    andl $31, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_lshr_6:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrl $6, %eax
; X64-NEXT:    andl $31, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = lshr i16 %t0, 6
  ret i16 %t1
}

define i16 @test_i16_65024_mask_lshr_1(i16 %a0) {
; X32-LABEL: test_i16_65024_mask_lshr_1:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $65024, %eax # imm = 0xFE00
; X32-NEXT:    shrl %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_65024_mask_lshr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $65024, %eax # imm = 0xFE00
; X64-NEXT:    shrl %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 65024
  %t1 = lshr i16 %t0, 1
  ret i16 %t1
}
define i16 @test_i16_65024_mask_lshr_8(i16 %a0) {
; X32-LABEL: test_i16_65024_mask_lshr_8:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $65024, %eax # imm = 0xFE00
; X32-NEXT:    shrl $8, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_65024_mask_lshr_8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $65024, %eax # imm = 0xFE00
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 65024
  %t1 = lshr i16 %t0, 8
  ret i16 %t1
}
define i16 @test_i16_65024_mask_lshr_9(i16 %a0) {
; X32-LABEL: test_i16_65024_mask_lshr_9:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $9, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_65024_mask_lshr_9:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %di, %eax
; X64-NEXT:    shrl $9, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 65024
  %t1 = lshr i16 %t0, 9
  ret i16 %t1
}
define i16 @test_i16_65024_mask_lshr_10(i16 %a0) {
; X32-LABEL: test_i16_65024_mask_lshr_10:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $10, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_65024_mask_lshr_10:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %di, %eax
; X64-NEXT:    shrl $10, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 65024
  %t1 = lshr i16 %t0, 10
  ret i16 %t1
}

; ashr

define i16 @test_i16_127_mask_ashr_1(i16 %a0) {
; X32-LABEL: test_i16_127_mask_ashr_1:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $126, %eax
; X32-NEXT:    shrl %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_127_mask_ashr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $126, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 127
  %t1 = ashr i16 %t0, 1
  ret i16 %t1
}

define i16 @test_i16_2032_mask_ashr_3(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_ashr_3:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $2032, %eax # imm = 0x7F0
; X32-NEXT:    shrl $3, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_ashr_3:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $2032, %eax # imm = 0x7F0
; X64-NEXT:    shrl $3, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = ashr i16 %t0, 3
  ret i16 %t1
}
define i16 @test_i16_2032_mask_ashr_4(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_ashr_4:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $4, %eax
; X32-NEXT:    andl $127, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_ashr_4:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrl $4, %eax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = ashr i16 %t0, 4
  ret i16 %t1
}
define i16 @test_i16_2032_mask_ashr_5(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_ashr_5:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $5, %eax
; X32-NEXT:    andl $63, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_ashr_5:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrl $5, %eax
; X64-NEXT:    andl $63, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = ashr i16 %t0, 5
  ret i16 %t1
}
define i16 @test_i16_2032_mask_ashr_6(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_ashr_6:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $6, %eax
; X32-NEXT:    andl $31, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_ashr_6:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrl $6, %eax
; X64-NEXT:    andl $31, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = ashr i16 %t0, 6
  ret i16 %t1
}

define i16 @test_i16_65024_mask_ashr_1(i16 %a0) {
; X32-LABEL: test_i16_65024_mask_ashr_1:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $65024, %eax # imm = 0xFE00
; X32-NEXT:    cwtl
; X32-NEXT:    shrl %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_65024_mask_ashr_1:
; X64:       # %bb.0:
; X64-NEXT:    andl $65024, %edi # imm = 0xFE00
; X64-NEXT:    movswl %di, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 65024
  %t1 = ashr i16 %t0, 1
  ret i16 %t1
}
define i16 @test_i16_65024_mask_ashr_8(i16 %a0) {
; X32-LABEL: test_i16_65024_mask_ashr_8:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $65024, %eax # imm = 0xFE00
; X32-NEXT:    cwtl
; X32-NEXT:    shrl $8, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_65024_mask_ashr_8:
; X64:       # %bb.0:
; X64-NEXT:    andl $65024, %edi # imm = 0xFE00
; X64-NEXT:    movswl %di, %eax
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 65024
  %t1 = ashr i16 %t0, 8
  ret i16 %t1
}
define i16 @test_i16_65024_mask_ashr_9(i16 %a0) {
; X32-LABEL: test_i16_65024_mask_ashr_9:
; X32:       # %bb.0:
; X32-NEXT:    movswl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $9, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_65024_mask_ashr_9:
; X64:       # %bb.0:
; X64-NEXT:    movswl %di, %eax
; X64-NEXT:    shrl $9, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 65024
  %t1 = ashr i16 %t0, 9
  ret i16 %t1
}
define i16 @test_i16_65024_mask_ashr_10(i16 %a0) {
; X32-LABEL: test_i16_65024_mask_ashr_10:
; X32:       # %bb.0:
; X32-NEXT:    movswl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $10, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_65024_mask_ashr_10:
; X64:       # %bb.0:
; X64-NEXT:    movswl %di, %eax
; X64-NEXT:    shrl $10, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 65024
  %t1 = ashr i16 %t0, 10
  ret i16 %t1
}

; shl

define i16 @test_i16_127_mask_shl_1(i16 %a0) {
; X32-LABEL: test_i16_127_mask_shl_1:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $127, %eax
; X32-NEXT:    addl %eax, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_127_mask_shl_1:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    andl $127, %edi
; X64-NEXT:    leal (%rdi,%rdi), %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 127
  %t1 = shl i16 %t0, 1
  ret i16 %t1
}
define i16 @test_i16_127_mask_shl_8(i16 %a0) {
; X32-LABEL: test_i16_127_mask_shl_8:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $127, %eax
; X32-NEXT:    shll $8, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_127_mask_shl_8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    shll $8, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 127
  %t1 = shl i16 %t0, 8
  ret i16 %t1
}
define i16 @test_i16_127_mask_shl_9(i16 %a0) {
; X32-LABEL: test_i16_127_mask_shl_9:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $9, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_127_mask_shl_9:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shll $9, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 127
  %t1 = shl i16 %t0, 9
  ret i16 %t1
}
define i16 @test_i16_127_mask_shl_10(i16 %a0) {
; X32-LABEL: test_i16_127_mask_shl_10:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $10, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_127_mask_shl_10:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shll $10, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 127
  %t1 = shl i16 %t0, 10
  ret i16 %t1
}

define i16 @test_i16_2032_mask_shl_3(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_shl_3:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $2032, %eax # imm = 0x7F0
; X32-NEXT:    shll $3, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_shl_3:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    andl $2032, %edi # imm = 0x7F0
; X64-NEXT:    leal (,%rdi,8), %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = shl i16 %t0, 3
  ret i16 %t1
}
define i16 @test_i16_2032_mask_shl_4(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_shl_4:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $2032, %eax # imm = 0x7F0
; X32-NEXT:    shll $4, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_shl_4:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $2032, %eax # imm = 0x7F0
; X64-NEXT:    shll $4, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = shl i16 %t0, 4
  ret i16 %t1
}
define i16 @test_i16_2032_mask_shl_5(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_shl_5:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $2032, %eax # imm = 0x7F0
; X32-NEXT:    shll $5, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_shl_5:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $2032, %eax # imm = 0x7F0
; X64-NEXT:    shll $5, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = shl i16 %t0, 5
  ret i16 %t1
}
define i16 @test_i16_2032_mask_shl_6(i16 %a0) {
; X32-LABEL: test_i16_2032_mask_shl_6:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $1008, %eax # imm = 0x3F0
; X32-NEXT:    shll $6, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_2032_mask_shl_6:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $1008, %eax # imm = 0x3F0
; X64-NEXT:    shll $6, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 2032
  %t1 = shl i16 %t0, 6
  ret i16 %t1
}

define i16 @test_i16_65024_mask_shl_1(i16 %a0) {
; X32-LABEL: test_i16_65024_mask_shl_1:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $32256, %eax # imm = 0x7E00
; X32-NEXT:    addl %eax, %eax
; X32-NEXT:    # kill: def $ax killed $ax killed $eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i16_65024_mask_shl_1:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    andl $32256, %edi # imm = 0x7E00
; X64-NEXT:    leal (%rdi,%rdi), %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = and i16 %a0, 65024
  %t1 = shl i16 %t0, 1
  ret i16 %t1
}

;------------------------------------------------------------------------------;
; 32-bit
;------------------------------------------------------------------------------;

; lshr

define i32 @test_i32_32767_mask_lshr_1(i32 %a0) {
; X32-LABEL: test_i32_32767_mask_lshr_1:
; X32:       # %bb.0:
; X32-NEXT:    movl $32766, %eax # imm = 0x7FFE
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_32767_mask_lshr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $32766, %eax # imm = 0x7FFE
; X64-NEXT:    shrl %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 32767
  %t1 = lshr i32 %t0, 1
  ret i32 %t1
}

define i32 @test_i32_8388352_mask_lshr_7(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_lshr_7:
; X32:       # %bb.0:
; X32-NEXT:    movl $8388352, %eax # imm = 0x7FFF00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $7, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_lshr_7:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $8388352, %eax # imm = 0x7FFF00
; X64-NEXT:    shrl $7, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = lshr i32 %t0, 7
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_lshr_8(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_lshr_8:
; X32:       # %bb.0:
; X32-NEXT:    movl $8388352, %eax # imm = 0x7FFF00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $8, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_lshr_8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $8388352, %eax # imm = 0x7FFF00
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = lshr i32 %t0, 8
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_lshr_9(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_lshr_9:
; X32:       # %bb.0:
; X32-NEXT:    movl $8388096, %eax # imm = 0x7FFE00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $9, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_lshr_9:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $8388096, %eax # imm = 0x7FFE00
; X64-NEXT:    shrl $9, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = lshr i32 %t0, 9
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_lshr_10(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_lshr_10:
; X32:       # %bb.0:
; X32-NEXT:    movl $8387584, %eax # imm = 0x7FFC00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $10, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_lshr_10:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $8387584, %eax # imm = 0x7FFC00
; X64-NEXT:    shrl $10, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = lshr i32 %t0, 10
  ret i32 %t1
}

define i32 @test_i32_4294836224_mask_lshr_1(i32 %a0) {
; X32-LABEL: test_i32_4294836224_mask_lshr_1:
; X32:       # %bb.0:
; X32-NEXT:    movl $-131072, %eax # imm = 0xFFFE0000
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_4294836224_mask_lshr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $-131072, %eax # imm = 0xFFFE0000
; X64-NEXT:    shrl %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 4294836224
  %t1 = lshr i32 %t0, 1
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_lshr_16(i32 %a0) {
; X32-LABEL: test_i32_4294836224_mask_lshr_16:
; X32:       # %bb.0:
; X32-NEXT:    movl $-131072, %eax # imm = 0xFFFE0000
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $16, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_4294836224_mask_lshr_16:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $-131072, %eax # imm = 0xFFFE0000
; X64-NEXT:    shrl $16, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 4294836224
  %t1 = lshr i32 %t0, 16
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_lshr_17(i32 %a0) {
; X32-LABEL: test_i32_4294836224_mask_lshr_17:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $17, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_4294836224_mask_lshr_17:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrl $17, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 4294836224
  %t1 = lshr i32 %t0, 17
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_lshr_18(i32 %a0) {
; X32-LABEL: test_i32_4294836224_mask_lshr_18:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $18, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_4294836224_mask_lshr_18:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrl $18, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 4294836224
  %t1 = lshr i32 %t0, 18
  ret i32 %t1
}

; ashr

define i32 @test_i32_32767_mask_ashr_1(i32 %a0) {
; X32-LABEL: test_i32_32767_mask_ashr_1:
; X32:       # %bb.0:
; X32-NEXT:    movl $32766, %eax # imm = 0x7FFE
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_32767_mask_ashr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $32766, %eax # imm = 0x7FFE
; X64-NEXT:    shrl %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 32767
  %t1 = ashr i32 %t0, 1
  ret i32 %t1
}

define i32 @test_i32_8388352_mask_ashr_7(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_ashr_7:
; X32:       # %bb.0:
; X32-NEXT:    movl $8388352, %eax # imm = 0x7FFF00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $7, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_ashr_7:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $8388352, %eax # imm = 0x7FFF00
; X64-NEXT:    shrl $7, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = ashr i32 %t0, 7
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_ashr_8(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_ashr_8:
; X32:       # %bb.0:
; X32-NEXT:    movl $8388352, %eax # imm = 0x7FFF00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $8, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_ashr_8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $8388352, %eax # imm = 0x7FFF00
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = ashr i32 %t0, 8
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_ashr_9(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_ashr_9:
; X32:       # %bb.0:
; X32-NEXT:    movl $8388096, %eax # imm = 0x7FFE00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $9, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_ashr_9:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $8388096, %eax # imm = 0x7FFE00
; X64-NEXT:    shrl $9, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = ashr i32 %t0, 9
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_ashr_10(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_ashr_10:
; X32:       # %bb.0:
; X32-NEXT:    movl $8387584, %eax # imm = 0x7FFC00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $10, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_ashr_10:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $8387584, %eax # imm = 0x7FFC00
; X64-NEXT:    shrl $10, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = ashr i32 %t0, 10
  ret i32 %t1
}

define i32 @test_i32_4294836224_mask_ashr_1(i32 %a0) {
; X32-LABEL: test_i32_4294836224_mask_ashr_1:
; X32:       # %bb.0:
; X32-NEXT:    movl $-131072, %eax # imm = 0xFFFE0000
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    sarl %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_4294836224_mask_ashr_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $-131072, %eax # imm = 0xFFFE0000
; X64-NEXT:    sarl %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 4294836224
  %t1 = ashr i32 %t0, 1
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_ashr_16(i32 %a0) {
; X32-LABEL: test_i32_4294836224_mask_ashr_16:
; X32:       # %bb.0:
; X32-NEXT:    movl $-131072, %eax # imm = 0xFFFE0000
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    sarl $16, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_4294836224_mask_ashr_16:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $-131072, %eax # imm = 0xFFFE0000
; X64-NEXT:    sarl $16, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 4294836224
  %t1 = ashr i32 %t0, 16
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_ashr_17(i32 %a0) {
; X32-LABEL: test_i32_4294836224_mask_ashr_17:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    sarl $17, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_4294836224_mask_ashr_17:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarl $17, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 4294836224
  %t1 = ashr i32 %t0, 17
  ret i32 %t1
}
define i32 @test_i32_4294836224_mask_ashr_18(i32 %a0) {
; X32-LABEL: test_i32_4294836224_mask_ashr_18:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    sarl $18, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_4294836224_mask_ashr_18:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarl $18, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 4294836224
  %t1 = ashr i32 %t0, 18
  ret i32 %t1
}

; shl

define i32 @test_i32_32767_mask_shl_1(i32 %a0) {
; X32-LABEL: test_i32_32767_mask_shl_1:
; X32:       # %bb.0:
; X32-NEXT:    movl $32767, %eax # imm = 0x7FFF
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    addl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_32767_mask_shl_1:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    andl $32767, %edi # imm = 0x7FFF
; X64-NEXT:    leal (%rdi,%rdi), %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 32767
  %t1 = shl i32 %t0, 1
  ret i32 %t1
}
define i32 @test_i32_32767_mask_shl_16(i32 %a0) {
; X32-LABEL: test_i32_32767_mask_shl_16:
; X32:       # %bb.0:
; X32-NEXT:    movl $32767, %eax # imm = 0x7FFF
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $16, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_32767_mask_shl_16:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $32767, %eax # imm = 0x7FFF
; X64-NEXT:    shll $16, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 32767
  %t1 = shl i32 %t0, 16
  ret i32 %t1
}
define i32 @test_i32_32767_mask_shl_17(i32 %a0) {
; X32-LABEL: test_i32_32767_mask_shl_17:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $17, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_32767_mask_shl_17:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shll $17, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 32767
  %t1 = shl i32 %t0, 17
  ret i32 %t1
}
define i32 @test_i32_32767_mask_shl_18(i32 %a0) {
; X32-LABEL: test_i32_32767_mask_shl_18:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $18, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_32767_mask_shl_18:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shll $18, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 32767
  %t1 = shl i32 %t0, 18
  ret i32 %t1
}

define i32 @test_i32_8388352_mask_shl_7(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_shl_7:
; X32:       # %bb.0:
; X32-NEXT:    movl $8388352, %eax # imm = 0x7FFF00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $7, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_shl_7:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $8388352, %eax # imm = 0x7FFF00
; X64-NEXT:    shll $7, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = shl i32 %t0, 7
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_shl_8(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_shl_8:
; X32:       # %bb.0:
; X32-NEXT:    movl $8388352, %eax # imm = 0x7FFF00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $8, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_shl_8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $8388352, %eax # imm = 0x7FFF00
; X64-NEXT:    shll $8, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = shl i32 %t0, 8
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_shl_9(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_shl_9:
; X32:       # %bb.0:
; X32-NEXT:    movl $8388352, %eax # imm = 0x7FFF00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $9, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_shl_9:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $8388352, %eax # imm = 0x7FFF00
; X64-NEXT:    shll $9, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = shl i32 %t0, 9
  ret i32 %t1
}
define i32 @test_i32_8388352_mask_shl_10(i32 %a0) {
; X32-LABEL: test_i32_8388352_mask_shl_10:
; X32:       # %bb.0:
; X32-NEXT:    movl $4194048, %eax # imm = 0x3FFF00
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $10, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_8388352_mask_shl_10:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $4194048, %eax # imm = 0x3FFF00
; X64-NEXT:    shll $10, %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 8388352
  %t1 = shl i32 %t0, 10
  ret i32 %t1
}

define i32 @test_i32_4294836224_mask_shl_1(i32 %a0) {
; X32-LABEL: test_i32_4294836224_mask_shl_1:
; X32:       # %bb.0:
; X32-NEXT:    movl $2147352576, %eax # imm = 0x7FFE0000
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    addl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i32_4294836224_mask_shl_1:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    andl $2147352576, %edi # imm = 0x7FFE0000
; X64-NEXT:    leal (%rdi,%rdi), %eax
; X64-NEXT:    retq
  %t0 = and i32 %a0, 4294836224
  %t1 = shl i32 %t0, 1
  ret i32 %t1
}

;------------------------------------------------------------------------------;
; 64-bit
;------------------------------------------------------------------------------;

; lshr

define i64 @test_i64_2147483647_mask_lshr_1(i64 %a0) {
; X32-LABEL: test_i64_2147483647_mask_lshr_1:
; X32:       # %bb.0:
; X32-NEXT:    movl $2147483646, %eax # imm = 0x7FFFFFFE
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_2147483647_mask_lshr_1:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    andl $2147483646, %eax # imm = 0x7FFFFFFE
; X64-NEXT:    shrq %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 2147483647
  %t1 = lshr i64 %t0, 1
  ret i64 %t1
}

define i64 @test_i64_140737488289792_mask_lshr_15(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_lshr_15:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    shll $16, %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shldl $17, %ecx, %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_lshr_15:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $140737488289792, %rax # imm = 0x7FFFFFFF0000
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    shrq $15, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = lshr i64 %t0, 15
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_lshr_16(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_lshr_16:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl $32767, %eax # imm = 0x7FFF
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $16, %eax
; X32-NEXT:    orl %ecx, %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_lshr_16:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $16, %rax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = lshr i64 %t0, 16
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_lshr_17(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_lshr_17:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl $32767, %eax # imm = 0x7FFF
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shldl $15, %ecx, %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_lshr_17:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $17, %rax
; X64-NEXT:    andl $1073741823, %eax # imm = 0x3FFFFFFF
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = lshr i64 %t0, 17
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_lshr_18(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_lshr_18:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl $32767, %eax # imm = 0x7FFF
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shldl $14, %ecx, %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_lshr_18:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $18, %rax
; X64-NEXT:    andl $536870911, %eax # imm = 0x1FFFFFFF
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = lshr i64 %t0, 18
  ret i64 %t1
}

define i64 @test_i64_18446744065119617024_mask_lshr_1(i64 %a0) {
; X32-LABEL: test_i64_18446744065119617024_mask_lshr_1:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    shrl %edx
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_18446744065119617024_mask_lshr_1:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $-8589934592, %rax # imm = 0xFFFFFFFE00000000
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    shrq %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = lshr i64 %t0, 1
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_lshr_32(i64 %a0) {
; X32-LABEL: test_i64_18446744065119617024_mask_lshr_32:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $-2, %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_18446744065119617024_mask_lshr_32:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $-8589934592, %rax # imm = 0xFFFFFFFE00000000
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    shrq $32, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = lshr i64 %t0, 32
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_lshr_33(i64 %a0) {
; X32-LABEL: test_i64_18446744065119617024_mask_lshr_33:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_18446744065119617024_mask_lshr_33:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $33, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = lshr i64 %t0, 33
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_lshr_34(i64 %a0) {
; X32-LABEL: test_i64_18446744065119617024_mask_lshr_34:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl $2, %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_18446744065119617024_mask_lshr_34:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $34, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = lshr i64 %t0, 34
  ret i64 %t1
}

; ashr

define i64 @test_i64_2147483647_mask_ashr_1(i64 %a0) {
; X32-LABEL: test_i64_2147483647_mask_ashr_1:
; X32:       # %bb.0:
; X32-NEXT:    movl $2147483646, %eax # imm = 0x7FFFFFFE
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shrl %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_2147483647_mask_ashr_1:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    andl $2147483646, %eax # imm = 0x7FFFFFFE
; X64-NEXT:    shrq %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 2147483647
  %t1 = ashr i64 %t0, 1
  ret i64 %t1
}

define i64 @test_i64_140737488289792_mask_ashr_15(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_ashr_15:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    shll $16, %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shldl $17, %ecx, %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_ashr_15:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $140737488289792, %rax # imm = 0x7FFFFFFF0000
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    shrq $15, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = ashr i64 %t0, 15
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_ashr_16(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_ashr_16:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl $32767, %eax # imm = 0x7FFF
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $16, %eax
; X32-NEXT:    orl %ecx, %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_ashr_16:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $16, %rax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = ashr i64 %t0, 16
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_ashr_17(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_ashr_17:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl $32767, %eax # imm = 0x7FFF
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shldl $15, %ecx, %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_ashr_17:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $17, %rax
; X64-NEXT:    andl $1073741823, %eax # imm = 0x3FFFFFFF
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = ashr i64 %t0, 17
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_ashr_18(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_ashr_18:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl $32767, %eax # imm = 0x7FFF
; X32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shldl $14, %ecx, %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_ashr_18:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $18, %rax
; X64-NEXT:    andl $536870911, %eax # imm = 0x1FFFFFFF
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = ashr i64 %t0, 18
  ret i64 %t1
}

define i64 @test_i64_18446744065119617024_mask_ashr_1(i64 %a0) {
; X32-LABEL: test_i64_18446744065119617024_mask_ashr_1:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    sarl %edx
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_18446744065119617024_mask_ashr_1:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $-8589934592, %rax # imm = 0xFFFFFFFE00000000
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    sarq %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = ashr i64 %t0, 1
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_ashr_32(i64 %a0) {
; X32-LABEL: test_i64_18446744065119617024_mask_ashr_32:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    andl $-2, %eax
; X32-NEXT:    movl %eax, %edx
; X32-NEXT:    sarl $31, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_18446744065119617024_mask_ashr_32:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $-8589934592, %rax # imm = 0xFFFFFFFE00000000
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    sarq $32, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = ashr i64 %t0, 32
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_ashr_33(i64 %a0) {
; X32-LABEL: test_i64_18446744065119617024_mask_ashr_33:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl %edx, %eax
; X32-NEXT:    sarl %eax
; X32-NEXT:    sarl $31, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_18446744065119617024_mask_ashr_33:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    sarq $33, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = ashr i64 %t0, 33
  ret i64 %t1
}
define i64 @test_i64_18446744065119617024_mask_ashr_34(i64 %a0) {
; X32-LABEL: test_i64_18446744065119617024_mask_ashr_34:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl %edx, %eax
; X32-NEXT:    sarl $2, %eax
; X32-NEXT:    sarl $31, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_18446744065119617024_mask_ashr_34:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    sarq $34, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = ashr i64 %t0, 34
  ret i64 %t1
}

; shl

define i64 @test_i64_2147483647_mask_shl_1(i64 %a0) {
; X32-LABEL: test_i64_2147483647_mask_shl_1:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    addl %eax, %eax
; X32-NEXT:    xorl %edx, %edx
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_2147483647_mask_shl_1:
; X64:       # %bb.0:
; X64-NEXT:    andl $2147483647, %edi # imm = 0x7FFFFFFF
; X64-NEXT:    leaq (%rdi,%rdi), %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 2147483647
  %t1 = shl i64 %t0, 1
  ret i64 %t1
}
define i64 @test_i64_2147483647_mask_shl_32(i64 %a0) {
; X32-LABEL: test_i64_2147483647_mask_shl_32:
; X32:       # %bb.0:
; X32-NEXT:    movl $2147483647, %edx # imm = 0x7FFFFFFF
; X32-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_2147483647_mask_shl_32:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    shlq $32, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 2147483647
  %t1 = shl i64 %t0, 32
  ret i64 %t1
}
define i64 @test_i64_2147483647_mask_shl_33(i64 %a0) {
; X32-LABEL: test_i64_2147483647_mask_shl_33:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    addl %edx, %edx
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_2147483647_mask_shl_33:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shlq $33, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 2147483647
  %t1 = shl i64 %t0, 33
  ret i64 %t1
}
define i64 @test_i64_2147483647_mask_shl_34(i64 %a0) {
; X32-LABEL: test_i64_2147483647_mask_shl_34:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    shll $2, %edx
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_2147483647_mask_shl_34:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shlq $34, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 2147483647
  %t1 = shl i64 %t0, 34
  ret i64 %t1
}

define i64 @test_i64_140737488289792_mask_shl_15(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_shl_15:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %eax, %ecx
; X32-NEXT:    shll $16, %ecx
; X32-NEXT:    movl $32767, %edx # imm = 0x7FFF
; X32-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    shldl $15, %ecx, %edx
; X32-NEXT:    shll $31, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_shl_15:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $140737488289792, %rax # imm = 0x7FFFFFFF0000
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    shlq $15, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = shl i64 %t0, 15
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_shl_16(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_shl_16:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $16, %eax
; X32-NEXT:    movl $32767, %edx # imm = 0x7FFF
; X32-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    shldl $16, %eax, %edx
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_shl_16:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $140737488289792, %rax # imm = 0x7FFFFFFF0000
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    shlq $16, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = shl i64 %t0, 16
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_shl_17(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_shl_17:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $16, %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    shldl $17, %eax, %edx
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_shl_17:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $140737488289792, %rax # imm = 0x7FFFFFFF0000
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    shlq $17, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = shl i64 %t0, 17
  ret i64 %t1
}
define i64 @test_i64_140737488289792_mask_shl_18(i64 %a0) {
; X32-LABEL: test_i64_140737488289792_mask_shl_18:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll $16, %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    shldl $18, %eax, %edx
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_140737488289792_mask_shl_18:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $70368744112128, %rax # imm = 0x3FFFFFFF0000
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    shlq $18, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 140737488289792
  %t1 = shl i64 %t0, 18
  ret i64 %t1
}

define i64 @test_i64_18446744065119617024_mask_shl_1(i64 %a0) {
; X32-LABEL: test_i64_18446744065119617024_mask_shl_1:
; X32:       # %bb.0:
; X32-NEXT:    movl $2147483646, %edx # imm = 0x7FFFFFFE
; X32-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    addl %edx, %edx
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_i64_18446744065119617024_mask_shl_1:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $9223372028264841216, %rax # imm = 0x7FFFFFFE00000000
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    addq %rax, %rax
; X64-NEXT:    retq
  %t0 = and i64 %a0, 18446744065119617024
  %t1 = shl i64 %t0, 1
  ret i64 %t1
}
