/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.NamePool;

public class NamespaceReducer
extends ProxyReceiver {
    private int nscodeXML;
    private int nscodeNull;
    private int[] namespaces = new int[50];
    private int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int countStackTop = 0;
    private int[] pendingUndeclarations = null;

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
        this.nscodeXML = namePool.getNamespaceCode("xml", "http://www.w3.org/XML/1998/namespace");
        this.nscodeNull = namePool.getNamespaceCode("", "");
        super.setNamePool(namePool);
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        super.startElement(n, n2, n3);
        if ((n3 & 0x80) != 0) {
            this.pendingUndeclarations = new int[this.namespacesSize];
            System.arraycopy(this.namespaces, 0, this.pendingUndeclarations, 0, this.namespacesSize);
        } else {
            this.pendingUndeclarations = null;
        }
        this.countStack[this.countStackTop] = 0;
        if (++this.countStackTop >= this.countStack.length) {
            int[] nArray = new int[this.countStackTop * 2];
            System.arraycopy(this.countStack, 0, nArray, 0, this.countStackTop);
            this.countStack = nArray;
        }
        if ((n3 & 0x40) == 0) {
            this.namespace(this.namePool.allocateNamespaceCode(n), 0);
        }
    }

    public void namespace(int n, int n2) throws TransformerException {
        if (this.isNeeded(n)) {
            this.addToStack(n);
            int n3 = this.countStackTop - 1;
            this.countStack[n3] = this.countStack[n3] + 1;
            super.namespace(n, n2);
        }
    }

    private boolean isNeeded(int n) {
        int n2;
        if (n == this.nscodeXML) {
            return false;
        }
        if (this.pendingUndeclarations != null) {
            n2 = 0;
            while (n2 < this.pendingUndeclarations.length) {
                if (n >> 16 == this.pendingUndeclarations[n2] >> 16) {
                    this.pendingUndeclarations[n2] = -1;
                    break;
                }
                ++n2;
            }
        }
        n2 = this.namespacesSize - 1;
        while (n2 >= 0) {
            if (this.namespaces[n2] == n) {
                return false;
            }
            if (this.namespaces[n2] >> 16 == n >> 16) {
                return true;
            }
            --n2;
        }
        return n != this.nscodeNull;
    }

    private void addToStack(int n) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesSize);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesSize++] = n;
    }

    public void startContent() throws TransformerException {
        if (this.pendingUndeclarations != null) {
            int n = 0;
            while (n < this.pendingUndeclarations.length) {
                int n2 = this.pendingUndeclarations[n];
                if (n2 != -1) {
                    super.namespace(n2 & 0xFFFF0000, 0);
                }
                ++n;
            }
        }
        this.pendingUndeclarations = null;
        super.startContent();
    }

    public void endElement() throws TransformerException {
        if (this.countStackTop-- == 0) {
            throw new IllegalStateException("Attempt to output end tag with no matching start tag");
        }
        int n = this.countStack[this.countStackTop];
        this.namespacesSize -= n;
        super.endElement();
    }

    protected int getURICode(short s) {
        int n = this.namespacesSize - 1;
        while (n >= 0) {
            if (this.namespaces[n] >> 16 == s) {
                return this.namespaces[n] & 0xFFFF;
            }
            --n;
        }
        if (s == 0) {
            return 0;
        }
        return -1;
    }
}

