/*
 * uwa-test-client.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#include <stdlib.h>

// in sync with what is in src/context-daemon/interest-tracking/unity-webapps-window-tracker-dbus-controllable.c
#define WINDOW_TRACKER_DBUS_CONTROLLABLE_DBUS_PATH \
  "com.canonical.Unity.Webapps.Tests.WindowTracker.DbusControllable"
#define WINDOW_TRACKER_DBUS_CONTROLLABLE_DBUS_SIGNAL \
  "UpdateLatestWindowId"


void
uwa_emit_test_finished ()
{
  GDBusConnection *connection;
  
  connection = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, NULL); // TODO: Error
  
  g_dbus_connection_emit_signal (connection,
				 NULL,
				 "/",
				 "com.canonical.Unity.Webapps.TraceTester",
				 "TestFinished",
				 NULL,
				 NULL); // TODO: Error
  
  g_dbus_connection_flush_sync (connection, NULL, NULL);
  
  exit(0);
}

void uwa_emit_window_changed (guint64 window_id)
{
  GDBusConnection *connection;
  connection = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, NULL); // TODO: Error

  g_dbus_connection_emit_signal (connection,
				 NULL,
				 "/",
				 WINDOW_TRACKER_DBUS_CONTROLLABLE_DBUS_PATH,
				 WINDOW_TRACKER_DBUS_CONTROLLABLE_DBUS_SIGNAL,
				 g_variant_new ("(t)", window_id, NULL),
				 NULL);

  g_dbus_connection_flush_sync (connection, NULL, NULL);
}

