/*
 * Copyright (c) 2003, 2011, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 7036582
 * @summary Some tests for the divide(..,MathContext) method.
 * @run main DivideMcTests
 * @run main/othervm -XX:+AggressiveOpts DivideMcTests
 * @author Sergey V. Kuksenko
 */

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;


public class DivideMcTests {

    static String[] value = new String[75];
    static String[][] results = new String[75][75];
    static {
        value[0]="11061";
        value[1]="5030285645";
        value[2]="224198292018431";
        value[3]="19226185404220649458";
        value[4]="2754593222460641763294400";
        value[5]="88290e4";
        value[6]="14207e-4";
        value[7]="9206524943e4";
        value[8]="9637167289e-4";
        value[9]="987673128759528e4";
        value[10]="270627774630281e-4";
        value[11]="81503625886547904651e4";
        value[12]="60700032235397315737e-4";
        value[13]="6477954854329556663533122e4";
        value[14]="8056417378028557868905113e-4";
        value[15]="74996e8";
        value[16]="65282e-8";
        value[17]="6336626690e8";
        value[18]="8318166778e-8";
        value[19]="983114227763768e8";
        value[20]="245802997834566e-8";
        value[21]="52727924122290902686e8";
        value[22]="42785567085625398961e-8";
        value[23]="4810906998143118279742863e8";
        value[24]="8077506080975981172874361e-8";
        value[25]="80689e12";
        value[26]="30125e-12";
        value[27]="6921467144e12";
        value[28]="1953347181e-12";
        value[29]="405471649883944e12";
        value[30]="866720590936024e-12";
        value[31]="33231666378140173438e12";
        value[32]="42631490906110209257e-12";
        value[33]="7723154992826793726050991e12";
        value[34]="1611437259018380210686834e-12";
        value[35]="65645e16";
        value[36]="31153e-16";
        value[37]="7758733150e16";
        value[38]="6365465077e-16";
        value[39]="727973863299662e16";
        value[40]="351084160935215e-16";
        value[41]="45470432070181568402e16";
        value[42]="97216256670931719037e-16";
        value[43]="2520581904836081418366563e16";
        value[44]="3700768934485477578987416e-16";
        value[45]="28736e20";
        value[46]="52779e-20";
        value[47]="7904805864e20";
        value[48]="6373815349e-20";
        value[49]="186651310031326e20";
        value[50]="189125880591366e-20";
        value[51]="74987916068454915171e20";
        value[52]="10554589082317914511e-20";
        value[53]="3599986721169840668392202e20";
        value[54]="2588106172836128849130551e-20";
        value[55]="71080e24";
        value[56]="61576e-24";
        value[57]="7086656363e24";
        value[58]="7703864845e-24";
        value[59]="361167296280301e24";
        value[60]="149150690375117e-24";
        value[61]="78129219923655854302e24";
        value[62]="20861932490694515212e-24";
        value[63]="9185868654811652011998047e24";
        value[64]="1996563690880014012200226e-24";
        value[65]="84665e28";
        value[66]="94968e-28";
        value[67]="2622821029e28";
        value[68]="4451579486e-28";
        value[69]="590522407411869e28";
        value[70]="606293232614518e-28";
        value[71]="96628087822208148505e28";
        value[72]="24875240094942654314e-28";
        value[73]="5099400093819597146233149e28";
        value[74]="8906650752845770170008864e-28";
        //--------------------------------------------
        initResults1();
        initResults2();
    }

    private static void initResults1() {
        results[0][0]="1";
        results[0][1]="0.000002198881093560642";
        results[0][2]="4.933579065397471E-11";
        results[0][3]="5.753091300977375E-16";
        results[0][4]="4.015474920147867E-21";
        results[0][5]="0.00001252803261977574";
        results[0][6]="7785.598648553530";
        results[0][7]="1.201430514605841E-10";
        results[0][8]="0.01147743903192921";
        results[0][9]="1.119904923797219E-15";
        results[0][10]="4.087163638363069E-7";
        results[0][11]="1.357117536758031E-20";
        results[0][12]="1.822239559462666E-12";
        results[0][13]="1.707483341383177E-25";
        results[0][14]="1.372942771084022E-17";
        results[0][15]="1.474878660195210E-9";
        results[0][16]="16943414.72381361";
        results[0][17]="1.745565983468090E-14";
        results[0][18]="132.9740109233477";
        results[0][19]="1.125098151123273E-19";
        results[0][20]="0.004499945117611804";
        results[0][21]="2.097749946374985E-24";
        results[0][22]="2.585217575324869E-8";
        results[0][23]="2.299150660004288E-29";
        results[0][24]="1.369358300583728E-13";
        results[0][25]="1.370818822887878E-13";
        results[0][26]="367170124481.3278";
        results[0][27]="1.598071589430057E-18";
        results[0][28]="5662587.842852089";
        results[0][29]="2.727934247231818E-23";
        results[0][30]="12.76189825841631";
        results[0][31]="3.328451806821200E-28";
        results[0][32]="0.0002594560913752765";
        results[0][33]="1.432186717769276E-33";
        results[0][34]="6.864058738928437E-9";
        results[0][35]="1.684972198948892E-17";
        results[0][36]="3550540878888069";
        results[0][37]="1.425619335806130E-22";
        results[0][38]="17376577934.52694";
        results[0][39]="1.519422682273810E-27";
        results[0][40]="315052.6634564146";
        results[0][41]="2.432569803367569E-32";
        results[0][42]="1.137772670824026";
        results[0][43]="4.388272398043467E-37";
        results[0][44]="0.00002988838318687904";
        results[0][45]="3.849178730512249E-21";
        results[0][46]="2.095719888592054E+19";
        results[0][47]="1.399275351008165E-26";
        results[0][48]="173538130528606.9";
        results[0][49]="5.926023234524105E-31";
        results[0][50]="5848485656.967753";
        results[0][51]="1.475037656720937E-36";
        results[0][52]="104798.0164242535";
        results[0][53]="3.072511333154488E-41";
        results[0][54]="0.4273781391232109";
        results[0][55]="1.556133933595948E-25";
        results[0][56]="1.796316746784461E+23";
        results[0][57]="1.560820707738894E-30";
        results[0][58]="1.435772852009322E+18";
        results[0][59]="3.062569649555309E-35";
        results[0][60]="74159898101586.80";
        results[0][61]="1.415731529229177E-40";
        results[0][62]="530200162.6615257";
        results[0][63]="1.204132174718842E-45";
        results[0][64]="5540.018608234184";
        results[0][65]="1.306443040217327E-29";
        results[0][66]="1.164708112206217E+27";
        results[0][67]="4.217214929154817E-34";
        results[0][68]="2.484736043641657E+22";
        results[0][69]="1.873087263272185E-39";
        results[0][70]="1.824364747121068E+17";
        results[0][71]="1.144698218633054E-44";
        results[0][72]="4446590247082.196";
        results[0][73]="2.169078675235893E-49";
        results[0][74]="12418809.61422664";
        results[1][0]="454776.7511979025";
        results[1][1]="1";
        results[1][2]="0.00002243677059139446";
        results[1][3]="2.616372171203405E-10";
        results[1][4]="1.826144638701504E-15";
        results[1][5]="5.697457973722958";
        results[1][6]="3540709259.519955";
        results[1][7]="0.00005463826662224685";
        results[1][8]="5219.672435012765";
        results[1][9]="5.093067228950338E-10";
        results[1][10]="0.1858747001068956";
        results[1][11]="6.171855043605175E-15";
        results[1][12]="8.287121867567282E-7";
        results[1][13]="7.765237267187802E-20";
        results[1][14]="6.243824530142372E-12";
        results[1][15]="0.0006707405254946931";
        results[1][16]="7705471102294.660";
        results[1][17]="7.938428269631898E-9";
        results[1][18]="60473488.68147447";
        results[1][19]="5.116684819466090E-14";
        results[1][20]="2046.470421156359";
        results[1][21]="9.540079054379898E-19";
        results[1][22]="0.01175696850045963";
        results[1][23]="1.045600267671264E-23";
        results[1][24]="6.227523191653488E-8";
        results[1][25]="6.234165307538822E-8";
        results[1][26]="1.669804363485477E+17";
        results[1][27]="7.267658056226699E-13";
        results[1][28]="2575213302545.012";
        results[1][29]="1.240601074437582E-17";
        results[1][30]="5803814.629080740";
        results[1][31]="1.513702499224934E-22";
        results[1][32]="117.9945983141544";
        results[1][33]="6.513252226158986E-28";
        results[1][34]="0.003121614333321446";
        results[1][35]="7.662861824967629E-12";
        results[1][36]="1.614703445896061E+21";
        results[1][37]="6.483385299828233E-17";
        results[1][38]="7902463660001319";
        results[1][39]="6.909981111408860E-22";
        results[1][40]="143278626742.9544";
        results[1][41]="1.106276192237624E-26";
        results[1][42]="517432.5588391111";
        results[1][43]="1.995684264553637E-31";
        results[1][44]="13.59254180428686";
        results[1][45]="1.750516997842428E-15";
        results[1][46]="9.530846823547244E+24";
        results[1][47]="6.363578981627979E-21";
        results[1][48]="7.892110721075739E+19";
        results[1][49]="2.695017594120158E-25";
        results[1][50]="2659755306503325";
        results[1][51]="6.708128334181145E-31";
        results[1][52]="47659701441.40646";
        results[1][53]="1.397306722110734E-35";
        results[1][54]="194361.6416434591";
        results[1][55]="7.076935347495779E-20";
        results[1][56]="8.169230942250227E+28";
        results[1][57]="7.098249706679054E-25";
        results[1][58]="6.529561130949462E+23";
        results[1][59]="1.392785475542062E-29";
        results[1][60]="3.372619752780715E+19";
        results[1][61]="6.438417854312836E-35";
        results[1][62]="241122707459808.1";
        results[1][63]="5.476113184315002E-40";
        results[1][64]="2519471664.228668";
        results[1][65]="5.941399214551468E-24";
        results[1][66]="5.296821713629854E+32";
        results[1][67]="1.917891304584321E-28";
        results[1][68]="1.130000185511682E+28";
        results[1][69]="8.518365403010947E-34";
        results[1][70]="8.296786726957023E+22";
        results[1][71]="5.205821369719668E-39";
        results[1][72]="2.022205866476320E+18";
        results[1][73]="9.864465530164297E-44";
        results[1][74]="5647785890103.269";
        results[2][0]="20269260647.17756";
        results[2][1]="44569.69401753148";
        results[2][2]="1";
        results[2][3]="0.00001166109071065203";
        results[2][4]="8.139070777868161E-11";
        results[2][5]="253933.9585665772";
        results[2][6]="157808328301844.9";
        results[2][7]="2.435210825001846";
        results[2][8]="232639203.3002624";
        results[2][9]="0.00002269964480050335";
        results[2][10]="8284.378509364762";
        results[2][11]="2.750776908140411E-10";
        results[2][12]="0.03693544859234678";
        results[2][13]="3.460942489720927E-15";
        results[2][14]="2.782853488076028E-7";
        results[2][15]="29.89469998645674";
        results[2][16]="3.434304892902040E+17";
        results[2][17]="0.0003538133189576156";
        results[2][18]="2695284886705.971";
        results[2][19]="2.280490767877520E-9";
        results[2][20]="91210560.48686773";
        results[2][21]="4.251984043567731E-14";
        results[2][22]="524.0044886392415";
        results[2][23]="4.660208399475724E-19";
        results[2][24]="0.002775588031390770";
        results[2][25]="0.002778548402117154";
        results[2][26]="7.442266954968664E+21";
        results[2][27]="3.239172957900716E-8";
        results[2][28]="1.147764689243079E+17";
        results[2][29]="5.529321028550383E-13";
        results[2][30]="258674242152.6016";
        results[2][31]="6.746525722402801E-18";
        results[2][32]="5258983.142583397";
        results[2][33]="2.902936587789118E-23";
        results[2][34]="139.1293956768774";
        results[2][35]="3.415314068374301E-7";
        results[2][36]="7.196683851264116E+25";
        results[2][37]="2.889624990111060E-12";
        results[2][38]="3.522103873109208E+20";
        results[2][39]="3.079757438024150E-17";
        results[2][40]="6385884553185581";
        results[2][41]="4.930639138691073E-22";
        results[2][42]="23061810822.16754";
        results[2][43]="8.894703702675794E-27";
        results[2][44]="605815.4291375707";
        results[2][45]="7.802000696632482E-11";
        results[2][46]="4.247869266534626E+29";
        results[2][47]="2.836227680675536E-16";
        results[2][48]="3.517489599908254E+24";
        results[2][49]="1.201161095417993E-20";
        results[2][50]="1.185444801723589E+20";
        results[2][51]="2.989792272847868E-26";
        results[2][52]="2124178310210390";
        results[2][53]="6.227753305311532E-31";
        results[2][54]="8662638896.794075";
        results[2][55]="3.154168430197397E-15";
        results[2][56]="3.641001234546430E+33";
        results[2][57]="3.163668174867180E-20";
        results[2][58]="2.910205416751843E+28";
        results[2][59]="6.207602247697180E-25";
        results[2][60]="1.503166304189191E+24";
        results[2][61]="2.869583137237347E-30";
        results[2][62]="1.074676529216240E+19";
        results[2][63]="2.440686890302896E-35";
        results[2][64]="112292081160512.5";
        results[2][65]="2.648063450285608E-19";
        results[2][66]="2.360777230418994E+37";
        results[2][67]="8.547982860420744E-24";
        results[2][68]="5.036376250800950E+32";
        results[2][69]="3.796609395417242E-29";
        results[2][70]="3.697852457491911E+27";
        results[2][71]="2.320218655583322E-34";
        results[2][72]="9.012909670930670E+22";
        results[2][73]="4.396562103259092E-39";
        results[2][74]="2.517200889984344E+17";
        results[3][0]="1738195950114877";
        results[3][1]="3822086211.611279";
        results[3][2]="85755.27151045421";
        results[3][3]="1";
        results[3][4]="0.000006979682243988879";
        results[3][5]="21776175562.60126";
        results[3][6]="1.353289604013560E+19";
        results[3][7]="208832.1654832305";
        results[3][8]="19950038042989.76";
        results[3][9]="1.946614203058035";
        results[3][10]="710429128.3659471";
        results[3][11]="0.00002358936206222687";
        results[3][12]="3167.409422397122";
        results[3][13]="2.967940628880855E-10";
        results[3][14]="0.02386443564437743";
        results[3][15]="2563628.114062170";
        results[3][16]="2.945097485404958E+22";
        results[3][17]="30.34135723122526";
        results[3][18]="2.311348872574943E+17";
        results[3][19]="0.0001955641049764209";
        results[3][20]="7821786379172.049";
        results[3][21]="3.646300461142698E-9";
        results[3][22]="44936147.19595487";
        results[3][23]="3.996374365923399E-14";
        results[3][24]="238.0213052330826";
        results[3][25]="238.2751726284952";
        results[3][26]="6.382136233766191E+26";
        results[3][27]="0.002777761564740970";
        results[3][28]="9.842687255615237E+21";
        results[3][29]="4.741684260718020E-8";
        results[3][30]="2.218267986855733E+16";
        results[3][31]="5.785501450769154E-13";
        results[3][32]="450985527261.1410";
        results[3][33]="2.489421152634873E-18";
        results[3][34]="11931079.10135604";
        results[3][35]="0.02928811852269122";
        results[3][36]="6.171535776400555E+30";
        results[3][37]="2.478005755903675E-7";
        results[3][38]="3.020389739265025E+25";
        results[3][39]="2.641054352841019E-12";
        results[3][40]="5.476232636928451E+20";
        results[3][41]="4.228282980585251E-17";
        results[3][42]="1977671848577708";
        results[3][43]="7.627677310280051E-22";
        results[3][44]="51951866610.91471";
        results[3][45]="0.000006690626880644714";
        results[3][46]="3.642771822925908E+34";
        results[3][47]="2.432214748217965E-11";
        results[3][48]="3.016432756753313E+29";
        results[3][49]="1.030058958653646E-15";
        results[3][50]="1.016581408324629E+25";
        results[3][51]="2.563904481179269E-21";
        results[3][52]="1.821594877287098E+20";
        results[3][53]="5.340626755971191E-26";
        results[3][54]="742866950591597.5";
        results[3][55]="2.704865701212809E-10";
        results[3][56]="3.122350494384281E+38";
        results[3][57]="2.713012233047182E-15";
        results[3][58]="2.495654556647489E+33";
        results[3][59]="5.323346161801775E-20";
        results[3][60]="1.289044345411101E+29";
        results[3][61]="2.460818810556097E-25";
        results[3][62]="9.215917754885128E+23";
        results[3][63]="2.093017669499310E-30";
        results[3][64]="9.629637908393713E+18";
        results[3][65]="2.270854001561525E-14";
        results[3][66]="2.024490923702789E+42";
        results[3][67]="7.330345910620899E-19";
        results[3][68]="4.318958128162389E+37";
        results[3][69]="3.255792695231470E-24";
        results[3][70]="3.171103414978191E+32";
        results[3][71]="1.989709807731689E-29";
        results[3][72]="7.729045159298581E+27";
        results[3][73]="3.770283768775571E-34";
        results[3][74]="2.158632457669644E+22";
        results[4][0]="2.490365448386802E+20";
        results[4][1]="547601750051441.0";
        results[4][2]="12286414841.35031";
        results[4][3]="143272.9979736873";
        results[4][4]="1";
        results[4][5]="3119937957255229";
        results[4][6]="1.938898586936469E+24";
        results[4][7]="29920010422.11961";
        results[4][8]="2.858301760108257E+18";
        results[4][9]="278897.2527702849";
        results[4][10]="101785311068822.8";
        results[4][11]="3.379718622942007";
        results[4][12]="453804243.7569410";
        results[4][13]="0.00004252257517076709";
        results[4][14]="3419.129239720079";
        results[4][15]="367298685591.3171";
        results[4][16]="4.219529460587362E+27";
        results[4][17]="4347097.213108260";
        results[4][18]="3.311538823369143E+22";
        results[4][19]="28.01905561601273";
        results[4][20]="1.120650784053732E+18";
        results[4][21]="0.0005224163985807529";
        results[4][22]="6438136526151.358";
        results[4][23]="5.725725364310391E-9";
        results[4][24]="34102025.98235386";
        results[4][25]="34138398.32518239";
        results[4][26]="9.143877916881798E+31";
        results[4][27]="397.9782270365194";
        results[4][28]="1.410191311229400E+27";
        results[4][29]="0.006793553194777180";
        results[4][30]="3.178179047858768E+21";
        results[4][31]="8.289061376328140E-8";
        results[4][32]="6.461404853344776E+16";
        results[4][33]="3.566668317571105E-13";
        results[4][34]="1709401471912.486";
        results[4][35]="4196.196545754653";
        results[4][36]="8.842144327867755E+35";
        results[4][37]="0.03550313136443727";
        results[4][38]="4.327402929934638E+30";
        results[4][39]="3.783917749429893E-7";
        results[4][40]="7.845962674940902E+25";
        results[4][41]="6.057987789095672E-12";
        results[4][42]="2.833469747538924E+20";
        results[4][43]="1.092840195819694E-16";
        results[4][44]="7443299679674857";
        results[4][45]="0.9585861715133080";
        results[4][46]="5.219108400046689E+39";
        results[4][47]="0.000003484706986930048";
        results[4][48]="4.321733642460815E+34";
        results[4][49]="1.475796350959623E-10";
        results[4][50]="1.456486660549828E+30";
        results[4][51]="3.673382815367253E-16";
        results[4][52]="2.609853591624336E+25";
        results[4][53]="7.651676063864807E-21";
        results[4][54]="1.064327751068292E+20";
        results[4][55]="0.00003875342181289592";
        results[4][56]="4.473485160550607E+43";
        results[4][57]="3.887013961679578E-10";
        results[4][58]="3.575599102375792E+38";
        results[4][59]="7.626917638530619E-15";
        results[4][60]="1.846852478880778E+34";
        results[4][61]="3.525688884584153E-20";
        results[4][62]="1.320392165821326E+29";
        results[4][63]="2.998729163210665E-25";
        results[4][64]="1.379667092536635E+24";
        results[4][65]="3.253520607642641E-9";
        results[4][66]="2.900548840094181E+47";
        results[4][67]="1.050240634798815E-13";
        results[4][68]="6.187900791446503E+42";
        results[4][69]="4.664671802266443E-19";
        results[4][70]="4.543334931485233E+37";
        results[4][71]="2.850716892513680E-24";
        results[4][72]="1.107363471446723E+33";
        results[4][73]="5.401798587640085E-29";
        results[4][74]="3.092737437336386E+27";
        results[5][0]="79820.99267697315";
        results[5][1]="0.1755168716666387";
        results[5][2]="0.000003938031784503595";
        results[5][3]="4.592174586052730E-11";
        results[5][4]="3.205191941956922E-16";
        results[5][5]="1";
        results[5][6]="621454212.7120434";
        results[5][7]="0.000009589937630824491";
        results[5][8]="916.1405769180272";
        results[5][9]="8.939192272132398E-11";
        results[5][10]="0.03262414588473695";
        results[5][11]="1.083264689633546E-15";
        results[5][12]="1.454529705315602E-7";
        results[5][13]="1.362930152886002E-20";
        results[5][14]="1.095896548766010E-12";
        results[5][15]="0.0001177262787348659";
        results[5][16]="1352440182592.445";
        results[5][17]="1.393328095835799E-9";
        results[5][18]="10614117.55214028";
        results[5][19]="8.980645128168683E-15";
        results[5][20]="359.1900862796728";
        results[5][21]="1.674444831077185E-19";
        results[5][22]="0.002063546331483886";
        results[5][23]="1.835204879954603E-24";
        results[5][24]="1.093035388830462E-8";
        results[5][25]="1.094201192231903E-8";
        results[5][26]="2.930788381742739E+16";
        results[5][27]="1.275596606371755E-13";
        results[5][28]="451993382737.0138";
        results[5][29]="2.177464195715552E-18";
        results[5][30]="1018667.387429325";
        results[5][31]="2.656803272979331E-23";
        results[5][32]="20.71004276966202";
        results[5][33]="1.143185655111196E-28";
        results[5][34]="0.0005478959823343203";
        results[5][35]="1.344961535532028E-12";
        results[5][36]="2.834076974930183E+20";
        results[5][37]="1.137943505635324E-17";
        results[5][38]="1387015700062728";
        results[5][39]="1.212818267950047E-22";
        results[5][40]="25147816342.61536";
        results[5][41]="1.941701364608288E-27";
        results[5][42]="90818.14402590475";
        results[5][43]="3.502762589487909E-32";
        results[5][44]="2.385720415486439";
        results[5][45]="3.072452672605791E-16";
        results[5][46]="1.672824418802933E+24";
        results[5][47]="1.116915475458918E-21";
        results[5][48]="1.385198584609954E+19";
        results[5][49]="4.730210572065213E-26";
        results[5][50]="466831930796205.5";
        results[5][51]="1.177389699953815E-31";
        results[5][52]="8365081701.561654";
        results[5][53]="2.452509046236414E-36";
        results[5][54]="34113.74731325223";
        results[5][55]="1.242121553179516E-20";
        results[5][56]="1.433837858906067E+28";
        results[5][57]="1.245862582824943E-25";
        results[5][58]="1.146048143060329E+23";
        results[5][59]="2.444573495698746E-30";
        results[5][60]="5.919516683291835E+18";
        results[5][61]="1.130050960271621E-35";
        results[5][62]="42321103301135.62";
        results[5][63]="9.611502550034045E-41";
        results[5][64]="442209784.7581557";
        results[5][65]="1.042815803460698E-24";
        results[5][66]="9.296815769522365E+31";
        results[5][67]="3.366222819772885E-29";
        results[5][68]="1.983340975437319E+27";
        results[5][69]="1.495116847249808E-34";
        results[5][70]="1.456226051200787E+22";
        results[5][71]="9.137094812685324E-40";
        results[5][72]="3.549312475498482E+17";
        results[5][73]="1.731380130517828E-44";
        results[5][74]="991281711273.9084";
        results[6][0]="0.0001284422746587108";
        results[6][1]="2.824292893609623E-10";
        results[6][2]="6.336801173682476E-15";
        results[6][3]="7.389401330167758E-20";
        results[6][4]="5.157567325787970E-25";
        results[6][5]="1.609129006682524E-9";
        results[6][6]="1";
        results[6][7]="1.543144681403597E-14";
        results[6][8]="0.000001474188376517659";
        results[6][9]="1.438431358140050E-19";
        results[6][10]="5.249645946137250E-11";
        results[6][11]="1.743112634004281E-24";
        results[6][12]="2.340525939904718E-16";
        results[6][13]="2.193130443091112E-29";
        results[6][14]="1.763438924942655E-21";
        results[6][15]="1.894367699610646E-13";
        results[6][16]="2176.250727612512";
        results[6][17]="2.242044654835111E-18";
        results[6][18]="0.01707948443348703";
        results[6][19]="1.445101657445832E-23";
        results[6][20]="5.779831867454199E-7";
        results[6][21]="2.694397747775916E-28";
        results[6][22]="3.320512258624031E-12";
        results[6][23]="2.953081405540270E-33";
        results[6][24]="1.758834949497607E-17";
        results[6][25]="1.760710877566955E-17";
        results[6][26]="47160165.97510373";
        results[6][27]="2.052599500138579E-22";
        results[6][28]="727.3156629906847";
        results[6][29]="3.503820798338526E-27";
        results[6][30]="0.001639167241274031";
        results[6][31]="4.275139211600108E-32";
        results[6][32]="3.332513055029883E-8";
        results[6][33]="1.839533197662788E-37";
        results[6][34]="8.816353178189703E-13";
        results[6][35]="2.164216619696854E-21";
        results[6][36]="456039546753.1217";
        results[6][37]="1.831097902883797E-26";
        results[6][38]="2231887.195695002";
        results[6][39]="1.951581054792877E-31";
        results[6][40]="40.46608073162718";
        results[6][41]="3.124447988106234E-36";
        results[6][42]="0.0001461381098851545";
        results[6][43]="5.636396886267384E-41";
        results[6][44]="3.838931922393911E-9";
        results[6][45]="4.943972717149220E-25";
        results[6][46]="2691790295382633";
        results[6][47]="1.797261089573547E-30";
        results[6][48]="22289632225.11453";
        results[6][49]="7.611519039226468E-35";
        results[6][50]="751192.8010897827";
        results[6][51]="1.894571918364917E-40";
        results[6][52]="13.46049560925206";
        results[6][53]="3.946403445450303E-45";
        results[6][54]="0.00005489342032839216";
        results[6][55]="1.998733821046708E-29";
        results[6][56]="2.307230089645316E+19";
        results[6][57]="2.004753620364024E-34";
        results[6][58]="184413931005301.8";
        results[6][59]="3.933634120896147E-39";
        results[6][60]="9525266000.626017";
        results[6][61]="1.818397779202506E-44";
        results[6][62]="68100.11491666482";
        results[6][63]="1.546614755106283E-49";
        results[6][64]="0.7115725916931837";
        results[6][65]="1.678025157975551E-33";
        results[6][66]="1.495977592452194E+23";
        results[6][67]="5.416686782253186E-38";
        results[6][68]="3.191451493718201E+18";
        results[6][69]="2.405835887289389E-43";
        results[6][70]="23432555792739.37";
        results[6][71]="1.470276429990037E-48";
        results[6][72]="571130165.8104760";
        results[6][73]="2.786013989610011E-53";
        results[6][74]="1595.100155404736";
        results[7][0]="8323411032.456378";
        results[7][1]="18302.19115320239";
        results[7][2]="0.4106420642242513";
        results[7][3]="0.000004788534360528390";
        results[7][4]="3.342244825091065E-11";
        results[7][5]="104275.9649224148";
        results[7][6]="64802737685647.92";
        results[7][7]="1";
        results[7][8]="95531442.66270503";
        results[7][9]="0.000009321428998035992";
        results[7][10]="3401.914291900572";
        results[7][11]="1.129584707779182E-10";
        results[7][12]="0.01516724885301000";
        results[7][13]="1.421208568140421E-15";
        results[7][14]="1.142756700777198E-7";
        results[7][15]="12.27602131180330";
        results[7][16]="1.410270050396740E+17";
        results[7][17]="0.0001452906316467887";
        results[7][18]="1106797349549.367";
        results[7][19]="9.364654363655727E-10";
        results[7][20]="37454892.83737830";
        results[7][21]="1.746043504699232E-14";
        results[7][22]="215.1782848775914";
        results[7][23]="1.913677596875906E-19";
        results[7][24]="0.001139773198646432";
        results[7][25]="0.001140988851392383";
        results[7][26]="3.056107864896266E+21";
        results[7][27]="1.330140669811724E-8";
        results[7][28]="4.713204612344845E+16";
        results[7][29]="2.270571800922490E-13";
        results[7][30]="106222524759.1882";
        results[7][31]="2.770407248989495E-18";
        results[7][32]="2159559.693390987";
        results[7][33]="1.192067872721828E-23";
        results[7][34]="57.13238223502557";
        results[7][35]="1.402471619011349E-7";
        results[7][36]="2.955261112252432E+25";
        results[7][37]="1.186601570773187E-12";
        results[7][38]="1.446324004865796E+20";
        results[7][39]="1.264677951660229E-17";
        results[7][40]="2622312814817888";
        results[7][41]="2.024727833856987E-22";
        results[7][42]="9470149600.764056";
        results[7][43]="3.652539489129880E-27";
        results[7][44]="248773.2983599527";
        results[7][45]="3.203829671144209E-11";
        results[7][46]="1.744353804164535E+29";
        results[7][47]="1.164674389402563E-16";
        results[7][48]="1.444429190193662E+24";
        results[7][49]="4.932472716883077E-21";
        results[7][50]="4.867935004036829E+19";
        results[7][51]="1.227734470523965E-26";
        results[7][52]="872276966085176.7";
        results[7][53]="2.557377472772532E-31";
        results[7][54]="3557243918.208811";
        results[7][55]="1.295234235087226E-15";
        results[7][56]="1.495148262797194E+33";
        results[7][57]="1.299135229848029E-20";
        results[7][58]="1.195052759651575E+28";
        results[7][59]="2.549102600877473E-25";
        results[7][60]="6.172633140245884E+23";
        results[7][61]="1.178371542938247E-30";
        results[7][62]="4.413073883307109E+18";
        results[7][63]="1.002248702759050E-35";
        results[7][64]="46111852003790.03";
        results[7][65]="1.087406241422075E-19";
        results[7][66]="9.694344350728666E+36";
        results[7][67]="3.510161326756695E-24";
        results[7][68]="2.068147939838898E+32";
        results[7][69]="1.559047519187323E-29";
        results[7][70]="1.518493766341199E+27";
        results[7][71]="9.527793781803528E-35";
        results[7][72]="3.701079831937688E+22";
        results[7][73]="1.805413337572430E-39";
        results[7][74]="1.033668569530294E+17";
        results[8][0]="87.12745040231444";
        results[8][1]="0.0001915829034197918";
        results[8][2]="4.298501653263149E-9";
        results[8][3]="5.012521769858929E-14";
        results[8][4]="3.498580919469208E-19";
        results[8][5]="0.001091535540718088";
        results[8][6]="678339.3601041740";
        results[8][7]="1.046775775731475E-8";
        results[8][8]="1";
        results[8][9]="9.757446070344992E-14";
        results[8][10]="0.00003561041471876213";
        results[8][11]="1.182421908739965E-18";
        results[8][12]="1.587670868382187E-10";
        results[8][13]="1.487686701391408E-23";
        results[8][14]="1.196210031928393E-15";
        results[8][15]="1.285024173155902E-7";
        results[8][16]="1476236525.994914";
        results[8][17]="1.520867136485833E-12";
        results[8][18]="11585.68654152080";
        results[8][19]="9.802693335972867E-18";
        results[8][20]="0.3920687450478594";
        results[8][21]="1.827716044092442E-22";
        results[8][22]="0.000002252434160733091";
        results[8][23]="2.003191350969721E-27";
        results[8][24]="1.193086974171064E-11";
        results[8][25]="1.194359490017227E-11";
        results[8][26]="31990596809958.51";
        results[8][27]="1.392359031474151E-16";
        results[8][28]="493366841.4268441";
        results[8][29]="2.376779558264652E-21";
        results[8][30]="1111.911657549550";
        results[8][31]="2.899995197153080E-26";
        results[8][32]="0.02260574773287777";
        results[8][33]="1.247827772192961E-31";
        results[8][34]="5.980479373345604E-7";
        results[8][35]="1.468073316931983E-15";
        results[8][36]="3.093495743267101E+17";
        results[8][37]="1.242105779730290E-20";
        results[8][38]="1513976932152.447";
        results[8][39]="1.323834243899629E-25";
        results[8][40]="27449735.30941583";
        results[8][41]="2.119436048930757E-30";
        results[8][42]="99.13123194632914";
        results[8][43]="3.823389857123776E-35";
        results[8][44]="0.002604098623720172";
        results[8][45]="3.353691289323497E-19";
        results[8][46]="1.825947306504481E+21";
        results[8][47]="1.219152937441450E-24";
        results[8][48]="1.511993486054156E+16";
        results[8][49]="5.163192954489619E-29";
        results[8][50]="509563644006.1053";
        results[8][51]="1.285162702774995E-34";
        results[8][52]="9130783.978265085";
        results[8][53]="2.677000787899666E-39";
        results[8][54]="37.23636761949100";
        results[8][55]="1.355819821187394E-23";
        results[8][56]="1.565084982623100E+25";
        results[8][57]="1.359903288004258E-28";
        results[8][58]="1.250952279524317E+20";
        results[8][59]="2.668338852452637E-33";
        results[8][60]="6461362843686697";
        results[8][61]="1.233490785959079E-38";
        results[8][62]="46194988375.59113";
        results[8][63]="1.049129663306469E-43";
        results[8][64]="482687.6965168229";
        results[8][65]="1.138270511899841E-27";
        results[8][66]="1.014780482794204E+29";
        results[8][67]="3.674351845758363E-32";
        results[8][68]="2.164887164052315E+24";
        results[8][69]="1.631973176299542E-37";
        results[8][70]="1.589522490205218E+19";
        results[8][71]="9.973463726956913E-43";
        results[8][72]="387420071212069.1";
        results[8][73]="1.889862946953332E-47";
        results[8][74]="1082019218.719317";
        results[9][0]="892932943458573.4";
        results[9][1]="1963453367.188511";
        results[9][2]="44053.55276650961";
        results[9][3]="0.5137124749367641";
        results[9][4]="0.000003585549839831714";
        results[9][5]="11186693042.92137";
        results[9][6]="6.952017517839994E+18";
        results[9][7]="107279.6885767942";
        results[9][8]="10248583418146.87";
        results[9][9]="1";
        results[9][10]="364956305.8000387";
        results[9][11]="0.00001211814956716597";
        results[9][12]="1627.137733517652";
        results[9][13]="1.524668125927760E-10";
        results[9][14]="0.01225945829784226";
        results[9][15]="1316967.743292346";
        results[9][16]="1.512933318157422E+22";
        results[9][17]="15.58673371619321";
        results[9][18]="1.187368749772774E+17";
        results[9][19]="0.0001004637203762303";
        results[9][20]="4018149239271.144";
        results[9][21]="1.873150034256679E-9";
        results[9][22]="23084259.39015671";
        results[9][23]="2.052987366292351E-14";
        results[9][24]="122.2745137989658";
        results[9][25]="122.4049286469690";
        results[9][26]="3.278583000031628E+26";
        results[9][27]="0.001426970768207302";
        results[9][28]="5.056311230110650E+21";
        results[9][29]="2.435862356942155E-8";
        results[9][30]="1.139551937600652E+16";
        results[9][31]="2.972084269024861E-13";
        results[9][32]="231676891369.9822";
        results[9][33]="1.278846701479992E-18";
        results[9][34]="6129144.173823912";
        results[9][35]="0.01504567185253299";
        results[9][36]="3.170394917855513E+30";
        results[9][37]="1.272982469772824E-7";
        results[9][38]="1.551611888231443E+25";
        results[9][39]="1.356742568040473E-12";
        results[9][40]="2.813209021245996E+20";
        results[9][41]="2.172121714689447E-17";
        results[9][42]="1015954699945620";
        results[9][43]="3.918432989082965E-22";
        results[9][44]="26688321974.27763";
        results[9][45]="0.000003437058493734438";
        results[9][46]="1.871337328785176E+34";
        results[9][47]="1.249459057884749E-11";
        results[9][48]="1.549579136952070E+29";
        results[9][49]="5.291541369807505E-16";
        results[9][50]="5.222305512451464E+24";
        results[9][51]="1.317109716528063E-21";
        results[9][52]="9.357760127432864E+19";
        results[9][53]="2.743546588523462E-26";
        results[9][54]="381620019737136.4";
        results[9][55]="1.389523253741598E-10";
        results[9][56]="1.603990400090178E+38";
        results[9][57]="1.393708228772385E-15";
        results[9][58]="1.282048878882594E+33";
        results[9][59]="2.734669331724314E-20";
        results[9][60]="6.621981609843777E+28";
        results[9][61]="1.264153321541716E-25";
        results[9][62]="4.734331918675705E+23";
        results[9][63]="1.075209287084869E-30";
        results[9][64]="4.946865122665819E+18";
        results[9][65]="1.166566029362225E-14";
        results[9][66]="1.040006242902376E+42";
        results[9][67]="3.765690139887650E-19";
        results[9][68]="2.218702669166555E+37";
        results[9][69]="1.672541323348396E-24";
        results[9][70]="1.629035383588871E+32";
        results[9][71]="1.022138749735799E-29";
        results[9][72]="3.970506917681290E+27";
        results[9][73]="1.936841806071609E-34";
        results[9][74]="1.108916422308302E+22";
        results[10][0]="2446684.518852554";
        results[10][1]="5.379968330412397";
        results[10][2]="0.0001207091152184304";
        results[10][3]="1.407599942164664E-9";
        results[10][4]="9.824600322966481E-15";
        results[10][5]="30.65214346248511";
        results[10][6]="19048903683.41529";
        results[10][7]="0.0002939521440563168";
        results[10][8]="28081.67239549524";
        results[10][9]="2.740054039641405E-9";
        results[10][10]="1";
        results[10][11]="3.320438467449187E-14";
        results[10][12]="0.000004458445319778002";
        results[10][13]="4.177673057560849E-19";
        results[10][14]="3.359157823281803E-11";
        results[10][15]="0.003608562785085618";
        results[10][16]="41455190501253.18";
        results[10][17]="4.270849268387010E-8";
        results[10][18]="325345453.9358852";
        results[10][19]="2.752760228542944E-13";
        results[10][20]="11009.94605494694";
        results[10][21]="5.132532318219450E-18";
        results[10][22]="0.06325211819412893";
        results[10][23]="5.625296326342124E-23";
        results[10][24]="3.350387754800450E-7";
        results[10][25]="3.353961192111453E-7";
        results[10][26]="8.983494593536299E+17";
        results[10][27]="3.909977017876616E-12";
        results[10][28]="13854566011748.89";
        results[10][29]="6.674394491149785E-17";
        results[10][30]="31224338.90003856";
        results[10][31]="8.143671507496243E-22";
        results[10][32]="634.8072020898827";
        results[10][33]="3.504109070472339E-27";
        results[10][34]="0.01679418625303079";
        results[10][35]="4.122595393865199E-11";
        results[10][36]="8.687053401928578E+21";
        results[10][37]="3.488040758693718E-16";
        results[10][38]="4.251500422304194E+16";
        results[10][39]="3.717547954312753E-21";
        results[10][40]="770834474302.0734";
        results[10][41]="5.951730878927634E-26";
        results[10][42]="2783770.779678667";
        results[10][43]="1.073671814080092E-30";
        results[10][44]="73.12744443686990";
        results[10][45]="9.417726010240848E-15";
        results[10][46]="5.127565407269577E+25";
        results[10][47]="3.423585338923651E-20";
        results[10][48]="4.245930573949562E+20";
        results[10][49]="1.449910930627067E-24";
        results[10][50]="1.430939931563421E+16";
        results[10][51]="3.608951799423663E-30";
        results[10][52]="256407684391.6768";
        results[10][53]="7.517465912828107E-35";
        results[10][54]="1045659.476688773";
        results[10][55]="3.807368804590335E-19";
        results[10][56]="4.395020375313125E+29";
        results[10][57]="3.818835862329240E-24";
        results[10][58]="3.512883209599986E+24";
        results[10][59]="7.493141749474667E-29";
        results[10][60]="1.814458746048353E+20";
        results[10][61]="3.463848415416480E-34";
        results[10][62]="1297232529877061";
        results[10][63]="2.946131550536850E-39";
        results[10][64]="13554677762.92165";
        results[10][65]="3.196453961262399E-23";
        results[10][66]="2.849673307116934E+33";
        results[10][67]="1.031819447983696E-27";
        results[10][68]="6.079365211412986E+28";
        results[10][69]="4.582853609507953E-33";
        results[10][70]="4.463644983521472E+23";
        results[10][71]="2.800715410287590E-38";
        results[10][72]="1.087940351921676E+19";
        results[10][73]="5.307051214872866E-43";
        results[10][74]="30384909225705.58";
        results[11][0]="7.368558528753992E+19";
        results[11][1]="162025840356721.7";
        results[11][2]="3635336609.961668";
        results[11][3]="42391.98997251724";
        results[11][4]="0.2958826196985332";
        results[11][5]="923135416089567.4";
        results[11][6]="5.736863932325467E+23";
        results[11][7]="8852811065.104166";
        results[11][8]="8.457218126697593E+17";
        results[11][9]="82520.84977639587";
        results[11][10]="30116504485873.39";
        results[11][11]="1";
        results[11][12]="134272788.4731154";
        results[11][13]="0.00001258169093785437";
        results[11][14]="1011.660916536231";
        results[11][15]="108677297304.5868";
        results[11][16]="1.248485430693727E+27";
        results[11][17]="1286230.511498665";
        results[11][18]="9.798267822918602E+21";
        results[11][19]="8.290351577144743";
        results[11][20]="3.315810897530334E+17";
        results[11][21]="0.0001545739325855462";
        results[11][22]="1904932701334.478";
        results[11][23]="1.694142620466497E-9";
        results[11][24]="10090196.78468630";
        results[11][25]="10100958.72876698";
        results[11][26]="2.705514552250553E+31";
        results[11][27]="117.7548403985430";
        results[11][28]="4.172510994426643E+26";
        results[11][29]="0.002010094316332011";
        results[11][30]="9.403679425514422E+20";
        results[11][31]="2.452589194869899E-8";
        results[11][32]="1.911817394940469E+16";
        results[11][33]="1.055315165398698E-13";
        results[11][34]="505782185625.9951";
        results[11][35]="1241.581626727822";
        results[11][36]="2.616236827482037E+35";
        results[11][37]="0.01050475951561086";
        results[11][38]="1.280403315400169E+30";
        results[11][39]="1.119595496425095E-7";
        results[11][40]="2.321483990318425E+25";
        results[11][41]="1.792453297139352E-12";
        results[11][42]="8.383744517383584E+19";
        results[11][43]="3.233524200509892E-17";
        results[11][44]="2202343008423450";
        results[11][45]="0.2836289876341450";
        results[11][46]="1.544243465896434E+39";
        results[11][47]="0.000001031064232174645";
        results[11][48]="1.278725871770590E+34";
        results[11][49]="4.366624904634691E-11";
        results[11][50]="4.309490886794513E+29";
        results[11][51]="1.086890130566436E-16";
        results[11][52]="7.722103177194344E+24";
        results[11][53]="2.263997958860880E-21";
        results[11][54]="3.149160832039346E+19";
        results[11][55]="0.00001146646396828192";
        results[11][56]="1.323626508486227E+43";
        results[11][57]="1.150099873786527E-10";
        results[11][58]="1.057957629402673E+38";
        results[11][59]="2.256672371113390E-15";
        results[11][60]="5.464515496479744E+33";
        results[11][61]="1.043190063412758E-20";
        results[11][62]="3.906810930526339E+28";
        results[11][63]="8.872718405771617E-26";
        results[11][64]="4.082195136515981E+23";
        results[11][65]="9.626602006324680E-10";
        results[11][66]="8.582219893706080E+46";
        results[11][67]="3.107479503381239E-14";
        results[11][68]="1.830892296607818E+42";
        results[11][69]="1.380195312888473E-19";
        results[11][70]="1.344293841695707E+37";
        results[11][71]="8.434775821758094E-25";
        results[11][72]="3.276496048901183E+32";
        results[11][73]="1.598298317194785E-29";
        results[11][74]="9.150872549988179E+26";
        results[12][0]="548775266570.8102";
        results[12][1]="1206691.558276256";
        results[12][2]="27.07426166761666";
        results[12][3]="0.0003157154212300068";
        results[12][4]="2.203593319712548E-9";
        results[12][5]="6875074.440525237";
        results[12][6]="4272543973773303";
        results[12][7]="65.93153509191260";
        results[12][8]="6298534664.297173";
        results[12][9]="0.0006145761230907817";
        results[12][10]="224293.4315161216";
        results[12][11]="7.447525380023099E-9";
        results[12][12]="1";
        results[12][13]="9.370246258327704E-14";
        results[12][14]="0.000007534370351881011";
        results[12][15]="809.3769299082260";
        results[12][16]="9.298126931680603E+18";
        results[12][17]="0.009579234378946397";
        results[12][18]="72972848291449.96";
        results[12][19]="6.174260378010000E-8";
        results[12][20]="2469458581.471433";
        results[12][21]="1.151193286020835E-12";
        results[12][22]="14187.03464042448";
        results[12][23]="1.261717016330308E-17";
        results[12][24]="0.07514699664337871";
        results[12][25]="0.07522714649505796";
        results[12][26]="2.014938829390782E+23";
        results[12][27]="8.769821624887181E-7";
        results[12][28]="3.107488152941784E+18";
        results[12][29]="1.497022843712283E-11";
        results[12][30]="7003414118711.969";
        results[12][31]="1.826572027556399E-16";
        results[12][32]="142383085.7078879";
        results[12][33]="7.859486478230080E-22";
        results[12][34]="3766.825664213152";
        results[12][35]="0.000009246710676425823";
        results[12][36]="1.948449017282359E+27";
        results[12][37]="7.823446310355102E-11";
        results[12][38]="9.535836188108477E+21";
        results[12][39]="8.338215874985453E-16";
        results[12][40]="1.728931093721377E+17";
        results[12][41]="1.334934142295141E-20";
        results[12][42]="624381500728.4375";
        results[12][43]="2.408175355021632E-25";
        results[12][44]="16402005.45075007";
        results[12][45]="2.112334083915552E-9";
        results[12][46]="1.150079240519853E+31";
        results[12][47]="7.678877037554697E-15";
        results[12][48]="9.523343384103629E+25";
        results[12][49]="3.252054980230781E-19";
        results[12][50]="3.209504275438039E+21";
        results[12][51]="8.094641832690152E-25";
        results[12][52]="5.751055939931189E+16";
        results[12][53]="1.686118225893689E-29";
        results[12][54]="234534552223.8769";
        results[12][55]="8.539678142289999E-14";
        results[12][56]="9.857742015622534E+34";
        results[12][57]="8.565397999586525E-19";
        results[12][58]="7.879166295965479E+29";
        results[12][59]="1.680662475826388E-23";
        results[12][60]="4.069711784956242E+25";
        results[12][61]="7.769184473454425E-29";
        results[12][62]="2.909607356004657E+20";
        results[12][63]="6.607979551678220E-34";
        results[12][64]="3040225188540963";
        results[12][65]="7.169436276548434E-18";
        results[12][66]="6.391630047531518E+38";
        results[12][67]="2.314303246933335E-22";
        results[12][68]="1.363561684707550E+34";
        results[12][69]="1.027903962212583E-27";
        results[12][70]="1.001166250423753E+29";
        results[12][71]="6.281820700734860E-33";
        results[12][72]="2.440178748173697E+24";
        results[12][73]="1.190336728215637E-37";
        results[12][74]="6.815135556539365E+18";
        results[13][0]="5.856572510920854E+24";
        results[13][1]="1.287790656733084E+19";
        results[13][2]="288938635348614.2";
        results[13][3]="3369339636.612199";
        results[13][4]="23516.92003563011";
        results[13][5]="7.337133145689837E+19";
        results[13][6]="4.559692302618115E+28";
        results[13][7]="703626492562206.3";
        results[13][8]="6.721845393016666E+22";
        results[13][9]="6558804391.555706";
        results[13][10]="2.393677021207241E+18";
        results[13][11]="79480.57259865707";
        results[13][12]="10672078112261.57";
        results[13][13]="1";
        results[13][14]="80407388.92198187";
        results[13][15]="8637733818243049";
        results[13][16]="9.923033691261843E+31";
        results[13][17]="102230337547.7774";
        results[13][18]="7.787719370405676E+26";
        results[13][19]="658921.8903956439";
        results[13][20]="2.635425487645780E+22";
        results[13][21]="12.28562467072543";
        results[13][22]="1.514051418639709E+17";
        results[13][23]="0.0001346514255384665";
        results[13][24]="801974618079.9959";
        results[13][25]="802829983557.8030";
        results[13][26]="2.150358457868733E+36";
        results[13][27]="9359222.141139671";
        results[13][28]="3.316335630112216E+31";
        results[13][29]="159.7634472393744";
        results[13][30]="7.474098252740968E+25";
        results[13][31]="0.001949331935575389";
        results[13][32]="1.519523412539414E+21";
        results[13][33]="8.387705361793504E-9";
        results[13][34]="4.019985772375435E+16";
        results[13][35]="98681618.62029944";
        results[13][36]="2.079400011019663E+40";
        results[13][37]="834.9243013119425";
        results[13][38]="1.017671886652243E+35";
        results[13][39]="0.008898609113474424";
        results[13][40]="1.845128768291237E+30";
        results[13][41]="1.424652144129865E-7";
        results[13][42]="6.663448147624991E+24";
        results[13][43]="2.570023549681410E-12";
        results[13][44]="1.750434833681448E+20";
        results[13][45]="22542.99434273927";
        results[13][46]="1.227373549011834E+44";
        results[13][47]="0.08194957555923548";
        results[13][48]="1.016338644850434E+39";
        results[13][49]="0.000003470618477439216";
        results[13][50]="3.425208032911223E+34";
        results[13][51]="8.638664992924948E-12";
        results[13][52]="6.137571821893155E+29";
        results[13][53]="1.799438541324536E-16";
        results[13][54]="2.502971061357505E+24";
        results[13][55]="0.9113611218809168";
        results[13][56]="1.052025928012465E+48";
        results[13][57]="0.000009141059651419642";
        results[13][58]="8.408707817004228E+42";
        results[13][59]="1.793616122236614E-10";
        results[13][60]="4.343228206344449E+38";
        results[13][61]="8.291334356927543E-16";
        results[13][62]="3.105155697929257E+33";
        results[13][63]="7.052087393973718E-21";
        results[13][64]="3.244552069097433E+28";
        results[13][65]="0.00007651278396420666";
        results[13][66]="6.821197513193451E+51";
        results[13][67]="2.469842502673314E-9";
        results[13][68]="1.455203681008597E+47";
        results[13][69]="1.096987137663585E-14";
        results[13][70]="1.068452442788232E+42";
        results[13][71]="6.704008120546416E-20";
        results[13][72]="2.604177820839036E+37";
        results[13][73]="1.270336654341115E-24";
        results[13][74]="7.273165900503936E+31";
        results[14][0]="7.283624788019671E+16";
        results[14][1]="160158248389.6609";
        results[14][2]="3593433.877438394";
        results[14][3]="41.90335840753915";
        results[14][4]="0.0002924721266406031";
        results[14][5]="912494889345.1759";
        results[14][6]="5.670737930617694E+20";
        results[14][7]="8750769.077266332";
        results[14][8]="835973594359440.8";
        results[14][9]="81.56967263194704";
        results[14][10]="29769366389.07392";
        results[14][11]="0.0009884734930986993";
        results[14][12]="132725.0922501232";
        results[14][13]="1.243666799042916E-8";
        results[14][14]="1";
        results[14][15]="107424627.6871908";
        results[14][16]="1.234094754760663E+24";
        results[14][17]="1271.404766631212";
        results[14][18]="9.685328021236938E+18";
        results[14][19]="0.008194792782476575";
        results[14][20]="327759118033654.3";
        results[14][21]="1.527922350848377E-7";
        results[14][22]="1882975481.406032";
        results[14][23]="1.674615073859902E-12";
        results[14][24]="9973.892061812134";
        results[14][25]="9984.529958270096";
        results[14][26]="2.674329420092467E+28";
        results[14][27]="0.1163975384180276";
        results[14][28]="4.124416517653632E+23";
        results[14][29]="0.000001986924950322545";
        results[14][30]="9.295287849718610E+17";
        results[14][31]="2.424319408589176E-11";
        results[14][32]="18897808185436.61";
        results[14][33]="1.043151067861683E-16";
        results[14][34]="499952283.7728221";
        results[14][35]="1.227270527538816";
        results[14][36]="2.586080755634628E+32";
        results[14][37]="0.00001038367633255766";
        results[14][38]="1.265644737748760E+27";
        results[14][39]="1.106690471208886E-10";
        results[14][40]="2.294725389082761E+22";
        results[14][41]="1.771792571839617E-15";
        results[14][42]="8.287109228345220E+16";
        results[14][43]="3.196252961497192E-20";
        results[14][44]="2176957686537.825";
        results[14][45]="0.0002803597361507711";
        results[14][46]="1.526443732929490E+36";
        results[14][47]="1.019179663186800E-9";
        results[14][48]="1.263986629184754E+31";
        results[14][49]="4.316292972536028E-14";
        results[14][50]="4.259817510346784E+26";
        results[14][51]="1.074362083975506E-19";
        results[14][52]="7.633094301629857E+21";
        results[14][53]="2.237901970763539E-24";
        results[14][54]="3.112862007975538E+16";
        results[14][55]="1.133429569221800E-8";
        results[14][56]="1.308369718401416E+40";
        results[14][57]="1.136843239654142E-13";
        results[14][58]="1.045763073486079E+35";
        results[14][59]="2.230660821453777E-18";
        results[14][60]="5.401528720897306E+30";
        results[14][61]="1.031165725947463E-23";
        results[14][62]="3.861779047373550E+25";
        results[14][63]="8.770446955834192E-29";
        results[14][64]="4.035141686102474E+20";
        results[14][65]="9.515640911862703E-13";
        results[14][66]="8.483296876872797E+43";
        results[14][67]="3.071661119439865E-17";
        results[14][68]="1.809788503915430E+39";
        results[14][69]="1.364286482089321E-22";
        results[14][70]="1.328798829452025E+34";
        results[14][71]="8.337552320037675E-28";
        results[14][72]="3.238729494581439E+29";
        results[14][73]="1.579875520611302E-32";
        results[14][74]="9.045394954387817E+23";
        results[15][0]="678021878.6728144";
        results[15][1]="1490.889490034119";
        results[15][2]="0.03345074546501661";
        results[15][3]="3.900721772064906E-7";
        results[15][4]="2.722579849122226E-12";
        results[15][5]="8494.280212934647";
        results[15][6]="5278806222284.789";
        results[15][7]="0.08145961746078984";
        results[15][8]="7781954.774781330";
        results[15][9]="7.593200403679254E-7";
        results[15][10]="277.1186368526144";
        results[15][11]="9.201553818525026E-12";
        results[15][12]="0.001235518289498798";
        results[15][13]="1.157711062927156E-16";
        results[15][14]="9.308852369606484E-9";
        results[15][15]="1";
        results[15][16]="1.148800588217273E+16";
        results[15][17]="0.00001183531927458393";
        results[15][18]="90159288700.90755";
        results[15][19]="7.628411621159118E-11";
        results[15][20]="3051061.242567714";
        results[15][21]="1.422320359626963E-15";
        results[15][22]="17.52834077199745";
        results[15][23]="1.558874449847949E-20";
        results[15][24]="0.00009284548875379919";
        results[15][25]="0.00009294451536144952";
        results[15][26]="2.489493775933610E+20";
        results[15][27]="1.083527501319018E-9";
        results[15][28]="3839358447360413";
        results[15][29]="1.849599103204027E-14";
        results[15][30]="8652846232.602745";
        results[15][31]="2.256763147132834E-19";
        results[15][32]="175916.9065073704";
        results[15][33]="9.710539289921761E-25";
        results[15][34]="4.653982001488808";
        results[15][35]="1.142448015842791E-8";
        results[15][36]="2.407344397008314E+24";
        results[15][37]="9.666011003355619E-14";
        results[15][38]="1.178170001607253E+19";
        results[15][39]="1.030201821533375E-18";
        results[15][40]="213612598757592.2";
        results[15][41]="1.649335548082038E-23";
        results[15][42]="771434763.7746916";
        results[15][43]="2.975344695449488E-28";
        results[15][44]="20264.97771886068";
        results[15][45]="2.609827394209354E-12";
        results[15][46]="1.420943936035166E+28";
        results[15][47]="9.487393022711177E-18";
        results[15][48]="1.176626492823741E+23";
        results[15][49]="4.017973406530782E-22";
        results[15][50]="3.965401232528285E+18";
        results[15][51]="1.000107803123075E-27";
        results[15][52]="71055347977156.85";
        results[15][53]="2.083229906348919E-32";
        results[15][54]="289771728.7920109";
        results[15][55]="1.055092853123241E-16";
        results[15][56]="1.217942055346239E+32";
        results[15][57]="1.058270588532557E-21";
        results[15][58]="9.734854064667849E+26";
        results[15][59]="2.076489227357834E-26";
        results[15][60]="5.028203343302236E+22";
        results[15][61]="9.598969511443032E-32";
        results[15][62]="3.594873103603994E+17";
        results[15][63]="8.164279592732510E-37";
        results[15][64]="3756253824637.292";
        results[15][65]="8.857969645071753E-21";
        results[15][66]="7.896975823435262E+35";
        results[15][67]="2.859363989032589E-25";
        results[15][68]="1.684705400315972E+31";
        results[15][69]="1.269994145161927E-30";
        results[15][70]="1.236959213227480E+26";
        results[15][71]="7.761304367110075E-36";
        results[15][72]="3.014885473014884E+21";
        results[15][73]="1.470682798372580E-40";
        results[15][74]="8420224625517956";
        results[16][0]="5.901998011029744E-8";
        results[16][1]="1.297779184068582E-13";
        results[16][2]="2.911797383123386E-18";
        results[16][3]="3.395473341564099E-23";
        results[16][4]="2.369932499205253E-28";
        results[16][5]="7.394042360403217E-13";
        results[16][6]="0.0004595058773843880";
        results[16][7]="7.090840507594115E-18";
        results[16][8]="6.773982233816134E-10";
        results[16][9]="6.609676632793603E-23";
        results[16][10]="2.412243166437193E-14";
        results[16][11]="8.009705002679486E-28";
        results[16][12]="1.075485425556837E-19";
        results[16][13]="1.007756328470993E-32";
        results[16][14]="8.103105504195564E-25";
        results[16][15]="8.704730918982346E-17";
        results[16][16]="1";
        results[16][17]="1.030232696254985E-21";
        results[16][18]="0.000007848123479882456";
        results[16][19]="6.640327050142802E-27";
        results[16][20]="2.655866713388787E-10";
        results[16][21]="1.238091601114291E-31";
        results[16][22]="1.525794898764651E-15";
        results[16][23]="1.356958262240303E-36";
        results[16][24]="8.081949966432234E-21";
        results[16][25]="8.090569966166392E-21";
        results[16][26]="21670.37344398340";
        results[16][27]="9.431815342299341E-26";
        results[16][28]="0.3342058218579424";
        results[16][29]="1.610026250138211E-30";
        results[16][30]="7.532069813813702E-7";
        results[16][31]="1.964451594366708E-35";
        results[16][32]="1.531309335246434E-11";
        results[16][33]="8.452763159697483E-41";
        results[16][34]="4.051166102474697E-16";
        results[16][35]="9.944702566836774E-25";
        results[16][36]="209552852.0527718";
        results[16][37]="8.414002484413322E-30";
        results[16][38]="1025.565284080813";
        results[16][39]="8.967629648693503E-35";
        results[16][40]="0.01859440193089382";
        results[16][41]="1.435702214116641E-39";
        results[16][42]="6.715132040207400E-8";
        results[16][43]="2.589957496510927E-44";
        results[16][44]="1.764011781218549E-12";
        results[16][45]="2.271784521158129E-28";
        results[16][46]="1236893461414.578";
        results[16][47]="8.258520338533136E-34";
        results[16][48]="10242217.01217658";
        results[16][49]="3.497537734347732E-38";
        results[16][50]="345.1775071495967";
        results[16][51]="8.705669316160942E-44";
        results[16][52]="0.006185176844958069";
        results[16][53]="1.813395577714413E-48";
        results[16][54]="2.522384927062784E-8";
        results[16][55]="9.184299380979178E-33";
        results[16][56]="1.060185786670131E+16";
        results[16][57]="9.211960712648993E-38";
        results[16][58]="84739285168.49519";
        results[16][59]="1.807527998031550E-42";
        results[16][60]="4376915.710937338";
        results[16][61]="8.355644669662702E-48";
        results[16][62]="31.29240305475972";
        results[16][63]="7.106785700207527E-53";
        results[16][64]="0.0003269717880686592";
        results[16][65]="7.710624224886317E-37";
        results[16][66]="6.874104961671300E+19";
        results[16][67]="2.488999412395668E-41";
        results[16][68]="1466490718750697";
        results[16][69]="1.105495730231758E-46";
        results[16][70]="10767397108.90133";
        results[16][71]="6.756006609601578E-52";
        results[16][72]="262437.6679414338";
        results[16][73]="1.280189802700927E-56";
        results[16][74]="0.7329578964252270";
        results[17][0]="57288009131181.63";
        results[17][1]="125969520.1662847";
        results[17][2]="2826.349225478968";
        results[17][3]="0.03295831469829135";
        results[17][4]="2.300385638914618E-7";
        results[17][5]="717706047.1174538";
        results[17][6]="4.460214464700500E+17";
        results[17][7]="6882.756229121966";
        results[17][8]="657519632063.7410";
        results[17][9]="0.06415712350055034";
        results[17][10]="23414546.78351770";
        results[17][11]="7.774656183788081E-7";
        results[17][12]="104.3924765216976";
        results[17][13]="9.781832125249994E-12";
        results[17][14]="0.0007865315800645127";
        results[17][15]="84492.86215264814";
        results[17][16]="9.706544974112313E+20";
        results[17][17]="1";
        results[17][18]="7617816351986589";
        results[17][19]="0.000006445463315502565";
        results[17][20]="257792896987.5612";
        results[17][21]="1.201759180828659E-10";
        results[17][22]="1481019.680613023";
        results[17][23]="1.317137640042879E-15";
        results[17][24]="7.844781082769998";
        results[17][25]="7.853148124279642";
        results[17][26]="2.103444544398340E+25";
        results[17][27]="0.00009155033980755107";
        results[17][28]="3.243983840474286E+20";
        results[17][29]="1.562779220646795E-9";
        results[17][30]="731103743959364.5";
        results[17][31]="1.906803775018709E-14";
        results[17][32]="14863722931.84754";
        results[17][33]="8.204712576512332E-20";
        results[17][34]="393228.2597126994";
        results[17][35]="0.0009652870271917130";
        results[17][36]="2.034034182903733E+29";
        results[17][37]="8.167089352725064E-9";
        results[17][38]="9.954695553818683E+23";
        results[17][39]="8.704470049622648E-14";
        results[17][40]="1.804873986089417E+19";
        results[17][41]="1.393570811075580E-18";
        results[17][42]="65180731155375.70";
        results[17][43]="2.513953892092264E-23";
        results[17][44]="1712245968.926182";
        results[17][45]="2.205117862611359E-7";
        results[17][46]="1.200596201140605E+33";
        results[17][47]="8.016169908559313E-13";
        results[17][48]="9.941654006331020E+27";
        results[17][49]="3.394900731710114E-17";
        results[17][50]="3.350480997199534E+23";
        results[17][51]="8.450197074706576E-23";
        results[17][52]="6.003669721842360E+18";
        results[17][53]="1.760180573094133E-27";
        results[17][54]="24483642736557.92";
        results[17][55]="8.914781499718627E-12";
        results[17][56]="1.029074101922827E+37";
        results[17][57]="8.941631095708316E-17";
        results[17][58]="8.225256825621270E+31";
        results[17][59]="1.754485180486043E-21";
        results[17][60]="4.248472919611204E+27";
        results[17][61]="8.110444077378283E-27";
        results[17][62]="3.037411175990747E+22";
        results[17][63]="6.898233502044262E-32";
        results[17][64]="3.173766366154361E+17";
        results[17][65]="7.484352081733892E-16";
        results[17][66]="6.672380896723107E+40";
        results[17][67]="2.415958473695767E-20";
        results[17][68]="1.423455811567193E+36";
        results[17][69]="1.073054402418369E-25";
        results[17][70]="1.045142242916776E+31";
        results[17][71]="6.557748200149776E-31";
        results[17][72]="2.547363026774680E+26";
        results[17][73]="1.242621989531652E-35";
        results[17][74]="7.114488785782220E+20";
        results[18][0]="0.007520266502124582";
        results[18][1]="1.653617183005917E-8";
        results[18][2]="3.710182938109170E-13";
        results[18][3]="4.326477979440449E-18";
        results[18][4]="3.019744153210938E-23";
        results[18][5]="9.421414404802356E-8";
        results[18][6]="58.54977671570353";
        results[18][7]="9.035077653620603E-13";
        results[18][8]="0.00008631340028199442";
        results[18][9]="8.421983483996608E-18";
        results[18][10]="3.073655979828342E-9";
        results[18][11]="1.020588555112725E-22";
        results[18][12]="1.370372711787334E-14";
        results[18][13]="1.284072977513965E-27";
        results[18][14]="1.032489553071727E-19";
        results[18][15]="1.109148058296442E-11";
        results[18][16]="127418.9941790999";
        results[18][17]="1.312712139272323E-16";
        results[18][18]="1";
        results[18][19]="8.461037937494653E-22";
        results[18][20]="0.00003384078652937511";
        results[18][21]="1.577563865155743E-26";
        results[18][22]="1.944152513241934E-10";
        results[18][23]="1.729022569176787E-31";
        results[18][24]="1.029793935728606E-15";
        results[18][25]="1.030892287424556E-15";
        results[18][26]="2761217187.717842";
        results[18][27]="1.201792424198785E-20";
        results[18][28]="42584.16966993846";
        results[18][29]="2.051479253945588E-25";
        results[18][30]="0.09597287597629022";
        results[18][31]="2.503084462677351E-30";
        results[18][32]="0.000001951178952741667";
        results[18][33]="1.077042579842804E-35";
        results[18][34]="5.161955100297903E-11";
        results[18][35]="1.267143998476655E-19";
        results[18][36]="26701013635925.91";
        results[18][37]="1.072103733584393E-24";
        results[18][38]="130676496.9625801";
        results[18][39]="1.142646350007201E-29";
        results[18][40]="2369.279991396404";
        results[18][41]="1.829357320634491E-34";
        results[18][42]="0.008556353703430740";
        results[18][43]="3.300097791720419E-39";
        results[18][44]="2.247686068829500E-7";
        results[18][45]="2.894684986776169E-23";
        results[18][46]="1.576037207601508E+17";
        results[18][47]="1.052292354943532E-28";
        results[18][48]="1305052989855.606";
        results[18][49]="4.456527402140359E-33";
        results[18][50]="43982170.77425067";
        results[18][51]="1.109267627921080E-38";
        results[18][52]="788.1090124044157";
        results[18][53]="2.310610405611983E-43";
        results[18][54]="0.003213997503388622";
        results[18][55]="1.170254189364097E-27";
        results[18][56]="1.350878065804859E+21";
        results[18][57]="1.173778768423119E-32";
        results[18][58]="1.079739448362558E+16";
        results[18][59]="2.303133994597421E-37";
        results[18][60]="557702197494.3356";
        results[18][61]="1.064667839526379E-42";
        results[18][62]="3987246.522684476";
        results[18][63]="9.055394857668533E-48";
        results[18][64]="41.66241636065038";
        results[18][65]="9.824799832280163E-32";
        results[18][66]="8.758915400977171E+24";
        results[18][67]="3.171458016398266E-36";
        results[18][68]="1.868587723561991E+20";
        results[18][69]="1.408611540154202E-41";
        results[18][70]="1371970909543155";
        results[18][71]="8.608435668627840E-47";
        results[18][72]="33439543683.80610";
        results[18][73]="1.631204970184925E-51";
        results[18][74]="93392.75793813131";
        results[19][0]="8.888113441495055E+18";
        results[19][1]="19543904603925.69";
        results[19][2]="438502104.0583787";
        results[19][3]="5113.412812236528";
        results[19][4]="0.03568999661175253";
        results[19][5]="111350575123317.2";
        results[19][6]="6.919928399829436E+22";
        results[19][7]="1067845070.589050";
        results[19][8]="1.020127801336300E+17";
        results[19][9]="9953.842006398556";
        results[19][10]="3632717407172.463";
        results[19][11]="0.1206221462014772";
        results[19][12]="16196271.92208414";
        results[19][13]="0.000001517630563767670";
        results[19][14]="122.0287109807536";
        results[19][15]="13108888844.25527";
        results[19][16]="1.505949921515530E+26";
        results[19][17]="155147.8848067927";
        results[19][18]="1.181888093857317E+21";
        results[19][19]="1";
        results[19][20]="3.999602268583552E+16";
        results[19][21]="0.00001864503949527103";
        results[19][22]="229777070804.3422";
        results[19][23]="2.043511188520634E-10";
        results[19][24]="1217101.191764106";
        results[19][25]="1218399.320556418";
        results[19][26]="3.263449718717902E+30";
        results[19][27]="14.20384157448466";
        results[19][28]="5.032972311970014E+25";
        results[19][29]="0.0002424618905033581";
        results[19][30]="1.134291994496223E+20";
        results[19][31]="2.958365724357601E-9";
        results[19][32]="2306075173230364";
        results[19][33]="1.272943801693578E-14";
        results[19][34]="61008532740.68144";
        results[19][35]="149.7622405002312";
        results[19][36]="3.155761011022271E+34";
        results[19][37]="0.001267106638103371";
        results[19][38]="1.544449959070552E+29";
        results[19][39]="1.350480116563032E-8";
        results[19][40]="2.800223812845777E+24";
        results[19][41]="2.162095636668628E-13";
        results[19][42]="1.011265256891675E+19";
        results[19][43]="3.900346288599187E-18";
        results[19][44]="265651340347854.4";
        results[19][45]="0.03421193721338280";
        results[19][46]="1.862699611140355E+38";
        results[19][47]="1.243691805564838E-7";
        results[19][48]="1.542426590563234E+33";
        results[19][49]="5.267116676538570E-12";
        results[19][50]="5.198200398008612E+28";
        results[19][51]="1.311030202341272E-17";
        results[19][52]="9.314566584224275E+23";
        results[19][53]="2.730882927935629E-22";
        results[19][54]="3.798585382942154E+18";
        results[19][55]="0.000001383109493196072";
        results[19][56]="1.596586702227764E+42";
        results[19][57]="1.387275151221789E-11";
        results[19][58]="1.276131198487774E+37";
        results[19][59]="2.722046646772734E-16";
        results[19][60]="6.591415871366172E+32";
        results[19][61]="1.258318243449020E-21";
        results[19][62]="4.712479192434771E+27";
        results[19][63]="1.070246336745521E-26";
        results[19][64]="4.924031385797897E+22";
        results[19][65]="1.161181394630329E-10";
        results[19][66]="1.035205782751841E+46";
        results[19][67]="3.748308469749455E-15";
        results[19][68]="2.208461582805865E+41";
        results[19][69]="1.664821208178269E-20";
        results[19][70]="1.621516083107649E+36";
        results[19][71]="1.017420762348790E-25";
        results[19][72]="3.952179854391208E+31";
        results[19][73]="1.927901732902443E-30";
        results[19][74]="1.103797886595758E+26";
        results[20][0]="222.2249324966694";
        results[20][1]="0.0004886462025847162";
        results[20][2]="1.096364274774934E-8";
        results[20][3]="1.278480326006873E-13";
        results[20][4]="8.923386430719285E-19";
        results[20][5]="0.002784041203245736";
        results[20][6]="1730154.134120969";
        results[20][7]="2.669878150077217E-8";
        results[20][8]="2.550573114105107";
        results[20][9]="2.488707960935246E-13";
        results[20][10]="0.00009082696636380747";
        results[20][11]="3.015853529960997E-18";
        results[20][12]="4.049470630943514E-10";
        results[20][13]="3.794453702780639E-23";
        results[20][14]="3.051021146259370E-15";
        results[20][15]="3.277548107026588E-7";
        results[20][16]="3765249193.262553";
        results[20][17]="3.879082828446787E-12";
        results[20][18]="29550.14060125232";
        results[20][19]="2.500248606854969E-17";
        results[20][20]="1";
        results[20][21]="4.661723402280728E-22";
        results[20][22]="0.000005744998011657722";
        results[20][23]="5.109286002191258E-27";
        results[20][24]="3.043055559109729E-11";
        results[20][25]="3.046301203814225E-11";
        results[20][26]="81594356127656.76";
        results[20][27]="3.551313510859396E-16";
        results[20][28]="1258368201.134266";
        results[20][29]="6.062150039464433E-21";
        results[20][30]="2836.011979005927";
        results[20][31]="7.396649780892585E-26";
        results[20][32]="0.05765761239172050";
        results[20][33]="3.182675966789038E-31";
        results[20][34]="0.000001525364989911545";
        results[20][35]="3.744428331701820E-15";
        results[20][36]="7.890187071375662E+17";
        results[20][37]="3.168081606654638E-20";
        results[20][38]="3861508858523.363";
        results[20][39]="3.376536030022057E-25";
        results[20][40]="70012556.86949763";
        results[20][41]="5.405776603467944E-30";
        results[20][42]="252.8414549704244";
        results[20][43]="9.751835374322068E-35";
        results[20][44]="0.006641943936138782";
        results[20][45]="8.553834835557002E-19";
        results[20][46]="4.657212107742966E+21";
        results[20][47]="3.109538704220428E-24";
        results[20][48]="3.856449934231786E+16";
        results[20][49]="1.316910113265814E-28";
        results[20][50]="1299679330327.398";
        results[20][51]="3.277901436948555E-34";
        results[20][52]="23288732.12566459";
        results[20][53]="6.827886236055077E-39";
        results[20][54]="94.97407811720772";
        results[20][55]="3.458117583491362E-23";
        results[20][56]="3.991863677968137E+25";
        results[20][57]="3.468532764166796E-28";
        results[20][58]="3.190645251183220E+20";
        results[20][59]="6.805793336387770E-33";
        results[20][60]="1.648017834958501E+16";
        results[20][61]="3.146108435163604E-38";
        results[20][62]="117823695357.1807";
        results[20][63]="2.675881912439624E-43";
        results[20][64]="1231130.261245134";
        results[20][65]="2.903242164230390E-27";
        results[20][66]="2.588271816133498E+29";
        results[20][67]="9.371703029553756E-32";
        results[20][68]="5.521702995703085E+24";
        results[20][69]="4.162466906410325E-37";
        results[20][70]="4.054193327782826E+19";
        results[20][71]="2.543804843647882E-42";
        results[20][72]="988143217498189.4";
        results[20][73]="4.820233621842614E-47";
        results[20][74]="2759769128.210504";
        results[21][0]="4.767012396916274E+23";
        results[21][1]="1.048209343234839E+18";
        results[21][2]="23518432565916.35";
        results[21][3]="274250575.5235032";
        results[21][4]="1914.181872385126";
        results[21][5]="5.972128680744241E+18";
        results[21][6]="3.711404527506926E+27";
        results[21][7]="57272341571595.42";
        results[21][8]="5.471309415005725E+21";
        results[21][9]="533860065.5108917";
        results[21][10]="1.948355973230217E+17";
        results[21][11]="6469.396121798011";
        results[21][12]="868663857010.9776";
        results[21][13]="0.08139594255901624";
        results[21][14]="6544835.210014115";
        results[21][15]="703076485709783.2";
        results[21][16]="8.076946803451319E+30";
        results[21][17]="8321134682.827734";
        results[21][18]="6.338887585392785E+25";
        results[21][19]="53633.56834152223";
        results[21][20]="2.145129416109833E+21";
        results[21][21]="1";
        results[21][22]="1.232376423029948E+16";
        results[21][23]="0.00001096007969861868";
        results[21][24]="65277479947.02833";
        results[21][25]="65347103226.32689";
        results[21][26]="1.750304535179781E+35";
        results[21][27]="761802.7077972777";
        results[21][28]="2.699362644550329E+30";
        results[21][29]="13.00409637452654";
        results[21][30]="6.083612720605475E+24";
        results[21][31]="0.0001586677102565503";
        results[21][32]="1.236830404041385E+20";
        results[21][33]="6.827251838304966E-10";
        results[21][34]="3272105310163334";
        results[21][35]="8032283.360848641";
        results[21][36]="1.692547238541742E+39";
        results[21][37]="67.95945047071364";
        results[21][38]="8.283436242987168E+33";
        results[21][39]="0.0007243106762555027";
        results[21][40]="1.501859952378219E+29";
        results[21][41]="1.159609040901739E-8";
        results[21][42]="5.423776426690670E+23";
        results[21][43]="2.091894892251871E-13";
        results[21][44]="1.424782931756363E+19";
        results[21][45]="1834.908272629834";
        results[21][46]="9.990322689382312E+42";
        results[21][47]="0.006670362944955292";
        results[21][48]="8.272584195675434E+37";
        results[21][49]="2.824942622339028E-7";
        results[21][50]="2.787980362995230E+33";
        results[21][51]="7.031522795507035E-13";
        results[21][52]="4.995734434666519E+28";
        results[21][53]="1.464669961481319E-17";
        results[21][54]="2.037316887371354E+23";
        results[21][55]="0.07418109752713971";
        results[21][56]="8.563064200709839E+46";
        results[21][57]="7.440451663154942E-7";
        results[21][58]="6.844346984684270E+41";
        results[21][59]="1.459930748584969E-11";
        results[21][60]="3.535211536043119E+37";
        results[21][61]="6.748809750540721E-17";
        results[21][62]="2.527470748254518E+32";
        results[21][63]="5.740113004410473E-22";
        results[21][64]="2.640933738459919E+27";
        results[21][65]="0.000006227830168580984";
        results[21][66]="5.552178009675986E+50";
        results[21][67]="2.010351584774140E-10";
        results[21][68]="1.184476752310447E+46";
        results[21][69]="8.929030204524482E-16";
        results[21][70]="8.696769366023154E+40";
        results[21][71]="5.456790598951745E-21";
        results[21][72]="2.119695083184782E+36";
        results[21][73]="1.034002493473623E-25";
        results[21][74]="5.920061938596140E+30";
        results[22][0]="38681463.77870482";
        results[22][1]="85.05593937424482";
        results[22][2]="0.001908380599175486";
        results[22][3]="2.225379927743381E-8";
        results[22][4]="1.553244476779973E-13";
        results[22][5]="484.6026400002877";
        results[22][6]="301158352119.5565";
        results[22][7]="0.004647309093335652";
        results[22][8]="443964.1421858626";
        results[22][9]="4.331956174545530E-8";
        results[22][10]="15.80974722349805";
        results[22][11]="5.249529284155089E-13";
        results[22][12]="0.00007048689351547812";
        results[22][13]="6.604795502245522E-18";
        results[22][14]="5.310743606992122E-10";
        results[22][15]="0.05705046547232572";
        results[22][16]="655396082926770.0";
        results[22][17]="6.752104736286019E-7";
        results[22][18]="5143629387.040573";
        results[22][19]="4.352044338016266E-12";
        results[22][20]="174064.4640730606";
        results[22][21]="8.114403856748394E-17";
        results[22][22]="1";
        results[22][23]="8.893451297674116E-22";
        results[22][24]="0.000005296878350409827";
        results[22][25]="0.000005302527864470423";
        results[22][26]="1.420267787074702E+19";
        results[22][27]="6.181574830231600E-11";
        results[22][28]="219037186537017.3";
        results[22][29]="1.055204897749860E-15";
        results[22][30]="493648905.2304466";
        results[22][31]="1.287493880047189E-20";
        results[22][32]="10036.14140069709";
        results[22][33]="5.539907864773438E-26";
        results[22][34]="0.2655118394847626";
        results[22][35]="6.517719108176616E-10";
        results[22][36]="1.373401184015196E+23";
        results[22][37]="5.514504270020602E-15";
        results[22][38]="6.721514699722450E+17";
        results[22][39]="5.877349344891688E-20";
        results[22][40]="12186698189873.78";
        results[22][41]="9.409536073813374E-25";
        results[22][42]="44010712.35487979";
        results[22][43]="1.697447998160085E-29";
        results[22][44]="1156.126411647312";
        results[22][45]="1.488918676420706E-13";
        results[22][46]="8.106551296088482E+26";
        results[22][47]="5.412601880645680E-19";
        results[22][48]="6.712708910266456E+21";
        results[22][49]="2.292272530980073E-23";
        results[22][50]="2.262279861002728E+17";
        results[22][51]="5.705661569067654E-29";
        results[22][52]="4053740676394.876";
        results[22][53]="1.188492358430754E-33";
        results[22][54]="16531612.00830475";
        results[22][55]="6.019353838720512E-18";
        results[22][56]="6.948416117582402E+30";
        results[22][57]="6.037482967145447E-23";
        results[22][58]="5.553779556944628E+25";
        results[22][59]="1.184646769690344E-27";
        results[22][60]="2.868613412248970E+21";
        results[22][61]="5.476256786824880E-33";
        results[22][62]="2.050891838745521E+16";
        results[22][63]="4.657759510115996E-38";
        results[22][64]="214296029127.7612";
        results[22][65]="5.053512913910754E-22";
        results[22][66]="4.505261465506844E+34";
        results[22][67]="1.631280465291153E-26";
        results[22][68]="9.611322727176706E+29";
        results[22][69]="7.245375712861636E-32";
        results[22][70]="7.056909888490957E+24";
        results[22][71]="4.427860268160242E-37";
        results[22][72]="1.720006195812521E+20";
        results[22][73]="8.390313820929822E-42";
        results[22][74]="480377734267339.0";
        results[23][0]="4.349432237720928E+28";
        results[23][1]="9.563884315247705E+22";
        results[23][2]="2.145826783438484E+18";
        results[23][3]="25022680771022.83";
        results[23][4]="174650360.6745100";
        results[23][5]="5.448982895167197E+23";
        results[23][6]="3.386293375197521E+32";
        results[23][7]="5.225540611608288E+18";
        results[23][8]="4.992034333194938E+26";
        results[23][9]="48709505787460.23";
        results[23][10]="1.777684128953709E+22";
        results[23][11]="590269076.4751797";
        results[23][12]="7.925707484777299E+16";
        results[23][13]="7426.583090383436";
        results[23][14]="597152154909.8750";
        results[23][15]="6.414884791379698E+19";
        results[23][16]="7.369423421683034E+35";
        results[23][17]="759222096156514.8";
        results[23][18]="5.783614498890633E+30";
        results[23][19]="4893538169.095777";
        results[23][20]="1.957220636251567E+26";
        results[23][21]="91240.21243440706";
        results[23][22]="1.124422866364071E+21";
        results[23][23]="1";
        results[23][24]="5955931137549612";
        results[23][25]="5962283580343192";
        results[23][26]="1.596981576147093E+40";
        results[23][27]="69507040892.53014";
        results[23][28]="2.462904211262749E+35";
        results[23][29]="1186496.515729304";
        results[23][30]="5.550701169967046E+29";
        results[23][31]="14.47687559028860";
        results[23][32]="1.128486688100694E+25";
        results[23][33]="0.00006229199080701412";
        results[23][34]="2.985475836070540E+20";
        results[23][35]="732867240177.1831";
        results[23][36]="1.544283695998176E+44";
        results[23][37]="6200634.697873477";
        results[23][38]="7.557824824970159E+38";
        results[23][39]="66.08625997006110";
        results[23][40]="1.370300211017172E+34";
        results[23][41]="0.001058029752327336";
        results[23][42]="4.948665133679859E+28";
        results[23][43]="1.908649343595118E-8";
        results[23][44]="1.299974973663679E+24";
        results[23][45]="167417420.5923969";
        results[23][46]="9.115191644675190E+47";
        results[23][47]="608.6053321123179";
        results[23][48]="7.547923393949451E+42";
        results[23][49]="0.02577483649772239";
        results[23][50]="2.543759205826400E+38";
        results[23][51]="6.415576335994377E-8";
        results[23][52]="4.558118710848557E+33";
        results[23][53]="1.336367984318503E-12";
        results[23][54]="1.858852255999673E+28";
        results[23][55]="6768.299096993695";
        results[23][56]="7.812957967622318E+51";
        results[23][57]="0.06788683903541942";
        results[23][58]="6.244796728573862E+46";
        results[23][59]="0.000001332043916404155";
        results[23][60]="3.225534515491407E+42";
        results[23][61]="6.157628353187331E-12";
        results[23][62]="2.306069679924920E+37";
        results[23][63]="5.237291299199141E-17";
        results[23][64]="2.409593553222759E+32";
        results[23][65]="0.5682285475867381";
        results[23][66]="5.065819010764803E+55";
        results[23][67]="0.00001834249056626394";
        results[23][68]="1.080719105044218E+51";
        results[23][69]="8.146866126940509E-11";
        results[23][70]="7.934950844489962E+45";
        results[23][71]="4.978787334584325E-16";
        results[23][72]="1.934014296859477E+41";
        results[23][73]="9.434260716223996E-21";
        results[23][74]="5.401477089023595E+35";
        results[24][0]="7302690607518.291";
        results[24][1]="16057748.30899485";
        results[24][2]="360.2840150232697";
        results[24][3]="0.004201304580784266";
        results[24][4]="2.932377098408908E-8";
        results[24][5]="91488346.14311905";
        results[24][6]="5.685581812469896E+16";
        results[24][7]="877.3675334597941";
        results[24][8]="83816186216.83326";
        results[24][9]="0.008178319168327438";
        results[24][10]="2984729.151326427";
        results[24][11]="9.910609488981233E-8";
        results[24][12]="13.30725171553627";
        results[24][13]="1.246922255961287E-12";
        results[24][14]="0.0001002617627905542";
        results[24][15]="10770.58253903672";
        results[24][16]="1.237325155628808E+20";
        results[24][17]="0.1274732831227585";
        results[24][18]="971068060613965.9";
        results[24][19]="8.216243700744122E-7";
        results[24][20]="32861706944.73151";
        results[24][21]="1.531921883031460E-11";
        results[24][22]="188790.4410571613";
        results[24][23]="1.678998593008280E-16";
        results[24][24]="1";
        results[24][25]="1.001066574251259";
        results[24][26]="2.681329819411114E+24";
        results[24][27]="0.00001167022238627271";
        results[24][28]="4.135212705424321E+19";
        results[24][29]="1.992125980518727E-10";
        results[24][30]="93196194545840.82";
        results[24][31]="2.430665374725046E-15";
        results[24][32]="1894727561.549639";
        results[24][33]="1.045881649206614E-20";
        results[24][34]="50126.09728222654";
        results[24][35]="0.0001230483065119351";
        results[24][36]="2.592850152786563E+28";
        results[24][37]="1.041085693348789E-9";
        results[24][38]="1.268957724732794E+23";
        results[24][39]="1.109587375069120E-14";
        results[24][40]="2.300732126296780E+18";
        results[24][41]="1.776430465518496E-19";
        results[24][42]="8308801796717.613";
        results[24][43]="3.204619562442379E-24";
        results[24][44]="218265615.1727291";
        results[24][45]="2.810936136197098E-8";
        results[24][46]="1.530439394641047E+32";
        results[24][47]="1.021847496313918E-13";
        results[24][48]="1.267295275857541E+27";
        results[24][49]="4.327591421469434E-18";
        results[24][50]="4.270968127534385E+22";
        results[24][51]="1.077174364147177E-23";
        results[24][52]="7.653074902279439E+17";
        results[24][53]="2.243759965412078E-28";
        results[24][54]="3121010322433.718";
        results[24][55]="1.136396466091162E-12";
        results[24][56]="1.311794543487070E+36";
        results[24][57]="1.139819072242488E-17";
        results[24][58]="1.048500492089822E+31";
        results[24][59]="2.236499861467814E-22";
        results[24][60]="5.415667913209714E+26";
        results[24][61]="1.033864934126942E-27";
        results[24][62]="3.871887747972994E+21";
        results[24][63]="8.793404722529862E-33";
        results[24][64]="4.045704185582832E+16";
        results[24][65]="9.540549319052715E-17";
        results[24][66]="8.505502991508699E+39";
        results[24][67]="3.079701585302480E-21";
        results[24][68]="1.814525856806408E+35";
        results[24][69]="1.367857676455993E-26";
        results[24][70]="1.332277130348850E+30";
        results[24][71]="8.359376929654525E-32";
        results[24][72]="3.247207283284959E+25";
        results[24][73]="1.584011046861337E-36";
        results[24][74]="9.069072432637074E+19";
        results[25][0]="7294910044299.792";
        results[25][1]="16040639.77563644";
        results[25][2]="359.9001547851519";
        results[25][3]="0.004196828351727361";
        results[25][4]="2.929252832762058E-8";
        results[25][5]="91390870.99331748";
        results[25][6]="5.679524178222003E+16";
        results[25][7]="876.4327528526417";
        results[25][8]="83726885276.85887";
        results[25][9]="0.008169605677269126";
        results[25][10]="2981549.107819164";
        results[25][11]="9.900050350191554E-8";
        results[25][12]="13.29307366544463";
        results[25][13]="1.245593737753071E-12";
        results[25][14]="0.0001001549401102962";
        results[25][15]="10759.10715238146";
        results[25][16]="1.236006862534849E+20";
        results[25][17]="0.1273374682578942";
        results[25][18]="970033447915559.5";
        results[25][19]="8.207489803452292E-7";
        results[25][20]="32826694837.26416";
        results[25][21]="1.530289715424023E-11";
        results[25][22]="188589.2965693774";
        results[25][23]="1.677209724302378E-16";
        results[25][24]="0.9989345621173533";
        results[25][25]="1";
        results[25][26]="2.678473029045643E+24";
        results[25][27]="0.00001165778848924346";
        results[25][28]="4.130806893155160E+19";
        results[25][29]="1.990003494032078E-10";
        results[25][30]="93096899789653.17";
        results[25][31]="2.428075651754777E-15";
        results[25][32]="1892708847.028269";
        results[25][33]="1.044767327276784E-20";
        results[25][34]="50072.69103927282";
        results[25][35]="0.0001229172061847818";
        results[25][36]="2.590087632009758E+28";
        results[25][37]="1.039976481212013E-9";
        results[25][38]="1.267605729101387E+23";
        results[25][39]="1.108405178645614E-14";
        results[25][40]="2.298280839131601E+18";
        results[25][41]="1.774537789204645E-19";
        results[25][42]="8299949284523.987";
        results[25][43]="3.201205239361082E-24";
        results[25][44]="218033066.7178449";
        results[25][45]="2.807941258351893E-8";
        results[25][46]="1.528808806532901E+32";
        results[25][47]="1.020758781281058E-13";
        results[25][48]="1.265945051462143E+27";
        results[25][49]="4.322980641628383E-18";
        results[25][50]="4.266417676295733E+22";
        results[25][51]="1.076026701773399E-23";
        results[25][52]="7.644921026359818E+17";
        results[25][53]="2.241369378545362E-28";
        results[25][54]="3117685079804.065";
        results[25][55]="1.135185706246483E-12";
        results[25][56]="1.310396907886189E+36";
        results[25][57]="1.138604665823557E-17";
        results[25][58]="1.047383379945576E+31";
        results[25][59]="2.234117009790872E-22";
        results[25][60]="5.409897855455146E+26";
        results[25][61]="1.032763415260583E-27";
        results[25][62]="3.867762492088947E+21";
        results[25][63]="8.784035896021034E-33";
        results[25][64]="4.041393739081530E+16";
        results[25][65]="9.530384456386937E-17";
        results[25][66]="8.496440906410580E+39";
        results[25][67]="3.076420354566251E-21";
        results[25][68]="1.812592592219525E+35";
        results[25][69]="1.366400309069427E-26";
        results[25][70]="1.330857671823993E+30";
        results[25][71]="8.350470532798348E-32";
        results[25][72]="3.243747585632540E+25";
        results[25][73]="1.582323381485480E-36";
        results[25][74]="9.059409899306875E+19";
        results[26][0]="2.723533134436308E-12";
        results[26][1]="5.988725516997952E-18";
        results[26][2]="1.343676605597132E-22";
        results[26][3]="1.566873478364917E-27";
        results[26][4]="1.093627899552070E-32";
        results[26][5]="3.412051194925813E-17";
        results[26][6]="2.120433589075808E-8";
        results[26][7]="3.272135815251872E-22";
        results[26][8]="3.125918550193178E-14";
        results[26][9]="3.050098167380094E-27";
        results[26][10]="1.113152559494507E-18";
        results[26][11]="3.696154578685082E-32";
        results[26][12]="4.962929819077190E-24";
        results[26][13]="4.650387456755103E-37";
        results[26][14]="3.739255128732137E-29";
        results[26][15]="4.016880900314683E-21";
        results[26][16]="0.00004614595141080237";
        results[26][17]="4.754106794320244E-26";
        results[26][18]="3.621591247686330E-10";
        results[26][19]="3.064242094077263E-31";
        results[26][20]="1.225574963096063E-14";
        results[26][21]="5.713291486714258E-36";
        results[26][22]="7.040925726124371E-20";
        results[26][23]="6.261813003582785E-41";
        results[26][24]="3.729492704555177E-25";
        results[26][25]="3.733470485444113E-25";
        results[26][26]="1";
        results[26][27]="4.352400925014057E-30";
        results[26][28]="0.00001542224561666388";
        results[26][29]="7.429619310899423E-35";
        results[26][30]="3.475745276510183E-11";
        results[26][31]="9.065148782251936E-40";
        results[26][32]="7.066372617918999E-16";
        results[26][33]="3.900607980544203E-45";
        results[26][34]="1.869449141218870E-20";
        results[26][35]="4.589077614441313E-29";
        results[26][36]="9670.015728822264";
        results[26][37]="3.882721498161075E-34";
        results[26][38]="0.04732568576779893";
        results[26][39]="4.138198020386811E-39";
        results[26][40]="8.580563680159561E-7";
        results[26][41]="6.625184461300789E-44";
        results[26][42]="3.098761568445328E-12";
        results[26][43]="1.195160527900366E-48";
        results[26][44]="8.140200194419411E-17";
        results[26][45]="1.048336581291759E-32";
        results[26][46]="57077625.57077626";
        results[26][47]="3.810972782670732E-38";
        results[26][48]="472.6368485827938";
        results[26][49]="1.613972063466582E-42";
        results[26][50]="0.01592854447302717";
        results[26][51]="4.017313932620759E-48";
        results[26][52]="2.854208701546549E-7";
        results[26][53]="8.368086421777320E-53";
        results[26][54]="1.163978522835795E-12";
        results[26][55]="4.238182329769274E-37";
        results[26][56]="489232817981.0316";
        results[26][57]="4.250946914441208E-42";
        results[26][58]="3910374.935971505";
        results[26][59]="8.341009917082876E-47";
        results[26][60]="201.9769397260919";
        results[26][61]="3.855791729321848E-52";
        results[26][62]="0.001444017710892185";
        results[26][63]="3.279493876087616E-57";
        results[26][64]="1.508842424491952E-8";
        results[26][65]="3.558140908285596E-41";
        results[26][66]="3172121135540393";
        results[26][67]="1.148572459459261E-45";
        results[26][68]="67672609451.86232";
        results[26][69]="5.101415225212420E-51";
        results[26][70]="496871.7838081744";
        results[26][71]="3.117623527377340E-56";
        results[26][72]="12.11043587318969";
        results[26][73]="5.907557643204166E-61";
        results[26][74]="0.00003382303947460244";
        results[27][0]="6.257541943766386E+17";
        results[27][1]="1375959067231.062";
        results[27][2]="30872077.93461244";
        results[27][3]="360.0021012218345";
        results[27][4]="0.002512700273696726";
        results[27][5]="7839468959112.017";
        results[27][6]="4.871871010065461E+21";
        results[27][7]="75180018.37666884";
        results[27][8]="7182055614931850";
        results[27][9]="700.7852033691596";
        results[27][10]="255755978980.9374";
        results[27][11]="0.008492219908884301";
        results[27][12]="1140274.047492801";
        results[27][13]="1.068464862698761E-7";
        results[27][14]="8.591246976449121";
        results[27][15]="922911507.8137501";
        results[27][16]="1.060241283048926E+25";
        results[27][17]="10922.95235716340";
        results[27][18]="8.320904507836979E+19";
        results[27][19]="0.07040348871507895";
        results[27][20]="2815859531810263";
        results[27][21]="0.000001312675827697515";
        results[27][22]="16177107411.35740";
        results[27][23]="1.438703169001500E-11";
        results[27][24]="85688.17001947338";
        results[27][25]="85779.56281525363";
        results[27][26]="2.297582454439834E+29";
        results[27][27]="1";
        results[27][28]="3.543388093690857E+24";
        results[27][29]="0.00001707016297188988";
        results[27][30]="7.985811363411926E+18";
        results[27][31]="2.082792678898868E-10";
        results[27][32]="162355737434647.7";
        results[27][33]="8.961968457746355E-16";
        results[27][34]="4295213546.332090";
        results[27][35]="10.54378420900297";
        results[27][36]="2.221765847269926E+33";
        results[27][37]="0.00008920872789651233";
        results[27][38]="1.087346652644278E+28";
        results[27][39]="9.507851164638391E-10";
        results[27][40]="1.971455256073830E+23";
        results[27][41]="1.522190757571212E-14";
        results[27][42]="7.119660210152448E+17";
        results[27][43]="2.745979859142930E-19";
        results[27][44]="18702781142325.76";
        results[27][45]="0.002408639735523385";
        results[27][46]="1.311405510525019E+37";
        results[27][47]="8.756024199812025E-9";
        results[27][48]="1.085922130625564E+32";
        results[27][49]="3.708233894976874E-13";
        results[27][50]="3.659714430599182E+27";
        results[27][51]="9.230110005566145E-19";
        results[27][52]="6.557779833982852E+22";
        results[27][53]="1.922636853991178E-23";
        results[27][54]="2.674336631412318E+17";
        results[27][55]="9.737573359594823E-8";
        results[27][56]="1.124052738729375E+41";
        results[27][57]="9.766901045375269E-13";
        results[27][58]="8.984408843169418E+35";
        results[27][59]="1.916415803779827E-17";
        results[27][60]="4.640586729161206E+31";
        results[27][61]="8.858999425264104E-23";
        results[27][62]="3.317749756446258E+26";
        results[27][63]="7.534907589141790E-28";
        results[27][64]="3.466689881027168E+21";
        results[27][65]="8.175122121301600E-12";
        results[27][66]="7.288209864375369E+44";
        results[27][67]="2.638939930506406E-16";
        results[27][68]="1.554834001227581E+40";
        results[27][69]="1.172092211426029E-21";
        results[27][70]="1.141603892583884E+35";
        results[27][71]="7.162997116051003E-27";
        results[27][72]="2.782472497785938E+30";
        results[27][73]="1.357310078961783E-31";
        results[27][74]="7.771122205267246E+24";
        results[28][0]="1.765977019256848E-7";
        results[28][1]="3.883173479306462E-13";
        results[28][2]="8.712587252178613E-18";
        results[28][3]="1.015982702721253E-22";
        results[28][4]="7.091236430383361E-28";
        results[28][5]="2.212421770302413E-12";
        results[28][6]="0.001374918829450271";
        results[28][7]="2.121698679027844E-17";
        results[28][8]="2.026889357030855E-9";
        results[28][9]="1.977726359178481E-22";
        results[28][10]="7.217837059291388E-14";
        results[28][11]="2.396638382345144E-27";
        results[28][12]="3.218033185591791E-19";
        results[28][13]="3.015376341646586E-32";
        results[28][14]="2.424585382489199E-24";
        results[28][15]="2.604601820097072E-16";
        results[28][16]="2.992168102999295";
        results[28][17]="3.082629412401127E-21";
        results[28][18]="0.00002348290474490412";
        results[28][19]="1.986897479292069E-26";
        results[28][20]="7.946799665619501E-10";
        results[28][21]="3.704578197445509E-31";
        results[28][22]="4.565434827802628E-15";
        results[28][23]="4.060247229376789E-36";
        results[28][24]="2.418255289959476E-20";
        results[28][25]="2.420834538784717E-20";
        results[28][26]="64841.40019917012";
        results[28][27]="2.822157702060747E-25";
        results[28][28]="1";
        results[28][29]="4.817469190655120E-30";
        results[28][30]="0.000002253721904645720";
        results[28][31]="5.877969400550175E-35";
        results[28][32]="4.581934948749433E-11";
        results[28][33]="2.529208830865435E-40";
        results[28][34]="1.212176999177676E-15";
        results[28][35]="2.975622181430421E-24";
        results[28][36]="627017359.8048342";
        results[28][37]="2.517610985241837E-29";
        results[28][38]="3068.663730570020";
        results[28][39]="2.683265539433148E-34";
        results[28][40]="0.05563757635196901";
        results[28][41]="4.295862370485278E-39";
        results[28][42]="2.009280389813716E-7";
        results[28][43]="7.749588209183903E-44";
        results[28][44]="5.278219785077115E-12";
        results[28][45]="6.797561181096882E-28";
        results[28][46]="3700993162053.089";
        results[28][47]="2.471088113492979E-33";
        results[28][48]="30646435.04783151";
        results[28][49]="1.046522084775171E-37";
        results[28][50]="1032.829126765834";
        results[28][51]="2.604882604307646E-43";
        results[28][52]="0.01850708886689335";
        results[28][53]="5.425984405757048E-48";
        results[28][54]="7.547399722243467E-8";
        results[28][55]="2.748096765616207E-32";
        results[28][56]="3.172254094127582E+16";
        results[28][57]="2.756373501047097E-37";
        results[28][58]="253554186152.1326";
        results[28][59]="5.408427620988176E-42";
        results[28][60]="13096467.57978319";
        results[28][61]="2.500149346056082E-47";
        results[28][62]="93.63213028664973";
        results[28][63]="2.126469748701247E-52";
        results[28][64]="0.0009783545548396877";
        results[28][65]="2.307148385991850E-36";
        results[28][66]="2.056847760298206E+20";
        results[28][67]="7.447504650154305E-41";
        results[28][68]="4387986751990347";
        results[28][69]="3.307829062001381E-46";
        results[28][70]="32217862181.58138";
        results[28][71]="2.021510748090225E-51";
        results[28][72]="785257.6190398789";
        results[28][73]="3.830543093426676E-56";
        results[28][74]="2.193133238525025";
        results[29][0]="3.665777505505325E+22";
        results[29][1]="8.060608850055552E+16";
        results[29][2]="1808540315956.603";
        results[29][3]="21089552.67824123";
        results[29][4]="147.1983763619884";
        results[29][5]="4.592498016581085E+17";
        results[29][6]="2.854027239276019E+26";
        results[29][7]="4404176954869.778";
        results[29][8]="4.207373782405491E+20";
        results[29][9]="41053222.77960500";
        results[29][10]="1.498263252683064E+16";
        results[29][11]="497.4890938574387";
        results[29][12]="66799247867.20172";
        results[29][13]="0.006259254023867518";
        results[29][14]="503290.2726585955";
        results[29][15]="54065770158934.34";
        results[29][16]="6.211078856100365E+29";
        results[29][17]="639885651.6572606";
        results[29][18]="4.874531380596274E+24";
        results[29][19]="4124.359493873326";
        results[29][20]="1.649579758814986E+20";
        results[29][21]="0.07689884565596421";
        results[29][22]="947683243446292.2";
        results[29][23]="8.428174771211442E-7";
        results[29][24]="5019762855.256830";
        results[29][25]="5025116805.065672";
        results[29][26]="1.345963983017241E+34";
        results[29][27]="58581.74884719846";
        results[29][28]="2.075778713727511E+29";
        results[29][29]="1";
        results[29][30]="4.678227956325009E+23";
        results[29][31]="0.00001220136376160371";
        results[29][32]="9.511083034298228E+18";
        results[29][33]="5.250077853682115E-11";
        results[29][34]="251621121216311.1";
        results[29][35]="617673.3184308691";
        results[29][36]="1.301549288620499E+38";
        results[29][37]="5.226003292611552";
        results[29][38]="6.369866851504902E+32";
        results[29][39]="0.00005569865490033896";
        results[29][40]="1.154912966748064E+28";
        results[29][41]="8.917259665756348E-10";
        results[29][42]="4.170821463085429E+22";
        results[29][43]="1.608643024477765E-14";
        results[29][44]="1.095641627623847E+18";
        results[29][45]="141.1023280498135";
        results[29][46]="7.682442825440876E+41";
        results[29][47]="0.0005129432105733799";
        results[29][48]="6.361521752392140E+36";
        results[29][49]="2.172348267022037E-8";
        results[29][50]="2.143924716258292E+32";
        results[29][51]="5.407159861780895E-14";
        results[29][52]="3.841662112296063E+27";
        results[29][53]="1.126314293048790E-18";
        results[29][54]="1.566673168742592E+22";
        results[29][55]="0.005704440769329544";
        results[29][56]="6.584897523124984E+45";
        results[29][57]="5.721621440556141E-8";
        results[29][58]="5.263223823910997E+40";
        results[29][59]="1.122669893038318E-12";
        results[29][60]="2.718536862713640E+36";
        results[29][61]="5.189756793682972E-18";
        results[29][62]="1.943595829699885E+31";
        results[29][63]="4.414080639739539E-23";
        results[29][64]="2.030847559414579E+26";
        results[29][65]="4.789129509052666E-7";
        results[29][66]="4.269560798205122E+49";
        results[29][67]="1.545937162317696E-11";
        results[29][68]="9.108489495899883E+44";
        results[29][69]="6.866321155551707E-17";
        results[29][70]="6.687715251833322E+39";
        results[29][71]="4.196208980457067E-22";
        results[29][72]="1.630021050395328E+35";
        results[29][73]="7.951359815351027E-27";
        results[29][74]="4.552459292898528E+29";
        results[30][0]="0.07835824888672127";
        results[30][1]="1.723004720015306E-7";
        results[30][2]="3.865866163087327E-12";
        results[30][3]="4.508021600300163E-17";
        results[30][4]="3.146455831913338E-22";
        results[30][5]="9.816746980813501E-7";
        results[30][6]="610.0658766354783";
        results[30][7]="9.414199128358610E-12";
        results[30][8]="0.0008993520242460782";
        results[30][9]="8.775378874836710E-17";
        results[30][10]="3.202629856156106E-8";
        results[30][11]="1.063413537138199E-21";
        results[30][12]="1.427875009316049E-13";
        results[30][13]="1.337954046340334E-26";
        results[30][14]="1.075813913638266E-18";
        results[30][15]="1.155689091332903E-10";
        results[30][16]="1327656.307919525";
        results[30][17]="1.367794937807870E-15";
        results[30][18]="10.41961064339727";
        results[30][19]="8.816072094770739E-21";
        results[30][20]="0.0003526078195024119";
        results[30][21]="1.643760124001572E-25";
        results[30][22]="2.025731221936322E-9";
        results[30][23]="1.801574196446855E-30";
        results[30][24]="1.073005185322375E-14";
        results[30][25]="1.074149625024506E-14";
        results[30][26]="28770807997.87632";
        results[30][27]="1.252220913433587E-19";
        results[30][28]="443710.4675331262";
        results[30][29]="2.137561506912014E-24";
        results[30][30]="1";
        results[30][31]="2.608116550863527E-29";
        results[30][32]="0.00002033052498315981";
        results[30][33]="1.122236432832213E-34";
        results[30][34]="5.378556230380286E-10";
        results[30][35]="1.320314709324433E-18";
        results[30][36]="278214165870389.4";
        results[30][37]="1.117090347328190E-23";
        results[30][38]="1361598218.593171";
        results[30][39]="1.190593007017408E-28";
        results[30][40]="24686.97501554217";
        results[30][41]="1.906119100865986E-33";
        results[30][42]="0.08915387411693861";
        results[30][43]="3.438573407486192E-38";
        results[30][44]="0.000002342001368579163";
        results[30][45]="3.016149049749527E-22";
        results[30][46]="1.642169406271479E+18";
        results[30][47]="1.096447662153521E-27";
        results[30][48]="13598144023296.90";
        results[30][49]="4.643528035193328E-32";
        results[30][50]="458277094.7190988";
        results[30][51]="1.155813678226253E-37";
        results[30][52]="8211.789053806363";
        results[30][53]="2.407566077505911E-42";
        results[30][54]="0.03348860259416035";
        results[30][55]="1.219359300697839E-26";
        results[30][56]="1.407562347239223E+22";
        results[30][57]="1.223031774845527E-31";
        results[30][58]="1.125046464825440E+17";
        results[30][59]="2.399775948327737E-36";
        results[30][60]="5811039752858.027";
        results[30][61]="1.109342435241184E-41";
        results[30][62]="41545556.30561193";
        results[30][63]="9.435368863912798E-47";
        results[30][64]="434.1061569410814";
        results[30][65]="1.023705889016741E-30";
        results[30][66]="9.126448813663803E+25";
        results[30][67]="3.304535770275098E-35";
        results[30][68]="1.946995653254801E+21";
        results[30][69]="1.467718379620295E-40";
        results[30][70]="1.429540269150730E+16";
        results[30][71]="8.969654791583536E-46";
        results[30][72]="348427025278.1341";
        results[30][73]="1.699652066890138E-50";
        results[30][74]="973116.1746283781";
        results[31][0]="3.004399817208225E+27";
        results[31][1]="6.606317955556214E+21";
        results[31][2]="1.482244404226248E+17";
        results[31][3]="1728458645303.865";
        results[31][4]="12064092.11609646";
        results[31][5]="3.763921891283291E+22";
        results[31][6]="2.339105115657083E+31";
        results[31][7]="3.609577618470172E+17";
        results[31][8]="3.448281572954666E+25";
        results[31][9]="3364642148346.955";
        results[31][10]="1.227947368799811E+21";
        results[31][11]="40773236.79365905";
        results[31][12]="5474736199359228";
        results[31][13]="512.9962638737704";
        results[31][14]="41248690104.82190";
        results[31][15]="4.431125177094802E+18";
        results[31][16]="5.090479209910875E+34";
        results[31][17]="52443781216564.26";
        results[31][18]="3.995070941115503E+29";
        results[31][19]="338024467.9576074";
        results[31][20]="1.351963428879995E+25";
        results[31][21]="6302.479555437567";
        results[31][22]="7.767027210749525E+19";
        results[31][23]="0.06907567822651053";
        results[31][24]="411409982796631.8";
        results[31][25]="411848782090993.5";
        results[31][26]="1.103125854876022E+39";
        results[31][27]="4801245991.169322";
        results[31][28]="1.701267787999033E+34";
        results[31][29]="81958.05153739330";
        results[31][30]="3.834184479481592E+28";
        results[31][31]="1";
        results[31][32]="7.795098335014412E+23";
        results[31][33]="0.000004302861513074059";
        results[31][34]="2.062237682054311E+19";
        results[31][35]="50623301665.22991";
        results[31][36]="1.066724436752164E+43";
        results[31][37]="428313.0471904447";
        results[31][38]="5.220618757019720E+37";
        results[31][39]="4.564953228885464";
        results[31][40]="9.465441644994164E+32";
        results[31][41]="0.00007308412272583773";
        results[31][42]="3.418324004248217E+27";
        results[31][43]="1.318412479054169E-9";
        results[31][44]="8.979665298330876E+22";
        results[31][45]="11564471.87435279";
        results[31][46]="6.296380450205607E+46";
        results[31][47]="42.03982608792905";
        results[31][48]="5.213779276388035E+41";
        results[31][49]="0.001780414312257591";
        results[31][50]="1.757118923873884E+37";
        results[31][51]="4.431602866227630E-9";
        results[31][52]="3.148551413888119E+32";
        results[31][53]="9.231052487699542E-14";
        results[31][54]="1.284014803060566E+27";
        results[31][55]="467.5248505647183";
        results[31][56]="5.396853705687309E+50";
        results[31][57]="0.004689329449025547";
        results[31][58]="4.313635694129337E+45";
        results[31][59]="9.201183695311428E-8";
        results[31][60]="2.228059843005880E+41";
        results[31][61]="4.253423547632060E-13";
        results[31][62]="1.592933271784059E+36";
        results[31][63]="3.617694485619832E-18";
        results[31][64]="1.664443089390894E+31";
        results[31][65]="0.03925077231221895";
        results[31][66]="3.499248839413294E+54";
        results[31][67]="0.000001267019976228053";
        results[31][68]="7.465140515327681E+49";
        results[31][69]="5.627503031390007E-12";
        results[31][70]="5.481121112771666E+44";
        results[31][71]="3.439131118819729E-17";
        results[31][72]="1.335933492553362E+40";
        results[31][73]="6.516779575388975E-22";
        results[31][74]="3.731106933492626E+34";
        results[32][0]="3854.216698861785";
        results[32][1]="0.008474964229612891";
        results[32][2]="1.901508281900985E-7";
        results[32][3]="2.217366056230347E-12";
        results[32][4]="1.547651049109460E-17";
        results[32][5]="0.04828575252702482";
        results[32][6]="30007384.32189076";
        results[32][7]="4.630573551915940E-7";
        results[32][8]="44.23653717702960";
        results[32][9]="4.316356258436777E-12";
        results[32][10]="0.001575281434595963";
        results[32][11]="5.230625072490977E-17";
        results[32][12]="7.023306139407549E-9";
        results[32][13]="6.581010807387358E-22";
        results[32][14]="5.291618954893612E-14";
        results[32][15]="0.000005684501960919277";
        results[32][16]="65303591964.26306";
        results[32][17]="6.727789562447809E-11";
        results[32][18]="512510.6534153962";
        results[32][19]="4.336372081917841E-16";
        results[32][20]="17.34376361626097";
        results[32][21]="8.085182873354881E-21";
        results[32][22]="0.00009963988749008084";
        results[32][23]="8.861424866987624E-26";
        results[32][24]="5.277803628834801E-10";
        results[32][25]="5.283432798288516E-10";
        results[32][26]="1415153225099094";
        results[32][27]="6.159314205957922E-15";
        results[32][28]="21824840622.69226";
        results[32][29]="1.051404972907783E-19";
        results[32][30]="49187.12137676328";
        results[32][31]="1.282857453520695E-24";
        results[32][32]="1";
        results[32][33]="5.519957963514394E-30";
        results[32][34]="0.00002645556981354615";
        results[32][35]="6.494247986306681E-14";
        results[32][36]="1.368455394540179E+19";
        results[32][37]="5.494645850284232E-19";
        results[32][38]="66973096844326.95";
        results[32][39]="5.856184274649082E-24";
        results[32][40]="1214281236.514595";
        results[32][41]="9.375651157286216E-29";
        results[32][42]="4385.222427398534";
        results[32][43]="1.691335275569338E-33";
        results[32][44]="0.1151963055808490";
        results[32][45]="1.483556894004392E-17";
        results[32][46]="8.077358590748254E+22";
        results[32][47]="5.393110424161355E-23";
        results[32][48]="6.688535605726128E+17";
        results[32][49]="2.284017770834574E-27";
        results[32][50]="22541331082138.75";
        results[32][51]="5.685114767983791E-33";
        results[32][52]="403914264.9099497";
        results[32][53]="1.184212448768611E-37";
        results[32][54]="1647.207960537155";
        results[32][55]="5.997677392530980E-22";
        results[32][56]="6.923394001901749E+26";
        results[32][57]="6.015741235696518E-27";
        results[32][58]="5.533779701986738E+21";
        results[32][59]="1.180380708474336E-31";
        results[32][60]="2.858283176490243E+17";
        results[32][61]="5.456536101060227E-37";
        results[32][62]="2043506320669.287";
        results[32][63]="4.640986335438119E-42";
        results[32][64]="21352432.23186122";
        results[32][65]="5.035314581717381E-26";
        results[32][66]="4.489037455364987E+30";
        results[32][67]="1.625406020263772E-30";
        results[32][68]="9.576711151667440E+25";
        results[32][69]="7.219284208528977E-36";
        results[32][70]="7.031497073168779E+20";
        results[32][71]="4.411914989412857E-41";
        results[32][72]="1.713812238330015E+16";
        results[32][73]="8.360099251239178E-46";
        results[32][74]="47864783395.13761";
        results[33][0]="6.982329800946383E+32";
        results[33][1]="1.535331298830604E+27";
        results[33][2]="3.444787613364996E+22";
        results[33][3]="4.016998083837972E+17";
        results[33][4]="2803737019990.124";
        results[33][5]="8.747485550828852E+27";
        results[33][6]="5.436161746200319E+36";
        results[33][7]="8.388784085898711E+22";
        results[33][8]="8.013926459118452E+30";
        results[33][9]="7.819545523655909E+17";
        results[33][10]="2.853792447348690E+26";
        results[33][11]="9475842220292.549";
        results[33][12]="1.272347758049958E+21";
        results[33][13]="119222118.1915926";
        results[33][14]="9586339225533875";
        results[33][15]="1.029808922186089E+24";
        results[33][16]="1.183045095558775E+40";
        results[33][17]="1.218811738588753E+19";
        results[33][18]="9.284683992214605E+34";
        results[33][19]="78558063495777.08";
        results[33][20]="3.142010089732407E+30";
        results[33][21]="1464718196.550773";
        results[33][22]="1.805084171812118E+25";
        results[33][23]="16053.42817021349";
        results[33][24]="9.561311270339060E+19";
        results[33][25]="9.571509118748273E+19";
        results[33][26]="2.563702902183168E+44";
        results[33][27]="1115826288292324";
        results[33][28]="3.953805584562284E+39";
        results[33][29]="19047336589.46896";
        results[33][30]="8.910778252638594E+33";
        results[33][31]="232403.4824178150";
        results[33][32]="1.811607998846661E+29";
        results[33][33]="1";
        results[33][34]="4.792712188826647E+24";
        results[33][35]="1.176503159848700E+16";
        results[33][36]="2.479104738813852E+48";
        results[33][37]="99541443732.04527";
        results[33][38]="1.213289979507148E+43";
        results[33][39]="1060911.027467431";
        results[33][40]="2.199801600919255E+38";
        results[33][41]="16.98500463093566";
        results[33][42]="7.944304026196954E+32";
        results[33][43]="0.0003064036513952934";
        results[33][44]="2.086905486278503E+28";
        results[33][45]="2687623535922.464";
        results[33][46]="1.463300743255233E+52";
        results[33][47]="9770201.983074019";
        results[33][48]="1.211700460390415E+47";
        results[33][49]="413.7744863151833";
        results[33][50]="4.083605569305342E+42";
        results[33][51]="0.001029919938804072";
        results[33][52]="7.317343131591340E+37";
        results[33][53]="2.145328744523008E-8";
        results[33][54]="2.984095117073005E+32";
        results[33][55]="108654403.3881091";
        results[33][56]="1.254247595301220E+56";
        results[33][57]="1089.816494157951";
        results[33][58]="1.002503957197447E+51";
        results[33][59]="0.02138387133156396";
        results[33][60]="5.178088665498566E+46";
        results[33][61]="9.885104446676278E-8";
        results[33][62]="3.702032396218190E+41";
        results[33][63]="8.407647967817748E-13";
        results[33][64]="3.868223702607104E+36";
        results[33][65]="9122.016172948436";
        results[33][66]="8.132376161261471E+59";
        results[33][67]="0.2944598547683367";
        results[33][68]="1.734924652500475E+55";
        results[33][69]="0.000001307851301811848";
        results[33][70]="1.273831634161944E+50";
        results[33][71]="7.992660485051813E-12";
        results[33][72]="3.104755959479955E+45";
        results[33][73]="1.514522267469688E-16";
        results[33][74]="8.671222446169412E+39";
        results[34][0]="145686398.9710135";
        results[34][1]="320.3470682862941";
        results[34][2]="0.007187553680765358";
        results[34][3]="8.381471545908569E-8";
        results[34][4]="5.850000812747606E-13";
        results[34][5]="1825.163958566520";
        results[34][6]="1134255830941.353";
        results[34][7]="0.01750320852868166";
        results[34][8]="1672106.761971122";
        results[34][9]="1.631549155379241E-7";
        results[34][10]="59.54441524783812";
        results[34][11]="1.977135669106896E-12";
        results[34][12]="0.0002654755194806417";
        results[34][13]="2.487570993091087E-17";
        results[34][14]="2.000190883125157E-9";
        results[34][15]="0.2148697609230333";
        results[34][16]="2468425077384854";
        results[34][17]="0.000002543052222977617";
        results[34][18]="19372504808.15474";
        results[34][19]="1.639114981260948E-11";
        results[34][20]="655580.7997520574";
        results[34][21]="3.056136356290082E-16";
        results[34][22]="3.766310391056549";
        results[34][23]="3.349549803478537E-21";
        results[34][24]="0.00001994968797131100";
        results[34][25]="0.00001997096579482185";
        results[34][26]="5.349169324542341E+19";
        results[34][27]="2.328172951619490E-10";
        results[34][28]="824962031682160.1";
        results[34][29]="3.974229171089060E-15";
        results[34][30]="1859235001.303121";
        results[34][31]="4.849101578843441E-20";
        results[34][32]="37799.22364355827";
        results[34][33]="2.086501255659210E-25";
        results[34][34]="1";
        results[34][35]="2.454775320311342E-9";
        results[34][36]="5.172655150445800E+23";
        results[34][37]="2.076933473370431E-14";
        results[34][38]="2.531531065720401E+18";
        results[34][39]="2.213592190953497E-19";
        results[34][40]="45898888025191.66";
        results[34][41]="3.543923348982476E-24";
        results[34][42]="165758003.2599846";
        results[34][43]="6.393116033748466E-29";
        results[34][44]="4354.330917562191";
        results[34][45]="5.607729882441468E-13";
        results[34][46]="3.053178838209099E+27";
        results[34][47]="2.038553870572805E-18";
        results[34][48]="2.528214532087444E+22";
        results[34][49]="8.633409852563746E-23";
        results[34][50]="8.520448147972540E+17";
        results[34][51]="2.148929245543152E-28";
        results[34][52]="15267645632154.63";
        results[34][53]="4.476231119249052E-33";
        results[34][54]="62263182.08779341";
        results[34][55]="2.267075491021919E-17";
        results[34][56]="2.616989182503541E+31";
        results[34][57]="2.273903483498682E-22";
        results[34][58]="2.091725765495799E+26";
        results[34][59]="4.461747438416318E-27";
        results[34][60]="1.080408850247748E+22";
        results[34][61]="2.062528284031250E-32";
        results[34][62]="7.724295243200328E+16";
        results[34][63]="1.754256804199234E-37";
        results[34][64]="807105361266.0442";
        results[34][65]="1.903309819900053E-21";
        results[34][66]="1.696821307196509E+35";
        results[34][67]="6.143908567153631E-26";
        results[34][68]="3.619922465916360E+30";
        results[34][69]="2.728833383445953E-31";
        results[34][70]="2.657851304177320E+25";
        results[34][71]="1.667669613811836E-36";
        results[34][72]="6.478077207970342E+20";
        results[34][73]="3.160052612799337E-41";
        results[34][74]="1809251652203281";
        results[35][0]="5.934816020251334E+16";
        results[35][1]="130499547406.9147";
        results[35][2]="2927988.407449751";
        results[35][3]="34.14353841900911";
        results[35][4]="0.0002383110488501100";
        results[35][5]="743515686940.7634";
        results[35][6]="4.620609558668262E+20";
        results[35][7]="7130269.065301548";
        results[35][8]="681164890381514.3";
        results[35][9]="66.46429682910084";
        results[35][10]="24256564238.34587";
        results[35][11]="0.0008054242898515592";
        results[35][12]="108146.5653023476";
        results[35][13]="1.013359948875315E-8";
        results[35][14]="0.8148162752717714";
        results[35][15]="87531335.00453358";
        results[35][16]="1.005560491406513E+24";
        results[35][17]="1035.961296309220";
        results[35][18]="7.891762903049598E+18";
        results[35][19]="0.006677250531641558";
        results[35][20]="267063463742543.0";
        results[35][21]="1.244975998822763E-7";
        results[35][22]="1534279068.187334";
        results[35][23]="1.364503616996488E-12";
        results[35][24]="8126.889579768451";
        results[35][25]="8135.557510937055";
        results[35][26]="2.179087136929461E+28";
        results[35][27]="0.09484260870458016";
        results[35][28]="3.360641704583902E+23";
        results[35][29]="0.000001618978787266365";
        results[35][30]="7.573951823286671E+17";
        results[35][31]="1.975374910575696E-11";
        results[35][32]="15398241676457.85";
        results[35][33]="8.499764676608273E-17";
        results[35][34]="407369257.6773865";
        results[35][35]="1";
        results[35][36]="2.107180688858216E+32";
        results[35][37]="0.000008460788472922284";
        results[35][38]="1.031267931029763E+27";
        results[35][39]="9.017494076291857E-11";
        results[35][40]="1.869779594303981E+22";
        results[35][41]="1.443685423940549E-15";
        results[35][42]="6.752471474210576E+16";
        results[35][43]="2.604358932913510E-20";
        results[35][44]="1773820553569.003";
        results[35][45]="0.0002284416759465479";
        results[35][46]="1.243771196877546E+36";
        results[35][47]="8.304441769906065E-10";
        results[35][48]="1.029916877185643E+31";
        results[35][49]="3.516985762863528E-14";
        results[35][50]="3.470968637118237E+26";
        results[35][51]="8.754077115581401E-20";
        results[35][52]="6.219569467652223E+21";
        results[35][53]="1.823478948240904E-24";
        results[35][54]="2.536410626773635E+16";
        results[35][55]="9.235368598761958E-9";
        results[35][56]="1.066080940626218E+40";
        results[35][57]="9.263183741028816E-14";
        results[35][58]="8.521047723546869E+34";
        results[35][59]="1.817578741931636E-18";
        results[35][60]="4.401253513135038E+30";
        results[35][61]="8.402106160044240E-24";
        results[35][62]="3.146640419303486E+25";
        results[35][63]="7.146302921021462E-29";
        results[35][64]="3.287899118863873E+20";
        results[35][65]="7.753499084627650E-13";
        results[35][66]="6.912328363238143E+43";
        results[35][67]="2.502839472239110E-17";
        results[35][68]="1.474645127790042E+39";
        results[35][69]="1.111642829739649E-22";
        results[35][70]="1.082726912799589E+34";
        results[35][71]="6.793573326296614E-28";
        results[35][72]="2.638969503387675E+29";
        results[35][73]="1.287308287097552E-32";
        results[35][74]="7.370335025096355E+23";
        results[36][0]="2.816472290028026E-16";
        results[36][1]="6.193087669080073E-22";
        results[36][2]="1.389528872835434E-26";
        results[36][3]="1.620342223120407E-31";
        results[36][4]="1.130947384389897E-36";
        results[36][5]="3.528485672216559E-21";
        results[36][6]="2.192792285493067E-12";
        results[36][7]="3.383795752781463E-26";
        results[36][8]="3.232588899391471E-18";
        results[36][9]="3.154181185340816E-31";
        results[36][10]="1.151138313225971E-22";
        results[36][11]="3.822283936590086E-36";
        results[36][12]="5.132287225019476E-28";
        results[36][13]="4.809079516690182E-41";
        results[36][14]="3.866855270552440E-33";
        results[36][15]="4.153954877593472E-25";
        results[36][16]="4.772065806807389E-9";
        results[36][17]="4.916338222853396E-30";
        results[36][18]="3.745176170594929E-14";
        results[36][19]="3.168807766200464E-35";
        results[36][20]="1.267397073040055E-18";
        results[36][21]="5.908254595372923E-40";
        results[36][22]="7.281193664595935E-24";
        results[36][23]="6.475494124501726E-45";
        results[36][24]="3.856759708713939E-29";
        results[36][25]="3.860873229312546E-29";
        results[36][26]="0.0001034124481327801";
        results[36][27]="4.500924349110802E-34";
        results[36][28]="1.594852174924249E-9";
        results[36][29]="7.683151216346878E-39";
        results[36][30]="3.594353281298647E-15";
        results[36][31]="9.374492282605629E-44";
        results[36][32]="7.307508918374459E-20";
        results[36][33]="4.033714204743355E-49";
        results[36][34]="1.933243123531666E-24";
        results[36][35]="4.745677507807144E-33";
        results[36][36]="1";
        results[36][37]="4.015217355426124E-38";
        results[36][38]="0.000004894065024810755";
        results[36][39]="4.279411881464243E-43";
        results[36][40]="8.873370965245172E-11";
        results[36][41]="6.851265444743684E-48";
        results[36][42]="3.204505199727048E-16";
        results[36][43]="1.235944761018426E-52";
        results[36][44]="8.417980303958437E-21";
        results[36][45]="1.084110523385301E-36";
        results[36][46]="5902.536993880142";
        results[36][47]="3.941020252233737E-42";
        results[36][48]="0.04887653358970880";
        results[36][49]="1.669048023009940E-46";
        results[36][50]="0.000001647209779147603";
        results[36][51]="4.154402686902390E-52";
        results[36][52]="2.951607093088121E-11";
        results[36][53]="8.653643030626684E-57";
        results[36][54]="1.203698686204266E-16";
        results[36][55]="4.382808103545301E-41";
        results[36][56]="50592763.41431727";
        results[36][57]="4.396008273048529E-46";
        results[36][58]="404.3814452458765";
        results[36][59]="8.625642554253372E-51";
        results[36][60]="0.02088692980344213";
        results[36][61]="3.987368622192980E-56";
        results[36][62]="1.493294066304539E-7";
        results[36][63]="3.391404903626805E-61";
        results[36][64]="1.560330889633121E-12";
        results[36][65]="3.679560621272072E-45";
        results[36][66]="328036812399.9663";
        results[36][67]="1.187766898905705E-49";
        results[36][68]="6998190.214950595";
        results[36][69]="5.275498373810540E-55";
        results[36][70]="51.38272757170476";
        results[36][71]="3.224010813224441E-60";
        results[36][72]="0.001252369821601588";
        results[36][73]="6.109149983692593E-65";
        results[36][74]="3.497723315360298E-9";
        results[37][0]="7.014495208389838E+21";
        results[37][1]="1.542404089460013E+16";
        results[37][2]="346065667144.4297";
        results[37][3]="4035503.136413506";
        results[37][4]="28.16652958678678";
        results[37][5]="8.787782478196851E+16";
        results[37][6]="5.461204441472514E+25";
        results[37][7]="842742858791.6008";
        results[37][8]="8.050844109405394E+19";
        results[37][9]="7855567.721827779";
        results[37][10]="2866938975720293";
        results[37][11]="95.19494458811030";
        results[37][12]="12782090658.38928";
        results[37][13]="0.001197713371653776";
        results[37][14]="96305.00489162340";
        results[37][15]="10345529294895.73";
        results[37][16]="1.188495013939524E+29";
        results[37][17]="122442642.2696522";
        results[37][18]="9.327455624622005E+23";
        results[37][19]="789.1995590022467";
        results[37][20]="3.156484346550524E+19";
        results[37][21]="0.01471465694724737";
        results[37][22]="181339962947614.9";
        results[37][23]="1.612738128796641E-7";
        results[37][24]="960535723.8013413";
        results[37][25]="961560206.4717620";
        results[37][26]="2.575513078838174E+33";
        results[37][27]="11209.66550672107";
        results[37][28]="3.972019529077253E+28";
        results[37][29]="0.1913508170601013";
        results[37][30]="8.951827418361983E+22";
        results[37][31]="0.000002334740925030381";
        results[37][32]="1.819953509739433E+18";
        results[37][33]="1.004606686931215E-11";
        results[37][34]="48147907134319.92";
        results[37][35]="118192.2941579709";
        results[37][36]="2.490525198215260E+37";
        results[37][37]="1";
        results[37][38]="1.218879226599518E+32";
        results[37][39]="0.00001065798312432847";
        results[37][40]="2.209935398205477E+27";
        results[37][41]="1.706324922979563E-10";
        results[37][42]="7.980900947732038E+21";
        results[37][43]="3.078151570918528E-15";
        results[37][44]="2.096519206508824E+17";
        results[37][45]="27.00004576141425";
        results[37][46]="1.470041711665625E+41";
        results[37][47]="0.00009815210244864781";
        results[37][48]="1.217282385065843E+36";
        results[37][49]="4.156806158337618E-9";
        results[37][50]="4.102417461713700E+31";
        results[37][51]="1.034664457526358E-14";
        results[37][52]="7.351051840566861E+26";
        results[37][53]="2.155211602413563E-19";
        results[37][54]="2.997841909050329E+21";
        results[37][55]="0.001091549402082161";
        results[37][56]="1.260025521307003E+45";
        results[37][57]="1.094836937559011E-8";
        results[37][58]="1.007122179075560E+40";
        results[37][59]="2.148238013216586E-13";
        results[37][60]="5.201942498882593E+35";
        results[37][61]="9.930642028144481E-19";
        results[37][62]="3.719086500476785E+30";
        results[37][63]="8.446379369833354E-24";
        results[37][64]="3.886043398184922E+25";
        results[37][65]="9.164038445638694E-8";
        results[37][66]="8.169839472243282E+48";
        results[37][67]="2.958163391330656E-12";
        results[37][68]="1.742916907223793E+44";
        results[37][69]="1.313876163311878E-17";
        results[37][70]="1.279699777703607E+39";
        results[37][71]="8.029480169653943E-23";
        results[37][72]="3.119058598183105E+34";
        results[37][73]="1.521499197406275E-27";
        results[37][74]="8.711168053289843E+28";
    }

    private static void initResults2() {
        results[38][0]="5.754873046740801E-11";
        results[38][1]="1.265428153832008E-16";
        results[38][2]="2.839212118742058E-21";
        results[38][3]="3.310831006343367E-26";
        results[38][4]="2.310854838782263E-31";
        results[38][5]="7.209723725223695E-16";
        results[38][6]="4.480513181530232E-7";
        results[38][7]="6.914080086037084E-21";
        results[38][8]="6.605120453046024E-13";
        results[38][9]="6.444910660872926E-26";
        results[38][10]="2.352110786003469E-17";
        results[38][11]="7.810039133548062E-31";
        results[38][12]="1.048675732545652E-22";
        results[38][13]="9.826349859084964E-36";
        results[38][14]="7.901111348029064E-28";
        results[38][15]="8.487739448770601E-20";
        results[38][16]="0.0009750720071382617";
        results[38][17]="1.004551062956811E-24";
        results[38][18]="7.652485513797906E-9";
        results[38][19]="6.474797024837234E-30";
        results[38][20]="2.589661286915703E-13";
        results[38][21]="1.207228462519536E-34";
        results[38][22]="1.487759894419769E-18";
        results[38][23]="1.323132016365500E-39";
        results[38][24]="7.880483175360085E-24";
        results[38][25]="7.888888295802402E-24";
        results[38][26]="21.13017452946058";
        results[38][27]="9.196699116773269E-29";
        results[38][28]="0.0003258747415163162";
        results[38][29]="1.569891527267555E-33";
        results[38][30]="7.344310431260839E-10";
        results[38][31]="1.915481759045105E-38";
        results[38][32]="1.493136867068297E-14";
        results[38][33]="8.242052739990580E-44";
        results[38][34]="3.950178662790491E-19";
        results[38][35]="9.696801092238556E-28";
        results[38][36]="204329.1200526434";
        results[38][37]="8.204258290543218E-33";
        results[38][38]="1";
        results[38][39]="8.744084640824158E-38";
        results[38][40]="0.00001813088081229221";
        results[38][41]="1.399913039571560E-42";
        results[38][42]="6.547737276643480E-11";
        results[38][43]="2.525395054525697E-47";
        results[38][44]="1.720038508128311E-15";
        results[38][45]="2.215153492831292E-31";
        results[38][46]="1206060190.037704";
        results[38][47]="8.052652002485662E-37";
        results[38][48]="9986.899099608667";
        results[38][49]="3.410351138672251E-41";
        results[38][50]="0.3365729247153389";
        results[38][51]="8.488654453591028E-47";
        results[38][52]="0.000006030992800718365";
        results[38][53]="1.768191265697641E-51";
        results[38][54]="2.459506933606407E-11";
        results[38][55]="8.955353231570062E-36";
        results[38][56]="10337574829479.02";
        results[38][57]="8.982325021761465E-41";
        results[38][58]="82626904.87270614";
        results[38][59]="1.762469952999227E-45";
        results[38][60]="4267.807987338662";
        results[38][61]="8.147355218982128E-51";
        results[38][62]="0.03051234625478403";
        results[38][63]="6.929627797002850E-56";
        results[38][64]="3.188210376696939E-7";
        results[38][65]="7.518413839248804E-40";
        results[38][66]="6.702747322255918E+16";
        results[38][67]="2.426953652810597E-44";
        results[38][68]="1429934048581.875";
        results[38][69]="1.077937940559859E-49";
        results[38][70]="10498987.51063113";
        results[38][71]="6.587592925063573E-55";
        results[38][72]="255.8956236283385";
        results[38][73]="1.248277240437528E-59";
        results[38][74]="0.0007146867272151842";
        results[39][0]="6.581447096100371E+26";
        results[39][1]="1.447181958788470E+21";
        results[39][2]="3.247008961334176E+16";
        results[39][3]="378636660364.1785";
        results[39][4]="2642763.575267104";
        results[39][5]="8.245258390527376E+21";
        results[39][6]="5.124050561692560E+30";
        results[39][7]="7.907151371518986E+16";
        results[39][8]="7.553815778735954E+24";
        results[39][9]="737059500863.3713";
        results[39][10]="2.689945125899165E+20";
        results[39][11]="8931797.271363033";
        results[39][12]="1199297325702478";
        results[39][13]="112.3771127878607";
        results[39][14]="9035950213.862933";
        results[39][15]="9.706835875242173E+17";
        results[39][16]="1.115121876320673E+34";
        results[39][17]="11488350172947.65";
        results[39][18]="8.751614180482857E+28";
        results[39][19]="74047739.59538163";
        results[39][20]="2.961615072691725E+24";
        results[39][21]="1380.623029291435";
        results[39][22]="1.701447270390950E+19";
        results[39][23]="0.01513173843478247";
        results[39][24]="90123592108977.16";
        results[39][25]="90219715611751.54";
        results[39][26]="2.416510749542446E+38";
        results[39][27]="1051762362.161496";
        results[39][28]="3.726802231475215E+33";
        results[39][29]="17953.75492979660";
        results[39][30]="8.399175823358240E+27";
        results[39][31]="0.2190602947851342";
        results[39][32]="1.707596539147366E+23";
        results[39][33]="9.425861114736121E-7";
        results[39][34]="4.517543945478293E+18";
        results[39][35]="11089555385.78204";
        results[39][36]="2.336769695694354E+42";
        results[39][37]="93826.38237785791";
        results[39][38]="1.143630283873541E+37";
        results[39][39]="1";
        results[39][40]="2.073502437023907E+32";
        results[39][41]="0.00001600982946843494";
        results[39][42]="7.488190640417148E+26";
        results[39][43]="2.888118263100058E-10";
        results[39][44]="1.967088127324202E+22";
        results[39][45]="2533316.617830116";
        results[39][46]="1.379286957501396E+46";
        results[39][47]="9.209256695537514";
        results[39][48]="1.142132025230187E+41";
        results[39][49]="0.0003900180840828200";
        results[39][50]="3.849149894363509E+36";
        results[39][51]="9.707882302464703E-10";
        results[39][52]="6.897226008724825E+31";
        results[39][53]="2.022157079132508E-14";
        results[39][54]="2.812766612669237E+26";
        results[39][55]="102.4161315840830";
        results[39][56]="1.182236363680106E+50";
        results[39][57]="0.001027245891448147";
        results[39][58]="9.449463067516497E+44";
        results[39][59]="2.015614012667092E-8";
        results[39][60]="4.880794460077878E+40";
        results[39][61]="9.317562161903105E-14";
        results[39][62]="3.489484320900643E+35";
        results[39][63]="7.924932204624348E-19";
        results[39][64]="3.646133938150488E+30";
        results[39][65]="0.008598285753258867";
        results[39][66]="7.665464822884150E+53";
        results[39][67]="2.775537694911710E-7";
        results[39][68]="1.635315881900131E+49";
        results[39][69]="1.232762472960531E-12";
        results[39][70]="1.200696006716784E+44";
        results[39][71]="7.533770766933783E-18";
        results[39][72]="2.926499846920735E+39";
        results[39][73]="1.427567654834451E-22";
        results[39][74]="8.173373847257529E+33";
        results[40][0]="0.000003174072515461667";
        results[40][1]="6.979408043839129E-12";
        results[40][2]="1.565953771433517E-16";
        results[40][3]="1.826072897737389E-21";
        results[40][4]="1.274540858056698E-26";
        results[40][5]="3.976488401123740E-11";
        results[40][6]="0.02471205468678926";
        results[40][7]="3.813427575647367E-16";
        results[40][8]="3.643022377913347E-8";
        results[40][9]="3.554659438554945E-21";
        results[40][10]="1.297295377072253E-12";
        results[40][11]="4.307589473674706E-26";
        results[40][12]="5.783920502277423E-18";
        results[40][13]="5.419675944492992E-31";
        results[40][14]="4.357819914999574E-23";
        results[40][15]="4.681371818966545E-15";
        results[40][16]="53.77962699292531";
        results[40][17]="5.540553012050880E-20";
        results[40][18]="0.0004220691533424975";
        results[40][19]="3.571143118677119E-25";
        results[40][20]="1.428315211889754E-8";
        results[40][21]="6.658410449100025E-30";
        results[40][22]="8.205668052327118E-14";
        results[40][23]="7.297670918825164E-35";
        results[40][24]="4.346442545702108E-19";
        results[40][25]="4.351078349405929E-19";
        results[40][26]="1165424.600614822";
        results[40][27]="5.072395109750087E-24";
        results[40][28]="17.97346443838419";
        results[40][29]="8.658661118125126E-29";
        results[40][30]="0.00004050719050715733";
        results[40][31]="1.056474739906990E-33";
        results[40][32]="8.235324486033761E-10";
        results[40][33]="4.545864497880714E-39";
        results[40][34]="2.178702018774722E-14";
        results[40][35]="5.348223946000686E-23";
        results[40][36]="11269674218.70173";
        results[40][37]="4.525019151292953E-28";
        results[40][38]="55154.51843475961";
        results[40][39]="4.822757775174344E-33";
        results[40][40]="1";
        results[40][41]="7.721152954810994E-38";
        results[40][42]="0.000003611372963305955";
        results[40][43]="1.392869480898883E-42";
        results[40][44]="9.486789560505935E-11";
        results[40][45]="1.221757241561856E-26";
        results[40][46]="66519668984864.25";
        results[40][47]="4.441401433197993E-32";
        results[40][48]="550822610.4954504";
        results[40][49]="1.880962747469021E-36";
        results[40][50]="18563.51758085312";
        results[40][51]="4.681876485468906E-42";
        results[40][52]="0.3326365036071236";
        results[40][53]="9.752373776010145E-47";
        results[40][54]="0.000001356529205100136";
        results[40][55]="4.939281949004150E-31";
        results[40][56]="5.701639615032074E+17";
        results[40][57]="4.954158109997452E-36";
        results[40][58]="4557247148008.799";
        results[40][59]="9.720818151340577E-41";
        results[40][60]="235388894.3136845";
        results[40][61]="4.493634536198847E-46";
        results[40][62]="1682.893763997254";
        results[40][63]="3.822002840758163E-51";
        results[40][64]="0.01758442079954232";
        results[40][65]="4.146744946969999E-35";
        results[40][66]="3.696868007488996E+21";
        results[40][67]="1.338574599842493E-39";
        results[40][68]="7.886732384299944E+16";
        results[40][69]="5.945314801413554E-45";
        results[40][70]="579066600201.4157";
        results[40][71]="3.633355154261108E-50";
        results[40][72]="14113799.89078350";
        results[40][73]="6.884813006940251E-55";
        results[40][74]="39.41820227126789";
        results[41][0]="4.110878950382567E+31";
        results[41][1]="9.039334001912643E+25";
        results[41][2]="2.028134632999056E+21";
        results[41][3]="2.365026192881695E+16";
        results[41][4]="165071313250.2498";
        results[41][5]="5.150122558634225E+26";
        results[41][6]="3.200565360046566E+35";
        results[41][7]="4.938935412840446E+21";
        results[41][8]="4.718236252065705E+29";
        results[41][9]="4.603793577667779E+16";
        results[41][10]="1.680183496771577E+25";
        results[41][11]="557894591505.3629";
        results[41][12]="7.491006247549473E+19";
        results[41][13]="7019257.326220990";
        results[41][14]="564400153772921.7";
        results[41][15]="6.063047638564933E+22";
        results[41][16]="6.965232693572741E+38";
        results[41][17]="7.175810457942816E+17";
        results[41][18]="5.466400624527316E+33";
        results[41][19]="4625142306567.008";
        results[41][20]="1.849872966186717E+29";
        results[41][21]="86235960.97719082";
        results[41][22]="1.062751651256206E+24";
        results[41][23]="945.1530051969814";
        results[41][24]="5.629266213401292E+18";
        results[41][25]="5.635270243797986E+18";
        results[41][26]="1.509391935939637E+43";
        results[41][27]="65694788581924.34";
        results[41][28]="2.327821316787288E+38";
        results[41][29]="1121420747.497299";
        results[41][30]="5.246261891744755E+32";
        results[41][31]="13682.86247002409";
        results[41][32]="1.066592584583160E+28";
        results[41][33]="0.05887546231095213";
        results[41][34]="2.821731458405042E+23";
        results[41][35]="692671674463882.5";
        results[41][36]="1.459584376149378E+47";
        results[41][37]="5860548518.823794";
        results[41][38]="7.143300846072895E+41";
        results[41][39]="62461.62721293222";
        results[41][40]="1.295143362464938E+37";
        results[41][41]="1";
        results[41][42]="4.677245722811041E+31";
        results[41][43]="0.00001803965662966171";
        results[41][44]="1.228675253039092E+27";
        results[41][45]="158235078195.2310";
        results[41][46]="8.615250775911171E+50";
        results[41][47]="575225.1586248642";
        results[41][48]="7.133942478787923E+45";
        results[41][49]="24.36116417428315";
        results[41][50]="2.404241657884309E+41";
        results[41][51]="0.00006063701254035724";
        results[41][52]="4.308119597603104E+36";
        results[41][53]="1.263072216427666E-9";
        results[41][54]="1.756899795975280E+31";
        results[41][55]="6397078.231595606";
        results[41][56]="7.384440702575934E+54";
        results[41][57]="64.16344992765041";
        results[41][58]="5.902288394855864E+49";
        results[41][59]="0.001258985310643743";
        results[41][60]="3.048623640683292E+45";
        results[41][61]="5.819900942901146E-9";
        results[41][62]="2.179588688174679E+40";
        results[41][63]="4.950041610530071E-14";
        results[41][64]="2.277434588131763E+35";
        results[41][65]="537.0629193903215";
        results[41][66]="4.787974061808353E+58";
        results[41][67]="0.01733646008150164";
        results[41][68]="1.021444909906334E+54";
        results[41][69]="7.700035002815314E-8";
        results[41][70]="7.499742636760013E+48";
        results[41][71]="4.705715811519044E-13";
        results[41][72]="1.827939424770661E+44";
        results[41][73]="8.916819867750936E-18";
        results[41][74]="5.105222303193294E+38";
        results[42][0]="0.8789101950179163";
        results[42][1]="0.000001932619010762593";
        results[42][2]="4.336172938504800E-11";
        results[42][3]="5.056450597297903E-16";
        results[42][4]="3.529241845156713E-21";
        results[42][5]="0.00001101101559303791";
        results[42][6]="6842.842026531408";
        results[42][7]="1.055949527892695E-10";
        results[42][8]="0.01008763817785915";
        results[42][9]="9.842958549761383E-16";
        results[42][10]="3.592249790463821E-7";
        results[42][11]="1.192784438894235E-20";
        results[42][12]="1.601584926576693E-12";
        results[42][13]="1.500724516564931E-25";
        results[42][14]="1.206693398681896E-17";
        results[42][15]="1.296285890859935E-9";
        results[42][16]="14891739.93917645";
        results[42][17]="1.534195738946580E-14";
        results[42][18]="116.8722138729541";
        results[42][19]="9.888602354180532E-20";
        results[42][20]="0.003955047640890110";
        results[42][21]="1.843733814467261E-24";
        results[42][22]="2.272174083292525E-8";
        results[42][23]="2.020746954959940E-29";
        results[42][24]="1.203542971015447E-13";
        results[42][25]="1.204826638958615E-13";
        results[42][26]="322709565712.6364";
        results[42][27]="1.404561412318563E-18";
        results[42][28]="4976906.185267212";
        results[42][29]="2.397609221230570E-23";
        results[42][30]="11.21656248710349";
        results[42][31]="2.925410226640957E-28";
        results[42][32]="0.0002280386038692306";
        results[42][33]="1.258763507416664E-33";
        results[42][34]="6.032891204846025E-9";
        results[42][35]="1.480939243977938E-17";
        results[42][36]="3120606576282596";
        results[42][37]="1.252991368454678E-22";
        results[42][38]="15272451501.17909";
        results[42][39]="1.335436085991919E-27";
        results[42][40]="276902.9978793913";
        results[42][41]="2.138010400272485E-32";
        results[42][42]="1";
        results[42][43]="3.856897349156122E-37";
        results[42][44]="0.00002626920469555007";
        results[42][45]="3.383082428693337E-21";
        results[42][46]="1.841949575985368E+19";
        results[42][47]="1.229837371638349E-26";
        results[42][48]="152524432145942.5";
        results[42][49]="5.208442236736284E-31";
        results[42][50]="5140293669.325014";
        results[42][51]="1.296425634527369E-36";
        results[42][52]="92108.04505293148";
        results[42][53]="2.700461535017569E-41";
        results[42][54]="0.3756270036031754";
        results[42][55]="1.367701979050812E-25";
        results[42][56]="1.578801102230280E+23";
        results[42][57]="1.371821232626794E-30";
        results[42][58]="1.261915397360943E+18";
        results[42][59]="2.691723687946608E-35";
        results[42][60]="65179890502974.45";
        results[42][61]="1.244300874447829E-40";
        results[42][62]="465998328.3633725";
        results[42][63]="1.058324044509485E-45";
        results[42][64]="4869.178835365991";
        results[42][65]="1.148246107257210E-29";
        results[42][66]="1.023673834038115E+27";
        results[42][67]="3.706553195815928E-34";
        results[42][68]="2.183859840685134E+22";
        results[42][69]="1.646275491848131E-39";
        results[42][70]="1.603452775675989E+17";
        results[42][71]="1.006086934575439E-44";
        results[42][72]="3908153501227.777";
        results[42][73]="1.906425361460782E-49";
        results[42][74]="10915018.37993031";
        results[43][0]="2.278801107346606E+36";
        results[43][1]="5.010812670929508E+30";
        results[43][2]="1.124264543740979E+26";
        results[43][3]="1.311015082733337E+21";
        results[43][4]="9150468694555485";
        results[43][5]="2.854889460681936E+31";
        results[43][6]="1.774183082168003E+40";
        results[43][7]="2.737821187083793E+26";
        results[43][8]="2.615480077546344E+34";
        results[43][9]="2.552040580472019E+21";
        results[43][10]="9.313833025008547E+29";
        results[43][11]="3.092600945563700E+16";
        results[43][12]="4.152521525954315E+24";
        results[43][13]="389101492911.9866";
        results[43][14]="3.128663507069788E+19";
        results[43][15]="3.360955124054725E+27";
        results[43][16]="3.861067223485925E+43";
        results[43][17]="3.977797696073652E+22";
        results[43][18]="3.030213233404445E+38";
        results[43][19]="2.563874912653335E+17";
        results[43][20]="1.025447991701273E+34";
        results[43][21]="4780354900735.599";
        results[43][22]="5.891196673382220E+28";
        results[43][23]="52393070.69974453";
        results[43][24]="3.120495211724467E+23";
        results[43][25]="3.123823451568468E+23";
        results[43][26]="8.367076862526411E+47";
        results[43][27]="3.641687307612366E+18";
        results[43][28]="1.290391144673877E+43";
        results[43][29]="62164195833605.98";
        results[43][30]="2.908182788312382E+37";
        results[43][31]="758487966.3133965";
        results[43][32]="5.912488283338024E+32";
        results[43][33]="3263.668678379727";
        results[43][34]="1.564182465516227E+28";
        results[43][35]="3.839716512812981E+19";
        results[43][36]="8.090976486489524E+51";
        results[43][37]="324870292108974.2";
        results[43][38]="3.959776503909459E+46";
        results[43][39]="3462462090.893108";
        results[43][40]="7.179423583569754E+41";
        results[43][41]="55433.42761611934";
        results[43][42]="2.592757622182496E+36";
        results[43][43]="1";
        results[43][44]="6.810968070305965E+31";
        results[43][45]="8771512753466319";
        results[43][46]="4.775728802811879E+55";
        results[43][47]="31886702193.60218";
        results[43][48]="3.954588840154493E+50";
        results[43][49]="1350422.830899525";
        results[43][50]="1.332753559139886E+46";
        results[43][51]="3.361317445513614";
        results[43][52]="2.388138358753168E+41";
        results[43][53]="0.00007001642228327445";
        results[43][54]="9.739097766897050E+35";
        results[43][55]="354611973105.8077";
        results[43][56]="4.093448591717685E+59";
        results[43][57]="3556799.957164907";
        results[43][58]="3.271840765057037E+54";
        results[43][59]="69.78987108732747";
        results[43][60]="1.689956579146075E+50";
        results[43][61]="0.0003226170576512954";
        results[43][62]="1.208220717788436E+45";
        results[43][63]="2.743977733140975E-9";
        results[43][64]="1.262460053916486E+40";
        results[43][65]="29771238.46732512";
        results[43][66]="2.654138135831102E+63";
        results[43][67]="961.0194050476638";
        results[43][68]="5.662219247714633E+58";
        results[43][69]="0.004268393329701480";
        results[43][70]="4.157364405943601E+53";
        results[43][71]="2.608539568198692E-8";
        results[43][72]="1.013289477896753E+49";
        results[43][73]="4.942898887049463E-13";
        results[43][74]="2.829999710082635E+43";
        results[44][0]="33457.81515672613";
        results[44][1]="0.07356975717997179";
        results[44][2]="0.000001650667764311622";
        results[44][3]="1.924858653278701E-11";
        results[44][4]="1.343490176447769E-16";
        results[44][5]="0.4191605996698921";
        results[44][6]="260489120.4677608";
        results[44][7]="0.000004019724008133258";
        results[44][8]="384.0100336028812";
        results[44][9]="3.746957193351482E-11";
        results[44][10]="0.01367475655276438";
        results[44][11]="4.540618769080169E-16";
        results[44][12]="6.096815435177592E-8";
        results[44][13]="5.712866201918743E-21";
        results[44][14]="4.593566545569257E-13";
        results[44][15]="0.00004934621759141124";
        results[44][16]="566889637953.1077";
        results[44][17]="5.840282401874423E-10";
        results[44][18]="4449019.878121849";
        results[44][19]="3.764332597345680E-15";
        results[44][20]="150.5583319604680";
        results[44][21]="7.018612995084639E-20";
        results[44][22]="0.0008649573177513917";
        results[44][23]="7.692455779988837E-25";
        results[44][24]="4.581573690425900E-9";
        results[44][25]="4.586460278954353E-9";
        results[44][26]="1.228471015596839E+16";
        results[44][27]="5.346798384636640E-14";
        results[44][28]="189457817354.8698";
        results[44][29]="9.127071980358501E-19";
        results[44][30]="426985.2329790381";
        results[44][31]="1.113627253106948E-23";
        results[44][32]="8.680833946520647";
        results[44][33]="4.791783847304273E-29";
        results[44][34]="0.0002296564085119783";
        results[44][35]="5.637548837665439E-13";
        results[44][36]="1.187933404322369E+20";
        results[44][37]="4.769810822125617E-18";
        results[44][38]="581382332589848.2";
        results[44][39]="5.083656324845414E-23";
        results[44][40]="10540973778.55897";
        results[44][41]="8.138847083690577E-28";
        results[44][42]="38067.38771080486";
        results[44][43]="1.468220067511016E-32";
        results[44][44]="1";
        results[44][45]="1.287851104706806E-16";
        results[44][46]="7.011820865278762E+23";
        results[44][47]="4.681669604739426E-22";
        results[44][48]="5.806206693869941E+18";
        results[44][49]="1.982717899951718E-26";
        results[44][50]="195677552057591.1";
        results[44][51]="4.935153726777955E-32";
        results[44][52]="3506312662.314225";
        results[44][53]="1.027995162516290E-36";
        results[44][54]="14299.13878080998";
        results[44][55]="5.206484150936237E-21";
        results[44][56]="6.010083367684613E+27";
        results[44][57]="5.222165073231839E-26";
        results[44][58]="4.803782268957339E+22";
        results[44][59]="1.024668892394211E-30";
        results[44][60]="2.481228162724536E+18";
        results[44][61]="4.736728381649903E-36";
        results[44][62]="17739339038395.46";
        results[44][63]="4.028763172600968E-41";
        results[44][64]="185356918.5591225";
        results[44][65]="4.371072975238266E-25";
        results[44][66]="3.896858872973504E+31";
        results[44][67]="1.410987975758478E-29";
        results[44][68]="8.313383926141755E+26";
        results[44][69]="6.266940742697879E-35";
        results[44][70]="6.103925848762411E+21";
        results[44][71]="3.829910140925841E-40";
        results[44][72]="1.487731945645773E+17";
        results[44][73]="7.257263337643890E-45";
        results[44][74]="415506236539.3683";
        results[45][0]="2.597956785100805E+20";
        results[45][1]="571259805664574.7";
        results[45][2]="12817225207.78065";
        results[45][3]="149462.8258067859";
        results[45][4]="1.043203031420026";
        results[45][5]="3254728734851059";
        results[45][6]="2.022664883508130E+24";
        results[45][7]="31212645572.47396";
        results[45][8]="2.981789060858130E+18";
        results[45][9]="290946.4595446784";
        results[45][10]="106182745061026.3";
        results[45][11]="3.525732712799818";
        results[45][12]="473409962.7585133";
        results[45][13]="0.00004435967932193017";
        results[45][14]="3566.845987692836";
        results[45][15]="383167102245.4531";
        results[45][16]="4.401825924450844E+27";
        results[45][17]="4534904.990592084";
        results[45][18]="3.454607339203797E+22";
        results[45][19]="29.22956375615078";
        results[45][20]="1.169066295088082E+18";
        results[45][21]="0.0005449863706629740";
        results[45][22]="6716283540777.093";
        results[45][23]="5.973094057127134E-9";
        results[45][24]="35575336.88235604";
        results[45][25]="35613280.62065461";
        results[45][26]="9.538921161825726E+31";
        results[45][27]="415.1720928836645";
        results[45][28]="1.471115850756691E+27";
        results[45][29]="0.007087055286904757";
        results[45][30]="3.315486017121880E+21";
        results[45][31]="8.647173955412170E-8";
        results[45][32]="6.740557130241340E+16";
        results[45][33]="3.720759200959941E-13";
        results[45][34]="1783252797412.961";
        results[45][35]="4377.484956965496";
        results[45][36]="9.224151767085032E+35";
        results[45][37]="0.03703697426428437";
        results[45][38]="4.514359854683718E+30";
        results[45][39]="3.947394466849308E-7";
        results[45][40]="8.184932046906727E+25";
        results[45][41]="6.319711225890107E-12";
        results[45][42]="2.955884230069542E+20";
        results[45][43]="1.140054205136760E-16";
        results[45][44]="7764872789604521";
        results[45][45]="1";
        results[45][46]="5.444589704238428E+39";
        results[45][47]="0.000003635256892375972";
        results[45][48]="4.508445636805033E+34";
        results[45][49]="1.539555227079692E-10";
        results[45][50]="1.519411299508411E+30";
        results[45][51]="3.832084088557348E-16";
        results[45][52]="2.722607178344951E+25";
        results[45][53]="7.982251665267820E-21";
        results[45][54]="1.110309936338901E+20";
        results[45][55]="0.00004042768711311199";
        results[45][56]="4.666753280498896E+43";
        results[45][57]="4.054944747996101E-10";
        results[45][58]="3.730075822741150E+38";
        results[45][59]="7.956423600906009E-15";
        results[45][60]="1.926642104554017E+34";
        results[45][61]="3.678009332242079E-20";
        results[45][62]="1.377437110048061E+29";
        results[45][63]="3.128283353469004E-25";
        results[45][64]="1.439272893284671E+24";
        results[45][65]="3.394082560680328E-9";
        results[45][66]="3.025861342768090E+47";
        results[45][67]="1.095614213942617E-13";
        results[45][68]="6.455236863763371E+42";
        results[45][69]="4.866199764703870E-19";
        results[45][70]="4.739620773281892E+37";
        results[45][71]="2.973876503990548E-24";
        results[45][72]="1.155204930297025E+33";
        results[45][73]="5.635172661746553E-29";
        results[45][74]="3.226353070015521E+27";
        results[46][0]="4.771630051532411E-20";
        results[46][1]="1.049224710578041E-25";
        results[46][2]="2.354121413006176E-30";
        results[46][3]="2.745162334095334E-35";
        results[46][4]="1.916036080015227E-40";
        results[46][5]="5.977913693510024E-25";
        results[46][6]="3.714999648060815E-16";
        results[46][7]="5.732781948321280E-30";
        results[46][8]="5.476609299938448E-22";
        results[46][9]="5.343771989249925E-35";
        results[46][10]="1.950243284234377E-26";
        results[46][11]="6.475662821856263E-40";
        results[46][12]="8.695053043023237E-32";
        results[46][13]="8.147478824234940E-45";
        results[46][14]="6.551174985538704E-37";
        results[46][15]="7.037575337351325E-29";
        results[46][16]="8.084770687172574E-13";
        results[46][17]="8.329195103649068E-34";
        results[46][18]="6.345027865946450E-18";
        results[46][19]="5.368552148823365E-39";
        results[46][20]="2.147207335344303E-22";
        results[46][21]="1.000968668472338E-43";
        results[46][22]="1.233570187216990E-27";
        results[46][23]="1.097069638227704E-48";
        results[46][24]="6.534071218380670E-33";
        results[46][25]="6.541040290498085E-33";
        results[46][26]="1.752E-8";
        results[46][27]="7.625406420624627E-38";
        results[46][28]="2.701977432039512E-13";
        results[46][29]="1.301669303269579E-42";
        results[46][30]="6.089505724445841E-19";
        results[46][31]="1.588214066650539E-47";
        results[46][32]="1.238028482659409E-23";
        results[46][33]="6.833865181913444E-53";
        results[46][34]="3.275274895415460E-28";
        results[46][35]="8.040063980501181E-37";
        results[46][36]="0.0001694186755689661";
        results[46][37]="6.802528064778204E-42";
        results[46][38]="8.291460146518372E-10";
        results[46][39]="7.250122931717692E-47";
        results[46][40]="1.503314756763955E-14";
        results[46][41]="1.160732317619898E-51";
        results[46][42]="5.429030267916215E-20";
        results[46][43]="2.093921244881440E-56";
        results[46][44]="1.426163074062281E-24";
        results[46][45]="1.836685690423163E-40";
        results[46][46]="1";
        results[46][47]="6.676824315239122E-46";
        results[46][48]="0.000008280597587170547";
        results[46][49]="2.827679055193452E-50";
        results[46][50]="2.790680991674361E-10";
        results[46][51]="7.038334009951569E-56";
        results[46][52]="5.000573645109554E-15";
        results[46][53]="1.466088741095387E-60";
        results[46][54]="2.039290372008313E-20";
        results[46][55]="7.425295441755768E-45";
        results[46][56]="8571.358971027673";
        results[46][57]="7.447658994100996E-50";
        results[46][58]="0.06850976887822076";
        results[46][59]="1.461344937472920E-54";
        results[46][60]="0.000003538635984001130";
        results[46][61]="6.755347109771878E-60";
        results[46][62]="2.529919029483109E-11";
        results[46][63]="5.745673270905503E-65";
        results[46][64]="2.643491927709899E-16";
        results[46][65]="6.233862871316364E-49";
        results[46][66]="55575562.29466768";
        results[46][67]="2.012298948972625E-53";
        results[46][68]="1185.624117596628";
        results[46][69]="8.937679474572159E-59";
        results[46][70]="0.008705193652319216";
        results[46][71]="5.462076419965100E-64";
        results[46][72]="2.121748364982833E-7";
        results[46][73]="1.035004099089370E-68";
        results[46][74]="5.925796515950347E-13";
        results[47][0]="7.146556246270681E+25";
        results[47][1]="1.571442741399231E+20";
        results[47][2]="3525810028628656";
        results[47][3]="41114790572.36538";
        results[47][4]="286968.1737232600";
        results[47][5]="8.953228977234115E+20";
        results[47][6]="5.564021865277680E+29";
        results[47][7]="8586090748616571";
        results[47][8]="8.202416360482460E+23";
        results[47][9]="80034635283.92306";
        results[47][10]="2.920914482927399E+19";
        results[47][11]="969871.6809241588";
        results[47][12]="130227375058794.5";
        results[47][13]="12.20262573876507";
        results[47][14]="981181273.6462696";
        results[47][15]="1.054030330150941E+17";
        results[47][16]="1.210870663276248E+33";
        results[47][17]="1247478548243.150";
        results[47][18]="9.503062483559163E+27";
        results[47][19]="8040577.219577623";
        results[47][20]="3.215911088814389E+23";
        results[47][21]="149.9168798238013";
        results[47][22]="1.847540281090668E+18";
        results[47][23]="0.001643100951037101";
        results[47][24]="9786196116419.247";
        results[47][25]="9796633821214.788";
        results[47][26]="2.624001946556017E+37";
        results[47][27]="114207084.9942909";
        results[47][28]="4.046800251839102E+32";
        results[47][29]="1949.533553397026";
        results[47][30]="9.120362371295601E+26";
        results[47][31]="0.02378696805044898";
        results[47][32]="1.854217550450959E+22";
        results[47][33]="1.023520293369992E-7";
        results[47][34]="4.905438185545787E+17";
        results[47][35]="1204174859.319065";
        results[47][36]="2.537414009565692E+41";
        results[47][37]="10188.26876910955";
        results[47][38]="1.241826915768028E+36";
        results[47][39]="0.1085863966072925";
        results[47][40]="2.251541579928655E+31";
        results[47][41]="0.000001738449692274594";
        results[47][42]="8.131156387513517E+25";
        results[47][43]="3.136103551657476E-11";
        results[47][44]="2.135990115551220E+21";
        results[47][45]="275083.7229955457";
        results[47][46]="1.497718006025124E+45";
        results[47][47]="1";
        results[47][48]="1.240200010695352E+40";
        results[47][49]="0.00004235065836223342";
        results[47][50]="4.179653170302738E+35";
        results[47][51]="1.054143957912348E-10";
        results[47][52]="7.489449188735266E+30";
        results[47][53]="2.195787505969266E-15";
        results[47][54]="3.054281909670523E+25";
        results[47][55]="11.12099868317389";
        results[47][56]="1.283747866701312E+49";
        results[47][57]="0.0001115449297820002";
        results[47][58]="1.026083144375309E+44";
        results[47][59]="2.188682625866851E-9";
        results[47][60]="5.299878830006924E+39";
        results[47][61]="1.011760500325512E-14";
        results[47][62]="3.789105284242457E+34";
        results[47][63]="8.605398314572440E-20";
        results[47][64]="3.959205458913181E+29";
        results[47][65]="0.0009336568669461997";
        results[47][66]="8.323652034369472E+52";
        results[47][67]="3.013856369381733E-8";
        results[47][68]="1.775730589302118E+48";
        results[47][69]="1.338612348114789E-13";
        results[47][70]="1.303792527901410E+43";
        results[47][71]="8.180650204466976E-19";
        results[47][72]="3.177780730489156E+38";
        results[47][73]="1.550144275515960E-23";
        results[47][74]="8.875172141979778E+32";
        results[48][0]="5.762422338848205E-15";
        results[48][1]="1.267088153400481E-20";
        results[48][2]="2.842936621692024E-25";
        results[48][3]="3.315174183018531E-30";
        results[48][4]="2.313886238094478E-35";
        results[48][5]="7.219181503001472E-20";
        results[48][6]="4.486390757373126E-11";
        results[48][7]="6.923150035938593E-25";
        results[48][8]="6.613785107035720E-17";
        results[48][9]="6.453365150275192E-30";
        results[48][10]="2.355196305223146E-21";
        results[48][11]="7.820284410257130E-35";
        results[48][12]="1.050051394418058E-26";
        results[48][13]="9.839240149597593E-40";
        results[48][14]="7.911476094054727E-32";
        results[48][15]="8.498873738599392E-24";
        results[48][16]="9.763511150087314E-8";
        results[48][17]="1.005868841707006E-28";
        results[48][18]="7.662524110309441E-13";
        results[48][19]="6.483290719429564E-34";
        results[48][20]="2.593058426931717E-17";
        results[48][21]="1.208812115230884E-38";
        results[48][22]="1.489711550683502E-22";
        results[48][23]="1.324867712358631E-43";
        results[48][24]="7.890820861170891E-28";
        results[48][25]="7.899237007522711E-28";
        results[48][26]="0.002115789327468880";
        results[48][27]="9.208763426010420E-33";
        results[48][28]="3.263022268134115E-8";
        results[48][29]="1.571950924515769E-37";
        results[48][30]="7.353944761040615E-14";
        results[48][31]="1.917994504540616E-42";
        results[48][32]="1.495095576891135E-18";
        results[48][33]="8.252864735875365E-48";
        results[48][34]="3.955360541236747E-23";
        results[48][35]="9.709521439561277E-32";
        results[48][36]="20.45971607549835";
        results[48][37]="8.215020707343183E-37";
        results[48][38]="0.0001001311808626548";
        results[48][39]="8.755555206487259E-42";
        results[48][40]="1.815466505814869E-9";
        results[48][41]="1.401749457573287E-46";
        results[48][42]="6.556326654887352E-15";
        results[48][43]="2.528707889543666E-51";
        results[48][44]="1.722294869481269E-19";
        results[48][45]="2.218059350292316E-35";
        results[48][46]="120764.2310199132";
        results[48][47]="8.063215540849113E-41";
        results[48][48]="1";
        results[48][49]="3.414824866715520E-45";
        results[48][50]="0.00003370144439814430";
        results[48][51]="8.499789943731035E-51";
        results[48][52]="6.038904309100998E-10";
        results[48][53]="1.770510794253370E-55";
        results[48][54]="2.462733336018967E-15";
        results[48][55]="8.967100941193022E-40";
        results[48][56]="1035113574.931792";
        results[48][57]="8.994108113211472E-45";
        results[48][58]="8273.529555930313";
        results[48][59]="1.764781976287603E-49";
        results[48][60]="0.4273406534672904";
        results[48][61]="8.158042989841942E-55";
        results[48][62]="0.000003055237261381728";
        results[48][63]="6.938718142525727E-60";
        results[48][64]="3.192392698572340E-11";
        results[48][65]="7.528276559381090E-44";
        results[48][66]="6711540044014.826";
        results[48][67]="2.430137351548587E-48";
        results[48][68]="143180984.8402199";
        results[48][69]="1.079351988849169E-53";
        results[48][70]="1051.276017301760";
        results[48][71]="6.596234586290859E-59";
        results[48][72]="0.02562313097149101";
        results[48][73]="1.249914741289858E-63";
        results[48][74]="7.156242594292246E-8";
        results[49][0]="1.687472290311238E+30";
        results[49][1]="3.710550915072856E+24";
        results[49][2]="8.325277964917845E+19";
        results[49][3]="970818215402995.0";
        results[49][4]="6776002660.189255";
        results[49][5]="2.114070789798686E+25";
        results[49][6]="1.313798198291870E+34";
        results[49][7]="2.027380702131727E+20";
        results[49][8]="1.936786033011718E+28";
        results[49][9]="1889808526690925";
        results[49][10]="6.896975385705340E+23";
        results[49][11]="22900982379.74620";
        results[49][12]="3.074978762902205E+18";
        results[49][13]="288133.0824752154";
        results[49][14]="23168028823874.12";
        results[49][15]="2.488816870650781E+21";
        results[49][16]="2.859154284968690E+37";
        results[49][17]="2.945594228012286E+16";
        results[49][18]="2.243899587646931E+32";
        results[49][19]="189857195390.0929";
        results[49][20]="7.593532693891262E+27";
        results[49][21]="3539894.906509671";
        results[49][22]="4.362483022786321E+22";
        results[49][23]="38.79753030008030";
        results[49][24]="2.310754187742728E+17";
        results[49][25]="2.313218778660363E+17";
        results[49][26]="6.195894108923685E+41";
        results[49][27]="2696701525096.859";
        results[49][28]="9.555460076266186E+36";
        results[49][29]="46033134.51994738";
        results[49][30]="2.153534968284877E+31";
        results[49][31]="561.6670193647148";
        results[49][32]="4.378249647482396E+26";
        results[49][33]="0.002416775400787454";
        results[49][34]="1.158290892101044E+22";
        results[49][35]="28433438956710.49";
        results[49][36]="5.991439348740924E+45";
        results[49][37]="240569312.5704755";
        results[49][38]="2.932249376494788E+40";
        results[49][39]="2563.983673607429";
        results[49][40]="5.316426395714516E+35";
        results[49][41]="0.04104894137430629";
        results[49][42]="1.919959854688953E+30";
        results[49][43]="7.405088074035996E-7";
        results[49][44]="5.043581843006266E+25";
        results[49][45]="6495382448.194808";
        results[49][46]="3.536469240253245E+49";
        results[49][47]="23612.38381341809";
        results[49][48]="2.928407865794388E+44";
        results[49][49]="1";
        results[49][50]="9.869157486415798E+39";
        results[49][51]="0.000002489085172882200";
        results[49][52]="1.768437487955098E+35";
        results[49][53]="5.184777736365438E-11";
        results[49][54]="7.211887672551995E+29";
        results[49][55]="262593.2892956190";
        results[49][56]="3.031234734820807E+53";
        results[49][57]="2.633841694453359";
        results[49][58]="2.422826902946868E+48";
        results[49][59]="0.00005168001420772782";
        results[49][60]="1.251427730987327E+44";
        results[49][61]="2.389007726094191E-10";
        results[49][62]="8.946980828098355E+38";
        results[49][63]="2.031939678710256E-15";
        results[49][64]="9.348627889203813E+33";
        results[49][65]="22.04586429236709";
        results[49][66]="1.965412665648703E+57";
        results[49][67]="0.0007116433335235624";
        results[49][68]="4.192923222382870E+52";
        results[49][69]="3.160782854106722E-9";
        results[49][70]="3.078564958187471E+47";
        results[49][71]="1.931646524711914E-14";
        results[49][72]="7.503497828319405E+42";
        results[49][73]="3.660260159965578E-19";
        results[49][74]="2.095639710265825E+37";
        results[50][0]="1.709844323220016E-10";
        results[50][1]="3.759744355260485E-16";
        results[50][2]="8.435652158126978E-21";
        results[50][3]="9.836890501942623E-26";
        results[50][4]="6.865836997247178E-31";
        results[50][5]="2.142098545603874E-15";
        results[50][6]="0.000001331216165209868";
        results[50][7]="2.054259145142100E-20";
        results[50][8]="1.962463397384800E-12";
        results[50][9]="1.914863076500820E-25";
        results[50][10]="6.988413545126361E-17";
        results[50][11]="2.320459716168051E-30";
        results[50][12]="3.115745966294182E-22";
        results[50][13]="2.919530698256769E-35";
        results[50][14]="2.347518403243974E-27";
        results[50][15]="2.521812904573124E-19";
        results[50][16]="0.002897060148147514";
        results[50][17]="2.984646087638879E-24";
        results[50][18]="2.273648577130825E-8";
        results[50][19]="1.923742686763465E-29";
        results[50][20]="7.694205614150171E-13";
        results[50][21]="3.586825837344361E-34";
        results[50][22]="4.420319595457841E-18";
        results[50][23]="3.931189704235886E-39";
        results[50][24]="2.341389516707296E-23";
        results[50][25]="2.343886782477983E-23";
        results[50][26]="62.78037530003851";
        results[50][27]="2.732453635286172E-28";
        results[50][28]="0.0009682143677835323";
        results[50][29]="4.664342886746792E-33";
        results[50][30]="2.182085929066454E-9";
        results[50][31]="5.691134427004636E-38";
        results[50][32]="4.436295249628704E-14";
        results[50][33]="2.448816329168904E-43";
        results[50][34]="1.173647186900553E-18";
        results[50][35]="2.881040149156310E-27";
        results[50][36]="607087.2166127371";
        results[50][37]="2.437587128400801E-32";
        results[50][38]="2.971124313834108";
        results[50][39]="2.597976247857604E-37";
        results[50][40]="0.00005386910081262968";
        results[50][41]="4.159315669124470E-42";
        results[50][42]="1.945414142323337E-10";
        results[50][43]="7.503262648537709E-47";
        results[50][44]="5.110448232230970E-15";
        results[50][45]="6.581496401425599E-31";
        results[50][46]="3583354754.568408";
        results[50][47]="2.392543015543006E-36";
        results[50][48]="29672.31873465527";
        results[50][49]="1.013257718682096E-40";
        results[50][50]="1";
        results[50][51]="2.522084763880048E-46";
        results[50][52]="0.00001791882934677280";
        results[50][53]="5.253516061023365E-51";
        results[50][54]="7.307500850481565E-11";
        results[50][55]="2.660746772529066E-35";
        results[50][56]="30714219921944.59";
        results[50][57]="2.668760426691597E-40";
        results[50][58]="245494806.0441551";
        results[50][59]="5.236517329758060E-45";
        results[50][60]="12680.18807795731";
        results[50][61]="2.420680518456101E-50";
        results[50][62]="0.09065597382971390";
        results[50][63]="2.058878563349585E-55";
        results[50][64]="9.472569367822474E-7";
        results[50][65]="2.233814215925896E-39";
        results[50][66]="1.991469553864102E+17";
        results[50][67]="7.210781006414067E-44";
        results[50][68]="4248511818920.849";
        results[50][69]="3.202687624001662E-49";
        results[50][70]="31193797.06347679";
        results[50][71]="1.957255750929793E-54";
        results[50][72]="760.2977091658982";
        results[50][73]="3.708786859469685E-59";
        results[50][74]="0.002123423112003558";
        results[51][0]="6.779487936755711E+35";
        results[51][1]="1.490728784815458E+30";
        results[51][2]="3.344713975889266E+25";
        results[51][3]="3.900301307403033E+20";
        results[51][4]="2722286378148756";
        results[51][5]="8.493364601705167E+30";
        results[51][6]="5.278237211829022E+39";
        results[51][7]="8.145083680620504E+25";
        results[51][8]="7.781115946181321E+33";
        results[51][9]="7.592381921196569E+20";
        results[51][10]="2.770887658182901E+29";
        results[51][11]="9200561969210697";
        results[51][12]="1.235385111125618E+24";
        results[51][13]="115758627151.1858";
        results[51][14]="9.307848954420085E+18";
        results[51][15]="9.998922084971854E+26";
        results[51][16]="1.148676757275435E+43";
        results[51][17]="1.183404352773304E+22";
        results[51][18]="9.014957029568579E+37";
        results[51][19]="7.627589343206385E+16";
        results[51][20]="3.050732364091198E+33";
        results[51][21]="1422167045577.915";
        results[51][22]="1.752645136580379E+28";
        results[51][23]="15587064.16428300";
        results[51][24]="9.283548079903686E+22";
        results[51][25]="9.293449673246033E+22";
        results[51][26]="2.489225429658254E+47";
        results[51][27]="1.083410706261310E+18";
        results[51][28]="3.838944597143528E+42";
        results[51][29]="18493997321370.88";
        results[51][30]="8.651913529303709E+36";
        results[51][31]="225651988.7241708";
        results[51][32]="1.758979441596474E+32";
        results[51][33]="970.9492576298560";
        results[51][34]="4.653480341774795E+27";
        results[51][35]="1.142324869654275E+19";
        results[51][36]="2.407084905737968E+51";
        results[51][37]="96649690895033.44";
        results[51][38]="1.178043004892208E+46";
        results[51][39]="1030090774.530830";
        results[51][40]="2.135895731345520E+41";
        results[51][41]="16491.57763724665";
        results[51][42]="7.713516096621809E+35";
        results[51][43]="0.2975023978573374";
        results[51][44]="2.026279332645786E+31";
        results[51][45]="2609546076992446";
        results[51][46]="1.420790770352885E+55";
        results[51][47]="9486370362.359466";
        results[51][48]="1.176499662485828E+50";
        results[51][49]="401754.0303139023";
        results[51][50]="3.964973795970168E+45";
        results[51][51]="1";
        results[51][52]="7.104768881441538E+40";
        results[51][53]="0.00002083005351866606";
        results[51][54]="2.897404938618912E+35";
        results[51][55]="105497912307.8994";
        results[51][56]="1.217810771541752E+59";
        results[51][57]="1058156.515955435";
        results[51][58]="9.733804730118538E+53";
        results[51][59]="20.76265399463438";
        results[51][60]="5.027661345707404E+49";
        results[51][61]="0.00009597934824093921";
        results[51][62]="3.594485606829729E+44";
        results[51][63]="8.163399552765810E-10";
        results[51][64]="3.755848932392581E+39";
        results[51][65]="8857014.831211825";
        results[51][66]="7.896124596543564E+62";
        results[51][67]="285.9055773891117";
        results[51][68]="1.684523803389072E+58";
        results[51][69]="0.001269857250584455";
        results[51][70]="1.236825879534966E+53";
        results[51][71]="7.760467764448543E-9";
        results[51][72]="3.014560493978934E+48";
        results[51][73]="1.470524271263579E-13";
        results[51][74]="8.419316996851535E+42";
        results[52][0]="0.000009542165339768479";
        results[52][1]="2.098208695724657E-11";
        results[52][2]="4.707702715884311E-16";
        results[52][3]="5.489694840870986E-21";
        results[52][4]="3.831632560574457E-26";
        results[52][5]="1.195445586399130E-10";
        results[52][6]="0.07429146957357580";
        results[52][7]="1.146424861461206E-15";
        results[52][8]="1.095196209197808E-7";
        results[52][9]="1.068631794769388E-20";
        results[52][10]="3.900039120795011E-12";
        results[52][11]="1.294983992124446E-25";
        results[52][12]="1.738811116505963E-17";
        results[52][13]="1.629308835837862E-30";
        results[52][14]="1.310084692372364E-22";
        results[52][15]="1.407353603167891E-14";
        results[52][16]="161.6768647148971";
        results[52][17]="1.665647922572809E-19";
        results[52][18]="0.001268859998122764";
        results[52][19]="1.073587258148610E-24";
        results[52][20]="4.293922033213574E-8";
        results[52][21]="2.001707682980056E-29";
        results[52][22]="2.466857354302527E-13";
        results[52][23]="2.193887573879874E-34";
        results[52][24]="1.306664331355432E-18";
        results[52][25]="1.308057985886294E-18";
        results[52][26]="3503598.035624204";
        results[52][27]="1.524906333112822E-23";
        results[52][28]="54.03334944745757";
        results[52][29]="2.603039962310287E-28";
        results[52][30]="0.0001217761432311118";
        results[52][31]="3.176063746613903E-33";
        results[52][32]="2.475772922312967E-9";
        results[52][33]="1.366616245837476E-38";
        results[52][34]="6.549798338873787E-14";
        results[52][35]="1.607828331528359E-22";
        results[52][36]="33879848111.95684";
        results[52][37]="1.360349541383301E-27";
        results[52][38]="165810.1796906287";
        results[52][39]="1.449858245525120E-32";
        results[52][40]="3.006284605435543";
        results[52][41]="2.321198326426144E-37";
        results[52][42]="0.00001085681494407283";
        results[52][43]="4.187362077807307E-42";
        results[52][44]="2.851998941075561E-10";
        results[52][45]="3.672949986886802E-26";
        results[52][46]="199977056827865.5";
        results[52][47]="1.335211675518248E-31";
        results[52][48]="1655929534.258291";
        results[52][49]="5.654709351113861E-36";
        results[52][50]="55807.21712605078";
        results[52][51]="1.407505320281584E-41";
        results[52][52]="1";
        results[52][53]="2.931841114927259E-46";
        results[52][54]="0.000004078112866116254";
        results[52][55]="1.484888728519684E-30";
        results[52][56]="1.714075140041236E+18";
        results[52][57]="1.489360925897899E-35";
        results[52][58]="13700381944223.89";
        results[52][59]="2.922354596061357E-40";
        results[52][60]="707646009.2657238";
        results[52][61]="1.350914432862808E-45";
        results[52][62]="5059.257615288420";
        results[52][63]="1.149002830210218E-50";
        results[52][64]="0.05286377354516463";
        results[52][65]="1.246629549674354E-34";
        results[52][66]="1.111383737924134E+22";
        results[52][67]="4.024136212733528E-39";
        results[52][68]="2.370976215411088E+17";
        results[52][69]="1.787330836195764E-44";
        results[52][70]="1740839005707.414";
        results[52][71]="1.092289966633505E-49";
        results[52][72]="42430099.33586029";
        results[52][73]="2.069770735406687E-54";
        results[52][74]="118.5023346620570";
        results[53][0]="3.254666595398102E+40";
        results[53][1]="7.156624842464271E+34";
        results[53][2]="1.605715497990454E+30";
        results[53][3]="1.872439407756647E+25";
        results[53][4]="1.306903208726412E+20";
        results[53][5]="4.077456927364187E+35";
        results[53][6]="2.533952784662378E+44";
        results[53][7]="3.910255762579582E+30";
        results[53][8]="3.735523741793833E+38";
        results[53][9]="3.644917145504665E+25";
        results[53][10]="1.330235496370605E+34";
        results[53][11]="4.416965112915320E+20";
        results[53][12]="5.930782222996091E+28";
        results[53][13]="5557288993398558";
        results[53][14]="4.468470974440470E+23";
        results[53][15]="4.800238307602860E+31";
        results[53][16]="5.514516591357251E+47";
        results[53][17]="5.681235296456829E+26";
        results[53][18]="4.327860714083221E+42";
        results[53][19]="3.661819369005083E+21";
        results[53][20]="1.464582105541592E+38";
        results[53][21]="6.827476675964822E+16";
        results[53][22]="8.414021284245927E+32";
        results[53][23]="748296885090.3456";
        results[53][24]="4.456804718040974E+27";
        results[53][25]="4.461558231196124E+27";
        results[53][26]="1.195016338977540E+52";
        results[53][27]="5.201190219172758E+22";
        results[53][28]="1.842983549563809E+47";
        results[53][29]="8.878516468907865E+17";
        results[53][30]="4.153572395553678E+41";
        results[53][31]="10833000910053.42";
        results[53][32]="8.444430735716701E+36";
        results[53][33]="46612902.68696511";
        results[53][34]="2.234022268644081E+32";
        results[53][35]="5.484022730093443E+23";
        results[53][36]="1.155582679411242E+56";
        results[53][37]="4.639915630001839E+18";
        results[53][38]="5.655496774583657E+50";
        results[53][39]="49452142482867.52";
        results[53][40]="1.025391379542793E+46";
        results[53][41]="791720367.9994558";
        results[53][42]="3.703070704887838E+40";
        results[53][43]="14282.36358541959";
        results[53][44]="9.727672234879347E+35";
        results[53][45]="1.252779343391509E+20";
        results[53][46]="6.820869514711989E+59";
        results[53][47]="455417474269022.8";
        results[53][48]="5.648087564592924E+54";
        results[53][49]="19287229864.95862";
        results[53][50]="1.903487090139787E+50";
        results[53][51]="48007.55788283925";
        results[53][52]="3.410826033199997E+45";
        results[53][53]="1";
        results[53][54]="1.390973353007717E+40";
        results[53][55]="5064697131640181";
        results[53][56]="5.846412110513578E+63";
        results[53][57]="50799510188.83404";
        results[53][58]="4.672961940014202E+58";
        results[53][59]="996764.3134487737";
        results[53][60]="2.413657430693617E+54";
        results[53][61]="4.607734116234075";
        results[53][62]="1.725624758289108E+49";
        results[53][63]="0.00003919048765501487";
        results[53][64]="1.803091350210368E+44";
        results[53][65]="425203652178.5674";
        results[53][66]="3.790736586186758E+67";
        results[53][67]="13725628.55553436";
        results[53][68]="8.086987399622141E+62";
        results[53][69]="60.96274546037631";
        results[53][70]="5.937699000276846E+57";
        results[53][71]="0.0003725611053996715";
        results[53][72]="1.447216874060142E+53";
        results[53][73]="7.059627907080629E-9";
        results[53][74]="4.041908480603224E+47";
        results[54][0]="2.339848271255880";
        results[54][1]="0.000005145048125465107";
        results[54][2]="1.154382644727447E-10";
        results[54][3]="1.346136073496915E-15";
        results[54][4]="9.395602050179328E-21";
        results[54][5]="0.00002931369546761954";
        results[54][6]="18217.11953851009";
        results[54][7]="2.811165112634539E-10";
        results[54][8]="0.02685546587730432";
        results[54][9]="2.620407599917871E-15";
        results[54][10]="9.563342773563720E-7";
        results[54][11]="3.175449122274317E-20";
        results[54][12]="4.263764083022794E-12";
        results[54][13]="3.995251944533639E-25";
        results[54][14]="3.212477769454207E-17";
        results[54][15]="3.450992283369952E-9";
        results[54][16]="39645019.65068670";
        results[54][17]="4.084359548780881E-14";
        results[54][18]="311.1390095809556";
        results[54][19]="2.632558963898978E-19";
        results[54][20]="0.01052918880419032";
        results[54][21]="4.908416585552623E-24";
        results[54][22]="6.049016874444212E-8";
        results[54][23]="5.379663697167850E-29";
        results[54][24]="3.204090652350726E-13";
        results[54][25]="3.207508052939222E-13";
        results[54][26]="859122381024.4411";
        results[54][27]="3.739245045871056E-18";
        results[54][28]="13249596.37493202";
        results[54][29]="6.382952232485079E-23";
        results[54][30]="29.86090557789883";
        results[54][31]="7.788072206149096E-28";
        results[54][32]="0.0006070878868712484";
        results[54][33]="3.351099615688073E-33";
        results[54][34]="1.606085597408052E-8";
        results[54][35]="3.942579286824783E-17";
        results[54][36]="8307726937489580";
        results[54][37]="3.335732938354928E-22";
        results[54][38]="40658555840.44592";
        results[54][39]="3.555218536425345E-27";
        results[54][40]="737175.4299430523";
        results[54][41]="5.691844249118863E-32";
        results[54][42]="2.662215416909782";
        results[54][43]="1.026789158436190E-36";
        results[54][44]="0.00006993428173045223";
        results[54][45]="9.006494198343990E-21";
        results[54][46]="4.903666558358682E+19";
        results[54][47]="3.274092011067419E-26";
        results[54][48]="406052894714338.1";
        results[54][49]="1.386599522072340E-30";
        results[54][50]="13684569053.92081";
        results[54][51]="3.451364311115807E-36";
        results[54][52]="245211.4575613350";
        results[54][53]="7.189210331295627E-41";
        results[54][54]="1";
        results[54][55]="3.641117294367092E-25";
        results[54][56]="4.203108634591608E+23";
        results[54][57]="3.652083634743231E-30";
        results[54][58]="3.359490625690135E+18";
        results[54][59]="7.165948300112717E-35";
        results[54][60]="173522909369510.1";
        results[54][61]="3.312596971229334E-40";
        results[54][62]="1240587934.023157";
        results[54][63]="2.817486587379466E-45";
        results[54][64]="12962.80296320216";
        results[54][65]="3.056878489146789E-29";
        results[54][66]="2.725240262863416E+27";
        results[54][67]="9.867643061497388E-34";
        results[54][68]="5.813905336242105E+22";
        results[54][69]="4.382739994878830E-39";
        results[54][70]="4.268736699691402E+17";
        results[54][71]="2.678420147978238E-44";
        results[54][72]="10404346502618.53";
        results[54][73]="5.075314988468698E-49";
        results[54][74]="29058130.20690411";
        results[55][0]="6.426182081186150E+24";
        results[55][1]="1.413041028209840E+19";
        results[55][2]="317040773861723.4";
        results[55][3]="3697041222.976872";
        results[55][4]="25804.17297930660";
        results[55][5]="8.050741873371843E+19";
        results[55][6]="5.003167452664180E+28";
        results[55][7]="772061124475030.9";
        results[55][8]="7.375611304488999E+22";
        results[55][9]="7196712953.937829";
        results[55][10]="2.626485773572434E+18";
        results[55][11]="87210.84396777946";
        results[55][12]="11710043204647.52";
        results[55][13]="1.097259885232042";
        results[55][14]="88227802.34034201";
        results[55][15]="9477838818070297";
        results[55][16]="1.088814680922766E+32";
        results[55][17]="112173248444.9072";
        results[55][18]="8.545152062590683E+26";
        results[55][19]="723008.5578324046";
        results[55][20]="2.891746668111807E+22";
        results[55][21]="13.48052311620413";
        results[55][22]="1.661307885852018E+17";
        results[55][23]="0.0001477476077326687";
        results[55][24]="879974577393.4671";
        results[55][25]="880913135619.4773";
        results[55][26]="2.359502074688797E+36";
        results[55][27]="10269499.01244810";
        results[55][28]="3.638882052887863E+31";
        results[55][29]="175.3020217821514";
        results[55][30]="8.201028191015562E+25";
        results[55][31]="0.002138923735908606";
        results[55][32]="1.667312085250398E+21";
        results[55][33]="9.203492622641725E-9";
        results[55][34]="4.410969127231112E+16";
        results[55][35]="108279381.5218219";
        results[55][36]="2.281642217442943E+40";
        results[55][37]="916.1289430349850";
        results[55][38]="1.116650537551916E+35";
        results[55][39]="0.009764086814575751";
        results[55][40]="2.024585780533582E+30";
        results[55][41]="1.563213648163519E-7";
        results[55][42]="7.311534349712662E+24";
        results[55][43]="2.819983745167070E-12";
        results[55][44]="1.920681924711475E+20";
        results[55][45]="24735.52338530067";
        results[55][46]="1.346747759525569E+44";
        results[55][47]="0.08991998187294129";
        results[55][48]="1.115187624805477E+39";
        results[55][49]="0.000003808170432239159";
        results[55][50]="3.758343373088038E+34";
        results[55][51]="9.478860558694889E-12";
        results[55][52]="6.734511352893900E+29";
        results[55][53]="1.974451727335874E-16";
        results[55][54]="2.746409739524259E+24";
        results[55][55]="1";
        results[55][56]="1.154345849032090E+48";
        results[55][57]="0.00001003011806401597";
        results[55][58]="9.226537774235836E+42";
        results[55][59]="1.968063020435687E-10";
        results[55][60]="4.765650083230079E+38";
        results[55][61]="9.097748584902804E-16";
        results[55][62]="3.407162784737478E+33";
        results[55][63]="7.737972604557934E-21";
        results[55][64]="3.560116830967234E+28";
        results[55][65]="0.00008395440855134944";
        results[55][66]="7.484626400471738E+51";
        results[55][67]="2.710059101024540E-9";
        results[55][68]="1.596736624012738E+47";
        results[55][69]="1.203679980773772E-14";
        results[55][70]="1.172370004749711E+42";
        results[55][71]="7.356039180945439E-20";
        results[55][72]="2.857459856817670E+37";
        results[55][73]="1.393889451548389E-24";
        results[55][74]="7.980553181260552E+31";
        results[56][0]="5.566946930657264E-24";
        results[56][1]="1.224105435467771E-29";
        results[56][2]="2.746497283526938E-34";
        results[56][3]="3.202715395976701E-39";
        results[56][4]="2.235393578184839E-44";
        results[56][5]="6.974289273983464E-29";
        results[56][6]="4.334201449989442E-20";
        results[56][7]="6.688299915682963E-34";
        results[56][8]="6.389429399060419E-26";
        results[56][9]="6.234451278160885E-39";
        results[56][10]="2.275302307167926E-30";
        results[56][11]="7.555001305796269E-44";
        results[56][12]="1.014431092247293E-35";
        results[56][13]="9.505469146461484E-49";
        results[56][14]="7.643099545454276E-41";
        results[56][15]="8.210571230465625E-33";
        results[56][16]="9.432309059158727E-17";
        results[56][17]="9.717473193927414E-38";
        results[56][18]="7.402592619669160E-22";
        results[56][19]="6.263361699083869E-43";
        results[56][20]="2.505095566061517E-26";
        results[56][21]="1.167806262525866E-47";
        results[56][22]="1.439176904603599E-31";
        results[56][23]="1.279924970982950E-52";
        results[56][24]="7.623144988404633E-37";
        results[56][25]="7.631275638562877E-37";
        results[56][26]="2.044016597510373E-12";
        results[56][27]="8.896379729748234E-42";
        results[56][28]="3.152332601134258E-17";
        results[56][29]="1.518626518466200E-46";
        results[56][30]="7.104481033905097E-23";
        results[56][31]="1.852931456982391E-51";
        results[56][32]="1.444378291521926E-27";
        results[56][33]="7.972907452613771E-57";
        results[56][34]="3.821185072852883E-32";
        results[56][35]="9.380150811181354E-41";
        results[56][36]="1.976567264789908E-8";
        results[56][37]="7.936347185751581E-46";
        results[56][38]="9.673448719794147E-14";
        results[56][39]="8.458545437455212E-51";
        results[56][40]="1.753881457824083E-18";
        results[56][41]="1.354198700046664E-55";
        results[56][42]="6.333920077629528E-24";
        results[56][43]="2.442927955717607E-60";
        results[56][44]="1.663870430445044E-28";
        results[56][45]="2.142817371937639E-44";
        results[56][46]="0.0001166676140131492";
        results[56][47]="7.789691620439270E-50";
        results[56][48]="9.660775630982277E-10";
        results[56][49]="3.298985685643760E-54";
        results[56][50]="3.255820927704967E-14";
        results[56][51]="8.211456355686501E-60";
        results[56][52]="5.834049958719679E-19";
        results[56][53]="1.710450753551403E-64";
        results[56][54]="2.379191419821972E-24";
        results[56][55]="8.662915025323579E-49";
        results[56][56]="1";
        results[56][57]="8.689006048253338E-54";
        results[56][58]="0.000007992871271614319";
        results[56][59]="1.704916271051602E-58";
        results[56][60]="4.128442171144841E-10";
        results[56][61]="7.881302291277083E-64";
        results[56][62]="2.951596168162563E-15";
        results[56][63]="6.703339914156715E-69";
        results[56][64]="3.084098958689342E-20";
        results[56][65]="7.272899072816394E-53";
        results[56][66]="6483.868250358015";
        results[56][67]="2.347701170578040E-57";
        results[56][68]="0.1383239369164440";
        results[56][69]="1.042737739112631E-62";
        results[56][70]="0.000001015614172938495";
        results[56][71]="6.372474234748120E-68";
        results[56][72]="2.475393192788476E-11";
        results[56][73]="1.207514587345858E-72";
        results[56][74]="6.913485406433592E-17";
        results[57][0]="6.406885781574903E+29";
        results[57][1]="1.408798001370755E+24";
        results[57][2]="3.160887756637065E+19";
        results[57][3]="368593988563342.1";
        results[57][4]="2572668917.216598";
        results[57][5]="8.026567406274776E+24";
        results[57][6]="4.988144128246639E+33";
        results[57][7]="7.697428081578381E+19";
        results[57][8]="7.353464094256007E+27";
        results[57][9]="717510293299212.7";
        results[57][10]="2.618599060159830E+23";
        results[57][11]="8694897050.180986";
        results[57][12]="1.167488072414467E+18";
        results[57][13]="109396.5074218388";
        results[57][14]="8796287518974.268";
        results[57][15]="9.449379117552936E+20";
        results[57][16]="1.085545228853283E+37";
        results[57][17]="1.118364188028252E+16";
        results[57][18]="8.519492999037822E+31";
        results[57][19]="72083753473.07911";
        results[57][20]="2.883063439189447E+27";
        results[57][21]="1344004.430472940";
        results[57][22]="1.656319372562645E+22";
        results[57][23]="14.73039567328003";
        results[57][24]="8.773322225891460E+16";
        results[57][25]="8.782679625475591E+16";
        results[57][26]="2.352417049958506E+41";
        results[57][27]="1023866214425.824";
        results[57][28]="3.627955353728795E+36";
        results[57][29]="17477563.14166077";
        results[57][30]="8.176402449775297E+30";
        results[57][31]="213.2501055578004";
        results[57][32]="1.662305542775258E+26";
        results[57][33]="0.0009175856718636401";
        results[57][34]="4.397724033833556E+21";
        results[57][35]="10795424423794.65";
        results[57][36]="2.274790987384843E+45";
        results[57][37]="91337802.52514549";
        results[57][38]="1.113297501011488E+40";
        results[57][39]="973.4767579262472";
        results[57][40]="2.018506429946206E+35";
        results[57][41]="0.01558519688588414";
        results[57][42]="7.289579547366953E+29";
        results[57][43]="2.811516003270229E-7";
        results[57][44]="1.914914572742777E+25";
        results[57][45]="2466124847.925947";
        results[57][46]="1.342703795638417E+49";
        results[57][47]="8964.997350882443";
        results[57][48]="1.111838981044821E+44";
        results[57][49]="0.3796735400255500";
        results[57][50]="3.747057959937145E+39";
        results[57][51]="9.450397790132930E-7";
        results[57][52]="6.714289213658032E+34";
        results[57][53]="1.968522917411524E-11";
        results[57][54]="2.738162922904441E+29";
        results[57][55]="99699.72373382105";
        results[57][56]="1.150879622417825E+53";
        results[57][57]="1";
        results[57][58]="9.198832671109769E+47";
        results[57][59]="0.00001962153394281874";
        results[57][60]="4.751339967101001E+43";
        results[57][61]="9.070430205145709E-11";
        results[57][62]="3.396931883544830E+38";
        results[57][63]="7.714737309343017E-16";
        results[57][64]="3.549426645075597E+33";
        results[57][65]="8.370231338805882";
        results[57][66]="7.462151843778957E+56";
        results[57][67]="0.0002701921436744741";
        results[57][68]="1.591942002897441E+52";
        results[57][69]="1.200065615470761E-9";
        results[57][70]="1.168849655873646E+47";
        results[57][71]="7.333950741154235E-15";
        results[57][72]="2.848879583052055E+42";
        results[57][73]="1.389703932348617E-19";
        results[57][74]="7.956589474147437E+36";
        results[58][0]="6.964890014465238E-19";
        results[58][1]="1.531496497153692E-24";
        results[58][2]="3.436183556816159E-29";
        results[58][3]="4.006964815448415E-34";
        results[58][4]="2.796734117467348E-39";
        results[58][5]="8.725636929437082E-24";
        results[58][6]="5.422583828394453E-15";
        results[58][7]="8.367831394252054E-29";
        results[58][8]="7.993910050511732E-21";
        results[58][9]="7.800014620905704E-34";
        results[58][10]="2.846664521232035E-25";
        results[58][11]="9.452174380221672E-39";
        results[58][12]="1.269169811166505E-30";
        results[58][13]="1.189243367426543E-43";
        results[58][14]="9.562395396755339E-36";
        results[58][15]="1.027236765294149E-27";
        results[58][16]="1.180090200208327E-11";
        results[58][17]="1.215767508784710E-32";
        results[58][18]="9.261493608634160E-17";
        results[58][19]="7.836184878051788E-38";
        results[58][20]="3.134162281529605E-21";
        results[58][21]="1.461059765435212E-42";
        results[58][22]="1.800575607560021E-26";
        results[58][23]="1.601333147361503E-47";
        results[58][24]="9.537429953960697E-32";
        results[58][25]="9.547602331172774E-32";
        results[58][26]="2.557299533609959E-7";
        results[58][27]="1.113039285562200E-36";
        results[58][28]="3.943930152271277E-12";
        results[58][29]="1.899976199866263E-41";
        results[58][30]="8.888521774566507E-18";
        results[58][31]="2.318230075295776E-46";
        results[58][32]="1.807083140011844E-22";
        results[58][33]="9.975022969440973E-52";
        results[58][34]="4.780741416946553E-27";
        results[58][35]="1.173564604311067E-35";
        results[58][36]="0.002472912671331814";
        results[58][37]="9.929281876384678E-41";
        results[58][38]="1.210259541417636E-8";
        results[58][39]="1.058261186752084E-45";
        results[58][40]="2.194307149738259E-13";
        results[58][41]="1.694258113296445E-50";
        results[58][42]="7.924461513753702E-19";
        results[58][43]="3.056383460588637E-55";
        results[58][44]="2.081693016068045E-23";
        results[58][45]="2.680910650403675E-39";
        results[58][46]="14.59645852517100";
        results[58][47]="9.745798919724109E-45";
        results[58][48]="0.0001208673992447659";
        results[58][49]="4.127410005162593E-49";
        results[58][50]="4.073405935195787E-9";
        results[58][51]="1.027347504625585E-54";
        results[58][52]="7.299066581290476E-14";
        results[58][53]="2.139970350361897E-59";
        results[58][54]="2.976641733579987E-19";
        results[58][55]="1.083830169527293E-43";
        results[58][56]="125111.4857249578";
        results[58][57]="1.087094456170119E-48";
        results[58][58]="1";
        results[58][59]="2.133046077079208E-53";
        results[58][60]="0.00005165155337615015";
        results[58][61]="9.860414391091898E-59";
        results[58][62]="3.692785818589105E-10";
        results[58][63]="8.386648159795576E-64";
        results[58][64]="3.858562028444187E-15";
        results[58][65]="9.099232085277269E-48";
        results[58][66]="811206390.0471738";
        results[58][67]="2.937243814892411E-52";
        results[58][68]="17305.91325894164";
        results[58][69]="1.304584677618646E-57";
        results[58][70]="0.1270649980996593";
        results[58][71]="7.972697192533506E-63";
        results[58][72]="0.000003097001201032130";
        results[58][73]="1.510739440573996E-67";
        results[58][74]="8.649564307367203E-12";
        results[59][0]="3.265231862221327E+34";
        results[59][1]="7.179856607930284E+28";
        results[59][2]="1.610927955912394E+24";
        results[59][3]="1.878517702221967E+19";
        results[59][4]="131114566512174.5";
        results[59][5]="4.090693128103987E+29";
        results[59][6]="2.542178477372429E+38";
        results[59][7]="3.922949196535957E+24";
        results[59][8]="3.747649962375796E+32";
        results[59][9]="3.656749239841227E+19";
        results[59][10]="1.334553693809554E+28";
        results[59][11]="443130342180164.7";
        results[59][12]="5.950034670157650E+22";
        results[59][13]="5575329010.496484";
        results[59][14]="4.482976481149991E+17";
        results[59][15]="4.815820794179703E+25";
        results[59][16]="5.532417761102616E+41";
        results[59][17]="5.699677666829715E+20";
        results[59][18]="4.341909773142817E+36";
        results[59][19]="3673706331174018";
        results[59][20]="1.469336417627336E+32";
        results[59][21]="68496399638.76680";
        results[59][22]="8.441334797725325E+26";
        results[59][23]="750725.9991093196";
        results[59][24]="4.471272353863239E+21";
        results[59][25]="4.476041297826234E+21";
        results[59][26]="1.198895589312202E+46";
        results[59][27]="5.218074271917703E+16";
        results[59][28]="1.848966224710778E+41";
        results[59][29]="890733782210.6083";
        results[59][30]="4.167055681580780E+35";
        results[59][31]="10868166.89150073";
        results[59][32]="8.471842964059609E+30";
        results[59][33]="46.76421703510423";
        results[59][34]="2.241274329850788E+26";
        results[59][35]="5.501824910965054E+17";
        results[59][36]="1.159333920586464E+50";
        results[59][37]="4654977678672.980";
        results[59][38]="5.673855592818941E+44";
        results[59][39]="49612673.54342235";
        results[59][40]="1.028719994995578E+40";
        results[59][41]="794.2904429033256";
        results[59][42]="3.715091576739267E+34";
        results[59][43]="0.01432872685419792";
        results[59][44]="9.759250109207765E+29";
        results[59][45]="125684610342532.4";
        results[59][46]="6.843011354521704E+53";
        results[59][47]="456895846.0132791";
        results[59][48]="5.666422331123308E+48";
        results[59][49]="19349.83988163200";
        results[59][50]="1.909666171287554E+44";
        results[59][51]="0.04816339954701486";
        results[59][52]="3.421898223260666E+39";
        results[59][53]="0.000001003246190205216";
        results[59][54]="1.395488717081967E+34";
        results[59][55]="5081138101.861297";
        results[59][56]="5.865390676242383E+57";
        results[59][57]="50964.41506123880";
        results[59][58]="4.688131263293223E+52";
        results[59][59]="1";
        results[59][60]="2.421492621803881E+48";
        results[59][61]="0.000004622691697590433";
        results[59][62]="1.731226464477344E+43";
        results[59][63]="3.931770743217822E-11";
        results[59][64]="1.808944527690531E+38";
        results[59][65]="426583.9441094915";
        results[59][66]="3.803042038163392E+61";
        results[59][67]="13.77018455651177";
        results[59][68]="8.113239298908500E+56";
        results[59][69]="0.00006116064212757286";
        results[59][70]="5.956973900613066E+51";
        results[59][71]="3.737705096108644E-10";
        results[59][72]="1.451914815301539E+47";
        results[59][73]="7.082544802045064E-15";
        results[59][74]="4.055029284323338E+41";
        results[60][0]="1.348437667255375E-14";
        results[60][1]="2.965054092372860E-20";
        results[60][2]="6.652623846164517E-25";
        results[60][3]="7.757685013397121E-30";
        results[60][4]="5.414617634246651E-35";
        results[60][5]="1.689327108110964E-19";
        results[60][6]="1.049839447984212E-10";
        results[60][7]="1.620054160484525E-24";
        results[60][8]="1.547661111428041E-16";
        results[60][9]="1.510121982992930E-29";
        results[60][10]="5.511285402205287E-21";
        results[60][11]="1.829988405457360E-34";
        results[60][12]="2.457176460742298E-26";
        results[60][13]="2.302434853732143E-39";
        results[60][14]="1.851327747515669E-31";
        results[60][15]="1.988781940038362E-23";
        results[60][16]="2.284713862551959E-7";
        results[60][17]="2.353786922788046E-28";
        results[60][18]="1.793071650950697E-12";
        results[60][19]="1.517124726334002E-33";
        results[60][20]="6.067895497169673E-17";
        results[60][21]="2.828685044174972E-38";
        results[60][22]="3.486004756618662E-22";
        results[60][23]="3.100261352644838E-43";
        results[60][24]="1.846494312475907E-27";
        results[60][25]="1.848463735764689E-27";
        results[60][26]="0.004951060261414672";
        results[60][27]="2.154899926158156E-32";
        results[60][28]="7.635646741444116E-8";
        results[60][29]="3.678449292763319E-37";
        results[60][30]="1.720862431732932E-13";
        results[60][31]="4.488209789961917E-42";
        results[60][32]="3.498603666092752E-18";
        results[60][33]="1.931214516782934E-47";
        results[60][34]="9.255755353824531E-23";
        results[60][35]="2.272079981340803E-31";
        results[60][36]="47.87683060222675";
        results[60][37]="1.922358811568574E-36";
        results[60][38]="0.0002343123221491472";
        results[60][39]="2.048846777260200E-41";
        results[60][40]="4.248288785737604E-9";
        results[60][41]="3.280168751088831E-46";
        results[60][42]="1.534215526112867E-14";
        results[60][43]="5.917311795698881E-51";
        results[60][44]="4.030262170254993E-19";
        results[60][45]="5.190377588220942E-35";
        results[60][46]="282594.7637793763";
        results[60][47]="1.886835590161396E-40";
        results[60][48]="2.340053519098534";
        results[60][49]="7.990872946462834E-45";
        results[60][50]="0.00007886318356258115";
        results[60][51]="1.988996336942614E-50";
        results[60][52]="1.413135928001109E-9";
        results[60][53]="4.143090014694539E-55";
        results[60][54]="5.762927809552455E-15";
        results[60][55]="2.098349611355051E-39";
        results[60][56]="2422221163.685803";
        results[60][57]="2.104669434147318E-44";
        results[60][58]="19360.50195272046";
        results[60][59]="4.129684274053472E-49";
        results[60][60]="1";
        results[60][61]="1.909025720733676E-54";
        results[60][62]="0.000007149418705177280";
        results[60][63]="1.623697180745017E-59";
        results[60][64]="7.470369768638670E-11";
        results[60][65]="1.761657005552672E-43";
        results[60][66]="15705362898567.62";
        results[60][67]="5.686651461384062E-48";
        results[60][68]="335051167.4433505";
        results[60][69]="2.525741419852499E-53";
        results[60][70]="2460.042143830875";
        results[60][71]="1.543554195644939E-58";
        results[60][72]="0.05995949780016016";
        results[60][73]="2.924867388928466E-63";
        results[60][74]="1.674599066629639E-7";
        results[61][0]="7.063486115509977E+39";
        results[61][1]="1.553176607402299E+34";
        results[61][2]="3.484826722820572E+29";
        results[61][3]="4.063688052571492E+24";
        results[61][4]="2.836325134564299E+19";
        results[61][5]="8.849158446444201E+34";
        results[61][6]="5.499346795499110E+43";
        results[61][7]="8.486287758668364E+29";
        results[61][8]="8.107073124364424E+37";
        results[61][9]="7.910432879932915E+24";
        results[61][10]="2.886962361139478E+33";
        results[61][11]="9.585980878005454E+19";
        results[61][12]="1.287136382739755E+28";
        results[61][13]="1206078487432465";
        results[61][14]="9.697762200941783E+22";
        results[61][15]="1.041778493835083E+31";
        results[61][16]="1.196795746509847E+47";
        results[61][17]="1.232978108793337E+26";
        results[61][18]="9.392600798807385E+41";
        results[61][19]="7.947115169045187E+20";
        results[61][20]="3.178529985880788E+37";
        results[61][21]="1.481742762003150E+16";
        results[61][22]="1.826064844887958E+32";
        results[61][23]="162400187644.0589";
        results[61][24]="9.672443343331502E+26";
        results[61][25]="9.682759722348257E+26";
        results[61][26]="2.593501076303929E+51";
        results[61][27]="1.128795648353017E+22";
        results[61][28]="3.999761060584132E+46";
        results[61][29]="1.926872567934611E+17";
        results[61][30]="9.014349115587456E+40";
        results[61][31]="2351047312362.565";
        results[61][32]="1.832664499013753E+36";
        results[61][33]="10116230.99578109";
        results[61][34]="4.848418359846594E+31";
        results[61][35]="1.190177773229581E+23";
        results[61][36]="2.507919620057646E+55";
        results[61][37]="1.006984238446915E+18";
        results[61][38]="1.227392169756080E+50";
        results[61][39]="10732421019831.98";
        results[61][40]="2.225370113978822E+45";
        results[61][41]="171824230.3109566";
        results[61][42]="8.036641462972210E+39";
        results[61][43]="3099.650115465570";
        results[61][44]="2.111161796555619E+35";
        results[61][45]="2.718862051908959E+19";
        results[61][46]="1.480308833506809E+59";
        results[61][47]="98837620136215.22";
        results[61][48]="1.225784175500373E+54";
        results[61][49]="4185838283.725054";
        results[61][50]="4.131069723475097E+49";
        results[61][51]="10418.90800810271";
        results[61][52]="7.402393339457015E+44";
        results[61][53]="0.2170264114148377";
        results[61][54]="3.018779551769291E+39";
        results[61][55]="1099173043382890";
        results[61][56]="1.268825839997009E+63";
        results[61][57]="11024835397.91414";
        results[61][58]="1.014156160519400E+58";
        results[61][59]="216324.1819741618";
        results[61][60]="5.238274105681931E+53";
        results[61][61]="1";
        results[61][62]="3.745061487400818E+48";
        results[61][63]="0.000008505370897365375";
        results[61][64]="3.913184451892906E+43";
        results[61][65]="92280422752.79732";
        results[61][66]="8.226899579190449E+66";
        results[61][67]="2978823.909820644";
        results[61][68]="1.755089854497003E+62";
        results[61][69]="13.23052587726166";
        results[61][70]="1.288637506091553E+57";
        results[61][71]="0.00008085559973763583";
        results[61][72]="3.140842847162717E+52";
        results[61][73]="1.532125710597750E-9";
        results[61][74]="8.772008928125169E+46";
        results[62][0]="1.886080145619249E-9";
        results[62][1]="4.147265973142270E-15";
        results[62][2]="9.305125522088941E-20";
        results[62][3]="1.085079127870824E-24";
        results[62][4]="7.573507522122931E-30";
        results[62][5]="2.362887358782933E-14";
        results[62][6]="0.00001468426303279687";
        results[62][7]="2.265994239939194E-19";
        results[62][8]="2.164736988067710E-11";
        results[62][9]="2.112230441755173E-24";
        results[62][10]="7.708718190213518E-16";
        results[62][11]="2.559632441351024E-29";
        results[62][12]="3.436889853664501E-21";
        results[62][13]="3.220450429158424E-34";
        results[62][14]="2.589480101613048E-26";
        results[62][15]="2.781739358191706E-18";
        results[62][16]="0.03195663810957770";
        results[62][17]="3.292277344287504E-23";
        results[62][18]="2.507996418858833E-7";
        results[62][19]="2.122025284706531E-28";
        results[62][20]="8.487257142703900E-12";
        results[62][21]="3.956524524331703E-33";
        results[62][22]="4.875927540926171E-17";
        results[62][23]="4.336382411621481E-38";
        results[62][24]="2.582719502969886E-22";
        results[62][25]="2.585474165089977E-22";
        results[62][26]="692.5122818487806";
        results[62][27]="3.014091096102228E-27";
        results[62][28]="0.01068009450322826";
        results[62][29]="5.145102622258724E-32";
        results[62][30]="2.406996292561188E-8";
        results[62][31]="6.277726868495983E-37";
        results[62][32]="4.893549826028827E-13";
        results[62][33]="2.701218933204230E-42";
        results[62][34]="1.294616490585723E-17";
        results[62][35]="3.177992610357912E-26";
        results[62][36]="6696604.657880305";
        results[62][37]="2.688832324474842E-31";
        results[62][38]="32.77361864111679";
        results[62][39]="2.865752953840177E-36";
        results[62][40]="0.0005942145733696068";
        results[62][41]="4.588021608964494E-41";
        results[62][42]="2.145930444669381E-9";
        results[62][43]="8.276633443518753E-46";
        results[62][44]="5.637188611343273E-14";
        results[62][45]="7.259859580559060E-30";
        results[62][46]="39526956726.52857";
        results[62][47]="2.639145457790906E-35";
        results[62][48]="327306.8224978871";
        results[62][49]="1.117695476511428E-39";
        results[62][50]="11.03071267954583";
        results[62][51]="2.782039238382100E-45";
        results[62][52]="0.0001976574580780646";
        results[62][53]="5.795002622652810E-50";
        results[62][54]="8.060694228719894E-10";
        results[62][55]="2.934993316079701E-34";
        results[62][56]="338799735135353.3";
        results[62][57]="2.943832947737714E-39";
        results[62][58]="2707982669.793906";
        results[62][59]="5.776251810602371E-44";
        results[62][60]="139871.5114105495";
        results[62][61]="2.670183128806329E-49";
        results[62][62]="1";
        results[62][63]="2.271089787438537E-54";
        results[62][64]="0.00001044891910335168";
        results[62][65]="2.464056279536351E-38";
        results[62][66]="2.196732845873822E+18";
        results[62][67]="7.954005347687989E-43";
        results[62][68]="46864113190170.53";
        results[62][69]="3.532792698269964E-48";
        results[62][70]="344089812.7912729";
        results[62][71]="2.158992582889526E-53";
        results[62][72]="8386.625580725921";
        results[62][73]="4.091056223648521E-58";
        results[62][74]="0.02342287024561831";
        results[63][0]="8.304736149364119E+44";
        results[63][1]="1.826112730584637E+39";
        results[63][2]="4.097207241015242E+34";
        results[63][3]="4.777790529781906E+29";
        results[63][4]="3.334745972621699E+24";
        results[63][5]="1.040420053778644E+40";
        results[63][6]="6.465734254108293E+48";
        results[63][7]="9.977563425596263E+34";
        results[63][8]="9.531710283058522E+42";
        results[63][9]="9.300514904509633E+29";
        results[63][10]="3.394281561588036E+38";
        results[63][11]="1.127050306645041E+25";
        results[63][12]="1.513321874227095E+33";
        results[63][13]="1.418019862962190E+20";
        results[63][14]="1.140192746202962E+28";
        results[63][15]="1.224847812524888E+36";
        results[63][16]="1.407105887505231E+52";
        results[63][17]="1.449646492400778E+31";
        results[63][18]="1.104314075441065E+47";
        results[63][19]="9.343643287216183E+25";
        results[63][20]="3.737085688838532E+42";
        results[63][21]="1.742125981198698E+21";
        results[63][22]="2.146954985177189E+37";
        results[63][23]="1.909383959897199E+16";
        results[63][24]="1.137215938028950E+32";
        results[63][25]="1.138428863266573E+32";
        results[63][26]="3.049251005746606E+56";
        results[63][27]="1.327156289801157E+27";
        results[63][28]="4.702629795748353E+51";
        results[63][29]="2.265477415607447E+22";
        results[63][30]="1.059841978011769E+46";
        results[63][31]="2.764191404152434E+17";
        results[63][32]="2.154714381216979E+41";
        results[63][33]="1189393280769.765";
        results[63][34]="5.700419674053768E+36";
        results[63][35]="1.399324953128441E+28";
        results[63][36]="2.948630518669679E+60";
        results[63][37]="1.183939243330163E+23";
        results[63][38]="1.443078949251087E+55";
        results[63][39]="1.261840447564310E+18";
        results[63][40]="2.616429243159934E+50";
        results[63][41]="20201850381878.22";
        results[63][42]="9.448901829150850E+44";
        results[63][43]="364434444.1728835";
        results[63][44]="2.482151362981211E+40";
        results[63][45]="3.196641374864857E+24";
        results[63][46]="1.740440071773177E+64";
        results[63][47]="1.162061259043167E+19";
        results[63][48]="1.441188385893991E+59";
        results[63][49]="492140593777240.2";
        results[63][50]="4.857013025445766E+54";
        results[63][51]="1224979854.944370";
        results[63][52]="8.703198753801531E+49";
        results[63][53]="25516.39593777902";
        results[63][54]="3.549262681424497E+44";
        results[63][55]="1.292328173158645E+20";
        results[63][56]="1.491793662272907E+68";
        results[63][57]="1296220415423529";
        results[63][58]="1.192371470635743E+63";
        results[63][59]="25433832878.60738";
        results[63][60]="6.158783865974074E+58";
        results[63][61]="117572.7680858409";
        results[63][62]="4.403172457253908E+53";
        results[63][63]="1";
        results[63][64]="4.600839280395232E+48";
        results[63][65]="1.084966474317800E+16";
        results[63][66]="9.672593562896609E+71";
        results[63][67]="350228572717.9005";
        results[63][68]="2.063507724325885E+67";
        results[63][69]="1555549.550621002";
        results[63][70]="1.515086786504186E+62";
        results[63][71]="9.506416676394638";
        results[63][72]="3.692775876635344E+57";
        results[63][73]="0.0001801362608504635";
        results[63][74]="1.031349371353387E+52";
        results[64][0]="0.0001805048088671923";
        results[64][1]="3.969086115148465E-10";
        results[64][2]="8.905347462307516E-15";
        results[64][3]="1.038460645678428E-19";
        results[64][4]="7.248125329722949E-25";
        results[64][5]="2.261370133514570E-9";
        results[64][6]="1.405337995973826";
        results[64][7]="2.168639854061398E-14";
        results[64][8]="0.000002071732938743234";
        results[64][9]="2.021482242194446E-19";
        results[64][10]="7.377526913516641E-11";
        results[64][11]="2.449662415828232E-24";
        results[64][12]="3.289230033910451E-16";
        results[64][13]="3.082089541802851E-29";
        results[64][14]="2.478227724801148E-21";
        results[64][15]="2.662226906608371E-13";
        results[64][16]="3058.367836279547";
        results[64][17]="3.150830542109802E-18";
        results[64][18]="0.02400244842602282";
        results[64][19]="2.030856267253379E-23";
        results[64][20]="8.122617333673738E-7";
        results[64][21]="3.786539531215795E-28";
        results[64][22]="4.666442043141217E-12";
        results[64][23]="4.150077504409531E-33";
        results[64][24]="2.471757583175691E-17";
        results[64][25]="2.474393896169260E-17";
        results[64][26]="66275973.14124528";
        results[64][27]="2.884596068061627E-22";
        results[64][28]="1022.124336267703";
        results[64][29]="4.924052498988474E-27";
        results[64][30]="0.002303584005917990";
        results[64][31]="6.008015572139217E-32";
        results[64][32]="4.683307218312307E-8";
        results[64][33]="2.585165897530746E-37";
        results[64][34]="1.238995610723459E-12";
        results[64][35]="3.041455847178024E-21";
        results[64][36]="640889702718.8438";
        results[64][37]="2.573311457270591E-26";
        results[64][38]="3136555.878837656";
        results[64][39]="2.742631008523106E-31";
        results[64][40]="56.86852080029998";
        results[64][41]="4.390905474129667E-36";
        results[64][42]="0.0002053734384814057";
        results[64][43]="7.921042704660115E-41";
        results[64][44]="5.394996894497005E-9";
        results[64][45]="6.947952710467755E-25";
        results[64][46]="3782875179294822";
        results[64][47]="2.525759297863022E-30";
        results[64][48]="31324467082.23605";
        results[64][49]="1.069675691290314E-34";
        results[64][50]="1055679.785673480";
        results[64][51]="2.662513902983238E-40";
        results[64][52]="18.91654592432077";
        results[64][53]="5.546030709333330E-45";
        results[64][54]="0.00007714380931645150";
        results[64][55]="2.808896582554887E-29";
        results[64][56]="3.242438110432659E+19";
        results[64][57]="2.817356435263650E-34";
        results[64][58]="259163904228646.2";
        results[64][59]="5.528085492354452E-39";
        results[64][60]="13386218232.43738";
        results[64][61]="2.555463490907705E-44";
        results[64][62]="95703.67902257296";
        results[64][63]="2.173516480484612E-49";
        results[64][64]="1";
        results[64][65]="2.358192512703023E-33";
        results[64][66]="2.102354151798515E+23";
        results[64][67]="7.612275747389602E-38";
        results[64][68]="4.485068046429608E+18";
        results[64][69]="3.381012584485181E-43";
        results[64][70]="32930660998313.20";
        results[64][71]="2.066235331649750E-48";
        results[64][72]="802630922.6602931";
        results[64][73]="3.915291316913575E-53";
        results[64][74]="2241.654855774030";
        results[65][0]="7.654371214175933E+28";
        results[65][1]="1.683105214594628E+23";
        results[65][2]="3.776344558103940E+18";
        results[65][3]="44036296446727.19";
        results[65][4]="307359356.4002524";
        results[65][5]="9.589421225506852E+23";
        results[65][6]="5.959386218061519E+32";
        results[65][7]="9.196195146831527E+18";
        results[65][8]="8.785257893845823E+26";
        results[65][9]="85721680113273.25";
        results[65][10]="3.128466770111285E+22";
        results[65][11]="1038788140.761402";
        results[65][12]="1.394809802928366E+17";
        results[65][13]="13069.71133696832";
        results[65][14]="1050901362569.648";
        results[65][15]="1.128926876100059E+20";
        results[65][16]="1.296911859318036E+36";
        results[65][17]="1336121001630285";
        results[65][18]="1.017832441445189E+31";
        results[65][19]="8611918901.080548";
        results[65][20]="3.444425037361932E+26";
        results[65][21]="160569.5680407179";
        results[65][22]="1.978821499094838E+21";
        results[65][23]="1.759855262899042";
        results[65][24]="1.048157675788096E+16";
        results[65][25]="1.049275613776351E+16";
        results[65][26]="2.810456431535270E+40";
        results[65][27]="122322331723.2581";
        results[65][28]="4.334354938206963E+35";
        results[65][29]="2088062.137617592";
        results[65][30]="9.768430666746378E+29";
        results[65][31]="25.47720569790407";
        results[65][32]="1.985973237165517E+25";
        results[65][33]="0.0001096248878581826";
        results[65][34]="5.254005362366659E+20";
        results[65][35]="1289740269632.112";
        results[65][36]="2.717715789811575E+44";
        results[65][37]="10912219.60636705";
        results[65][38]="1.330067779429277E+39";
        results[65][39]="116.3022524136263";
        results[65][40]="2.411530038110238E+34";
        results[65][41]="0.001861979227937033";
        results[65][42]="8.708934379831493E+28";
        results[65][43]="3.358946592354670E-8";
        results[65][44]="2.287767799039069E+24";
        results[65][45]="294630428.7305122";
        results[65][46]="1.604141798821501E+48";
        results[65][47]="1071.057296746282";
        results[65][48]="1.328325270880074E+43";
        results[65][49]="0.04535998166087906";
        results[65][50]="4.476648025921479E+38";
        results[65][51]="1.129048577943026E-7";
        results[65][52]="8.021629202205431E+33";
        results[65][53]="2.351814230372703E-12";
        results[65][54]="3.271310925672783E+28";
        results[65][55]="11911.22678671919";
        results[65][56]="1.374967519812914E+52";
        results[65][57]="0.1194710109580630";
        results[65][58]="1.098993838851543E+47";
        results[65][59]="0.000002344204496696504";
        results[65][60]="5.676473892750065E+42";
        results[65][61]="1.083653466433309E-11";
        results[65][62]="4.058348862827780E+37";
        results[65][63]="9.216874656230971E-17";
        results[65][64]="4.240535896086675E+32";
        results[65][65]="1";
        results[65][66]="8.915108246988459E+55";
        results[65][67]="0.00003228012855771563";
        results[65][68]="1.901909204727609E+51";
        results[65][69]="1.433730522963019E-10";
        results[65][70]="1.396436500452086E+46";
        results[65][71]="8.761945093623320E-16";
        results[65][72]="3.403585238850141E+41";
        results[65][73]="1.660293337300849E-20";
        results[65][74]="9.505817882546773E+35";
        results[66][0]="8.585842148087876E-28";
        results[66][1]="1.887924597172652E-33";
        results[66][2]="4.235893108061360E-38";
        results[66][3]="4.939513377372926E-43";
        results[66][4]="3.447623381399535E-48";
        results[66][5]="1.075637104994903E-32";
        results[66][6]="6.684592102484691E-24";
        results[66][7]="1.031529275030174E-37";
        results[66][8]="9.854347979244672E-30";
        results[66][9]="9.615326896589304E-43";
        results[66][10]="3.509174183238983E-34";
        results[66][11]="1.165199694700630E-47";
        results[66][12]="1.564546121354764E-39";
        results[66][13]="1.466018243960560E-52";
        results[66][14]="1.178786991088576E-44";
        results[66][15]="1.266307536401941E-36";
        results[66][16]="1.454734842682516E-20";
        results[66][17]="1.498715399312880E-41";
        results[66][18]="1.141693867585976E-25";
        results[66][19]="9.659915126649943E-47";
        results[66][20]="3.863581845487368E-30";
        results[66][21]="1.801094990573543E-51";
        results[66][22]="2.219627002020180E-35";
        results[66][23]="1.974014464146888E-56";
        results[66][24]="1.175709421298576E-40";
        results[66][25]="1.176963402694295E-40";
        results[66][26]="3.152464730290456E-16";
        results[66][27]="1.372079040819037E-45";
        results[66][28]="4.861808536840948E-21";
        results[66][29]="2.342161283709532E-50";
        results[66][30]="1.095716439567200E-26";
        results[66][31]="2.857756181088471E-55";
        results[66][32]="2.227649044907988E-31";
        results[66][33]="1.229652908535508E-60";
        results[66][34]="5.893372482764269E-36";
        results[66][35]="1.446690532409171E-44";
        results[66][36]="3.048438352646615E-12";
        results[66][37]="1.224014258049331E-49";
        results[66][38]="1.491925552197951E-17";
        results[66][39]="1.304552330622721E-54";
        results[66][40]="2.704992436771430E-22";
        results[66][41]="2.088566034591912E-59";
        results[66][42]="9.768736552103434E-28";
        results[66][43]="3.767701411241225E-64";
        results[66][44]="2.566169401041071E-32";
        results[66][45]="3.304844097995546E-48";
        results[66][46]="1.799352015005968E-8";
        results[66][47]="1.201395728546636E-53";
        results[66][48]="1.489970995392888E-13";
        results[66][49]="5.087990005752511E-58";
        results[66][50]="5.021417465608115E-18";
        results[66][51]="1.266444048309139E-63";
        results[66][52]="8.997792264513616E-23";
        results[66][53]="2.638009730467547E-68";
        results[66][54]="3.669401240055428E-28";
        results[66][55]="1.336072031513787E-52";
        results[66][56]="0.0001542289203585813";
        results[66][57]="1.340096021811295E-57";
        results[66][58]="1.232731906786197E-9";
        results[66][59]="2.629473957860669E-62";
        results[66][60]="6.367251788185060E-14";
        results[66][61]="1.215524743403277E-67";
        results[66][62]="4.552214903502375E-19";
        results[66][63]="1.033848877756975E-72";
        results[66][64]="4.756572526776819E-24";
        results[66][65]="1.121691371877399E-56";
        results[66][66]="1";
        results[66][67]="3.620834168628286E-61";
        results[66][68]="0.00002133355145037165";
        results[66][69]="1.608203157204890E-66";
        results[66][70]="1.566370773931775E-10";
        results[66][71]="9.828198212380789E-72";
        results[66][72]="3.817772195867480E-15";
        results[66][73]="1.862336711235894E-76";
        results[66][74]="1.066259390149060E-20";
        results[67][0]="2.371233187776874E+33";
        results[67][1]="5.214059825026099E+27";
        results[67][2]="1.169866641439169E+23";
        results[67][3]="1.364192102518798E+18";
        results[67][4]="9521627395340.313";
        results[67][5]="2.970688672556348E+28";
        results[67][6]="1.846146990216091E+37";
        results[67][7]="2.848871909041218E+23";
        results[67][8]="2.721568434319621E+31";
        results[67][9]="2.655555722462696E+18";
        results[67][10]="9.691618063161386E+26";
        results[67][11]="32180421428746.45";
        results[67][12]="4.320954919477782E+21";
        results[67][13]="404884116.6663938";
        results[67][14]="3.255567463712780E+16";
        results[67][15]="3.497281226998773E+24";
        results[67][16]="4.017678730737416E+40";
        results[67][17]="4.139143991453913E+19";
        results[67][18]="3.153123878132466E+35";
        results[67][19]="266787007544990.6";
        results[67][20]="1.067041920605562E+31";
        results[67][21]="4974254292.501521";
        results[67][22]="6.130153712234388E+25";
        results[67][23]="54518.22348701272";
        results[67][24]="3.247067848301876E+20";
        results[67][25]="3.250531087260965E+20";
        results[67][26]="8.706459847302905E+44";
        results[67][27]="3789400389299890";
        results[67][28]="1.342731622167273E+40";
        results[67][29]="64685682211.09210";
        results[67][30]="3.026143668938864E+34";
        results[67][31]="789253.5388250330";
        results[67][32]="6.152308946399247E+29";
        results[67][33]="3.396048676267737";
        results[67][34]="1.627628388459699E+25";
        results[67][35]="3.995461998628989E+16";
        results[67][36]="8.419160366577858E+48";
        results[67][37]="338047588219.9918";
        results[67][38]="4.120391828834159E+43";
        results[67][39]="3602905.490468613";
        results[67][40]="7.470633314853486E+38";
        results[67][41]="57.68190249329044";
        results[67][42]="2.697924317203462E+33";
        results[67][43]="0.001040561714724588";
        results[67][44]="7.087232614171990E+28";
        results[67][45]="9127300351475.501";
        results[67][46]="4.969440552113530E+52";
        results[67][47]="33180081.51148695";
        results[67][48]="4.114993744541877E+47";
        results[67][49]="1405.198296524041";
        results[67][50]="1.386812328803897E+43";
        results[67][51]="0.003497658244837316";
        results[67][52]="2.485005345583759E+38";
        results[67][53]="7.285640842996488E-8";
        results[67][54]="1.013413227219280E+33";
        results[67][55]="368995642.7968486";
        results[67][56]="4.259485885734702E+56";
        results[67][57]="3701.069862359855";
        results[67][58]="3.404552236793557E+51";
        results[67][59]="0.07262066792903739";
        results[67][60]="1.758504115806338E+47";
        results[67][61]="3.357029587090330E-7";
        results[67][62]="1.257228221867707E+42";
        results[67][63]="2.855278175163260E-12";
        results[67][64]="1.313667598474634E+37";
        results[67][65]="30978.81094903443";
        results[67][66]="2.761794529736332E+60";
        results[67][67]="1";
        results[67][68]="5.891888569548503E+55";
        results[67][69]="0.000004441526682273164";
        results[67][70]="4.325994234983640E+50";
        results[67][71]="2.714346406011766E-11";
        results[67][72]="1.054390236632627E+46";
        results[67][73]="5.143391341618445E-16";
        results[67][74]="2.944789350993672E+40";
        results[68][0]="4.024572358737908E-23";
        results[68][1]="8.849556069295544E-29";
        results[68][2]="1.985554593624666E-33";
        results[68][3]="2.315373222720905E-38";
        results[68][4]="1.616056937083241E-43";
        results[68][5]="5.041997379091630E-28";
        results[68][6]="3.133370511719575E-19";
        results[68][7]="4.835244040026928E-33";
        results[68][8]="4.619178387700187E-25";
        results[68][9]="4.507138400728770E-38";
        results[68][10]="1.644908580459467E-29";
        results[68][11]="5.461817725994849E-43";
        results[68][12]="7.333734962012186E-35";
        results[68][13]="6.871890258736175E-48";
        results[68][14]="5.525507526633783E-40";
        results[68][15]="5.935755888314043E-32";
        results[68][16]="6.818999856009313E-16";
        results[68][17]="7.025156607418828E-37";
        results[68][18]="5.351635287926178E-21";
        results[68][19]="4.528038919877851E-42";
        results[68][20]="1.811035473617807E-25";
        results[68][21]="8.442546449724692E-47";
        results[68][22]="1.040439519497590E-30";
        results[68][23]="9.253098194827277E-52";
        results[68][24]="5.511081565737588E-36";
        results[68][25]="5.516959543432190E-36";
        results[68][26]="1.477702733941909E-11";
        results[68][27]="6.431554746104564E-41";
        results[68][28]="2.278949451126784E-16";
        results[68][29]="1.097876876786368E-45";
        results[68][30]="5.136118297584773E-22";
        results[68][31]="1.339559513912385E-50";
        results[68][32]="1.044199813655115E-26";
        results[68][33]="5.763939076885797E-56";
        results[68][34]="2.762490106944477E-31";
        results[68][35]="6.781292537131541E-40";
        results[68][36]="1.428940867974192E-7";
        results[68][37]="5.737508172967645E-45";
        results[68][38]="6.993329524475215E-13";
        results[68][39]="6.115026528318585E-50";
        results[68][40]="1.267952240893443E-17";
        results[68][41]="9.790053191333628E-55";
        results[68][42]="4.579048441525779E-23";
        results[68][43]="1.766091979577825E-59";
        results[68][44]="1.202879608212802E-27";
        results[68][45]="1.549129832266147E-43";
        results[68][46]="0.0008434376335284867";
        results[68][47]="5.631484899930744E-49";
        results[68][48]="6.984167633124823E-9";
        results[68][49]="2.384970930690432E-53";
        results[68][50]="2.353765371550753E-13";
        results[68][51]="5.936395781336616E-59";
        results[68][52]="4.217672001516121E-18";
        results[68][53]="1.236554418332251E-63";
        results[68][54]="1.720014245444119E-23";
        results[68][55]="6.262773615644344E-48";
        results[68][56]="7.229406726646745";
        results[68][57]="6.281635877311693E-53";
        results[68][58]="0.00005778371733623009";
        results[68][59]="1.232553315830994E-57";
        results[68][60]="2.984618760264661E-9";
        results[68][61]="5.697713979929495E-63";
        results[68][62]="2.133828919245919E-14";
        results[68][63]="4.846117066640417E-68";
        results[68][64]="2.229620575759295E-19";
        results[68][65]="5.257874547924172E-52";
        results[68][66]="46874.52074382950";
        results[68][67]="1.697248663473332E-56";
        results[68][68]="1";
        results[68][69]="7.538375225269271E-62";
        results[68][70]="0.000007342287933519324";
        results[68][71]="4.606920809807113E-67";
        results[68][72]="1.789562419904057E-10";
        results[68][73]="8.729614080282214E-72";
        results[68][74]="4.998039790184512E-16";
        results[69][0]="5.338779562533849E+38";
        results[69][1]="1.173934144274364E+33";
        results[69][2]="2.633929108448886E+28";
        results[69][3]="3.071448625904928E+23";
        results[69][4]="2.143773543755267E+18";
        results[69][5]="6.688440450921611E+33";
        results[69][6]="4.156559494698874E+42";
        results[69][7]="6.414172677182188E+28";
        results[69][8]="6.127551693389194E+36";
        results[69][9]="5.978925519149620E+23";
        results[69][10]="2.182046570122424E+32";
        results[69][11]="7.245351369200056E+18";
        results[69][12]="9.728535318099962E+26";
        results[69][13]="91158771663435.09";
        results[69][14]="7.329838806791966E+21";
        results[69][15]="7.874052048267494E+29";
        results[69][16]="9.045715624703119E+45";
        results[69][17]="9.319191997593739E+24";
        results[69][18]="7.099189318657215E+40";
        results[69][19]="6.006651015061551E+19";
        results[69][20]="2.402421502642987E+36";
        results[69][21]="1119942454101324";
        results[69][22]="1.380190675584772E+31";
        results[69][23]="12274658554.81710";
        results[69][24]="7.310702108942491E+25";
        results[69][25]="7.318499515570511E+25";
        results[69][26]="1.960240356553922E+50";
        results[69][27]="8.531751941115174E+20";
        results[69][28]="3.023130824647137E+45";
        results[69][29]="1.456383960705739E+16";
        results[69][30]="6.813296160116931E+39";
        results[69][31]="177698704811.3589";
        results[69][32]="1.385178878009241E+35";
        results[69][33]="764612.9178559042";
        results[69][34]="3.664569651142300E+30";
        results[69][35]="8.995695139186061E+21";
        results[69][36]="1.895555508014859E+54";
        results[69][37]="7.611067373954845E+16";
        results[69][38]="9.276971914362904E+48";
        results[69][39]="811186276297.3776";
        results[69][40]="1.681996720782961E+44";
        results[69][41]="12986953.95065576";
        results[69][42]="6.074317481804861E+38";
        results[69][43]="234.2801899350586";
        results[69][44]="1.595674893152901E+34";
        results[69][45]="2.054991673899878E+18";
        results[69][46]="1.118858651001097E+58";
        results[69][47]="7470422646319.768";
        results[69][48]="9.264818245864578E+52";
        results[69][49]="316377317.3157802";
        results[69][50]="3.122377569719179E+48";
        results[69][51]="787.4900895669555";
        results[69][52]="5.594935082798914E+43";
        results[69][53]="0.01640346071109881";
        results[69][54]="2.281677674624746E+38";
        results[69][55]="83078560412474.54";
        results[69][56]="9.590139135570173E+61";
        results[69][57]="833287769.5256027";
        results[69][58]="7.665274758748302E+56";
        results[69][59]="16350.38425388234";
        results[69][60]="3.959233483443444E+52";
        results[69][61]="0.07558278554283523";
        results[69][62]="2.830621792469476E+47";
        results[69][63]="6.428596244978392E-7";
        results[69][64]="2.957693812169788E+42";
        results[69][65]="6974811402.726853";
        results[69][66]="6.218119865763931E+65";
        results[69][67]="225147.8087458437";
        results[69][68]="1.326545800808529E+61";
        results[69][69]="1";
        results[69][70]="9.739881226537191E+55";
        results[69][71]="0.000006111291454907054";
        results[69][72]="2.373936513408476E+51";
        results[69][73]="1.158023290087738E-10";
        results[69][74]="6.630128695943206E+45";
        results[70][0]="5.481360027253576E-18";
        results[70][1]="1.205285893092693E-23";
        results[70][2]="2.704272308036475E-28";
        results[70][3]="3.153476469031765E-33";
        results[70][4]="2.201026371773776E-38";
        results[70][5]="6.867065722216763E-23";
        results[70][6]="4.267566922042078E-14";
        results[70][7]="6.585473198283149E-28";
        results[70][8]="6.291197552485674E-20";
        results[70][9]="6.138602083626537E-33";
        results[70][10]="2.240321539216762E-24";
        results[70][11]="7.438849818270307E-38";
        results[70][12]="9.988351081318820E-30";
        results[70][13]="9.359330934659115E-43";
        results[70][14]="7.525593625126715E-35";
        results[70][15]="8.084340933043336E-27";
        results[70][16]="9.287295619229160E-11";
        results[70][17]="9.568075606715566E-32";
        results[70][18]="7.288784281388184E-16";
        results[70][19]="6.167068032304013E-37";
        results[70][20]="2.466581929251223E-20";
        results[70][21]="1.149852270323317E-41";
        results[70][22]="1.417050827913914E-25";
        results[70][23]="1.260247252438118E-46";
        results[70][24]="7.505945851807534E-31";
        results[70][25]="7.513951500384414E-31";
        results[70][26]="0.000002012591643533670";
        results[70][27]="8.759605730991504E-36";
        results[70][28]="3.103868265262150E-11";
        results[70][29]="1.495278973975256E-40";
        results[70][30]="6.995255898556019E-17";
        results[70][31]="1.824444268654967E-45";
        results[70][32]="1.422172248091892E-21";
        results[70][33]="7.850331026344006E-51";
        results[70][34]="3.762437719628292E-26";
        results[70][35]="9.235939258352015E-35";
        results[70][36]="0.01946179284866684";
        results[70][37]="7.814332841367511E-40";
        results[70][38]="9.524727970077244E-8";
        results[70][39]="8.328502755118070E-45";
        results[70][40]="1.726917075949764E-12";
        results[70][41]="1.333379088368309E-49";
        results[70][42]="6.236541637956356E-18";
        results[70][43]="2.405370091133565E-54";
        results[70][44]="1.638289888797966E-22";
        results[70][45]="2.109873443118451E-38";
        results[70][46]="114.8739522564880";
        results[70][47]="7.669931976137371E-44";
        results[70][48]="0.0009512249718838192";
        results[70][49]="3.248266687829637E-48";
        results[70][50]="3.205765550006891E-8";
        results[70][51]="8.085212450243923E-54";
        results[70][52]="5.744356581633671E-13";
        results[70][53]="1.684154080483660E-58";
        results[70][54]="2.342613448311986E-18";
        results[70][55]="8.529730340665701E-43";
        results[70][56]="984625.8812110530";
        results[70][57]="8.555420237109612E-48";
        results[70][58]="7.869987919219759";
        results[70][59]="1.678704685775246E-52";
        results[70][60]="0.0004064971010792362";
        results[70][61]="7.760134213639389E-58";
        results[70][62]="2.906217978056231E-9";
        results[70][63]="6.600281970033780E-63";
        results[70][64]="3.036683654941584E-14";
        results[70][65]="7.161084658530892E-47";
        results[70][66]="6384184489.665129";
        results[70][67]="2.311607333900624E-51";
        results[70][68]="136197.3282789357";
        results[70][69]="1.026706565245795E-56";
        results[70][70]="1";
        results[70][71]="6.274503058883598E-62";
        results[70][72]="0.00002437336203793195";
        results[70][73]="1.188950114640616E-66";
        results[70][74]="6.807196660549431E-11";
        results[71][0]="8.735926934473208E+43";
        results[71][1]="1.920926457094031E+38";
        results[71][2]="4.309938624075892E+33";
        results[71][3]="5.025858525269176E+28";
        results[71][4]="3.507889550962140E+23";
        results[71][5]="1.094439775990578E+39";
        results[71][6]="6.801442093489699E+47";
        results[71][7]="1.049560919244317E+34";
        results[71][8]="1.002660687778045E+42";
        results[71][9]="9.783407587849290E+28";
        results[71][10]="3.570516291397545E+37";
        results[71][11]="1.185567964261042E+24";
        results[71][12]="1.591895164857249E+32";
        results[71][13]="1.491644971215360E+19";
        results[71][14]="1.199392773340319E+27";
        results[71][15]="1.288443221267910E+35";
        results[71][16]="1.480164330477132E+51";
        results[71][17]="1.524913689087910E+30";
        results[71][18]="1.161651243610208E+46";
        results[71][19]="9.828775242323811E+24";
        results[71][20]="3.931119175659616E+41";
        results[71][21]="1.832579025832696E+20";
        results[71][22]="2.258427184775404E+36";
        results[71][23]="2008521217714331";
        results[71][24]="1.196261406101385E+31";
        results[71][25]="1.197537307714907E+31";
        results[71][26]="3.207571379990312E+55";
        results[71][27]="1.396063664131845E+26";
        results[71][28]="4.946795365519211E+50";
        results[71][29]="2.383103426586433E+21";
        results[71][30]="1.114870107307058E+45";
        results[71][31]="2.907711178930534E+16";
        results[71][32]="2.266589456958420E+40";
        results[71][33]="125114785229.5539";
        results[71][34]="5.996391561721113E+35";
        results[71][35]="1.471979401663617E+27";
        results[71][36]="3.101726569582645E+59";
        results[71][37]="1.245410635397457E+22";
        results[71][38]="1.518005152072067E+54";
        results[71][39]="1.327356553492530E+17";
        results[71][40]="2.752277048466415E+49";
        results[71][41]="2125075206522.494";
        results[71][42]="9.939498920359126E+43";
        results[71][43]="38335627.03787325";
        results[71][44]="2.611027317101128E+39";
        results[71][45]="3.362614414748335E+23";
        results[71][46]="1.830805582186251E+63";
        results[71][47]="1.222396722761668E+18";
        results[71][48]="1.516016428642984E+58";
        results[71][49]="51769305988793.17";
        results[71][50]="5.109194337658483E+53";
        results[71][51]="128858211.9471067";
        results[71][52]="9.155078143600022E+48";
        results[71][53]="2684.123451177847";
        results[71][54]="3.733544196771496E+43";
        results[71][55]="1.359427234414859E+19";
        results[71][56]="1.569249185107967E+67";
        results[71][57]="136352156606197.4";
        results[71][58]="1.254280672965365E+62";
        results[71][59]="2675438469.025040";
        results[71][60]="6.478554512834406E+57";
        results[71][61]="12367.72719817611";
        results[71][62]="4.631789881656898E+52";
        results[71][63]="0.1051921069779213";
        results[71][64]="4.839719777715578E+47";
        results[71][65]="1141299094338961";
        results[71][66]="1.017480496822173E+71";
        results[71][67]="36841281488.06609";
        results[71][68]="2.170647252870554E+66";
        results[71][69]="163631.5347383819";
        results[71][70]="1.593751713267834E+61";
        results[71][71]="1";
        results[71][72]="3.884508750605123E+56";
        results[71][73]="0.00001894891282198470";
        results[71][74]="1.084898134030173E+51";
        results[72][0]="2.248914211639332E-13";
        results[72][1]="4.945094941013564E-19";
        results[72][2]="1.109519607441867E-23";
        results[72][3]="1.293820878762663E-28";
        results[72][4]="9.030458614401850E-34";
        results[72][5]="2.817447060249479E-18";
        results[72][6]="1.750914344685201E-9";
        results[72][7]="2.701914158594232E-23";
        results[72][8]="2.581177575212958E-15";
        results[72][9]="2.518570098812429E-28";
        results[72][10]="9.191680391610227E-20";
        results[72][11]="3.052040915280100E-33";
        results[72][12]="4.098060442286985E-25";
        results[72][13]="3.839983552574039E-38";
        results[72][14]="3.087630509658344E-30";
        results[72][15]="3.316875579356586E-22";
        results[72][16]="0.000003810428616608354";
        results[72][17]="3.925628147575576E-27";
        results[72][18]="2.990471429442005E-11";
        results[72][19]="2.530249221550267E-32";
        results[72][20]="1.011999052659421E-15";
        results[72][21]="4.717659666868350E-37";
        results[72][22]="5.813932545327873E-21";
        results[72][23]="5.170592593983595E-42";
        results[72][24]="3.079569343009031E-26";
        results[72][25]="3.082853932375250E-26";
        results[72][26]="0.08257341110354408";
        results[72][27]="3.593925908686312E-31";
        results[72][28]="0.000001273467427444617";
        results[72][29]="6.134890097017279E-36";
        results[72][30]="2.870041436084768E-12";
        results[72][31]="7.485402571116811E-41";
        results[72][32]="5.834944911902525E-17";
        results[72][33]="3.220865063312414E-46";
        results[72][34]="1.543667924750332E-21";
        results[72][35]="3.789357924433339E-30";
        results[72][36]="798.4861841537783";
        results[72][37]="3.206095584682231E-35";
        results[72][38]="0.003907843306661606";
        results[72][39]="3.417051263652724E-40";
        results[72][40]="7.085264122619546E-8";
        results[72][41]="5.470640801598023E-45";
        results[72][42]="2.558753129030992E-13";
        results[72][43]="9.868848160504565E-50";
        results[72][44]="6.721640971189435E-18";
        results[72][45]="8.656472750188841E-34";
        results[72][46]="4713094.241069868";
        results[72][47]="3.146850222878877E-39";
        results[72][48]="39.02723680071055";
        results[72][49]="1.332711787062614E-43";
        results[72][50]="0.001315274251052358";
        results[72][51]="3.317233148902893E-49";
        results[72][52]="2.356817484881160E-8";
        results[72][53]="6.909814402554038E-54";
        results[72][54]="9.611367708181607E-14";
        results[72][55]="3.499611718478145E-38";
        results[72][56]="40397622604.49307";
        results[72][57]="3.510151871454961E-43";
        results[72][58]="322892.9971569699";
        results[72][59]="6.887456409020225E-48";
        results[72][60]="16.67792487743833";
        results[72][61]="3.183858755949381E-53";
        results[72][62]="0.0001192374680822991";
        results[72][63]="2.707989960417380E-58";
        results[72][64]="1.245902658080421E-9";
        results[72][65]="2.938078319842043E-42";
        results[72][66]="261932862595217.9";
        results[72][67]="9.484154587713828E-47";
        results[72][68]="5587958200.718210";
        results[72][69]="4.212412566013441E-52";
        results[72][70]="41028.39807014366";
        results[72][71]="2.574328091922103E-57";
        results[72][72]="1";
        results[72][73]="4.878071858901815E-62";
        results[72][74]="0.000002792883743307747";
        results[73][0]="4.610252322411714E+48";
        results[73][1]="1.013739666829516E+43";
        results[73][2]="2.274504434405050E+38";
        results[73][3]="2.652320253137757E+33";
        results[73][4]="1.851235257619769E+28";
        results[73][5]="5.775739148057081E+43";
        results[73][6]="3.589357425085942E+52";
        results[73][7]="5.538897820177879E+38";
        results[73][8]="5.291388995229049E+46";
        results[73][9]="5.163044275816442E+33";
        results[73][10]="1.884285565584005E+42";
        results[73][11]="6.256654275624378E+28";
        results[73][12]="8.400984161003253E+36";
        results[73][13]="7.871929040091104E+23";
        results[73][14]="6.329612598928488E+31";
        results[73][15]="6.799562768440446E+39";
        results[73][16]="7.811341708004652E+55";
        results[73][17]="8.047499629206652E+34";
        results[73][18]="6.130437426797644E+50";
        results[73][19]="5.186986364157197E+29";
        results[73][20]="2.074588242919507E+46";
        results[73][21]="9.671156562114322E+24";
        results[73][22]="1.191850533058106E+41";
        results[73][23]="1.059966466985920E+20";
        results[73][24]="6.313087285479891E+35";
        results[73][25]="6.319820661824533E+35";
        results[73][26]="1.692746919110240E+60";
        results[73][27]="7.367513256550102E+30";
        results[73][28]="2.610595875336918E+55";
        results[73][29]="1.257646519868694E+26";
        results[73][30]="5.883557108424581E+49";
        results[73][31]="1.534500267243291E+21";
        results[73][32]="1.196158047826734E+45";
        results[73][33]="6602742141723014";
        results[73][34]="3.164504274231525E+40";
        results[73][35]="7.768146993403301E+31";
        results[73][36]="1.636888933271145E+64";
        results[73][37]="6.572464853775255E+26";
        results[73][38]="8.011040877822095E+58";
        results[73][39]="7.004921949677867E+21";
        results[73][40]="1.452472273381932E+54";
        results[73][41]="1.121476058540394E+17";
        results[73][42]="5.245419098043044E+48";
        results[73][43]="2023104301445.511";
        results[73][44]="1.377929880004403E+44";
        results[73][45]="1.774568518172187E+28";
        results[73][46]="9.661797483505934E+67";
        results[73][47]="6.451012436678859E+22";
        results[73][48]="8.000545692964971E+62";
        results[73][49]="2.732046237963053E+18";
        results[73][50]="2.696299458262718E+58";
        results[73][51]="6800295782542.430";
        results[73][52]="4.831452986040559E+53";
        results[73][53]="141650525.0931179";
        results[73][54]="1.970321058440780E+48";
        results[73][55]="7.174170081344397E+23";
        results[73][56]="8.281473453650119E+71";
        results[73][57]="7.195777292721534E+18";
        results[73][58]="6.619275125431665E+66";
        results[73][59]="141192188394099.9";
        results[73][60]="3.418958424526566E+62";
        results[73][61]="652687957.0540302";
        results[73][62]="2.444356531253368E+57";
        results[73][63]="5551.353154988210";
        results[73][64]="2.554088365481576E+52";
        results[73][65]="6.023032060260553E+19";
        results[73][66]="5.369598279230475E+75";
        results[73][67]="1944242492124535";
        results[73][68]="1.145526011577904E+71";
        results[73][69]="8635404905.580393";
        results[73][70]="8.410781812340964E+65";
        results[73][71]="52773.47620913591";
        results[73][72]="2.049990301342397E+61";
        results[73][73]="1";
        results[73][74]="5.725384586557730E+55";
        results[74][0]="8.052301557585906E-8";
        results[74][1]="1.770605365462456E-13";
        results[74][2]="3.972666639277327E-18";
        results[74][3]="4.632562604379404E-23";
        results[74][4]="3.233381495395381E-28";
        results[74][5]="1.008794965777072E-12";
        results[74][6]="0.0006269198812448631";
        results[74][7]="9.674280804091849E-18";
        results[74][8]="9.241980019390084E-10";
        results[74][9]="9.017812162240471E-23";
        results[74][10]="3.291107413129942E-14";
        results[74][11]="1.092791965506384E-27";
        results[74][12]="1.467322244295588E-19";
        results[74][13]="1.374917076937174E-32";
        results[74][14]="1.105534921407618E-24";
        results[74][15]="1.187616773274011E-16";
        results[74][16]="1.364334847713883";
        results[74][17]="1.405582368754908E-21";
        results[74][18]="0.00001070746835276518";
        results[74][19]="9.059629594726956E-27";
        results[74][20]="3.623491507959662E-10";
        results[74][21]="1.689171516062104E-31";
        results[74][22]="2.081695150848690E-15";
        results[74][23]="1.851345444067719E-36";
        results[74][24]="1.102648597668354E-20";
        results[74][25]="1.103824654270814E-20";
        results[74][26]="29565.64565260007";
        results[74][27]="1.286815434870144E-25";
        results[74][28]="0.4559686490696489";
        results[74][29]="2.196614918797670E-30";
        results[74][30]="0.000001027626532239985";
        results[74][31]="2.680169766841597E-35";
        results[74][32]="2.089218688706290E-11";
        results[74][33]="1.153239933824738E-40";
        results[74][34]="5.527147087483460E-16";
        results[74][35]="1.356790426208511E-24";
        results[74][36]="285900258.4934282";
        results[74][37]="1.147951679823628E-29";
        results[74][38]="1399.214455677041";
        results[74][39]="1.223484963110475E-34";
        results[74][40]="0.02536899052671676";
        results[74][41]="1.958778561659312E-39";
        results[74][42]="9.161688649454979E-8";
        results[74][43]="3.533569266587664E-44";
        results[74][44]="2.406702744894305E-12";
        results[74][45]="3.099474788713032E-28";
        results[74][46]="1687536852317.355";
        results[74][47]="1.126738708841461E-33";
        results[74][48]="13973813.58756047";
        results[74][49]="4.771812612164872E-38";
        results[74][50]="470.9377016512027";
        results[74][51]="1.187744802071186E-43";
        results[74][52]="0.008438652308849302";
        results[74][53]="2.474078779366023E-48";
        results[74][54]="3.441377655339997E-8";
        results[74][55]="1.253045969730694E-32";
        results[74][56]="1.446448413805017E+16";
        results[74][57]="1.256819901603824E-37";
        results[74][58]="115612759725.7422";
        results[74][59]="2.466073435932954E-42";
        results[74][60]="5971578.629938194";
        results[74][61]="1.139989719793558E-47";
        results[74][62]="42.69331595631704";
        results[74][63]="9.696035386027837E-53";
        results[74][64]="0.0004460990046813902";
        results[74][65]="1.051987332763925E-36";
        results[74][66]="9.378580946051059E+19";
        results[74][67]="3.395828634270787E-41";
        results[74][68]="2000784391440555";
        results[74][69]="1.508266348754094E-46";
        results[74][70]="14690335094.84779";
        results[74][71]="9.217455248864755E-52";
        results[74][72]="358052.8557252626";
        results[74][73]="1.746607559512835E-56";
        results[74][74]="1";
    }

    public static int mcDivideTests() {
        int failures = 0;
        for(int i=0; i<value.length; i++) {
            for(int j=0; j<value.length; j++) {
                BigDecimal v1 = new BigDecimal(value[i]);
                BigDecimal v2 = new BigDecimal(value[j]);
                BigDecimal res1  = v1.divide(v2, MathContext.DECIMAL64);
                if(!res1.toString().equals(results[i][j])) {
                    failures++;
                    System.err.println("Unexpected result from " + v1 + " / " + v2 +
                                       "; expected " + results[i][j] + " got " + res1);

                }
            }
        }
        for (int mpc = 1; mpc < 23; mpc++) {
            for (int i = 0; i < value.length; i++) {
                for (int j = 0; j < value.length; j++) {
                    BigDecimal v1 = new BigDecimal(value[i]);
                    BigDecimal v2 = new BigDecimal(value[j]);
                    BigDecimal res1 = v1.divide(v2, new MathContext(mpc, RoundingMode.HALF_EVEN));
                    BigDecimal res2 = v1.divide(v2, new MathContext(128, RoundingMode.HALF_EVEN)).round(new MathContext(mpc, RoundingMode.HALF_EVEN));
                    if (!res1.equals(res2)) {
                        failures++;
                        System.err.println("Unexpected result from " + v1 + " / " + v2 +
                                           "; expected " + res2 + " got " + res1);

                    }
                }
            }
        }
        return failures;
    }

    public static void main(String argv[]) {
        int failures = 0;
        failures += mcDivideTests();
        if (failures > 0) {
            throw new RuntimeException("Incurred " + failures +
                                       " failures while testing DECIMAL64 divide.");
        }
    }

}
