/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc;

import com.google.javascript.rhino.head.CompilerEnvirons;
import com.google.javascript.rhino.head.IRFactory;
import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.AstRoot;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.chromium.devtools.jsdoc.DoDidNodeVisitor;
import org.chromium.devtools.jsdoc.DoDidVisitorAdapter;
import org.chromium.devtools.jsdoc.ScriptText;
import org.chromium.devtools.jsdoc.ValidationCheck;
import org.chromium.devtools.jsdoc.ValidatorContext;
import org.chromium.devtools.jsdoc.checks.ContextTrackingValidationCheck;

public class FileCheckerCallable
implements Callable<ValidatorContext> {
    private final String fileName;

    public FileCheckerCallable(String string) {
        this.fileName = string;
    }

    @Override
    public ValidatorContext call() {
        try {
            ValidatorContext validatorContext = new ValidatorContext(this.readScriptText(), this.fileName);
            AstRoot astRoot = FileCheckerCallable.parseScript(validatorContext);
            ValidationCheckDispatcher validationCheckDispatcher = new ValidationCheckDispatcher(validatorContext);
            validationCheckDispatcher.registerCheck(new ContextTrackingValidationCheck());
            astRoot.visit(validationCheckDispatcher);
            validationCheckDispatcher.flush();
            return validatorContext;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileCheckerCallable.logError("File not found: " + this.fileName);
        }
        catch (IOException iOException) {
            FileCheckerCallable.logError("Failed to read file " + this.fileName);
        }
        return null;
    }

    private ScriptText readScriptText() throws IOException {
        byte[] byArray = Files.readAllBytes(FileSystems.getDefault().getPath(this.fileName, new String[0]));
        String string = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(byArray)).toString();
        return new ScriptText(string);
    }

    private static AstRoot parseScript(ValidatorContext validatorContext) throws IOException {
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.setRecoverFromErrors(true);
        compilerEnvirons.setGenerateDebugInfo(true);
        compilerEnvirons.setRecordingLocalJsDocComments(true);
        compilerEnvirons.setAllowSharpComments(true);
        compilerEnvirons.setRecordingComments(true);
        IRFactory iRFactory = new IRFactory(compilerEnvirons);
        return iRFactory.parse(new StringReader(validatorContext.scriptText.text), validatorContext.scriptFileName, 1);
    }

    private static void logError(String string) {
        System.err.println("ERROR: " + string);
    }

    private static class ValidationCheckDispatcher
    extends DoDidVisitorAdapter {
        private final List<ValidationCheck> checks = new ArrayList<ValidationCheck>(2);
        private final ValidatorContext context;

        public ValidationCheckDispatcher(ValidatorContext validatorContext) {
            this.context = validatorContext;
        }

        public void registerCheck(ValidationCheck validationCheck) {
            validationCheck.setContext(this.context);
            this.checks.add(validationCheck);
        }

        @Override
        public void doVisit(AstNode astNode) {
            for (DoDidNodeVisitor doDidNodeVisitor : this.checks) {
                doDidNodeVisitor.doVisit(astNode);
            }
        }

        @Override
        public void didVisit(AstNode astNode) {
            for (ValidationCheck validationCheck : this.checks) {
                validationCheck.didVisit(astNode);
            }
        }
    }
}

