/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_SIF.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgi_sysINIfile(void)

	Return the dynamically allocated name of the system INI file.

	The path is choosen:
		<appPath>\..\ETC	if exist
		<appPath>			otherwise

	Return:
		NULL: memory allocation error
		else: pointer to duplicated buffer, must be free()'ed by the user

ob: cfgi_sysINIfile
ty: L
su: inifile
sh: Return the name of the system INI file
lo: Returns the dynamically allocated name of the system INI file.\par
	The path to the INI file is either <path>\..\ETC or, if that path
	does not exist, <path>. <path> itself is either the string set by
	cfgChangePathINI() or appPathEx() on default.
wa: The returned string must be dealloacated manually.
va: NULL: if out of memory
re: cfgi_apppath \subsys{appName} cfgChangePathINI
fi: cfgi_sif.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"
#include "dynstr.h"
#include "appname.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_SIF.C 1.4 2001/02/27 01:27:57 ska Exp ska $";
#endif

char *cfgi_sysINIfile(void)
{	char *path, *tpath;
	int w;

	DBG_ENTER("cfgi_sysINIfile", Suppl_inifile)

	chkHeap
	if((path = cfgi_apppath? cfgi_apppath: appPathEx()) == 0)
		/* no path to application available */
		DBG_RETURN_BS( dfnpath(0))

	chkHeap
	if((tpath = StrConcat(2, path, CFG_SYSINI)) == 0)
		DBG_RETURN_S( 0)

	chkHeap
	w = dfnstat(tpath) & DFN_DIRECTORY;
	chkHeap
	free(tpath);

	chkHeap
	DBG_RETURN_BS( w? StrConcat(5, path, CFG_SYSINI, "\\", cfgi_appName(), CFG_INIEXT)
		: StrConcat(4, path, "\\", cfgi_appName(), CFG_INIEXT))
}
