/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.ResponseMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResponseMetadataCache {
    private final int maxEntries;
    private Map<Integer, ResponseMetadata> map;
    private List<Object> objectList;

    public ResponseMetadataCache(int maxEntries) {
        this.maxEntries = maxEntries;
        this.objectList = new ArrayList<Object>(maxEntries);
        this.map = new HashMap<Integer, ResponseMetadata>();
    }

    public synchronized void add(Object obj, ResponseMetadata metadata) {
        if (obj == null) {
            return;
        }
        if (this.map.size() >= this.maxEntries) {
            this.evictOldest();
        }
        this.store(System.identityHashCode(obj), metadata);
    }

    public ResponseMetadata get(Object obj) {
        return this.map.get(System.identityHashCode(obj));
    }

    private void evictOldest() {
        this.map.remove(this.objectList.remove(0));
    }

    private void store(int id, ResponseMetadata metadata) {
        this.map.put(id, metadata);
        this.objectList.add(id);
    }
}

