/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import org.broadinstitute.gatk.utils.MathUtils;
import org.broadinstitute.gatk.utils.QualityUtils;

public class PairHMMModel {
    public static final int TRANS_PROB_ARRAY_LENGTH = 6;
    public static final int matchToMatch = 0;
    public static final int indelToMatch = 1;
    public static final int matchToInsertion = 2;
    public static final int insertionToInsertion = 3;
    public static final int matchToDeletion = 4;
    public static final int deletionToDeletion = 5;
    private static double LN10 = Math.log(10.0);
    private static double INV_LN10 = 1.0 / LN10;
    private static double[] matchToMatchProb = new double[32640];
    private static double[] matchToMatchLog10 = new double[32640];

    private PairHMMModel() {
    }

    public static void qualToTransProbs(double[] dest, byte insQual, byte delQual, byte gcp) {
        if (insQual < 0) {
            throw new IllegalArgumentException("insert quality cannot less than 0: " + insQual);
        }
        if (delQual < 0) {
            throw new IllegalArgumentException("deletion quality cannot be less than 0: " + delQual);
        }
        if (gcp < 0) {
            throw new IllegalArgumentException("gcp cannot be less than 0: " + gcp);
        }
        dest[0] = PairHMMModel.matchToMatchProb(insQual, delQual);
        dest[2] = QualityUtils.qualToErrorProb(insQual);
        dest[4] = QualityUtils.qualToErrorProb(delQual);
        dest[1] = QualityUtils.qualToProb(gcp);
        dest[3] = dest[5] = QualityUtils.qualToErrorProb(gcp);
    }

    public static double[] qualToTransProbs(byte insQual, byte delQual, byte gcp) {
        double[] dest = new double[6];
        PairHMMModel.qualToTransProbs(dest, insQual, delQual, gcp);
        return dest;
    }

    public static void qualToTransProbs(double[][] dest, byte[] insQuals, byte[] delQuals, byte[] gcps) {
        int readLength = insQuals.length;
        if (delQuals.length != readLength) {
            throw new IllegalArgumentException("deletion quality array length does not match insert quality array length: " + readLength + " != " + delQuals.length);
        }
        if (gcps.length != readLength) {
            throw new IllegalArgumentException("deletion quality array length does not match insert quality array length: " + readLength + " != " + gcps.length);
        }
        if (dest.length < readLength + 1) {
            throw new IllegalArgumentException("destination length is not enough for the read length: " + dest.length + " < " + readLength + " + 1");
        }
        for (int i = 0; i < readLength; ++i) {
            PairHMMModel.qualToTransProbs(dest[i + 1], insQuals[i], delQuals[i], gcps[i]);
        }
    }

    public static double[][] qualToTransProbs(byte[] insQuals, byte[] delQuals, byte[] gcps) {
        double[][] dest = PairHMMModel.createTransitionMatrix(insQuals.length);
        PairHMMModel.qualToTransProbs(dest, insQuals, delQuals, gcps);
        return dest;
    }

    public static void qualToTransProbsLog10(double[] dest, byte insQual, byte delQual, byte gcp) {
        if (insQual < 0) {
            throw new IllegalArgumentException("insert quality cannot less than 0: " + insQual);
        }
        if (delQual < 0) {
            throw new IllegalArgumentException("deletion quality cannot be less than 0: " + delQual);
        }
        if (gcp < 0) {
            throw new IllegalArgumentException("gcp cannot be less than 0: " + gcp);
        }
        dest[0] = PairHMMModel.matchToMatchProbLog10(insQual, delQual);
        dest[2] = QualityUtils.qualToErrorProbLog10(insQual);
        dest[4] = QualityUtils.qualToErrorProbLog10(delQual);
        dest[1] = QualityUtils.qualToProbLog10(gcp);
        dest[3] = dest[5] = QualityUtils.qualToErrorProbLog10(gcp);
    }

    public static double[] qualToTransProbsLog10(byte insQual, byte delQual, byte gcp) {
        double[] dest = new double[6];
        PairHMMModel.qualToTransProbsLog10(dest, insQual, delQual, gcp);
        return dest;
    }

    public static void qualToTransProbsLog10(double[][] dest, byte[] insQuals, byte[] delQuals, byte[] gcps) {
        int readLength = insQuals.length;
        if (delQuals.length != readLength) {
            throw new IllegalArgumentException("deletion quality array length does not match insert quality array length: " + readLength + " != " + delQuals.length);
        }
        if (gcps.length != readLength) {
            throw new IllegalArgumentException("deletion quality array length does not match insert quality array length: " + readLength + " != " + gcps.length);
        }
        if (dest.length < readLength + 1) {
            throw new IllegalArgumentException("destination length is not enough for the read length: " + dest.length + " < " + readLength + " + 1");
        }
        for (int i = 0; i < readLength; ++i) {
            PairHMMModel.qualToTransProbsLog10(dest[i + 1], insQuals[i], delQuals[i], gcps[i]);
        }
    }

    public static double[][] qualToTransProbsLog10(byte[] insQuals, byte[] delQuals, byte[] gcps) {
        double[][] dest = PairHMMModel.createTransitionMatrix(insQuals.length);
        PairHMMModel.qualToTransProbsLog10(dest, insQuals, delQuals, gcps);
        return dest;
    }

    public static double[][] createTransitionMatrix(int maxReadLength) {
        return new double[maxReadLength + 1][6];
    }

    public static double matchToMatchProb(byte insQual, byte delQual) {
        return PairHMMModel.matchToMatchProb(insQual & 0xFF, delQual & 0xFF);
    }

    public static double matchToMatchProbLog10(byte insQual, byte delQual) {
        return PairHMMModel.matchToMatchProbLog10(insQual & 0xFF, delQual & 0xFF);
    }

    public static double matchToMatchProb(int insQual, int delQual) {
        int maxQual;
        int minQual;
        if (insQual <= delQual) {
            minQual = insQual;
            maxQual = delQual;
        } else {
            minQual = delQual;
            maxQual = insQual;
        }
        if (minQual < 0) {
            throw new IllegalArgumentException("quality cannot be negative: " + minQual + " and " + maxQual);
        }
        return 254 < maxQual ? 1.0 - Math.pow(10.0, MathUtils.approximateLog10SumLog10(-0.1 * (double)minQual, -0.1 * (double)maxQual)) : matchToMatchProb[(maxQual * (maxQual + 1) >> 1) + minQual];
    }

    public static double matchToMatchProbLog10(int insQual, int delQual) {
        int maxQual;
        int minQual;
        if (insQual <= delQual) {
            minQual = insQual;
            maxQual = delQual;
        } else {
            minQual = delQual;
            maxQual = insQual;
        }
        return 254 < maxQual ? Math.log1p(-Math.min(1.0, Math.pow(10.0, MathUtils.approximateLog10SumLog10(-0.1 * (double)minQual, -0.1 * (double)maxQual)))) * INV_LN10 : matchToMatchLog10[(maxQual * (maxQual + 1) >> 1) + minQual];
    }

    static {
        int i = 0;
        int offset = 0;
        while (i <= 254) {
            for (int j = 0; j <= i; ++j) {
                double log10Sum = MathUtils.approximateLog10SumLog10(-0.1 * (double)i, -0.1 * (double)j);
                PairHMMModel.matchToMatchLog10[offset + j] = Math.log1p(-Math.min(1.0, Math.pow(10.0, log10Sum))) * INV_LN10;
                PairHMMModel.matchToMatchProb[offset + j] = Math.pow(10.0, matchToMatchLog10[offset + j]);
            }
            offset += ++i;
        }
    }
}

