#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Endless Space
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250127.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='endless-space-1'
GAME_NAME='Endless Space'

ARCHIVE_BASE_0_NAME='setup_endlesstm_space_-_definitive_edition_1.0.0._(64185).exe'
ARCHIVE_BASE_0_MD5='84ccf58a734694a63db59e599344a254'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_endlesstm_space_-_definitive_edition_1.0.0._(64185)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='65a88affbdbff4aa78808b941184051b'
ARCHIVE_BASE_0_SIZE='3600000'
ARCHIVE_BASE_0_VERSION='1.1.59-gog64185'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/endless_space_definitive_edition'

UNITY3D_NAME='endless space'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME0_BIN_FILES='
avprowindowsmedia.dll
fmod_event.dll
fmod_event_net.dll
fmodex.dll
stlport_vc10.5.2.dll'
## The game fails to start if the Galaxy libraries are not available.
CONTENT_GAME1_BIN_FILES='
galaxy.dll
galaxycsharp.dll
galaxycsharpglue.dll'
CONTENT_GAME0_DATA_FILES='
public
public_xp1'

## The game engine expects write access to XML files.
USER_PERSISTENT_FILES='
*.xml'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/Endless Space'

## Skip playing the logo movie on launch,
## as it prevents reaching the game menu
APP_MAIN_OPTIONS='-nologo'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
deinterlace
video/x-ms-asf'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
