/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.logdata;

import gmonitor.logdata.DataBlock;
import gmonitor.logdata.DataBlockGroup;
import gmonitor.logdata.DataBlockGroupElement;
import gmonitor.logdata.DataBlockGroupTable;
import gmonitor.logdata.FirstMetaBlock;
import gmonitor.logdata.SecondMetaBlock;
import gmonitor.logdata.SeekableFile;
import gmonitor.logdata.SeekableFileFactory;
import gmonitor.logdata.UTY;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class DataFile
implements Comparable {
    private String url;
    private SeekableFile file;
    private FirstMetaBlock fmb;
    private SecondMetaBlock smb;
    private long latestDateTime = -1L;
    private long size;
    private int dbgroup_length;
    long datablock_pos;
    private static final int CAPACITY = 100;
    private static HashMap instanceMap = new HashMap();
    private static ArrayList instanceGeneration = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataFile getInstance(String string) throws IOException {
        DataFile dataFile = null;
        HashMap hashMap = instanceMap;
        synchronized (hashMap) {
            Object v = instanceMap.get(string);
            if (v == null) {
                dataFile = new DataFile(string);
                instanceMap.put(string, dataFile);
                instanceGeneration.add(string);
                if (instanceGeneration.size() > 100) {
                    String string2 = (String)instanceGeneration.remove(0);
                    DataFile dataFile2 = (DataFile)instanceMap.remove(string2);
                    dataFile2.close();
                }
            } else {
                dataFile = (DataFile)v;
                int n = instanceGeneration.indexOf(string);
                instanceGeneration.remove(n);
                instanceGeneration.add(string);
                DataFile dataFile3 = (DataFile)instanceMap.remove(string);
                dataFile3.close();
                dataFile = new DataFile(string);
                instanceMap.put(string, dataFile);
            }
        }
        return dataFile;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public void reload() throws IOException {
        this.initialize();
    }

    protected void initialize() throws IOException {
        this.file.seek(0L);
        byte[] byArray = new byte[2];
        this.file.read(byArray, 0, 2);
        int n = UTY.byte2int(byArray);
        byte[] byArray2 = new byte[n];
        this.file.read(byArray2, 0, n);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2, 0, n);
        this.fmb = FirstMetaBlock.newInstance(byteArrayInputStream, n);
        ((InputStream)byteArrayInputStream).close();
        byte[] byArray3 = new byte[4];
        this.file.read(byArray3, 0, 4);
        n = UTY.byte2int(byArray3);
        byte[] byArray4 = new byte[n];
        this.file.read(byArray4, 0, n);
        byteArrayInputStream = new ByteArrayInputStream(byArray4, 0, n);
        this.smb = SecondMetaBlock.newInstance(byteArrayInputStream, n);
        ((InputStream)byteArrayInputStream).close();
        this.size = this.file.size();
        DataBlockGroupTable dataBlockGroupTable = this.smb.getDataBlockGroupTable();
        ArrayList arrayList = dataBlockGroupTable.getDataBlockGroupElements();
        this.datablock_pos = this.fmb.getSize() + this.smb.getSize() + 2 + 4;
        this.dbgroup_length = (int)((this.size - this.datablock_pos) / (long)this.fmb.getDataBlockGroupSize());
        this.latestDateTime = -1L;
        this.file.seek(this.datablock_pos);
    }

    protected DataFile(String string) throws IOException {
        SeekableFile seekableFile;
        this.url = string;
        this.file = seekableFile = SeekableFileFactory.create(string);
        this.initialize();
    }

    public long getLength() {
        return this.dbgroup_length;
    }

    public FirstMetaBlock getFirstMetaBlock() {
        return this.fmb;
    }

    public SecondMetaBlock getSecondMetaBlock() {
        return this.smb;
    }

    public DataBlockGroup getDataBlockGroup(long l) throws IOException {
        int n = 0;
        DataBlockGroup dataBlockGroup = new DataBlockGroup();
        int n2 = this.fmb.getDataBlockGroupSize();
        byte[] byArray = new byte[n2];
        long l2 = this.datablock_pos + l * (long)n2;
        this.file.seek(l2);
        int n3 = this.file.read(byArray, 0, n2);
        if (n3 < 0) {
            throw new IOException("File pointer exceeded.");
        }
        DataBlockGroupTable dataBlockGroupTable = this.smb.getDataBlockGroupTable();
        ArrayList arrayList = dataBlockGroupTable.getDataBlockGroupElements();
        for (int i = 0; i < arrayList.size(); ++i) {
            DataBlockGroupElement[] dataBlockGroupElementArray = (DataBlockGroupElement[])arrayList.get(i);
            if (dataBlockGroupElementArray.length > 0) {
                int n4 = 8 + 5 * dataBlockGroupElementArray.length;
                DataBlock dataBlock = new DataBlock(byArray, n, dataBlockGroupElementArray.length);
                dataBlockGroup.add(dataBlock);
                n += n4;
                continue;
            }
            DataBlock dataBlock = new DataBlock();
            dataBlockGroup.add(dataBlock);
        }
        return dataBlockGroup;
    }

    public long getBeginDateTime() {
        return this.fmb.getBeginDate();
    }

    public long getLatestDateTime() throws IOException {
        if (this.latestDateTime > 0L) {
            return this.latestDateTime;
        }
        long l = this.fmb.getBeginDate();
        DataBlockGroup dataBlockGroup = this.getDataBlockGroup(this.dbgroup_length - 1);
        for (int i = 0; i < dataBlockGroup.size(); ++i) {
            long l2;
            DataBlock dataBlock = (DataBlock)dataBlockGroup.get(i);
            if (!dataBlock.isValid() || (l2 = dataBlock.getTime()) <= l) continue;
            l = l2;
        }
        this.latestDateTime = l;
        return l;
    }

    public boolean containsHost(String string) {
        return this.smb.containsHost(string);
    }

    public boolean containsEvent(String string) {
        return this.smb.containsEvent(string);
    }

    public boolean containsDateTime(long l) throws IOException {
        boolean bl = false;
        long l2 = this.getBeginDateTime();
        long l3 = this.getLatestDateTime();
        if (l2 <= l && l <= l3) {
            bl = true;
        }
        return bl;
    }

    public long getDataBlockGroupIndex(long l) throws IOException {
        long l2 = -1L;
        if (!this.containsDateTime(l)) {
            throw new IOException("TimePointOutOfRangeInFile " + this.getUrl() + " " + l);
        }
        long l3 = this.fmb.getGroupInterval();
        long l4 = this.getBeginDateTime();
        l2 = (l - l4) / l3;
        return l2;
    }

    public int compareTo(Object object) {
        if (!(object instanceof DataFile)) {
            throw new ClassCastException("Object is not compatible.");
        }
        DataFile dataFile = (DataFile)object;
        long l = this.getBeginDateTime();
        long l2 = dataFile.getBeginDateTime();
        return (int)(l - l2);
    }

    public String getUrl() {
        return this.url;
    }

    public DataBlock readDataBlock(long l) throws IOException {
        DataBlockGroupTable dataBlockGroupTable = this.smb.getDataBlockGroupTable();
        long l2 = dataBlockGroupTable.getDataBlockGroupElements().size();
        long l3 = l / l2;
        DataBlockGroup dataBlockGroup = null;
        try {
            dataBlockGroup = this.getDataBlockGroup(l3);
        }
        catch (IOException iOException) {
            return null;
        }
        int n = (int)(l % l2);
        if (n >= dataBlockGroup.size()) {
            return null;
        }
        DataBlock dataBlock = (DataBlock)dataBlockGroup.get(n);
        return dataBlock;
    }
}

