%{
#include "ghmm/sequence.h"
#ifdef GHMM_OBSOLETE
#include "ghmm/obsolete.h"
#endif /*GHMM_OBSOLETE*/
%}

/*==========================================================================
  ===== continous sequences ================================================ */

typedef struct ghmm_cseq {
  /** sequence array. sequence[i][j] = j-th symbol of i-th seq. */
  double **seq;
  /** array of sequence length */
  int *seq_len;
#ifdef GHMM_OBSOLETE
  /**  array of sequence labels */
    long *seq_label;
#endif /* GHMM_OBSOLETE */
  /**  array of sequence IDs*/
  double *seq_id;
  /** positive! sequence weights.  default is 1 = no weight */
  double *seq_w;
  /** total number of sequences */
  long seq_number;
  /** reserved space for sequences is always >= seq_number */
  long capacity;
  /** sum of sequence weights */
  double total_w;
  /** total number of dimensions */
  int dim;

  /** flags (internal) */
  unsigned int flags;
} ghmm_cseq;

extern int ghmm_cseq_free(ghmm_cseq **csq);
extern ghmm_cseq* ghmm_cseq_calloc(long number);

%extend ghmm_cseq {
%apply SWIGTYPE* DISOWN {ghmm_cseq* seq};
        ghmm_cseq(ghmm_cseq* seq) { return seq; }
%clear ghmm_cseq* seq;
        ghmm_cseq(long number) { return ghmm_cseq_calloc(number); }
        ghmm_cseq(double* seq, int length) {
            ghmm_cseq* self = ghmm_cseq_calloc(1);
            self->seq[0] = seq;
            self->seq_len[0] = length;
            return self;
        }
        ghmm_cseq(double** seqs, int* lengths, int number) {
            ghmm_cseq* self = ghmm_cseq_calloc(number);
            free(self->seq);
            free(self->seq_len);
            self->seq = seqs;
            self->seq_len = lengths;
            return self;
        }
        ~ghmm_cseq() { ghmm_cseq_free(&self); }

        //ghmm_cseq** truncate(int sqd_fields, double trunc_ratio, int seed);

        ghmm_cseq* get_singlesequence(int index);

%apply SWIGTYPE * DISOWN {ghmm_cseq* self};
        int subseq_free();
%clear ghmm_cseq* self;

        int add(ghmm_cseq *source);

        void clean();

        int partition(ghmm_cseq *sqd_train, ghmm_cseq *sqd_test, double train_ratio);

        void copy_all(long t_num, ghmm_cseq *source, long s_num);

        double* getSequence(int index) { return self->seq[index]; }
        void setSequence(int seqno, double *O) { self->seq[seqno] = O; }
        double getSymbol(int seqno, int index) { return self->seq[seqno][index]; }
        void setSymbol(int seqno, int index, double value) { self->seq[seqno][index] = value; }

        int  getLength(int i) {
                return self->seq_len[i]; }
        void setLength(int i, int len) { self->seq_len[i] = len; }

        double getWeight(int i) { return self->seq_w[i]; }
        void   setWeight(int i, double w) { self->seq_w[i] = w; }

        void write(char* filename, int discrete = 0)
            {
                FILE* file;
                file = fopen(filename, "at");
                if (file)
                {
                        ghmm_cseq_print(self, file, discrete); 
                        fclose(file);
                }
                else
                        PyErr_SetString(PyExc_TypeError,"Expecting a sequence");
            }
}

// ignore the input value for ghmm_cseq array to python list conversion
%typemap(in, numinputs=0) int *sqd_number (int temp) {
    $1 = &temp;
}
// convert array of ghmm_cseqs to python list
%typemap(argout) (int *sqd_number) {
    int i;
    PyObject *obj;
    Py_XDECREF($result);   /* Blow away any previous result */
    if (result) {
        $result = PyList_New(*$1);
        for (i=0; i<*$1; i++) {
            obj = SWIG_NewPointerObj(result[i], SWIGTYPE_p_ghmm_cseq, SWIG_POINTER_NEW);
            PyList_SetItem($result, i, obj);
        }
        free(result);
    }
    else {
        PyErr_SetString(PyExc_ValueError,"got a null pointer");
        return NULL;
    }
}
#ifdef GHMM_OBSOLETE
extern ghmm_cseq **ghmm_cseq_read(const char *filename, int *sqd_number);
#endif /*GHMM_OBSOLETE*/
REFERENCE_ARRAY(ghmm_cseq, cseq_ptr)
