// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticbeanstalk

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/elasticbeanstalk/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the specified configuration template to have the specified properties
// or configuration option values.
//
// If a property (for example, ApplicationName ) is not provided, its value remains
// unchanged. To clear such properties, specify an empty string.
//
// # Related Topics
//
// DescribeConfigurationOptions
func (c *Client) UpdateConfigurationTemplate(ctx context.Context, params *UpdateConfigurationTemplateInput, optFns ...func(*Options)) (*UpdateConfigurationTemplateOutput, error) {
	if params == nil {
		params = &UpdateConfigurationTemplateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateConfigurationTemplate", params, optFns, c.addOperationUpdateConfigurationTemplateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateConfigurationTemplateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The result message containing the options for the specified solution stack.
type UpdateConfigurationTemplateInput struct {

	// The name of the application associated with the configuration template to
	// update.
	//
	// If no application is found with this name, UpdateConfigurationTemplate returns
	// an InvalidParameterValue error.
	//
	// This member is required.
	ApplicationName *string

	// The name of the configuration template to update.
	//
	// If no configuration template is found with this name,
	// UpdateConfigurationTemplate returns an InvalidParameterValue error.
	//
	// This member is required.
	TemplateName *string

	// A new description for the configuration.
	Description *string

	// A list of configuration option settings to update with the new specified option
	// value.
	OptionSettings []types.ConfigurationOptionSetting

	// A list of configuration options to remove from the configuration set.
	//
	// Constraint: You can remove only UserDefined configuration options.
	OptionsToRemove []types.OptionSpecification

	noSmithyDocumentSerde
}

// Describes the settings for a configuration set.
type UpdateConfigurationTemplateOutput struct {

	// The name of the application associated with this configuration set.
	ApplicationName *string

	// The date (in UTC time) when this configuration set was created.
	DateCreated *time.Time

	// The date (in UTC time) when this configuration set was last modified.
	DateUpdated *time.Time

	//  If this configuration set is associated with an environment, the
	// DeploymentStatus parameter indicates the deployment status of this configuration
	// set:
	//
	//   - null : This configuration is not associated with a running environment.
	//
	//   - pending : This is a draft configuration that is not deployed to the
	//   associated environment but is in the process of deploying.
	//
	//   - deployed : This is the configuration that is currently deployed to the
	//   associated running environment.
	//
	//   - failed : This is a draft configuration that failed to successfully deploy.
	DeploymentStatus types.ConfigurationDeploymentStatus

	// Describes this configuration set.
	Description *string

	//  If not null , the name of the environment for this configuration set.
	EnvironmentName *string

	// A list of the configuration options and their values in this configuration set.
	OptionSettings []types.ConfigurationOptionSetting

	// The ARN of the platform version.
	PlatformArn *string

	// The name of the solution stack this configuration set uses.
	SolutionStackName *string

	//  If not null , the name of the configuration template for this configuration
	// set.
	TemplateName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateConfigurationTemplateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpUpdateConfigurationTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpUpdateConfigurationTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateConfigurationTemplate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateConfigurationTemplateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateConfigurationTemplate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateConfigurationTemplate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateConfigurationTemplate",
	}
}
