#ifndef _GFile_JPEG_H
#define _GFile_JPEG_H

#include "GFile.h"

/* GFile (ie. GImage) decendent for reading JPEG files.
 * 
 * Written by:  Chris Studholme
 * Last Update: 8-January-2000
 * Copyright:   GPL (http://www.fsf.org/copyleft/gpl.html)
 */

class GFile_JPEG : public GFile {
 protected:
  int w,h;
  unsigned int histogram[256];

 public:
  GFile_JPEG(const char* filename, bool fast=false);
  ~GFile_JPEG();

  static bool supportsFile(FILE* file);

  bool isOK() {
    return ((red!=NULL)&&(green!=NULL)&&(blue!=NULL));
  }

  void FindBestMinMax(int& min, int& max) {
    calculateBestMinMax(min,max,histogram);
  }

  const char* getComments() {
    return NULL;
  }
  int getWidth() {
    return w;
  }
  int getHeight() {
    return h;
  }
  
  /* width/height of individual pixel */
  double getAspectRatio() {
    return 1;
  }
  
  /* must have x1<x2, y1<y2,
   * pixel values are typically in [-16384,16383], but may be
   * out of this range
   */
  void getPixel(short& r, short& g, short& b,
		float x1, float y1, float x2, float y2) {
    r = red->getPixel(x1,y1,x2,y2);
    g = green->getPixel(x1,y1,x2,y2);
    b = blue->getPixel(x1,y1,x2,y2);
  }

  /* must have y1<y2
   */
  void getScanLineHorz(short* r, short* g, short* b,
		       float x1, float y1,
		       float x2, float y2, int npixels) {
    red->getScanLineHorz(r,x1,y1,x2,y2,npixels);
    green->getScanLineHorz(g,x1,y1,x2,y2,npixels);
    blue->getScanLineHorz(b,x1,y1,x2,y2,npixels);
  }

  /* must have x1<x2
   */
  void getScanLineVert(short* r, short* g, short* b,
		       float x1, float y1,
		       float x2, float y2, int npixels) {
    red->getScanLineVert(r,x1,y1,x2,y2,npixels);
    green->getScanLineVert(g,x1,y1,x2,y2,npixels);
    blue->getScanLineVert(b,x1,y1,x2,y2,npixels);
  }

};

#endif

