/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.RegexTranslator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class Matches
extends SystemFunction {
    private Pattern regexp;

    public Expression simplify() throws XPathException {
        Expression expression = this.simplifyArguments(true);
        if (!(expression instanceof Value)) {
            this.regexp = Matches.tryToCompile(this.argument, 1, 2);
        }
        return expression;
    }

    public static int setFlags(String string) throws XPathException {
        int n = 1;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            switch (c) {
                case 'm': {
                    n |= 8;
                    break;
                }
                case 'i': {
                    n |= 2;
                    break;
                }
                case 's': {
                    n |= 0x20;
                    break;
                }
                case 'x': {
                    n |= 4;
                    break;
                }
                default: {
                    throw new XPathException.Dynamic("Invalid character '" + c + "' in regular expression flags");
                }
            }
            ++n2;
        }
        return n;
    }

    protected static Pattern tryToCompile(Expression[] expressionArray, int n, int n2) throws XPathException {
        if (n > expressionArray.length - 1) {
            return null;
        }
        String string = null;
        if (expressionArray.length - 1 < n2) {
            string = "";
        } else if (expressionArray[n2] instanceof StringValue) {
            string = ((StringValue)expressionArray[n2]).getStringValue();
        }
        if (expressionArray[n] instanceof StringValue && string != null) {
            int n3 = Matches.setFlags(string);
            try {
                String string2 = RegexTranslator.translate(((StringValue)expressionArray[n]).getStringValue(), true);
                return Pattern.compile(string2, n3);
            }
            catch (RegexTranslator.RegexSyntaxException regexSyntaxException) {
                throw new XPathException.Dynamic(regexSyntaxException);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new XPathException.Dynamic(patternSyntaxException);
            }
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        Pattern pattern = this.regexp;
        if (pattern == null) {
            Object object;
            String string;
            AtomicValue atomicValue2 = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            if (this.getNumberOfArguments() == 2) {
                string = "";
            } else {
                object = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
                if (object == null) {
                    return null;
                }
                string = object.getStringValue();
            }
            try {
                object = RegexTranslator.translate(atomicValue2.getStringValue(), true);
                pattern = Pattern.compile((String)object, Matches.setFlags(string));
            }
            catch (RegexTranslator.RegexSyntaxException regexSyntaxException) {
                throw new XPathException.Dynamic(regexSyntaxException);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new XPathException.Dynamic(patternSyntaxException);
            }
        }
        return BooleanValue.get(pattern.matcher(atomicValue.getStringValue()).find());
    }
}

