#if   !defined(__SIXCYLINDERENGINE_HPP)
#define __SIXCYLINDERENGINE_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#include <Common.hpp>

#if   !defined(__ENGINE_HPP)
#include <Engine.hpp>
#endif

/**
SixCylinderEngine is concrete Engine that has six (6) cylinders.
*/
      
DECLARE_CLASS(SixCylinderEngine);

class SixCylinderEngine : public Engine
{

public:

                        /// Default constructor

                        SixCylinderEngine( void );

                        /// Copy Constructor 

                        SixCylinderEngine( SixCylinderEngineCref aRef );

                        /// Destructor

   virtual              ~SixCylinderEngine( void );

   //
   // Operator overloads
   //

            /// Assignment operator
         
            SixCylinderEngineRef   operator=( SixCylinderEngineCref );
         
            /// Equality operator
         
            bool        operator==( SixCylinderEngineCref aRef ) const;

   //
   // Accessors
   //

            /// Return the Cylinders count

   virtual  CylindersCref  getCylinders( void ) const ;

   //
   // Factory method
   //
            
            /// Duplicates the engine

   virtual  EnginePtr   clone( void ) const;

protected:

            /// Fixed cylinder count

   static   Cylinders   theCylinders;

};

#endif // if !defined __SIXCYLINDERENGINE_HPP

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.3 $
   $Date: 2000/02/11 03:22:19 $
   $Locker:  $
*/


