--TESTSETUP cp c.ads1 c.ads
--TESTSETUP cp b.ads1 b.ads
--TESTSETUP gcc -c c.ads
--TESTSETUP gcc -c b.ads

--  We know that T has a child T2
CHILD_TYPES t:c.ads:2:8
#  1> T2:b.ads:3:9

PARENT_TYPES t:c.ads:2:8
#  1> predefined entity: Integer

PARENT_TYPES T2:b.ads:3:9
#  1> T:c.ads:2:8

--  Simulate a change on c.ads.
--  The type T still exists, so we need to preserve the relationship
--  between T and T2.
shell sleep 2
shell cp c.ads3 c.ads
shell gcc -c c.ads
REFRESH
CHILD_TYPES t:c.ads:2:8
#  1> T2:b.ads:3:9
PARENT_TYPES t:c.ads:2:8
#  1> predefined entity: Integer
PARENT_TYPES T2:b.ads:3:9
#  1> T:c.ads:2:8

--  Let's remove the definition of T. It should be removed from the database
--  now (and no longer be marked as the parent of T2). We haven't recompiled
--  b.ads, so it's ALI file still refers to T:c.ads. But since the ALI file
--  hasn't changed, we are now reparsing it.
shell sleep 2
shell cp c.ads2 c.ads
shell gcc -c c.ads
REFRESH
DECL t:c.ads:2:8
#Error: entity not found 't:c.ads:2:8'

PARENT_TYPES t2:b.ads:3:9

--  Now b no longer depends on T. T should be removed from the database
shell sleep 2
shell cp b.ads2 b.ads
shell gcc -c b.ads
REFRESH
DECL t:c.ads:2:8
#Error: entity not found 't:c.ads:2:8'
PARENT_TYPES t2:b.ads:3:9
#  1> predefined entity: Integer
