/*
 * @(#)IClassMetaDataWriter.java
 *
 * Copyright (C) 2002-2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.datastore;

import java.io.IOException;


/**
 * Knows how to store the meta-data in a repository.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/03/09 22:23:58 $
 * @since     December 15, 2002
 */
public interface IClassMetaDataWriter
{
    /**
     * Writes the given class record and its associated marks for this
     * Analysis Module to the repository.  If class record <tt>cr</tt>
     * has already been written, another call will overwrite any existing
     * data.
     *
     * @param cr the class record to write to the underlying repository.
     * @exception IOException thrown if there is an underlying problem, or
     *      if the close method has been executed.
     * @exception IllegalArgumentException if <tt>cr</tt> is <tt>null</tt>.
     */
    public void writeClassRecord( ClassRecord cr )
            throws IOException;
    
    
    /**
     * Closes off the writer's connection to the store.
     *
     * @exception IOException thrown if there is an underlying problem, or
     *      if the close method has been executed before.
     */
    public void close()
            throws IOException;
}

