-----------------------------------------------------------------------
--              GtkAda - Ada95 binding for Gtk+/Gnome                --
--                                                                   --
--                     Copyright (C) 2001                            --
--                         ACT-Europe                                --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-----------------------------------------------------------------------

with Glib; use Glib;
with Gtk; use Gtk;
with System;

package body Gnome.Druid_Page is

   ----------
   -- Back --
   ----------

   function Back
     (Druid_Page : access Gnome_Druid_Page_Record) return Boolean
   is
      function Internal (Druid_Page : System.Address) return Gint;
      pragma Import (C, Internal, "gnome_druid_page_back");
   begin
      return Boolean'Val (Internal (Get_Object (Druid_Page)));
   end Back;

   ------------
   -- Cancel --
   ------------

   function Cancel (Druid_Page : access Gnome_Druid_Page_Record)
                    return Boolean
   is
      function Internal (Druid_Page : System.Address)
                         return Gint;
      pragma Import (C, Internal, "gnome_druid_page_cancel");
   begin
      return Boolean'Val (Internal (Get_Object (Druid_Page)));
   end Cancel;

   ------------
   -- Finish --
   ------------

   procedure Finish (Druid_Page : access Gnome_Druid_Page_Record)
   is
      procedure Internal (Druid_Page : System.Address);
      pragma Import (C, Internal, "gnome_druid_page_finish");
   begin
      Internal (Get_Object (Druid_Page));
   end Finish;

   ----------
   -- Next --
   ----------

   function Next (Druid_Page : access Gnome_Druid_Page_Record)
                  return Boolean
   is
      function Internal (Druid_Page : System.Address)
                         return Gint;
      pragma Import (C, Internal, "gnome_druid_page_next");
   begin
      return Boolean'Val (Internal (Get_Object (Druid_Page)));
   end Next;

   -------------
   -- Prepare --
   -------------

   procedure Prepare (Druid_Page : access Gnome_Druid_Page_Record)
   is
      procedure Internal (Druid_Page : System.Address);
      pragma Import (C, Internal, "gnome_druid_page_prepare");
   begin
      Internal (Get_Object (Druid_Page));
   end Prepare;

end Gnome.Druid_Page;
