package Locales::DB::Language::ta;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::ta::VERSION = '0.09';

$Locales::DB::Language::ta::cldr_version = '2.0';

%Locales::DB::Language::ta::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "மொழி\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ மற்றும்\ \{1\}",
            'end'    => "\{0\}\ மற்றும்\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#\,\#\#0\%",
        'territory' => "மண்டலம்\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "இல்லை\:இ",
        'yesstr' => "ஆம்\:ஆ"
    },
);

%Locales::DB::Language::ta::code_to_name = (
    'aa'     => 'அஃபார்',
    'ab'     => 'அப்காஜியான்',
    'ace'    => 'ஆச்சினீஸ்',
    'ach'    => 'அகோலி',
    'ada'    => 'அதாங்மே',
    'ady'    => 'அதகே',
    'ae'     => 'அவெஸ்தான்',
    'af'     => 'ஆஃப்ரிகான்ஸ்',
    'afa'    => "அஃப்ரோ\-ஏசியாடிக்\ மொழி",
    'afh'    => 'அஃப்ரிஹிலி',
    'agq'    => 'Aghem',
    'ain'    => 'ஐனு',
    'ak'     => 'அகான்',
    'akk'    => 'அக்கேதியன்',
    'ale'    => 'அலூட்',
    'alg'    => "அல்கான்கியன்\ மொழி",
    'alt'    => "தெற்கு\ அல்தை",
    'am'     => 'அம்ஹாரிக்',
    'an'     => 'ஆர்கோனீஸ்',
    'ang'    => "பழைய\ ஆங்கிலம்",
    'anp'    => 'அங்கிகா',
    'apa'    => "அபாச்சி\ மொழி",
    'ar'     => 'அரபு',
    'arc'    => 'அராமைக்',
    'arn'    => 'அரௌகேனியன்',
    'arp'    => 'அரபஹோ',
    'art'    => "செயற்கையான\ மொழி",
    'arw'    => 'அராவாக்',
    'as'     => 'அஸ்ஸாமி',
    'asa'    => 'Asu',
    'ast'    => 'அஸ்துரியன்',
    'ath'    => "அதாபஸ்கான்\ மொழி",
    'aus'    => "ஆஸ்த்ரேலிய\ மொழி",
    'av'     => 'அவேரிக்',
    'awa'    => 'அவதி',
    'ay'     => 'அய்மரா',
    'az'     => 'அஸேரி',
    'ba'     => 'பாஷ்கிர்',
    'bad'    => 'பாண்டா',
    'bai'    => "பமிலெகே\ மொழி",
    'bal'    => 'பெலுசி',
    'ban'    => 'பலினீஸ்',
    'bas'    => 'பாஸா',
    'bat'    => "பால்டிக்\ மொழி",
    'be'     => 'பைலோருஷ்ன்',
    'bej'    => 'பேஜா',
    'bem'    => 'பெம்பா',
    'ber'    => 'பெர்பெர்',
    'bez'    => 'Bena',
    'bg'     => 'பல்கேரியன்',
    'bh'     => 'பிஹாரி',
    'bho'    => 'போஜ்பூரி',
    'bi'     => 'பிஸ்லாமா',
    'bik'    => 'பிகோல்',
    'bin'    => 'பினி',
    'bla'    => 'சிக்சிகா',
    'bm'     => 'பம்பாரா',
    'bn'     => 'வங்காளம்',
    'bnt'    => 'பான்டு',
    'bo'     => 'திபெத்து',
    'br'     => 'பிரிடன்',
    'bra'    => 'ப்ராஜ்',
    'brx'    => 'Bodo',
    'bs'     => 'போஸ்னியன்',
    'btk'    => 'பாடாக்',
    'bua'    => 'புரியாத்',
    'bug'    => 'புகினீஸ்',
    'byn'    => 'ப்லின்',
    'ca'     => 'காடலான்',
    'cad'    => 'கேடோ',
    'cai'    => "மத்திய\ அமெரிக்கன்\ இன்டியன்\ மொழி",
    'car'    => 'கரீப்',
    'cau'    => "காகேஷியன்\ மொழி",
    'cay'    => 'Cayuga',
    'cch'    => 'ஆட்சம்',
    'ce'     => 'செசென்',
    'ceb'    => 'செபுவானோ',
    'cel'    => "கெல்டிக்\ மொழி",
    'cgg'    => 'Chiga',
    'ch'     => 'சாமோரோ',
    'chb'    => 'சிப்சா',
    'chg'    => 'ஷகதை',
    'chk'    => 'சூகிசே',
    'chm'    => 'மாரி',
    'chn'    => "சினூக்\ ஜார்கான்",
    'cho'    => 'சோக்தௌ',
    'chp'    => 'சிபெவ்யான்',
    'chr'    => 'செரூக்கி',
    'chy'    => 'செயேனி',
    'cmc'    => "சாமிக்\ மொழி",
    'co'     => 'கார்சியன்',
    'cop'    => 'காப்டிக்',
    'cpe'    => "ஆங்கில\ அடைப்படையிலான\ கிரியோல்\ மற்றும்\ பிஜின்",
    'cpf'    => "ஃப்ரென்ச்\ அடைப்படையிலான\ கிரியோல்\ மற்றும்\ பிஜின்",
    'cpp'    => "போர்சுக்கீஸ்\ அடைப்படையிலான\ கிரியோல்\ மற்றும்\ பிஜின்",
    'cr'     => 'க்ரீ',
    'crh'    => "கிரிமியன்\ துர்க்கி",
    'crp'    => "கிரியோல்\ மற்றும்\ பிஜின்",
    'cs'     => 'செக்',
    'csb'    => 'கஷுபியன்',
    'cu'     => "சர்ச்\ ஸ்லாவிக்",
    'cus'    => "குஷிடிக்\ மொழி",
    'cv'     => 'சுவாஷ்',
    'cy'     => 'வெல்ஷ்',
    'da'     => 'டேனிஷ்',
    'dak'    => 'தகோடா',
    'dar'    => 'தார்குவா',
    'dav'    => 'Taita',
    'day'    => 'தயாக்',
    'de'     => 'ஜெர்மன்',
    'de_at'  => "ஆஸ்ட்ரியன்\ ஜெர்மன்",
    'de_ch'  => "ஸ்விஸ்\ ஹை\ ஜெர்மன்",
    'del'    => 'தெலாவேர்',
    'den'    => 'ஸ்லாவ்',
    'dgr'    => 'டோக்ரிப்',
    'din'    => 'டின்கா',
    'dje'    => 'Zarma',
    'doi'    => 'டோக்ரி',
    'dra'    => "திராவிட\ மொழி",
    'dsb'    => "லோவர்\ சோர்பியன்",
    'dua'    => 'துவாலா',
    'dum'    => "மத்திய\ டச்சு",
    'dv'     => 'திவேஹி',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'ட்யூலா',
    'dz'     => 'பூடானி',
    'ebu'    => 'Embu',
    'ee'     => 'ஈஓயே',
    'efi'    => 'எஃபிக்',
    'egy'    => "பண்டைய\ எகிப்தியன்",
    'eka'    => 'ஈகாஜுக்',
    'el'     => 'கிரேக்கம்',
    'elx'    => 'எலமைட்',
    'en'     => 'ஆங்கிலம்',
    'en_au'  => "ஆஸ்ட்ரேலியன்\ ஆங்கிலம்",
    'en_ca'  => "கனடியன்\ ஆங்கிலம்",
    'en_gb'  => "ஆங்கிலம்\ \(யூகே\)",
    'en_us'  => "ஆங்கிலம்\ \(யூஎஸ்\)",
    'enm'    => "மத்திய\ ஆங்கிலம்",
    'eo'     => 'எஸ்பரேன்டோ',
    'es'     => 'ஸ்பானிஷ்',
    'es_419' => "லத்தின்\ அமெரிக்கன்\ ஸ்பானிஷ்",
    'es_es'  => "ஐபெரியன்\ ஸ்பானிஷ்",
    'et'     => 'எஸ்டோனியன்',
    'eu'     => 'பஸ்க்',
    'ewo'    => 'எவோன்டோ',
    'fa'     => 'பர்ஸியன்',
    'fan'    => 'ஃபங்க்',
    'fat'    => 'ஃபான்டி',
    'ff'     => 'ஃபுலா',
    'fi'     => 'பின்னிஷ்',
    'fil'    => 'ஃபிலிபினோ',
    'fiu'    => "ஃபினோ\-உக்ரைன்\ மொழி",
    'fj'     => 'ஃபிஜி',
    'fo'     => 'ஃபரிஸ்த்',
    'fon'    => 'ஃபான்',
    'fr'     => 'பிரெஞ்சு',
    'fr_ca'  => "கெனடியன்\ பிரன்சு",
    'fr_ch'  => "ஸ்விஸ்\ பிரன்சு",
    'frm'    => "மத்திய\ ஃப்ரென்ச்",
    'fro'    => "பழைய\ ஃப்ரென்ச்",
    'frr'    => "வடக்கு\ ஃப்ரிஸியான்",
    'frs'    => "கிழக்கு\ ஃப்ரிஸியான்",
    'fur'    => 'ஃப்ரியூலியன்',
    'fy'     => "மேற்கத்திய\ பிரிஷிய",
    'ga'     => 'ஐரிஷ்',
    'gaa'    => 'கா',
    'gay'    => 'கயோ',
    'gba'    => 'பயா',
    'gd'     => "ஸ்காட்ஸ்\ கேலிக்",
    'gem'    => "ஜெர்மானிய\ மொழி",
    'gez'    => 'கீஜ்',
    'gil'    => 'கில்பெர்டீஸ்',
    'gl'     => 'காலிஸியன்',
    'gmh'    => "மத்திய\ ஹை\ ஜெர்மன்",
    'gn'     => 'குரானி',
    'goh'    => "பழைய\ ஹை\ ஜெர்மன்",
    'gon'    => 'கோன்டி',
    'gor'    => 'கோரோன்டலோ',
    'got'    => 'கோதிக்',
    'grb'    => 'க்ரேபோ',
    'grc'    => "பண்டைய\ கிரேக்கம்",
    'gsw'    => "ஸ்விஸ்\ ஜெர்மன்",
    'gu'     => 'குஜராத்தி',
    'guz'    => 'Gusii',
    'gv'     => 'மேங்க்ஸ்',
    'gwi'    => 'குவிசின்',
    'ha'     => 'ஹௌஸா',
    'hai'    => 'ஹைடா',
    'haw'    => 'ஹவாய்யான்',
    'he'     => 'ஹுப்ரு',
    'hi'     => 'இந்தி',
    'hil'    => 'ஹிலிகாய்னான்',
    'him'    => 'ஹிமாச்சலி',
    'hit'    => 'ஹிட்டைட்',
    'hmn'    => 'மாங்க்',
    'ho'     => "ஹிரி\ மோட்டு",
    'hr'     => 'குரோஷியன்',
    'hsb'    => "அப்பர்\ சோர்பியான்",
    'ht'     => 'ஹைத்தியன்',
    'hu'     => 'ஹங்கேரியன்',
    'hup'    => 'ஹுபா',
    'hy'     => 'ஆர்மேனியன்',
    'hz'     => 'ஹெரேரோ',
    'ia'     => 'இன்டர்லிங்குவா',
    'iba'    => 'இபான்',
    'id'     => 'இந்தோனேஷியன்',
    'ie'     => 'இன்டர்லிங்',
    'ig'     => 'இக்போ',
    'ii'     => "சிசுவான்\ ஈ",
    'ijo'    => 'இஜோ',
    'ik'     => 'இனுபியாக்',
    'ilo'    => 'இலோகோ',
    'inc'    => "இந்திய\ மொழி",
    'ine'    => "இன்டோ\-ஐரோப்பியன்\ மொழி",
    'inh'    => 'இங்குஷ்',
    'io'     => 'இடோ',
    'ira'    => "இரானியன்\ மொழி",
    'iro'    => "இரோகோயியன்\ மொழி",
    'is'     => 'ஐஸ்லென்டிக்',
    'it'     => 'இத்தாலியன்',
    'iu'     => 'இனுகிடூட்',
    'ja'     => 'ஜப்பானீஸ்',
    'jbo'    => 'லோஜ்பன்',
    'jmc'    => 'Machame',
    'jpr'    => "ஜூதேயோ\-பெர்ஷியன்",
    'jrb'    => "ஜூதேயோ\-அராபிக்",
    'jv'     => 'ஜாவானீஸ்',
    'ka'     => 'ஜியோர்ஜியன்',
    'kaa'    => "காரா\-கல்பாக்",
    'kab'    => 'கபாய்ல்',
    'kac'    => 'காசின்',
    'kaj'    => 'ஜ்ஜூ',
    'kam'    => 'கம்பா',
    'kar'    => 'கரேன்',
    'kaw'    => 'காவி',
    'kbd'    => 'கபார்டியன்',
    'kcg'    => 'தையாப்',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'கோரோ',
    'kg'     => 'காங்கோ',
    'kha'    => 'காஸி',
    'khi'    => "கொய்ஸன்\ மொழி",
    'kho'    => 'கோதானீஸ்',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'கிகுயூ',
    'kj'     => 'குவான்யாமா',
    'kk'     => 'கசாக்',
    'kl'     => 'கலாலிசூட்',
    'kln'    => 'Kalenjin',
    'km'     => 'கெமெர்',
    'kmb'    => 'கிம்புன்து',
    'kn'     => 'கன்னடம்',
    'ko'     => 'கொரியன்',
    'kok'    => 'கொங்கனி',
    'kos'    => 'கோஸ்ரைன்',
    'kpe'    => 'க்பெல்லே',
    'kr'     => 'கனுரி',
    'krc'    => "கராசே\-பல்கார்",
    'krl'    => 'கரேலியன்',
    'kro'    => 'க்ரு',
    'kru'    => 'குருக்',
    'ks'     => 'காஷ்மிரி',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'குர்திஷ்',
    'kum'    => 'கும்இக்',
    'kut'    => 'குடேனை',
    'kv'     => 'கோமி',
    'kw'     => 'கார்னிஷ்',
    'ky'     => 'கிர்கிஷ்',
    'la'     => 'லத்தின்',
    'lad'    => 'லடினோ',
    'lag'    => 'Langi',
    'lah'    => 'லஹன்டா',
    'lam'    => 'லம்பா',
    'lb'     => 'லக்க்ஷெம்பர்கிஷ்',
    'lez'    => 'லெஜ்ஜியன்',
    'lg'     => 'கான்டா',
    'li'     => 'லிம்பர்கிஷ்',
    'ln'     => 'லிங்காலா',
    'lo'     => 'லோத்தியன்',
    'lol'    => 'மோங்கோ',
    'loz'    => 'லோஜி',
    'lt'     => 'லிதுவேனியன்',
    'lu'     => "லுபா\-கடாங்கா",
    'lua'    => "லுபா\-லுலௌ",
    'lui'    => 'லுய்சேனோ',
    'lun'    => 'லூன்டா',
    'luo'    => 'லுயோ',
    'lus'    => 'லுஷய்',
    'luy'    => 'Luyia',
    'lv'     => 'லேட்வியன்',
    'mad'    => 'மதுரீஸ்',
    'mag'    => 'மகாஹி',
    'mai'    => 'மைதிலி',
    'mak'    => 'மகாசார்',
    'man'    => 'மான்டிங்கோ',
    'map'    => 'ஆஸ்ட்ரோனேஷியன்',
    'mas'    => 'மாசாய்',
    'mdf'    => 'மோக்க்ஷா',
    'mdr'    => 'மான்டார்',
    'men'    => 'மென்டீ',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'மலகாஸி',
    'mga'    => "மத்திய\ ஐரிஷ்",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'மார்ஷெலிஷ்',
    'mi'     => 'மௌரி',
    'mic'    => 'மிக்மாக்',
    'min'    => 'மின்னாங்கபௌ',
    'mis'    => "பலதரப்பட்ட\ மொழிகள்",
    'mk'     => 'மாஸிடோனியன்',
    'mkh'    => "மான்\-க்மெர்\ மொழி",
    'ml'     => 'மலையாளம்',
    'mn'     => 'மங்கோலியன்',
    'mnc'    => 'மன்சு',
    'mni'    => 'மனிபூரி',
    'mno'    => "மனோபோ\ மொழி",
    'mo'     => 'மோல்டாவியன்',
    'moh'    => 'மோஹாவ்க்',
    'mos'    => 'மோஸ்ஸி',
    'mr'     => 'மராத்தி',
    'ms'     => 'மலாய்',
    'mt'     => 'மால்டிஸ்',
    'mua'    => 'Mundang',
    'mul'    => "பல\ மொழிகள்",
    'mun'    => "முண்டா\ மொழி",
    'mus'    => 'க்ரீக்',
    'mwl'    => 'மிரான்டீஸ்',
    'mwr'    => 'மார்வாரி',
    'my'     => 'பர்மிஸ்',
    'myn'    => "மாயான்\ மொழி",
    'myv'    => 'ஏர்ஜியா',
    'na'     => 'நவ்ரூ',
    'nah'    => 'நஹுவால்',
    'nai'    => "வடக்கு\ அமெரிக்கன்\ இன்டியன்\ மொழி",
    'nap'    => 'நியோபோலிடன்',
    'naq'    => 'Nama',
    'nb'     => "நார்வே\ பொக்மால்",
    'nd'     => "வடக்கு\ தெபெலே",
    'nds'    => "லோ\ ஜெர்மன்",
    'ne'     => 'நேபாளி',
    'new'    => 'நெவாரி',
    'ng'     => 'தோங்கா',
    'nia'    => 'நியாஸ்',
    'nic'    => "நைஜர்\-கோரடோஃபனியன்\ மொழி",
    'niu'    => 'நியூவான்',
    'nl'     => 'டச்சு',
    'nl_be'  => 'பிலெமிஷ்',
    'nmg'    => 'Kwasio',
    'nn'     => "நார்வேஜியன்\ நியூநார்ஸ்க்",
    'no'     => 'நார்வே',
    'nog'    => 'நோகை',
    'non'    => "பழைய\ நோர்ஸ்",
    'nqo'    => "என்\'கோ",
    'nr'     => "தெற்கு\ தெபெலே",
    'nso'    => "வடக்கு\ சோதோ",
    'nub'    => "நியூபியன்\ மொழி",
    'nus'    => 'Nuer',
    'nv'     => 'நவாஜோ',
    'nwc'    => "பாரம்பரிய\ நேவாரி",
    'ny'     => 'நயன்ஜா',
    'nym'    => 'நியாம்வேஜி',
    'nyn'    => 'நியான்கோலே',
    'nyo'    => 'நியோரோ',
    'nzi'    => 'நிஜ்மா',
    'oc'     => 'ஆகிடியன்',
    'oj'     => 'ஓஜிபவா',
    'om'     => 'ஒரோமோ',
    'or'     => 'ஒரியா',
    'os'     => 'ஒசெட்டிக்',
    'osa'    => 'ஓசேஜ்',
    'ota'    => "ஒட்டோமன்\ துர்க்கி",
    'oto'    => "ஒட்டோமன்\ மொழி",
    'pa'     => 'பஞ்சாபி',
    'paa'    => "பபுவான்\ மொழி",
    'pag'    => 'பன்காசினன்',
    'pal'    => 'பாஹ்லவி',
    'pam'    => 'பம்பாங்கா',
    'pap'    => 'பபியேமென்டோ',
    'pau'    => 'பலௌவ்ன்',
    'peo'    => "பழைய\ பெர்ஷியன்",
    'phi'    => "பிலிபைன்\ மொழி",
    'phn'    => 'ஃபொனிஷியன்',
    'pi'     => 'பாலி',
    'pl'     => 'போலிஷ்',
    'pon'    => 'ஃபோன்பெயென்',
    'pra'    => "பராக்ரித்\ மொழி",
    'pro'    => "பழைய\ ப்ரோவென்சால்",
    'ps'     => 'புஷ்டோ',
    'pt'     => 'போர்ச்சுக்கீஸ்',
    'pt_br'  => "போர்ச்சுகீஸ்\ \(பிரேசில்\)",
    'pt_pt'  => "போர்ச்சுகீஸ்\ \(போர்ச்சுகல்\)",
    'qu'     => 'கிவேசுவா',
    'raj'    => 'ராஜஸ்தானி',
    'rap'    => 'ரபனுய்',
    'rar'    => 'ரரோடோங்கன்',
    'rm'     => "ரைட்டோ\-ரோமென்ஸ்",
    'rn'     => 'ருண்டி',
    'ro'     => 'ரோமேனியன்',
    'roa'    => "ரோமன்ஸ்\ மொழி",
    'rof'    => 'Rombo',
    'rom'    => 'ரோமானி',
    'ru'     => 'ரஷியன்',
    'rup'    => 'அரோமானியன்',
    'rw'     => 'கின்யாருவான்டா',
    'rwk'    => 'Rwa',
    'sa'     => 'சமஸ்கிருதம்',
    'sad'    => 'சான்டாவே',
    'sah'    => 'யாகுட்',
    'sai'    => "தென்\ அமெரிக்க\ இன்டியன்\ மொழி",
    'sal'    => "சாலிஷன்\ மொழி",
    'sam'    => "சமாரிடன்\ அராமைக்",
    'saq'    => 'Samburu',
    'sas'    => 'சாசாக்',
    'sat'    => 'சான்டாலி',
    'sbp'    => 'Sangu',
    'sc'     => 'சாடினியன்',
    'scn'    => 'சிசிலியன்',
    'sco'    => 'ஸ்காட்ஸ்',
    'sd'     => 'சிந்தி',
    'se'     => "வடக்கு\ சாமி",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'செல்குப்',
    'sem'    => "செமிடிக்\ மொழி",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'சாங்கோ',
    'sga'    => "பழைய\ ஐரிஷ்",
    'sgn'    => "சங்கேத\ மொழி",
    'sh'     => "செர்போ\-க்ரோஷியன்",
    'shi'    => 'Tachelhit',
    'shn'    => 'ஷான்',
    'si'     => 'சிங்களம்',
    'sid'    => 'சிடாமோ',
    'sio'    => "சியோயுவான்\ மொழி",
    'sit'    => "சினோ\-திபேத்தியன்\ மொழி",
    'sk'     => 'ஸ்லோவாக்',
    'sl'     => 'ஸ்லோவேனியன்',
    'sla'    => "ஸ்லாவிக்\ மொழி",
    'sm'     => 'ஸாமோவான்',
    'sma'    => "தெற்கு\ சாமி",
    'smi'    => "சாமி\ மொழி",
    'smj'    => "லுலே\ சாமி",
    'smn'    => "இனாரி\ சாமி",
    'sms'    => "ஸ்கோல்ட்\ சாமி",
    'sn'     => 'ஷோனா',
    'snk'    => 'சோனின்கே',
    'so'     => 'சோமாலி',
    'sog'    => 'சோக்தியன்',
    'son'    => 'சோங்காய்',
    'sq'     => 'அல்பெனியன்',
    'sr'     => 'செர்பியன்',
    'srn'    => "ஸ்ரானன்\ டோங்கோ",
    'srr'    => 'செரெர்',
    'ss'     => 'ஸ்வாடீ',
    'ssa'    => "நிலோ\-சஹாரன்\ மொழி",
    'ssy'    => 'Saho',
    'st'     => "தெற்கு\ ஸோதோ",
    'su'     => 'சுடானீஸ்',
    'suk'    => 'சுகுமா',
    'sus'    => 'சுசு',
    'sux'    => 'சுமேரியன்',
    'sv'     => 'ஸ்வீடிஷ்',
    'sw'     => 'சுவாஹிலி',
    'swb'    => 'கொமோரியன்',
    'swc'    => "Congo\ Swahili",
    'syc'    => "பாரம்பரிய\ சிரியாக்",
    'syr'    => 'சிரியாக்',
    'ta'     => 'தமிழ்',
    'tai'    => "தாய்\ மொழி",
    'te'     => 'தெலுங்கு',
    'tem'    => 'டிம்னே',
    'teo'    => 'Teso',
    'ter'    => 'டெரெனோ',
    'tet'    => 'டெடும்',
    'tg'     => 'தாஜிக்',
    'th'     => 'தாய்',
    'ti'     => 'டிக்ரின்யா',
    'tig'    => 'டைக்ரே',
    'tiv'    => 'டிவ்',
    'tk'     => 'டர்க்மென்',
    'tkl'    => 'டோகேலௌ',
    'tl'     => 'டாகாலோக்',
    'tlh'    => 'கிளிங்கன்',
    'tli'    => 'டிலிங்கிட்',
    'tmh'    => 'டாமாஷேக்',
    'tn'     => 'ஸ்வானா',
    'to'     => 'டோங்கா',
    'tog'    => "நயாசா\ டோங்கா",
    'tpi'    => "டோக்\ பிஸின்",
    'tr'     => 'டர்கிஷ்',
    'trv'    => 'Taroko',
    'ts'     => 'ஸோங்கா',
    'tsi'    => 'ட்ஸிம்ஷியன்',
    'tt'     => 'டாடர்',
    'tum'    => 'டும்புகா',
    'tup'    => "துபி\ மொழி",
    'tut'    => "அல்தேய்க்\ மொழி",
    'tvl'    => 'டுவாலு',
    'tw'     => 'ட்வி',
    'twq'    => 'Tasawaq',
    'ty'     => 'டஹிதியான்',
    'tyv'    => 'டுவினியன்',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'உட்முர்ட்',
    'ug'     => 'யூகுர்',
    'uga'    => 'உகாரிட்க்',
    'uk'     => 'உக்ரைனியன்',
    'umb'    => 'அம்பொண்டு',
    'und'    => "தெரியாத\ அல்லது\ செல்லாத\ பிரதேசம்",
    'ur'     => 'உருது',
    'uz'     => 'உஸ்பெக்',
    'vai'    => 'வை',
    've'     => 'வென்டா',
    'vi'     => 'வியட்நாமிஸ்',
    'vo'     => 'ஒலாபூக்',
    'vot'    => 'வோட்க்',
    'vun'    => 'Vunjo',
    'wa'     => 'ஒவாலூன்',
    'wae'    => 'Walser',
    'wak'    => "வகாஷான்\ மொழி",
    'wal'    => 'வாலாமோ',
    'war'    => 'வாரே',
    'was'    => 'வாஷோ',
    'wen'    => "சொர்பியன்\ மொழி",
    'wo'     => 'ஒலூஃப்',
    'xal'    => 'கல்மிக்',
    'xh'     => 'ஹோஷா',
    'xog'    => 'Soga',
    'yao'    => 'யாவ்',
    'yap'    => 'யாபேசி',
    'yav'    => 'Yangben',
    'yi'     => 'ஈத்திஷ',
    'yo'     => 'யோருப்பா',
    'ypk'    => "யுபிக்\ மொழி",
    'yue'    => 'காண்டோனீஸ்',
    'za'     => 'ஜுவாங்',
    'zap'    => 'ஜாபோடெக்',
    'zbl'    => 'ப்லிஸ்ஸிம்பால்ஸ்',
    'zen'    => 'ஜெனகா',
    'zh'     => 'சீனம்',
    'znd'    => 'ஜான்டே',
    'zu'     => 'ஜூலூ',
    'zun'    => 'ஜூனி',
    'zxx'    => "மொழிக்கிணங்க\ உள்ளடக்கம்\ இல்லை",
    'zza'    => 'ஜாஜா',
);

%Locales::DB::Language::ta::name_to_code = (
    'aghem'                                                                                                                                      => 'agq',
    'asu'                                                                                                                                        => 'asa',
    'bafia'                                                                                                                                      => 'ksf',
    'bena'                                                                                                                                       => 'bez',
    'bodo'                                                                                                                                       => 'brx',
    'cayuga'                                                                                                                                     => 'cay',
    'centralmoroccotamazight'                                                                                                                    => 'tzm',
    'chiga'                                                                                                                                      => 'cgg',
    'colognian'                                                                                                                                  => 'ksh',
    'congoswahili'                                                                                                                               => 'swc',
    'embu'                                                                                                                                       => 'ebu',
    'gusii'                                                                                                                                      => 'guz',
    'jolafonyi'                                                                                                                                  => 'dyo',
    'kabuverdianu'                                                                                                                               => 'kea',
    'kalenjin'                                                                                                                                   => 'kln',
    'koyraborosenni'                                                                                                                             => 'ses',
    'koyrachiini'                                                                                                                                => 'khq',
    'kwasio'                                                                                                                                     => 'nmg',
    'langi'                                                                                                                                      => 'lag',
    'luyia'                                                                                                                                      => 'luy',
    'machame'                                                                                                                                    => 'jmc',
    'makhuwameetto'                                                                                                                              => 'mgh',
    'makonde'                                                                                                                                    => 'kde',
    'meru'                                                                                                                                       => 'mer',
    'morisyen'                                                                                                                                   => 'mfe',
    'mundang'                                                                                                                                    => 'mua',
    'nama'                                                                                                                                       => 'naq',
    'nuer'                                                                                                                                       => 'nus',
    'rombo'                                                                                                                                      => 'rof',
    'rwa'                                                                                                                                        => 'rwk',
    'saho'                                                                                                                                       => 'ssy',
    'samburu'                                                                                                                                    => 'saq',
    'sangu'                                                                                                                                      => 'sbp',
    'sena'                                                                                                                                       => 'seh',
    'seneca'                                                                                                                                     => 'see',
    'shambala'                                                                                                                                   => 'ksb',
    'soga'                                                                                                                                       => 'xog',
    'tachelhit'                                                                                                                                  => 'shi',
    'taita'                                                                                                                                      => 'dav',
    'taroko'                                                                                                                                     => 'trv',
    'tasawaq'                                                                                                                                    => 'twq',
    'teso'                                                                                                                                       => 'teo',
    'vunjo'                                                                                                                                      => 'vun',
    'walser'                                                                                                                                     => 'wae',
    'yangben'                                                                                                                                    => 'yav',
    'zarma'                                                                                                                                      => 'dje',
    'ஃபங்க்'                                                                                                                         => 'fan',
    'ஃபரிஸ்த்'                                                                                                                   => 'fo',
    'ஃபான்'                                                                                                                            => 'fon',
    'ஃபான்டி'                                                                                                                      => 'fat',
    'ஃபிஜி'                                                                                                                            => 'fj',
    'ஃபினோஉக்ரைன்மொழி'                                                                                           => 'fiu',
    'ஃபிலிபினோ'                                                                                                                => 'fil',
    'ஃபுலா'                                                                                                                            => 'ff',
    'ஃபொனிஷியன்'                                                                                                             => 'phn',
    'ஃபோன்பெயென்'                                                                                                          => 'pon',
    'ஃப்ரியூலியன்'                                                                                                       => 'fur',
    'ஃப்ரென்ச்அடைப்படையிலானகிரியோல்மற்றும்பிஜின்'          => 'cpf',
    'அஃபார்'                                                                                                                         => 'aa',
    'அஃப்ரிஹிலி'                                                                                                             => 'afh',
    'அஃப்ரோஏசியாடிக்மொழி'                                                                                  => 'afa',
    'அகான்'                                                                                                                            => 'ak',
    'அகோலி'                                                                                                                            => 'ach',
    'அக்கேதியன்'                                                                                                             => 'akk',
    'அங்கிகா'                                                                                                                      => 'anp',
    'அதகே'                                                                                                                               => 'ady',
    'அதாங்மே'                                                                                                                      => 'ada',
    'அதாபஸ்கான்மொழி'                                                                                                 => 'ath',
    'அபாச்சிமொழி'                                                                                                          => 'apa',
    'அப்காஜியான்'                                                                                                          => 'ab',
    'அப்பர்சோர்பியான்'                                                                                           => 'hsb',
    'அம்பொண்டு'                                                                                                                => 'umb',
    'அம்ஹாரிக்'                                                                                                                => 'am',
    'அய்மரா'                                                                                                                         => 'ay',
    'அரபஹோ'                                                                                                                            => 'arp',
    'அரபு'                                                                                                                               => 'ar',
    'அராமைக்'                                                                                                                      => 'arc',
    'அராவாக்'                                                                                                                      => 'arw',
    'அரோமானியன்'                                                                                                             => 'rup',
    'அரௌகேனியன்'                                                                                                             => 'arn',
    'அலூட்'                                                                                                                            => 'ale',
    'அல்கான்கியன்மொழி'                                                                                           => 'alg',
    'அல்தேய்க்மொழி'                                                                                                    => 'tut',
    'அல்பெனியன்'                                                                                                             => 'sq',
    'அவதி'                                                                                                                               => 'awa',
    'அவெஸ்தான்'                                                                                                                => 'ae',
    'அவேரிக்'                                                                                                                      => 'av',
    'அஸேரி'                                                                                                                            => 'az',
    'அஸ்துரியன்'                                                                                                             => 'ast',
    'அஸ்ஸாமி'                                                                                                                      => 'as',
    'ஆஃப்ரிகான்ஸ்'                                                                                                       => 'af',
    'ஆகிடியன்'                                                                                                                   => 'oc',
    'ஆங்கிலஅடைப்படையிலானகிரியோல்மற்றும்பிஜின்'                   => 'cpe',
    'ஆங்கிலம்'                                                                                                                   => 'en',
    'ஆங்கிலம்யூஎஸ்'                                                                                                    => 'en_us',
    'ஆங்கிலம்யூகே'                                                                                                       => 'en_gb',
    'ஆச்சினீஸ்'                                                                                                                => 'ace',
    'ஆட்சம்'                                                                                                                         => 'cch',
    'ஆர்கோனீஸ்'                                                                                                                => 'an',
    'ஆர்மேனியன்'                                                                                                             => 'hy',
    'ஆஸ்ட்ரியன்ஜெர்மன்'                                                                                        => 'de_at',
    'ஆஸ்ட்ரேலியன்ஆங்கிலம்'                                                                               => 'en_au',
    'ஆஸ்ட்ரோனேஷியன்'                                                                                                 => 'map',
    'ஆஸ்த்ரேலியமொழி'                                                                                                 => 'aus',
    'இக்போ'                                                                                                                            => 'ig',
    'இங்குஷ்'                                                                                                                      => 'inh',
    'இஜோ'                                                                                                                                  => 'ijo',
    'இடோ'                                                                                                                                  => 'io',
    'இத்தாலியன்'                                                                                                             => 'it',
    'இந்தி'                                                                                                                            => 'hi',
    'இந்தியமொழி'                                                                                                             => 'inc',
    'இந்தோனேஷியன்'                                                                                                       => 'id',
    'இனாரிசாமி'                                                                                                                => 'smn',
    'இனுகிடூட்'                                                                                                                => 'iu',
    'இனுபியாக்'                                                                                                                => 'ik',
    'இன்டர்லிங்'                                                                                                             => 'ie',
    'இன்டர்லிங்குவா'                                                                                                 => 'ia',
    'இன்டோஐரோப்பியன்மொழி'                                                                                  => 'ine',
    'இபான்'                                                                                                                            => 'iba',
    'இரானியன்மொழி'                                                                                                       => 'ira',
    'இரோகோயியன்மொழி'                                                                                                 => 'iro',
    'இலோகோ'                                                                                                                            => 'ilo',
    'ஈஓயே'                                                                                                                               => 'ee',
    'ஈகாஜுக்'                                                                                                                      => 'eka',
    'ஈத்திஷ'                                                                                                                         => 'yi',
    'உகாரிட்க்'                                                                                                                => 'uga',
    'உக்ரைனியன்'                                                                                                             => 'uk',
    'உட்முர்ட்'                                                                                                                => 'udm',
    'உருது'                                                                                                                            => 'ur',
    'உஸ்பெக்'                                                                                                                      => 'uz',
    'எஃபிக்'                                                                                                                         => 'efi',
    'என்கோ'                                                                                                                            => 'nqo',
    'எலமைட்'                                                                                                                         => 'elx',
    'எவோன்டோ'                                                                                                                      => 'ewo',
    'எஸ்டோனியன்'                                                                                                             => 'et',
    'எஸ்பரேன்டோ'                                                                                                             => 'eo',
    'ஏர்ஜியா'                                                                                                                      => 'myv',
    'ஐனு'                                                                                                                                  => 'ain',
    'ஐபெரியன்ஸ்பானிஷ்'                                                                                           => 'es_es',
    'ஐரிஷ்'                                                                                                                            => 'ga',
    'ஐஸ்லென்டிக்'                                                                                                          => 'is',
    'ஒசெட்டிக்'                                                                                                                => 'os',
    'ஒட்டோமன்துர்க்கி'                                                                                           => 'ota',
    'ஒட்டோமன்மொழி'                                                                                                       => 'oto',
    'ஒரியா'                                                                                                                            => 'or',
    'ஒரோமோ'                                                                                                                            => 'om',
    'ஒலாபூக்'                                                                                                                      => 'vo',
    'ஒலூஃப்'                                                                                                                         => 'wo',
    'ஒவாலூன்'                                                                                                                      => 'wa',
    'ஓசேஜ்'                                                                                                                            => 'osa',
    'ஓஜிபவா'                                                                                                                         => 'oj',
    'கசாக்'                                                                                                                            => 'kk',
    'கனடியன்ஆங்கிலம்'                                                                                              => 'en_ca',
    'கனுரி'                                                                                                                            => 'kr',
    'கன்னடம்'                                                                                                                      => 'kn',
    'கபாய்ல்'                                                                                                                      => 'kab',
    'கபார்டியன்'                                                                                                             => 'kbd',
    'கம்பா'                                                                                                                            => 'kam',
    'கயோ'                                                                                                                                  => 'gay',
    'கராசேபல்கார்'                                                                                                       => 'krc',
    'கரீப்'                                                                                                                            => 'car',
    'கரேன்'                                                                                                                            => 'kar',
    'கரேலியன்'                                                                                                                   => 'krl',
    'கலாலிசூட்'                                                                                                                => 'kl',
    'கல்மிக்'                                                                                                                      => 'xal',
    'கஷுபியன்'                                                                                                                   => 'csb',
    'கா'                                                                                                                                     => 'gaa',
    'காகேஷியன்மொழி'                                                                                                    => 'cau',
    'காங்கோ'                                                                                                                         => 'kg',
    'காசின்'                                                                                                                         => 'kac',
    'காடலான்'                                                                                                                      => 'ca',
    'காண்டோனீஸ்'                                                                                                             => 'yue',
    'கான்டா'                                                                                                                         => 'lg',
    'காப்டிக்'                                                                                                                   => 'cop',
    'காராகல்பாக்'                                                                                                          => 'kaa',
    'கார்சியன்'                                                                                                                => 'co',
    'கார்னிஷ்'                                                                                                                   => 'kw',
    'காலிஸியன்'                                                                                                                => 'gl',
    'காவி'                                                                                                                               => 'kaw',
    'காஷ்மிரி'                                                                                                                   => 'ks',
    'காஸி'                                                                                                                               => 'kha',
    'கிகுயூ'                                                                                                                         => 'ki',
    'கின்யாருவான்டா'                                                                                                 => 'rw',
    'கிம்புன்து'                                                                                                             => 'kmb',
    'கிரிமியன்துர்க்கி'                                                                                        => 'crh',
    'கிரியோல்மற்றும்பிஜின்'                                                                            => 'crp',
    'கிரேக்கம்'                                                                                                                => 'el',
    'கிர்கிஷ்'                                                                                                                   => 'ky',
    'கில்பெர்டீஸ்'                                                                                                       => 'gil',
    'கிளிங்கன்'                                                                                                                => 'tlh',
    'கிழக்குஃப்ரிஸியான்'                                                                                     => 'frs',
    'கிவேசுவா'                                                                                                                   => 'qu',
    'கீஜ்'                                                                                                                               => 'gez',
    'குஜராத்தி'                                                                                                                => 'gu',
    'குடேனை'                                                                                                                         => 'kut',
    'கும்இக்'                                                                                                                      => 'kum',
    'குரானி'                                                                                                                         => 'gn',
    'குருக்'                                                                                                                         => 'kru',
    'குரோஷியன்'                                                                                                                => 'hr',
    'குர்திஷ்'                                                                                                                   => 'ku',
    'குவான்யாமா'                                                                                                             => 'kj',
    'குவிசின்'                                                                                                                   => 'gwi',
    'குஷிடிக்மொழி'                                                                                                       => 'cus',
    'கெனடியன்பிரன்சு'                                                                                              => 'fr_ca',
    'கெமெர்'                                                                                                                         => 'km',
    'கெல்டிக்மொழி'                                                                                                       => 'cel',
    'கேடோ'                                                                                                                               => 'cad',
    'கொங்கனி'                                                                                                                      => 'kok',
    'கொமோரியன்'                                                                                                                => 'swb',
    'கொய்ஸன்மொழி'                                                                                                          => 'khi',
    'கொரியன்'                                                                                                                      => 'ko',
    'கோதானீஸ்'                                                                                                                   => 'kho',
    'கோதிக்'                                                                                                                         => 'got',
    'கோன்டி'                                                                                                                         => 'gon',
    'கோமி'                                                                                                                               => 'kv',
    'கோரோ'                                                                                                                               => 'kfo',
    'கோரோன்டலோ'                                                                                                                => 'gor',
    'கோஸ்ரைன்'                                                                                                                   => 'kos',
    'க்பெல்லே'                                                                                                                   => 'kpe',
    'க்ரீ'                                                                                                                               => 'cr',
    'க்ரீக்'                                                                                                                         => 'mus',
    'க்ரு'                                                                                                                               => 'kro',
    'க்ரேபோ'                                                                                                                         => 'grb',
    'சங்கேதமொழி'                                                                                                             => 'sgn',
    'சமஸ்கிருதம்'                                                                                                          => 'sa',
    'சமாரிடன்அராமைக்'                                                                                              => 'sam',
    'சர்ச்ஸ்லாவிக்'                                                                                                    => 'cu',
    'சாங்கோ'                                                                                                                         => 'sg',
    'சாசாக்'                                                                                                                         => 'sas',
    'சாடினியன்'                                                                                                                => 'sc',
    'சான்டாலி'                                                                                                                   => 'sat',
    'சான்டாவே'                                                                                                                   => 'sad',
    'சாமிக்மொழி'                                                                                                             => 'cmc',
    'சாமிமொழி'                                                                                                                   => 'smi',
    'சாமோரோ'                                                                                                                         => 'ch',
    'சாலிஷன்மொழி'                                                                                                          => 'sal',
    'சிக்சிகா'                                                                                                                   => 'bla',
    'சிங்களம்'                                                                                                                   => 'si',
    'சிசிலியன்'                                                                                                                => 'scn',
    'சிசுவான்ஈ'                                                                                                                => 'ii',
    'சிடாமோ'                                                                                                                         => 'sid',
    'சிந்தி'                                                                                                                         => 'sd',
    'சினூக்ஜார்கான்'                                                                                                 => 'chn',
    'சினோதிபேத்தியன்மொழி'                                                                                  => 'sit',
    'சிபெவ்யான்'                                                                                                             => 'chp',
    'சிப்சா'                                                                                                                         => 'chb',
    'சியோயுவான்மொழி'                                                                                                 => 'sio',
    'சிரியாக்'                                                                                                                   => 'syr',
    'சீனம்'                                                                                                                            => 'zh',
    'சுகுமா'                                                                                                                         => 'suk',
    'சுசு'                                                                                                                               => 'sus',
    'சுடானீஸ்'                                                                                                                   => 'su',
    'சுமேரியன்'                                                                                                                => 'sux',
    'சுவாஷ்'                                                                                                                         => 'cv',
    'சுவாஹிலி'                                                                                                                   => 'sw',
    'சூகிசே'                                                                                                                         => 'chk',
    'செக்'                                                                                                                               => 'cs',
    'செசென்'                                                                                                                         => 'ce',
    'செபுவானோ'                                                                                                                   => 'ceb',
    'செமிடிக்மொழி'                                                                                                       => 'sem',
    'செயற்கையானமொழி'                                                                                                 => 'art',
    'செயேனி'                                                                                                                         => 'chy',
    'செரூக்கி'                                                                                                                   => 'chr',
    'செரெர்'                                                                                                                         => 'srr',
    'செர்பியன்'                                                                                                                => 'sr',
    'செர்போக்ரோஷியன்'                                                                                              => 'sh',
    'செல்குப்'                                                                                                                   => 'sel',
    'சொர்பியன்மொழி'                                                                                                    => 'wen',
    'சோக்தியன்'                                                                                                                => 'sog',
    'சோக்தௌ'                                                                                                                         => 'cho',
    'சோங்காய்'                                                                                                                   => 'son',
    'சோனின்கே'                                                                                                                   => 'snk',
    'சோமாலி'                                                                                                                         => 'so',
    'ஜப்பானீஸ்'                                                                                                                => 'ja',
    'ஜாஜா'                                                                                                                               => 'zza',
    'ஜான்டே'                                                                                                                         => 'znd',
    'ஜாபோடெக்'                                                                                                                   => 'zap',
    'ஜாவானீஸ்'                                                                                                                   => 'jv',
    'ஜியோர்ஜியன்'                                                                                                          => 'ka',
    'ஜுவாங்'                                                                                                                         => 'za',
    'ஜூதேயோஅராபிக்'                                                                                                    => 'jrb',
    'ஜூதேயோபெர்ஷியன்'                                                                                              => 'jpr',
    'ஜூனி'                                                                                                                               => 'zun',
    'ஜூலூ'                                                                                                                               => 'zu',
    'ஜெனகா'                                                                                                                            => 'zen',
    'ஜெர்மன்'                                                                                                                      => 'de',
    'ஜெர்மானியமொழி'                                                                                                    => 'gem',
    'ஜ்ஜூ'                                                                                                                               => 'kaj',
    'டச்சு'                                                                                                                            => 'nl',
    'டர்கிஷ்'                                                                                                                      => 'tr',
    'டர்க்மென்'                                                                                                                => 'tk',
    'டஹிதியான்'                                                                                                                => 'ty',
    'டாகாலோக்'                                                                                                                   => 'tl',
    'டாடர்'                                                                                                                            => 'tt',
    'டாமாஷேக்'                                                                                                                   => 'tmh',
    'டிக்ரின்யா'                                                                                                             => 'ti',
    'டின்கா'                                                                                                                         => 'din',
    'டிம்னே'                                                                                                                         => 'tem',
    'டிலிங்கிட்'                                                                                                             => 'tli',
    'டிவ்'                                                                                                                               => 'tiv',
    'டும்புகா'                                                                                                                   => 'tum',
    'டுவாலு'                                                                                                                         => 'tvl',
    'டுவினியன்'                                                                                                                => 'tyv',
    'டெடும்'                                                                                                                         => 'tet',
    'டெரெனோ'                                                                                                                         => 'ter',
    'டேனிஷ்'                                                                                                                         => 'da',
    'டைக்ரே'                                                                                                                         => 'tig',
    'டோகேலௌ'                                                                                                                         => 'tkl',
    'டோக்பிஸின்'                                                                                                             => 'tpi',
    'டோக்ரி'                                                                                                                         => 'doi',
    'டோக்ரிப்'                                                                                                                   => 'dgr',
    'டோங்கா'                                                                                                                         => 'to',
    'ட்யூலா'                                                                                                                         => 'dyu',
    'ட்வி'                                                                                                                               => 'tw',
    'ட்ஸிம்ஷியன்'                                                                                                          => 'tsi',
    'தகோடா'                                                                                                                            => 'dak',
    'தமிழ்'                                                                                                                            => 'ta',
    'தயாக்'                                                                                                                            => 'day',
    'தாஜிக்'                                                                                                                         => 'tg',
    'தாய்'                                                                                                                               => 'th',
    'தாய்மொழி'                                                                                                                   => 'tai',
    'தார்குவா'                                                                                                                   => 'dar',
    'திபெத்து'                                                                                                                   => 'bo',
    'திராவிடமொழி'                                                                                                          => 'dra',
    'திவேஹி'                                                                                                                         => 'dv',
    'துபிமொழி'                                                                                                                   => 'tup',
    'துவாலா'                                                                                                                         => 'dua',
    'தென்அமெரிக்கஇன்டியன்மொழி'                                                                   => 'sai',
    'தெரியாதஅல்லதுசெல்லாதபிரதேசம்'                                                       => 'und',
    'தெற்குஅல்தை'                                                                                                          => 'alt',
    'தெற்குசாமி'                                                                                                             => 'sma',
    'தெற்குதெபெலே'                                                                                                       => 'nr',
    'தெற்குஸோதோ'                                                                                                             => 'st',
    'தெலாவேர்'                                                                                                                   => 'del',
    'தெலுங்கு'                                                                                                                   => 'te',
    'தையாப்'                                                                                                                         => 'kcg',
    'தோங்கா'                                                                                                                         => 'ng',
    'நயன்ஜா'                                                                                                                         => 'ny',
    'நயாசாடோங்கா'                                                                                                          => 'tog',
    'நவாஜோ'                                                                                                                            => 'nv',
    'நவ்ரூ'                                                                                                                            => 'na',
    'நஹுவால்'                                                                                                                      => 'nah',
    'நார்வே'                                                                                                                         => 'no',
    'நார்வேஜியன்நியூநார்ஸ்க்'                                                                      => 'nn',
    'நார்வேபொக்மால்'                                                                                                 => 'nb',
    'நிஜ்மா'                                                                                                                         => 'nzi',
    'நியான்கோலே'                                                                                                             => 'nyn',
    'நியாம்வேஜி'                                                                                                             => 'nym',
    'நியாஸ்'                                                                                                                         => 'nia',
    'நியூபியன்மொழி'                                                                                                    => 'nub',
    'நியூவான்'                                                                                                                   => 'niu',
    'நியோபோலிடன்'                                                                                                          => 'nap',
    'நியோரோ'                                                                                                                         => 'nyo',
    'நிலோசஹாரன்மொழி'                                                                                                 => 'ssa',
    'நெவாரி'                                                                                                                         => 'new',
    'நேபாளி'                                                                                                                         => 'ne',
    'நைஜர்கோரடோஃபனியன்மொழி'                                                                            => 'nic',
    'நோகை'                                                                                                                               => 'nog',
    'பஞ்சாபி'                                                                                                                      => 'pa',
    'பண்டையஎகிப்தியன்'                                                                                           => 'egy',
    'பண்டையகிரேக்கம்'                                                                                              => 'grc',
    'பன்காசினன்'                                                                                                             => 'pag',
    'பபியேமென்டோ'                                                                                                          => 'pap',
    'பபுவான்மொழி'                                                                                                          => 'paa',
    'பமிலெகேமொழி'                                                                                                          => 'bai',
    'பம்பாங்கா'                                                                                                                => 'pam',
    'பம்பாரா'                                                                                                                      => 'bm',
    'பயா'                                                                                                                                  => 'gba',
    'பராக்ரித்மொழி'                                                                                                    => 'pra',
    'பர்மிஸ்'                                                                                                                      => 'my',
    'பர்ஸியன்'                                                                                                                   => 'fa',
    'பலதரப்பட்டமொழிகள்'                                                                                        => 'mis',
    'பலமொழிகள்'                                                                                                                => 'mul',
    'பலினீஸ்'                                                                                                                      => 'ban',
    'பலௌவ்ன்'                                                                                                                      => 'pau',
    'பல்கேரியன்'                                                                                                             => 'bg',
    'பழையஃப்ரென்ச்'                                                                                                    => 'fro',
    'பழையஆங்கிலம்'                                                                                                       => 'ang',
    'பழையஐரிஷ்'                                                                                                                => 'sga',
    'பழையநோர்ஸ்'                                                                                                             => 'non',
    'பழையபெர்ஷியன்'                                                                                                    => 'peo',
    'பழையப்ரோவென்சால்'                                                                                           => 'pro',
    'பழையஹைஜெர்மன்'                                                                                                    => 'goh',
    'பஸ்க்'                                                                                                                            => 'eu',
    'பாடாக்'                                                                                                                         => 'btk',
    'பாண்டா'                                                                                                                         => 'bad',
    'பான்டு'                                                                                                                         => 'bnt',
    'பாரம்பரியசிரியாக்'                                                                                        => 'syc',
    'பாரம்பரியநேவாரி'                                                                                              => 'nwc',
    'பாலி'                                                                                                                               => 'pi',
    'பால்டிக்மொழி'                                                                                                       => 'bat',
    'பாஷ்கிர்'                                                                                                                   => 'ba',
    'பாஸா'                                                                                                                               => 'bas',
    'பாஹ்லவி'                                                                                                                      => 'pal',
    'பிகோல்'                                                                                                                         => 'bik',
    'பினி'                                                                                                                               => 'bin',
    'பின்னிஷ்'                                                                                                                   => 'fi',
    'பிரிடன்'                                                                                                                      => 'br',
    'பிரெஞ்சு'                                                                                                                   => 'fr',
    'பிலிபைன்மொழி'                                                                                                       => 'phi',
    'பிலெமிஷ்'                                                                                                                   => 'nl_be',
    'பிஸ்லாமா'                                                                                                                   => 'bi',
    'பிஹாரி'                                                                                                                         => 'bh',
    'புகினீஸ்'                                                                                                                   => 'bug',
    'புரியாத்'                                                                                                                   => 'bua',
    'புஷ்டோ'                                                                                                                         => 'ps',
    'பூடானி'                                                                                                                         => 'dz',
    'பெம்பா'                                                                                                                         => 'bem',
    'பெர்பெர்'                                                                                                                   => 'ber',
    'பெலுசி'                                                                                                                         => 'bal',
    'பேஜா'                                                                                                                               => 'bej',
    'பைலோருஷ்ன்'                                                                                                             => 'be',
    'போஜ்பூரி'                                                                                                                   => 'bho',
    'போர்சுக்கீஸ்அடைப்படையிலானகிரியோல்மற்றும்பிஜின்' => 'cpp',
    'போர்ச்சுகீஸ்பிரேசில்'                                                                               => 'pt_br',
    'போர்ச்சுகீஸ்போர்ச்சுகல்'                                                                      => 'pt_pt',
    'போர்ச்சுக்கீஸ்'                                                                                                 => 'pt',
    'போலிஷ்'                                                                                                                         => 'pl',
    'போஸ்னியன்'                                                                                                                => 'bs',
    'ப்ராஜ்'                                                                                                                         => 'bra',
    'ப்லின்'                                                                                                                         => 'byn',
    'ப்லிஸ்ஸிம்பால்ஸ்'                                                                                           => 'zbl',
    'மகாசார்'                                                                                                                      => 'mak',
    'மகாஹி'                                                                                                                            => 'mag',
    'மங்கோலியன்'                                                                                                             => 'mn',
    'மதுரீஸ்'                                                                                                                      => 'mad',
    'மத்தியஃப்ரென்ச்'                                                                                              => 'frm',
    'மத்தியஅமெரிக்கன்இன்டியன்மொழி'                                                       => 'cai',
    'மத்தியஆங்கிலம்'                                                                                                 => 'enm',
    'மத்தியஐரிஷ்'                                                                                                          => 'mga',
    'மத்தியடச்சு'                                                                                                          => 'dum',
    'மத்தியஹைஜெர்மன்'                                                                                              => 'gmh',
    'மனிபூரி'                                                                                                                      => 'mni',
    'மனோபோமொழி'                                                                                                                => 'mno',
    'மன்சு'                                                                                                                            => 'mnc',
    'மராத்தி'                                                                                                                      => 'mr',
    'மலகாஸி'                                                                                                                         => 'mg',
    'மலாய்'                                                                                                                            => 'ms',
    'மலையாளம்'                                                                                                                   => 'ml',
    'மாங்க்'                                                                                                                         => 'hmn',
    'மாசாய்'                                                                                                                         => 'mas',
    'மான்க்மெர்மொழி'                                                                                                 => 'mkh',
    'மான்டார்'                                                                                                                   => 'mdr',
    'மான்டிங்கோ'                                                                                                             => 'man',
    'மாயான்மொழி'                                                                                                             => 'myn',
    'மாரி'                                                                                                                               => 'chm',
    'மார்வாரி'                                                                                                                   => 'mwr',
    'மார்ஷெலிஷ்'                                                                                                             => 'mh',
    'மால்டிஸ்'                                                                                                                   => 'mt',
    'மாஸிடோனியன்'                                                                                                          => 'mk',
    'மிக்மாக்'                                                                                                                   => 'mic',
    'மின்னாங்கபௌ'                                                                                                          => 'min',
    'மிரான்டீஸ்'                                                                                                             => 'mwl',
    'முண்டாமொழி'                                                                                                             => 'mun',
    'மென்டீ'                                                                                                                         => 'men',
    'மேங்க்ஸ்'                                                                                                                   => 'gv',
    'மேற்கத்தியபிரிஷிய'                                                                                        => 'fy',
    'மைதிலி'                                                                                                                         => 'mai',
    'மொழிக்கிணங்கஉள்ளடக்கம்இல்லை'                                                          => 'zxx',
    'மோக்க்ஷா'                                                                                                                   => 'mdf',
    'மோங்கோ'                                                                                                                         => 'lol',
    'மோல்டாவியன்'                                                                                                          => 'mo',
    'மோஸ்ஸி'                                                                                                                         => 'mos',
    'மோஹாவ்க்'                                                                                                                   => 'moh',
    'மௌரி'                                                                                                                               => 'mi',
    'யாகுட்'                                                                                                                         => 'sah',
    'யாபேசி'                                                                                                                         => 'yap',
    'யாவ்'                                                                                                                               => 'yao',
    'யுபிக்மொழி'                                                                                                             => 'ypk',
    'யூகுர்'                                                                                                                         => 'ug',
    'யோருப்பா'                                                                                                                   => 'yo',
    'ரபனுய்'                                                                                                                         => 'rap',
    'ரரோடோங்கன்'                                                                                                             => 'rar',
    'ரஷியன்'                                                                                                                         => 'ru',
    'ராஜஸ்தானி'                                                                                                                => 'raj',
    'ருண்டி'                                                                                                                         => 'rn',
    'ரைட்டோரோமென்ஸ்'                                                                                                 => 'rm',
    'ரோமன்ஸ்மொழி'                                                                                                          => 'roa',
    'ரோமானி'                                                                                                                         => 'rom',
    'ரோமேனியன்'                                                                                                                => 'ro',
    'லக்க்ஷெம்பர்கிஷ்'                                                                                           => 'lb',
    'லடினோ'                                                                                                                            => 'lad',
    'லத்தின்'                                                                                                                      => 'la',
    'லத்தின்அமெரிக்கன்ஸ்பானிஷ்'                                                                => 'es_419',
    'லம்பா'                                                                                                                            => 'lam',
    'லஹன்டா'                                                                                                                         => 'lah',
    'லிங்காலா'                                                                                                                   => 'ln',
    'லிதுவேனியன்'                                                                                                          => 'lt',
    'லிம்பர்கிஷ்'                                                                                                          => 'li',
    'லுபாகடாங்கா'                                                                                                          => 'lu',
    'லுபாலுலௌ'                                                                                                                   => 'lua',
    'லுயோ'                                                                                                                               => 'luo',
    'லுய்சேனோ'                                                                                                                   => 'lui',
    'லுலேசாமி'                                                                                                                   => 'smj',
    'லுஷய்'                                                                                                                            => 'lus',
    'லூன்டா'                                                                                                                         => 'lun',
    'லெஜ்ஜியன்'                                                                                                                => 'lez',
    'லேட்வியன்'                                                                                                                => 'lv',
    'லோஜி'                                                                                                                               => 'loz',
    'லோஜெர்மன்'                                                                                                                => 'nds',
    'லோஜ்பன்'                                                                                                                      => 'jbo',
    'லோத்தியன்'                                                                                                                => 'lo',
    'லோவர்சோர்பியன்'                                                                                                 => 'dsb',
    'வகாஷான்மொழி'                                                                                                          => 'wak',
    'வங்காளம்'                                                                                                                   => 'bn',
    'வடக்குஃப்ரிஸியான்'                                                                                        => 'frr',
    'வடக்குஅமெரிக்கன்இன்டியன்மொழி'                                                       => 'nai',
    'வடக்குசாமி'                                                                                                             => 'se',
    'வடக்குசோதோ'                                                                                                             => 'nso',
    'வடக்குதெபெலே'                                                                                                       => 'nd',
    'வாரே'                                                                                                                               => 'war',
    'வாலாமோ'                                                                                                                         => 'wal',
    'வாஷோ'                                                                                                                               => 'was',
    'வியட்நாமிஸ்'                                                                                                          => 'vi',
    'வென்டா'                                                                                                                         => 've',
    'வெல்ஷ்'                                                                                                                         => 'cy',
    'வை'                                                                                                                                     => 'vai',
    'வோட்க்'                                                                                                                         => 'vot',
    'ஷகதை'                                                                                                                               => 'chg',
    'ஷான்'                                                                                                                               => 'shn',
    'ஷோனா'                                                                                                                               => 'sn',
    'ஸாமோவான்'                                                                                                                   => 'sm',
    'ஸோங்கா'                                                                                                                         => 'ts',
    'ஸ்காட்ஸ்'                                                                                                                   => 'sco',
    'ஸ்காட்ஸ்கேலிக்'                                                                                                 => 'gd',
    'ஸ்கோல்ட்சாமி'                                                                                                       => 'sms',
    'ஸ்பானிஷ்'                                                                                                                   => 'es',
    'ஸ்ரானன்டோங்கோ'                                                                                                    => 'srn',
    'ஸ்லாவிக்மொழி'                                                                                                       => 'sla',
    'ஸ்லாவ்'                                                                                                                         => 'den',
    'ஸ்லோவாக்'                                                                                                                   => 'sk',
    'ஸ்லோவேனியன்'                                                                                                          => 'sl',
    'ஸ்வாடீ'                                                                                                                         => 'ss',
    'ஸ்வானா'                                                                                                                         => 'tn',
    'ஸ்விஸ்ஜெர்மன்'                                                                                                    => 'gsw',
    'ஸ்விஸ்பிரன்சு'                                                                                                    => 'fr_ch',
    'ஸ்விஸ்ஹைஜெர்மன்'                                                                                              => 'de_ch',
    'ஸ்வீடிஷ்'                                                                                                                   => 'sv',
    'ஹங்கேரியன்'                                                                                                             => 'hu',
    'ஹவாய்யான்'                                                                                                                => 'haw',
    'ஹிட்டைட்'                                                                                                                   => 'hit',
    'ஹிமாச்சலி'                                                                                                                => 'him',
    'ஹிரிமோட்டு'                                                                                                             => 'ho',
    'ஹிலிகாய்னான்'                                                                                                       => 'hil',
    'ஹுபா'                                                                                                                               => 'hup',
    'ஹுப்ரு'                                                                                                                         => 'he',
    'ஹெரேரோ'                                                                                                                         => 'hz',
    'ஹைடா'                                                                                                                               => 'hai',
    'ஹைத்தியன்'                                                                                                                => 'ht',
    'ஹோஷா'                                                                                                                               => 'xh',
    'ஹௌஸா'                                                                                                                               => 'ha',
);

1;
