/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// Std lib includes


/////////////////////// Qt includes
#include <QDebug>
#include <QCborStreamReader>
#include <QCborStreamWriter>


/////////////////////// PAPPSO includes
#include <pappsomspp/core/trace/datapoint.h>
#include <pappsomspp/core/trace/trace.h>


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

#include "MsXpS/libXpertMassCore/globals.hpp"

namespace MsXpS
{

namespace libXpertMassCore
{

typedef std::shared_ptr<QCborStreamReader> QCborStreamReaderSPtr;
typedef std::shared_ptr<QCborStreamWriter> QCborStreamWriterSPtr;

class DECLSPEC MassDataCborBaseHandler: public QObject
{
  Q_OBJECT

  public:
  MassDataCborBaseHandler(QObject *parent_p);
  ~MassDataCborBaseHandler();

  void setInputFileName(const QString &file_name);
  void setOutputFileName(const QString &file_name);


  static Enums::MassDataType readMassDataType(const QString &input_file_name);
  static Enums::MassDataType readMassDataType(const QByteArray &byte_array);
  static Enums::MassDataType readMassDataType(QCborStreamReaderSPtr &reader_sp);

  void setMassDataType(Enums::MassDataType mass_data_type);
  Enums::MassDataType getMassDataType() const;

  virtual bool readFile(const QString &input_file_name = QString());
  virtual bool readByteArray(const QByteArray &byte_array);
  virtual bool writeFile(const QString &output_file_name = QString());
  virtual void writeByteArray(QByteArray &byte_array);

  void setTitle(const QString &title);
  QString getTitle() const;

  protected:
  Enums::MassDataType m_massDataType = Enums::MassDataType::NOT_SET;
  QString m_title                    = QString();
  QString m_currentKey;

  QCborStreamReaderSPtr msp_reader = nullptr;
  QCborStreamWriterSPtr msp_writer = nullptr;

  QString m_inputFileName  = QString();
  QString m_outputFileName = QString();

  virtual bool decodeStream(QCborStreamReaderSPtr &reader_sp);
};


} // namespace libXpertMassCore

} // namespace MsXpS
