.TH "ZIP_SET_DEFAULT_PASSWORD" "3" "January 3, 2011" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_set_default_password\fP
\- set default password for encrypted files in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
int
zip_set_default_password zip_t *archive const char *password
.SH "DESCRIPTION"
The
zip_set_default_password
function sets the default password used when accessing encrypted files.
If
\fIpassword\fP
is
\fRNULL\fP,
the default password is unset.
.PP
If you prefer a different password for single files, use
zip_fopen_encrypted(3)
instead of
zip_fopen(3).
Usually, however, the same password is used for every file in an
zip archive.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fIarchive\fP
is set to indicate the error.
.SH "ERRORS"
zip_set_default_password
fails if:
.TP 17n
[\fRZIP_ER_MEMORY\fP]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_fopen(3),
zip_fopen_encrypted(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
