/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#ifndef OIF_QML_OIFROTATEAREA_H_
#define OIF_QML_OIFROTATEAREA_H_

#include "continuousgesturearea.h"

/**
 * An input-only item for receiving non-instantaneous rotate gesture events.
 */

class OIFRotateArea : public ContinuousGestureArea {
  Q_OBJECT
  /**
   * This property holds the rotation angle of the touches.
   */
  Q_PROPERTY(GestureProperty* angle READ angle CONSTANT)

 public:
  explicit OIFRotateArea(QDeclarativeItem* parent = 0);

  GestureProperty* angle() { return &angle_; }

  virtual bool IsGestureEventHandled(GestureEvent* event);
  virtual void HandleGestureUpdateEvent(bool end, GestureEvent* event);

 private:
  GestureProperty angle_;

  Q_DISABLE_COPY(OIFRotateArea)
};

QML_DECLARE_TYPE(OIFRotateArea)

#endif  // OIF_QML_OIFROTATEAREA_H_
