/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_SoftwareInstallationCapabilities.h"

CMPIObjectPath* SoftwareUpdate_OpenDRIM_SoftwareInstallationCapabilities_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_SoftwareInstallationCapabilities& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_SoftwareInstallationCapabilities_classnames[0], OpenDRIM_SoftwareInstallationCapabilities_NAMESPACE);

	if (!instance.ManagedElement_isNULL)
		op.addKey("ManagedElement", instance.ManagedElement);

	if (!instance.Capabilities_isNULL)
		op.addKey("Capabilities", instance.Capabilities);

	_L_;
	return op.getHdl();
}

CMPIInstance* SoftwareUpdate_OpenDRIM_SoftwareInstallationCapabilities_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_SoftwareInstallationCapabilities& instance) {
	_E_;
	Objectpath op(broker, SoftwareUpdate_OpenDRIM_SoftwareInstallationCapabilities_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Characteristics_isNULL)
		ci.setProperty("Characteristics", instance.Characteristics);

	_L_;
	return ci.getHdl();
}

void SoftwareUpdate_OpenDRIM_SoftwareInstallationCapabilities_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_SoftwareInstallationCapabilities& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Capabilities", instance.Capabilities) == OK)
		instance.Capabilities_isNULL = false;

	if (op.getKey("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	_L_;
}

void SoftwareUpdate_OpenDRIM_SoftwareInstallationCapabilities_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_SoftwareInstallationCapabilities& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	if (inst.getProperty("Capabilities", instance.Capabilities) == OK)
		instance.Capabilities_isNULL = false;

	if (inst.getProperty("Characteristics", instance.Characteristics) == OK)
		instance.Characteristics_isNULL = false;

	_L_;
}

