# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1681-1 (linux-2.6.24)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(62843);
 script_cve_id("CVE-2008-3528", "CVE-2008-4554", "CVE-2008-4576", "CVE-2008-4618", "CVE-2008-4933", "CVE-2008-4934", "CVE-2008-5025", "CVE-2008-5029", "CVE-2008-5134", "CVE-2008-5182", "CVE-2008-5300");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1681-1 (linux-2.6.24)";
 script_name(name);

 desc = "The remote host is missing an update to linux-2.6.24
announced via advisory DSA 1681-1.

Several vulnerabilities have been discovered in the Linux kernel that
may lead to a denial of service or privilege escalation. The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-2008-3528

Eugene Teo reported a local DoS issue in the ext2 and ext3
filesystems.  Local users who have been granted the privileges
necessary to mount a filesystem would be able to craft a corrupted
filesystem that causes the kernel to output error messages in an
infinite loop.

CVE-2008-4554

Milos Szeredi reported that the usage of splice() on files opened
with O_APPEND allows users to write to the file at arbitrary
offsets, enabling a bypass of possible assumed semantics of the
O_APPEND flag.

CVE-2008-4576

Vlad Yasevich reported an issue in the SCTP subsystem that may
allow remote users to cause a local DoS by triggering a kernel
oops.

CVE-2008-4618

Wei Yongjun reported an issue in the SCTP subsystem that may allow
remote users to cause a local DoS by triggering a kernel panic.

CVE-2008-4933

Eric Sesterhenn reported a local DoS issue in the hfsplus
filesystem.  Local users who have been granted the privileges
necessary to mount a filesystem would be able to craft a corrupted
filesystem that causes the kernel to overrun a buffer, resulting
in a system oops or memory corruption.

CVE-2008-4934

Eric Sesterhenn reported a local DoS issue in the hfsplus
filesystem.  Local users who have been granted the privileges
necessary to mount a filesystem would be able to craft a corrupted
filesystem that results in a kernel oops due to an unchecked
return value.

CVE-2008-5025

Eric Sesterhenn reported a local DoS issue in the hfs filesystem.
Local users who have been granted the privileges necessary to
mount a filesystem would be able to craft a filesystem with a
corrupted catalog name length, resulting in a system oops or
memory corruption.

CVE-2008-5029

Andrea Bittau reported a DoS issue in the unix socket subsystem
that allows a local user to cause memory corruption, resulting in
a kernel panic.

CVE-2008-5134

Johannes Berg reported a remote DoS issue in the libertas wireless
driver, which can be triggered by a specially crafted beacon/probe
response.

CVE-2008-5182

Al Viro reported race conditions in the inotify subsystem that may
allow local users to acquire elevated privileges.

CVE-2008-5300

Dann Frazier reported a DoS condition that allows local users to
cause the out of memory handler to kill off privileged processes
or trigger soft lockups due to a starvation issue in the unix
socket subsystem.

For the stable distribution (etch), these problems have been fixed in
version 2.6.24-6~etchnhalf.7.

We recommend that you upgrade your linux-2.6.24 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201681-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1681-1 (linux-2.6.24)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"linux-doc-2.6.24", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-manual-2.6.24", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-source-2.6.24", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-patch-debian-2.6.24", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-support-2.6.24-etchnhalf.1", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-tree-2.6.24", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-alpha-smp", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-alpha-generic", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-common", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-alpha-generic", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all-alpha", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-alpha-legacy", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-alpha-smp", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-alpha-legacy", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-amd64", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-amd64", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all-amd64", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-ixp4xx", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all-arm", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-footbridge", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-ixp4xx", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-iop32x", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-footbridge", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-iop32x", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-parisc", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-parisc64", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-parisc64-smp", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-parisc64-smp", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-parisc-smp", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-parisc64", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-parisc-smp", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-parisc", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all-hppa", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-686", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-686-bigmem", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-686", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-486", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all-i386", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-486", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-686-bigmem", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-mckinley", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-itanium", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-mckinley", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-itanium", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all-ia64", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-sb1a-bcm91480b", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-sb1-bcm91250a", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-r5k-ip32", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-sb1a-bcm91480b", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-5kc-malta", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-4kc-malta", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-r4k-ip22", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all-mips", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-4kc-malta", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-5kc-malta", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-r5k-ip32", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-r4k-ip22", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-sb1-bcm91250a", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-r5k-cobalt", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all-mipsel", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-r5k-cobalt", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all-powerpc", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-powerpc-miboot", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-powerpc-smp", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-powerpc64", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-powerpc", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-powerpc", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-powerpc-miboot", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-powerpc64", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-powerpc-smp", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-s390x", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-s390", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-s390-tape", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-s390x", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all-s390", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-s390", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-all-sparc", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-sparc64-smp", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.24-etchnhalf.1-sparc64", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-sparc64", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.24-etchnhalf.1-sparc64-smp", ver:"2.6.24-6~etchnhalf.7", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
