###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bpsoft_hex_workshop_detect.nasl 799 2009-01-02 17:52:24Z jan $
#
# BreakPoint Software, Hex Workshop Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800326);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("BreakPoint Software Hex Workshop Version Detection");
  desc = "
  Overview : This script finds the installed Hex Workshop Version and saves the
  version in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of Hex Workshop in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  if("Hex Workshop" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    hwVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(hwVer)
    {
      # Set the Version in KB
      set_kb_item(name:"BPSoft/HexWorkshop/Ver", value:hwVer);
      security_note(data:"BPSoft HexWork shop version " + hwVer + " was" + 
                         " detected on the host");
    }
    exit(0);
  }
}
