###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for libxslt FEDORA-2008-7062
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860430);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-7062");
  script_cve_id("CVE-2008-2935");
  script_name( "Fedora Update for libxslt FEDORA-2008-7062");
  desc = "

  Vulnerability Insight:
  This C library allows to transform XML files into other XML files
  (or HTML, text, ...) using the standard XSLT stylesheet transformation
  mechanism. To use it you need to have a version of libxml2 &gt;= 2.6.27
  installed. The xsltproc command is a command line interface to the XSLT engine


  Affected Software/OS:
  libxslt on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-August/msg00118.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libxslt");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"libxslt", rpm:"libxslt~1.1.24~2.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}