###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Portable File System (PFS) HPSBUX02203
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835135);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "02203");
  script_name( "HP-UX Update for Portable File System (PFS) HPSBUX02203");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified in HP-UX with the 
  Portable File System (PFS). The vulnerability could be exploitedremotely to 
  gain an increase in privilege. 

  Impact:
  Remote increase in privilege.

  Affected Software/OS:
  Portable File System (PFS) on
  HP-UX B.11.00 (obsolete), B.11.11 and B.11.23. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00913684-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Portable File System (PFS)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE-KRN", patch_list:['PHKL_28060', 'PHKL_26450', 'PHCO_26449'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"ProgSupport.C-INC", patch_list:['PHKL_28060', 'PHKL_26450', 'PHCO_26449'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE2-KRN", patch_list:['PHKL_28060', 'PHKL_26450', 'PHCO_26449'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHKL_28060', 'PHKL_26450', 'PHCO_26449'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE-KRN", revision:"S.", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"ProgSupport.C-INC", revision:"S.", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE2-KRN", revision:"S.", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", revision:"S.", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE-KRN", patch_list:['PHKL_28025', 'PHKL_26269', 'PHCO_25841'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"ProgSupport.C-INC", patch_list:['PHKL_28025', 'PHKL_26269', 'PHCO_25841'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE2-KRN", patch_list:['PHKL_28025', 'PHKL_26269', 'PHCO_25841'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHKL_28025', 'PHKL_26269', 'PHCO_25841'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}