###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_qtweb_detect.nasl 4413 2009-09-07 11:03:29Z sep $
#
# QtWeb Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800898);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("QtWeb Version Detection");
  desc = "
  Overview: This script detects the installed version of QtWeb Browser
  and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of QtWeb Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion"))
{
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  qtwebName = registry_get_sz(key:key + item, item:"DisplayName");

  if("QtWeb" >< qtwebName)
  {
    qtwebPath = registry_get_sz(key:key + item, item:"InstallLocation");

    if(!isnull(qtwebPath))
    {
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:qtwebPath);
      qfile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                                                 string:qtwebPath + "\QtWeb.exe");
      qtwebVer = GetVer(file:qfile, share:share);
    }

    if(!isnull(qtwebVer))
    {
      set_kb_item(name:"QtWeb/Ver", value:qtwebVer);         
      security_note(data:"QtWeb version " + qtwebVer + " running at location " 
                        + qtwebPath + " was detected on the host");
    }
  }
}
