###############################################################################
# OpenVAS Vulnerability Test
# $Id: savant_12429.nasl 8288 2010-07-05 10:48:02Z mime $
#
# Savant Web Server Remote Buffer Overflow Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100394);
 script_bugtraq_id(12429);
 script_cve_id("CVE-2005-0338");
 script_version ("1.0-$Revision: 8288 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");

 script_name("Savant Web Server Remote Buffer Overflow Vulnerability");

desc = "Overview:
A remote buffer-overflow vulnerability affects Savant Web Server. This
issue occurs because the application fails to validate the length of
user-supplied strings before copying them into finite process buffers.

A remote attacker may leverage this issue to execute arbitrary code
with the privileges of the affected webserver. This issue may
facilitate unauthorized access or privilege escalation.

References:
http://www.securityfocus.com/bid/12429
http://savant.sourceforge.net/index.html

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Savant Web Server version is 3.1");
 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if(!banner)exit(0);

if("Server: Savant/" >< banner)
 {
   version = eregmatch(pattern: "Savant/([0-9.]+)", string: banner);
   if(isnull(version[1]))exit(0);
   if(version_is_equal(version: version[1], test_version: "3.1")) {
        security_note(port:port);
        exit(0); 
   }
 }

exit(0);

